var __extends =
        (this && this.__extends) ||
        function (e, t) {
            function i() {
                this.constructor = e;
            }
            for (var r in t) t.hasOwnProperty(r) && (e[r] = t[r]);
            (i.prototype = t.prototype), (e.prototype = new i());
        },
    BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, t, i) {
            void 0 === e && (e = 0), void 0 === t && (t = 0), void 0 === i && (i = 0), (this.r = e), (this.g = t), (this.b = i);
        }
        return (
            (t.prototype.toString = function () {
                return "{R: " + this.r + " G:" + this.g + " B:" + this.b + "}";
            }),
            (t.prototype.toArray = function (e, t) {
                return void 0 === t && (t = 0), (e[t] = this.r), (e[t + 1] = this.g), (e[t + 2] = this.b), this;
            }),
            (t.prototype.toColor4 = function (e) {
                return void 0 === e && (e = 1), new i(this.r, this.g, this.b, e);
            }),
            (t.prototype.asArray = function () {
                var e = [];
                return this.toArray(e, 0), e;
            }),
            (t.prototype.toLuminance = function () {
                return 0.3 * this.r + 0.59 * this.g + 0.11 * this.b;
            }),
            (t.prototype.multiply = function (e) {
                return new t(this.r * e.r, this.g * e.g, this.b * e.b);
            }),
            (t.prototype.multiplyToRef = function (e, t) {
                return (t.r = this.r * e.r), (t.g = this.g * e.g), (t.b = this.b * e.b), this;
            }),
            (t.prototype.equals = function (e) {
                return e && this.r === e.r && this.g === e.g && this.b === e.b;
            }),
            (t.prototype.equalsFloats = function (e, t, i) {
                return this.r === e && this.g === t && this.b === i;
            }),
            (t.prototype.scale = function (e) {
                return new t(this.r * e, this.g * e, this.b * e);
            }),
            (t.prototype.scaleToRef = function (e, t) {
                return (t.r = this.r * e), (t.g = this.g * e), (t.b = this.b * e), this;
            }),
            (t.prototype.add = function (e) {
                return new t(this.r + e.r, this.g + e.g, this.b + e.b);
            }),
            (t.prototype.addToRef = function (e, t) {
                return (t.r = this.r + e.r), (t.g = this.g + e.g), (t.b = this.b + e.b), this;
            }),
            (t.prototype.subtract = function (e) {
                return new t(this.r - e.r, this.g - e.g, this.b - e.b);
            }),
            (t.prototype.subtractToRef = function (e, t) {
                return (t.r = this.r - e.r), (t.g = this.g - e.g), (t.b = this.b - e.b), this;
            }),
            (t.prototype.clone = function () {
                return new t(this.r, this.g, this.b);
            }),
            (t.prototype.copyFrom = function (e) {
                return (this.r = e.r), (this.g = e.g), (this.b = e.b), this;
            }),
            (t.prototype.copyFromFloats = function (e, t, i) {
                return (this.r = e), (this.g = t), (this.b = i), this;
            }),
            (t.prototype.toHexString = function () {
                var t = (255 * this.r) | 0,
                    i = (255 * this.g) | 0,
                    r = (255 * this.b) | 0;
                return "#" + e.Tools.ToHex(t) + e.Tools.ToHex(i) + e.Tools.ToHex(r);
            }),
            (t.FromHexString = function (i) {
                if ("#" !== i.substring(0, 1) || 7 !== i.length) return e.Tools.Warn("Color3.FromHexString must be called with a string like #FFFFFF"), new t(0, 0, 0);
                var r = parseInt(i.substring(1, 3), 16),
                    n = parseInt(i.substring(3, 5), 16),
                    o = parseInt(i.substring(5, 7), 16);
                return t.FromInts(r, n, o);
            }),
            (t.FromArray = function (e, i) {
                return void 0 === i && (i = 0), new t(e[i], e[i + 1], e[i + 2]);
            }),
            (t.FromInts = function (e, i, r) {
                return new t(e / 255, i / 255, r / 255);
            }),
            (t.Lerp = function (e, i, r) {
                var n = e.r + (i.r - e.r) * r,
                    o = e.g + (i.g - e.g) * r,
                    s = e.b + (i.b - e.b) * r;
                return new t(n, o, s);
            }),
            (t.Red = function () {
                return new t(1, 0, 0);
            }),
            (t.Green = function () {
                return new t(0, 1, 0);
            }),
            (t.Blue = function () {
                return new t(0, 0, 1);
            }),
            (t.Black = function () {
                return new t(0, 0, 0);
            }),
            (t.White = function () {
                return new t(1, 1, 1);
            }),
            (t.Purple = function () {
                return new t(0.5, 0, 0.5);
            }),
            (t.Magenta = function () {
                return new t(1, 0, 1);
            }),
            (t.Yellow = function () {
                return new t(1, 1, 0);
            }),
            (t.Gray = function () {
                return new t(0.5, 0.5, 0.5);
            }),
            t
        );
    })();
    e.Color3 = t;
    var i = (function () {
        function t(e, t, i, r) {
            (this.r = e), (this.g = t), (this.b = i), (this.a = r);
        }
        return (
            (t.prototype.addInPlace = function (e) {
                return (this.r += e.r), (this.g += e.g), (this.b += e.b), (this.a += e.a), this;
            }),
            (t.prototype.asArray = function () {
                var e = [];
                return this.toArray(e, 0), e;
            }),
            (t.prototype.toArray = function (e, t) {
                return void 0 === t && (t = 0), (e[t] = this.r), (e[t + 1] = this.g), (e[t + 2] = this.b), (e[t + 3] = this.a), this;
            }),
            (t.prototype.add = function (e) {
                return new t(this.r + e.r, this.g + e.g, this.b + e.b, this.a + e.a);
            }),
            (t.prototype.subtract = function (e) {
                return new t(this.r - e.r, this.g - e.g, this.b - e.b, this.a - e.a);
            }),
            (t.prototype.subtractToRef = function (e, t) {
                return (t.r = this.r - e.r), (t.g = this.g - e.g), (t.b = this.b - e.b), (t.a = this.a - e.a), this;
            }),
            (t.prototype.scale = function (e) {
                return new t(this.r * e, this.g * e, this.b * e, this.a * e);
            }),
            (t.prototype.scaleToRef = function (e, t) {
                return (t.r = this.r * e), (t.g = this.g * e), (t.b = this.b * e), (t.a = this.a * e), this;
            }),
            (t.prototype.toString = function () {
                return "{R: " + this.r + " G:" + this.g + " B:" + this.b + " A:" + this.a + "}";
            }),
            (t.prototype.clone = function () {
                return new t(this.r, this.g, this.b, this.a);
            }),
            (t.prototype.copyFrom = function (e) {
                return (this.r = e.r), (this.g = e.g), (this.b = e.b), (this.a = e.a), this;
            }),
            (t.prototype.toHexString = function () {
                var t = (255 * this.r) | 0,
                    i = (255 * this.g) | 0,
                    r = (255 * this.b) | 0,
                    n = (255 * this.a) | 0;
                return "#" + e.Tools.ToHex(t) + e.Tools.ToHex(i) + e.Tools.ToHex(r) + e.Tools.ToHex(n);
            }),
            (t.FromHexString = function (i) {
                if ("#" !== i.substring(0, 1) || 9 !== i.length) return e.Tools.Warn("Color4.FromHexString must be called with a string like #FFFFFFFF"), new t(0, 0, 0, 0);
                var r = parseInt(i.substring(1, 3), 16),
                    n = parseInt(i.substring(3, 5), 16),
                    o = parseInt(i.substring(5, 7), 16),
                    s = parseInt(i.substring(7, 9), 16);
                return t.FromInts(r, n, o, s);
            }),
            (t.Lerp = function (e, i, r) {
                var n = new t(0, 0, 0, 0);
                return t.LerpToRef(e, i, r, n), n;
            }),
            (t.LerpToRef = function (e, t, i, r) {
                (r.r = e.r + (t.r - e.r) * i), (r.g = e.g + (t.g - e.g) * i), (r.b = e.b + (t.b - e.b) * i), (r.a = e.a + (t.a - e.a) * i);
            }),
            (t.FromArray = function (e, i) {
                return void 0 === i && (i = 0), new t(e[i], e[i + 1], e[i + 2], e[i + 3]);
            }),
            (t.FromInts = function (e, i, r, n) {
                return new t(e / 255, i / 255, r / 255, n / 255);
            }),
            t
        );
    })();
    e.Color4 = i;
    var r = (function () {
        function t(e, t) {
            (this.x = e), (this.y = t);
        }
        return (
            (t.prototype.toString = function () {
                return "{X: " + this.x + " Y:" + this.y + "}";
            }),
            (t.prototype.toArray = function (e, t) {
                return void 0 === t && (t = 0), (e[t] = this.x), (e[t + 1] = this.y), this;
            }),
            (t.prototype.asArray = function () {
                var e = [];
                return this.toArray(e, 0), e;
            }),
            (t.prototype.copyFrom = function (e) {
                return (this.x = e.x), (this.y = e.y), this;
            }),
            (t.prototype.copyFromFloats = function (e, t) {
                return (this.x = e), (this.y = t), this;
            }),
            (t.prototype.add = function (e) {
                return new t(this.x + e.x, this.y + e.y);
            }),
            (t.prototype.addVector3 = function (e) {
                return new t(this.x + e.x, this.y + e.y);
            }),
            (t.prototype.subtract = function (e) {
                return new t(this.x - e.x, this.y - e.y);
            }),
            (t.prototype.subtractInPlace = function (e) {
                return (this.x -= e.x), (this.y -= e.y), this;
            }),
            (t.prototype.multiplyInPlace = function (e) {
                return (this.x *= e.x), (this.y *= e.y), this;
            }),
            (t.prototype.multiply = function (e) {
                return new t(this.x * e.x, this.y * e.y);
            }),
            (t.prototype.multiplyToRef = function (e, t) {
                return (t.x = this.x * e.x), (t.y = this.y * e.y), this;
            }),
            (t.prototype.multiplyByFloats = function (e, i) {
                return new t(this.x * e, this.y * i);
            }),
            (t.prototype.divide = function (e) {
                return new t(this.x / e.x, this.y / e.y);
            }),
            (t.prototype.divideToRef = function (e, t) {
                return (t.x = this.x / e.x), (t.y = this.y / e.y), this;
            }),
            (t.prototype.negate = function () {
                return new t(-this.x, -this.y);
            }),
            (t.prototype.scaleInPlace = function (e) {
                return (this.x *= e), (this.y *= e), this;
            }),
            (t.prototype.scale = function (e) {
                return new t(this.x * e, this.y * e);
            }),
            (t.prototype.equals = function (e) {
                return e && this.x === e.x && this.y === e.y;
            }),
            (t.prototype.equalsWithEpsilon = function (t, i) {
                return void 0 === i && (i = e.Engine.Epsilon), t && e.Tools.WithinEpsilon(this.x, t.x, i) && e.Tools.WithinEpsilon(this.y, t.y, i);
            }),
            (t.prototype.length = function () {
                return Math.sqrt(this.x * this.x + this.y * this.y);
            }),
            (t.prototype.lengthSquared = function () {
                return this.x * this.x + this.y * this.y;
            }),
            (t.prototype.normalize = function () {
                var e = this.length();
                if (0 === e) return this;
                var t = 1 / e;
                return (this.x *= t), (this.y *= t), this;
            }),
            (t.prototype.clone = function () {
                return new t(this.x, this.y);
            }),
            (t.Zero = function () {
                return new t(0, 0);
            }),
            (t.FromArray = function (e, i) {
                return void 0 === i && (i = 0), new t(e[i], e[i + 1]);
            }),
            (t.FromArrayToRef = function (e, t, i) {
                (i.x = e[t]), (i.y = e[t + 1]);
            }),
            (t.CatmullRom = function (e, i, r, n, o) {
                var s = o * o,
                    a = o * s,
                    h = 0.5 * (2 * i.x + (-e.x + r.x) * o + (2 * e.x - 5 * i.x + 4 * r.x - n.x) * s + (-e.x + 3 * i.x - 3 * r.x + n.x) * a),
                    l = 0.5 * (2 * i.y + (-e.y + r.y) * o + (2 * e.y - 5 * i.y + 4 * r.y - n.y) * s + (-e.y + 3 * i.y - 3 * r.y + n.y) * a);
                return new t(h, l);
            }),
            (t.Clamp = function (e, i, r) {
                var n = e.x;
                (n = n > r.x ? r.x : n), (n = n < i.x ? i.x : n);
                var o = e.y;
                return (o = o > r.y ? r.y : o), (o = o < i.y ? i.y : o), new t(n, o);
            }),
            (t.Hermite = function (e, i, r, n, o) {
                var s = o * o,
                    a = o * s,
                    h = 2 * a - 3 * s + 1,
                    l = -2 * a + 3 * s,
                    c = a - 2 * s + o,
                    u = a - s,
                    f = e.x * h + r.x * l + i.x * c + n.x * u,
                    d = e.y * h + r.y * l + i.y * c + n.y * u;
                return new t(f, d);
            }),
            (t.Lerp = function (e, i, r) {
                var n = e.x + (i.x - e.x) * r,
                    o = e.y + (i.y - e.y) * r;
                return new t(n, o);
            }),
            (t.Dot = function (e, t) {
                return e.x * t.x + e.y * t.y;
            }),
            (t.Normalize = function (e) {
                var t = e.clone();
                return t.normalize(), t;
            }),
            (t.Minimize = function (e, i) {
                var r = e.x < i.x ? e.x : i.x,
                    n = e.y < i.y ? e.y : i.y;
                return new t(r, n);
            }),
            (t.Maximize = function (e, i) {
                var r = e.x > i.x ? e.x : i.x,
                    n = e.y > i.y ? e.y : i.y;
                return new t(r, n);
            }),
            (t.Transform = function (e, i) {
                var r = e.x * i.m[0] + e.y * i.m[4],
                    n = e.x * i.m[1] + e.y * i.m[5];
                return new t(r, n);
            }),
            (t.Distance = function (e, i) {
                return Math.sqrt(t.DistanceSquared(e, i));
            }),
            (t.DistanceSquared = function (e, t) {
                var i = e.x - t.x,
                    r = e.y - t.y;
                return i * i + r * r;
            }),
            t
        );
    })();
    e.Vector2 = r;
    var n = (function () {
        function t(e, t, i) {
            (this.x = e), (this.y = t), (this.z = i);
        }
        return (
            (t.prototype.toString = function () {
                return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + "}";
            }),
            (t.prototype.asArray = function () {
                var e = [];
                return this.toArray(e, 0), e;
            }),
            (t.prototype.toArray = function (e, t) {
                return void 0 === t && (t = 0), (e[t] = this.x), (e[t + 1] = this.y), (e[t + 2] = this.z), this;
            }),
            (t.prototype.toQuaternion = function () {
                var e = new s(0, 0, 0, 1),
                    t = Math.cos(0.5 * (this.x + this.z)),
                    i = Math.sin(0.5 * (this.x + this.z)),
                    r = Math.cos(0.5 * (this.z - this.x)),
                    n = Math.sin(0.5 * (this.z - this.x)),
                    o = Math.cos(0.5 * this.y),
                    a = Math.sin(0.5 * this.y);
                return (e.x = r * a), (e.y = -n * a), (e.z = i * o), (e.w = t * o), e;
            }),
            (t.prototype.addInPlace = function (e) {
                return (this.x += e.x), (this.y += e.y), (this.z += e.z), this;
            }),
            (t.prototype.add = function (e) {
                return new t(this.x + e.x, this.y + e.y, this.z + e.z);
            }),
            (t.prototype.addToRef = function (e, t) {
                return (t.x = this.x + e.x), (t.y = this.y + e.y), (t.z = this.z + e.z), this;
            }),
            (t.prototype.subtractInPlace = function (e) {
                return (this.x -= e.x), (this.y -= e.y), (this.z -= e.z), this;
            }),
            (t.prototype.subtract = function (e) {
                return new t(this.x - e.x, this.y - e.y, this.z - e.z);
            }),
            (t.prototype.subtractToRef = function (e, t) {
                return (t.x = this.x - e.x), (t.y = this.y - e.y), (t.z = this.z - e.z), this;
            }),
            (t.prototype.subtractFromFloats = function (e, i, r) {
                return new t(this.x - e, this.y - i, this.z - r);
            }),
            (t.prototype.subtractFromFloatsToRef = function (e, t, i, r) {
                return (r.x = this.x - e), (r.y = this.y - t), (r.z = this.z - i), this;
            }),
            (t.prototype.negate = function () {
                return new t(-this.x, -this.y, -this.z);
            }),
            (t.prototype.scaleInPlace = function (e) {
                return (this.x *= e), (this.y *= e), (this.z *= e), this;
            }),
            (t.prototype.scale = function (e) {
                return new t(this.x * e, this.y * e, this.z * e);
            }),
            (t.prototype.scaleToRef = function (e, t) {
                (t.x = this.x * e), (t.y = this.y * e), (t.z = this.z * e);
            }),
            (t.prototype.equals = function (e) {
                return e && this.x === e.x && this.y === e.y && this.z === e.z;
            }),
            (t.prototype.equalsWithEpsilon = function (t, i) {
                return void 0 === i && (i = e.Engine.Epsilon), t && e.Tools.WithinEpsilon(this.x, t.x, i) && e.Tools.WithinEpsilon(this.y, t.y, i) && e.Tools.WithinEpsilon(this.z, t.z, i);
            }),
            (t.prototype.equalsToFloats = function (e, t, i) {
                return this.x === e && this.y === t && this.z === i;
            }),
            (t.prototype.multiplyInPlace = function (e) {
                return (this.x *= e.x), (this.y *= e.y), (this.z *= e.z), this;
            }),
            (t.prototype.multiply = function (e) {
                return new t(this.x * e.x, this.y * e.y, this.z * e.z);
            }),
            (t.prototype.multiplyToRef = function (e, t) {
                return (t.x = this.x * e.x), (t.y = this.y * e.y), (t.z = this.z * e.z), this;
            }),
            (t.prototype.multiplyByFloats = function (e, i, r) {
                return new t(this.x * e, this.y * i, this.z * r);
            }),
            (t.prototype.divide = function (e) {
                return new t(this.x / e.x, this.y / e.y, this.z / e.z);
            }),
            (t.prototype.divideToRef = function (e, t) {
                return (t.x = this.x / e.x), (t.y = this.y / e.y), (t.z = this.z / e.z), this;
            }),
            (t.prototype.MinimizeInPlace = function (e) {
                return e.x < this.x && (this.x = e.x), e.y < this.y && (this.y = e.y), e.z < this.z && (this.z = e.z), this;
            }),
            (t.prototype.MaximizeInPlace = function (e) {
                return e.x > this.x && (this.x = e.x), e.y > this.y && (this.y = e.y), e.z > this.z && (this.z = e.z), this;
            }),
            (t.prototype.length = function () {
                return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            }),
            (t.prototype.lengthSquared = function () {
                return this.x * this.x + this.y * this.y + this.z * this.z;
            }),
            (t.prototype.normalize = function () {
                var e = this.length();
                if (0 === e || 1 === e) return this;
                var t = 1 / e;
                return (this.x *= t), (this.y *= t), (this.z *= t), this;
            }),
            (t.prototype.clone = function () {
                return new t(this.x, this.y, this.z);
            }),
            (t.prototype.copyFrom = function (e) {
                return (this.x = e.x), (this.y = e.y), (this.z = e.z), this;
            }),
            (t.prototype.copyFromFloats = function (e, t, i) {
                return (this.x = e), (this.y = t), (this.z = i), this;
            }),
            (t.GetClipFactor = function (e, i, r, n) {
                var o = t.Dot(e, r) - n,
                    s = t.Dot(i, r) - n,
                    a = o / (o - s);
                return a;
            }),
            (t.FromArray = function (e, i) {
                return i || (i = 0), new t(e[i], e[i + 1], e[i + 2]);
            }),
            (t.FromFloatArray = function (e, i) {
                return i || (i = 0), new t(e[i], e[i + 1], e[i + 2]);
            }),
            (t.FromArrayToRef = function (e, t, i) {
                (i.x = e[t]), (i.y = e[t + 1]), (i.z = e[t + 2]);
            }),
            (t.FromFloatArrayToRef = function (e, t, i) {
                (i.x = e[t]), (i.y = e[t + 1]), (i.z = e[t + 2]);
            }),
            (t.FromFloatsToRef = function (e, t, i, r) {
                (r.x = e), (r.y = t), (r.z = i);
            }),
            (t.Zero = function () {
                return new t(0, 0, 0);
            }),
            (t.Up = function () {
                return new t(0, 1, 0);
            }),
            (t.TransformCoordinates = function (e, i) {
                var r = t.Zero();
                return t.TransformCoordinatesToRef(e, i, r), r;
            }),
            (t.TransformCoordinatesToRef = function (e, t, i) {
                var r = e.x * t.m[0] + e.y * t.m[4] + e.z * t.m[8] + t.m[12],
                    n = e.x * t.m[1] + e.y * t.m[5] + e.z * t.m[9] + t.m[13],
                    o = e.x * t.m[2] + e.y * t.m[6] + e.z * t.m[10] + t.m[14],
                    s = e.x * t.m[3] + e.y * t.m[7] + e.z * t.m[11] + t.m[15];
                (i.x = r / s), (i.y = n / s), (i.z = o / s);
            }),
            (t.TransformCoordinatesFromFloatsToRef = function (e, t, i, r, n) {
                var o = e * r.m[0] + t * r.m[4] + i * r.m[8] + r.m[12],
                    s = e * r.m[1] + t * r.m[5] + i * r.m[9] + r.m[13],
                    a = e * r.m[2] + t * r.m[6] + i * r.m[10] + r.m[14],
                    h = e * r.m[3] + t * r.m[7] + i * r.m[11] + r.m[15];
                (n.x = o / h), (n.y = s / h), (n.z = a / h);
            }),
            (t.TransformCoordinatesToRefSIMD = function (e, t, i) {
                var r = SIMD.float32x4.loadXYZ(e._data, 0),
                    n = SIMD.float32x4.load(t.m, 0),
                    o = SIMD.float32x4.load(t.m, 4),
                    s = SIMD.float32x4.load(t.m, 8),
                    a = SIMD.float32x4.load(t.m, 12),
                    h = SIMD.float32x4.add(
                        SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(r, 0, 0, 0, 0), n), SIMD.float32x4.mul(SIMD.float32x4.swizzle(r, 1, 1, 1, 1), o)),
                        SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(r, 2, 2, 2, 2), s), a)
                    );
                (h = SIMD.float32x4.div(h, SIMD.float32x4.swizzle(h, 3, 3, 3, 3))), SIMD.float32x4.storeXYZ(i._data, 0, h);
            }),
            (t.TransformCoordinatesFromFloatsToRefSIMD = function (e, t, i, r, n) {
                var o = SIMD.float32x4.splat(e),
                    s = SIMD.float32x4.splat(t),
                    a = SIMD.float32x4.splat(i),
                    h = SIMD.float32x4.load(r.m, 0),
                    l = SIMD.float32x4.load(r.m, 4),
                    c = SIMD.float32x4.load(r.m, 8),
                    u = SIMD.float32x4.load(r.m, 12),
                    f = SIMD.float32x4.add(SIMD.float32x4.add(SIMD.float32x4.mul(o, h), SIMD.float32x4.mul(s, l)), SIMD.float32x4.add(SIMD.float32x4.mul(a, c), u));
                (f = SIMD.float32x4.div(f, SIMD.float32x4.swizzle(f, 3, 3, 3, 3))), SIMD.float32x4.storeXYZ(n._data, 0, f);
            }),
            (t.TransformNormal = function (e, i) {
                var r = t.Zero();
                return t.TransformNormalToRef(e, i, r), r;
            }),
            (t.TransformNormalToRef = function (e, t, i) {
                (i.x = e.x * t.m[0] + e.y * t.m[4] + e.z * t.m[8]), (i.y = e.x * t.m[1] + e.y * t.m[5] + e.z * t.m[9]), (i.z = e.x * t.m[2] + e.y * t.m[6] + e.z * t.m[10]);
            }),
            (t.TransformNormalFromFloatsToRef = function (e, t, i, r, n) {
                (n.x = e * r.m[0] + t * r.m[4] + i * r.m[8]), (n.y = e * r.m[1] + t * r.m[5] + i * r.m[9]), (n.z = e * r.m[2] + t * r.m[6] + i * r.m[10]);
            }),
            (t.CatmullRom = function (e, i, r, n, o) {
                var s = o * o,
                    a = o * s,
                    h = 0.5 * (2 * i.x + (-e.x + r.x) * o + (2 * e.x - 5 * i.x + 4 * r.x - n.x) * s + (-e.x + 3 * i.x - 3 * r.x + n.x) * a),
                    l = 0.5 * (2 * i.y + (-e.y + r.y) * o + (2 * e.y - 5 * i.y + 4 * r.y - n.y) * s + (-e.y + 3 * i.y - 3 * r.y + n.y) * a),
                    c = 0.5 * (2 * i.z + (-e.z + r.z) * o + (2 * e.z - 5 * i.z + 4 * r.z - n.z) * s + (-e.z + 3 * i.z - 3 * r.z + n.z) * a);
                return new t(h, l, c);
            }),
            (t.Clamp = function (e, i, r) {
                var n = e.x;
                (n = n > r.x ? r.x : n), (n = n < i.x ? i.x : n);
                var o = e.y;
                (o = o > r.y ? r.y : o), (o = o < i.y ? i.y : o);
                var s = e.z;
                return (s = s > r.z ? r.z : s), (s = s < i.z ? i.z : s), new t(n, o, s);
            }),
            (t.Hermite = function (e, i, r, n, o) {
                var s = o * o,
                    a = o * s,
                    h = 2 * a - 3 * s + 1,
                    l = -2 * a + 3 * s,
                    c = a - 2 * s + o,
                    u = a - s,
                    f = e.x * h + r.x * l + i.x * c + n.x * u,
                    d = e.y * h + r.y * l + i.y * c + n.y * u,
                    p = e.z * h + r.z * l + i.z * c + n.z * u;
                return new t(f, d, p);
            }),
            (t.Lerp = function (e, i, r) {
                var n = e.x + (i.x - e.x) * r,
                    o = e.y + (i.y - e.y) * r,
                    s = e.z + (i.z - e.z) * r;
                return new t(n, o, s);
            }),
            (t.Dot = function (e, t) {
                return e.x * t.x + e.y * t.y + e.z * t.z;
            }),
            (t.Cross = function (e, i) {
                var r = t.Zero();
                return t.CrossToRef(e, i, r), r;
            }),
            (t.CrossToRef = function (e, t, i) {
                (i.x = e.y * t.z - e.z * t.y), (i.y = e.z * t.x - e.x * t.z), (i.z = e.x * t.y - e.y * t.x);
            }),
            (t.Normalize = function (e) {
                var i = t.Zero();
                return t.NormalizeToRef(e, i), i;
            }),
            (t.NormalizeToRef = function (e, t) {
                t.copyFrom(e), t.normalize();
            }),
            (t.Project = function (e, i, r, n) {
                var o = n.width,
                    s = n.height,
                    h = n.x,
                    l = n.y,
                    c = a.FromValues(o / 2, 0, 0, 0, 0, -s / 2, 0, 0, 0, 0, 1, 0, h + o / 2, s / 2 + l, 0, 1),
                    u = i.multiply(r).multiply(c);
                return t.TransformCoordinates(e, u);
            }),
            (t.UnprojectFromTransform = function (i, r, n, o, s) {
                var a = o.multiply(s);
                a.invert(), (i.x = (i.x / r) * 2 - 1), (i.y = -((i.y / n) * 2 - 1));
                var h = t.TransformCoordinates(i, a),
                    l = i.x * a.m[3] + i.y * a.m[7] + i.z * a.m[11] + a.m[15];
                return e.Tools.WithinEpsilon(l, 1) && (h = h.scale(1 / l)), h;
            }),
            (t.Unproject = function (i, r, n, o, s, a) {
                var h = o.multiply(s).multiply(a);
                h.invert();
                var l = new t((i.x / r) * 2 - 1, -((i.y / n) * 2 - 1), i.z),
                    c = t.TransformCoordinates(l, h),
                    u = l.x * h.m[3] + l.y * h.m[7] + l.z * h.m[11] + h.m[15];
                return e.Tools.WithinEpsilon(u, 1) && (c = c.scale(1 / u)), c;
            }),
            (t.Minimize = function (e, t) {
                var i = e.clone();
                return i.MinimizeInPlace(t), i;
            }),
            (t.Maximize = function (e, t) {
                var i = e.clone();
                return i.MaximizeInPlace(t), i;
            }),
            (t.Distance = function (e, i) {
                return Math.sqrt(t.DistanceSquared(e, i));
            }),
            (t.DistanceSquared = function (e, t) {
                var i = e.x - t.x,
                    r = e.y - t.y,
                    n = e.z - t.z;
                return i * i + r * r + n * n;
            }),
            (t.Center = function (e, t) {
                var i = e.add(t);
                return i.scaleInPlace(0.5), i;
            }),
            (t.RotationFromAxis = function (e, i, r) {
                var n = t.Zero();
                return t.RotationFromAxisToRef(e, i, r, n), n;
            }),
            (t.RotationFromAxisToRef = function (i, r, n, o) {
                var s,
                    a,
                    h,
                    l = t.Normalize(i),
                    c = t.Normalize(n),
                    u = f.X,
                    d = f.Y,
                    p = 0,
                    m = 0,
                    g = 0,
                    _ = 0,
                    v = 0,
                    y = 0,
                    x = 0,
                    M = -1,
                    S = 0,
                    b = 0;
                e.Tools.WithinEpsilon(c.z, 0, e.Engine.Epsilon) ? (y = 1) : e.Tools.WithinEpsilon(c.x, 0, e.Engine.Epsilon) ? (_ = 1) : ((x = c.z / c.x), (_ = -x * Math.sqrt(1 / (1 + x * x))), (y = Math.sqrt(1 / (1 + x * x)))),
                    (a = new t(_, v, y)),
                    a.normalize(),
                    (h = t.Cross(c, a)),
                    h.normalize(),
                    (s = t.Cross(l, a)),
                    s.normalize(),
                    t.Dot(c, s) < 0 && (M = 1),
                    (b = t.Dot(l, a)),
                    (b = Math.min(1, Math.max(-1, b))),
                    (g = Math.acos(b) * M),
                    t.Dot(a, u) < 0 && ((g = Math.PI + g), (a = a.scaleInPlace(-1)), (h = h.scaleInPlace(-1)), S++);
                var A, T;
                (_ = 0),
                    (v = 0),
                    (y = 0),
                    (M = -1),
                    e.Tools.WithinEpsilon(c.z, 0, e.Engine.Epsilon) ? (_ = 1) : ((x = a.z / a.x), (_ = -x * Math.sqrt(1 / (1 + x * x))), (y = Math.sqrt(1 / (1 + x * x)))),
                    (A = new t(_, v, y)),
                    A.normalize(),
                    (T = t.Cross(A, a)),
                    T.normalize(),
                    (s = t.Cross(c, A)),
                    s.normalize(),
                    t.Dot(a, s) < 0 && (M = 1),
                    (b = t.Dot(c, A)),
                    (b = Math.min(1, Math.max(-1, b))),
                    (m = Math.acos(b) * M),
                    t.Dot(T, d) < 0 && ((m = Math.PI + m), (T = T.scaleInPlace(-1)), (A = A.scaleInPlace(-1)), S++),
                    (M = -1),
                    (s = t.Cross(u, a)),
                    s.normalize(),
                    t.Dot(s, d) < 0 && (M = 1),
                    (b = t.Dot(a, u)),
                    (b = Math.min(1, Math.max(-1, b))),
                    (p = -Math.acos(b) * M),
                    0 > b && 2 > S && (p = Math.PI + p),
                    (o.x = m),
                    (o.y = p),
                    (o.z = g);
            }),
            t
        );
    })();
    e.Vector3 = n;
    var o = (function () {
        function t(e, t, i, r) {
            (this.x = e), (this.y = t), (this.z = i), (this.w = r);
        }
        return (
            (t.prototype.toString = function () {
                return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + "W:" + this.w + "}";
            }),
            (t.prototype.asArray = function () {
                var e = [];
                return this.toArray(e, 0), e;
            }),
            (t.prototype.toArray = function (e, t) {
                return void 0 === t && (t = 0), (e[t] = this.x), (e[t + 1] = this.y), (e[t + 2] = this.z), (e[t + 3] = this.w), this;
            }),
            (t.prototype.addInPlace = function (e) {
                return (this.x += e.x), (this.y += e.y), (this.z += e.z), (this.w += e.w), this;
            }),
            (t.prototype.add = function (e) {
                return new t(this.x + e.x, this.y + e.y, this.z + e.z, this.w + e.w);
            }),
            (t.prototype.addToRef = function (e, t) {
                return (t.x = this.x + e.x), (t.y = this.y + e.y), (t.z = this.z + e.z), (t.w = this.w + e.w), this;
            }),
            (t.prototype.subtractInPlace = function (e) {
                return (this.x -= e.x), (this.y -= e.y), (this.z -= e.z), (this.w -= e.w), this;
            }),
            (t.prototype.subtract = function (e) {
                return new t(this.x - e.x, this.y - e.y, this.z - e.z, this.w - e.w);
            }),
            (t.prototype.subtractToRef = function (e, t) {
                return (t.x = this.x - e.x), (t.y = this.y - e.y), (t.z = this.z - e.z), (t.w = this.w - e.w), this;
            }),
            (t.prototype.subtractFromFloats = function (e, i, r, n) {
                return new t(this.x - e, this.y - i, this.z - r, this.w - n);
            }),
            (t.prototype.subtractFromFloatsToRef = function (e, t, i, r, n) {
                return (n.x = this.x - e), (n.y = this.y - t), (n.z = this.z - i), (n.w = this.w - r), this;
            }),
            (t.prototype.negate = function () {
                return new t(-this.x, -this.y, -this.z, -this.w);
            }),
            (t.prototype.scaleInPlace = function (e) {
                return (this.x *= e), (this.y *= e), (this.z *= e), (this.w *= e), this;
            }),
            (t.prototype.scale = function (e) {
                return new t(this.x * e, this.y * e, this.z * e, this.w * e);
            }),
            (t.prototype.scaleToRef = function (e, t) {
                (t.x = this.x * e), (t.y = this.y * e), (t.z = this.z * e), (t.w = this.w * e);
            }),
            (t.prototype.equals = function (e) {
                return e && this.x === e.x && this.y === e.y && this.z === e.z && this.w === e.w;
            }),
            (t.prototype.equalsWithEpsilon = function (t, i) {
                return void 0 === i && (i = e.Engine.Epsilon), t && e.Tools.WithinEpsilon(this.x, t.x, i) && e.Tools.WithinEpsilon(this.y, t.y, i) && e.Tools.WithinEpsilon(this.z, t.z, i) && e.Tools.WithinEpsilon(this.w, t.w, i);
            }),
            (t.prototype.equalsToFloats = function (e, t, i, r) {
                return this.x === e && this.y === t && this.z === i && this.w === r;
            }),
            (t.prototype.multiplyInPlace = function (e) {
                return (this.x *= e.x), (this.y *= e.y), (this.z *= e.z), (this.w *= e.w), this;
            }),
            (t.prototype.multiply = function (e) {
                return new t(this.x * e.x, this.y * e.y, this.z * e.z, this.w * e.w);
            }),
            (t.prototype.multiplyToRef = function (e, t) {
                return (t.x = this.x * e.x), (t.y = this.y * e.y), (t.z = this.z * e.z), (t.w = this.w * e.w), this;
            }),
            (t.prototype.multiplyByFloats = function (e, i, r, n) {
                return new t(this.x * e, this.y * i, this.z * r, this.w * n);
            }),
            (t.prototype.divide = function (e) {
                return new t(this.x / e.x, this.y / e.y, this.z / e.z, this.w / e.w);
            }),
            (t.prototype.divideToRef = function (e, t) {
                return (t.x = this.x / e.x), (t.y = this.y / e.y), (t.z = this.z / e.z), (t.w = this.w / e.w), this;
            }),
            (t.prototype.MinimizeInPlace = function (e) {
                return e.x < this.x && (this.x = e.x), e.y < this.y && (this.y = e.y), e.z < this.z && (this.z = e.z), e.w < this.w && (this.w = e.w), this;
            }),
            (t.prototype.MaximizeInPlace = function (e) {
                return e.x > this.x && (this.x = e.x), e.y > this.y && (this.y = e.y), e.z > this.z && (this.z = e.z), e.w > this.w && (this.w = e.w), this;
            }),
            (t.prototype.length = function () {
                return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
            }),
            (t.prototype.lengthSquared = function () {
                return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
            }),
            (t.prototype.normalize = function () {
                var e = this.length();
                if (0 === e) return this;
                var t = 1 / e;
                return (this.x *= t), (this.y *= t), (this.z *= t), (this.w *= t), this;
            }),
            (t.prototype.clone = function () {
                return new t(this.x, this.y, this.z, this.w);
            }),
            (t.prototype.copyFrom = function (e) {
                return (this.x = e.x), (this.y = e.y), (this.z = e.z), (this.w = e.w), this;
            }),
            (t.prototype.copyFromFloats = function (e, t, i, r) {
                return (this.x = e), (this.y = t), (this.z = i), (this.w = r), this;
            }),
            (t.FromArray = function (e, i) {
                return i || (i = 0), new t(e[i], e[i + 1], e[i + 2], e[i + 3]);
            }),
            (t.FromArrayToRef = function (e, t, i) {
                (i.x = e[t]), (i.y = e[t + 1]), (i.z = e[t + 2]), (i.w = e[t + 3]);
            }),
            (t.FromFloatArrayToRef = function (e, t, i) {
                (i.x = e[t]), (i.y = e[t + 1]), (i.z = e[t + 2]), (i.w = e[t + 3]);
            }),
            (t.FromFloatsToRef = function (e, t, i, r, n) {
                (n.x = e), (n.y = t), (n.z = i), (n.w = r);
            }),
            (t.Zero = function () {
                return new t(0, 0, 0, 0);
            }),
            (t.Normalize = function (e) {
                var i = t.Zero();
                return t.NormalizeToRef(e, i), i;
            }),
            (t.NormalizeToRef = function (e, t) {
                t.copyFrom(e), t.normalize();
            }),
            (t.Minimize = function (e, t) {
                var i = e.clone();
                return i.MinimizeInPlace(t), i;
            }),
            (t.Maximize = function (e, t) {
                var i = e.clone();
                return i.MaximizeInPlace(t), i;
            }),
            (t.Distance = function (e, i) {
                return Math.sqrt(t.DistanceSquared(e, i));
            }),
            (t.DistanceSquared = function (e, t) {
                var i = e.x - t.x,
                    r = e.y - t.y,
                    n = e.z - t.z,
                    o = e.w - t.w;
                return i * i + r * r + n * n + o * o;
            }),
            (t.Center = function (e, t) {
                var i = e.add(t);
                return i.scaleInPlace(0.5), i;
            }),
            t
        );
    })();
    e.Vector4 = o;
    var s = (function () {
        function e(e, t, i, r) {
            void 0 === e && (e = 0), void 0 === t && (t = 0), void 0 === i && (i = 0), void 0 === r && (r = 1), (this.x = e), (this.y = t), (this.z = i), (this.w = r);
        }
        return (
            (e.prototype.toString = function () {
                return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + " W:" + this.w + "}";
            }),
            (e.prototype.asArray = function () {
                return [this.x, this.y, this.z, this.w];
            }),
            (e.prototype.equals = function (e) {
                return e && this.x === e.x && this.y === e.y && this.z === e.z && this.w === e.w;
            }),
            (e.prototype.clone = function () {
                return new e(this.x, this.y, this.z, this.w);
            }),
            (e.prototype.copyFrom = function (e) {
                return (this.x = e.x), (this.y = e.y), (this.z = e.z), (this.w = e.w), this;
            }),
            (e.prototype.copyFromFloats = function (e, t, i, r) {
                return (this.x = e), (this.y = t), (this.z = i), (this.w = r), this;
            }),
            (e.prototype.add = function (t) {
                return new e(this.x + t.x, this.y + t.y, this.z + t.z, this.w + t.w);
            }),
            (e.prototype.subtract = function (t) {
                return new e(this.x - t.x, this.y - t.y, this.z - t.z, this.w - t.w);
            }),
            (e.prototype.scale = function (t) {
                return new e(this.x * t, this.y * t, this.z * t, this.w * t);
            }),
            (e.prototype.multiply = function (t) {
                var i = new e(0, 0, 0, 1);
                return this.multiplyToRef(t, i), i;
            }),
            (e.prototype.multiplyToRef = function (e, t) {
                var i = this.x * e.w + this.y * e.z - this.z * e.y + this.w * e.x,
                    r = -this.x * e.z + this.y * e.w + this.z * e.x + this.w * e.y,
                    n = this.x * e.y - this.y * e.x + this.z * e.w + this.w * e.z,
                    o = -this.x * e.x - this.y * e.y - this.z * e.z + this.w * e.w;
                return t.copyFromFloats(i, r, n, o), this;
            }),
            (e.prototype.length = function () {
                return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
            }),
            (e.prototype.normalize = function () {
                var e = 1 / this.length();
                return (this.x *= e), (this.y *= e), (this.z *= e), (this.w *= e), this;
            }),
            (e.prototype.toEulerAngles = function () {
                var e = n.Zero();
                return this.toEulerAnglesToRef(e), e;
            }),
            (e.prototype.toEulerAnglesToRef = function (e) {
                var t = this.x,
                    i = this.y,
                    r = this.z,
                    n = this.w,
                    o = t * i,
                    s = t * r,
                    a = n * i,
                    h = n * r,
                    l = n * t,
                    c = i * r,
                    u = t * t,
                    f = i * i,
                    d = u + f;
                return (
                    0 !== d && 1 !== d
                        ? ((e.x = Math.atan2(s + a, l - c)), (e.y = Math.acos(1 - 2 * d)), (e.z = Math.atan2(s - a, l + c)))
                        : 0 === d
                        ? ((e.x = 0), (e.y = 0), (e.z = Math.atan2(o - h, 0.5 - f - r * r)))
                        : ((e.x = Math.atan2(o - h, 0.5 - f - r * r)), (e.y = Math.PI), (e.z = 0)),
                    this
                );
            }),
            (e.prototype.toRotationMatrix = function (e) {
                var t = this.x * this.x,
                    i = this.y * this.y,
                    r = this.z * this.z,
                    n = this.x * this.y,
                    o = this.z * this.w,
                    s = this.z * this.x,
                    a = this.y * this.w,
                    h = this.y * this.z,
                    l = this.x * this.w;
                return (
                    (e.m[0] = 1 - 2 * (i + r)),
                    (e.m[1] = 2 * (n + o)),
                    (e.m[2] = 2 * (s - a)),
                    (e.m[3] = 0),
                    (e.m[4] = 2 * (n - o)),
                    (e.m[5] = 1 - 2 * (r + t)),
                    (e.m[6] = 2 * (h + l)),
                    (e.m[7] = 0),
                    (e.m[8] = 2 * (s + a)),
                    (e.m[9] = 2 * (h - l)),
                    (e.m[10] = 1 - 2 * (i + t)),
                    (e.m[11] = 0),
                    (e.m[12] = 0),
                    (e.m[13] = 0),
                    (e.m[14] = 0),
                    (e.m[15] = 1),
                    this
                );
            }),
            (e.prototype.fromRotationMatrix = function (t) {
                return e.FromRotationMatrixToRef(t, this), this;
            }),
            (e.FromRotationMatrix = function (t) {
                var i = new e();
                return e.FromRotationMatrixToRef(t, i), i;
            }),
            (e.FromRotationMatrixToRef = function (e, t) {
                var i,
                    r = e.m,
                    n = r[0],
                    o = r[4],
                    s = r[8],
                    a = r[1],
                    h = r[5],
                    l = r[9],
                    c = r[2],
                    u = r[6],
                    f = r[10],
                    d = n + h + f;
                d > 0
                    ? ((i = 0.5 / Math.sqrt(d + 1)), (t.w = 0.25 / i), (t.x = (u - l) * i), (t.y = (s - c) * i), (t.z = (a - o) * i))
                    : n > h && n > f
                    ? ((i = 2 * Math.sqrt(1 + n - h - f)), (t.w = (u - l) / i), (t.x = 0.25 * i), (t.y = (o + a) / i), (t.z = (s + c) / i))
                    : h > f
                    ? ((i = 2 * Math.sqrt(1 + h - n - f)), (t.w = (s - c) / i), (t.x = (o + a) / i), (t.y = 0.25 * i), (t.z = (l + u) / i))
                    : ((i = 2 * Math.sqrt(1 + f - n - h)), (t.w = (a - o) / i), (t.x = (s + c) / i), (t.y = (l + u) / i), (t.z = 0.25 * i));
            }),
            (e.Inverse = function (t) {
                return new e(-t.x, -t.y, -t.z, t.w);
            }),
            (e.Identity = function () {
                return new e(0, 0, 0, 1);
            }),
            (e.RotationAxis = function (t, i) {
                var r = new e(),
                    n = Math.sin(i / 2);
                return t.normalize(), (r.w = Math.cos(i / 2)), (r.x = t.x * n), (r.y = t.y * n), (r.z = t.z * n), r;
            }),
            (e.FromArray = function (t, i) {
                return i || (i = 0), new e(t[i], t[i + 1], t[i + 2], t[i + 3]);
            }),
            (e.RotationYawPitchRoll = function (t, i, r) {
                var n = new e();
                return e.RotationYawPitchRollToRef(t, i, r, n), n;
            }),
            (e.RotationYawPitchRollToRef = function (e, t, i, r) {
                var n = 0.5 * i,
                    o = 0.5 * t,
                    s = 0.5 * e,
                    a = Math.sin(n),
                    h = Math.cos(n),
                    l = Math.sin(o),
                    c = Math.cos(o),
                    u = Math.sin(s),
                    f = Math.cos(s);
                (r.x = f * l * h + u * c * a), (r.y = u * c * h - f * l * a), (r.z = f * c * a - u * l * h), (r.w = f * c * h + u * l * a);
            }),
            (e.RotationAlphaBetaGamma = function (t, i, r) {
                var n = new e();
                return e.RotationAlphaBetaGammaToRef(t, i, r, n), n;
            }),
            (e.RotationAlphaBetaGammaToRef = function (e, t, i, r) {
                var n = 0.5 * (i + e),
                    o = 0.5 * (i - e),
                    s = 0.5 * t;
                (r.x = Math.cos(o) * Math.sin(s)), (r.y = Math.sin(o) * Math.sin(s)), (r.z = Math.sin(n) * Math.cos(s)), (r.w = Math.cos(n) * Math.cos(s));
            }),
            (e.Slerp = function (t, i, r) {
                var n,
                    o,
                    s = r,
                    a = t.x * i.x + t.y * i.y + t.z * i.z + t.w * i.w,
                    h = !1;
                if ((0 > a && ((h = !0), (a = -a)), a > 0.999999)) (o = 1 - s), (n = h ? -s : s);
                else {
                    var l = Math.acos(a),
                        c = 1 / Math.sin(l);
                    (o = Math.sin((1 - s) * l) * c), (n = h ? -Math.sin(s * l) * c : Math.sin(s * l) * c);
                }
                return new e(o * t.x + n * i.x, o * t.y + n * i.y, o * t.z + n * i.z, o * t.w + n * i.w);
            }),
            e
        );
    })();
    e.Quaternion = s;
    var a = (function () {
        function t() {
            this.m = new Float32Array(16);
        }
        return (
            (t.prototype.isIdentity = function () {
                return 1 !== this.m[0] || 1 !== this.m[5] || 1 !== this.m[10] || 1 !== this.m[15]
                    ? !1
                    : 0 !== this.m[1] ||
                      0 !== this.m[2] ||
                      0 !== this.m[3] ||
                      0 !== this.m[4] ||
                      0 !== this.m[6] ||
                      0 !== this.m[7] ||
                      0 !== this.m[8] ||
                      0 !== this.m[9] ||
                      0 !== this.m[11] ||
                      0 !== this.m[12] ||
                      0 !== this.m[13] ||
                      0 !== this.m[14]
                    ? !1
                    : !0;
            }),
            (t.prototype.determinant = function () {
                var e = this.m[10] * this.m[15] - this.m[11] * this.m[14],
                    t = this.m[9] * this.m[15] - this.m[11] * this.m[13],
                    i = this.m[9] * this.m[14] - this.m[10] * this.m[13],
                    r = this.m[8] * this.m[15] - this.m[11] * this.m[12],
                    n = this.m[8] * this.m[14] - this.m[10] * this.m[12],
                    o = this.m[8] * this.m[13] - this.m[9] * this.m[12];
                return (
                    this.m[0] * (this.m[5] * e - this.m[6] * t + this.m[7] * i) -
                    this.m[1] * (this.m[4] * e - this.m[6] * r + this.m[7] * n) +
                    this.m[2] * (this.m[4] * t - this.m[5] * r + this.m[7] * o) -
                    this.m[3] * (this.m[4] * i - this.m[5] * n + this.m[6] * o)
                );
            }),
            (t.prototype.toArray = function () {
                return this.m;
            }),
            (t.prototype.asArray = function () {
                return this.toArray();
            }),
            (t.prototype.invert = function () {
                return this.invertToRef(this), this;
            }),
            (t.prototype.reset = function () {
                for (var e = 0; 16 > e; e++) this.m[e] = 0;
                return this;
            }),
            (t.prototype.add = function (e) {
                var i = new t();
                return this.addToRef(e, i), i;
            }),
            (t.prototype.addToRef = function (e, t) {
                for (var i = 0; 16 > i; i++) t.m[i] = this.m[i] + e.m[i];
                return this;
            }),
            (t.prototype.addToSelf = function (e) {
                for (var t = 0; 16 > t; t++) this.m[t] += e.m[t];
                return this;
            }),
            (t.prototype.invertToRef = function (e) {
                var t = this.m[0],
                    i = this.m[1],
                    r = this.m[2],
                    n = this.m[3],
                    o = this.m[4],
                    s = this.m[5],
                    a = this.m[6],
                    h = this.m[7],
                    l = this.m[8],
                    c = this.m[9],
                    u = this.m[10],
                    f = this.m[11],
                    d = this.m[12],
                    p = this.m[13],
                    m = this.m[14],
                    g = this.m[15],
                    _ = u * g - f * m,
                    v = c * g - f * p,
                    y = c * m - u * p,
                    x = l * g - f * d,
                    M = l * m - u * d,
                    S = l * p - c * d,
                    b = s * _ - a * v + h * y,
                    A = -(o * _ - a * x + h * M),
                    T = o * v - s * x + h * S,
                    E = -(o * y - s * M + a * S),
                    P = 1 / (t * b + i * A + r * T + n * E),
                    D = a * g - h * m,
                    C = s * g - h * p,
                    I = s * m - a * p,
                    w = o * g - h * d,
                    R = o * m - a * d,
                    L = o * p - s * d,
                    O = a * f - h * u,
                    B = s * f - h * c,
                    F = s * u - a * c,
                    V = o * f - h * l,
                    N = o * u - a * l,
                    z = o * c - s * l;
                return (
                    (e.m[0] = b * P),
                    (e.m[4] = A * P),
                    (e.m[8] = T * P),
                    (e.m[12] = E * P),
                    (e.m[1] = -(i * _ - r * v + n * y) * P),
                    (e.m[5] = (t * _ - r * x + n * M) * P),
                    (e.m[9] = -(t * v - i * x + n * S) * P),
                    (e.m[13] = (t * y - i * M + r * S) * P),
                    (e.m[2] = (i * D - r * C + n * I) * P),
                    (e.m[6] = -(t * D - r * w + n * R) * P),
                    (e.m[10] = (t * C - i * w + n * L) * P),
                    (e.m[14] = -(t * I - i * R + r * L) * P),
                    (e.m[3] = -(i * O - r * B + n * F) * P),
                    (e.m[7] = (t * O - r * V + n * N) * P),
                    (e.m[11] = -(t * B - i * V + n * z) * P),
                    (e.m[15] = (t * F - i * N + r * z) * P),
                    this
                );
            }),
            (t.prototype.invertToRefSIMD = function (e) {
                var t,
                    i,
                    r,
                    n,
                    o,
                    s,
                    a,
                    h,
                    l,
                    c,
                    u = this.m,
                    f = e.m,
                    d = SIMD.float32x4.load(u, 0),
                    p = SIMD.float32x4.load(u, 4),
                    m = SIMD.float32x4.load(u, 8),
                    g = SIMD.float32x4.load(u, 12);
                return (
                    (o = SIMD.float32x4.shuffle(d, p, 0, 1, 4, 5)),
                    (i = SIMD.float32x4.shuffle(m, g, 0, 1, 4, 5)),
                    (t = SIMD.float32x4.shuffle(o, i, 0, 2, 4, 6)),
                    (i = SIMD.float32x4.shuffle(i, o, 1, 3, 5, 7)),
                    (o = SIMD.float32x4.shuffle(d, p, 2, 3, 6, 7)),
                    (n = SIMD.float32x4.shuffle(m, g, 2, 3, 6, 7)),
                    (r = SIMD.float32x4.shuffle(o, n, 0, 2, 4, 6)),
                    (n = SIMD.float32x4.shuffle(n, o, 1, 3, 5, 7)),
                    (o = SIMD.float32x4.mul(r, n)),
                    (o = SIMD.float32x4.swizzle(o, 1, 0, 3, 2)),
                    (s = SIMD.float32x4.mul(i, o)),
                    (a = SIMD.float32x4.mul(t, o)),
                    (o = SIMD.float32x4.swizzle(o, 2, 3, 0, 1)),
                    (s = SIMD.float32x4.sub(SIMD.float32x4.mul(i, o), s)),
                    (a = SIMD.float32x4.sub(SIMD.float32x4.mul(t, o), a)),
                    (a = SIMD.float32x4.swizzle(a, 2, 3, 0, 1)),
                    (o = SIMD.float32x4.mul(i, r)),
                    (o = SIMD.float32x4.swizzle(o, 1, 0, 3, 2)),
                    (s = SIMD.float32x4.add(SIMD.float32x4.mul(n, o), s)),
                    (l = SIMD.float32x4.mul(t, o)),
                    (o = SIMD.float32x4.swizzle(o, 2, 3, 0, 1)),
                    (s = SIMD.float32x4.sub(s, SIMD.float32x4.mul(n, o))),
                    (l = SIMD.float32x4.sub(SIMD.float32x4.mul(t, o), l)),
                    (l = SIMD.float32x4.swizzle(l, 2, 3, 0, 1)),
                    (o = SIMD.float32x4.mul(SIMD.float32x4.swizzle(i, 2, 3, 0, 1), n)),
                    (o = SIMD.float32x4.swizzle(o, 1, 0, 3, 2)),
                    (r = SIMD.float32x4.swizzle(r, 2, 3, 0, 1)),
                    (s = SIMD.float32x4.add(SIMD.float32x4.mul(r, o), s)),
                    (h = SIMD.float32x4.mul(t, o)),
                    (o = SIMD.float32x4.swizzle(o, 2, 3, 0, 1)),
                    (s = SIMD.float32x4.sub(s, SIMD.float32x4.mul(r, o))),
                    (h = SIMD.float32x4.sub(SIMD.float32x4.mul(t, o), h)),
                    (h = SIMD.float32x4.swizzle(h, 2, 3, 0, 1)),
                    (o = SIMD.float32x4.mul(t, i)),
                    (o = SIMD.float32x4.swizzle(o, 1, 0, 3, 2)),
                    (h = SIMD.float32x4.add(SIMD.float32x4.mul(n, o), h)),
                    (l = SIMD.float32x4.sub(SIMD.float32x4.mul(r, o), l)),
                    (o = SIMD.float32x4.swizzle(o, 2, 3, 0, 1)),
                    (h = SIMD.float32x4.sub(SIMD.float32x4.mul(n, o), h)),
                    (l = SIMD.float32x4.sub(l, SIMD.float32x4.mul(r, o))),
                    (o = SIMD.float32x4.mul(t, n)),
                    (o = SIMD.float32x4.swizzle(o, 1, 0, 3, 2)),
                    (a = SIMD.float32x4.sub(a, SIMD.float32x4.mul(r, o))),
                    (h = SIMD.float32x4.add(SIMD.float32x4.mul(i, o), h)),
                    (o = SIMD.float32x4.swizzle(o, 2, 3, 0, 1)),
                    (a = SIMD.float32x4.add(SIMD.float32x4.mul(r, o), a)),
                    (h = SIMD.float32x4.sub(h, SIMD.float32x4.mul(i, o))),
                    (o = SIMD.float32x4.mul(t, r)),
                    (o = SIMD.float32x4.swizzle(o, 1, 0, 3, 2)),
                    (a = SIMD.float32x4.add(SIMD.float32x4.mul(n, o), a)),
                    (l = SIMD.float32x4.sub(l, SIMD.float32x4.mul(i, o))),
                    (o = SIMD.float32x4.swizzle(o, 2, 3, 0, 1)),
                    (a = SIMD.float32x4.sub(a, SIMD.float32x4.mul(n, o))),
                    (l = SIMD.float32x4.add(SIMD.float32x4.mul(i, o), l)),
                    (c = SIMD.float32x4.mul(t, s)),
                    (c = SIMD.float32x4.add(SIMD.float32x4.swizzle(c, 2, 3, 0, 1), c)),
                    (c = SIMD.float32x4.add(SIMD.float32x4.swizzle(c, 1, 0, 3, 2), c)),
                    (o = SIMD.float32x4.reciprocalApproximation(c)),
                    (c = SIMD.float32x4.sub(SIMD.float32x4.add(o, o), SIMD.float32x4.mul(c, SIMD.float32x4.mul(o, o)))),
                    (c = SIMD.float32x4.swizzle(c, 0, 0, 0, 0)),
                    (s = SIMD.float32x4.mul(c, s)),
                    (a = SIMD.float32x4.mul(c, a)),
                    (h = SIMD.float32x4.mul(c, h)),
                    (l = SIMD.float32x4.mul(c, l)),
                    SIMD.float32x4.store(f, 0, s),
                    SIMD.float32x4.store(f, 4, a),
                    SIMD.float32x4.store(f, 8, h),
                    SIMD.float32x4.store(f, 12, l),
                    this
                );
            }),
            (t.prototype.setTranslation = function (e) {
                return (this.m[12] = e.x), (this.m[13] = e.y), (this.m[14] = e.z), this;
            }),
            (t.prototype.multiply = function (e) {
                var i = new t();
                return this.multiplyToRef(e, i), i;
            }),
            (t.prototype.copyFrom = function (e) {
                for (var t = 0; 16 > t; t++) this.m[t] = e.m[t];
                return this;
            }),
            (t.prototype.copyToArray = function (e, t) {
                void 0 === t && (t = 0);
                for (var i = 0; 16 > i; i++) e[t + i] = this.m[i];
                return this;
            }),
            (t.prototype.multiplyToRef = function (e, t) {
                return this.multiplyToArray(e, t.m, 0), this;
            }),
            (t.prototype.multiplyToArray = function (e, t, i) {
                var r = this.m[0],
                    n = this.m[1],
                    o = this.m[2],
                    s = this.m[3],
                    a = this.m[4],
                    h = this.m[5],
                    l = this.m[6],
                    c = this.m[7],
                    u = this.m[8],
                    f = this.m[9],
                    d = this.m[10],
                    p = this.m[11],
                    m = this.m[12],
                    g = this.m[13],
                    _ = this.m[14],
                    v = this.m[15],
                    y = e.m[0],
                    x = e.m[1],
                    M = e.m[2],
                    S = e.m[3],
                    b = e.m[4],
                    A = e.m[5],
                    T = e.m[6],
                    E = e.m[7],
                    P = e.m[8],
                    D = e.m[9],
                    C = e.m[10],
                    I = e.m[11],
                    w = e.m[12],
                    R = e.m[13],
                    L = e.m[14],
                    O = e.m[15];
                return (
                    (t[i] = r * y + n * b + o * P + s * w),
                    (t[i + 1] = r * x + n * A + o * D + s * R),
                    (t[i + 2] = r * M + n * T + o * C + s * L),
                    (t[i + 3] = r * S + n * E + o * I + s * O),
                    (t[i + 4] = a * y + h * b + l * P + c * w),
                    (t[i + 5] = a * x + h * A + l * D + c * R),
                    (t[i + 6] = a * M + h * T + l * C + c * L),
                    (t[i + 7] = a * S + h * E + l * I + c * O),
                    (t[i + 8] = u * y + f * b + d * P + p * w),
                    (t[i + 9] = u * x + f * A + d * D + p * R),
                    (t[i + 10] = u * M + f * T + d * C + p * L),
                    (t[i + 11] = u * S + f * E + d * I + p * O),
                    (t[i + 12] = m * y + g * b + _ * P + v * w),
                    (t[i + 13] = m * x + g * A + _ * D + v * R),
                    (t[i + 14] = m * M + g * T + _ * C + v * L),
                    (t[i + 15] = m * S + g * E + _ * I + v * O),
                    this
                );
            }),
            (t.prototype.multiplyToArraySIMD = function (e, t, i) {
                void 0 === i && (i = 0);
                var r = this.m,
                    n = e.m,
                    o = SIMD.float32x4.load(n, 0),
                    s = SIMD.float32x4.load(n, 4),
                    a = SIMD.float32x4.load(n, 8),
                    h = SIMD.float32x4.load(n, 12),
                    l = SIMD.float32x4.load(r, 0);

                SIMD.float32x4.store(
                    t,
                    i + 0,
                    SIMD.float32x4.add(
                        SIMD.float32x4.mul(SIMD.float32x4.swizzle(l, 0, 0, 0, 0), o),
                        SIMD.float32x4.add(
                            SIMD.float32x4.mul(SIMD.float32x4.swizzle(l, 1, 1, 1, 1), s),
                            SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(l, 2, 2, 2, 2), a), SIMD.float32x4.mul(SIMD.float32x4.swizzle(l, 3, 3, 3, 3), h))
                        )
                    )
                );
                var c = SIMD.float32x4.load(r, 4);
                SIMD.float32x4.store(
                    t,
                    i + 4,
                    SIMD.float32x4.add(
                        SIMD.float32x4.mul(SIMD.float32x4.swizzle(c, 0, 0, 0, 0), o),
                        SIMD.float32x4.add(
                            SIMD.float32x4.mul(SIMD.float32x4.swizzle(c, 1, 1, 1, 1), s),
                            SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(c, 2, 2, 2, 2), a), SIMD.float32x4.mul(SIMD.float32x4.swizzle(c, 3, 3, 3, 3), h))
                        )
                    )
                );
                var u = SIMD.float32x4.load(r, 8);
                SIMD.float32x4.store(
                    t,
                    i + 8,
                    SIMD.float32x4.add(
                        SIMD.float32x4.mul(SIMD.float32x4.swizzle(u, 0, 0, 0, 0), o),
                        SIMD.float32x4.add(
                            SIMD.float32x4.mul(SIMD.float32x4.swizzle(u, 1, 1, 1, 1), s),
                            SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(u, 2, 2, 2, 2), a), SIMD.float32x4.mul(SIMD.float32x4.swizzle(u, 3, 3, 3, 3), h))
                        )
                    )
                );
                var f = SIMD.float32x4.load(r, 12);
                SIMD.float32x4.store(
                    t,
                    i + 12,
                    SIMD.float32x4.add(
                        SIMD.float32x4.mul(SIMD.float32x4.swizzle(f, 0, 0, 0, 0), o),
                        SIMD.float32x4.add(
                            SIMD.float32x4.mul(SIMD.float32x4.swizzle(f, 1, 1, 1, 1), s),
                            SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(f, 2, 2, 2, 2), a), SIMD.float32x4.mul(SIMD.float32x4.swizzle(f, 3, 3, 3, 3), h))
                        )
                    )
                );
            }),
            (t.prototype.equals = function (e) {
                return (
                    e &&
                    this.m[0] === e.m[0] &&
                    this.m[1] === e.m[1] &&
                    this.m[2] === e.m[2] &&
                    this.m[3] === e.m[3] &&
                    this.m[4] === e.m[4] &&
                    this.m[5] === e.m[5] &&
                    this.m[6] === e.m[6] &&
                    this.m[7] === e.m[7] &&
                    this.m[8] === e.m[8] &&
                    this.m[9] === e.m[9] &&
                    this.m[10] === e.m[10] &&
                    this.m[11] === e.m[11] &&
                    this.m[12] === e.m[12] &&
                    this.m[13] === e.m[13] &&
                    this.m[14] === e.m[14] &&
                    this.m[15] === e.m[15]
                );
            }),
            (t.prototype.clone = function () {
                return t.FromValues(this.m[0], this.m[1], this.m[2], this.m[3], this.m[4], this.m[5], this.m[6], this.m[7], this.m[8], this.m[9], this.m[10], this.m[11], this.m[12], this.m[13], this.m[14], this.m[15]);
            }),
            (t.prototype.decompose = function (i, r, n) {
                (n.x = this.m[12]), (n.y = this.m[13]), (n.z = this.m[14]);
                var o = e.Tools.Sign(this.m[0] * this.m[1] * this.m[2] * this.m[3]) < 0 ? -1 : 1,
                    a = e.Tools.Sign(this.m[4] * this.m[5] * this.m[6] * this.m[7]) < 0 ? -1 : 1,
                    h = e.Tools.Sign(this.m[8] * this.m[9] * this.m[10] * this.m[11]) < 0 ? -1 : 1;
                if (
                    ((i.x = o * Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1] + this.m[2] * this.m[2])),
                    (i.y = a * Math.sqrt(this.m[4] * this.m[4] + this.m[5] * this.m[5] + this.m[6] * this.m[6])),
                    (i.z = h * Math.sqrt(this.m[8] * this.m[8] + this.m[9] * this.m[9] + this.m[10] * this.m[10])),
                    0 === i.x || 0 === i.y || 0 === i.z)
                )
                    return (r.x = 0), (r.y = 0), (r.z = 0), (r.w = 1), !1;
                var l = t.FromValues(this.m[0] / i.x, this.m[1] / i.x, this.m[2] / i.x, 0, this.m[4] / i.y, this.m[5] / i.y, this.m[6] / i.y, 0, this.m[8] / i.z, this.m[9] / i.z, this.m[10] / i.z, 0, 0, 0, 0, 1);
                return s.FromRotationMatrixToRef(l, r), !0;
            }),
            (t.FromArray = function (e, i) {
                var r = new t();
                return i || (i = 0), t.FromArrayToRef(e, i, r), r;
            }),
            (t.FromArrayToRef = function (e, t, i) {
                for (var r = 0; 16 > r; r++) i.m[r] = e[r + t];
            }),
            (t.FromFloat32ArrayToRefScaled = function (e, t, i, r) {
                for (var n = 0; 16 > n; n++) r.m[n] = e[n + t] * i;
            }),
            (t.FromValuesToRef = function (e, t, i, r, n, o, s, a, h, l, c, u, f, d, p, m, g) {
                (g.m[0] = e),
                    (g.m[1] = t),
                    (g.m[2] = i),
                    (g.m[3] = r),
                    (g.m[4] = n),
                    (g.m[5] = o),
                    (g.m[6] = s),
                    (g.m[7] = a),
                    (g.m[8] = h),
                    (g.m[9] = l),
                    (g.m[10] = c),
                    (g.m[11] = u),
                    (g.m[12] = f),
                    (g.m[13] = d),
                    (g.m[14] = p),
                    (g.m[15] = m);
            }),
            (t.FromValues = function (e, i, r, n, o, s, a, h, l, c, u, f, d, p, m, g) {
                var _ = new t();
                return (
                    (_.m[0] = e),
                    (_.m[1] = i),
                    (_.m[2] = r),
                    (_.m[3] = n),
                    (_.m[4] = o),
                    (_.m[5] = s),
                    (_.m[6] = a),
                    (_.m[7] = h),
                    (_.m[8] = l),
                    (_.m[9] = c),
                    (_.m[10] = u),
                    (_.m[11] = f),
                    (_.m[12] = d),
                    (_.m[13] = p),
                    (_.m[14] = m),
                    (_.m[15] = g),
                    _
                );
            }),
            (t.Compose = function (e, i, r) {
                var n = t.FromValues(e.x, 0, 0, 0, 0, e.y, 0, 0, 0, 0, e.z, 0, 0, 0, 0, 1),
                    o = t.Identity();
                return i.toRotationMatrix(o), (n = n.multiply(o)), n.setTranslation(r), n;
            }),
            (t.Identity = function () {
                return t.FromValues(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
            }),
            (t.IdentityToRef = function (e) {
                t.FromValuesToRef(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, e);
            }),
            (t.Zero = function () {
                return t.FromValues(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            }),
            (t.RotationX = function (e) {
                var i = new t();
                return t.RotationXToRef(e, i), i;
            }),
            (t.Invert = function (e) {
                var i = new t();
                return e.invertToRef(i), i;
            }),
            (t.RotationXToRef = function (e, t) {
                var i = Math.sin(e),
                    r = Math.cos(e);
                (t.m[0] = 1),
                    (t.m[15] = 1),
                    (t.m[5] = r),
                    (t.m[10] = r),
                    (t.m[9] = -i),
                    (t.m[6] = i),
                    (t.m[1] = 0),
                    (t.m[2] = 0),
                    (t.m[3] = 0),
                    (t.m[4] = 0),
                    (t.m[7] = 0),
                    (t.m[8] = 0),
                    (t.m[11] = 0),
                    (t.m[12] = 0),
                    (t.m[13] = 0),
                    (t.m[14] = 0);
            }),
            (t.RotationY = function (e) {
                var i = new t();
                return t.RotationYToRef(e, i), i;
            }),
            (t.RotationYToRef = function (e, t) {
                var i = Math.sin(e),
                    r = Math.cos(e);
                (t.m[5] = 1),
                    (t.m[15] = 1),
                    (t.m[0] = r),
                    (t.m[2] = -i),
                    (t.m[8] = i),
                    (t.m[10] = r),
                    (t.m[1] = 0),
                    (t.m[3] = 0),
                    (t.m[4] = 0),
                    (t.m[6] = 0),
                    (t.m[7] = 0),
                    (t.m[9] = 0),
                    (t.m[11] = 0),
                    (t.m[12] = 0),
                    (t.m[13] = 0),
                    (t.m[14] = 0);
            }),
            (t.RotationZ = function (e) {
                var i = new t();
                return t.RotationZToRef(e, i), i;
            }),
            (t.RotationZToRef = function (e, t) {
                var i = Math.sin(e),
                    r = Math.cos(e);
                (t.m[10] = 1),
                    (t.m[15] = 1),
                    (t.m[0] = r),
                    (t.m[1] = i),
                    (t.m[4] = -i),
                    (t.m[5] = r),
                    (t.m[2] = 0),
                    (t.m[3] = 0),
                    (t.m[6] = 0),
                    (t.m[7] = 0),
                    (t.m[8] = 0),
                    (t.m[9] = 0),
                    (t.m[11] = 0),
                    (t.m[12] = 0),
                    (t.m[13] = 0),
                    (t.m[14] = 0);
            }),
            (t.RotationAxis = function (e, i) {
                var r = Math.sin(-i),
                    n = Math.cos(-i),
                    o = 1 - n;
                e.normalize();
                var s = t.Zero();
                return (
                    (s.m[0] = e.x * e.x * o + n),
                    (s.m[1] = e.x * e.y * o - e.z * r),
                    (s.m[2] = e.x * e.z * o + e.y * r),
                    (s.m[3] = 0),
                    (s.m[4] = e.y * e.x * o + e.z * r),
                    (s.m[5] = e.y * e.y * o + n),
                    (s.m[6] = e.y * e.z * o - e.x * r),
                    (s.m[7] = 0),
                    (s.m[8] = e.z * e.x * o - e.y * r),
                    (s.m[9] = e.z * e.y * o + e.x * r),
                    (s.m[10] = e.z * e.z * o + n),
                    (s.m[11] = 0),
                    (s.m[15] = 1),
                    s
                );
            }),
            (t.RotationYawPitchRoll = function (e, i, r) {
                var n = new t();
                return t.RotationYawPitchRollToRef(e, i, r, n), n;
            }),
            (t.RotationYawPitchRollToRef = function (e, t, i, r) {
                s.RotationYawPitchRollToRef(e, t, i, this._tempQuaternion), this._tempQuaternion.toRotationMatrix(r);
            }),
            (t.Scaling = function (e, i, r) {
                var n = t.Zero();
                return t.ScalingToRef(e, i, r, n), n;
            }),
            (t.ScalingToRef = function (e, t, i, r) {
                (r.m[0] = e),
                    (r.m[1] = 0),
                    (r.m[2] = 0),
                    (r.m[3] = 0),
                    (r.m[4] = 0),
                    (r.m[5] = t),
                    (r.m[6] = 0),
                    (r.m[7] = 0),
                    (r.m[8] = 0),
                    (r.m[9] = 0),
                    (r.m[10] = i),
                    (r.m[11] = 0),
                    (r.m[12] = 0),
                    (r.m[13] = 0),
                    (r.m[14] = 0),
                    (r.m[15] = 1);
            }),
            (t.Translation = function (e, i, r) {
                var n = t.Identity();
                return t.TranslationToRef(e, i, r, n), n;
            }),
            (t.TranslationToRef = function (e, i, r, n) {
                t.FromValuesToRef(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, e, i, r, 1, n);
            }),
            (t.LookAtLH = function (e, i, r) {
                var n = t.Zero();
                return t.LookAtLHToRef(e, i, r, n), n;
            }),
            (t.LookAtLHToRef = function (e, i, r, o) {
                i.subtractToRef(e, this._zAxis),
                    this._zAxis.normalize(),
                    n.CrossToRef(r, this._zAxis, this._xAxis),
                    0 === this._xAxis.lengthSquared() ? (this._xAxis.x = 1) : this._xAxis.normalize(),
                    n.CrossToRef(this._zAxis, this._xAxis, this._yAxis),
                    this._yAxis.normalize();
                var s = -n.Dot(this._xAxis, e),
                    a = -n.Dot(this._yAxis, e),
                    h = -n.Dot(this._zAxis, e);
                return t.FromValuesToRef(this._xAxis.x, this._yAxis.x, this._zAxis.x, 0, this._xAxis.y, this._yAxis.y, this._zAxis.y, 0, this._xAxis.z, this._yAxis.z, this._zAxis.z, 0, s, a, h, 1, o);
            }),
            (t.LookAtLHToRefSIMD = function (e, t, i, r) {
                var n = r.m,
                    o = SIMD.float32x4(t.x, t.y, t.z, 0),
                    s = SIMD.float32x4(e.x, e.y, e.z, 0),
                    a = SIMD.float32x4(i.x, i.y, i.z, 0),
                    h = SIMD.float32x4.sub(o, s),
                    l = SIMD.float32x4.mul(h, h);
                (l = SIMD.float32x4.add(l, SIMD.float32x4.add(SIMD.float32x4.swizzle(l, 1, 2, 0, 3), SIMD.float32x4.swizzle(l, 2, 0, 1, 3)))),
                    (h = SIMD.float32x4.mul(h, SIMD.float32x4.reciprocalSqrtApproximation(l))),
                    (l = SIMD.float32x4.mul(a, a)),
                    (l = SIMD.float32x4.add(l, SIMD.float32x4.add(SIMD.float32x4.swizzle(l, 1, 2, 0, 3), SIMD.float32x4.swizzle(l, 2, 0, 1, 3)))),
                    (a = SIMD.float32x4.mul(a, SIMD.float32x4.reciprocalSqrtApproximation(l)));
                var c = SIMD.float32x4.sub(SIMD.float32x4.mul(SIMD.float32x4.swizzle(h, 1, 2, 0, 3), SIMD.float32x4.swizzle(a, 2, 0, 1, 3)), SIMD.float32x4.mul(SIMD.float32x4.swizzle(h, 2, 0, 1, 3), SIMD.float32x4.swizzle(a, 1, 2, 0, 3)));
                (l = SIMD.float32x4.mul(c, c)),
                    (l = SIMD.float32x4.add(l, SIMD.float32x4.add(SIMD.float32x4.swizzle(l, 1, 2, 0, 3), SIMD.float32x4.swizzle(l, 2, 0, 1, 3)))),
                    (c = SIMD.float32x4.mul(c, SIMD.float32x4.reciprocalSqrtApproximation(l)));
                var u = SIMD.float32x4.sub(SIMD.float32x4.mul(SIMD.float32x4.swizzle(c, 1, 2, 0, 3), SIMD.float32x4.swizzle(h, 2, 0, 1, 3)), SIMD.float32x4.mul(SIMD.float32x4.swizzle(c, 2, 0, 1, 3), SIMD.float32x4.swizzle(h, 1, 2, 0, 3)));
                (l = SIMD.float32x4.mul(c, c)),
                    (l = SIMD.float32x4.add(l, SIMD.float32x4.add(SIMD.float32x4.swizzle(l, 1, 2, 0, 3), SIMD.float32x4.swizzle(l, 2, 0, 1, 3)))),
                    (c = SIMD.float32x4.mul(c, SIMD.float32x4.reciprocalSqrtApproximation(l)));
                var f = SIMD.float32x4.splat(0);
                c = SIMD.float32x4.neg(c);
                var d = SIMD.float32x4.shuffle(c, u, 0, 1, 4, 5),
                    p = SIMD.float32x4.shuffle(h, f, 0, 1, 4, 5),
                    m = SIMD.float32x4.shuffle(d, p, 0, 2, 4, 6),
                    g = SIMD.float32x4.shuffle(d, p, 1, 3, 5, 7);
                (d = SIMD.float32x4.shuffle(c, u, 2, 3, 6, 7)), (p = SIMD.float32x4.shuffle(h, f, 2, 3, 6, 7));
                var _ = SIMD.float32x4.shuffle(d, p, 0, 2, 4, 6),
                    v = SIMD.float32x4(0, 0, 0, 1),
                    y = SIMD.float32x4(1, 0, 0, 0),
                    x = SIMD.float32x4(0, 1, 0, 0),
                    M = SIMD.float32x4(0, 0, 1, 0),
                    S = SIMD.float32x4.neg(s);
                (S = SIMD.float32x4.withW(S, 1)),
                    SIMD.float32x4.store(
                        n,
                        0,
                        SIMD.float32x4.add(
                            SIMD.float32x4.mul(SIMD.float32x4.swizzle(y, 0, 0, 0, 0), m),
                            SIMD.float32x4.add(
                                SIMD.float32x4.mul(SIMD.float32x4.swizzle(y, 1, 1, 1, 1), g),
                                SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(y, 2, 2, 2, 2), _), SIMD.float32x4.mul(SIMD.float32x4.swizzle(y, 3, 3, 3, 3), v))
                            )
                        )
                    ),
                    SIMD.float32x4.store(
                        n,
                        4,
                        SIMD.float32x4.add(
                            SIMD.float32x4.mul(SIMD.float32x4.swizzle(x, 0, 0, 0, 0), m),
                            SIMD.float32x4.add(
                                SIMD.float32x4.mul(SIMD.float32x4.swizzle(x, 1, 1, 1, 1), g),
                                SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(x, 2, 2, 2, 2), _), SIMD.float32x4.mul(SIMD.float32x4.swizzle(x, 3, 3, 3, 3), v))
                            )
                        )
                    ),
                    SIMD.float32x4.store(
                        n,
                        8,
                        SIMD.float32x4.add(
                            SIMD.float32x4.mul(SIMD.float32x4.swizzle(M, 0, 0, 0, 0), m),
                            SIMD.float32x4.add(
                                SIMD.float32x4.mul(SIMD.float32x4.swizzle(M, 1, 1, 1, 1), g),
                                SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(M, 2, 2, 2, 2), _), SIMD.float32x4.mul(SIMD.float32x4.swizzle(M, 3, 3, 3, 3), v))
                            )
                        )
                    ),
                    SIMD.float32x4.store(
                        n,
                        12,
                        SIMD.float32x4.add(
                            SIMD.float32x4.mul(SIMD.float32x4.swizzle(S, 0, 0, 0, 0), m),
                            SIMD.float32x4.add(
                                SIMD.float32x4.mul(SIMD.float32x4.swizzle(S, 1, 1, 1, 1), g),
                                SIMD.float32x4.add(SIMD.float32x4.mul(SIMD.float32x4.swizzle(S, 2, 2, 2, 2), _), SIMD.float32x4.mul(SIMD.float32x4.swizzle(S, 3, 3, 3, 3), v))
                            )
                        )
                    );
            }),
            (t.OrthoLH = function (e, i, r, n) {
                var o = t.Zero();
                return t.OrthoLHToRef(e, i, r, n, o), o;
            }),
            (t.OrthoLHToRef = function (e, i, r, n, o) {
                var s = 2 / e,
                    a = 2 / i,
                    h = 1 / (n - r),
                    l = r / (r - n);
                t.FromValuesToRef(s, 0, 0, 0, 0, a, 0, 0, 0, 0, h, 0, 0, 0, l, 1, o);
            }),
            (t.OrthoOffCenterLH = function (e, i, r, n, o, s) {
                var a = t.Zero();
                return t.OrthoOffCenterLHToRef(e, i, r, n, o, s, a), a;
            }),
            (t.OrthoOffCenterLHToRef = function (e, t, i, r, n, o, s) {
                (s.m[0] = 2 / (t - e)),
                    (s.m[1] = s.m[2] = s.m[3] = 0),
                    (s.m[5] = 2 / (r - i)),
                    (s.m[4] = s.m[6] = s.m[7] = 0),
                    (s.m[10] = -1 / (n - o)),
                    (s.m[8] = s.m[9] = s.m[11] = 0),
                    (s.m[12] = (e + t) / (e - t)),
                    (s.m[13] = (r + i) / (i - r)),
                    (s.m[14] = n / (n - o)),
                    (s.m[15] = 1);
            }),
            (t.PerspectiveLH = function (e, i, r, n) {
                var o = t.Zero();
                return (
                    (o.m[0] = (2 * r) / e),
                    (o.m[1] = o.m[2] = o.m[3] = 0),
                    (o.m[5] = (2 * r) / i),
                    (o.m[4] = o.m[6] = o.m[7] = 0),
                    (o.m[10] = -n / (r - n)),
                    (o.m[8] = o.m[9] = 0),
                    (o.m[11] = 1),
                    (o.m[12] = o.m[13] = o.m[15] = 0),
                    (o.m[14] = (r * n) / (r - n)),
                    o
                );
            }),
            (t.PerspectiveFovLH = function (e, i, r, n) {
                var o = t.Zero();
                return t.PerspectiveFovLHToRef(e, i, r, n, o), o;
            }),
            (t.PerspectiveFovLHToRef = function (t, i, r, n, o, s) {
                void 0 === s && (s = e.Camera.FOVMODE_VERTICAL_FIXED);
                var a = 1 / Math.tan(0.5 * t),
                    h = s === e.Camera.FOVMODE_VERTICAL_FIXED;
                (o.m[0] = h ? a / i : a),
                    (o.m[1] = o.m[2] = o.m[3] = 0),
                    (o.m[5] = h ? a : a * i),
                    (o.m[4] = o.m[6] = o.m[7] = 0),
                    (o.m[8] = o.m[9] = 0),
                    (o.m[10] = -n / (r - n)),
                    (o.m[11] = 1),
                    (o.m[12] = o.m[13] = o.m[15] = 0),
                    (o.m[14] = (r * n) / (r - n));
            }),
            (t.GetFinalMatrix = function (e, i, r, n, o, s) {
                var a = e.width,
                    h = e.height,
                    l = e.x,
                    c = e.y,
                    u = t.FromValues(a / 2, 0, 0, 0, 0, -h / 2, 0, 0, 0, 0, s - o, 0, l + a / 2, h / 2 + c, o, 1);
                return i.multiply(r).multiply(n).multiply(u);
            }),
            (t.GetAsMatrix2x2 = function (e) {
                return new Float32Array([e.m[0], e.m[1], e.m[4], e.m[5]]);
            }),
            (t.GetAsMatrix3x3 = function (e) {
                return new Float32Array([e.m[0], e.m[1], e.m[2], e.m[4], e.m[5], e.m[6], e.m[8], e.m[9], e.m[10]]);
            }),
            (t.Transpose = function (e) {
                var i = new t();
                return (
                    (i.m[0] = e.m[0]),
                    (i.m[1] = e.m[4]),
                    (i.m[2] = e.m[8]),
                    (i.m[3] = e.m[12]),
                    (i.m[4] = e.m[1]),
                    (i.m[5] = e.m[5]),
                    (i.m[6] = e.m[9]),
                    (i.m[7] = e.m[13]),
                    (i.m[8] = e.m[2]),
                    (i.m[9] = e.m[6]),
                    (i.m[10] = e.m[10]),
                    (i.m[11] = e.m[14]),
                    (i.m[12] = e.m[3]),
                    (i.m[13] = e.m[7]),
                    (i.m[14] = e.m[11]),
                    (i.m[15] = e.m[15]),
                    i
                );
            }),
            (t.Reflection = function (e) {
                var i = new t();
                return t.ReflectionToRef(e, i), i;
            }),
            (t.ReflectionToRef = function (e, t) {
                e.normalize();
                var i = e.normal.x,
                    r = e.normal.y,
                    n = e.normal.z,
                    o = -2 * i,
                    s = -2 * r,
                    a = -2 * n;
                (t.m[0] = o * i + 1),
                    (t.m[1] = s * i),
                    (t.m[2] = a * i),
                    (t.m[3] = 0),
                    (t.m[4] = o * r),
                    (t.m[5] = s * r + 1),
                    (t.m[6] = a * r),
                    (t.m[7] = 0),
                    (t.m[8] = o * n),
                    (t.m[9] = s * n),
                    (t.m[10] = a * n + 1),
                    (t.m[11] = 0),
                    (t.m[12] = o * e.d),
                    (t.m[13] = s * e.d),
                    (t.m[14] = a * e.d),
                    (t.m[15] = 1);
            }),
            (t._tempQuaternion = new s()),
            (t._xAxis = n.Zero()),
            (t._yAxis = n.Zero()),
            (t._zAxis = n.Zero()),
            t
        );
    })();
    e.Matrix = a;
    var h = (function () {
        function e(e, t, i, r) {
            (this.normal = new n(e, t, i)), (this.d = r);
        }
        return (
            (e.prototype.asArray = function () {
                return [this.normal.x, this.normal.y, this.normal.z, this.d];
            }),
            (e.prototype.clone = function () {
                return new e(this.normal.x, this.normal.y, this.normal.z, this.d);
            }),
            (e.prototype.normalize = function () {
                var e = Math.sqrt(this.normal.x * this.normal.x + this.normal.y * this.normal.y + this.normal.z * this.normal.z),
                    t = 0;
                return 0 !== e && (t = 1 / e), (this.normal.x *= t), (this.normal.y *= t), (this.normal.z *= t), (this.d *= t), this;
            }),
            (e.prototype.transform = function (t) {
                var i = a.Transpose(t),
                    r = this.normal.x,
                    n = this.normal.y,
                    o = this.normal.z,
                    s = this.d,
                    h = r * i.m[0] + n * i.m[1] + o * i.m[2] + s * i.m[3],
                    l = r * i.m[4] + n * i.m[5] + o * i.m[6] + s * i.m[7],
                    c = r * i.m[8] + n * i.m[9] + o * i.m[10] + s * i.m[11],
                    u = r * i.m[12] + n * i.m[13] + o * i.m[14] + s * i.m[15];
                return new e(h, l, c, u);
            }),
            (e.prototype.dotCoordinate = function (e) {
                return this.normal.x * e.x + this.normal.y * e.y + this.normal.z * e.z + this.d;
            }),
            (e.prototype.copyFromPoints = function (e, t, i) {
                var r,
                    n = t.x - e.x,
                    o = t.y - e.y,
                    s = t.z - e.z,
                    a = i.x - e.x,
                    h = i.y - e.y,
                    l = i.z - e.z,
                    c = o * l - s * h,
                    u = s * a - n * l,
                    f = n * h - o * a,
                    d = Math.sqrt(c * c + u * u + f * f);
                return (r = 0 !== d ? 1 / d : 0), (this.normal.x = c * r), (this.normal.y = u * r), (this.normal.z = f * r), (this.d = -(this.normal.x * e.x + this.normal.y * e.y + this.normal.z * e.z)), this;
            }),
            (e.prototype.isFrontFacingTo = function (e, t) {
                var i = n.Dot(this.normal, e);
                return t >= i;
            }),
            (e.prototype.signedDistanceTo = function (e) {
                return n.Dot(e, this.normal) + this.d;
            }),
            (e.FromArray = function (t) {
                return new e(t[0], t[1], t[2], t[3]);
            }),
            (e.FromPoints = function (t, i, r) {
                var n = new e(0, 0, 0, 0);
                return n.copyFromPoints(t, i, r), n;
            }),
            (e.FromPositionAndNormal = function (t, i) {
                var r = new e(0, 0, 0, 0);
                return i.normalize(), (r.normal = i), (r.d = -(i.x * t.x + i.y * t.y + i.z * t.z)), r;
            }),
            (e.SignedDistanceToPlaneFromPositionAndNormal = function (e, t, i) {
                var r = -(t.x * e.x + t.y * e.y + t.z * e.z);
                return n.Dot(i, t) + r;
            }),
            e
        );
    })();
    e.Plane = h;
    var l = (function () {
        function e(e, t, i, r) {
            (this.x = e), (this.y = t), (this.width = i), (this.height = r);
        }
        return (
            (e.prototype.toGlobal = function (t) {
                var i = t.getRenderWidth(),
                    r = t.getRenderHeight();
                return new e(this.x * i, this.y * r, this.width * i, this.height * r);
            }),
            e
        );
    })();
    e.Viewport = l;
    var c = (function () {
        function e() {}
        return (
            (e.GetPlanes = function (t) {
                for (var i = [], r = 0; 6 > r; r++) i.push(new h(0, 0, 0, 0));
                return e.GetPlanesToRef(t, i), i;
            }),
            (e.GetPlanesToRef = function (e, t) {
                (t[0].normal.x = e.m[3] + e.m[2]),
                    (t[0].normal.y = e.m[7] + e.m[6]),
                    (t[0].normal.z = e.m[11] + e.m[10]),
                    (t[0].d = e.m[15] + e.m[14]),
                    t[0].normalize(),
                    (t[1].normal.x = e.m[3] - e.m[2]),
                    (t[1].normal.y = e.m[7] - e.m[6]),
                    (t[1].normal.z = e.m[11] - e.m[10]),
                    (t[1].d = e.m[15] - e.m[14]),
                    t[1].normalize(),
                    (t[2].normal.x = e.m[3] + e.m[0]),
                    (t[2].normal.y = e.m[7] + e.m[4]),
                    (t[2].normal.z = e.m[11] + e.m[8]),
                    (t[2].d = e.m[15] + e.m[12]),
                    t[2].normalize(),
                    (t[3].normal.x = e.m[3] - e.m[0]),
                    (t[3].normal.y = e.m[7] - e.m[4]),
                    (t[3].normal.z = e.m[11] - e.m[8]),
                    (t[3].d = e.m[15] - e.m[12]),
                    t[3].normalize(),
                    (t[4].normal.x = e.m[3] - e.m[1]),
                    (t[4].normal.y = e.m[7] - e.m[5]),
                    (t[4].normal.z = e.m[11] - e.m[9]),
                    (t[4].d = e.m[15] - e.m[13]),
                    t[4].normalize(),
                    (t[5].normal.x = e.m[3] + e.m[1]),
                    (t[5].normal.y = e.m[7] + e.m[5]),
                    (t[5].normal.z = e.m[11] + e.m[9]),
                    (t[5].d = e.m[15] + e.m[13]),
                    t[5].normalize();
            }),
            e
        );
    })();
    e.Frustum = c;
    var u = (function () {
        function t(e, t, i) {
            void 0 === i && (i = Number.MAX_VALUE), (this.origin = e), (this.direction = t), (this.length = i);
        }
        return (
            (t.prototype.intersectsBoxMinMax = function (e, t) {
                var i,
                    r,
                    n,
                    o,
                    s = 0,
                    a = Number.MAX_VALUE;
                if (Math.abs(this.direction.x) < 1e-7) {
                    if (this.origin.x < e.x || this.origin.x > t.x) return !1;
                } else if (
                    ((i = 1 / this.direction.x), (r = (e.x - this.origin.x) * i), (n = (t.x - this.origin.x) * i), n === -(1 / 0) && (n = 1 / 0), r > n && ((o = r), (r = n), (n = o)), (s = Math.max(r, s)), (a = Math.min(n, a)), s > a)
                )
                    return !1;
                if (Math.abs(this.direction.y) < 1e-7) {
                    if (this.origin.y < e.y || this.origin.y > t.y) return !1;
                } else if (
                    ((i = 1 / this.direction.y), (r = (e.y - this.origin.y) * i), (n = (t.y - this.origin.y) * i), n === -(1 / 0) && (n = 1 / 0), r > n && ((o = r), (r = n), (n = o)), (s = Math.max(r, s)), (a = Math.min(n, a)), s > a)
                )
                    return !1;
                if (Math.abs(this.direction.z) < 1e-7) {
                    if (this.origin.z < e.z || this.origin.z > t.z) return !1;
                } else if (
                    ((i = 1 / this.direction.z), (r = (e.z - this.origin.z) * i), (n = (t.z - this.origin.z) * i), n === -(1 / 0) && (n = 1 / 0), r > n && ((o = r), (r = n), (n = o)), (s = Math.max(r, s)), (a = Math.min(n, a)), s > a)
                )
                    return !1;
                return !0;
            }),
            (t.prototype.intersectsBox = function (e) {
                return this.intersectsBoxMinMax(e.minimum, e.maximum);
            }),
            (t.prototype.intersectsSphere = function (e) {
                var t = e.center.x - this.origin.x,
                    i = e.center.y - this.origin.y,
                    r = e.center.z - this.origin.z,
                    n = t * t + i * i + r * r,
                    o = e.radius * e.radius;
                if (o >= n) return !0;
                var s = t * this.direction.x + i * this.direction.y + r * this.direction.z;
                if (0 > s) return !1;
                var a = n - s * s;
                return o >= a;
            }),
            (t.prototype.intersectsTriangle = function (t, i, r) {
                this._edge1 || ((this._edge1 = n.Zero()), (this._edge2 = n.Zero()), (this._pvec = n.Zero()), (this._tvec = n.Zero()), (this._qvec = n.Zero())),
                    i.subtractToRef(t, this._edge1),
                    r.subtractToRef(t, this._edge2),
                    n.CrossToRef(this.direction, this._edge2, this._pvec);
                var o = n.Dot(this._edge1, this._pvec);
                if (0 === o) return null;
                var s = 1 / o;
                this.origin.subtractToRef(t, this._tvec);
                var a = n.Dot(this._tvec, this._pvec) * s;
                if (0 > a || a > 1) return null;
                n.CrossToRef(this._tvec, this._edge1, this._qvec);
                var h = n.Dot(this.direction, this._qvec) * s;
                if (0 > h || a + h > 1) return null;
                var l = n.Dot(this._edge2, this._qvec) * s;
                return l > this.length ? null : new e.IntersectionInfo(a, h, l);
            }),
            (t.CreateNew = function (e, i, r, o, s, a, h) {
                var l = n.Unproject(new n(e, i, 0), r, o, s, a, h),
                    c = n.Unproject(new n(e, i, 1), r, o, s, a, h),
                    u = c.subtract(l);
                return u.normalize(), new t(l, u);
            }),
            (t.CreateNewFromTo = function (e, i, r) {
                void 0 === r && (r = a.Identity());
                var n = i.subtract(e),
                    o = Math.sqrt(n.x * n.x + n.y * n.y + n.z * n.z);
                return n.normalize(), t.Transform(new t(e, n, o), r);
            }),
            (t.Transform = function (e, i) {
                var r = n.TransformCoordinates(e.origin, i),
                    o = n.TransformNormal(e.direction, i);
                return new t(r, o, e.length);
            }),
            t
        );
    })();
    (e.Ray = u),
        (function (e) {
            (e[(e.LOCAL = 0)] = "LOCAL"), (e[(e.WORLD = 1)] = "WORLD");
        })(e.Space || (e.Space = {}));
    var f =
        (e.Space,
        (function () {
            function e() {}
            return (e.X = new n(1, 0, 0)), (e.Y = new n(0, 1, 0)), (e.Z = new n(0, 0, 1)), e;
        })());
    e.Axis = f;
    var d = (function () {
        function e() {}
        return (
            (e.interpolate = function (e, t, i, r, n) {
                for (var o = 1 - 3 * r + 3 * t, s = 3 * r - 6 * t, a = 3 * t, h = e, l = 0; 5 > l; l++) {
                    var c = h * h,
                        u = c * h,
                        f = o * u + s * c + a * h,
                        d = 1 / (3 * o * c + 2 * s * h + a);
                    (h -= (f - e) * d), (h = Math.min(1, Math.max(0, h)));
                }
                return 3 * Math.pow(1 - h, 2) * h * i + 3 * (1 - h) * Math.pow(h, 2) * n + Math.pow(h, 3);
            }),
            e
        );
    })();
    (e.BezierCurve = d),
        (function (e) {
            (e[(e.CW = 0)] = "CW"), (e[(e.CCW = 1)] = "CCW");
        })(e.Orientation || (e.Orientation = {}));
    var p = e.Orientation,
        m = (function () {
            function e(e) {
                var t = this;
                (this.degrees = function () {
                    return (180 * t._radians) / Math.PI;
                }),
                    (this.radians = function () {
                        return t._radians;
                    }),
                    (this._radians = e),
                    this._radians < 0 && (this._radians += 2 * Math.PI);
            }
            return (
                (e.BetweenTwoPoints = function (t, i) {
                    var r = i.subtract(t),
                        n = Math.atan2(r.y, r.x);
                    return new e(n);
                }),
                (e.FromRadians = function (t) {
                    return new e(t);
                }),
                (e.FromDegrees = function (t) {
                    return new e((t * Math.PI) / 180);
                }),
                e
            );
        })();
    e.Angle = m;
    var g = (function () {
        function e(e, t, i) {
            (this.startPoint = e), (this.midPoint = t), (this.endPoint = i);
            var n = Math.pow(t.x, 2) + Math.pow(t.y, 2),
                o = (Math.pow(e.x, 2) + Math.pow(e.y, 2) - n) / 2,
                s = (n - Math.pow(i.x, 2) - Math.pow(i.y, 2)) / 2,
                a = (e.x - t.x) * (t.y - i.y) - (t.x - i.x) * (e.y - t.y);
            (this.centerPoint = new r((o * (t.y - i.y) - s * (e.y - t.y)) / a, ((e.x - t.x) * s - (t.x - i.x) * o) / a)),
                (this.radius = this.centerPoint.subtract(this.startPoint).length()),
                (this.startAngle = m.BetweenTwoPoints(this.centerPoint, this.startPoint));
            var h = this.startAngle.degrees(),
                l = m.BetweenTwoPoints(this.centerPoint, this.midPoint).degrees(),
                c = m.BetweenTwoPoints(this.centerPoint, this.endPoint).degrees();
            l - h > 180 && (l -= 360),
                -180 > l - h && (l += 360),
                c - l > 180 && (c -= 360),
                -180 > c - l && (c += 360),
                (this.orientation = 0 > l - h ? p.CW : p.CCW),
                (this.angle = m.FromDegrees(this.orientation === p.CW ? h - c : c - h));
        }
        return e;
    })();
    e.Arc2 = g;
    var _ = (function () {
        function e(e) {
            (this.path = e), (this._onchange = new Array()), (this.value = 0), (this.animations = new Array());
        }
        return (
            (e.prototype.getPoint = function () {
                var e = this.path.getPointAtLengthPosition(this.value);
                return new n(e.x, 0, e.y);
            }),
            (e.prototype.moveAhead = function (e) {
                return void 0 === e && (e = 0.002), this.move(e), this;
            }),
            (e.prototype.moveBack = function (e) {
                return void 0 === e && (e = 0.002), this.move(-e), this;
            }),
            (e.prototype.move = function (e) {
                if (Math.abs(e) > 1) throw "step size should be less than 1.";
                return (this.value += e), this.ensureLimits(), this.raiseOnChange(), this;
            }),
            (e.prototype.ensureLimits = function () {
                for (; this.value > 1; ) this.value -= 1;
                for (; this.value < 0; ) this.value += 1;
                return this;
            }),
            (e.prototype.markAsDirty = function (e) {
                return this.ensureLimits(), this.raiseOnChange(), this;
            }),
            (e.prototype.raiseOnChange = function () {
                var e = this;
                return (
                    this._onchange.forEach(function (t) {
                        return t(e);
                    }),
                    this
                );
            }),
            (e.prototype.onchange = function (e) {
                return this._onchange.push(e), this;
            }),
            e
        );
    })();
    e.PathCursor = _;
    var v = (function () {
        function t(e, t) {
            (this._points = new Array()), (this._length = 0), (this.closed = !1), this._points.push(new r(e, t));
        }
        return (
            (t.prototype.addLineTo = function (t, i) {
                if (closed) return e.Tools.Error("cannot add lines to closed paths"), this;
                var n = new r(t, i),
                    o = this._points[this._points.length - 1];
                return this._points.push(n), (this._length += n.subtract(o).length()), this;
            }),
            (t.prototype.addArcTo = function (t, i, n, o, s) {
                if ((void 0 === s && (s = 36), closed)) return e.Tools.Error("cannot add arcs to closed paths"), this;
                var a = this._points[this._points.length - 1],
                    h = new r(t, i),
                    l = new r(n, o),
                    c = new g(a, h, l),
                    u = c.angle.radians() / s;
                c.orientation === p.CW && (u *= -1);
                for (var f = c.startAngle.radians() + u, d = 0; s > d; d++) {
                    var m = Math.cos(f) * c.radius + c.centerPoint.x,
                        _ = Math.sin(f) * c.radius + c.centerPoint.y;
                    this.addLineTo(m, _), (f += u);
                }
                return this;
            }),
            (t.prototype.close = function () {
                return (this.closed = !0), this;
            }),
            (t.prototype.length = function () {
                var e = this._length;
                if (!this.closed) {
                    var t = this._points[this._points.length - 1],
                        i = this._points[0];
                    e += i.subtract(t).length();
                }
                return e;
            }),
            (t.prototype.getPoints = function () {
                return this._points;
            }),
            (t.prototype.getPointAtLengthPosition = function (t) {
                if (0 > t || t > 1) return e.Tools.Error("normalized length position should be between 0 and 1."), r.Zero();
                for (var i = t * this.length(), n = 0, o = 0; o < this._points.length; o++) {
                    var s = (o + 1) % this._points.length,
                        a = this._points[o],
                        h = this._points[s],
                        l = h.subtract(a),
                        c = l.length() + n;
                    if (i >= n && c >= i) {
                        var u = l.normalize(),
                            f = i - n;
                        return new r(a.x + u.x * f, a.y + u.y * f);
                    }
                    n = c;
                }
                return e.Tools.Error("internal error"), r.Zero();
            }),
            (t.StartingAt = function (e, i) {
                return new t(e, i);
            }),
            t
        );
    })();
    e.Path2 = v;
    var y = (function () {
        function t(e, t, i) {
            (this.path = e), (this._curve = new Array()), (this._distances = new Array()), (this._tangents = new Array()), (this._normals = new Array()), (this._binormals = new Array());
            for (var r = 0; r < e.length; r++) this._curve[r] = e[r].clone();
            (this._raw = i || !1), this._compute(t);
        }
        return (
            (t.prototype.getCurve = function () {
                return this._curve;
            }),
            (t.prototype.getTangents = function () {
                return this._tangents;
            }),
            (t.prototype.getNormals = function () {
                return this._normals;
            }),
            (t.prototype.getBinormals = function () {
                return this._binormals;
            }),
            (t.prototype.getDistances = function () {
                return this._distances;
            }),
            (t.prototype.update = function (e, t) {
                for (var i = 0; i < e.length; i++) (this._curve[i].x = e[i].x), (this._curve[i].y = e[i].y), (this._curve[i].z = e[i].z);
                return this._compute(t), this;
            }),
            (t.prototype._compute = function (e) {
                var t = this._curve.length;
                (this._tangents[0] = this._getFirstNonNullVector(0)), this._raw || this._tangents[0].normalize(), (this._tangents[t - 1] = this._curve[t - 1].subtract(this._curve[t - 2])), this._raw || this._tangents[t - 1].normalize();
                var i = this._tangents[0],
                    r = this._normalVector(this._curve[0], i, e);
                (this._normals[0] = r), this._raw || this._normals[0].normalize(), (this._binormals[0] = n.Cross(i, this._normals[0])), this._raw || this._binormals[0].normalize(), (this._distances[0] = 0);
                for (var o, s, a, h, l = 1; t > l; l++)
                    (o = this._getLastNonNullVector(l)),
                        t - 1 > l && ((s = this._getFirstNonNullVector(l)), (this._tangents[l] = o.add(s)), this._tangents[l].normalize()),
                        (this._distances[l] = this._distances[l - 1] + o.length()),
                        (a = this._tangents[l]),
                        (h = this._binormals[l - 1]),
                        (this._normals[l] = n.Cross(h, a)),
                        this._raw || this._normals[l].normalize(),
                        (this._binormals[l] = n.Cross(a, this._normals[l])),
                        this._raw || this._binormals[l].normalize();
            }),
            (t.prototype._getFirstNonNullVector = function (e) {
                for (var t = 1, i = this._curve[e + t].subtract(this._curve[e]); 0 === i.length() && e + t + 1 < this._curve.length; ) t++, (i = this._curve[e + t].subtract(this._curve[e]));
                return i;
            }),
            (t.prototype._getLastNonNullVector = function (e) {
                for (var t = 1, i = this._curve[e].subtract(this._curve[e - t]); 0 === i.length() && e > t + 1; ) t++, (i = this._curve[e].subtract(this._curve[e - t]));
                return i;
            }),
            (t.prototype._normalVector = function (t, i, r) {
                var o;
                if (void 0 === r || null === r) {
                    var s;
                    e.Tools.WithinEpsilon(i.y, 1, e.Engine.Epsilon)
                        ? e.Tools.WithinEpsilon(i.x, 1, e.Engine.Epsilon)
                            ? e.Tools.WithinEpsilon(i.z, 1, e.Engine.Epsilon) || (s = new n(0, 0, 1))
                            : (s = new n(1, 0, 0))
                        : (s = new n(0, -1, 0)),
                        (o = n.Cross(i, s));
                } else (o = n.Cross(i, r)), n.CrossToRef(o, i, o);
                return o.normalize(), o;
            }),
            t
        );
    })();
    e.Path3D = y;
    var x = (function () {
        function e(e) {
            (this._length = 0), (this._points = e), (this._length = this._computeLength(e));
        }
        return (
            (e.CreateQuadraticBezier = function (t, i, r, o) {
                o = o > 2 ? o : 3;
                for (
                    var s = new Array(),
                        a = function (e, t, i, r) {
                            var n = (1 - e) * (1 - e) * t + 2 * e * (1 - e) * i + e * e * r;
                            return n;
                        },
                        h = 0;
                    o >= h;
                    h++
                )
                    s.push(new n(a(h / o, t.x, i.x, r.x), a(h / o, t.y, i.y, r.y), a(h / o, t.z, i.z, r.z)));
                return new e(s);
            }),
            (e.CreateCubicBezier = function (t, i, r, o, s) {
                s = s > 3 ? s : 4;
                for (
                    var a = new Array(),
                        h = function (e, t, i, r, n) {
                            var o = (1 - e) * (1 - e) * (1 - e) * t + 3 * e * (1 - e) * (1 - e) * i + 3 * e * e * (1 - e) * r + e * e * e * n;
                            return o;
                        },
                        l = 0;
                    s >= l;
                    l++
                )
                    a.push(new n(h(l / s, t.x, i.x, r.x, o.x), h(l / s, t.y, i.y, r.y, o.y), h(l / s, t.z, i.z, r.z, o.z)));
                return new e(a);
            }),
            (e.CreateHermiteSpline = function (t, i, r, o, s) {
                for (var a = new Array(), h = 1 / s, l = 0; s >= l; l++) a.push(n.Hermite(t, i, r, o, l * h));
                return new e(a);
            }),
            (e.prototype.getPoints = function () {
                return this._points;
            }),
            (e.prototype.length = function () {
                return this._length;
            }),
            (e.prototype["continue"] = function (t) {
                for (var i = this._points[this._points.length - 1], r = this._points.slice(), n = t.getPoints(), o = 1; o < n.length; o++) r.push(n[o].subtract(n[0]).add(i));
                var s = new e(r);
                return s;
            }),
            (e.prototype._computeLength = function (e) {
                for (var t = 0, i = 1; i < e.length; i++) t += e[i].subtract(e[i - 1]).length();
                return t;
            }),
            e
        );
    })();
    e.Curve3 = x;
    var M = (function () {
        function e(e, t) {
            void 0 === e && (e = n.Zero()), void 0 === t && (t = n.Up()), (this.position = e), (this.normal = t);
        }
        return (
            (e.prototype.clone = function () {
                return new e(this.position.clone(), this.normal.clone());
            }),
            e
        );
    })();
    e.PositionNormalVertex = M;
    var S = (function () {
        function e(e, t, i) {
            void 0 === e && (e = n.Zero()), void 0 === t && (t = n.Up()), void 0 === i && (i = r.Zero()), (this.position = e), (this.normal = t), (this.uv = i);
        }
        return (
            (e.prototype.clone = function () {
                return new e(this.position.clone(), this.normal.clone(), this.uv.clone());
            }),
            e
        );
    })();
    e.PositionNormalTextureVertex = S;
    var b = a.prototype.multiplyToArray,
        A = a.prototype.invertToRef,
        T = a.LookAtLHToRef,
        E = n.TransformCoordinatesToRef,
        P = n.TransformCoordinatesFromFloatsToRef,
        D = (function () {
            function e() {}
            return (
                Object.defineProperty(e, "IsEnabled", {
                    get: function () {
                        return e._isEnabled;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                (e.DisableSIMD = function () {
                    (a.prototype.multiplyToArray = b), (a.prototype.invertToRef = A), (a.LookAtLHToRef = T), (n.TransformCoordinatesToRef = E), (n.TransformCoordinatesFromFloatsToRef = P), (e._isEnabled = !1);
                }),
                (e.EnableSIMD = function () {
                    void 0 !== window.SIMD &&
                        ((a.prototype.multiplyToArray = a.prototype.multiplyToArraySIMD),
                        (a.prototype.invertToRef = a.prototype.invertToRefSIMD),
                        (a.LookAtLHToRef = a.LookAtLHToRefSIMD),
                        (n.TransformCoordinatesToRef = n.TransformCoordinatesToRefSIMD),
                        (n.TransformCoordinatesFromFloatsToRef = n.TransformCoordinatesFromFloatsToRefSIMD),
                        Object.defineProperty(n.prototype, "x", {
                            get: function () {
                                return this._data[0];
                            },
                            set: function (e) {
                                this._data || (this._data = new Float32Array(3)), (this._data[0] = e);
                            },
                        }),
                        Object.defineProperty(n.prototype, "y", {
                            get: function () {
                                return this._data[1];
                            },
                            set: function (e) {
                                this._data[1] = e;
                            },
                        }),
                        Object.defineProperty(n.prototype, "z", {
                            get: function () {
                                return this._data[2];
                            },
                            set: function (e) {
                                this._data[2] = e;
                            },
                        }),
                        (e._isEnabled = !0));
                }),
                (e._isEnabled = !1),
                e
            );
        })();
    e.SIMDHelper = D;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, i) {
            (this.idbFactory = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB),
                (this.callbackManifestChecked = i),
                (this.currentSceneUrl = t.ReturnFullUrlLocation(e)),
                (this.db = null),
                (this.enableSceneOffline = !1),
                (this.enableTexturesOffline = !1),
                (this.manifestVersionFound = 0),
                (this.mustUpdateRessources = !1),
                (this.hasReachedQuota = !1),
                t.IDBStorageEnabled ? this.checkManifestFile() : this.callbackManifestChecked(!0);
        }
        return (
            (t.prototype.checkManifestFile = function () {
                function t() {
                    (r.enableSceneOffline = !1), (r.enableTexturesOffline = !1), r.callbackManifestChecked(!1);
                }
                var i = this,
                    r = this,
                    n = this.currentSceneUrl + ".manifest",
                    o = new XMLHttpRequest(),
                    s = n + (null == n.match(/\?/) ? "?" : "&") + new Date().getTime();
                o.open("GET", s, !0),
                    o.addEventListener(
                        "load",
                        function () {
                            if (200 === o.status || e.Tools.ValidateXHRData(o, 1))
                                try {
                                    var r = JSON.parse(o.response);
                                    (i.enableSceneOffline = r.enableSceneOffline),
                                        (i.enableTexturesOffline = r.enableTexturesOffline),
                                        r.version && !isNaN(parseInt(r.version)) && (i.manifestVersionFound = r.version),
                                        i.callbackManifestChecked && i.callbackManifestChecked(!0);
                                } catch (n) {
                                    t();
                                }
                            else t();
                        },
                        !1
                    ),
                    o.addEventListener(
                        "error",
                        function (e) {
                            t();
                        },
                        !1
                    );
                try {
                    o.send();
                } catch (a) {
                    e.Tools.Error("Error on XHR send request."), r.callbackManifestChecked(!1);
                }
            }),
            (t.prototype.openAsync = function (t, i) {
                function r() {
                    (o.isSupported = !1), i && i();
                }
                var n = this,
                    o = this;
                if (this.idbFactory && (this.enableSceneOffline || this.enableTexturesOffline))
                    if (this.db) t && t();
                    else {
                        (this.hasReachedQuota = !1), (this.isSupported = !0);
                        var s = this.idbFactory.open("babylonjs", 1);
                        (s.onerror = function (e) {
                            r();
                        }),
                            (s.onblocked = function (t) {
                                e.Tools.Error("IDB request blocked. Please reload the page."), r();
                            }),
                            (s.onsuccess = function (e) {
                                (n.db = s.result), t();
                            }),
                            (s.onupgradeneeded = function (t) {
                                n.db = t.target.result;
                                try {
                                    {
                                        n.db.createObjectStore("scenes", { keyPath: "sceneUrl" }), n.db.createObjectStore("versions", { keyPath: "sceneUrl" }), n.db.createObjectStore("textures", { keyPath: "textureUrl" });
                                    }
                                } catch (i) {
                                    e.Tools.Error("Error while creating object stores. Exception: " + i.message), r();
                                }
                            });
                    }
                else (this.isSupported = !1), i && i();
            }),
            (t.prototype.loadImageFromDB = function (e, i) {
                var r = this,
                    n = t.ReturnFullUrlLocation(e),
                    o = function () {
                        r.hasReachedQuota || null === r.db ? (i.src = e) : r._saveImageIntoDBAsync(n, i);
                    };
                this.mustUpdateRessources ? o() : this._loadImageFromDBAsync(n, i, o);
            }),
            (t.prototype._loadImageFromDBAsync = function (t, i, r) {
                if (this.isSupported && null !== this.db) {
                    var n,
                        o = this.db.transaction(["textures"]);
                    (o.onabort = function (e) {
                        i.src = t;
                    }),
                        (o.oncomplete = function (o) {
                            var s;
                            if (n) {
                                var a = window.URL || window.webkitURL;
                                (s = a.createObjectURL(n.data, { oneTimeOnly: !0 })),
                                    (i.onerror = function () {
                                        e.Tools.Error("Error loading image from blob URL: " + s + " switching back to web url: " + t), (i.src = t);
                                    }),
                                    (i.src = s);
                            } else r();
                        });
                    var s = o.objectStore("textures").get(t);
                    (s.onsuccess = function (e) {
                        n = e.target.result;
                    }),
                        (s.onerror = function (r) {
                            e.Tools.Error("Error loading texture " + t + " from DB."), (i.src = t);
                        });
                } else e.Tools.Error("Error: IndexedDB not supported by your browser or BabylonJS Database is not open."), (i.src = t);
            }),
            (t.prototype._saveImageIntoDBAsync = function (i, r) {
                var n = this;
                if (this.isSupported) {
                    var o = function () {
                        var e;
                        if (s) {
                            var t = window.URL || window.webkitURL;
                            try {
                                e = t.createObjectURL(s, { oneTimeOnly: !0 });
                            } catch (i) {
                                e = t.createObjectURL(s);
                            }
                        }
                        r.src = e;
                    };
                    if (t.IsUASupportingBlobStorage) {
                        var s,
                            a = new XMLHttpRequest();
                        a.open("GET", i, !0),
                            (a.responseType = "blob"),
                            a.addEventListener(
                                "load",
                                function () {
                                    if (200 === a.status) {
                                        s = a.response;
                                        var e = n.db.transaction(["textures"], "readwrite");
                                        (e.onabort = function (e) {
                                            try {
                                                e.srcElement.error && "QuotaExceededError" === e.srcElement.error.name && (this.hasReachedQuota = !0);
                                            } catch (t) {}
                                            o();
                                        }),
                                            (e.oncomplete = function (e) {
                                                o();
                                            });
                                        var h = { textureUrl: i, data: s };
                                        try {
                                            var l = e.objectStore("textures").put(h);
                                            (l.onsuccess = function (e) {}),
                                                (l.onerror = function (e) {
                                                    o();
                                                });
                                        } catch (c) {
                                            25 === c.code && (t.IsUASupportingBlobStorage = !1), (r.src = i);
                                        }
                                    } else r.src = i;
                                },
                                !1
                            ),
                            a.addEventListener(
                                "error",
                                function (t) {
                                    e.Tools.Error("Error in XHR request in BABYLON.Database."), (r.src = i);
                                },
                                !1
                            ),
                            a.send();
                    } else r.src = i;
                } else e.Tools.Error("Error: IndexedDB not supported by your browser or BabylonJS Database is not open."), (r.src = i);
            }),
            (t.prototype._checkVersionFromDB = function (e, t) {
                var i = this,
                    r = function (r) {
                        i._saveVersionIntoDBAsync(e, t);
                    };
                this._loadVersionFromDBAsync(e, t, r);
            }),
            (t.prototype._loadVersionFromDBAsync = function (t, i, r) {
                var n = this;
                if (this.isSupported) {
                    var o;
                    try {
                        var s = this.db.transaction(["versions"]);
                        (s.oncomplete = function (e) {
                            o ? (n.manifestVersionFound > o.data ? ((n.mustUpdateRessources = !0), r()) : i(o.data)) : ((n.mustUpdateRessources = !0), r());
                        }),
                            (s.onabort = function (e) {
                                i(-1);
                            });
                        var a = s.objectStore("versions").get(t);
                        (a.onsuccess = function (e) {
                            o = e.target.result;
                        }),
                            (a.onerror = function (r) {
                                e.Tools.Error("Error loading version for scene " + t + " from DB."), i(-1);
                            });
                    } catch (h) {
                        e.Tools.Error("Error while accessing 'versions' object store (READ OP). Exception: " + h.message), i(-1);
                    }
                } else e.Tools.Error("Error: IndexedDB not supported by your browser or BabylonJS Database is not open."), i(-1);
            }),
            (t.prototype._saveVersionIntoDBAsync = function (t, i) {
                var r = this;
                if (this.isSupported && !this.hasReachedQuota)
                    try {
                        var n = this.db.transaction(["versions"], "readwrite");
                        (n.onabort = function (e) {
                            try {
                                e.srcElement.error && "QuotaExceededError" === e.srcElement.error.name && (r.hasReachedQuota = !0);
                            } catch (t) {}
                            i(-1);
                        }),
                            (n.oncomplete = function (e) {
                                i(r.manifestVersionFound);
                            });
                        var o = { sceneUrl: t, data: this.manifestVersionFound },
                            s = n.objectStore("versions").put(o);
                        (s.onsuccess = function (e) {}),
                            (s.onerror = function (t) {
                                e.Tools.Error("Error in DB add version request in BABYLON.Database.");
                            });
                    } catch (a) {
                        e.Tools.Error("Error while accessing 'versions' object store (WRITE OP). Exception: " + a.message), i(-1);
                    }
                else i(-1);
            }),
            (t.prototype.loadFileFromDB = function (e, i, r, n, o) {
                var s = this,
                    a = t.ReturnFullUrlLocation(e),
                    h = function (e) {
                        s._saveFileIntoDBAsync(a, i, r);
                    };
                this._checkVersionFromDB(a, function (e) {
                    -1 !== e ? (s.mustUpdateRessources ? s._saveFileIntoDBAsync(a, i, r, o) : s._loadFileFromDBAsync(a, i, h, o)) : n();
                });
            }),
            (t.prototype._loadFileFromDBAsync = function (t, i, r, n) {
                if (this.isSupported) {
                    var o;
                    o = -1 !== t.indexOf(".babylon") ? "scenes" : "textures";
                    var s,
                        a = this.db.transaction([o]);
                    (a.oncomplete = function (e) {
                        s ? i(s.data) : r();
                    }),
                        (a.onabort = function (e) {
                            r();
                        });
                    var h = a.objectStore(o).get(t);
                    (h.onsuccess = function (e) {
                        s = e.target.result;
                    }),
                        (h.onerror = function (i) {
                            e.Tools.Error("Error loading file " + t + " from DB."), r();
                        });
                } else e.Tools.Error("Error: IndexedDB not supported by your browser or BabylonJS Database is not open."), i();
            }),
            (t.prototype._saveFileIntoDBAsync = function (t, i, r, n) {
                var o = this;
                if (this.isSupported) {
                    var s;
                    s = -1 !== t.indexOf(".babylon") ? "scenes" : "textures";
                    var a,
                        h = new XMLHttpRequest();
                    h.open("GET", t, !0),
                        n && (h.responseType = "arraybuffer"),
                        (h.onprogress = r),
                        h.addEventListener(
                            "load",
                            function () {
                                if (200 === h.status || e.Tools.ValidateXHRData(h, n ? 6 : 1))
                                    if (((a = n ? h.response : h.responseText), o.hasReachedQuota)) i(a);
                                    else {
                                        var r = o.db.transaction([s], "readwrite");
                                        (r.onabort = function (e) {
                                            try {
                                                e.srcElement.error && "QuotaExceededError" === e.srcElement.error.name && (this.hasReachedQuota = !0);
                                            } catch (t) {}
                                            i(a);
                                        }),
                                            (r.oncomplete = function (e) {
                                                i(a);
                                            });
                                        var l;
                                        l = "scenes" === s ? { sceneUrl: t, data: a, version: o.manifestVersionFound } : { textureUrl: t, data: a };
                                        try {
                                            var c = r.objectStore(s).put(l);
                                            (c.onsuccess = function (e) {}),
                                                (c.onerror = function (t) {
                                                    e.Tools.Error("Error in DB add file request in BABYLON.Database.");
                                                });
                                        } catch (u) {
                                            i(a);
                                        }
                                    }
                                else i();
                            },
                            !1
                        ),
                        h.addEventListener(
                            "error",
                            function (t) {
                                e.Tools.Error("error on XHR request."), i();
                            },
                            !1
                        ),
                        h.send();
                } else e.Tools.Error("Error: IndexedDB not supported by your browser or BabylonJS Database is not open."), i();
            }),
            (t.IsUASupportingBlobStorage = !0),
            (t.IDBStorageEnabled = !0),
            (t.parseURL = function (e) {
                var t = document.createElement("a");
                t.href = e;
                var i = e.substring(0, e.lastIndexOf("#")),
                    r = e.substring(i.lastIndexOf("/") + 1, e.length),
                    n = e.substring(0, e.indexOf(r, 0));
                return n;
            }),
            (t.ReturnFullUrlLocation = function (e) {
                return -1 === e.indexOf("http:/") ? t.parseURL(window.location.href) + e : e;
            }),
            t
        );
    })();
    e.Database = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t;
    !(function (t) {
        var i = (function () {
            function t() {}
            return (
                (t.GetTGAHeader = function (e) {
                    var t = 0,
                        i = {
                            id_length: e[t++],
                            colormap_type: e[t++],
                            image_type: e[t++],
                            colormap_index: e[t++] | (e[t++] << 8),
                            colormap_length: e[t++] | (e[t++] << 8),
                            colormap_size: e[t++],
                            origin: [e[t++] | (e[t++] << 8), e[t++] | (e[t++] << 8)],
                            width: e[t++] | (e[t++] << 8),
                            height: e[t++] | (e[t++] << 8),
                            pixel_size: e[t++],
                            flags: e[t++],
                        };
                    return i;
                }),
                (t.UploadContent = function (i, r) {
                    if (r.length < 19) return void e.Tools.Error("Unable to load TGA file - Not enough data to contain header");
                    var n = 18,
                        o = t.GetTGAHeader(r);
                    if (o.id_length + n > r.length) return void e.Tools.Error("Unable to load TGA file - Not enough data");
                    n += o.id_length;
                    var s = !1,
                        a = !1,
                        h = !1,
                        l = !1;
                    switch (o.image_type) {
                        case t._TYPE_RLE_INDEXED:
                            s = !0;
                        case t._TYPE_INDEXED:
                            a = !0;
                            break;
                        case t._TYPE_RLE_RGB:
                            s = !0;
                        case t._TYPE_RGB:
                            h = !0;
                            break;
                        case t._TYPE_RLE_GREY:
                            s = !0;
                        case t._TYPE_GREY:
                            l = !0;
                    }
                    var c,
                        u,
                        f = (15 & o.flags, o.pixel_size >> 3),
                        d = o.width * o.height * f;
                    if ((a && (u = r.subarray(n, (n += o.colormap_length * (o.colormap_size >> 3)))), s)) {
                        c = new Uint8Array(d);
                        for (var p, m, g, _ = 0, v = new Uint8Array(f); d > n && d > _; )
                            if (((p = r[n++]), (m = (127 & p) + 1), 128 & p)) {
                                for (g = 0; f > g; ++g) v[g] = r[n++];
                                for (g = 0; m > g; ++g) c.set(v, _ + g * f);
                                _ += f * m;
                            } else {
                                for (m *= f, g = 0; m > g; ++g) c[_ + g] = r[n++];
                                _ += m;
                            }
                    } else c = r.subarray(n, (n += a ? o.width * o.height : d));
                    var y, x, M, S, b, A;
                    switch ((o.flags & t._ORIGIN_MASK) >> t._ORIGIN_SHIFT) {
                        default:
                        case t._ORIGIN_UL:
                            (y = 0), (M = 1), (A = o.width), (x = 0), (S = 1), (b = o.height);
                            break;
                        case t._ORIGIN_BL:
                            (y = 0), (M = 1), (A = o.width), (x = o.height - 1), (S = -1), (b = -1);
                            break;
                        case t._ORIGIN_UR:
                            (y = o.width - 1), (M = -1), (A = -1), (x = 0), (S = 1), (b = o.height);
                            break;
                        case t._ORIGIN_BR:
                            (y = o.width - 1), (M = -1), (A = -1), (x = o.height - 1), (S = -1), (b = -1);
                    }
                    var T = "_getImageData" + (l ? "Grey" : "") + o.pixel_size + "bits",
                        E = t[T](o, u, c, x, S, b, y, M, A);
                    i.texImage2D(i.TEXTURE_2D, 0, i.RGBA, o.width, o.height, 0, i.RGBA, i.UNSIGNED_BYTE, E);
                }),
                (t._getImageData8bits = function (e, t, i, r, n, o, s, a, h) {
                    var l,
                        c,
                        u,
                        f = i,
                        d = t,
                        p = e.width,
                        m = e.height,
                        g = 0,
                        _ = new Uint8Array(p * m * 4);
                    for (u = r; u !== o; u += n)
                        for (c = s; c !== h; c += a, g++) (l = f[g]), (_[4 * (c + p * u) + 3] = 255), (_[4 * (c + p * u) + 2] = d[3 * l + 0]), (_[4 * (c + p * u) + 1] = d[3 * l + 1]), (_[4 * (c + p * u) + 0] = d[3 * l + 2]);
                    return _;
                }),
                (t._getImageData16bits = function (e, t, i, r, n, o, s, a, h) {
                    var l,
                        c,
                        u,
                        f = i,
                        d = e.width,
                        p = e.height,
                        m = 0,
                        g = new Uint8Array(d * p * 4);
                    for (u = r; u !== o; u += n)
                        for (c = s; c !== h; c += a, m += 2)
                            (l = f[m + 0] + (f[m + 1] << 8)), (g[4 * (c + d * u) + 0] = (31744 & l) >> 7), (g[4 * (c + d * u) + 1] = (992 & l) >> 2), (g[4 * (c + d * u) + 2] = (31 & l) >> 3), (g[4 * (c + d * u) + 3] = 32768 & l ? 0 : 255);
                    return g;
                }),
                (t._getImageData24bits = function (e, t, i, r, n, o, s, a, h) {
                    var l,
                        c,
                        u = i,
                        f = e.width,
                        d = e.height,
                        p = 0,
                        m = new Uint8Array(f * d * 4);
                    for (c = r; c !== o; c += n) for (l = s; l !== h; l += a, p += 3) (m[4 * (l + f * c) + 3] = 255), (m[4 * (l + f * c) + 2] = u[p + 0]), (m[4 * (l + f * c) + 1] = u[p + 1]), (m[4 * (l + f * c) + 0] = u[p + 2]);
                    return m;
                }),
                (t._getImageData32bits = function (e, t, i, r, n, o, s, a, h) {
                    var l,
                        c,
                        u = i,
                        f = e.width,
                        d = e.height,
                        p = 0,
                        m = new Uint8Array(f * d * 4);
                    for (c = r; c !== o; c += n) for (l = s; l !== h; l += a, p += 4) (m[4 * (l + f * c) + 2] = u[p + 0]), (m[4 * (l + f * c) + 1] = u[p + 1]), (m[4 * (l + f * c) + 0] = u[p + 2]), (m[4 * (l + f * c) + 3] = u[p + 3]);
                    return m;
                }),
                (t._getImageDataGrey8bits = function (e, t, i, r, n, o, s, a, h) {
                    var l,
                        c,
                        u,
                        f = i,
                        d = e.width,
                        p = e.height,
                        m = 0,
                        g = new Uint8Array(d * p * 4);
                    for (u = r; u !== o; u += n) for (c = s; c !== h; c += a, m++) (l = f[m]), (g[4 * (c + d * u) + 0] = l), (g[4 * (c + d * u) + 1] = l), (g[4 * (c + d * u) + 2] = l), (g[4 * (c + d * u) + 3] = 255);
                    return g;
                }),
                (t._getImageDataGrey16bits = function (e, t, i, r, n, o, s, a, h) {
                    var l,
                        c,
                        u = i,
                        f = e.width,
                        d = e.height,
                        p = 0,
                        m = new Uint8Array(f * d * 4);
                    for (c = r; c !== o; c += n) for (l = s; l !== h; l += a, p += 2) (m[4 * (l + f * c) + 0] = u[p + 0]), (m[4 * (l + f * c) + 1] = u[p + 0]), (m[4 * (l + f * c) + 2] = u[p + 0]), (m[4 * (l + f * c) + 3] = u[p + 1]);
                    return m;
                }),
                (t._TYPE_NO_DATA = 0),
                (t._TYPE_INDEXED = 1),
                (t._TYPE_RGB = 2),
                (t._TYPE_GREY = 3),
                (t._TYPE_RLE_INDEXED = 9),
                (t._TYPE_RLE_RGB = 10),
                (t._TYPE_RLE_GREY = 11),
                (t._ORIGIN_MASK = 48),
                (t._ORIGIN_SHIFT = 4),
                (t._ORIGIN_BL = 0),
                (t._ORIGIN_BR = 1),
                (t._ORIGIN_UL = 2),
                (t._ORIGIN_UR = 3),
                t
            );
        })();
        t.TGATools = i;
    })((t = e.Internals || (e.Internals = {})));
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t;
    !(function (t) {
        function i(e) {
            return e.charCodeAt(0) + (e.charCodeAt(1) << 8) + (e.charCodeAt(2) << 16) + (e.charCodeAt(3) << 24);
        }
        function r(e) {
            return String.fromCharCode(255 & e, (e >> 8) & 255, (e >> 16) & 255, (e >> 24) & 255);
        }
        var n = 542327876,
            o = 131072,
            s = 512,
            a = 4,
            h = 64,
            l = 131072,
            c = i("DXT1"),
            u = i("DXT3"),
            f = i("DXT5"),
            d = 31,
            p = 0,
            m = 1,
            g = 2,
            _ = 3,
            v = 4,
            y = 7,
            x = 20,
            M = 21,
            S = 22,
            b = 28,
            A = (function () {
                function t() {}
                return (
                    (t.GetDDSInfo = function (e) {
                        var t = new Int32Array(e, 0, d),
                            i = 1;
                        return t[g] & o && (i = Math.max(1, t[y])), { width: t[v], height: t[_], mipmapCount: i, isFourCC: (t[x] & a) === a, isRGB: (t[x] & h) === h, isLuminance: (t[x] & l) === l, isCube: (t[b] & s) === s };
                    }),
                    (t.GetRGBAArrayBuffer = function (e, t, i, r, n) {
                        for (var o = new Uint8Array(r), s = new Uint8Array(n), a = 0, h = t - 1; h >= 0; h--)
                            for (var l = 0; e > l; l++) {
                                var c = i + 4 * (l + h * e);
                                (o[a + 2] = s[c]), (o[a + 1] = s[c + 1]), (o[a] = s[c + 2]), (o[a + 3] = s[c + 3]), (a += 4);
                            }
                        return o;
                    }),
                    (t.GetRGBArrayBuffer = function (e, t, i, r, n) {
                        for (var o = new Uint8Array(r), s = new Uint8Array(n), a = 0, h = t - 1; h >= 0; h--)
                            for (var l = 0; e > l; l++) {
                                var c = i + 3 * (l + h * e);
                                (o[a + 2] = s[c]), (o[a + 1] = s[c + 1]), (o[a] = s[c + 2]), (a += 3);
                            }
                        return o;
                    }),
                    (t.GetLuminanceArrayBuffer = function (e, t, i, r, n) {
                        for (var o = new Uint8Array(r), s = new Uint8Array(n), a = 0, h = t - 1; h >= 0; h--)
                            for (var l = 0; e > l; l++) {
                                var c = i + (l + h * e);
                                (o[a] = s[c]), a++;
                            }
                        return o;
                    }),
                    (t.UploadDDSLevels = function (i, s, a, h, l, x) {
                        var b,
                            A,
                            T,
                            E,
                            P,
                            D,
                            C,
                            I,
                            w,
                            R,
                            L = new Int32Array(a, 0, d);
                        if (L[p] != n) return void e.Tools.Error("Invalid magic number in DDS header");
                        if (!h.isFourCC && !h.isRGB && !h.isLuminance) return void e.Tools.Error("Unsupported format, must contain a FourCC, RGB or LUMINANCE code");
                        if (h.isFourCC)
                            switch ((b = L[M])) {
                                case c:
                                    (A = 8), (T = s.COMPRESSED_RGBA_S3TC_DXT1_EXT);
                                    break;
                                case u:
                                    (A = 16), (T = s.COMPRESSED_RGBA_S3TC_DXT3_EXT);
                                    break;
                                case f:
                                    (A = 16), (T = s.COMPRESSED_RGBA_S3TC_DXT5_EXT);
                                    break;
                                default:
                                    return void console.error("Unsupported FourCC code:", r(b));
                            }
                        (w = 1), L[g] & o && l !== !1 && (w = Math.max(1, L[y]));
                        for (var O = L[S], B = 0; x > B; B++) {
                            var F = 1 == x ? i.TEXTURE_2D : i.TEXTURE_CUBE_MAP_POSITIVE_X + B;
                            for (E = L[v], P = L[_], C = L[m] + 4, R = 0; w > R; ++R) {
                                if (h.isRGB)
                                    24 == O
                                        ? ((D = E * P * 3), (I = t.GetRGBArrayBuffer(E, P, C, D, a)), i.texImage2D(F, R, i.RGB, E, P, 0, i.RGB, i.UNSIGNED_BYTE, I))
                                        : ((D = E * P * 4), (I = t.GetRGBAArrayBuffer(E, P, C, D, a)), i.texImage2D(F, R, i.RGBA, E, P, 0, i.RGBA, i.UNSIGNED_BYTE, I));
                                else if (h.isLuminance) {
                                    var V = i.getParameter(i.UNPACK_ALIGNMENT),
                                        N = E,
                                        z = Math.floor((E + V - 1) / V) * V;
                                    (D = z * (P - 1) + N), (I = t.GetLuminanceArrayBuffer(E, P, C, D, a)), i.texImage2D(F, R, i.LUMINANCE, E, P, 0, i.LUMINANCE, i.UNSIGNED_BYTE, I);
                                } else (D = (((Math.max(4, E) / 4) * Math.max(4, P)) / 4) * A), (I = new Uint8Array(a, C, D)), i.compressedTexImage2D(F, R, T, E, P, 0, I);
                                (C += D), (E *= 0.5), (P *= 0.5), (E = Math.max(1, E)), (P = Math.max(1, P));
                            }
                        }
                    }),
                    t
                );
            })();
        t.DDSTools = A;
    })((t = e.Internals || (e.Internals = {})));
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e(t) {
            (this.length = 0), (this._duplicateId = 0), (this.data = new Array(t)), (this._id = e._GlobalId++);
        }
        return (
            (e.prototype.push = function (e) {
                (this.data[this.length++] = e), this.length > this.data.length && (this.data.length *= 2), e.__smartArrayFlags || (e.__smartArrayFlags = {}), (e.__smartArrayFlags[this._id] = this._duplicateId);
            }),
            (e.prototype.pushNoDuplicate = function (e) {
                (e.__smartArrayFlags && e.__smartArrayFlags[this._id] === this._duplicateId) || this.push(e);
            }),
            (e.prototype.sort = function (e) {
                this.data.sort(e);
            }),
            (e.prototype.reset = function () {
                (this.length = 0), this._duplicateId++;
            }),
            (e.prototype.concat = function (e) {
                if (0 !== e.length) {
                    this.length + e.length > this.data.length && (this.data.length = 2 * (this.length + e.length));
                    for (var t = 0; t < e.length; t++) this.data[this.length++] = (e.data || e)[t];
                }
            }),
            (e.prototype.concatWithNoDuplicate = function (e) {
                if (0 !== e.length) {
                    this.length + e.length > this.data.length && (this.data.length = 2 * (this.length + e.length));
                    for (var t = 0; t < e.length; t++) {
                        var i = (e.data || e)[t];
                        this.pushNoDuplicate(i);
                    }
                }
            }),
            (e.prototype.indexOf = function (e) {
                var t = this.data.indexOf(e);
                return t >= this.length ? -1 : t;
            }),
            (e._GlobalId = 0),
            e
        );
    })();
    e.SmartArray = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e(e) {
            void 0 === e && (e = 10), (this.count = 0), (this._initialCapacity = e), (this.items = {}), (this._keys = new Array(this._initialCapacity));
        }
        return (
            (e.prototype.add = function (e, t) {
                return void 0 != this.items[e] ? -1 : ((this.items[e] = t), (this._keys[this.count++] = e), this.count > this._keys.length && (this._keys.length *= 2), this.count);
            }),
            (e.prototype.remove = function (e) {
                return void 0 == this.items[e] ? -1 : this.removeItemOfIndex(this.indexOf(e));
            }),
            (e.prototype.removeItemOfIndex = function (e) {
                if (!(e < this.count && e > -1)) return -1;
                for (delete this.items[this._keys[e]]; e < this.count; ) (this._keys[e] = this._keys[e + 1]), e++;
                return --this.count;
            }),
            (e.prototype.indexOf = function (e) {
                for (var t = 0; t !== this.count; t++) if (this._keys[t] === e) return t;
                return -1;
            }),
            (e.prototype.item = function (e) {
                return this.items[e];
            }),
            (e.prototype.getAllKeys = function () {
                if (this.count > 0) {
                    for (var e = new Array(this.count), t = 0; t < this.count; t++) e[t] = this._keys[t];
                    return e;
                }
                return void 0;
            }),
            (e.prototype.getKeyByIndex = function (e) {
                return e < this.count && e > -1 ? this._keys[e] : void 0;
            }),
            (e.prototype.getItemByIndex = function (e) {
                return e < this.count && e > -1 ? this.items[this._keys[e]] : void 0;
            }),
            (e.prototype.empty = function () {
                this.count > 0 && ((this.count = 0), (this.items = {}), (this._keys = new Array(this._initialCapacity)));
            }),
            (e.prototype.forEach = function (e) {
                var t;
                for (t in this.items) this.items.hasOwnProperty(t) && e(this.items[t]);
            }),
            e
        );
    })();
    e.SmartCollection = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t,
        i = function (t, i) {
            return t ? (t instanceof e.Mesh ? null : t instanceof e.SubMesh ? t.clone(i) : t.clone ? t.clone() : null) : null;
        },
        r = (function () {
            function r() {}
            return (
                (r.ToHex = function (e) {
                    var t = e.toString(16);
                    return 15 >= e ? ("0" + t).toUpperCase() : t.toUpperCase();
                }),
                (r.SetImmediate = function (e) {
                    window.setImmediate ? window.setImmediate(e) : setTimeout(e, 1);
                }),
                (r.IsExponantOfTwo = function (e) {
                    var t = 1;
                    do t *= 2;
                    while (e > t);
                    return t === e;
                }),
                (r.GetExponantOfTwo = function (e, t) {
                    var i = 1;
                    do i *= 2;
                    while (e > i);
                    return i > t && (i = t), i;
                }),
                (r.GetFilename = function (e) {
                    var t = e.lastIndexOf("/");
                    return 0 > t ? e : e.substring(t + 1);
                }),
                (r.GetDOMTextContent = function (e) {
                    for (var t = "", i = e.firstChild; i; ) 3 === i.nodeType && (t += i.textContent), (i = i.nextSibling);
                    return t;
                }),
                (r.ToDegrees = function (e) {
                    return (180 * e) / Math.PI;
                }),
                (r.ToRadians = function (e) {
                    return (e * Math.PI) / 180;
                }),
                (r.ExtractMinAndMaxIndexed = function (t, i, r, n) {
                    for (var o = new e.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE), s = new e.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE), a = r; r + n > a; a++) {
                        var h = new e.Vector3(t[3 * i[a]], t[3 * i[a] + 1], t[3 * i[a] + 2]);
                        (o = e.Vector3.Minimize(h, o)), (s = e.Vector3.Maximize(h, s));
                    }
                    return { minimum: o, maximum: s };
                }),
                (r.ExtractMinAndMax = function (t, i, r) {
                    for (var n = new e.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE), o = new e.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE), s = i; i + r > s; s++) {
                        var a = new e.Vector3(t[3 * s], t[3 * s + 1], t[3 * s + 2]);
                        (n = e.Vector3.Minimize(a, n)), (o = e.Vector3.Maximize(a, o));
                    }
                    return { minimum: n, maximum: o };
                }),
                (r.MakeArray = function (e, t) {
                    return t === !0 || (void 0 !== e && null != e) ? (Array.isArray(e) ? e : [e]) : void 0;
                }),
                (r.GetPointerPrefix = function () {
                    var e = "pointer";
                    return navigator.pointerEnabled || (e = "mouse"), e;
                }),
                (r.QueueNewFrame = function (e) {
                    window.requestAnimationFrame
                        ? window.requestAnimationFrame(e)
                        : window.msRequestAnimationFrame
                        ? window.msRequestAnimationFrame(e)
                        : window.webkitRequestAnimationFrame
                        ? window.webkitRequestAnimationFrame(e)
                        : window.mozRequestAnimationFrame
                        ? window.mozRequestAnimationFrame(e)
                        : window.oRequestAnimationFrame
                        ? window.oRequestAnimationFrame(e)
                        : window.setTimeout(e, 16);
                }),
                (r.RequestFullscreen = function (e) {
                    e.requestFullscreen ? e.requestFullscreen() : e.msRequestFullscreen ? e.msRequestFullscreen() : e.webkitRequestFullscreen ? e.webkitRequestFullscreen() : e.mozRequestFullScreen && e.mozRequestFullScreen();
                }),
                (r.ExitFullscreen = function () {
                    document.exitFullscreen
                        ? document.exitFullscreen()
                        : document.mozCancelFullScreen
                        ? document.mozCancelFullScreen()
                        : document.webkitCancelFullScreen
                        ? document.webkitCancelFullScreen()
                        : document.msCancelFullScreen && document.msCancelFullScreen();
                }),
                (r.CleanUrl = function (e) {
                    return (e = e.replace(/#/gm, "%23"));
                }),
                (r.LoadImage = function (t, i, n, o) {
                    t = r.CleanUrl(t);
                    var s = new Image();
                    "data:" !== t.substr(0, 5) && (s.crossOrigin = "anonymous"),
                        (s.onload = function () {
                            i(s);
                        }),
                        (s.onerror = function (e) {
                            r.Error("Error while trying to load texture: " + t),
                                (s.src =
                                    "data:image/jpg;base64,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"),
                                i(s);
                        });
                    var a = function () {
                            s.src = t;
                        },
                        h = function () {
                            o.loadImageFromDB(t, s);
                        };
                    if (o && o.enableTexturesOffline && e.Database.IsUASupportingBlobStorage) o.openAsync(h, a);
                    else if (-1 === t.indexOf("file:")) a();
                    else
                        try {
                            var l,
                                c = t.substring(5);
                            try {
                                l = URL.createObjectURL(e.FilesInput.FilesTextures[c], { oneTimeOnly: !0 });
                            } catch (u) {
                                l = URL.createObjectURL(e.FilesInput.FilesTextures[c]);
                            }
                            s.src = l;
                        } catch (f) {
                            s.src = null;
                        }
                    return s;
                }),
                (r.LoadFile = function (t, i, n, o, s, a) {
                    t = r.CleanUrl(t);
                    var h = function () {
                            var e = new XMLHttpRequest(),
                                o = r.BaseUrl + t;
                            e.open("GET", o, !0),
                                s && (e.responseType = "arraybuffer"),
                                (e.onprogress = n),
                                (e.onreadystatechange = function () {
                                    if (4 === e.readyState)
                                        if (200 === e.status || r.ValidateXHRData(e, s ? 6 : 1)) i(s ? e.response : e.responseText);
                                        else {
                                            if (!a) throw new Error("Error status: " + e.status + " - Unable to load " + o);
                                            a();
                                        }
                                }),
                                e.send(null);
                        },
                        l = function () {
                            o.loadFileFromDB(t, i, n, h, s);
                        };
                    if (-1 !== t.indexOf("file:")) {
                        var c = t.substring(5);
                        r.ReadFile(e.FilesInput.FilesToLoad[c], i, n, !0);
                    } else o && o.enableSceneOffline ? o.openAsync(l, h) : h();
                }),
                (r.ReadFileAsDataURL = function (e, t, i) {
                    var r = new FileReader();
                    (r.onload = function (e) {
                        t(e.target.result);
                    }),
                        (r.onprogress = i),
                        r.readAsDataURL(e);
                }),
                (r.ReadFile = function (e, t, i, n) {
                    var o = new FileReader();
                    (o.onerror = function (i) {
                        r.Log("Error while reading file: " + e.name), t(JSON.stringify({ autoClear: !0, clearColor: [1, 0, 0], ambientColor: [0, 0, 0], gravity: [0, -9.807, 0], meshes: [], cameras: [], lights: [] }));
                    }),
                        (o.onload = function (e) {
                            t(e.target.result);
                        }),
                        (o.onprogress = i),
                        n ? o.readAsArrayBuffer(e) : o.readAsText(e);
                }),
                (r.Clamp = function (e, t, i) {
                    return void 0 === t && (t = 0), void 0 === i && (i = 1), Math.min(i, Math.max(t, e));
                }),
                (r.Sign = function (e) {
                    return (e = +e), 0 === e || isNaN(e) ? e : e > 0 ? 1 : -1;
                }),
                (r.Format = function (e, t) {
                    return void 0 === t && (t = 2), e.toFixed(t);
                }),
                (r.CheckExtends = function (e, t, i) {
                    e.x < t.x && (t.x = e.x), e.y < t.y && (t.y = e.y), e.z < t.z && (t.z = e.z), e.x > i.x && (i.x = e.x), e.y > i.y && (i.y = e.y), e.z > i.z && (i.z = e.z);
                }),
                (r.WithinEpsilon = function (e, t, i) {
                    void 0 === i && (i = 1.401298e-45);
                    var r = e - t;
                    return r >= -i && i >= r;
                }),
                (r.DeepCopy = function (e, t, r, n) {
                    for (var o in e)
                        if (("_" !== o[0] || (n && -1 !== n.indexOf(o))) && (!r || -1 === r.indexOf(o))) {
                            var s = e[o],
                                a = typeof s;
                            if ("function" !== a)
                                if ("object" === a)
                                    if (s instanceof Array) {
                                        if (((t[o] = []), s.length > 0))
                                            if ("object" == typeof s[0])
                                                for (var h = 0; h < s.length; h++) {
                                                    var l = i(s[h], t);
                                                    -1 === t[o].indexOf(l) && t[o].push(l);
                                                }
                                            else t[o] = s.slice(0);
                                    } else t[o] = i(s, t);
                                else t[o] = s;
                        }
                }),
                (r.IsEmpty = function (e) {
                    for (var t in e) return !1;
                    return !0;
                }),
                (r.RegisterTopRootEvents = function (e) {
                    for (var t = 0; t < e.length; t++) {
                        var i = e[t];
                        window.addEventListener(i.name, i.handler, !1);
                        try {
                            window.parent && window.parent.addEventListener(i.name, i.handler, !1);
                        } catch (r) {}
                    }
                }),
                (r.UnregisterTopRootEvents = function (e) {
                    for (var t = 0; t < e.length; t++) {
                        var i = e[t];
                        window.removeEventListener(i.name, i.handler);
                        try {
                            window.parent && window.parent.removeEventListener(i.name, i.handler);
                        } catch (r) {}
                    }
                }),
                (r.DumpFramebuffer = function (e, i, r, n) {
                    for (var o = 4 * e, s = i / 2, a = r.readPixels(0, 0, e, i), h = 0; s > h; h++)
                        for (var l = 0; o > l; l++) {
                            var c = l + h * o,
                                u = i - h - 1,
                                f = l + u * o,
                                d = a[c];
                            (a[c] = a[f]), (a[f] = d);
                        }
                    t || (t = document.createElement("canvas")), (t.width = e), (t.height = i);
                    var p = t.getContext("2d"),
                        m = p.createImageData(e, i),
                        g = m.data;
                    g.set(a), p.putImageData(m, 0, 0);
                    var _ = t.toDataURL();
                    if (n) n(_);
                    else if ("download" in document.createElement("a")) {
                        var v = window.document.createElement("a");
                        v.href = _;
                        var y = new Date(),
                            x = y.getFullYear() + "-" + y.getMonth() + "-" + y.getDate() + "_" + y.getHours() + "-" + ("0" + y.getMinutes()).slice(-2);
                        v.setAttribute("download", "screenshot_" + x + ".png"),
                            window.document.body.appendChild(v),
                            v.addEventListener("click", function () {
                                v.parentElement.removeChild(v);
                            }),
                            v.click();
                    } else {
                        var M = window.open(""),
                            S = M.document.createElement("img");
                        (S.src = _), M.document.body.appendChild(S);
                    }
                }),
                (r.CreateScreenshot = function (t, i, n, o) {
                    var s, a;
                    if (n.precision) (s = Math.round(t.getRenderWidth() * n.precision)), (a = Math.round(s / t.getAspectRatio(i))), (n = { width: s, height: a });
                    else if (n.width && n.height) (s = n.width), (a = n.height);
                    else if (n.width && !n.height) (s = n.width), (a = Math.round(s / t.getAspectRatio(i))), (n = { width: s, height: a });
                    else if (n.height && !n.width) (a = n.height), (s = Math.round(a * t.getAspectRatio(i))), (n = { width: s, height: a });
                    else {
                        if (isNaN(n)) return void r.Error("Invalid 'size' parameter !");
                        (a = n), (s = n);
                    }
                    var h = i.getScene(),
                        l = null;
                    h.activeCamera !== i && ((l = h.activeCamera), (h.activeCamera = i));
                    var c = new e.RenderTargetTexture("screenShot", n, h, !1, !1);
                    (c.renderList = h.meshes),
                        (c.onAfterRender = function () {
                            r.DumpFramebuffer(s, a, t, o);
                        }),
                        h.incrementRenderId(),
                        c.render(!0),
                        c.dispose(),
                        l && (h.activeCamera = l);
                }),
                (r.ValidateXHRData = function (t, i) {
                    void 0 === i && (i = 7);
                    try {
                        if (1 & i) {
                            if (t.responseText && t.responseText.length > 0) return !0;
                            if (1 === i) return !1;
                        }
                        if (2 & i) {
                            var r = e.Internals.TGATools.GetTGAHeader(t.response);
                            if (r.width && r.height && r.width > 0 && r.height > 0) return !0;
                            if (2 === i) return !1;
                        }
                        if (4 & i) {
                            var n = new Uint8Array(t.response, 0, 3);
                            return 68 === n[0] && 68 === n[1] && 83 === n[2] ? !0 : !1;
                        }
                    } catch (o) {}
                    return !1;
                }),
                Object.defineProperty(r, "NoneLogLevel", {
                    get: function () {
                        return r._NoneLogLevel;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(r, "MessageLogLevel", {
                    get: function () {
                        return r._MessageLogLevel;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(r, "WarningLogLevel", {
                    get: function () {
                        return r._WarningLogLevel;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(r, "ErrorLogLevel", {
                    get: function () {
                        return r._ErrorLogLevel;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(r, "AllLogLevel", {
                    get: function () {
                        return r._MessageLogLevel | r._WarningLogLevel | r._ErrorLogLevel;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                (r._AddLogEntry = function (e) {
                    (r._LogCache = e + r._LogCache), r.OnNewCacheEntry && r.OnNewCacheEntry(e);
                }),
                (r._FormatMessage = function (e) {
                    var t = function (e) {
                            return 10 > e ? "0" + e : "" + e;
                        },
                        i = new Date();
                    return "[" + t(i.getHours()) + ":" + t(i.getMinutes()) + ":" + t(i.getSeconds()) + "]: " + e;
                }),
                (r._LogDisabled = function (e) {}),
                (r._LogEnabled = function (e) {
                    var t = r._FormatMessage(e);
                    console.log("BJS - " + t);
                    var i = "<div style='color:white'>" + t + "</div><br>";
                    r._AddLogEntry(i);
                }),
                (r._WarnDisabled = function (e) {}),
                (r._WarnEnabled = function (e) {
                    var t = r._FormatMessage(e);
                    console.warn("BJS - " + t);
                    var i = "<div style='color:orange'>" + t + "</div><br>";
                    r._AddLogEntry(i);
                }),
                (r._ErrorDisabled = function (e) {}),
                (r._ErrorEnabled = function (e) {
                    r.errorsCount++;
                    var t = r._FormatMessage(e);
                    console.error("BJS - " + t);
                    var i = "<div style='color:red'>" + t + "</div><br>";
                    r._AddLogEntry(i);
                }),
                Object.defineProperty(r, "LogCache", {
                    get: function () {
                        return r._LogCache;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                (r.ClearLogCache = function () {
                    (r._LogCache = ""), (r.errorsCount = 0);
                }),
                Object.defineProperty(r, "LogLevels", {
                    set: function (e) {
                        (r.Log = (e & r.MessageLogLevel) === r.MessageLogLevel ? r._LogEnabled : r._LogDisabled),
                            (r.Warn = (e & r.WarningLogLevel) === r.WarningLogLevel ? r._WarnEnabled : r._WarnDisabled),
                            (r.Error = (e & r.ErrorLogLevel) === r.ErrorLogLevel ? r._ErrorEnabled : r._ErrorDisabled);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(r, "PerformanceNoneLogLevel", {
                    get: function () {
                        return r._PerformanceNoneLogLevel;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(r, "PerformanceUserMarkLogLevel", {
                    get: function () {
                        return r._PerformanceUserMarkLogLevel;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(r, "PerformanceConsoleLogLevel", {
                    get: function () {
                        return r._PerformanceConsoleLogLevel;
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(r, "PerformanceLogLevel", {
                    set: function (e) {
                        return (e & r.PerformanceUserMarkLogLevel) === r.PerformanceUserMarkLogLevel
                            ? ((r.StartPerformanceCounter = r._StartUserMark), void (r.EndPerformanceCounter = r._EndUserMark))
                            : (e & r.PerformanceConsoleLogLevel) === r.PerformanceConsoleLogLevel
                            ? ((r.StartPerformanceCounter = r._StartPerformanceConsole), void (r.EndPerformanceCounter = r._EndPerformanceConsole))
                            : ((r.StartPerformanceCounter = r._StartPerformanceCounterDisabled), void (r.EndPerformanceCounter = r._EndPerformanceCounterDisabled));
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                (r._StartPerformanceCounterDisabled = function (e, t) {}),
                (r._EndPerformanceCounterDisabled = function (e, t) {}),
                (r._StartUserMark = function (e, t) {
                    void 0 === t && (t = !0), t && r._performance.mark && r._performance.mark(e + "-Begin");
                }),
                (r._EndUserMark = function (e, t) {
                    void 0 === t && (t = !0), t && r._performance.mark && (r._performance.mark(e + "-End"), r._performance.measure(e, e + "-Begin", e + "-End"));
                }),
                (r._StartPerformanceConsole = function (e, t) {
                    void 0 === t && (t = !0), t && (r._StartUserMark(e, t), console.time && console.time(e));
                }),
                (r._EndPerformanceConsole = function (e, t) {
                    void 0 === t && (t = !0), t && (r._EndUserMark(e, t), console.time && console.timeEnd(e));
                }),
                Object.defineProperty(r, "Now", {
                    get: function () {
                        return window.performance && window.performance.now ? window.performance.now() : new Date().getTime();
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                (r.GetFps = function () {
                    return r.Warn("Tools.GetFps() is deprecated. Please use engine.getFps() instead"), 0;
                }),
                (r.BaseUrl = ""),
                (r._NoneLogLevel = 0),
                (r._MessageLogLevel = 1),
                (r._WarningLogLevel = 2),
                (r._ErrorLogLevel = 4),
                (r._LogCache = ""),
                (r.errorsCount = 0),
                (r.Log = r._LogEnabled),
                (r.Warn = r._WarnEnabled),
                (r.Error = r._ErrorEnabled),
                (r._PerformanceNoneLogLevel = 0),
                (r._PerformanceUserMarkLogLevel = 1),
                (r._PerformanceConsoleLogLevel = 2),
                (r._performance = window.performance),
                (r.StartPerformanceCounter = r._StartPerformanceCounterDisabled),
                (r.EndPerformanceCounter = r._EndPerformanceCounterDisabled),
                r
            );
        })();
    e.Tools = r;
    var n = (function () {
        function e(e, t, i, r) {
            void 0 === r && (r = 0), (this.iterations = e), (this._fn = t), (this._successCallback = i), (this.index = r - 1), (this._done = !1);
        }
        return (
            (e.prototype.executeNext = function () {
                this._done || (this.index + 1 < this.iterations ? (++this.index, this._fn(this)) : this.breakLoop());
            }),
            (e.prototype.breakLoop = function () {
                (this._done = !0), this._successCallback();
            }),
            (e.Run = function (t, i, r, n) {
                void 0 === n && (n = 0);
                var o = new e(t, i, r, n);
                return o.executeNext(), o;
            }),
            (e.SyncAsyncForLoop = function (t, i, r, n, o, s) {
                void 0 === s && (s = 0),
                    e.Run(
                        Math.ceil(t / i),
                        function (e) {
                            o && o()
                                ? e.breakLoop()
                                : setTimeout(function () {
                                      for (var n = 0; i > n; ++n) {
                                          var s = e.index * i + n;
                                          if (s >= t) break;
                                          if ((r(s), o && o())) {
                                              e.breakLoop();
                                              break;
                                          }
                                      }
                                      e.executeNext();
                                  }, s);
                        },
                        n
                    );
            }),
            e
        );
    })();
    e.AsyncLoop = n;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e() {
            (this._isDepthTestDirty = !1), (this._isDepthMaskDirty = !1), (this._isDepthFuncDirty = !1), (this._isCullFaceDirty = !1), (this._isCullDirty = !1), (this._isZOffsetDirty = !1);
        }
        return (
            Object.defineProperty(e.prototype, "isDirty", {
                get: function () {
                    return this._isDepthFuncDirty || this._isDepthTestDirty || this._isDepthMaskDirty || this._isCullFaceDirty || this._isCullDirty || this._isZOffsetDirty;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e.prototype, "zOffset", {
                get: function () {
                    return this._zOffset;
                },
                set: function (e) {
                    this._zOffset !== e && ((this._zOffset = e), (this._isZOffsetDirty = !0));
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e.prototype, "cullFace", {
                get: function () {
                    return this._cullFace;
                },
                set: function (e) {
                    this._cullFace !== e && ((this._cullFace = e), (this._isCullFaceDirty = !0));
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e.prototype, "cull", {
                get: function () {
                    return this._cull;
                },
                set: function (e) {
                    this._cull !== e && ((this._cull = e), (this._isCullDirty = !0));
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e.prototype, "depthFunc", {
                get: function () {
                    return this._depthFunc;
                },
                set: function (e) {
                    this._depthFunc !== e && ((this._depthFunc = e), (this._isDepthFuncDirty = !0));
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e.prototype, "depthMask", {
                get: function () {
                    return this._depthMask;
                },
                set: function (e) {
                    this._depthMask !== e && ((this._depthMask = e), (this._isDepthMaskDirty = !0));
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e.prototype, "depthTest", {
                get: function () {
                    return this._depthTest;
                },
                set: function (e) {
                    this._depthTest !== e && ((this._depthTest = e), (this._isDepthTestDirty = !0));
                },
                enumerable: !0,
                configurable: !0,
            }),
            (e.prototype.reset = function () {
                (this._depthMask = !0),
                    (this._depthTest = !0),
                    (this._depthFunc = null),
                    (this._cull = null),
                    (this._cullFace = null),
                    (this._zOffset = 0),
                    (this._isDepthTestDirty = !0),
                    (this._isDepthMaskDirty = !0),
                    (this._isDepthFuncDirty = !1),
                    (this._isCullFaceDirty = !1),
                    (this._isCullDirty = !1),
                    (this._isZOffsetDirty = !1);
            }),
            (e.prototype.apply = function (e) {
                this.isDirty &&
                    (this._isCullDirty && (this.cull ? e.enable(e.CULL_FACE) : e.disable(e.CULL_FACE), (this._isCullDirty = !1)),
                    this._isCullFaceDirty && (e.cullFace(this.cullFace), (this._isCullFaceDirty = !1)),
                    this._isDepthMaskDirty && (e.depthMask(this.depthMask), (this._isDepthMaskDirty = !1)),
                    this._isDepthTestDirty && (this.depthTest ? e.enable(e.DEPTH_TEST) : e.disable(e.DEPTH_TEST), (this._isDepthTestDirty = !1)),
                    this._isDepthFuncDirty && (e.depthFunc(this.depthFunc), (this._isDepthFuncDirty = !1)),
                    this._isZOffsetDirty && (this.zOffset ? (e.enable(e.POLYGON_OFFSET_FILL), e.polygonOffset(this.zOffset, 0)) : e.disable(e.POLYGON_OFFSET_FILL), (this._isZOffsetDirty = !1)));
            }),
            e
        );
    })();
    e._DepthCullingState = t;
    var i = (function () {
        function e() {
            (this._isAlphaBlendDirty = !1), (this._isBlendFunctionParametersDirty = !1), (this._alphaBlend = !1), (this._blendFunctionParameters = new Array(4));
        }
        return (
            Object.defineProperty(e.prototype, "isDirty", {
                get: function () {
                    return this._isAlphaBlendDirty || this._isBlendFunctionParametersDirty;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e.prototype, "alphaBlend", {
                get: function () {
                    return this._alphaBlend;
                },
                set: function (e) {
                    this._alphaBlend !== e && ((this._alphaBlend = e), (this._isAlphaBlendDirty = !0));
                },
                enumerable: !0,
                configurable: !0,
            }),
            (e.prototype.setAlphaBlendFunctionParameters = function (e, t, i, r) {
                (this._blendFunctionParameters[0] !== e || this._blendFunctionParameters[1] !== t || this._blendFunctionParameters[2] !== i || this._blendFunctionParameters[3] !== r) &&
                    ((this._blendFunctionParameters[0] = e), (this._blendFunctionParameters[1] = t), (this._blendFunctionParameters[2] = i), (this._blendFunctionParameters[3] = r), (this._isBlendFunctionParametersDirty = !0));
            }),
            (e.prototype.reset = function () {
                (this._alphaBlend = !1),
                    (this._blendFunctionParameters[0] = null),
                    (this._blendFunctionParameters[1] = null),
                    (this._blendFunctionParameters[2] = null),
                    (this._blendFunctionParameters[3] = null),
                    (this._isAlphaBlendDirty = !0),
                    (this._isBlendFunctionParametersDirty = !1);
            }),
            (e.prototype.apply = function (e) {
                this.isDirty &&
                    (this._isAlphaBlendDirty && (this._alphaBlend ? e.enable(e.BLEND) : e.disable(e.BLEND), (this._isAlphaBlendDirty = !1)),
                    this._isBlendFunctionParametersDirty &&
                        (e.blendFuncSeparate(this._blendFunctionParameters[0], this._blendFunctionParameters[1], this._blendFunctionParameters[2], this._blendFunctionParameters[3]), (this._isBlendFunctionParametersDirty = !1)));
            }),
            e
        );
    })();
    e._AlphaState = i;
    var r = function (e, t, i, r) {
            var n = e.createShader("vertex" === i ? e.VERTEX_SHADER : e.FRAGMENT_SHADER);
            if ((e.shaderSource(n, (r ? r + "\n" : "") + t), e.compileShader(n), !e.getShaderParameter(n, e.COMPILE_STATUS))) throw new Error(e.getShaderInfoLog(n));
            return n;
        },
        n = function (e, t) {
            var i = e.UNSIGNED_BYTE;
            return t === c.TEXTURETYPE_FLOAT && (i = e.FLOAT), i;
        },
        o = function (t, i, r) {
            var n = r.NEAREST,
                o = r.NEAREST;
            return (
                t === e.Texture.BILINEAR_SAMPLINGMODE
                    ? ((n = r.LINEAR), (o = i ? r.LINEAR_MIPMAP_NEAREST : r.LINEAR))
                    : t === e.Texture.TRILINEAR_SAMPLINGMODE
                    ? ((n = r.LINEAR), (o = i ? r.LINEAR_MIPMAP_LINEAR : r.LINEAR))
                    : t === e.Texture.NEAREST_SAMPLINGMODE && ((n = r.NEAREST), (o = i ? r.NEAREST_MIPMAP_LINEAR : r.NEAREST)),
                { min: o, mag: n }
            );
        },
        s = function (t, i, r, n, s, a, h, l, c, u) {
            void 0 === u && (u = e.Texture.TRILINEAR_SAMPLINGMODE);
            var f = r.getEngine(),
                d = e.Tools.GetExponantOfTwo(n, f.getCaps().maxTextureSize),
                p = e.Tools.GetExponantOfTwo(s, f.getCaps().maxTextureSize);
            i.bindTexture(i.TEXTURE_2D, t), i.pixelStorei(i.UNPACK_FLIP_Y_WEBGL, void 0 === a ? 1 : a ? 1 : 0), (t._baseWidth = n), (t._baseHeight = s), (t._width = d), (t._height = p), (t.isReady = !0), c(d, p);
            var m = o(u, !h, i);
            i.texParameteri(i.TEXTURE_2D, i.TEXTURE_MAG_FILTER, m.mag),
                i.texParameteri(i.TEXTURE_2D, i.TEXTURE_MIN_FILTER, m.min),
                h || l || i.generateMipmap(i.TEXTURE_2D),
                i.bindTexture(i.TEXTURE_2D, null),
                (f._activeTexturesCache = []),
                r._removePendingData(t);
        },
        a = function (t, i, r, n, o) {
            var s = function () {
                    (r[i] = h), r._internalCount++, n._removePendingData(h), 6 === r._internalCount && o(r);
                },
                a = function () {
                    n._removePendingData(h);
                },
                h = e.Tools.LoadImage(t, s, a, n.database);
            n._addPendingData(h);
        },
        h = function (e, t, i, r) {
            var n = [];
            n._internalCount = 0;
            for (var o = 0; 6 > o; o++) a(e + r[o], o, n, t, i);
        },
        l = (function () {
            function e() {}
            return e;
        })();
    e.EngineCapabilities = l;
    var c = (function () {
        function a(r, n, o) {
            var s = this;
            (this.isFullscreen = !1),
                (this.isPointerLock = !1),
                (this.cullBackFaces = !0),
                (this.renderEvenInBackground = !0),
                (this.enableOfflineSupport = !0),
                (this.scenes = new Array()),
                (this._windowIsBackground = !1),
                (this._drawCalls = 0),
                (this._renderingQueueLaunched = !1),
                (this._activeRenderLoops = []),
                (this.fpsRange = 60),
                (this.previousFramesDuration = []),
                (this.fps = 60),
                (this.deltaTime = 0),
                (this._depthCullingState = new t()),
                (this._alphaState = new i()),
                (this._alphaMode = a.ALPHA_DISABLE),
                (this._loadedTexturesCache = new Array()),
                (this._activeTexturesCache = new Array()),
                (this._compiledEffects = {}),
                (this._uintIndicesCurrentlySet = !1),
                (this._renderingCanvas = r),
                (o = o || {}),
                (o.antialias = n),
                void 0 === o.preserveDrawingBuffer && (o.preserveDrawingBuffer = !1);
            try {
                this._gl = r.getContext("webgl", o) || r.getContext("experimental-webgl", o);
            } catch (h) {
                throw new Error("WebGL not supported");
            }
            if (!this._gl) throw new Error("WebGL not supported");
            (this._onBlur = function () {
                s._windowIsBackground = !0;
            }),
                (this._onFocus = function () {
                    s._windowIsBackground = !1;
                }),
                window.addEventListener("blur", this._onBlur),
                window.addEventListener("focus", this._onFocus),
                (this._hardwareScalingLevel = 1 / (window.devicePixelRatio || 1)),
                this.resize(),
                (this._caps = new l()),
                (this._caps.maxTexturesImageUnits = this._gl.getParameter(this._gl.MAX_TEXTURE_IMAGE_UNITS)),
                (this._caps.maxTextureSize = this._gl.getParameter(this._gl.MAX_TEXTURE_SIZE)),
                (this._caps.maxCubemapTextureSize = this._gl.getParameter(this._gl.MAX_CUBE_MAP_TEXTURE_SIZE)),
                (this._caps.maxRenderTextureSize = this._gl.getParameter(this._gl.MAX_RENDERBUFFER_SIZE)),
                (this._glVersion = this._gl.getParameter(this._gl.VERSION));
            var c = this._gl.getExtension("WEBGL_debug_renderer_info");
            if (
                (null != c && ((this._glRenderer = this._gl.getParameter(c.UNMASKED_RENDERER_WEBGL)), (this._glVendor = this._gl.getParameter(c.UNMASKED_VENDOR_WEBGL))),
                this._glVendor || (this._glVendor = "Unknown vendor"),
                this._glRenderer || (this._glRenderer = "Unknown renderer"),
                (this._caps.standardDerivatives = null !== this._gl.getExtension("OES_standard_derivatives")),
                (this._caps.s3tc = this._gl.getExtension("WEBGL_compressed_texture_s3tc")),
                (this._caps.textureFloat = null !== this._gl.getExtension("OES_texture_float")),
                (this._caps.textureAnisotropicFilterExtension =
                    this._gl.getExtension("EXT_texture_filter_anisotropic") || this._gl.getExtension("WEBKIT_EXT_texture_filter_anisotropic") || this._gl.getExtension("MOZ_EXT_texture_filter_anisotropic")),
                (this._caps.maxAnisotropy = this._caps.textureAnisotropicFilterExtension ? this._gl.getParameter(this._caps.textureAnisotropicFilterExtension.MAX_TEXTURE_MAX_ANISOTROPY_EXT) : 0),
                (this._caps.instancedArrays = this._gl.getExtension("ANGLE_instanced_arrays")),
                (this._caps.uintIndices = null !== this._gl.getExtension("OES_element_index_uint")),
                (this._caps.highPrecisionShaderSupported = !0),
                this._gl.getShaderPrecisionFormat)
            ) {
                var u = this._gl.getShaderPrecisionFormat(this._gl.FRAGMENT_SHADER, this._gl.HIGH_FLOAT);
                this._caps.highPrecisionShaderSupported = 0 != u.precision;
            }
            this.setDepthBuffer(!0),
                this.setDepthFunctionToLessOrEqual(),
                this.setDepthWrite(!0),
                (this._onFullscreenChange = function () {
                    void 0 !== document.fullscreen
                        ? (s.isFullscreen = document.fullscreen)
                        : void 0 !== document.mozFullScreen
                        ? (s.isFullscreen = document.mozFullScreen)
                        : void 0 !== document.webkitIsFullScreen
                        ? (s.isFullscreen = document.webkitIsFullScreen)
                        : void 0 !== document.msIsFullScreen && (s.isFullscreen = document.msIsFullScreen),
                        s.isFullscreen &&
                            s._pointerLockRequested &&
                            ((r.requestPointerLock = r.requestPointerLock || r.msRequestPointerLock || r.mozRequestPointerLock || r.webkitRequestPointerLock), r.requestPointerLock && r.requestPointerLock());
                }),
                document.addEventListener("fullscreenchange", this._onFullscreenChange, !1),
                document.addEventListener("mozfullscreenchange", this._onFullscreenChange, !1),
                document.addEventListener("webkitfullscreenchange", this._onFullscreenChange, !1),
                document.addEventListener("msfullscreenchange", this._onFullscreenChange, !1),
                (this._onPointerLockChange = function () {
                    s.isPointerLock = document.mozPointerLockElement === r || document.webkitPointerLockElement === r || document.msPointerLockElement === r || document.pointerLockElement === r;
                }),
                document.addEventListener("pointerlockchange", this._onPointerLockChange, !1),
                document.addEventListener("mspointerlockchange", this._onPointerLockChange, !1),
                document.addEventListener("mozpointerlockchange", this._onPointerLockChange, !1),
                document.addEventListener("webkitpointerlockchange", this._onPointerLockChange, !1),
                a.audioEngine || (a.audioEngine = new e.AudioEngine()),
                (this._loadingScreen = new e.DefaultLoadingScreen(this._renderingCanvas)),
                e.Tools.Log("Babylon.js engine (v" + a.Version + ") launched");
        }
        return (
            Object.defineProperty(a, "ALPHA_DISABLE", {
                get: function () {
                    return a._ALPHA_DISABLE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "ALPHA_ONEONE", {
                get: function () {
                    return a._ALPHA_ONEONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "ALPHA_ADD", {
                get: function () {
                    return a._ALPHA_ADD;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "ALPHA_COMBINE", {
                get: function () {
                    return a._ALPHA_COMBINE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "ALPHA_SUBTRACT", {
                get: function () {
                    return a._ALPHA_SUBTRACT;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "ALPHA_MULTIPLY", {
                get: function () {
                    return a._ALPHA_MULTIPLY;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "ALPHA_MAXIMIZED", {
                get: function () {
                    return a._ALPHA_MAXIMIZED;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "DELAYLOADSTATE_NONE", {
                get: function () {
                    return a._DELAYLOADSTATE_NONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "DELAYLOADSTATE_LOADED", {
                get: function () {
                    return a._DELAYLOADSTATE_LOADED;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "DELAYLOADSTATE_LOADING", {
                get: function () {
                    return a._DELAYLOADSTATE_LOADING;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "DELAYLOADSTATE_NOTLOADED", {
                get: function () {
                    return a._DELAYLOADSTATE_NOTLOADED;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "TEXTUREFORMAT_ALPHA", {
                get: function () {
                    return a._TEXTUREFORMAT_ALPHA;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "TEXTUREFORMAT_LUMINANCE", {
                get: function () {
                    return a._TEXTUREFORMAT_LUMINANCE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "TEXTUREFORMAT_LUMINANCE_ALPHA", {
                get: function () {
                    return a._TEXTUREFORMAT_LUMINANCE_ALPHA;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "TEXTUREFORMAT_RGB", {
                get: function () {
                    return a._TEXTUREFORMAT_RGB;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "TEXTUREFORMAT_RGBA", {
                get: function () {
                    return a._TEXTUREFORMAT_RGBA;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "TEXTURETYPE_UNSIGNED_INT", {
                get: function () {
                    return a._TEXTURETYPE_UNSIGNED_INT;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "TEXTURETYPE_FLOAT", {
                get: function () {
                    return a._TEXTURETYPE_FLOAT;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a, "Version", {
                get: function () {
                    return "2.3.0-alpha";
                },
                enumerable: !0,
                configurable: !0,
            }),
            (a.prototype._prepareWorkingCanvas = function () {
                this._workingCanvas || ((this._workingCanvas = document.createElement("canvas")), (this._workingContext = this._workingCanvas.getContext("2d")));
            }),
            (a.prototype.getGlInfo = function () {
                return { vendor: this._glVendor, renderer: this._glRenderer, version: this._glVersion };
            }),
            (a.prototype.getAspectRatio = function (e) {
                var t = e.viewport;
                return (this.getRenderWidth() * t.width) / (this.getRenderHeight() * t.height);
            }),
            (a.prototype.getRenderWidth = function () {
                return this._currentRenderTarget ? this._currentRenderTarget._width : this._renderingCanvas.width;
            }),
            (a.prototype.getRenderHeight = function () {
                return this._currentRenderTarget ? this._currentRenderTarget._height : this._renderingCanvas.height;
            }),
            (a.prototype.getRenderingCanvas = function () {
                return this._renderingCanvas;
            }),
            (a.prototype.getRenderingCanvasClientRect = function () {
                return this._renderingCanvas.getBoundingClientRect();
            }),
            (a.prototype.setHardwareScalingLevel = function (e) {
                (this._hardwareScalingLevel = e), this.resize();
            }),
            (a.prototype.getHardwareScalingLevel = function () {
                return this._hardwareScalingLevel;
            }),
            (a.prototype.getLoadedTexturesCache = function () {
                return this._loadedTexturesCache;
            }),
            (a.prototype.getCaps = function () {
                return this._caps;
            }),
            Object.defineProperty(a.prototype, "drawCalls", {
                get: function () {
                    return this._drawCalls;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (a.prototype.resetDrawCalls = function () {
                this._drawCalls = 0;
            }),
            (a.prototype.setDepthFunctionToGreater = function () {
                this._depthCullingState.depthFunc = this._gl.GREATER;
            }),
            (a.prototype.setDepthFunctionToGreaterOrEqual = function () {
                this._depthCullingState.depthFunc = this._gl.GEQUAL;
            }),
            (a.prototype.setDepthFunctionToLess = function () {
                this._depthCullingState.depthFunc = this._gl.LESS;
            }),
            (a.prototype.setDepthFunctionToLessOrEqual = function () {
                this._depthCullingState.depthFunc = this._gl.LEQUAL;
            }),
            (a.prototype.stopRenderLoop = function (e) {
                if (!e) return void (this._activeRenderLoops = []);
                var t = this._activeRenderLoops.indexOf(e);
                t >= 0 && this._activeRenderLoops.splice(t, 1);
            }),
            (a.prototype._renderLoop = function () {
                var t = this,
                    i = !0;
                if ((!this.renderEvenInBackground && this._windowIsBackground && (i = !1), i)) {
                    this.beginFrame();
                    for (var r = 0; r < this._activeRenderLoops.length; r++) {
                        var n = this._activeRenderLoops[r];
                        n();
                    }
                    this.endFrame();
                }
                this._activeRenderLoops.length > 0
                    ? e.Tools.QueueNewFrame(function () {
                          t._renderLoop();
                      })
                    : (this._renderingQueueLaunched = !1);
            }),
            (a.prototype.runRenderLoop = function (t) {
                var i = this;
                -1 === this._activeRenderLoops.indexOf(t) &&
                    (this._activeRenderLoops.push(t),
                    this._renderingQueueLaunched ||
                        ((this._renderingQueueLaunched = !0),
                        e.Tools.QueueNewFrame(function () {
                            i._renderLoop();
                        })));
            }),
            (a.prototype.switchFullscreen = function (t) {
                this.isFullscreen ? e.Tools.ExitFullscreen() : ((this._pointerLockRequested = t), e.Tools.RequestFullscreen(this._renderingCanvas));
            }),
            (a.prototype.clear = function (e, t, i) {
                this.applyStates(), this._gl.clearColor(e.r, e.g, e.b, void 0 !== e.a ? e.a : 1), this._depthCullingState.depthMask && this._gl.clearDepth(1);
                var r = 0;
                t && (r |= this._gl.COLOR_BUFFER_BIT), i && this._depthCullingState.depthMask && (r |= this._gl.DEPTH_BUFFER_BIT), this._gl.clear(r);
            }),
            (a.prototype.setViewport = function (e, t, i) {
                var r = t || (navigator.isCocoonJS ? window.innerWidth : this._renderingCanvas.width),
                    n = i || (navigator.isCocoonJS ? window.innerHeight : this._renderingCanvas.height),
                    o = e.x || 0,
                    s = e.y || 0;
                (this._cachedViewport = e), this._gl.viewport(o * r, s * n, r * e.width, n * e.height);
            }),
            (a.prototype.setDirectViewport = function (e, t, i, r) {
                (this._cachedViewport = null), this._gl.viewport(e, t, i, r);
            }),
            (a.prototype.beginFrame = function () {
                this._measureFps();
            }),
            (a.prototype.endFrame = function () {}),
            (a.prototype.resize = function () {
                var e = navigator.isCocoonJS ? window.innerWidth : this._renderingCanvas.clientWidth,
                    t = navigator.isCocoonJS ? window.innerHeight : this._renderingCanvas.clientHeight;
                this.setSize(e / this._hardwareScalingLevel, t / this._hardwareScalingLevel);
            }),
            (a.prototype.setSize = function (e, t) {
                (this._renderingCanvas.width = e), (this._renderingCanvas.height = t);
                for (var i = 0; i < this.scenes.length; i++)
                    for (var r = this.scenes[i], n = 0; n < r.cameras.length; n++) {
                        var o = r.cameras[n];
                        o._currentRenderId = 0;
                    }
            }),
            (a.prototype.bindFramebuffer = function (e) {
                this._currentRenderTarget = e;
                var t = this._gl;
                t.bindFramebuffer(t.FRAMEBUFFER, e._framebuffer), this._gl.viewport(0, 0, e._width, e._height), this.wipeCaches();
            }),
            (a.prototype.unBindFramebuffer = function (e) {
                if (((this._currentRenderTarget = null), e.generateMipMaps)) {
                    var t = this._gl;
                    t.bindTexture(t.TEXTURE_2D, e), t.generateMipmap(t.TEXTURE_2D), t.bindTexture(t.TEXTURE_2D, null);
                }
                this._gl.bindFramebuffer(this._gl.FRAMEBUFFER, null);
            }),
            (a.prototype.flushFramebuffer = function () {
                this._gl.flush();
            }),
            (a.prototype.restoreDefaultFramebuffer = function () {
                (this._currentRenderTarget = null), this._gl.bindFramebuffer(this._gl.FRAMEBUFFER, null), this.setViewport(this._cachedViewport), this.wipeCaches();
            }),
            (a.prototype._resetVertexBufferBinding = function () {
                this._gl.bindBuffer(this._gl.ARRAY_BUFFER, null), (this._cachedVertexBuffers = null);
            }),
            (a.prototype.createVertexBuffer = function (e) {
                var t = this._gl.createBuffer();
                return this._gl.bindBuffer(this._gl.ARRAY_BUFFER, t), this._gl.bufferData(this._gl.ARRAY_BUFFER, new Float32Array(e), this._gl.STATIC_DRAW), this._resetVertexBufferBinding(), (t.references = 1), t;
            }),
            (a.prototype.createDynamicVertexBuffer = function (e) {
                var t = this._gl.createBuffer();
                return this._gl.bindBuffer(this._gl.ARRAY_BUFFER, t), this._gl.bufferData(this._gl.ARRAY_BUFFER, e, this._gl.DYNAMIC_DRAW), this._resetVertexBufferBinding(), (t.references = 1), t;
            }),
            (a.prototype.updateDynamicVertexBuffer = function (e, t, i) {
                this._gl.bindBuffer(this._gl.ARRAY_BUFFER, e),
                    void 0 === i && (i = 0),
                    t instanceof Float32Array ? this._gl.bufferSubData(this._gl.ARRAY_BUFFER, i, t) : this._gl.bufferSubData(this._gl.ARRAY_BUFFER, i, new Float32Array(t)),
                    this._resetVertexBufferBinding();
            }),
            (a.prototype._resetIndexBufferBinding = function () {
                this._gl.bindBuffer(this._gl.ELEMENT_ARRAY_BUFFER, null), (this._cachedIndexBuffer = null);
            }),
            (a.prototype.createIndexBuffer = function (e) {
                var t = this._gl.createBuffer();
                this._gl.bindBuffer(this._gl.ELEMENT_ARRAY_BUFFER, t);
                var i,
                    r = !1;
                if (this._caps.uintIndices) {
                    for (var n = 0; n < e.length; n++)
                        if (e[n] > 65535) {
                            r = !0;
                            break;
                        }
                    i = r ? new Uint32Array(e) : new Uint16Array(e);
                } else i = new Uint16Array(e);
                return this._gl.bufferData(this._gl.ELEMENT_ARRAY_BUFFER, i, this._gl.STATIC_DRAW), this._resetIndexBufferBinding(), (t.references = 1), (t.is32Bits = r), t;
            }),
            (a.prototype.bindBuffers = function (e, t, i, r, n) {
                if (this._cachedVertexBuffers !== e || this._cachedEffectForVertexBuffers !== n) {
                    (this._cachedVertexBuffers = e), (this._cachedEffectForVertexBuffers = n), this._gl.bindBuffer(this._gl.ARRAY_BUFFER, e);
                    for (var o = 0, s = 0; s < i.length; s++) {
                        var a = n.getAttributeLocation(s);
                        a >= 0 && this._gl.vertexAttribPointer(a, i[s], this._gl.FLOAT, !1, r, o), (o += 4 * i[s]);
                    }
                }
                this._cachedIndexBuffer !== t && ((this._cachedIndexBuffer = t), this._gl.bindBuffer(this._gl.ELEMENT_ARRAY_BUFFER, t), (this._uintIndicesCurrentlySet = t.is32Bits));
            }),
            (a.prototype.bindMultiBuffers = function (e, t, i) {
                if (this._cachedVertexBuffers !== e || this._cachedEffectForVertexBuffers !== i) {
                    (this._cachedVertexBuffers = e), (this._cachedEffectForVertexBuffers = i);
                    for (var r = i.getAttributesNames(), n = 0; n < r.length; n++) {
                        var o = i.getAttributeLocation(n);
                        if (o >= 0) {
                            var s = e[r[n]];
                            if (!s) continue;
                            var a = s.getStrideSize();
                            this._gl.bindBuffer(this._gl.ARRAY_BUFFER, s.getBuffer()), this._gl.vertexAttribPointer(o, a, this._gl.FLOAT, !1, 4 * a, 0);
                        }
                    }
                }
                null != t && this._cachedIndexBuffer !== t && ((this._cachedIndexBuffer = t), this._gl.bindBuffer(this._gl.ELEMENT_ARRAY_BUFFER, t), (this._uintIndicesCurrentlySet = t.is32Bits));
            }),
            (a.prototype._releaseBuffer = function (e) {
                return e.references--, 0 === e.references ? (this._gl.deleteBuffer(e), !0) : !1;
            }),
            (a.prototype.createInstancesBuffer = function (e) {
                var t = this._gl.createBuffer();
                return (t.capacity = e), this._gl.bindBuffer(this._gl.ARRAY_BUFFER, t), this._gl.bufferData(this._gl.ARRAY_BUFFER, e, this._gl.DYNAMIC_DRAW), t;
            }),
            (a.prototype.deleteInstancesBuffer = function (e) {
                this._gl.deleteBuffer(e);
            }),
            (a.prototype.updateAndBindInstancesBuffer = function (e, t, i) {
                this._gl.bindBuffer(this._gl.ARRAY_BUFFER, e), this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, t);
                for (var r = 0; 4 > r; r++) {
                    var n = i[r];
                    this._gl.enableVertexAttribArray(n), this._gl.vertexAttribPointer(n, 4, this._gl.FLOAT, !1, 64, 16 * r), this._caps.instancedArrays.vertexAttribDivisorANGLE(n, 1);
                }
            }),
            (a.prototype.unBindInstancesBuffer = function (e, t) {
                this._gl.bindBuffer(this._gl.ARRAY_BUFFER, e);
                for (var i = 0; 4 > i; i++) {
                    var r = t[i];
                    this._gl.disableVertexAttribArray(r), this._caps.instancedArrays.vertexAttribDivisorANGLE(r, 0);
                }
            }),
            (a.prototype.applyStates = function () {
                this._depthCullingState.apply(this._gl), this._alphaState.apply(this._gl);
            }),
            (a.prototype.draw = function (e, t, i, r) {
                this.applyStates(), this._drawCalls++;
                var n = this._uintIndicesCurrentlySet ? this._gl.UNSIGNED_INT : this._gl.UNSIGNED_SHORT,
                    o = this._uintIndicesCurrentlySet ? 4 : 2;
                return r ? void this._caps.instancedArrays.drawElementsInstancedANGLE(e ? this._gl.TRIANGLES : this._gl.LINES, i, n, t * o, r) : void this._gl.drawElements(e ? this._gl.TRIANGLES : this._gl.LINES, i, n, t * o);
            }),
            (a.prototype.drawPointClouds = function (e, t, i) {
                return this.applyStates(), this._drawCalls++, i ? void this._caps.instancedArrays.drawArraysInstancedANGLE(this._gl.POINTS, e, t, i) : void this._gl.drawArrays(this._gl.POINTS, e, t);
            }),
            (a.prototype._releaseEffect = function (e) {
                this._compiledEffects[e._key] && (delete this._compiledEffects[e._key], e.getProgram() && this._gl.deleteProgram(e.getProgram()));
            }),
            (a.prototype.createEffect = function (t, i, r, n, o, s, a, h) {
                var l = t.vertexElement || t.vertex || t,
                    c = t.fragmentElement || t.fragment || t,
                    u = l + "+" + c + "@" + o;
                if (this._compiledEffects[u]) return this._compiledEffects[u];
                var f = new e.Effect(t, i, r, n, this, o, s, a, h);
                return (f._key = u), (this._compiledEffects[u] = f), f;
            }),
            (a.prototype.createEffectForParticles = function (e, t, i, r, n, o, s) {
                return (
                    void 0 === t && (t = []),
                    void 0 === i && (i = []),
                    void 0 === r && (r = ""),
                    this.createEffect({ vertex: "particles", fragmentElement: e }, ["position", "color", "options"], ["view", "projection"].concat(t), ["diffuseSampler"].concat(i), r, n, o, s)
                );
            }),
            (a.prototype.createShaderProgram = function (e, t, i) {
                var n = r(this._gl, e, "vertex", i),
                    o = r(this._gl, t, "fragment", i),
                    s = this._gl.createProgram();
                this._gl.attachShader(s, n), this._gl.attachShader(s, o), this._gl.linkProgram(s);
                var a = this._gl.getProgramParameter(s, this._gl.LINK_STATUS);
                if (!a) {
                    var h = this._gl.getProgramInfoLog(s);
                    if (h) throw new Error(h);
                }
                return this._gl.deleteShader(n), this._gl.deleteShader(o), s;
            }),
            (a.prototype.getUniforms = function (e, t) {
                for (var i = [], r = 0; r < t.length; r++) i.push(this._gl.getUniformLocation(e, t[r]));
                return i;
            }),
            (a.prototype.getAttributes = function (e, t) {
                for (var i = [], r = 0; r < t.length; r++)
                    try {
                        i.push(this._gl.getAttribLocation(e, t[r]));
                    } catch (n) {
                        i.push(-1);
                    }
                return i;
            }),
            (a.prototype.enableEffect = function (e) {
                if (!e || !e.getAttributesCount() || this._currentEffect === e) return void (e && e.onBind && e.onBind(e));
                (this._vertexAttribArrays = this._vertexAttribArrays || []), this._gl.useProgram(e.getProgram());
                for (var t in this._vertexAttribArrays) t > this._gl.VERTEX_ATTRIB_ARRAY_ENABLED || !this._vertexAttribArrays[t] || ((this._vertexAttribArrays[t] = !1), this._gl.disableVertexAttribArray(t));
                for (var i = e.getAttributesCount(), r = 0; i > r; r++) {
                    var n = e.getAttributeLocation(r);
                    n >= 0 && ((this._vertexAttribArrays[n] = !0), this._gl.enableVertexAttribArray(n));
                }
                (this._currentEffect = e), e.onBind && e.onBind(e);
            }),
            (a.prototype.setArray = function (e, t) {
                e && this._gl.uniform1fv(e, t);
            }),
            (a.prototype.setArray2 = function (e, t) {
                e && t.length % 2 === 0 && this._gl.uniform2fv(e, t);
            }),
            (a.prototype.setArray3 = function (e, t) {
                e && t.length % 3 === 0 && this._gl.uniform3fv(e, t);
            }),
            (a.prototype.setArray4 = function (e, t) {
                e && t.length % 4 === 0 && this._gl.uniform4fv(e, t);
            }),
            (a.prototype.setMatrices = function (e, t) {
                e && this._gl.uniformMatrix4fv(e, !1, t);
            }),
            (a.prototype.setMatrix = function (e, t) {
                e && this._gl.uniformMatrix4fv(e, !1, t.toArray());
            }),
            (a.prototype.setMatrix3x3 = function (e, t) {
                e && this._gl.uniformMatrix3fv(e, !1, t);
            }),
            (a.prototype.setMatrix2x2 = function (e, t) {
                e && this._gl.uniformMatrix2fv(e, !1, t);
            }),
            (a.prototype.setFloat = function (e, t) {
                e && this._gl.uniform1f(e, t);
            }),
            (a.prototype.setFloat2 = function (e, t, i) {
                e && this._gl.uniform2f(e, t, i);
            }),
            (a.prototype.setFloat3 = function (e, t, i, r) {
                e && this._gl.uniform3f(e, t, i, r);
            }),
            (a.prototype.setBool = function (e, t) {
                e && this._gl.uniform1i(e, t);
            }),
            (a.prototype.setFloat4 = function (e, t, i, r, n) {
                e && this._gl.uniform4f(e, t, i, r, n);
            }),
            (a.prototype.setColor3 = function (e, t) {
                e && this._gl.uniform3f(e, t.r, t.g, t.b);
            }),
            (a.prototype.setColor4 = function (e, t, i) {
                e && this._gl.uniform4f(e, t.r, t.g, t.b, i);
            }),
            (a.prototype.setState = function (e, t, i, r) {
                void 0 === t && (t = 0), void 0 === r && (r = !1);
                var n = r ? this._gl.FRONT : this._gl.BACK,
                    o = r ? this._gl.BACK : this._gl.FRONT,
                    s = this.cullBackFaces ? n : o;
                (this._depthCullingState.cull !== e || i || this._depthCullingState.cullFace != s) && (e ? ((this._depthCullingState.cullFace = s), (this._depthCullingState.cull = !0)) : (this._depthCullingState.cull = !1)),
                    (this._depthCullingState.zOffset = t);
            }),
            (a.prototype.setDepthBuffer = function (e) {
                this._depthCullingState.depthTest = e;
            }),
            (a.prototype.getDepthWrite = function () {
                return this._depthCullingState.depthMask;
            }),
            (a.prototype.setDepthWrite = function (e) {
                this._depthCullingState.depthMask = e;
            }),
            (a.prototype.setColorWrite = function (e) {
                this._gl.colorMask(e, e, e, e);
            }),
            (a.prototype.setAlphaMode = function (e) {
                if (this._alphaMode != e) {
                    switch (e) {
                        case a.ALPHA_DISABLE:
                            this.setDepthWrite(!0), (this._alphaState.alphaBlend = !1);
                            break;
                        case a.ALPHA_COMBINE:
                            this.setDepthWrite(!1), this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE_MINUS_SRC_ALPHA, this._gl.ONE, this._gl.ONE), (this._alphaState.alphaBlend = !0);
                            break;
                        case a.ALPHA_ONEONE:
                            this.setDepthWrite(!1), this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE, this._gl.ZERO, this._gl.ONE), (this._alphaState.alphaBlend = !0);
                            break;
                        case a.ALPHA_ADD:
                            this.setDepthWrite(!1), this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE, this._gl.ZERO, this._gl.ONE), (this._alphaState.alphaBlend = !0);
                            break;
                        case a.ALPHA_SUBTRACT:
                            this.setDepthWrite(!1), this._alphaState.setAlphaBlendFunctionParameters(this._gl.ZERO, this._gl.ONE_MINUS_SRC_COLOR, this._gl.ONE, this._gl.ONE), (this._alphaState.alphaBlend = !0);
                            break;
                        case a.ALPHA_MULTIPLY:
                            this.setDepthWrite(!1), this._alphaState.setAlphaBlendFunctionParameters(this._gl.DST_COLOR, this._gl.ZERO, this._gl.ONE, this._gl.ONE), (this._alphaState.alphaBlend = !0);
                            break;
                        case a.ALPHA_MAXIMIZED:
                            this.setDepthWrite(!1), this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE_MINUS_SRC_COLOR, this._gl.ONE, this._gl.ONE), (this._alphaState.alphaBlend = !0);
                    }
                    this._alphaMode = e;
                }
            }),
            (a.prototype.getAlphaMode = function () {
                return this._alphaMode;
            }),
            (a.prototype.setAlphaTesting = function (e) {
                this._alphaTest = e;
            }),
            (a.prototype.getAlphaTesting = function () {
                return this._alphaTest;
            }),
            (a.prototype.wipeCaches = function () {
                (this._activeTexturesCache = []),
                    (this._currentEffect = null),
                    this._depthCullingState.reset(),
                    this._alphaState.reset(),
                    (this._cachedVertexBuffers = null),
                    (this._cachedIndexBuffer = null),
                    (this._cachedEffectForVertexBuffers = null);
            }),
            (a.prototype.setSamplingMode = function (t, i) {
                var r = this._gl;
                r.bindTexture(r.TEXTURE_2D, t);
                var n = r.NEAREST,
                    o = r.NEAREST;
                i === e.Texture.BILINEAR_SAMPLINGMODE ? ((n = r.LINEAR), (o = r.LINEAR)) : i === e.Texture.TRILINEAR_SAMPLINGMODE && ((n = r.LINEAR), (o = r.LINEAR_MIPMAP_LINEAR)),
                    r.texParameteri(r.TEXTURE_2D, r.TEXTURE_MAG_FILTER, n),
                    r.texParameteri(r.TEXTURE_2D, r.TEXTURE_MIN_FILTER, o),
                    r.bindTexture(r.TEXTURE_2D, null),
                    (t.samplingMode = i);
            }),
            (a.prototype.createTexture = function (t, i, r, n, o, a, h, l) {
                var c = this;
                void 0 === o && (o = e.Texture.TRILINEAR_SAMPLINGMODE), void 0 === a && (a = null), void 0 === h && (h = null), void 0 === l && (l = null);
                var u,
                    f = this._gl.createTexture(),
                    d = !1;
                if (("data:" === t.substr(0, 5) && (d = !0), d)) {
                    var p = t;
                    (d = p.split(":")), (t = p), (u = d[1].substr(d[1].length - 4, 4).toLowerCase());
                } else u = t.substr(t.length - 4, 4).toLowerCase();
                var m = this.getCaps().s3tc && ".dds" === u,
                    g = ".tga" === u;
                n._addPendingData(f), (f.url = t), (f.noMipmap = i), (f.references = 1), (f.samplingMode = o), this._loadedTexturesCache.push(f);
                var _ = function () {
                    n._removePendingData(f), h && h();
                };
                if (g) {
                    var v = function (t) {
                        var h = new Uint8Array(t),
                            l = e.Internals.TGATools.GetTGAHeader(h);
                        s(
                            f,
                            c._gl,
                            n,
                            l.width,
                            l.height,
                            r,
                            i,
                            !1,
                            function () {
                                e.Internals.TGATools.UploadContent(c._gl, h), a && a();
                            },
                            o
                        );
                    };
                    d instanceof Array
                        ? v(l)
                        : e.Tools.LoadFile(
                              t,
                              function (e) {
                                  v(e);
                              },
                              _,
                              n.database,
                              !0
                          );
                } else if (m)
                    (v = function (t) {
                        var h = e.Internals.DDSTools.GetDDSInfo(t),
                            l = (h.isRGB || h.isLuminance || h.mipmapCount > 1) && !i && h.width >> (h.mipmapCount - 1) === 1;
                        s(
                            f,
                            c._gl,
                            n,
                            h.width,
                            h.height,
                            r,
                            !l,
                            h.isFourCC,
                            function () {
                                e.Internals.DDSTools.UploadDDSLevels(c._gl, c.getCaps().s3tc, t, h, l, 1), a && a();
                            },
                            o
                        );
                    }),
                        d instanceof Array
                            ? v(l)
                            : e.Tools.LoadFile(
                                  t,
                                  function (e) {
                                      v(e);
                                  },
                                  _,
                                  n.database,
                                  !0
                              );
                else {
                    var y = function (t) {
                        s(
                            f,
                            c._gl,
                            n,
                            t.width,
                            t.height,
                            r,
                            i,
                            !1,
                            function (i, r) {
                                var n = t.width === i && t.height === r;
                                n ||
                                    (c._prepareWorkingCanvas(),
                                    (c._workingCanvas.width = i),
                                    (c._workingCanvas.height = r),
                                    o === e.Texture.NEAREST_SAMPLINGMODE &&
                                        ((c._workingContext.imageSmoothingEnabled = !1),
                                        (c._workingContext.mozImageSmoothingEnabled = !1),
                                        (c._workingContext.oImageSmoothingEnabled = !1),
                                        (c._workingContext.webkitImageSmoothingEnabled = !1),
                                        (c._workingContext.msImageSmoothingEnabled = !1)),
                                    c._workingContext.drawImage(t, 0, 0, t.width, t.height, 0, 0, i, r),
                                    o === e.Texture.NEAREST_SAMPLINGMODE &&
                                        ((c._workingContext.imageSmoothingEnabled = !0),
                                        (c._workingContext.mozImageSmoothingEnabled = !0),
                                        (c._workingContext.oImageSmoothingEnabled = !0),
                                        (c._workingContext.webkitImageSmoothingEnabled = !0),
                                        (c._workingContext.msImageSmoothingEnabled = !0))),
                                    c._gl.texImage2D(c._gl.TEXTURE_2D, 0, c._gl.RGBA, c._gl.RGBA, c._gl.UNSIGNED_BYTE, n ? t : c._workingCanvas),
                                    a && a();
                            },
                            o
                        );
                    };
                    d instanceof Array ? e.Tools.LoadImage(l, y, _, n.database) : e.Tools.LoadImage(t, y, _, n.database);
                }
                return f;
            }),
            (a.prototype.updateRawTexture = function (e, t, i, r, n) {
                void 0 === n && (n = null);
                var o = this._gl.RGBA;
                switch (i) {
                    case a.TEXTUREFORMAT_ALPHA:
                        o = this._gl.ALPHA;
                        break;
                    case a.TEXTUREFORMAT_LUMINANCE:
                        o = this._gl.LUMINANCE;
                        break;
                    case a.TEXTUREFORMAT_LUMINANCE_ALPHA:
                        o = this._gl.LUMINANCE_ALPHA;
                        break;
                    case a.TEXTUREFORMAT_RGB:
                        o = this._gl.RGB;
                        break;
                    case a.TEXTUREFORMAT_RGBA:
                        o = this._gl.RGBA;
                }
                this._gl.bindTexture(this._gl.TEXTURE_2D, e),
                    this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, void 0 === r ? 1 : r ? 1 : 0),
                    n ? this._gl.compressedTexImage2D(this._gl.TEXTURE_2D, 0, this.getCaps().s3tc[n], e._width, e._height, 0, t) : this._gl.texImage2D(this._gl.TEXTURE_2D, 0, o, e._width, e._height, 0, o, this._gl.UNSIGNED_BYTE, t),
                    e.generateMipMaps && this._gl.generateMipmap(this._gl.TEXTURE_2D),
                    this._gl.bindTexture(this._gl.TEXTURE_2D, null),
                    (this._activeTexturesCache = []),
                    (e.isReady = !0);
            }),
            (a.prototype.createRawTexture = function (e, t, i, r, n, s, a, h) {
                void 0 === h && (h = null);
                var l = this._gl.createTexture();
                (l._baseWidth = t), (l._baseHeight = i), (l._width = t), (l._height = i), (l.references = 1), this.updateRawTexture(l, e, r, s, h), this._gl.bindTexture(this._gl.TEXTURE_2D, l);
                var c = o(a, n, this._gl);
                return (
                    this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MAG_FILTER, c.mag),
                    this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MIN_FILTER, c.min),
                    this._gl.bindTexture(this._gl.TEXTURE_2D, null),
                    (l.samplingMode = a),
                    this._loadedTexturesCache.push(l),
                    l
                );
            }),
            (a.prototype.createDynamicTexture = function (t, i, r, n, o) {
                void 0 === o && (o = !0);
                var s = this._gl.createTexture();
                return (
                    (s._baseWidth = t),
                    (s._baseHeight = i),
                    o && ((t = e.Tools.GetExponantOfTwo(t, this._caps.maxTextureSize)), (i = e.Tools.GetExponantOfTwo(i, this._caps.maxTextureSize))),
                    (this._activeTexturesCache = []),
                    (s._width = t),
                    (s._height = i),
                    (s.isReady = !1),
                    (s.generateMipMaps = r),
                    (s.references = 1),
                    (s.samplingMode = n),
                    this.updateTextureSamplingMode(n, s),
                    this._loadedTexturesCache.push(s),
                    s
                );
            }),
            (a.prototype.updateTextureSamplingMode = function (e, t) {
                var i = o(e, t.generateMipMaps, this._gl);
                this._gl.bindTexture(this._gl.TEXTURE_2D, t),
                    this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MAG_FILTER, i.mag),
                    this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MIN_FILTER, i.min),
                    this._gl.bindTexture(this._gl.TEXTURE_2D, null);
            }),
            (a.prototype.updateDynamicTexture = function (e, t, i) {
                this._gl.bindTexture(this._gl.TEXTURE_2D, e),
                    this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, i ? 1 : 0),
                    this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, t),
                    e.generateMipMaps && this._gl.generateMipmap(this._gl.TEXTURE_2D),
                    this._gl.bindTexture(this._gl.TEXTURE_2D, null),
                    (this._activeTexturesCache = []),
                    (e.isReady = !0);
            }),
            (a.prototype.updateVideoTexture = function (e, t, i) {
                if (!e._isDisabled) {
                    this._gl.bindTexture(this._gl.TEXTURE_2D, e), this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, i ? 0 : 1);
                    try {
                        void 0 === this._videoTextureSupported && (this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, t), (this._videoTextureSupported = 0 !== this._gl.getError() ? !1 : !0)),
                            this._videoTextureSupported
                                ? this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, t)
                                : (e._workingCanvas ||
                                      ((e._workingCanvas = document.createElement("canvas")), (e._workingContext = e._workingCanvas.getContext("2d")), (e._workingCanvas.width = e._width), (e._workingCanvas.height = e._height)),
                                  e._workingContext.drawImage(t, 0, 0, t.videoWidth, t.videoHeight, 0, 0, e._width, e._height),
                                  this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, e._workingCanvas)),
                            e.generateMipMaps && this._gl.generateMipmap(this._gl.TEXTURE_2D),
                            this._gl.bindTexture(this._gl.TEXTURE_2D, null),
                            (this._activeTexturesCache = []),
                            (e.isReady = !0);
                    } catch (r) {
                        e._isDisabled = !0;
                    }
                }
            }),
            (a.prototype.createRenderTargetTexture = function (t, i) {
                var r = !1,
                    s = !0,
                    h = a.TEXTURETYPE_UNSIGNED_INT,
                    l = e.Texture.TRILINEAR_SAMPLINGMODE;
                void 0 !== i &&
                    ((r = void 0 === i.generateMipMaps ? i : i.generateMipmaps),
                    (s = void 0 === i.generateDepthBuffer ? !0 : i.generateDepthBuffer),
                    (h = void 0 === i.type ? h : i.type),
                    void 0 !== i.samplingMode && (l = i.samplingMode),
                    h === a.TEXTURETYPE_FLOAT && (l = e.Texture.NEAREST_SAMPLINGMODE));
                var c = this._gl,
                    u = c.createTexture();
                c.bindTexture(c.TEXTURE_2D, u);
                var f = t.width || t,
                    d = t.height || t,
                    p = o(l, r, c);
                h !== a.TEXTURETYPE_FLOAT || this._caps.textureFloat || ((h = a.TEXTURETYPE_UNSIGNED_INT), e.Tools.Warn("Float textures are not supported. Render target forced to TEXTURETYPE_UNSIGNED_BYTE type")),
                    c.texParameteri(c.TEXTURE_2D, c.TEXTURE_MAG_FILTER, p.mag),
                    c.texParameteri(c.TEXTURE_2D, c.TEXTURE_MIN_FILTER, p.min),
                    c.texParameteri(c.TEXTURE_2D, c.TEXTURE_WRAP_S, c.CLAMP_TO_EDGE),
                    c.texParameteri(c.TEXTURE_2D, c.TEXTURE_WRAP_T, c.CLAMP_TO_EDGE),
                    c.texImage2D(c.TEXTURE_2D, 0, c.RGBA, f, d, 0, c.RGBA, n(c, h), null);
                var m;
                s && ((m = c.createRenderbuffer()), c.bindRenderbuffer(c.RENDERBUFFER, m), c.renderbufferStorage(c.RENDERBUFFER, c.DEPTH_COMPONENT16, f, d));
                var g = c.createFramebuffer();
                return (
                    c.bindFramebuffer(c.FRAMEBUFFER, g),
                    c.framebufferTexture2D(c.FRAMEBUFFER, c.COLOR_ATTACHMENT0, c.TEXTURE_2D, u, 0),
                    s && c.framebufferRenderbuffer(c.FRAMEBUFFER, c.DEPTH_ATTACHMENT, c.RENDERBUFFER, m),
                    r && this._gl.generateMipmap(this._gl.TEXTURE_2D),
                    c.bindTexture(c.TEXTURE_2D, null),
                    c.bindRenderbuffer(c.RENDERBUFFER, null),
                    c.bindFramebuffer(c.FRAMEBUFFER, null),
                    (u._framebuffer = g),
                    s && (u._depthBuffer = m),
                    (u._width = f),
                    (u._height = d),
                    (u.isReady = !0),
                    (u.generateMipMaps = r),
                    (u.references = 1),
                    (u.samplingMode = l),
                    (this._activeTexturesCache = []),
                    this._loadedTexturesCache.push(u),
                    u
                );
            }),
            (a.prototype.createCubeTexture = function (t, i, r, n) {
                var o = this,
                    s = this._gl,
                    a = s.createTexture();
                (a.isCube = !0), (a.url = t), (a.references = 1), this._loadedTexturesCache.push(a);
                var l = t.substr(t.length - 4, 4).toLowerCase(),
                    c = this.getCaps().s3tc && ".dds" === l;
                return (
                    c
                        ? e.Tools.LoadFile(
                              t,
                              function (t) {
                                  var i = e.Internals.DDSTools.GetDDSInfo(t),
                                      r = (i.isRGB || i.isLuminance || i.mipmapCount > 1) && !n;
                                  s.bindTexture(s.TEXTURE_CUBE_MAP, a),
                                      s.pixelStorei(s.UNPACK_FLIP_Y_WEBGL, 1),
                                      e.Internals.DDSTools.UploadDDSLevels(o._gl, o.getCaps().s3tc, t, i, r, 6),
                                      n || i.isFourCC || 1 !== i.mipmapCount || s.generateMipmap(s.TEXTURE_CUBE_MAP),
                                      s.texParameteri(s.TEXTURE_CUBE_MAP, s.TEXTURE_MAG_FILTER, s.LINEAR),
                                      s.texParameteri(s.TEXTURE_CUBE_MAP, s.TEXTURE_MIN_FILTER, r ? s.LINEAR_MIPMAP_LINEAR : s.LINEAR),
                                      s.texParameteri(s.TEXTURE_CUBE_MAP, s.TEXTURE_WRAP_S, s.CLAMP_TO_EDGE),
                                      s.texParameteri(s.TEXTURE_CUBE_MAP, s.TEXTURE_WRAP_T, s.CLAMP_TO_EDGE),
                                      s.bindTexture(s.TEXTURE_CUBE_MAP, null),
                                      (o._activeTexturesCache = []),
                                      (a._width = i.width),
                                      (a._height = i.height),
                                      (a.isReady = !0);
                              },
                              null,
                              null,
                              !0
                          )
                        : h(
                              t,
                              i,
                              function (t) {
                                  var i = e.Tools.GetExponantOfTwo(t[0].width, o._caps.maxCubemapTextureSize),
                                      r = i;
                                  o._prepareWorkingCanvas(), (o._workingCanvas.width = i), (o._workingCanvas.height = r);
                                  var h = [s.TEXTURE_CUBE_MAP_POSITIVE_X, s.TEXTURE_CUBE_MAP_POSITIVE_Y, s.TEXTURE_CUBE_MAP_POSITIVE_Z, s.TEXTURE_CUBE_MAP_NEGATIVE_X, s.TEXTURE_CUBE_MAP_NEGATIVE_Y, s.TEXTURE_CUBE_MAP_NEGATIVE_Z];
                                  s.bindTexture(s.TEXTURE_CUBE_MAP, a), s.pixelStorei(s.UNPACK_FLIP_Y_WEBGL, 0);
                                  for (var l = 0; l < h.length; l++) o._workingContext.drawImage(t[l], 0, 0, t[l].width, t[l].height, 0, 0, i, r), s.texImage2D(h[l], 0, s.RGBA, s.RGBA, s.UNSIGNED_BYTE, o._workingCanvas);
                                  n || s.generateMipmap(s.TEXTURE_CUBE_MAP),
                                      s.texParameteri(s.TEXTURE_CUBE_MAP, s.TEXTURE_MAG_FILTER, s.LINEAR),
                                      s.texParameteri(s.TEXTURE_CUBE_MAP, s.TEXTURE_MIN_FILTER, n ? s.LINEAR : s.LINEAR_MIPMAP_LINEAR),
                                      s.texParameteri(s.TEXTURE_CUBE_MAP, s.TEXTURE_WRAP_S, s.CLAMP_TO_EDGE),
                                      s.texParameteri(s.TEXTURE_CUBE_MAP, s.TEXTURE_WRAP_T, s.CLAMP_TO_EDGE),
                                      s.bindTexture(s.TEXTURE_CUBE_MAP, null),
                                      (o._activeTexturesCache = []),
                                      (a._width = i),
                                      (a._height = r),
                                      (a.isReady = !0);
                              },
                              r
                          ),
                    a
                );
            }),
            (a.prototype._releaseTexture = function (e) {
                var t = this._gl;
                e._framebuffer && t.deleteFramebuffer(e._framebuffer), e._depthBuffer && t.deleteRenderbuffer(e._depthBuffer), t.deleteTexture(e);
                for (var i = 0; i < this._caps.maxTexturesImageUnits; i++)
                    this._gl.activeTexture(this._gl["TEXTURE" + i]), this._gl.bindTexture(this._gl.TEXTURE_2D, null), this._gl.bindTexture(this._gl.TEXTURE_CUBE_MAP, null), (this._activeTexturesCache[i] = null);
                var r = this._loadedTexturesCache.indexOf(e);
                -1 !== r && this._loadedTexturesCache.splice(r, 1);
            }),
            (a.prototype.bindSamplers = function (e) {
                this._gl.useProgram(e.getProgram());
                for (var t = e.getSamplers(), i = 0; i < t.length; i++) {
                    var r = e.getUniform(t[i]);
                    this._gl.uniform1i(r, i);
                }
                this._currentEffect = null;
            }),
            (a.prototype._bindTexture = function (e, t) {
                this._gl.activeTexture(this._gl["TEXTURE" + e]), this._gl.bindTexture(this._gl.TEXTURE_2D, t), (this._activeTexturesCache[e] = null);
            }),
            (a.prototype.setTextureFromPostProcess = function (e, t) {
                this._bindTexture(e, t._textures.data[t._currentRenderTextureInd]);
            }),
            (a.prototype.setTexture = function (t, i) {
                if (!(0 > t)) {
                    if (!i || !i.isReady())
                        return void (
                            null != this._activeTexturesCache[t] &&
                            (this._gl.activeTexture(this._gl["TEXTURE" + t]), this._gl.bindTexture(this._gl.TEXTURE_2D, null), this._gl.bindTexture(this._gl.TEXTURE_CUBE_MAP, null), (this._activeTexturesCache[t] = null))
                        );
                    if (i instanceof e.VideoTexture) i.update() && (this._activeTexturesCache[t] = null);
                    else if (i.delayLoadState === a.DELAYLOADSTATE_NOTLOADED) return void i.delayLoad();
                    if (this._activeTexturesCache[t] !== i) {
                        this._activeTexturesCache[t] = i;
                        var r = i.getInternalTexture();
                        if ((this._gl.activeTexture(this._gl["TEXTURE" + t]), r.isCube)) {
                            if ((this._gl.bindTexture(this._gl.TEXTURE_CUBE_MAP, r), r._cachedCoordinatesMode !== i.coordinatesMode)) {
                                r._cachedCoordinatesMode = i.coordinatesMode;
                                var n = i.coordinatesMode !== e.Texture.CUBIC_MODE && i.coordinatesMode !== e.Texture.SKYBOX_MODE ? this._gl.REPEAT : this._gl.CLAMP_TO_EDGE;
                                this._gl.texParameteri(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_WRAP_S, n), this._gl.texParameteri(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_WRAP_T, n);
                            }
                            this._setAnisotropicLevel(this._gl.TEXTURE_CUBE_MAP, i);
                        } else {
                            if ((this._gl.bindTexture(this._gl.TEXTURE_2D, r), r._cachedWrapU !== i.wrapU))
                                switch (((r._cachedWrapU = i.wrapU), i.wrapU)) {
                                    case e.Texture.WRAP_ADDRESSMODE:
                                        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_S, this._gl.REPEAT);
                                        break;
                                    case e.Texture.CLAMP_ADDRESSMODE:
                                        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_S, this._gl.CLAMP_TO_EDGE);
                                        break;
                                    case e.Texture.MIRROR_ADDRESSMODE:
                                        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_S, this._gl.MIRRORED_REPEAT);
                                }
                            if (r._cachedWrapV !== i.wrapV)
                                switch (((r._cachedWrapV = i.wrapV), i.wrapV)) {
                                    case e.Texture.WRAP_ADDRESSMODE:
                                        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_T, this._gl.REPEAT);
                                        break;
                                    case e.Texture.CLAMP_ADDRESSMODE:
                                        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_T, this._gl.CLAMP_TO_EDGE);
                                        break;
                                    case e.Texture.MIRROR_ADDRESSMODE:
                                        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_T, this._gl.MIRRORED_REPEAT);
                                }
                            this._setAnisotropicLevel(this._gl.TEXTURE_2D, i);
                        }
                    }
                }
            }),
            (a.prototype._setAnisotropicLevel = function (t, i) {
                var r = this._caps.textureAnisotropicFilterExtension,
                    n = i.anisotropicFilteringLevel;
                i.getInternalTexture().samplingMode === e.Texture.NEAREST_SAMPLINGMODE && (n = 1),
                    r && i._cachedAnisotropicFilteringLevel !== n && (this._gl.texParameterf(t, r.TEXTURE_MAX_ANISOTROPY_EXT, Math.min(n, this._caps.maxAnisotropy)), (i._cachedAnisotropicFilteringLevel = n));
            }),
            (a.prototype.readPixels = function (e, t, i, r) {
                var n = new Uint8Array(r * i * 4);
                return this._gl.readPixels(e, t, i, r, this._gl.RGBA, this._gl.UNSIGNED_BYTE, n), n;
            }),
            (a.prototype.dispose = function () {
                for (this.hideLoadingUI(), this.stopRenderLoop(); this.scenes.length; ) this.scenes[0].dispose();
                a.audioEngine.dispose();
                for (var e in this._compiledEffects) this._gl.deleteProgram(this._compiledEffects[e]._program);
                for (var t in this._vertexAttribArrays) t > this._gl.VERTEX_ATTRIB_ARRAY_ENABLED || !this._vertexAttribArrays[t] || this._gl.disableVertexAttribArray(t);
                (this._gl = null),
                    window.removeEventListener("blur", this._onBlur),
                    window.removeEventListener("focus", this._onFocus),
                    document.removeEventListener("fullscreenchange", this._onFullscreenChange),
                    document.removeEventListener("mozfullscreenchange", this._onFullscreenChange),
                    document.removeEventListener("webkitfullscreenchange", this._onFullscreenChange),
                    document.removeEventListener("msfullscreenchange", this._onFullscreenChange),
                    document.removeEventListener("pointerlockchange", this._onPointerLockChange),
                    document.removeEventListener("mspointerlockchange", this._onPointerLockChange),
                    document.removeEventListener("mozpointerlockchange", this._onPointerLockChange),
                    document.removeEventListener("webkitpointerlockchange", this._onPointerLockChange);
            }),
            (a.prototype.displayLoadingUI = function () {
                this._loadingScreen.displayLoadingUI();
            }),
            (a.prototype.hideLoadingUI = function () {
                this._loadingScreen.hideLoadingUI();
            }),
            Object.defineProperty(a.prototype, "loadingScreen", {
                get: function () {
                    return this._loadingScreen;
                },
                set: function (e) {
                    this._loadingScreen = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a.prototype, "loadingUIText", {
                set: function (e) {
                    this._loadingScreen.loadingUIText = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(a.prototype, "loadingUIBackgroundColor", {
                set: function (e) {
                    this._loadingScreen.loadingUIBackgroundColor = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (a.prototype.getFps = function () {
                return this.fps;
            }),
            (a.prototype.getDeltaTime = function () {
                return this.deltaTime;
            }),
            (a.prototype._measureFps = function () {
                this.previousFramesDuration.push(e.Tools.Now);
                var t = this.previousFramesDuration.length;
                if ((t >= 2 && (this.deltaTime = this.previousFramesDuration[t - 1] - this.previousFramesDuration[t - 2]), t >= this.fpsRange)) {
                    t > this.fpsRange && (this.previousFramesDuration.splice(0, 1), (t = this.previousFramesDuration.length));
                    for (var i = 0, r = 0; t - 1 > r; r++) i += this.previousFramesDuration[r + 1] - this.previousFramesDuration[r];
                    this.fps = 1e3 / (i / (t - 1));
                }
            }),
            (a.isSupported = function () {
                try {
                    if (navigator.isCocoonJS) return !0;
                    var e = document.createElement("canvas"),
                        t = e.getContext("webgl") || e.getContext("experimental-webgl");
                    return null != t && !!window.WebGLRenderingContext;
                } catch (i) {
                    return !1;
                }
            }),
            (a._ALPHA_DISABLE = 0),
            (a._ALPHA_ADD = 1),
            (a._ALPHA_COMBINE = 2),
            (a._ALPHA_SUBTRACT = 3),
            (a._ALPHA_MULTIPLY = 4),
            (a._ALPHA_MAXIMIZED = 5),
            (a._ALPHA_ONEONE = 6),
            (a._DELAYLOADSTATE_NONE = 0),
            (a._DELAYLOADSTATE_LOADED = 1),
            (a._DELAYLOADSTATE_LOADING = 2),
            (a._DELAYLOADSTATE_NOTLOADED = 4),
            (a._TEXTUREFORMAT_ALPHA = 0),
            (a._TEXTUREFORMAT_LUMINANCE = 1),
            (a._TEXTUREFORMAT_LUMINANCE_ALPHA = 2),
            (a._TEXTUREFORMAT_RGB = 4),
            (a._TEXTUREFORMAT_RGBA = 5),
            (a._TEXTURETYPE_UNSIGNED_INT = 0),
            (a._TEXTURETYPE_FLOAT = 1),
            (a.Epsilon = 0.001),
            (a.CollisionsEpsilon = 0.001),
            (a.CodeRepository = "src/"),
            (a.ShadersRepository = "src/Shaders/"),
            a
        );
    })();
    e.Engine = c;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, t) {
            (this.state = ""),
                (this.animations = new Array()),
                (this._childrenFlag = -1),
                (this._isEnabled = !0),
                (this._isReady = !0),
                (this._currentRenderId = -1),
                (this._parentRenderId = -1),
                (this.name = e),
                (this.id = e),
                (this._scene = t),
                this._initCache();
        }
        return (
            (t.prototype.getScene = function () {
                return this._scene;
            }),
            (t.prototype.getEngine = function () {
                return this._scene.getEngine();
            }),
            (t.prototype.getWorldMatrix = function () {
                return e.Matrix.Identity();
            }),
            (t.prototype._initCache = function () {
                (this._cache = {}), (this._cache.parent = void 0);
            }),
            (t.prototype.updateCache = function (e) {
                (e || !this.isSynchronized()) && ((this._cache.parent = this.parent), this._updateCache());
            }),
            (t.prototype._updateCache = function (e) {}),
            (t.prototype._isSynchronized = function () {
                return !0;
            }),
            (t.prototype._markSyncedWithParent = function () {
                this._parentRenderId = this.parent._currentRenderId;
            }),
            (t.prototype.isSynchronizedWithParent = function () {
                return this.parent ? (this._parentRenderId !== this.parent._currentRenderId ? !1 : this.parent.isSynchronized()) : !0;
            }),
            (t.prototype.isSynchronized = function (e) {
                var t = this.hasNewParent();
                return (t = t || !this.isSynchronizedWithParent()), (t = t || !this._isSynchronized()), e && this.updateCache(!0), !t;
            }),
            (t.prototype.hasNewParent = function (e) {
                return this._cache.parent === this.parent ? !1 : (e && (this._cache.parent = this.parent), !0);
            }),
            (t.prototype.isReady = function () {
                return this._isReady;
            }),
            (t.prototype.isEnabled = function () {
                return this._isEnabled ? (this.parent ? this.parent.isEnabled() : !0) : !1;
            }),
            (t.prototype.setEnabled = function (e) {
                this._isEnabled = e;
            }),
            (t.prototype.isDescendantOf = function (e) {
                return this.parent ? (this.parent === e ? !0 : this.parent.isDescendantOf(e)) : !1;
            }),
            (t.prototype._getDescendants = function (e, t) {
                for (var i = 0; i < e.length; i++) {
                    var r = e[i];
                    r.isDescendantOf(this) && t.push(r);
                }
            }),
            (t.prototype.getDescendants = function () {
                var e = [];
                return this._getDescendants(this._scene.meshes, e), this._getDescendants(this._scene.lights, e), this._getDescendants(this._scene.cameras, e), e;
            }),
            (t.prototype._setReady = function (e) {
                if (e != this._isReady) {
                    if (!e) return void (this._isReady = !1);
                    (this._isReady = !0), this.onReady && this.onReady(this);
                }
            }),
            t
        );
    })();
    e.Node = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, t, i, r, n, o, s, a) {
            (this._engine = e),
                (this._canvas = i),
                (this._currentScene = t),
                (this._sceneLoadedCallback = r),
                (this._progressCallback = n),
                (this._additionnalRenderLoopLogicCallback = o),
                (this._textureLoadingCallback = s),
                (this._startingProcessingFilesCallback = a);
        }
        return (
            (t.prototype.monitorElementForDragNDrop = function (e) {
                var t = this;
                e &&
                    ((this._elementToMonitor = e),
                    this._elementToMonitor.addEventListener(
                        "dragenter",
                        function (e) {
                            t.drag(e);
                        },
                        !1
                    ),
                    this._elementToMonitor.addEventListener(
                        "dragover",
                        function (e) {
                            t.drag(e);
                        },
                        !1
                    ),
                    this._elementToMonitor.addEventListener(
                        "drop",
                        function (e) {
                            t.drop(e);
                        },
                        !1
                    ));
            }),
            (t.prototype.renderFunction = function () {
                if ((this._additionnalRenderLoopLogicCallback && this._additionnalRenderLoopLogicCallback(), this._currentScene)) {
                    if (this._textureLoadingCallback) {
                        var e = this._currentScene.getWaitingItemsCount();
                        e > 0 && this._textureLoadingCallback(e);
                    }
                    this._currentScene.render();
                }
            }),
            (t.prototype.drag = function (e) {
                e.stopPropagation(), e.preventDefault();
            }),
            (t.prototype.drop = function (e) {
                e.stopPropagation(), e.preventDefault(), this.loadFiles(e);
            }),
            (t.prototype.loadFiles = function (e) {
                if (
                    (this._startingProcessingFilesCallback && this._startingProcessingFilesCallback(),
                    e && e.dataTransfer && e.dataTransfer.files && (this._filesToLoad = e.dataTransfer.files),
                    e && e.target && e.target.files && (this._filesToLoad = e.target.files),
                    this._filesToLoad && this._filesToLoad.length > 0)
                ) {
                    for (var i = 0; i < this._filesToLoad.length; i++)
                        switch (this._filesToLoad[i].type) {
                            case "image/jpeg":
                            case "image/png":
                            case "image/bmp":
                                t.FilesTextures[this._filesToLoad[i].name] = this._filesToLoad[i];
                                break;
                            case "image/targa":
                            case "image/vnd.ms-dds":
                            case "audio/wav":
                            case "audio/x-wav":
                            case "audio/mp3":
                            case "audio/mpeg":
                            case "audio/mpeg3":
                            case "audio/x-mpeg-3":
                            case "audio/ogg":
                                t.FilesToLoad[this._filesToLoad[i].name] = this._filesToLoad[i];
                                break;
                            default:
                                -1 !== this._filesToLoad[i].name.indexOf(".babylon") &&
                                    -1 === this._filesToLoad[i].name.indexOf(".manifest") &&
                                    -1 === this._filesToLoad[i].name.indexOf(".incremental") &&
                                    -1 === this._filesToLoad[i].name.indexOf(".babylonmeshdata") &&
                                    -1 === this._filesToLoad[i].name.indexOf(".babylongeometrydata") &&
                                    -1 === this._filesToLoad[i].name.indexOf(".babylonbinarymeshdata") &&
                                    -1 === this._filesToLoad[i].name.indexOf(".binary.babylon") &&
                                    (this._sceneFileToLoad = this._filesToLoad[i]);
                        }
                    this.reload();
                }
            }),
            (t.prototype.reload = function () {
                var t = this,
                    i = this;
                this._sceneFileToLoad
                    ? (this._currentScene && (e.Tools.errorsCount > 0 && (e.Tools.ClearLogCache(), e.Tools.Log("Babylon.js engine (v" + e.Engine.Version + ") launched")), this._engine.stopRenderLoop(), this._currentScene.dispose()),
                      e.SceneLoader.Load(
                          "file:",
                          this._sceneFileToLoad,
                          this._engine,
                          function (e) {
                              (i._currentScene = e),
                                  i._currentScene.executeWhenReady(function () {
                                      (i._currentScene.activeCamera && 0 !== i._currentScene.lights.length) || i._currentScene.createDefaultCameraOrLight(),
                                          i._currentScene.activeCamera.attachControl(i._canvas),
                                          i._sceneLoadedCallback && i._sceneLoadedCallback(t._sceneFileToLoad, i._currentScene),
                                          i._engine.runRenderLoop(function () {
                                              i.renderFunction();
                                          });
                                  });
                          },
                          function (e) {
                              t._progressCallback && t._progressCallback(e);
                          }
                      ))
                    : e.Tools.Error("Please provide a valid .babylon file.");
            }),
            (t.FilesTextures = new Array()),
            (t.FilesToLoad = new Array()),
            t
        );
    })();
    e.FilesInput = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e(e, t, i) {
            (this.bu = e), (this.bv = t), (this.distance = i), (this.faceId = 0), (this.subMeshId = 0);
        }
        return e;
    })();
    e.IntersectionInfo = t;
    var i = (function () {
        function t() {
            (this.hit = !1), (this.distance = 0), (this.pickedPoint = null), (this.pickedMesh = null), (this.bu = 0), (this.bv = 0), (this.faceId = -1), (this.subMeshId = 0);
        }
        return (
            (t.prototype.getNormal = function (t, i) {
                if ((void 0 === t && (t = !1), void 0 === i && (i = !0), !this.pickedMesh || !this.pickedMesh.isVerticesDataPresent(e.VertexBuffer.NormalKind))) return null;
                var r,
                    n = this.pickedMesh.getIndices();
                if (i) {
                    var o = this.pickedMesh.getVerticesData(e.VertexBuffer.NormalKind),
                        s = e.Vector3.FromArray(o, 3 * n[3 * this.faceId]),
                        a = e.Vector3.FromArray(o, 3 * n[3 * this.faceId + 1]),
                        h = e.Vector3.FromArray(o, 3 * n[3 * this.faceId + 2]);
                    (s = s.scale(this.bu)), (a = a.scale(this.bv)), (h = h.scale(1 - this.bu - this.bv)), (r = new e.Vector3(s.x + a.x + h.x, s.y + a.y + h.y, s.z + a.z + h.z));
                } else {
                    var l = this.pickedMesh.getVerticesData(e.VertexBuffer.PositionKind),
                        c = e.Vector3.FromArray(l, 3 * n[3 * this.faceId]),
                        u = e.Vector3.FromArray(l, 3 * n[3 * this.faceId + 1]),
                        f = e.Vector3.FromArray(l, 3 * n[3 * this.faceId + 2]),
                        d = c.subtract(u),
                        p = f.subtract(u);
                    r = e.Vector3.Cross(d, p);
                }
                return t && (r = e.Vector3.TransformNormal(r, this.pickedMesh.getWorldMatrix())), e.Vector3.Normalize(r);
            }),
            (t.prototype.getTextureCoordinates = function () {
                if (!this.pickedMesh || !this.pickedMesh.isVerticesDataPresent(e.VertexBuffer.UVKind)) return null;
                var t = this.pickedMesh.getIndices(),
                    i = this.pickedMesh.getVerticesData(e.VertexBuffer.UVKind),
                    r = e.Vector2.FromArray(i, 2 * t[3 * this.faceId]),
                    n = e.Vector2.FromArray(i, 2 * t[3 * this.faceId + 1]),
                    o = e.Vector2.FromArray(i, 2 * t[3 * this.faceId + 2]);
                return (r = r.scale(1 - this.bu - this.bv)), (n = n.scale(this.bu)), (o = o.scale(this.bv)), new e.Vector2(r.x + n.x + o.x, r.y + n.y + o.y);
            }),
            t
        );
    })();
    e.PickingInfo = i;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i) {
            (this.minimum = t), (this.maximum = i), (this._tempRadiusVector = e.Vector3.Zero());
            var r = e.Vector3.Distance(t, i);
            (this.center = e.Vector3.Lerp(t, i, 0.5)), (this.radius = 0.5 * r), (this.centerWorld = e.Vector3.Zero()), this._update(e.Matrix.Identity());
        }
        return (
            (t.prototype._update = function (t) {
                e.Vector3.TransformCoordinatesToRef(this.center, t, this.centerWorld),
                    e.Vector3.TransformNormalFromFloatsToRef(1, 1, 1, t, this._tempRadiusVector),
                    (this.radiusWorld = Math.max(Math.abs(this._tempRadiusVector.x), Math.abs(this._tempRadiusVector.y), Math.abs(this._tempRadiusVector.z)) * this.radius);
            }),
            (t.prototype.isInFrustum = function (e) {
                for (var t = 0; 6 > t; t++) if (e[t].dotCoordinate(this.centerWorld) <= -this.radiusWorld) return !1;
                return !0;
            }),
            (t.prototype.intersectsPoint = function (t) {
                var i = this.centerWorld.x - t.x,
                    r = this.centerWorld.y - t.y,
                    n = this.centerWorld.z - t.z,
                    o = Math.sqrt(i * i + r * r + n * n);
                return Math.abs(this.radiusWorld - o) < e.Engine.Epsilon ? !1 : !0;
            }),
            (t.Intersects = function (e, t) {
                var i = e.centerWorld.x - t.centerWorld.x,
                    r = e.centerWorld.y - t.centerWorld.y,
                    n = e.centerWorld.z - t.centerWorld.z,
                    o = Math.sqrt(i * i + r * r + n * n);
                return e.radiusWorld + t.radiusWorld < o ? !1 : !0;
            }),
            t
        );
    })();
    e.BoundingSphere = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i) {
            (this.minimum = t),
                (this.maximum = i),
                (this.vectors = new Array()),
                (this.vectorsWorld = new Array()),
                this.vectors.push(this.minimum.clone()),
                this.vectors.push(this.maximum.clone()),
                this.vectors.push(this.minimum.clone()),
                (this.vectors[2].x = this.maximum.x),
                this.vectors.push(this.minimum.clone()),
                (this.vectors[3].y = this.maximum.y),
                this.vectors.push(this.minimum.clone()),
                (this.vectors[4].z = this.maximum.z),
                this.vectors.push(this.maximum.clone()),
                (this.vectors[5].z = this.minimum.z),
                this.vectors.push(this.maximum.clone()),
                (this.vectors[6].x = this.minimum.x),
                this.vectors.push(this.maximum.clone()),
                (this.vectors[7].y = this.minimum.y),
                (this.center = this.maximum.add(this.minimum).scale(0.5)),
                (this.extendSize = this.maximum.subtract(this.minimum).scale(0.5)),
                (this.directions = [e.Vector3.Zero(), e.Vector3.Zero(), e.Vector3.Zero()]);
            for (var r = 0; r < this.vectors.length; r++) this.vectorsWorld[r] = e.Vector3.Zero();
            (this.minimumWorld = e.Vector3.Zero()), (this.maximumWorld = e.Vector3.Zero()), this._update(e.Matrix.Identity());
        }
        return (
            (t.prototype.getWorldMatrix = function () {
                return this._worldMatrix;
            }),
            (t.prototype._update = function (t) {
                e.Vector3.FromFloatsToRef(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE, this.minimumWorld), e.Vector3.FromFloatsToRef(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE, this.maximumWorld);
                for (var i = 0; i < this.vectors.length; i++) {
                    var r = this.vectorsWorld[i];
                    e.Vector3.TransformCoordinatesToRef(this.vectors[i], t, r),
                        r.x < this.minimumWorld.x && (this.minimumWorld.x = r.x),
                        r.y < this.minimumWorld.y && (this.minimumWorld.y = r.y),
                        r.z < this.minimumWorld.z && (this.minimumWorld.z = r.z),
                        r.x > this.maximumWorld.x && (this.maximumWorld.x = r.x),
                        r.y > this.maximumWorld.y && (this.maximumWorld.y = r.y),
                        r.z > this.maximumWorld.z && (this.maximumWorld.z = r.z);
                }
                this.maximumWorld.addToRef(this.minimumWorld, this.center),
                    this.center.scaleInPlace(0.5),
                    e.Vector3.FromFloatArrayToRef(t.m, 0, this.directions[0]),
                    e.Vector3.FromFloatArrayToRef(t.m, 4, this.directions[1]),
                    e.Vector3.FromFloatArrayToRef(t.m, 8, this.directions[2]),
                    (this._worldMatrix = t);
            }),
            (t.prototype.isInFrustum = function (e) {
                return t.IsInFrustum(this.vectorsWorld, e);
            }),
            (t.prototype.isCompletelyInFrustum = function (e) {
                return t.IsCompletelyInFrustum(this.vectorsWorld, e);
            }),
            (t.prototype.intersectsPoint = function (t) {
                var i = -e.Engine.Epsilon;
                return this.maximumWorld.x - t.x < i || i > t.x - this.minimumWorld.x ? !1 : this.maximumWorld.y - t.y < i || i > t.y - this.minimumWorld.y ? !1 : this.maximumWorld.z - t.z < i || i > t.z - this.minimumWorld.z ? !1 : !0;
            }),
            (t.prototype.intersectsSphere = function (e) {
                return t.IntersectsSphere(this.minimumWorld, this.maximumWorld, e.centerWorld, e.radiusWorld);
            }),
            (t.prototype.intersectsMinMax = function (e, t) {
                return this.maximumWorld.x < e.x || this.minimumWorld.x > t.x ? !1 : this.maximumWorld.y < e.y || this.minimumWorld.y > t.y ? !1 : this.maximumWorld.z < e.z || this.minimumWorld.z > t.z ? !1 : !0;
            }),
            (t.Intersects = function (e, t) {
                return e.maximumWorld.x < t.minimumWorld.x || e.minimumWorld.x > t.maximumWorld.x
                    ? !1
                    : e.maximumWorld.y < t.minimumWorld.y || e.minimumWorld.y > t.maximumWorld.y
                    ? !1
                    : e.maximumWorld.z < t.minimumWorld.z || e.minimumWorld.z > t.maximumWorld.z
                    ? !1
                    : !0;
            }),
            (t.IntersectsSphere = function (t, i, r, n) {
                var o = e.Vector3.Clamp(r, t, i),
                    s = e.Vector3.DistanceSquared(r, o);
                return n * n >= s;
            }),
            (t.IsCompletelyInFrustum = function (e, t) {
                for (var i = 0; 6 > i; i++) for (var r = 0; 8 > r; r++) if (t[i].dotCoordinate(e[r]) < 0) return !1;
                return !0;
            }),
            (t.IsInFrustum = function (e, t) {
                for (var i = 0; 6 > i; i++) {
                    for (var r = 8, n = 0; 8 > n && t[i].dotCoordinate(e[n]) < 0; n++) --r;
                    if (0 === r) return !1;
                }
                return !0;
            }),
            t
        );
    })();
    e.BoundingBox = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = function (t, i) {
            var r = e.Vector3.Dot(i.center, t),
                n = Math.abs(e.Vector3.Dot(i.directions[0], t)) * i.extendSize.x,
                o = Math.abs(e.Vector3.Dot(i.directions[1], t)) * i.extendSize.y,
                s = Math.abs(e.Vector3.Dot(i.directions[2], t)) * i.extendSize.z,
                a = n + o + s;
            return { min: r - a, max: r + a };
        },
        i = function (e, t, i, r) {
            return !(e > r || i > t);
        },
        r = function (e, r, n) {
            var o = t(e, r),
                s = t(e, n);
            return i(o.min, o.max, s.min, s.max);
        },
        n = (function () {
            function t(t, i) {
                (this.minimum = t), (this.maximum = i), (this.boundingBox = new e.BoundingBox(t, i)), (this.boundingSphere = new e.BoundingSphere(t, i));
            }
            return (
                (t.prototype._update = function (e) {
                    this.boundingBox._update(e), this.boundingSphere._update(e);
                }),
                (t.prototype.isInFrustum = function (e) {
                    return this.boundingSphere.isInFrustum(e) ? this.boundingBox.isInFrustum(e) : !1;
                }),
                (t.prototype.isCompletelyInFrustum = function (e) {
                    return this.boundingBox.isCompletelyInFrustum(e);
                }),
                (t.prototype._checkCollision = function (e) {
                    return e._canDoCollision(this.boundingSphere.centerWorld, this.boundingSphere.radiusWorld, this.boundingBox.minimumWorld, this.boundingBox.maximumWorld);
                }),
                (t.prototype.intersectsPoint = function (e) {
                    return this.boundingSphere.centerWorld && this.boundingSphere.intersectsPoint(e) && this.boundingBox.intersectsPoint(e) ? !0 : !1;
                }),
                (t.prototype.intersects = function (t, i) {
                    if (!this.boundingSphere.centerWorld || !t.boundingSphere.centerWorld) return !1;
                    if (!e.BoundingSphere.Intersects(this.boundingSphere, t.boundingSphere)) return !1;
                    if (!e.BoundingBox.Intersects(this.boundingBox, t.boundingBox)) return !1;
                    if (!i) return !0;
                    var n = this.boundingBox,
                        o = t.boundingBox;
                    return r(n.directions[0], n, o) &&
                        r(n.directions[1], n, o) &&
                        r(n.directions[2], n, o) &&
                        r(o.directions[0], n, o) &&
                        r(o.directions[1], n, o) &&
                        r(o.directions[2], n, o) &&
                        r(e.Vector3.Cross(n.directions[0], o.directions[0]), n, o) &&
                        r(e.Vector3.Cross(n.directions[0], o.directions[1]), n, o) &&
                        r(e.Vector3.Cross(n.directions[0], o.directions[2]), n, o) &&
                        r(e.Vector3.Cross(n.directions[1], o.directions[0]), n, o) &&
                        r(e.Vector3.Cross(n.directions[1], o.directions[1]), n, o) &&
                        r(e.Vector3.Cross(n.directions[1], o.directions[2]), n, o) &&
                        r(e.Vector3.Cross(n.directions[2], o.directions[0]), n, o) &&
                        r(e.Vector3.Cross(n.directions[2], o.directions[1]), n, o) &&
                        r(e.Vector3.Cross(n.directions[2], o.directions[2]), n, o)
                        ? !0
                        : !1;
                }),
                t
            );
        })();
    e.BoundingInfo = n;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(r, n) {
            var o = this;
            t.call(this, r, n),
                (this.definedFacingForward = !0),
                (this.position = new e.Vector3(0, 0, 0)),
                (this.rotation = new e.Vector3(0, 0, 0)),
                (this.scaling = new e.Vector3(1, 1, 1)),
                (this.billboardMode = i.BILLBOARDMODE_NONE),
                (this.visibility = 1),
                (this.alphaIndex = Number.MAX_VALUE),
                (this.infiniteDistance = !1),
                (this.isVisible = !0),
                (this.isPickable = !0),
                (this.showBoundingBox = !1),
                (this.showSubMeshesBoundingBox = !1),
                (this.onDispose = null),
                (this.isBlocker = !1),
                (this.renderingGroupId = 0),
                (this.receiveShadows = !1),
                (this.renderOutline = !1),
                (this.outlineColor = e.Color3.Red()),
                (this.outlineWidth = 0.02),
                (this.renderOverlay = !1),
                (this.overlayColor = e.Color3.Red()),
                (this.overlayAlpha = 0.5),
                (this.hasVertexAlpha = !1),
                (this.useVertexColors = !0),
                (this.applyFog = !0),
                (this.computeBonesUsingShaders = !0),
                (this.scalingDeterminant = 1),
                (this.useOctreeForRenderingSelection = !0),
                (this.useOctreeForPicking = !0),
                (this.useOctreeForCollisions = !0),
                (this.layerMask = 268435455),
                (this.alwaysSelectAsActiveMesh = !1),
                (this._physicImpostor = e.PhysicsEngine.NoImpostor),
                (this._checkCollisions = !1),
                (this.ellipsoid = new e.Vector3(0.5, 1, 0.5)),
                (this.ellipsoidOffset = new e.Vector3(0, 0, 0)),
                (this._collider = new e.Collider()),
                (this._oldPositionForCollisions = new e.Vector3(0, 0, 0)),
                (this._diffPositionForCollisions = new e.Vector3(0, 0, 0)),
                (this._newPositionForCollisions = new e.Vector3(0, 0, 0)),
                (this.edgesWidth = 1),
                (this.edgesColor = new e.Color4(1, 0, 0, 1)),
                (this._localScaling = e.Matrix.Zero()),
                (this._localRotation = e.Matrix.Zero()),
                (this._localTranslation = e.Matrix.Zero()),
                (this._localBillboard = e.Matrix.Zero()),
                (this._localPivotScaling = e.Matrix.Zero()),
                (this._localPivotScalingRotation = e.Matrix.Zero()),
                (this._localWorld = e.Matrix.Zero()),
                (this._worldMatrix = e.Matrix.Zero()),
                (this._rotateYByPI = e.Matrix.RotationY(Math.PI)),
                (this._absolutePosition = e.Vector3.Zero()),
                (this._collisionsTransformMatrix = e.Matrix.Zero()),
                (this._collisionsScalingMatrix = e.Matrix.Zero()),
                (this._isDirty = !1),
                (this._pivotMatrix = e.Matrix.Identity()),
                (this._isDisposed = !1),
                (this._renderId = 0),
                (this._intersectionsInProgress = new Array()),
                (this._onAfterWorldMatrixUpdate = new Array()),
                (this._isWorldMatrixFrozen = !1),
                (this._onCollisionPositionChange = function (t, i, r) {
                    void 0 === r && (r = null),
                        o.getScene().workerCollisions && i.multiplyInPlace(o._collider.radius),
                        i.subtractToRef(o._oldPositionForCollisions, o._diffPositionForCollisions),
                        o._diffPositionForCollisions.length() > e.Engine.CollisionsEpsilon && o.position.addInPlace(o._diffPositionForCollisions),
                        o.onCollide && r && o.onCollide(r);
                }),
                n.addMesh(this);
        }
        return (
            __extends(i, t),
            Object.defineProperty(i, "BILLBOARDMODE_NONE", {
                get: function () {
                    return i._BILLBOARDMODE_NONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i, "BILLBOARDMODE_X", {
                get: function () {
                    return i._BILLBOARDMODE_X;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i, "BILLBOARDMODE_Y", {
                get: function () {
                    return i._BILLBOARDMODE_Y;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i, "BILLBOARDMODE_Z", {
                get: function () {
                    return i._BILLBOARDMODE_Z;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i, "BILLBOARDMODE_ALL", {
                get: function () {
                    return i._BILLBOARDMODE_ALL;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.disableEdgesRendering = function () {
                void 0 !== this._edgesRenderer && (this._edgesRenderer.dispose(), (this._edgesRenderer = void 0));
            }),
            (i.prototype.enableEdgesRendering = function (t, i) {
                void 0 === t && (t = 0.95), void 0 === i && (i = !1), this.disableEdgesRendering(), (this._edgesRenderer = new e.EdgesRenderer(this, t, i));
            }),
            Object.defineProperty(i.prototype, "isBlocked", {
                get: function () {
                    return !1;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.getLOD = function (e) {
                return this;
            }),
            (i.prototype.getTotalVertices = function () {
                return 0;
            }),
            (i.prototype.getIndices = function () {
                return null;
            }),
            (i.prototype.getVerticesData = function (e) {
                return null;
            }),
            (i.prototype.isVerticesDataPresent = function (e) {
                return !1;
            }),
            (i.prototype.getBoundingInfo = function () {
                return this._masterMesh ? this._masterMesh.getBoundingInfo() : (this._boundingInfo || this._updateBoundingInfo(), this._boundingInfo);
            }),
            Object.defineProperty(i.prototype, "useBones", {
                get: function () {
                    return this.skeleton && this.getScene().skeletonsEnabled && this.isVerticesDataPresent(e.VertexBuffer.MatricesIndicesKind) && this.isVerticesDataPresent(e.VertexBuffer.MatricesWeightsKind);
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype._preActivate = function () {}),
            (i.prototype._activate = function (e) {
                this._renderId = e;
            }),
            (i.prototype.getWorldMatrix = function () {
                return this._masterMesh ? this._masterMesh.getWorldMatrix() : (this._currentRenderId !== this.getScene().getRenderId() && this.computeWorldMatrix(), this._worldMatrix);
            }),
            Object.defineProperty(i.prototype, "worldMatrixFromCache", {
                get: function () {
                    return this._worldMatrix;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "absolutePosition", {
                get: function () {
                    return this._absolutePosition;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.freezeWorldMatrix = function () {
                (this._isWorldMatrixFrozen = !1), this.computeWorldMatrix(!0), (this._isWorldMatrixFrozen = !0);
            }),
            (i.prototype.unfreezeWorldMatrix = function () {
                (this._isWorldMatrixFrozen = !1), this.computeWorldMatrix(!0);
            }),
            Object.defineProperty(i.prototype, "isWorldMatrixFrozen", {
                get: function () {
                    return this._isWorldMatrixFrozen;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.rotate = function (t, i, r) {
                t.normalize(), this.rotationQuaternion || ((this.rotationQuaternion = e.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z)), (this.rotation = e.Vector3.Zero()));
                var n;
                if (r && r !== e.Space.LOCAL) {
                    if (this.parent) {
                        var o = this.parent.getWorldMatrix().clone();
                        o.invert(), (t = e.Vector3.TransformNormal(t, o));
                    }
                    (n = e.Quaternion.RotationAxis(t, i)), (this.rotationQuaternion = n.multiply(this.rotationQuaternion));
                } else (n = e.Quaternion.RotationAxis(t, i)), (this.rotationQuaternion = this.rotationQuaternion.multiply(n));
            }),
            (i.prototype.translate = function (t, i, r) {
                var n = t.scale(i);
                if (r && r !== e.Space.LOCAL) this.setAbsolutePosition(this.getAbsolutePosition().add(n));
                else {
                    var o = this.getPositionExpressedInLocalSpace().add(n);
                    this.setPositionWithLocalVector(o);
                }
            }),
            (i.prototype.getAbsolutePosition = function () {
                return this.computeWorldMatrix(), this._absolutePosition;
            }),
            (i.prototype.setAbsolutePosition = function (t) {
                if (t) {
                    var i, r, n;
                    if (void 0 === t.x) {
                        if (arguments.length < 3) return;
                        (i = arguments[0]), (r = arguments[1]), (n = arguments[2]);
                    } else (i = t.x), (r = t.y), (n = t.z);
                    if (this.parent) {
                        var o = this.parent.getWorldMatrix().clone();
                        o.invert();
                        var s = new e.Vector3(i, r, n);
                        this.position = e.Vector3.TransformCoordinates(s, o);
                    } else (this.position.x = i), (this.position.y = r), (this.position.z = n);
                }
            }),
            (i.prototype.movePOV = function (e, t, i) {
                this.position.addInPlace(this.calcMovePOV(e, t, i));
            }),
            (i.prototype.calcMovePOV = function (t, i, r) {
                var n = new e.Matrix(),
                    o = this.rotationQuaternion ? this.rotationQuaternion : e.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z);
                o.toRotationMatrix(n);
                var s = e.Vector3.Zero(),
                    a = this.definedFacingForward ? -1 : 1;
                return e.Vector3.TransformCoordinatesFromFloatsToRef(t * a, i, r * a, n, s), s;
            }),
            (i.prototype.rotatePOV = function (e, t, i) {
                this.rotation.addInPlace(this.calcRotatePOV(e, t, i));
            }),
            (i.prototype.calcRotatePOV = function (t, i, r) {
                var n = this.definedFacingForward ? 1 : -1;
                return new e.Vector3(t * n, i, r * n);
            }),
            (i.prototype.setPivotMatrix = function (e) {
                (this._pivotMatrix = e), (this._cache.pivotMatrixUpdated = !0);
            }),
            (i.prototype.getPivotMatrix = function () {
                return this._pivotMatrix;
            }),
            (i.prototype._isSynchronized = function () {
                if (this._isDirty) return !1;
                if (this.billboardMode !== i.BILLBOARDMODE_NONE) return !1;
                if (this._cache.pivotMatrixUpdated) return !1;
                if (this.infiniteDistance) return !1;
                if (!this._cache.position.equals(this.position)) return !1;
                if (this.rotationQuaternion) {
                    if (!this._cache.rotationQuaternion.equals(this.rotationQuaternion)) return !1;
                } else if (!this._cache.rotation.equals(this.rotation)) return !1;
                return this._cache.scaling.equals(this.scaling) ? !0 : !1;
            }),
            (i.prototype._initCache = function () {
                t.prototype._initCache.call(this),
                    (this._cache.localMatrixUpdated = !1),
                    (this._cache.position = e.Vector3.Zero()),
                    (this._cache.scaling = e.Vector3.Zero()),
                    (this._cache.rotation = e.Vector3.Zero()),
                    (this._cache.rotationQuaternion = new e.Quaternion(0, 0, 0, 0));
            }),
            (i.prototype.markAsDirty = function (e) {
                "rotation" === e && (this.rotationQuaternion = null), (this._currentRenderId = Number.MAX_VALUE), (this._isDirty = !0);
            }),
            (i.prototype._updateBoundingInfo = function () {
                (this._boundingInfo = this._boundingInfo || new e.BoundingInfo(this.absolutePosition, this.absolutePosition)),
                    this._boundingInfo._update(this.worldMatrixFromCache),
                    this._updateSubMeshesBoundingInfo(this.worldMatrixFromCache);
            }),
            (i.prototype._updateSubMeshesBoundingInfo = function (e) {
                if (this.subMeshes)
                    for (var t = 0; t < this.subMeshes.length; t++) {
                        var i = this.subMeshes[t];
                        i.updateBoundingInfo(e);
                    }
            }),
            (i.prototype.computeWorldMatrix = function (t) {
                if (this._isWorldMatrixFrozen) return this._worldMatrix;
                if (!t && (this._currentRenderId === this.getScene().getRenderId() || this.isSynchronized(!0))) return this._worldMatrix;
                if (
                    (this._cache.position.copyFrom(this.position),
                    this._cache.scaling.copyFrom(this.scaling),
                    (this._cache.pivotMatrixUpdated = !1),
                    (this._currentRenderId = this.getScene().getRenderId()),
                    (this._isDirty = !1),
                    e.Matrix.ScalingToRef(this.scaling.x * this.scalingDeterminant, this.scaling.y * this.scalingDeterminant, this.scaling.z * this.scalingDeterminant, this._localScaling),
                    this.rotationQuaternion
                        ? (this.rotationQuaternion.toRotationMatrix(this._localRotation), this._cache.rotationQuaternion.copyFrom(this.rotationQuaternion))
                        : (e.Matrix.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, this._localRotation), this._cache.rotation.copyFrom(this.rotation)),
                    this.infiniteDistance && !this.parent)
                ) {
                    var r = this.getScene().activeCamera;
                    if (r) {
                        var n = r.getWorldMatrix(),
                            o = new e.Vector3(n.m[12], n.m[13], n.m[14]);
                        e.Matrix.TranslationToRef(this.position.x + o.x, this.position.y + o.y, this.position.z + o.z, this._localTranslation);
                    }
                } else e.Matrix.TranslationToRef(this.position.x, this.position.y, this.position.z, this._localTranslation);
                if (
                    (this._pivotMatrix.multiplyToRef(this._localScaling, this._localPivotScaling),
                    this._localPivotScaling.multiplyToRef(this._localRotation, this._localPivotScalingRotation),
                    this.billboardMode !== i.BILLBOARDMODE_NONE && this.getScene().activeCamera)
                ) {
                    var s = this.position.clone(),
                        a = this.getScene().activeCamera.globalPosition.clone();
                    this.parent && this.parent.position && (s.addInPlace(this.parent.position), e.Matrix.TranslationToRef(s.x, s.y, s.z, this._localTranslation)),
                        (this.billboardMode & i.BILLBOARDMODE_ALL) !== i.BILLBOARDMODE_ALL &&
                            (this.billboardMode & i.BILLBOARDMODE_X && (a.x = s.x + e.Engine.Epsilon), this.billboardMode & i.BILLBOARDMODE_Y && (a.y = s.y + 0.001), this.billboardMode & i.BILLBOARDMODE_Z && (a.z = s.z + 0.001)),
                        e.Matrix.LookAtLHToRef(s, a, e.Vector3.Up(), this._localBillboard),
                        (this._localBillboard.m[12] = this._localBillboard.m[13] = this._localBillboard.m[14] = 0),
                        this._localBillboard.invert(),
                        this._localPivotScalingRotation.multiplyToRef(this._localBillboard, this._localWorld),
                        this._rotateYByPI.multiplyToRef(this._localWorld, this._localPivotScalingRotation);
                }
                this._localPivotScalingRotation.multiplyToRef(this._localTranslation, this._localWorld),
                    this.parent && this.parent.getWorldMatrix && this.billboardMode === i.BILLBOARDMODE_NONE
                        ? (this._markSyncedWithParent(),
                          this._meshToBoneReferal
                              ? (this._localMeshReferalTransform || (this._localMeshReferalTransform = e.Matrix.Zero()),
                                this._localWorld.multiplyToRef(this.parent.getWorldMatrix(), this._localMeshReferalTransform),
                                this._localMeshReferalTransform.multiplyToRef(this._meshToBoneReferal.getWorldMatrix(), this._worldMatrix))
                              : this._localWorld.multiplyToRef(this.parent.getWorldMatrix(), this._worldMatrix))
                        : this._worldMatrix.copyFrom(this._localWorld),
                    this._updateBoundingInfo(),
                    this._absolutePosition.copyFromFloats(this._worldMatrix.m[12], this._worldMatrix.m[13], this._worldMatrix.m[14]);
                for (var h = 0; h < this._onAfterWorldMatrixUpdate.length; h++) this._onAfterWorldMatrixUpdate[h](this);
                return this._worldMatrix;
            }),
            (i.prototype.registerAfterWorldMatrixUpdate = function (e) {
                this._onAfterWorldMatrixUpdate.push(e);
            }),
            (i.prototype.unregisterAfterWorldMatrixUpdate = function (e) {
                var t = this._onAfterWorldMatrixUpdate.indexOf(e);
                t > -1 && this._onAfterWorldMatrixUpdate.splice(t, 1);
            }),
            (i.prototype.setPositionWithLocalVector = function (t) {
                this.computeWorldMatrix(), (this.position = e.Vector3.TransformNormal(t, this._localWorld));
            }),
            (i.prototype.getPositionExpressedInLocalSpace = function () {
                this.computeWorldMatrix();
                var t = this._localWorld.clone();
                return t.invert(), e.Vector3.TransformNormal(this.position, t);
            }),
            (i.prototype.locallyTranslate = function (t) {
                this.computeWorldMatrix(!0), (this.position = e.Vector3.TransformCoordinates(t, this._localWorld));
            }),
            (i.prototype.lookAt = function (t, i, r, n) {
                (i = i || 0), (r = r || 0), (n = n || 0);
                var o = t.subtract(this.position),
                    s = -Math.atan2(o.z, o.x) - Math.PI / 2,
                    a = Math.sqrt(o.x * o.x + o.z * o.z),
                    h = Math.atan2(o.y, a);
                this.rotationQuaternion = e.Quaternion.RotationYawPitchRoll(s + i, h + r, n);
            }),
            (i.prototype.attachToBone = function (e, t) {
                (this._meshToBoneReferal = t), (this.parent = e), e.getWorldMatrix().determinant() < 0 && (this.scalingDeterminant *= -1);
            }),
            (i.prototype.detachFromBone = function () {
                this.parent.getWorldMatrix().determinant() < 0 && (this.scalingDeterminant *= -1), (this._meshToBoneReferal = null), (this.parent = null);
            }),
            (i.prototype.isInFrustum = function (e) {
                return this._boundingInfo.isInFrustum(e);
            }),
            (i.prototype.isCompletelyInFrustum = function (t) {
                t || (t = this.getScene().activeCamera);
                var i = t.getViewMatrix().multiply(t.getProjectionMatrix());
                return this._boundingInfo.isCompletelyInFrustum(e.Frustum.GetPlanes(i)) ? !0 : !1;
            }),
            (i.prototype.intersectsMesh = function (e, t) {
                return this._boundingInfo && e._boundingInfo ? this._boundingInfo.intersects(e._boundingInfo, t) : !1;
            }),
            (i.prototype.intersectsPoint = function (e) {
                return this._boundingInfo ? this._boundingInfo.intersectsPoint(e) : !1;
            }),
            (i.prototype.setPhysicsState = function (t, i) {
                var r = this.getScene().getPhysicsEngine();
                return r
                    ? ((t = t || e.PhysicsEngine.NoImpostor),
                      t.impostor && ((i = t), (t = t.impostor)),
                      t === e.PhysicsEngine.NoImpostor
                          ? (r._unregisterMesh(this), null)
                          : (i
                                ? (i.mass || 0 === i.mass || (i.mass = 0), i.friction || 0 === i.friction || (i.friction = 0.2), i.restitution || 0 === i.restitution || (i.restitution = 0.2))
                                : (i = { mass: 0, friction: 0.2, restitution: 0.2 }),
                            (this._physicImpostor = t),
                            (this._physicsMass = i.mass),
                            (this._physicsFriction = i.friction),
                            (this._physicRestitution = i.restitution),
                            r._registerMesh(this, t, i)))
                    : null;
            }),
            (i.prototype.getPhysicsImpostor = function () {
                return this._physicImpostor ? this._physicImpostor : e.PhysicsEngine.NoImpostor;
            }),
            (i.prototype.getPhysicsMass = function () {
                return this._physicsMass ? this._physicsMass : 0;
            }),
            (i.prototype.getPhysicsFriction = function () {
                return this._physicsFriction ? this._physicsFriction : 0;
            }),
            (i.prototype.getPhysicsRestitution = function () {
                return this._physicRestitution ? this._physicRestitution : 0;
            }),
            (i.prototype.getPositionInCameraSpace = function (t) {
                return t || (t = this.getScene().activeCamera), e.Vector3.TransformCoordinates(this.absolutePosition, t.getViewMatrix());
            }),
            (i.prototype.getDistanceToCamera = function (e) {
                return e || (e = this.getScene().activeCamera), this.absolutePosition.subtract(e.position).length();
            }),
            (i.prototype.applyImpulse = function (e, t) {
                this._physicImpostor && this.getScene().getPhysicsEngine()._applyImpulse(this, e, t);
            }),
            (i.prototype.setPhysicsLinkWith = function (e, t, i, r) {
                this._physicImpostor && this.getScene().getPhysicsEngine()._createLink(this, e, t, i, r);
            }),
            (i.prototype.updatePhysicsBodyPosition = function () {
                this._physicImpostor && this.getScene().getPhysicsEngine()._updateBodyPosition(this);
            }),
            Object.defineProperty(i.prototype, "checkCollisions", {
                get: function () {
                    return this._checkCollisions;
                },
                set: function (e) {
                    (this._checkCollisions = e), this.getScene().workerCollisions && this.getScene().collisionCoordinator.onMeshUpdated(this);
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.moveWithCollisions = function (e) {
                var t = this.getAbsolutePosition();
                t.subtractFromFloatsToRef(0, this.ellipsoid.y, 0, this._oldPositionForCollisions),
                    this._oldPositionForCollisions.addInPlace(this.ellipsoidOffset),
                    (this._collider.radius = this.ellipsoid),
                    this.getScene().collisionCoordinator.getNewPosition(this._oldPositionForCollisions, e, this._collider, 3, this, this._onCollisionPositionChange, this.uniqueId);
            }),
            (i.prototype.createOrUpdateSubmeshesOctree = function (t, i) {
                void 0 === t && (t = 64), void 0 === i && (i = 2), this._submeshesOctree || (this._submeshesOctree = new e.Octree(e.Octree.CreationFuncForSubMeshes, t, i)), this.computeWorldMatrix(!0);
                var r = this.getBoundingInfo().boundingBox;
                return this._submeshesOctree.update(r.minimumWorld, r.maximumWorld, this.subMeshes), this._submeshesOctree;
            }),
            (i.prototype._collideForSubMesh = function (t, i, r) {
                if ((this._generatePointsArray(), !t._lastColliderWorldVertices || !t._lastColliderTransformMatrix.equals(i))) {
                    (t._lastColliderTransformMatrix = i.clone()), (t._lastColliderWorldVertices = []), (t._trianglePlanes = []);
                    for (var n = t.verticesStart, o = t.verticesStart + t.verticesCount, s = n; o > s; s++) t._lastColliderWorldVertices.push(e.Vector3.TransformCoordinates(this._positions[s], i));
                }
                r._collide(t._trianglePlanes, t._lastColliderWorldVertices, this.getIndices(), t.indexStart, t.indexStart + t.indexCount, t.verticesStart, !!t.getMaterial()), r.collisionFound && (r.collidedMesh = this);
            }),
            (i.prototype._processCollisionsForSubMeshes = function (e, t) {
                var i, r;
                if (this._submeshesOctree && this.useOctreeForCollisions) {
                    var n = e.velocityWorldLength + Math.max(e.radius.x, e.radius.y, e.radius.z),
                        o = this._submeshesOctree.intersects(e.basePointWorld, n);
                    (r = o.length), (i = o.data);
                } else (i = this.subMeshes), (r = i.length);
                for (var s = 0; r > s; s++) {
                    var a = i[s];
                    (r > 1 && !a._checkCollision(e)) || this._collideForSubMesh(a, t, e);
                }
            }),
            (i.prototype._checkCollision = function (t) {
                this._boundingInfo._checkCollision(t) &&
                    (e.Matrix.ScalingToRef(1 / t.radius.x, 1 / t.radius.y, 1 / t.radius.z, this._collisionsScalingMatrix),
                    this.worldMatrixFromCache.multiplyToRef(this._collisionsScalingMatrix, this._collisionsTransformMatrix),
                    this._processCollisionsForSubMeshes(t, this._collisionsTransformMatrix));
            }),
            (i.prototype._generatePointsArray = function () {
                return !1;
            }),
            (i.prototype.intersects = function (t, i) {
                var r = new e.PickingInfo();
                if (!(this.subMeshes && this._boundingInfo && t.intersectsSphere(this._boundingInfo.boundingSphere) && t.intersectsBox(this._boundingInfo.boundingBox))) return r;
                if (!this._generatePointsArray()) return r;
                var n,
                    o,
                    s = null;
                if (this._submeshesOctree && this.useOctreeForPicking) {
                    var a = e.Ray.Transform(t, this.getWorldMatrix()),
                        h = this._submeshesOctree.intersectsRay(a);
                    (o = h.length), (n = h.data);
                } else (n = this.subMeshes), (o = n.length);
                for (var l = 0; o > l; l++) {
                    var c = n[l];
                    if (!(o > 1) || c.canIntersects(t)) {
                        var u = c.intersects(t, this._positions, this.getIndices(), i);
                        if (u && (i || !s || u.distance < s.distance) && ((s = u), (s.subMeshId = l), i)) break;
                    }
                }
                if (s) {
                    var f = this.getWorldMatrix(),
                        d = e.Vector3.TransformCoordinates(t.origin, f),
                        p = t.direction.clone();
                    p = p.scale(s.distance);
                    var m = e.Vector3.TransformNormal(p, f),
                        g = d.add(m);
                    return (r.hit = !0), (r.distance = e.Vector3.Distance(d, g)), (r.pickedPoint = g), (r.pickedMesh = this), (r.bu = s.bu), (r.bv = s.bv), (r.faceId = s.faceId), (r.subMeshId = s.subMeshId), r;
                }
                return r;
            }),
            (i.prototype.clone = function (e, t, i) {
                return null;
            }),
            (i.prototype.releaseSubMeshes = function () {
                if (this.subMeshes) for (; this.subMeshes.length; ) this.subMeshes[0].dispose();
                else this.subMeshes = new Array();
            }),
            (i.prototype.dispose = function (t) {
                var i;
                for (this.getPhysicsImpostor() !== e.PhysicsEngine.NoImpostor && this.setPhysicsState(e.PhysicsEngine.NoImpostor), i = 0; i < this._intersectionsInProgress.length; i++) {
                    var r = this._intersectionsInProgress[i],
                        n = r._intersectionsInProgress.indexOf(this);
                    r._intersectionsInProgress.splice(n, 1);
                }
                if (((this._intersectionsInProgress = []), this._edgesRenderer && (this._edgesRenderer.dispose(), (this._edgesRenderer = null)), this.releaseSubMeshes(), this.getScene().removeMesh(this), t))
                    for (i = 0; i < this.getScene().meshes.length; i++) {
                        var o = this.getScene().meshes[i];
                        o.parent === this && ((o.parent = null), o.computeWorldMatrix(!0));
                    }
                else {
                    for (i = 0; i < this.getScene().particleSystems.length; i++) this.getScene().particleSystems[i].emitter === this && (this.getScene().particleSystems[i].dispose(), i--);
                    var s = this.getScene().meshes.slice(0);
                    for (i = 0; i < s.length; i++) s[i].parent === this && s[i].dispose();
                }
                (this._onAfterWorldMatrixUpdate = []), (this._isDisposed = !0), this.onDispose && this.onDispose();
            }),
            (i._BILLBOARDMODE_NONE = 0),
            (i._BILLBOARDMODE_X = 1),
            (i._BILLBOARDMODE_Y = 2),
            (i._BILLBOARDMODE_Z = 4),
            (i._BILLBOARDMODE_ALL = 7),
            i
        );
    })(e.Node);
    e.AbstractMesh = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r) {
            t.call(this, i, r),
                (this.diffuse = new e.Color3(1, 1, 1)),
                (this.specular = new e.Color3(1, 1, 1)),
                (this.intensity = 1),
                (this.range = Number.MAX_VALUE),
                (this.includeOnlyWithLayerMask = 0),
                (this.includedOnlyMeshes = new Array()),
                (this.excludedMeshes = new Array()),
                (this.excludeWithLayerMask = 0),
                (this._excludedMeshesIds = new Array()),
                (this._includedOnlyMeshesIds = new Array()),
                r.addLight(this);
        }
        return (
            __extends(i, t),
            (i.prototype.getShadowGenerator = function () {
                return this._shadowGenerator;
            }),
            (i.prototype.getAbsolutePosition = function () {
                return e.Vector3.Zero();
            }),
            (i.prototype.transferToEffect = function (e, t, i) {}),
            (i.prototype._getWorldMatrix = function () {
                return e.Matrix.Identity();
            }),
            (i.prototype.canAffectMesh = function (e) {
                return e
                    ? this.includedOnlyMeshes.length > 0 && -1 === this.includedOnlyMeshes.indexOf(e)
                        ? !1
                        : this.excludedMeshes.length > 0 && -1 !== this.excludedMeshes.indexOf(e)
                        ? !1
                        : 0 !== this.includeOnlyWithLayerMask && 0 === (this.includeOnlyWithLayerMask & e.layerMask)
                        ? !1
                        : 0 !== this.excludeWithLayerMask && this.excludeWithLayerMask & e.layerMask
                        ? !1
                        : !0
                    : !0;
            }),
            (i.prototype.getWorldMatrix = function () {
                this._currentRenderId = this.getScene().getRenderId();
                var t = this._getWorldMatrix();
                return this.parent && this.parent.getWorldMatrix
                    ? (this._parentedWorldMatrix || (this._parentedWorldMatrix = e.Matrix.Identity()), t.multiplyToRef(this.parent.getWorldMatrix(), this._parentedWorldMatrix), this._markSyncedWithParent(), this._parentedWorldMatrix)
                    : t;
            }),
            (i.prototype.dispose = function () {
                this._shadowGenerator && (this._shadowGenerator.dispose(), (this._shadowGenerator = null)), this.getScene().removeLight(this);
            }),
            i
        );
    })(e.Node);
    e.Light = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(e, i, r) {
            t.call(this, e, r), (this.position = i);
        }
        return (
            __extends(i, t),
            (i.prototype.getAbsolutePosition = function () {
                return this._transformedPosition ? this._transformedPosition : this.position;
            }),
            (i.prototype.transferToEffect = function (t, i) {
                return this.parent && this.parent.getWorldMatrix
                    ? (this._transformedPosition || (this._transformedPosition = e.Vector3.Zero()),
                      e.Vector3.TransformCoordinatesToRef(this.position, this.parent.getWorldMatrix(), this._transformedPosition),
                      void t.setFloat4(i, this._transformedPosition.x, this._transformedPosition.y, this._transformedPosition.z, 0))
                    : void t.setFloat4(i, this.position.x, this.position.y, this.position.z, 0);
            }),
            (i.prototype.getShadowGenerator = function () {
                return null;
            }),
            (i.prototype._getWorldMatrix = function () {
                return this._worldMatrix || (this._worldMatrix = e.Matrix.Identity()), e.Matrix.TranslationToRef(this.position.x, this.position.y, this.position.z, this._worldMatrix), this._worldMatrix;
            }),
            i
        );
    })(e.Light);
    e.PointLight = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(e, i, r, n, o, s) {
            t.call(this, e, s), (this.position = i), (this.direction = r), (this.angle = n), (this.exponent = o);
        }
        return (
            __extends(i, t),
            (i.prototype.getAbsolutePosition = function () {
                return this.transformedPosition ? this.transformedPosition : this.position;
            }),
            (i.prototype.setShadowProjectionMatrix = function (t, i, r) {
                var n = this.getScene().activeCamera;
                e.Matrix.PerspectiveFovLHToRef(this.angle, 1, n.minZ, n.maxZ, t);
            }),
            (i.prototype.supportsVSM = function () {
                return !0;
            }),
            (i.prototype.needRefreshPerFrame = function () {
                return !1;
            }),
            (i.prototype.setDirectionToTarget = function (t) {
                return (this.direction = e.Vector3.Normalize(t.subtract(this.position))), this.direction;
            }),
            (i.prototype.computeTransformedPosition = function () {
                return this.parent && this.parent.getWorldMatrix
                    ? (this.transformedPosition || (this.transformedPosition = e.Vector3.Zero()), e.Vector3.TransformCoordinatesToRef(this.position, this.parent.getWorldMatrix(), this.transformedPosition), !0)
                    : !1;
            }),
            (i.prototype.transferToEffect = function (t, i, r) {
                var n;
                this.parent && this.parent.getWorldMatrix
                    ? (this._transformedDirection || (this._transformedDirection = e.Vector3.Zero()),
                      this.computeTransformedPosition(),
                      e.Vector3.TransformNormalToRef(this.direction, this.parent.getWorldMatrix(), this._transformedDirection),
                      t.setFloat4(i, this.transformedPosition.x, this.transformedPosition.y, this.transformedPosition.z, this.exponent),
                      (n = e.Vector3.Normalize(this._transformedDirection)))
                    : (t.setFloat4(i, this.position.x, this.position.y, this.position.z, this.exponent), (n = e.Vector3.Normalize(this.direction))),
                    t.setFloat4(r, n.x, n.y, n.z, Math.cos(0.5 * this.angle));
            }),
            (i.prototype._getWorldMatrix = function () {
                return this._worldMatrix || (this._worldMatrix = e.Matrix.Identity()), e.Matrix.TranslationToRef(this.position.x, this.position.y, this.position.z, this._worldMatrix), this._worldMatrix;
            }),
            i
        );
    })(e.Light);
    e.SpotLight = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n) {
            t.call(this, i, n), (this.direction = r), (this.groundColor = new e.Color3(0, 0, 0));
        }
        return (
            __extends(i, t),
            (i.prototype.setDirectionToTarget = function (t) {
                return (this.direction = e.Vector3.Normalize(t.subtract(e.Vector3.Zero()))), this.direction;
            }),
            (i.prototype.getShadowGenerator = function () {
                return null;
            }),
            (i.prototype.transferToEffect = function (t, i, r) {
                var n = e.Vector3.Normalize(this.direction);
                t.setFloat4(i, n.x, n.y, n.z, 0), t.setColor3(r, this.groundColor.scale(this.intensity));
            }),
            (i.prototype._getWorldMatrix = function () {
                return this._worldMatrix || (this._worldMatrix = e.Matrix.Identity()), this._worldMatrix;
            }),
            i
        );
    })(e.Light);
    e.HemisphericLight = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(e, i, r) {
            t.call(this, e, r), (this.direction = i), (this.shadowOrthoScale = 0.5), (this.position = i.scale(-1));
        }
        return (
            __extends(i, t),
            (i.prototype.getAbsolutePosition = function () {
                return this.transformedPosition ? this.transformedPosition : this.position;
            }),
            (i.prototype.setDirectionToTarget = function (t) {
                return (this.direction = e.Vector3.Normalize(t.subtract(this.position))), this.direction;
            }),
            (i.prototype.setShadowProjectionMatrix = function (t, i, r) {
                for (var n = Number.MAX_VALUE, o = Number.MIN_VALUE, s = Number.MIN_VALUE, a = Number.MAX_VALUE, h = e.Vector3.Zero(), l = this.getScene().activeCamera, c = 0; c < r.length; c++) {
                    var u = r[c];
                    if (u) {
                        var f = u.getBoundingInfo();
                        if (f)
                            for (var d = f.boundingBox, p = 0; p < d.vectorsWorld.length; p++)
                                e.Vector3.TransformCoordinatesToRef(d.vectorsWorld[p], i, h), h.x < n && (n = h.x), h.y < a && (a = h.y), h.x > o && (o = h.x), h.y > s && (s = h.y);
                    }
                }
                var m = o - n,
                    g = s - a;
                e.Matrix.OrthoOffCenterLHToRef(n - m * this.shadowOrthoScale, o + m * this.shadowOrthoScale, a - g * this.shadowOrthoScale, s + g * this.shadowOrthoScale, -l.maxZ, l.maxZ, t);
            }),
            (i.prototype.supportsVSM = function () {
                return !0;
            }),
            (i.prototype.needRefreshPerFrame = function () {
                return !0;
            }),
            (i.prototype.computeTransformedPosition = function () {
                return this.parent && this.parent.getWorldMatrix
                    ? (this.transformedPosition || (this.transformedPosition = e.Vector3.Zero()), e.Vector3.TransformCoordinatesToRef(this.position, this.parent.getWorldMatrix(), this.transformedPosition), !0)
                    : !1;
            }),
            (i.prototype.transferToEffect = function (t, i) {
                return this.parent && this.parent.getWorldMatrix
                    ? (this._transformedDirection || (this._transformedDirection = e.Vector3.Zero()),
                      e.Vector3.TransformNormalToRef(this.direction, this.parent.getWorldMatrix(), this._transformedDirection),
                      void t.setFloat4(i, this._transformedDirection.x, this._transformedDirection.y, this._transformedDirection.z, 1))
                    : void t.setFloat4(i, this.direction.x, this.direction.y, this.direction.z, 1);
            }),
            (i.prototype._getWorldMatrix = function () {
                return this._worldMatrix || (this._worldMatrix = e.Matrix.Identity()), e.Matrix.TranslationToRef(this.position.x, this.position.y, this.position.z, this._worldMatrix), this._worldMatrix;
            }),
            i
        );
    })(e.Light);
    e.DirectionalLight = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(i, r) {
            var n = this;
            (this._filter = t.FILTER_NONE),
                (this.blurScale = 2),
                (this._blurBoxOffset = 0),
                (this._bias = 5e-5),
                (this._lightDirection = e.Vector3.Zero()),
                (this._darkness = 0),
                (this._transparencyShadow = !1),
                (this._viewMatrix = e.Matrix.Zero()),
                (this._projectionMatrix = e.Matrix.Zero()),
                (this._transformMatrix = e.Matrix.Zero()),
                (this._worldViewProjection = e.Matrix.Zero()),
                (this._light = r),
                (this._scene = r.getScene()),
                (this._mapSize = i),
                (r._shadowGenerator = this),
                (this._shadowMap = new e.RenderTargetTexture(r.name + "_shadowMap", i, this._scene, !1)),
                (this._shadowMap.wrapU = e.Texture.CLAMP_ADDRESSMODE),
                (this._shadowMap.wrapV = e.Texture.CLAMP_ADDRESSMODE),
                (this._shadowMap.anisotropicFilteringLevel = 1),
                this._shadowMap.updateSamplingMode(e.Texture.NEAREST_SAMPLINGMODE),
                (this._shadowMap.renderParticles = !1),
                (this._shadowMap.onAfterUnbind = function () {
                    n.useBlurVarianceShadowMap &&
                        (n._shadowMap2 ||
                            ((n._shadowMap2 = new e.RenderTargetTexture(r.name + "_shadowMap", i, n._scene, !1)),
                            (n._shadowMap2.wrapU = e.Texture.CLAMP_ADDRESSMODE),
                            (n._shadowMap2.wrapV = e.Texture.CLAMP_ADDRESSMODE),
                            n._shadowMap2.updateSamplingMode(e.Texture.TRILINEAR_SAMPLINGMODE),
                            (n._downSamplePostprocess = new e.PassPostProcess("downScale", 1 / n.blurScale, null, e.Texture.BILINEAR_SAMPLINGMODE, n._scene.getEngine())),
                            (n._downSamplePostprocess.onApply = function (e) {
                                e.setTexture("textureSampler", n._shadowMap);
                            }),
                            (n.blurBoxOffset = 1)),
                        n._scene.postProcessManager.directRender([n._downSamplePostprocess, n._boxBlurPostprocess], n._shadowMap2.getInternalTexture()));
                });
            var o = function (t) {
                var i = t.getRenderingMesh(),
                    r = n._scene,
                    o = r.getEngine();
                o.setState(t.getMaterial().backFaceCulling);
                var s = i._getInstancesRenderList(t._id);
                if (!s.mustReturn) {
                    var a = null !== o.getCaps().instancedArrays && null !== s.visibleInstances[t._id];
                    if (n.isReady(t, a)) {
                        o.enableEffect(n._effect), i._bind(t, n._effect, e.Material.TriangleFillMode);
                        var h = t.getMaterial();
                        if ((n._effect.setMatrix("viewProjection", n.getTransformMatrix()), h && h.needAlphaTesting())) {
                            var l = h.getAlphaTestTexture();
                            n._effect.setTexture("diffuseSampler", l), n._effect.setMatrix("diffuseMatrix", l.getTextureMatrix());
                        }
                        i.useBones && i.computeBonesUsingShaders && n._effect.setMatrices("mBones", i.skeleton.getTransformMatrices()),
                            i._processRendering(t, n._effect, e.Material.TriangleFillMode, s, a, function (e, t) {
                                return n._effect.setMatrix("world", t);
                            });
                    } else n._shadowMap.resetRefreshCounter();
                }
            };
            (this._shadowMap.customRenderFunction = function (e, t, i) {
                var r;
                for (r = 0; r < e.length; r++) o(e.data[r]);
                for (r = 0; r < t.length; r++) o(t.data[r]);
                if (n._transparencyShadow) for (r = 0; r < i.length; r++) o(i.data[r]);
            }),
                (this._shadowMap.onClear = function (t) {
                    n.useBlurVarianceShadowMap || n.useVarianceShadowMap ? t.clear(new e.Color4(0, 0, 0, 0), !0, !0) : t.clear(new e.Color4(1, 1, 1, 1), !0, !0);
                });
        }
        return (
            Object.defineProperty(t, "FILTER_NONE", {
                get: function () {
                    return t._FILTER_NONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "FILTER_VARIANCESHADOWMAP", {
                get: function () {
                    return t._FILTER_VARIANCESHADOWMAP;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "FILTER_POISSONSAMPLING", {
                get: function () {
                    return t._FILTER_POISSONSAMPLING;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "FILTER_BLURVARIANCESHADOWMAP", {
                get: function () {
                    return t._FILTER_BLURVARIANCESHADOWMAP;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "bias", {
                get: function () {
                    return this._bias;
                },
                set: function (e) {
                    this._bias = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "blurBoxOffset", {
                get: function () {
                    return this._blurBoxOffset;
                },
                set: function (t) {
                    var i = this;
                    this._blurBoxOffset !== t &&
                        ((this._blurBoxOffset = t),
                        this._boxBlurPostprocess && this._boxBlurPostprocess.dispose(),
                        (this._boxBlurPostprocess = new e.PostProcess(
                            "DepthBoxBlur",
                            "depthBoxBlur",
                            ["screenSize", "boxOffset"],
                            [],
                            1 / this.blurScale,
                            null,
                            e.Texture.BILINEAR_SAMPLINGMODE,
                            this._scene.getEngine(),
                            !1,
                            "#define OFFSET " + t
                        )),
                        (this._boxBlurPostprocess.onApply = function (e) {
                            e.setFloat2("screenSize", i._mapSize / i.blurScale, i._mapSize / i.blurScale);
                        }));
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "filter", {
                get: function () {
                    return this._filter;
                },
                set: function (t) {
                    this._filter !== t &&
                        ((this._filter = t),
                        this.useVarianceShadowMap || this.useBlurVarianceShadowMap
                            ? ((this._shadowMap.anisotropicFilteringLevel = 16), this._shadowMap.updateSamplingMode(e.Texture.BILINEAR_SAMPLINGMODE))
                            : ((this._shadowMap.anisotropicFilteringLevel = 1), this._shadowMap.updateSamplingMode(e.Texture.NEAREST_SAMPLINGMODE)));
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "useVarianceShadowMap", {
                get: function () {
                    return this.filter === t.FILTER_VARIANCESHADOWMAP && this._light.supportsVSM();
                },
                set: function (e) {
                    this.filter = e ? t.FILTER_VARIANCESHADOWMAP : t.FILTER_NONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "usePoissonSampling", {
                get: function () {
                    return this.filter === t.FILTER_POISSONSAMPLING || (!this._light.supportsVSM() && (this.filter === t.FILTER_VARIANCESHADOWMAP || this.filter === t.FILTER_BLURVARIANCESHADOWMAP));
                },
                set: function (e) {
                    this.filter = e ? t.FILTER_POISSONSAMPLING : t.FILTER_NONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "useBlurVarianceShadowMap", {
                get: function () {
                    return this.filter === t.FILTER_BLURVARIANCESHADOWMAP && this._light.supportsVSM();
                },
                set: function (e) {
                    this.filter = e ? t.FILTER_BLURVARIANCESHADOWMAP : t.FILTER_NONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype.isReady = function (t, i) {
                var r = [];
                (this.useVarianceShadowMap || this.useBlurVarianceShadowMap) && r.push("#define VSM");
                var n = [e.VertexBuffer.PositionKind],
                    o = t.getMesh(),
                    s = t.getMaterial();
                s &&
                    s.needAlphaTesting() &&
                    (r.push("#define ALPHATEST"),
                    o.isVerticesDataPresent(e.VertexBuffer.UVKind) && (n.push(e.VertexBuffer.UVKind), r.push("#define UV1")),
                    o.isVerticesDataPresent(e.VertexBuffer.UV2Kind) && (n.push(e.VertexBuffer.UV2Kind), r.push("#define UV2"))),
                    o.useBones &&
                        o.computeBonesUsingShaders &&
                        (n.push(e.VertexBuffer.MatricesIndicesKind), n.push(e.VertexBuffer.MatricesWeightsKind), r.push("#define BONES"), r.push("#define BonesPerMesh " + (o.skeleton.bones.length + 1))),
                    i && (r.push("#define INSTANCES"), n.push("world0"), n.push("world1"), n.push("world2"), n.push("world3"));
                var a = r.join("\n");
                return (
                    this._cachedDefines !== a && ((this._cachedDefines = a), (this._effect = this._scene.getEngine().createEffect("shadowMap", n, ["world", "mBones", "viewProjection", "diffuseMatrix"], ["diffuseSampler"], a))),
                    this._effect.isReady()
                );
            }),
            (t.prototype.getShadowMap = function () {
                return this._shadowMap;
            }),
            (t.prototype.getShadowMapForRendering = function () {
                return this._shadowMap2 ? this._shadowMap2 : this._shadowMap;
            }),
            (t.prototype.getLight = function () {
                return this._light;
            }),
            (t.prototype.getTransformMatrix = function () {
                var t = this._scene;
                if (this._currentRenderID === t.getRenderId()) return this._transformMatrix;
                this._currentRenderID = t.getRenderId();
                var i = this._light.position;
                return (
                    e.Vector3.NormalizeToRef(this._light.direction, this._lightDirection),
                    1 == Math.abs(e.Vector3.Dot(this._lightDirection, e.Vector3.Up())) && (this._lightDirection.z = 1e-13),
                    this._light.computeTransformedPosition() && (i = this._light.transformedPosition),
                    (!this._light.needRefreshPerFrame() && this._cachedPosition && this._cachedDirection && i.equals(this._cachedPosition) && this._lightDirection.equals(this._cachedDirection)) ||
                        ((this._cachedPosition = i.clone()),
                        (this._cachedDirection = this._lightDirection.clone()),
                        e.Matrix.LookAtLHToRef(i, this._light.position.add(this._lightDirection), e.Vector3.Up(), this._viewMatrix),
                        this._light.setShadowProjectionMatrix(this._projectionMatrix, this._viewMatrix, this.getShadowMap().renderList),
                        this._viewMatrix.multiplyToRef(this._projectionMatrix, this._transformMatrix)),
                    this._transformMatrix
                );
            }),
            (t.prototype.getDarkness = function () {
                return this._darkness;
            }),
            (t.prototype.setDarkness = function (e) {
                this._darkness = e >= 1 ? 1 : 0 >= e ? 0 : e;
            }),
            (t.prototype.setTransparencyShadow = function (e) {
                this._transparencyShadow = e;
            }),
            (t.prototype._packHalf = function (t) {
                var i = 255 * t,
                    r = i - Math.floor(i);
                return new e.Vector2(t - r / 255, r);
            }),
            (t.prototype.dispose = function () {
                this._shadowMap.dispose(), this._shadowMap2 && this._shadowMap2.dispose(), this._downSamplePostprocess && this._downSamplePostprocess.dispose(), this._boxBlurPostprocess && this._boxBlurPostprocess.dispose();
            }),
            (t._FILTER_NONE = 0),
            (t._FILTER_VARIANCESHADOWMAP = 1),
            (t._FILTER_POISSONSAMPLING = 2),
            (t._FILTER_BLURVARIANCESHADOWMAP = 3),
            t
        );
    })();
    e.ShadowGenerator = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = function (e, t, i, r) {
            return e.x > i.x + r ? !1 : i.x - r > t.x ? !1 : e.y > i.y + r ? !1 : i.y - r > t.y ? !1 : e.z > i.z + r ? !1 : i.z - r > t.z ? !1 : !0;
        },
        i = function (e, t, i, r) {
            var n = t * t - 4 * e * i,
                o = { root: 0, found: !1 };
            if (0 > n) return o;
            var s = Math.sqrt(n),
                a = (-t - s) / (2 * e),
                h = (-t + s) / (2 * e);
            if (a > h) {
                var l = h;
                (h = a), (a = l);
            }
            return a > 0 && r > a ? ((o.root = a), (o.found = !0), o) : h > 0 && r > h ? ((o.root = h), (o.found = !0), o) : o;
        },
        r = (function () {
            function r() {
                (this.radius = new e.Vector3(1, 1, 1)),
                    (this.retry = 0),
                    (this.basePointWorld = e.Vector3.Zero()),
                    (this.velocityWorld = e.Vector3.Zero()),
                    (this.normalizedVelocity = e.Vector3.Zero()),
                    (this._collisionPoint = e.Vector3.Zero()),
                    (this._planeIntersectionPoint = e.Vector3.Zero()),
                    (this._tempVector = e.Vector3.Zero()),
                    (this._tempVector2 = e.Vector3.Zero()),
                    (this._tempVector3 = e.Vector3.Zero()),
                    (this._tempVector4 = e.Vector3.Zero()),
                    (this._edge = e.Vector3.Zero()),
                    (this._baseToVertex = e.Vector3.Zero()),
                    (this._destinationPoint = e.Vector3.Zero()),
                    (this._slidePlaneNormal = e.Vector3.Zero()),
                    (this._displacementVector = e.Vector3.Zero());
            }
            return (
                (r.prototype._initialize = function (t, i, r) {
                    (this.velocity = i),
                        e.Vector3.NormalizeToRef(i, this.normalizedVelocity),
                        (this.basePoint = t),
                        t.multiplyToRef(this.radius, this.basePointWorld),
                        i.multiplyToRef(this.radius, this.velocityWorld),
                        (this.velocityWorldLength = this.velocityWorld.length()),
                        (this.epsilon = r),
                        (this.collisionFound = !1);
                }),
                (r.prototype._checkPointInTriangle = function (t, i, r, n, o) {
                    i.subtractToRef(t, this._tempVector), r.subtractToRef(t, this._tempVector2), e.Vector3.CrossToRef(this._tempVector, this._tempVector2, this._tempVector4);
                    var s = e.Vector3.Dot(this._tempVector4, o);
                    return 0 > s
                        ? !1
                        : (n.subtractToRef(t, this._tempVector3),
                          e.Vector3.CrossToRef(this._tempVector2, this._tempVector3, this._tempVector4),
                          (s = e.Vector3.Dot(this._tempVector4, o)),
                          0 > s ? !1 : (e.Vector3.CrossToRef(this._tempVector3, this._tempVector, this._tempVector4), (s = e.Vector3.Dot(this._tempVector4, o)), s >= 0));
                }),
                (r.prototype._canDoCollision = function (i, r, n, o) {
                    var s = e.Vector3.Distance(this.basePointWorld, i),
                        a = Math.max(this.radius.x, this.radius.y, this.radius.z);
                    return s > this.velocityWorldLength + a + r ? !1 : t(n, o, this.basePointWorld, this.velocityWorldLength + a) ? !0 : !1;
                }),
                (r.prototype._testTriangle = function (t, r, n, o, s, a) {
                    var h,
                        l = !1;
                    r || (r = []), r[t] || ((r[t] = new e.Plane(0, 0, 0, 0)), r[t].copyFromPoints(n, o, s));
                    var c = r[t];
                    if (a || c.isFrontFacingTo(this.normalizedVelocity, 0)) {
                        var u = c.signedDistanceTo(this.basePoint),
                            f = e.Vector3.Dot(c.normal, this.velocity);
                        if (0 == f) {
                            if (Math.abs(u) >= 1) return;
                            (l = !0), (h = 0);
                        } else {
                            h = (-1 - u) / f;
                            var d = (1 - u) / f;
                            if (h > d) {
                                var p = d;
                                (d = h), (h = p);
                            }
                            if (h > 1 || 0 > d) return;
                            0 > h && (h = 0), h > 1 && (h = 1);
                        }
                        this._collisionPoint.copyFromFloats(0, 0, 0);
                        var m = !1,
                            g = 1;
                        if (
                            (l ||
                                (this.basePoint.subtractToRef(c.normal, this._planeIntersectionPoint),
                                this.velocity.scaleToRef(h, this._tempVector),
                                this._planeIntersectionPoint.addInPlace(this._tempVector),
                                this._checkPointInTriangle(this._planeIntersectionPoint, n, o, s, c.normal) && ((m = !0), (g = h), this._collisionPoint.copyFrom(this._planeIntersectionPoint))),
                            !m)
                        ) {
                            var _ = this.velocity.lengthSquared(),
                                v = _;
                            this.basePoint.subtractToRef(n, this._tempVector);
                            var y = 2 * e.Vector3.Dot(this.velocity, this._tempVector),
                                x = this._tempVector.lengthSquared() - 1,
                                M = i(v, y, x, g);
                            M.found && ((g = M.root), (m = !0), this._collisionPoint.copyFrom(n)),
                                this.basePoint.subtractToRef(o, this._tempVector),
                                (y = 2 * e.Vector3.Dot(this.velocity, this._tempVector)),
                                (x = this._tempVector.lengthSquared() - 1),
                                (M = i(v, y, x, g)),
                                M.found && ((g = M.root), (m = !0), this._collisionPoint.copyFrom(o)),
                                this.basePoint.subtractToRef(s, this._tempVector),
                                (y = 2 * e.Vector3.Dot(this.velocity, this._tempVector)),
                                (x = this._tempVector.lengthSquared() - 1),
                                (M = i(v, y, x, g)),
                                M.found && ((g = M.root), (m = !0), this._collisionPoint.copyFrom(s)),
                                o.subtractToRef(n, this._edge),
                                n.subtractToRef(this.basePoint, this._baseToVertex);
                            var S = this._edge.lengthSquared(),
                                b = e.Vector3.Dot(this._edge, this.velocity),
                                A = e.Vector3.Dot(this._edge, this._baseToVertex);
                            if (((v = S * -_ + b * b), (y = 2 * S * e.Vector3.Dot(this.velocity, this._baseToVertex) - 2 * b * A), (x = S * (1 - this._baseToVertex.lengthSquared()) + A * A), (M = i(v, y, x, g)), M.found)) {
                                var T = (b * M.root - A) / S;
                                T >= 0 && 1 >= T && ((g = M.root), (m = !0), this._edge.scaleInPlace(T), n.addToRef(this._edge, this._collisionPoint));
                            }
                            s.subtractToRef(o, this._edge),
                                o.subtractToRef(this.basePoint, this._baseToVertex),
                                (S = this._edge.lengthSquared()),
                                (b = e.Vector3.Dot(this._edge, this.velocity)),
                                (A = e.Vector3.Dot(this._edge, this._baseToVertex)),
                                (v = S * -_ + b * b),
                                (y = 2 * S * e.Vector3.Dot(this.velocity, this._baseToVertex) - 2 * b * A),
                                (x = S * (1 - this._baseToVertex.lengthSquared()) + A * A),
                                (M = i(v, y, x, g)),
                                M.found && ((T = (b * M.root - A) / S), T >= 0 && 1 >= T && ((g = M.root), (m = !0), this._edge.scaleInPlace(T), o.addToRef(this._edge, this._collisionPoint))),
                                n.subtractToRef(s, this._edge),
                                s.subtractToRef(this.basePoint, this._baseToVertex),
                                (S = this._edge.lengthSquared()),
                                (b = e.Vector3.Dot(this._edge, this.velocity)),
                                (A = e.Vector3.Dot(this._edge, this._baseToVertex)),
                                (v = S * -_ + b * b),
                                (y = 2 * S * e.Vector3.Dot(this.velocity, this._baseToVertex) - 2 * b * A),
                                (x = S * (1 - this._baseToVertex.lengthSquared()) + A * A),
                                (M = i(v, y, x, g)),
                                M.found && ((T = (b * M.root - A) / S), T >= 0 && 1 >= T && ((g = M.root), (m = !0), this._edge.scaleInPlace(T), s.addToRef(this._edge, this._collisionPoint)));
                        }
                        if (m) {
                            var E = g * this.velocity.length();
                            (!this.collisionFound || E < this.nearestDistance) &&
                                (this.intersectionPoint ? this.intersectionPoint.copyFrom(this._collisionPoint) : (this.intersectionPoint = this._collisionPoint.clone()), (this.nearestDistance = E), (this.collisionFound = !0));
                        }
                    }
                }),
                (r.prototype._collide = function (e, t, i, r, n, o, s) {
                    for (var a = r; n > a; a += 3) {
                        var h = t[i[a] - o],
                            l = t[i[a + 1] - o],
                            c = t[i[a + 2] - o];
                        this._testTriangle(a, e, c, l, h, s);
                    }
                }),
                (r.prototype._getResponse = function (t, i) {
                    t.addToRef(i, this._destinationPoint),
                        i.scaleInPlace(this.nearestDistance / i.length()),
                        this.basePoint.addToRef(i, t),
                        t.subtractToRef(this.intersectionPoint, this._slidePlaneNormal),
                        this._slidePlaneNormal.normalize(),
                        this._slidePlaneNormal.scaleToRef(this.epsilon, this._displacementVector),
                        t.addInPlace(this._displacementVector),
                        this.intersectionPoint.addInPlace(this._displacementVector),
                        this._slidePlaneNormal.scaleInPlace(e.Plane.SignedDistanceToPlaneFromPositionAndNormal(this.intersectionPoint, this._slidePlaneNormal, this._destinationPoint)),
                        this._destinationPoint.subtractInPlace(this._slidePlaneNormal),
                        this._destinationPoint.subtractToRef(this.intersectionPoint, i);
                }),
                r
            );
        })();
    e.Collider = r;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    (e.CollisionWorker = ""),
        (function (e) {
            (e[(e.INIT = 0)] = "INIT"), (e[(e.UPDATE = 1)] = "UPDATE"), (e[(e.COLLIDE = 2)] = "COLLIDE");
        })(e.WorkerTaskType || (e.WorkerTaskType = {}));
    var t = e.WorkerTaskType;
    !(function (e) {
        (e[(e.SUCCESS = 0)] = "SUCCESS"), (e[(e.UNKNOWN_ERROR = 1)] = "UNKNOWN_ERROR");
    })(e.WorkerReplyType || (e.WorkerReplyType = {}));
    var i = e.WorkerReplyType,
        r = (function () {
            function r() {
                var n = this;
                (this._scaledPosition = e.Vector3.Zero()),
                    (this._scaledVelocity = e.Vector3.Zero()),
                    (this.onMeshUpdated = function (e) {
                        n._addUpdateMeshesList[e.uniqueId] = r.SerializeMesh(e);
                    }),
                    (this.onGeometryUpdated = function (e) {
                        n._addUpdateGeometriesList[e.id] = r.SerializeGeometry(e);
                    }),
                    (this._afterRender = function () {
                        if (
                            n._init &&
                            !((0 == n._toRemoveGeometryArray.length && 0 == n._toRemoveMeshesArray.length && 0 == Object.keys(n._addUpdateGeometriesList).length && 0 == Object.keys(n._addUpdateMeshesList).length) || n._runningUpdated > 4)
                        ) {
                            ++n._runningUpdated;
                            var e = { updatedMeshes: n._addUpdateMeshesList, updatedGeometries: n._addUpdateGeometriesList, removedGeometries: n._toRemoveGeometryArray, removedMeshes: n._toRemoveMeshesArray },
                                i = { payload: e, taskType: t.UPDATE },
                                r = [];
                            for (var o in e.updatedGeometries)
                                e.updatedGeometries.hasOwnProperty(o) &&
                                    (r.push(i.payload.updatedGeometries[o].indices.buffer), r.push(i.payload.updatedGeometries[o].normals.buffer), r.push(i.payload.updatedGeometries[o].positions.buffer));
                            n._worker.postMessage(i, r), (n._addUpdateMeshesList = {}), (n._addUpdateGeometriesList = {}), (n._toRemoveGeometryArray = []), (n._toRemoveMeshesArray = []);
                        }
                    }),
                    (this._onMessageFromWorker = function (r) {
                        var o = r.data;
                        if (o.error != i.SUCCESS) return void e.Tools.Warn("error returned from worker!");
                        switch (o.taskType) {
                            case t.INIT:
                                (n._init = !0),
                                    n._scene.meshes.forEach(function (e) {
                                        n.onMeshAdded(e);
                                    }),
                                    n._scene.getGeometries().forEach(function (e) {
                                        n.onGeometryAdded(e);
                                    });
                                break;
                            case t.UPDATE:
                                n._runningUpdated--;
                                break;
                            case t.COLLIDE:
                                n._runningCollisionTask = !1;
                                var s = o.payload;
                                if (!n._collisionsCallbackArray[s.collisionId]) return;
                                n._collisionsCallbackArray[s.collisionId](s.collisionId, e.Vector3.FromArray(s.newPosition), n._scene.getMeshByUniqueID(s.collidedMeshUniqueId)), (n._collisionsCallbackArray[s.collisionId] = void 0);
                        }
                    }),
                    (this._collisionsCallbackArray = []),
                    (this._init = !1),
                    (this._runningUpdated = 0),
                    (this._runningCollisionTask = !1),
                    (this._addUpdateMeshesList = {}),
                    (this._addUpdateGeometriesList = {}),
                    (this._toRemoveGeometryArray = []),
                    (this._toRemoveMeshesArray = []);
            }
            return (
                (r.prototype.getNewPosition = function (e, i, r, n, o, s, a) {
                    if (this._init && !this._collisionsCallbackArray[a] && !this._collisionsCallbackArray[a + 1e5]) {
                        e.divideToRef(r.radius, this._scaledPosition), i.divideToRef(r.radius, this._scaledVelocity), (this._collisionsCallbackArray[a] = s);
                        var h = { collider: { position: this._scaledPosition.asArray(), velocity: this._scaledVelocity.asArray(), radius: r.radius.asArray() }, collisionId: a, excludedMeshUniqueId: o ? o.uniqueId : null, maximumRetry: n },
                            l = { payload: h, taskType: t.COLLIDE };
                        this._worker.postMessage(l);
                    }
                }),
                (r.prototype.init = function (i) {
                    (this._scene = i), this._scene.registerAfterRender(this._afterRender);
                    var r = e.WorkerIncluded ? e.Engine.CodeRepository + "Collisions/babylon.collisionWorker.js" : URL.createObjectURL(new Blob([e.CollisionWorker], { type: "application/javascript" }));
                    (this._worker = new Worker(r)), (this._worker.onmessage = this._onMessageFromWorker);
                    var n = { payload: {}, taskType: t.INIT };
                    this._worker.postMessage(n);
                }),
                (r.prototype.destroy = function () {
                    this._scene.unregisterAfterRender(this._afterRender), this._worker.terminate();
                }),
                (r.prototype.onMeshAdded = function (e) {
                    e.registerAfterWorldMatrixUpdate(this.onMeshUpdated), this.onMeshUpdated(e);
                }),
                (r.prototype.onMeshRemoved = function (e) {
                    this._toRemoveMeshesArray.push(e.uniqueId);
                }),
                (r.prototype.onGeometryAdded = function (e) {
                    (e.onGeometryUpdated = this.onGeometryUpdated), this.onGeometryUpdated(e);
                }),
                (r.prototype.onGeometryDeleted = function (e) {
                    this._toRemoveGeometryArray.push(e.id);
                }),
                (r.SerializeMesh = function (t) {
                    var i = [];
                    t.subMeshes &&
                        (i = t.subMeshes.map(function (e, t) {
                            return {
                                position: t,
                                verticesStart: e.verticesStart,
                                verticesCount: e.verticesCount,
                                indexStart: e.indexStart,
                                indexCount: e.indexCount,
                                hasMaterial: !!e.getMaterial(),
                                sphereCenter: e.getBoundingInfo().boundingSphere.centerWorld.asArray(),
                                sphereRadius: e.getBoundingInfo().boundingSphere.radiusWorld,
                                boxMinimum: e.getBoundingInfo().boundingBox.minimumWorld.asArray(),
                                boxMaximum: e.getBoundingInfo().boundingBox.maximumWorld.asArray(),
                            };
                        }));
                    var r = null;
                    return (
                        t instanceof e.Mesh ? (r = t.geometry ? t.geometry.id : null) : t instanceof e.InstancedMesh && (r = t.sourceMesh && t.sourceMesh.geometry ? t.sourceMesh.geometry.id : null),
                        {
                            uniqueId: t.uniqueId,
                            id: t.id,
                            name: t.name,
                            geometryId: r,
                            sphereCenter: t.getBoundingInfo().boundingSphere.centerWorld.asArray(),
                            sphereRadius: t.getBoundingInfo().boundingSphere.radiusWorld,
                            boxMinimum: t.getBoundingInfo().boundingBox.minimumWorld.asArray(),
                            boxMaximum: t.getBoundingInfo().boundingBox.maximumWorld.asArray(),
                            worldMatrixFromCache: t.worldMatrixFromCache.asArray(),
                            subMeshes: i,
                            checkCollisions: t.checkCollisions,
                        }
                    );
                }),
                (r.SerializeGeometry = function (t) {
                    return {
                        id: t.id,
                        positions: new Float32Array(t.getVerticesData(e.VertexBuffer.PositionKind) || []),
                        normals: new Float32Array(t.getVerticesData(e.VertexBuffer.NormalKind) || []),
                        indices: new Int32Array(t.getIndices() || []),
                    };
                }),
                r
            );
        })();
    e.CollisionCoordinatorWorker = r;
    var n = (function () {
        function t() {
            (this._scaledPosition = e.Vector3.Zero()), (this._scaledVelocity = e.Vector3.Zero()), (this._finalPosition = e.Vector3.Zero());
        }
        return (
            (t.prototype.getNewPosition = function (e, t, i, r, n, o, s) {
                e.divideToRef(i.radius, this._scaledPosition),
                    t.divideToRef(i.radius, this._scaledVelocity),
                    (i.collidedMesh = null),
                    (i.retry = 0),
                    (i.initialVelocity = this._scaledVelocity),
                    (i.initialPosition = this._scaledPosition),
                    this._collideWithWorld(this._scaledPosition, this._scaledVelocity, i, r, this._finalPosition, n),
                    this._finalPosition.multiplyInPlace(i.radius),
                    o(s, this._finalPosition, i.collidedMesh);
            }),
            (t.prototype.init = function (e) {
                this._scene = e;
            }),
            (t.prototype.destroy = function () {}),
            (t.prototype.onMeshAdded = function (e) {}),
            (t.prototype.onMeshUpdated = function (e) {}),
            (t.prototype.onMeshRemoved = function (e) {}),
            (t.prototype.onGeometryAdded = function (e) {}),
            (t.prototype.onGeometryUpdated = function (e) {}),
            (t.prototype.onGeometryDeleted = function (e) {}),
            (t.prototype._collideWithWorld = function (t, i, r, n, o, s) {
                void 0 === s && (s = null);
                var a = 10 * e.Engine.CollisionsEpsilon;
                if (r.retry >= n) return void o.copyFrom(t);
                r._initialize(t, i, a);
                for (var h = 0; h < this._scene.meshes.length; h++) {
                    var l = this._scene.meshes[h];
                    l.isEnabled() && l.checkCollisions && l.subMeshes && l !== s && l._checkCollision(r);
                }
                return r.collisionFound ? ((0 !== i.x || 0 !== i.y || 0 !== i.z) && r._getResponse(t, i), i.length() <= a ? void o.copyFrom(t) : (r.retry++, void this._collideWithWorld(t, i, r, n, o, s))) : void t.addToRef(i, o);
            }),
            t
        );
    })();
    e.CollisionCoordinatorLegacy = n;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t() {
            this.compensateDistorsion = !0;
        }
        return (
            Object.defineProperty(t.prototype, "aspectRatio", {
                get: function () {
                    return this.hResolution / (2 * this.vResolution);
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "aspectRatioFov", {
                get: function () {
                    return 2 * Math.atan((this.postProcessScaleFactor * this.vScreenSize) / (2 * this.eyeToScreenDistance));
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "leftHMatrix", {
                get: function () {
                    var t = this.hScreenSize / 4 - this.lensSeparationDistance / 2,
                        i = (4 * t) / this.hScreenSize;
                    return e.Matrix.Translation(i, 0, 0);
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "rightHMatrix", {
                get: function () {
                    var t = this.hScreenSize / 4 - this.lensSeparationDistance / 2,
                        i = (4 * t) / this.hScreenSize;
                    return e.Matrix.Translation(-i, 0, 0);
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "leftPreViewMatrix", {
                get: function () {
                    return e.Matrix.Translation(0.5 * this.interpupillaryDistance, 0, 0);
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "rightPreViewMatrix", {
                get: function () {
                    return e.Matrix.Translation(-0.5 * this.interpupillaryDistance, 0, 0);
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.GetDefault = function () {
                var e = new t();
                return (
                    (e.hResolution = 1280),
                    (e.vResolution = 800),
                    (e.hScreenSize = 0.149759993),
                    (e.vScreenSize = 0.0935999975),
                    (e.vScreenCenter = 0.0467999987),
                    (e.eyeToScreenDistance = 0.0410000011),
                    (e.lensSeparationDistance = 0.063500002),
                    (e.interpupillaryDistance = 0.064000003),
                    (e.distortionK = [1, 0.219999999, 0.239999995, 0]),
                    (e.chromaAbCorrection = [0.995999992, -0.00400000019, 1.01400006, 0]),
                    (e.postProcessScaleFactor = 1.714605507808412),
                    (e.lensCenterOffset = 0.151976421),
                    e
                );
            }),
            t
        );
    })();
    e.VRCameraMetrics = t;
    var i = (function (i) {
        function r(t, n, o) {
            i.call(this, t, o),
                (this.position = n),
                (this.upVector = e.Vector3.Up()),
                (this.orthoLeft = null),
                (this.orthoRight = null),
                (this.orthoBottom = null),
                (this.orthoTop = null),
                (this.fov = 0.8),
                (this.minZ = 1),
                (this.maxZ = 1e4),
                (this.inertia = 0.9),
                (this.mode = r.PERSPECTIVE_CAMERA),
                (this.isIntermediate = !1),
                (this.viewport = new e.Viewport(0, 0, 1, 1)),
                (this.layerMask = 268435455),
                (this.fovMode = r.FOVMODE_VERTICAL_FIXED),
                (this.cameraRigMode = r.RIG_MODE_NONE),
                (this._rigCameras = new Array()),
                (this._computedViewMatrix = e.Matrix.Identity()),
                (this._projectionMatrix = new e.Matrix()),
                (this._postProcesses = new Array()),
                (this._postProcessesTakenIndices = []),
                (this._activeMeshes = new e.SmartArray(256)),
                (this._globalPosition = e.Vector3.Zero()),
                o.addCamera(this),
                o.activeCamera || (o.activeCamera = this);
        }
        return (
            __extends(r, i),
            Object.defineProperty(r, "PERSPECTIVE_CAMERA", {
                get: function () {
                    return r._PERSPECTIVE_CAMERA;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "ORTHOGRAPHIC_CAMERA", {
                get: function () {
                    return r._ORTHOGRAPHIC_CAMERA;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "FOVMODE_VERTICAL_FIXED", {
                get: function () {
                    return r._FOVMODE_VERTICAL_FIXED;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "FOVMODE_HORIZONTAL_FIXED", {
                get: function () {
                    return r._FOVMODE_HORIZONTAL_FIXED;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "RIG_MODE_NONE", {
                get: function () {
                    return r._RIG_MODE_NONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "RIG_MODE_STEREOSCOPIC_ANAGLYPH", {
                get: function () {
                    return r._RIG_MODE_STEREOSCOPIC_ANAGLYPH;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL", {
                get: function () {
                    return r._RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED", {
                get: function () {
                    return r._RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "RIG_MODE_STEREOSCOPIC_OVERUNDER", {
                get: function () {
                    return r._RIG_MODE_STEREOSCOPIC_OVERUNDER;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "RIG_MODE_VR", {
                get: function () {
                    return r._RIG_MODE_VR;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r.prototype, "globalPosition", {
                get: function () {
                    return this._globalPosition;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (r.prototype.getActiveMeshes = function () {
                return this._activeMeshes;
            }),
            (r.prototype.isActiveMesh = function (e) {
                return -1 !== this._activeMeshes.indexOf(e);
            }),
            (r.prototype._initCache = function () {
                i.prototype._initCache.call(this),
                    (this._cache.position = new e.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE)),
                    (this._cache.upVector = new e.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE)),
                    (this._cache.mode = void 0),
                    (this._cache.minZ = void 0),
                    (this._cache.maxZ = void 0),
                    (this._cache.fov = void 0),
                    (this._cache.aspectRatio = void 0),
                    (this._cache.orthoLeft = void 0),
                    (this._cache.orthoRight = void 0),
                    (this._cache.orthoBottom = void 0),
                    (this._cache.orthoTop = void 0),
                    (this._cache.renderWidth = void 0),
                    (this._cache.renderHeight = void 0);
            }),
            (r.prototype._updateCache = function (e) {
                e || i.prototype._updateCache.call(this);
                var t = this.getEngine();
                this._cache.position.copyFrom(this.position),
                    this._cache.upVector.copyFrom(this.upVector),
                    (this._cache.mode = this.mode),
                    (this._cache.minZ = this.minZ),
                    (this._cache.maxZ = this.maxZ),
                    (this._cache.fov = this.fov),
                    (this._cache.aspectRatio = t.getAspectRatio(this)),
                    (this._cache.orthoLeft = this.orthoLeft),
                    (this._cache.orthoRight = this.orthoRight),
                    (this._cache.orthoBottom = this.orthoBottom),
                    (this._cache.orthoTop = this.orthoTop),
                    (this._cache.renderWidth = t.getRenderWidth()),
                    (this._cache.renderHeight = t.getRenderHeight());
            }),
            (r.prototype._updateFromScene = function () {
                this.updateCache(), this._update();
            }),
            (r.prototype._isSynchronized = function () {
                return this._isSynchronizedViewMatrix() && this._isSynchronizedProjectionMatrix();
            }),
            (r.prototype._isSynchronizedViewMatrix = function () {
                return i.prototype._isSynchronized.call(this) ? this._cache.position.equals(this.position) && this._cache.upVector.equals(this.upVector) && this.isSynchronizedWithParent() : !1;
            }),
            (r.prototype._isSynchronizedProjectionMatrix = function () {
                var e = this._cache.mode === this.mode && this._cache.minZ === this.minZ && this._cache.maxZ === this.maxZ;
                if (!e) return !1;
                var t = this.getEngine();
                return (e =
                    this.mode === r.PERSPECTIVE_CAMERA
                        ? this._cache.fov === this.fov && this._cache.aspectRatio === t.getAspectRatio(this)
                        : this._cache.orthoLeft === this.orthoLeft &&
                          this._cache.orthoRight === this.orthoRight &&
                          this._cache.orthoBottom === this.orthoBottom &&
                          this._cache.orthoTop === this.orthoTop &&
                          this._cache.renderWidth === t.getRenderWidth() &&
                          this._cache.renderHeight === t.getRenderHeight());
            }),
            (r.prototype.attachControl = function (e) {}),
            (r.prototype.detachControl = function (e) {}),
            (r.prototype._update = function () {
                this.cameraRigMode !== r.RIG_MODE_NONE && this._updateRigCameras(), this._checkInputs();
            }),
            (r.prototype._checkInputs = function () {}),
            (r.prototype.attachPostProcess = function (t, i) {
                if ((void 0 === i && (i = null), !t.isReusable() && this._postProcesses.indexOf(t) > -1)) return e.Tools.Error("You're trying to reuse a post process not defined as reusable."), 0;
                if (null == i || 0 > i) return this._postProcesses.push(t), this._postProcessesTakenIndices.push(this._postProcesses.length - 1), this._postProcesses.length - 1;
                var r = 0;
                if (this._postProcesses[i]) {
                    for (var n = this._postProcesses.length - 1, o = n; o >= i + 1; --o) this._postProcesses[o + 1] = this._postProcesses[o];
                    r = 1;
                }
                for (o = 0; o < this._postProcessesTakenIndices.length; ++o)
                    if (!(this._postProcessesTakenIndices[o] < i)) {
                        n = this._postProcessesTakenIndices.length - 1;
                        for (var s = n; s >= o; --s) this._postProcessesTakenIndices[s + 1] = this._postProcessesTakenIndices[s] + r;
                        this._postProcessesTakenIndices[o] = i;
                        break;
                    }
                r || -1 != this._postProcessesTakenIndices.indexOf(i) || this._postProcessesTakenIndices.push(i);
                var a = i + r;
                return (this._postProcesses[a] = t), a;
            }),
            (r.prototype.detachPostProcess = function (e, t) {
                void 0 === t && (t = null);
                var i = [];
                if (t)
                    for (t = t instanceof Array ? t : [t], o = 0; o < t.length; o++) {
                        var r = this._postProcesses[t[o]];
                        r === e ? (delete this._postProcesses[t[o]], (s = this._postProcessesTakenIndices.indexOf(t[o])), this._postProcessesTakenIndices.splice(s, 1)) : i.push(o);
                    }
                else
                    for (var n = this._postProcesses.length, o = 0; n > o; o++)
                        if (this._postProcesses[o] === e) {
                            delete this._postProcesses[o];
                            var s = this._postProcessesTakenIndices.indexOf(o);
                            this._postProcessesTakenIndices.splice(s, 1);
                        }
                return i;
            }),
            (r.prototype.getWorldMatrix = function () {
                this._worldMatrix || (this._worldMatrix = e.Matrix.Identity());
                var t = this.getViewMatrix();
                return t.invertToRef(this._worldMatrix), this._worldMatrix;
            }),
            (r.prototype._getViewMatrix = function () {
                return e.Matrix.Identity();
            }),
            (r.prototype.getViewMatrix = function (t) {
                return (
                    (this._computedViewMatrix = this._computeViewMatrix(t)),
                    !t && this._isSynchronizedViewMatrix()
                        ? this._computedViewMatrix
                        : (this.parent && this.parent.getWorldMatrix
                              ? (this._worldMatrix || (this._worldMatrix = e.Matrix.Identity()),
                                this._computedViewMatrix.invertToRef(this._worldMatrix),
                                this._worldMatrix.multiplyToRef(this.parent.getWorldMatrix(), this._computedViewMatrix),
                                this._globalPosition.copyFromFloats(this._computedViewMatrix.m[12], this._computedViewMatrix.m[13], this._computedViewMatrix.m[14]),
                                this._computedViewMatrix.invert(),
                                this._markSyncedWithParent())
                              : this._globalPosition.copyFrom(this.position),
                          (this._currentRenderId = this.getScene().getRenderId()),
                          this._computedViewMatrix)
                );
            }),
            (r.prototype._computeViewMatrix = function (e) {
                return !e && this._isSynchronizedViewMatrix() ? this._computedViewMatrix : ((this._computedViewMatrix = this._getViewMatrix()), (this._currentRenderId = this.getScene().getRenderId()), this._computedViewMatrix);
            }),
            (r.prototype.getProjectionMatrix = function (t) {
                if (!t && this._isSynchronizedProjectionMatrix()) return this._projectionMatrix;
                var i = this.getEngine();
                if (this.mode === r.PERSPECTIVE_CAMERA)
                    return this.minZ <= 0 && (this.minZ = 0.1), e.Matrix.PerspectiveFovLHToRef(this.fov, i.getAspectRatio(this), this.minZ, this.maxZ, this._projectionMatrix, this.fovMode), this._projectionMatrix;
                var n = i.getRenderWidth() / 2,
                    o = i.getRenderHeight() / 2;
                return e.Matrix.OrthoOffCenterLHToRef(this.orthoLeft || -n, this.orthoRight || n, this.orthoBottom || -o, this.orthoTop || o, this.minZ, this.maxZ, this._projectionMatrix), this._projectionMatrix;
            }),
            (r.prototype.dispose = function () {
                for (this.getScene().removeCamera(this); this._rigCameras.length > 0; ) this._rigCameras.pop().dispose();
                for (var e = 0; e < this._postProcessesTakenIndices.length; ++e) this._postProcesses[this._postProcessesTakenIndices[e]].dispose(this);
            }),
            (r.prototype.setCameraRigMode = function (i, n) {
                for (; this._rigCameras.length > 0; ) this._rigCameras.pop().dispose();
                switch (((this.cameraRigMode = i), (this._cameraRigParams = {}), this.cameraRigMode)) {
                    case r.RIG_MODE_STEREOSCOPIC_ANAGLYPH:
                    case r.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL:
                    case r.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED:
                    case r.RIG_MODE_STEREOSCOPIC_OVERUNDER:
                        (this._cameraRigParams.interaxialDistance = n.interaxialDistance || 0.0637),
                            (this._cameraRigParams.stereoHalfAngle = e.Tools.ToRadians(this._cameraRigParams.interaxialDistance / 0.0637)),
                            this._rigCameras.push(this.createRigCamera(this.name + "_L", 0)),
                            this._rigCameras.push(this.createRigCamera(this.name + "_R", 1));
                }
                var o = new Array();
                switch (this.cameraRigMode) {
                    case r.RIG_MODE_STEREOSCOPIC_ANAGLYPH:
                        o.push(new e.PassPostProcess(this.name + "_passthru", 1, this._rigCameras[0])),
                            (this._rigCameras[0].isIntermediate = !0),
                            o.push(new e.AnaglyphPostProcess(this.name + "_anaglyph", 1, this._rigCameras[1])),
                            (o[1].onApply = function (e) {
                                e.setTextureFromPostProcess("leftSampler", o[0]);
                            });
                        break;
                    case r.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL:
                    case r.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED:
                    case r.RIG_MODE_STEREOSCOPIC_OVERUNDER:
                        var s = this.cameraRigMode === r.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL || this.cameraRigMode === r.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED,
                            a = this.cameraRigMode === r.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED ? 1 : 0,
                            h = 1 - a;
                        o.push(new e.PassPostProcess(this.name + "_passthru", 1, this._rigCameras[a])),
                            (this._rigCameras[a].isIntermediate = !0),
                            o.push(new e.StereoscopicInterlacePostProcess(this.name + "_stereoInterlace", this._rigCameras[h], o[0], s));
                        break;
                    case r.RIG_MODE_VR:
                        this._rigCameras.push(this.createRigCamera(this.name + "_L", 0)), this._rigCameras.push(this.createRigCamera(this.name + "_R", 1));
                        var l = n.vrCameraMetrics || t.GetDefault();
                        (this._rigCameras[0]._cameraRigParams.vrMetrics = l),
                            (this._rigCameras[0].viewport = new e.Viewport(0, 0, 0.5, 1)),
                            (this._rigCameras[0]._cameraRigParams.vrWorkMatrix = new e.Matrix()),
                            (this._rigCameras[0]._cameraRigParams.vrHMatrix = l.leftHMatrix),
                            (this._rigCameras[0]._cameraRigParams.vrPreViewMatrix = l.leftPreViewMatrix),
                            (this._rigCameras[0].getProjectionMatrix = this._rigCameras[0]._getVRProjectionMatrix),
                            l.compensateDistorsion && o.push(new e.VRDistortionCorrectionPostProcess("VR_Distort_Compensation_Left", this._rigCameras[0], !1, l)),
                            (this._rigCameras[1]._cameraRigParams.vrMetrics = this._rigCameras[0]._cameraRigParams.vrMetrics),
                            (this._rigCameras[1].viewport = new e.Viewport(0.5, 0, 0.5, 1)),
                            (this._rigCameras[1]._cameraRigParams.vrWorkMatrix = new e.Matrix()),
                            (this._rigCameras[1]._cameraRigParams.vrHMatrix = l.rightHMatrix),
                            (this._rigCameras[1]._cameraRigParams.vrPreViewMatrix = l.rightPreViewMatrix),
                            (this._rigCameras[1].getProjectionMatrix = this._rigCameras[1]._getVRProjectionMatrix),
                            l.compensateDistorsion && o.push(new e.VRDistortionCorrectionPostProcess("VR_Distort_Compensation_Right", this._rigCameras[1], !0, l));
                }
                this._update();
            }),
            (r.prototype._getVRProjectionMatrix = function () {
                return (
                    e.Matrix.PerspectiveFovLHToRef(this._cameraRigParams.vrMetrics.aspectRatioFov, this._cameraRigParams.vrMetrics.aspectRatio, this.minZ, this.maxZ, this._cameraRigParams.vrWorkMatrix),
                    this._cameraRigParams.vrWorkMatrix.multiplyToRef(this._cameraRigParams.vrHMatrix, this._projectionMatrix),
                    this._projectionMatrix
                );
            }),
            (r.prototype.setCameraRigParameter = function (t, i) {
                (this._cameraRigParams[t] = i), "interaxialDistance" === t && (this._cameraRigParams.stereoHalfAngle = e.Tools.ToRadians(i / 0.0637));
            }),
            (r.prototype.createRigCamera = function (e, t) {
                return null;
            }),
            (r.prototype._updateRigCameras = function () {
                for (var e = 0; e < this._rigCameras.length; e++) (this._rigCameras[e].minZ = this.minZ), (this._rigCameras[e].maxZ = this.maxZ), (this._rigCameras[e].fov = this.fov);
                this.cameraRigMode === r.RIG_MODE_STEREOSCOPIC_ANAGLYPH && (this._rigCameras[0].viewport = this._rigCameras[1].viewport = this.viewport);
            }),
            (r._PERSPECTIVE_CAMERA = 0),
            (r._ORTHOGRAPHIC_CAMERA = 1),
            (r._FOVMODE_VERTICAL_FIXED = 0),
            (r._FOVMODE_HORIZONTAL_FIXED = 1),
            (r._RIG_MODE_NONE = 0),
            (r._RIG_MODE_STEREOSCOPIC_ANAGLYPH = 10),
            (r._RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL = 11),
            (r._RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED = 12),
            (r._RIG_MODE_STEREOSCOPIC_OVERUNDER = 13),
            (r._RIG_MODE_VR = 20),
            r
        );
    })(e.Node);
    e.Camera = i;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n) {
            t.call(this, i, r, n),
                (this.cameraDirection = new e.Vector3(0, 0, 0)),
                (this.cameraRotation = new e.Vector2(0, 0)),
                (this.rotation = new e.Vector3(0, 0, 0)),
                (this.speed = 2),
                (this.noRotationConstraint = !1),
                (this.lockedTarget = null),
                (this._currentTarget = e.Vector3.Zero()),
                (this._viewMatrix = e.Matrix.Zero()),
                (this._camMatrix = e.Matrix.Zero()),
                (this._cameraTransformMatrix = e.Matrix.Zero()),
                (this._cameraRotationMatrix = e.Matrix.Zero()),
                (this._referencePoint = new e.Vector3(0, 0, 1)),
                (this._transformedReferencePoint = e.Vector3.Zero()),
                (this._lookAtTemp = e.Matrix.Zero()),
                (this._tempMatrix = e.Matrix.Zero());
        }
        return (
            __extends(i, t),
            (i.prototype.getFrontPosition = function (e) {
                var t = this.getTarget().subtract(this.position);
                return t.normalize(), t.scaleInPlace(e), this.globalPosition.add(t);
            }),
            (i.prototype._getLockedTargetPosition = function () {
                return this.lockedTarget ? this.lockedTarget.position || this.lockedTarget : null;
            }),
            (i.prototype._initCache = function () {
                t.prototype._initCache.call(this),
                    (this._cache.lockedTarget = new e.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE)),
                    (this._cache.rotation = new e.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE));
            }),
            (i.prototype._updateCache = function (e) {
                e || t.prototype._updateCache.call(this);
                var i = this._getLockedTargetPosition();
                i ? (this._cache.lockedTarget ? this._cache.lockedTarget.copyFrom(i) : (this._cache.lockedTarget = i.clone())) : (this._cache.lockedTarget = null), this._cache.rotation.copyFrom(this.rotation);
            }),
            (i.prototype._isSynchronizedViewMatrix = function () {
                if (!t.prototype._isSynchronizedViewMatrix.call(this)) return !1;
                var e = this._getLockedTargetPosition();
                return (this._cache.lockedTarget ? this._cache.lockedTarget.equals(e) : !e) && this._cache.rotation.equals(this.rotation);
            }),
            (i.prototype._computeLocalCameraSpeed = function () {
                var e = this.getEngine();
                return this.speed * (e.getDeltaTime() / (10 * e.getFps()));
            }),
            (i.prototype.setTarget = function (t) {
                this.upVector.normalize(), e.Matrix.LookAtLHToRef(this.position, t, this.upVector, this._camMatrix), this._camMatrix.invert(), (this.rotation.x = Math.atan(this._camMatrix.m[6] / this._camMatrix.m[10]));
                var i = t.subtract(this.position);
                (this.rotation.y = i.x >= 0 ? -Math.atan(i.z / i.x) + Math.PI / 2 : -Math.atan(i.z / i.x) - Math.PI / 2),
                    (this.rotation.z = -Math.acos(e.Vector3.Dot(new e.Vector3(0, 1, 0), this.upVector))),
                    isNaN(this.rotation.x) && (this.rotation.x = 0),
                    isNaN(this.rotation.y) && (this.rotation.y = 0),
                    isNaN(this.rotation.z) && (this.rotation.z = 0);
            }),
            (i.prototype.getTarget = function () {
                return this._currentTarget;
            }),
            (i.prototype._decideIfNeedsToMove = function () {
                return Math.abs(this.cameraDirection.x) > 0 || Math.abs(this.cameraDirection.y) > 0 || Math.abs(this.cameraDirection.z) > 0;
            }),
            (i.prototype._updatePosition = function () {
                this.position.addInPlace(this.cameraDirection);
            }),
            (i.prototype._checkInputs = function () {
                var i = this._decideIfNeedsToMove(),
                    r = Math.abs(this.cameraRotation.x) > 0 || Math.abs(this.cameraRotation.y) > 0;
                if ((i && this._updatePosition(), r && ((this.rotation.x += this.cameraRotation.x), (this.rotation.y += this.cameraRotation.y), !this.noRotationConstraint))) {
                    var n = (Math.PI / 2) * 0.95;
                    this.rotation.x > n && (this.rotation.x = n), this.rotation.x < -n && (this.rotation.x = -n);
                }
                i &&
                    (Math.abs(this.cameraDirection.x) < e.Engine.Epsilon && (this.cameraDirection.x = 0),
                    Math.abs(this.cameraDirection.y) < e.Engine.Epsilon && (this.cameraDirection.y = 0),
                    Math.abs(this.cameraDirection.z) < e.Engine.Epsilon && (this.cameraDirection.z = 0),
                    this.cameraDirection.scaleInPlace(this.inertia)),
                    r && (Math.abs(this.cameraRotation.x) < e.Engine.Epsilon && (this.cameraRotation.x = 0), Math.abs(this.cameraRotation.y) < e.Engine.Epsilon && (this.cameraRotation.y = 0), this.cameraRotation.scaleInPlace(this.inertia)),
                    t.prototype._checkInputs.call(this);
            }),
            (i.prototype._getViewMatrix = function () {
                return (
                    this.lockedTarget
                        ? this._currentTarget.copyFrom(this._getLockedTargetPosition())
                        : (0 !== this.upVector.x || 1 !== this.upVector.y || 0 !== this.upVector.z
                              ? (e.Matrix.LookAtLHToRef(e.Vector3.Zero(), this._referencePoint, this.upVector, this._lookAtTemp),
                                e.Matrix.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, this._cameraRotationMatrix),
                                this._lookAtTemp.multiplyToRef(this._cameraRotationMatrix, this._tempMatrix),
                                this._lookAtTemp.invert(),
                                this._tempMatrix.multiplyToRef(this._lookAtTemp, this._cameraRotationMatrix))
                              : e.Matrix.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, this._cameraRotationMatrix),
                          e.Vector3.TransformCoordinatesToRef(this._referencePoint, this._cameraRotationMatrix, this._transformedReferencePoint),
                          this.position.addToRef(this._transformedReferencePoint, this._currentTarget)),
                    e.Matrix.LookAtLHToRef(this.position, this._currentTarget, this.upVector, this._viewMatrix),
                    this._viewMatrix
                );
            }),
            (i.prototype._getVRViewMatrix = function () {
                return (
                    e.Matrix.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, this._cameraRotationMatrix),
                    e.Vector3.TransformCoordinatesToRef(this._referencePoint, this._cameraRotationMatrix, this._transformedReferencePoint),
                    e.Vector3.TransformNormalToRef(this.upVector, this._cameraRotationMatrix, this._cameraRigParams.vrActualUp),
                    this.position.addToRef(this._transformedReferencePoint, this._currentTarget),
                    e.Matrix.LookAtLHToRef(this.position, this._currentTarget, this._cameraRigParams.vrActualUp, this._cameraRigParams.vrWorkMatrix),
                    this._cameraRigParams.vrWorkMatrix.multiplyToRef(this._cameraRigParams.vrPreViewMatrix, this._viewMatrix),
                    this._viewMatrix
                );
            }),
            (i.prototype.createRigCamera = function (t, r) {
                if (this.cameraRigMode !== e.Camera.RIG_MODE_NONE) {
                    var n = new i(t, this.position.clone(), this.getScene());
                    return this.cameraRigMode === e.Camera.RIG_MODE_VR && ((n._cameraRigParams = {}), (n._cameraRigParams.vrActualUp = new e.Vector3(0, 0, 0)), (n._getViewMatrix = n._getVRViewMatrix)), n;
                }
                return null;
            }),
            (i.prototype._updateRigCameras = function () {
                switch (this.cameraRigMode) {
                    case e.Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH:
                    case e.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL:
                    case e.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED:
                    case e.Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER:
                    case e.Camera.RIG_MODE_VR:
                        var i = this._rigCameras[0],
                            r = this._rigCameras[1];
                        this.cameraRigMode === e.Camera.RIG_MODE_VR
                            ? ((i.rotation.x = r.rotation.x = this.rotation.x),
                              (i.rotation.y = r.rotation.y = this.rotation.y),
                              (i.rotation.z = r.rotation.z = this.rotation.z),
                              i.position.copyFrom(this.position),
                              r.position.copyFrom(this.position))
                            : (this._getRigCamPosition(-this._cameraRigParams.stereoHalfAngle, i.position),
                              this._getRigCamPosition(this._cameraRigParams.stereoHalfAngle, r.position),
                              i.setTarget(this.getTarget()),
                              r.setTarget(this.getTarget()));
                }
                t.prototype._updateRigCameras.call(this);
            }),
            (i.prototype._getRigCamPosition = function (t, i) {
                this._rigCamTransformMatrix || (this._rigCamTransformMatrix = new e.Matrix());
                var r = this.getTarget();
                e.Matrix.Translation(-r.x, -r.y, -r.z).multiplyToRef(e.Matrix.RotationY(t), this._rigCamTransformMatrix),
                    (this._rigCamTransformMatrix = this._rigCamTransformMatrix.multiply(e.Matrix.Translation(r.x, r.y, r.z))),
                    e.Vector3.TransformCoordinatesToRef(this.position, this._rigCamTransformMatrix, i);
            }),
            i
        );
    })(e.Camera);
    e.TargetCamera = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n) {
            var o = this;
            t.call(this, i, r, n),
                (this.ellipsoid = new e.Vector3(0.5, 1, 0.5)),
                (this.keysUp = [38]),
                (this.keysDown = [40]),
                (this.keysLeft = [37]),
                (this.keysRight = [39]),
                (this.checkCollisions = !1),
                (this.applyGravity = !1),
                (this.angularSensibility = 2e3),
                (this._keys = []),
                (this._collider = new e.Collider()),
                (this._needMoveForGravity = !1),
                (this._oldPosition = e.Vector3.Zero()),
                (this._diffPosition = e.Vector3.Zero()),
                (this._newPosition = e.Vector3.Zero()),
                (this._onCollisionPositionChange = function (t, i, r) {
                    void 0 === r && (r = null), o.getScene().workerCollisions && i.multiplyInPlace(o._collider.radius);
                    var n = function (t) {
                        o._newPosition.copyFrom(t), o._newPosition.subtractToRef(o._oldPosition, o._diffPosition);
                        o.position.clone();
                        o._diffPosition.length() > e.Engine.CollisionsEpsilon && (o.position.addInPlace(o._diffPosition), o.onCollide && r && o.onCollide(r));
                    };
                    n(i);
                });
        }
        return (
            __extends(i, t),
            (i.prototype.attachControl = function (t, i) {
                var r,
                    n = this,
                    o = this.getEngine();
                this._attachedElement ||
                    ((this._attachedElement = t),
                    void 0 === this._onMouseDown &&
                        ((this._onMouseDown = function (e) {
                            (r = { x: e.clientX, y: e.clientY }), i || e.preventDefault();
                        }),
                        (this._onMouseUp = function (e) {
                            (r = null), i || e.preventDefault();
                        }),
                        (this._onMouseOut = function (e) {
                            (r = null), (n._keys = []), i || e.preventDefault();
                        }),
                        (this._onMouseMove = function (e) {
                            if (r || o.isPointerLock) {
                                var t, s;
                                o.isPointerLock
                                    ? ((t = e.movementX || e.mozMovementX || e.webkitMovementX || e.msMovementX || 0), (s = e.movementY || e.mozMovementY || e.webkitMovementY || e.msMovementY || 0))
                                    : ((t = e.clientX - r.x), (s = e.clientY - r.y)),
                                    (n.cameraRotation.y += t / n.angularSensibility),
                                    (n.cameraRotation.x += s / n.angularSensibility),
                                    (r = { x: e.clientX, y: e.clientY }),
                                    i || e.preventDefault();
                            }
                        }),
                        (this._onKeyDown = function (e) {
                            if (-1 !== n.keysUp.indexOf(e.keyCode) || -1 !== n.keysDown.indexOf(e.keyCode) || -1 !== n.keysLeft.indexOf(e.keyCode) || -1 !== n.keysRight.indexOf(e.keyCode)) {
                                var t = n._keys.indexOf(e.keyCode);
                                -1 === t && n._keys.push(e.keyCode), i || e.preventDefault();
                            }
                        }),
                        (this._onKeyUp = function (e) {
                            if (-1 !== n.keysUp.indexOf(e.keyCode) || -1 !== n.keysDown.indexOf(e.keyCode) || -1 !== n.keysLeft.indexOf(e.keyCode) || -1 !== n.keysRight.indexOf(e.keyCode)) {
                                var t = n._keys.indexOf(e.keyCode);
                                t >= 0 && n._keys.splice(t, 1), i || e.preventDefault();
                            }
                        }),
                        (this._onLostFocus = function () {
                            n._keys = [];
                        }),
                        (this._reset = function () {
                            (n._keys = []), (r = null), (n.cameraDirection = new e.Vector3(0, 0, 0)), (n.cameraRotation = new e.Vector2(0, 0));
                        })),
                    t.addEventListener("mousedown", this._onMouseDown, !1),
                    t.addEventListener("mouseup", this._onMouseUp, !1),
                    t.addEventListener("mouseout", this._onMouseOut, !1),
                    t.addEventListener("mousemove", this._onMouseMove, !1),
                    e.Tools.RegisterTopRootEvents([
                        { name: "keydown", handler: this._onKeyDown },
                        { name: "keyup", handler: this._onKeyUp },
                        { name: "blur", handler: this._onLostFocus },
                    ]));
            }),
            (i.prototype.detachControl = function (t) {
                this._attachedElement == t &&
                    (t.removeEventListener("mousedown", this._onMouseDown),
                    t.removeEventListener("mouseup", this._onMouseUp),
                    t.removeEventListener("mouseout", this._onMouseOut),
                    t.removeEventListener("mousemove", this._onMouseMove),
                    e.Tools.UnregisterTopRootEvents([
                        { name: "keydown", handler: this._onKeyDown },
                        { name: "keyup", handler: this._onKeyUp },
                        { name: "blur", handler: this._onLostFocus },
                    ]),
                    (this._attachedElement = null),
                    this._reset && this._reset());
            }),
            (i.prototype._collideWithWorld = function (t) {
                var i;
                (i = this.parent ? e.Vector3.TransformCoordinates(this.position, this.parent.getWorldMatrix()) : this.position),
                    i.subtractFromFloatsToRef(0, this.ellipsoid.y, 0, this._oldPosition),
                    (this._collider.radius = this.ellipsoid),
                    this.applyGravity && t.addInPlace(this.getScene().gravity),
                    this.getScene().collisionCoordinator.getNewPosition(this._oldPosition, t, this._collider, 3, null, this._onCollisionPositionChange, this.uniqueId);
            }),
            (i.prototype._checkInputs = function () {
                this._localDirection || ((this._localDirection = e.Vector3.Zero()), (this._transformedDirection = e.Vector3.Zero()));
                for (var i = 0; i < this._keys.length; i++) {
                    var r = this._keys[i],
                        n = this._computeLocalCameraSpeed();
                    -1 !== this.keysLeft.indexOf(r)
                        ? this._localDirection.copyFromFloats(-n, 0, 0)
                        : -1 !== this.keysUp.indexOf(r)
                        ? this._localDirection.copyFromFloats(0, 0, n)
                        : -1 !== this.keysRight.indexOf(r)
                        ? this._localDirection.copyFromFloats(n, 0, 0)
                        : -1 !== this.keysDown.indexOf(r) && this._localDirection.copyFromFloats(0, 0, -n),
                        this.getViewMatrix().invertToRef(this._cameraTransformMatrix),
                        e.Vector3.TransformNormalToRef(this._localDirection, this._cameraTransformMatrix, this._transformedDirection),
                        this.cameraDirection.addInPlace(this._transformedDirection);
                }
                t.prototype._checkInputs.call(this);
            }),
            (i.prototype._decideIfNeedsToMove = function () {
                return this._needMoveForGravity || Math.abs(this.cameraDirection.x) > 0 || Math.abs(this.cameraDirection.y) > 0 || Math.abs(this.cameraDirection.z) > 0;
            }),
            (i.prototype._updatePosition = function () {
                this.checkCollisions && this.getScene().collisionsEnabled ? this._collideWithWorld(this.cameraDirection) : this.position.addInPlace(this.cameraDirection);
            }),
            i
        );
    })(e.TargetCamera);
    e.FreeCamera = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(e, i, r) {
            t.call(this, e, i, r), (this.radius = 12), (this.rotationOffset = 0), (this.heightOffset = 4), (this.cameraAcceleration = 0.05), (this.maxCameraSpeed = 20);
        }
        return (
            __extends(i, t),
            (i.prototype.getRadians = function (e) {
                return (e * Math.PI) / 180;
            }),
            (i.prototype.follow = function (t) {
                if (t) {
                    var i;
                    if (t.rotationQuaternion) {
                        var r = new e.Matrix();
                        t.rotationQuaternion.toRotationMatrix(r), (i = Math.atan2(r.m[8], r.m[10]));
                    } else i = t.rotation.y;
                    var n = this.getRadians(this.rotationOffset) + i,
                        o = t.position.x + Math.sin(n) * this.radius,
                        s = t.position.z + Math.cos(n) * this.radius,
                        a = o - this.position.x,
                        h = t.position.y + this.heightOffset - this.position.y,
                        l = s - this.position.z,
                        c = a * this.cameraAcceleration * 2,
                        u = h * this.cameraAcceleration,
                        f = l * this.cameraAcceleration * 2;
                    (c > this.maxCameraSpeed || c < -this.maxCameraSpeed) && (c = 1 > c ? -this.maxCameraSpeed : this.maxCameraSpeed),
                        (u > this.maxCameraSpeed || u < -this.maxCameraSpeed) && (u = 1 > u ? -this.maxCameraSpeed : this.maxCameraSpeed),
                        (f > this.maxCameraSpeed || f < -this.maxCameraSpeed) && (f = 1 > f ? -this.maxCameraSpeed : this.maxCameraSpeed),
                        (this.position = new e.Vector3(this.position.x + c, this.position.y + u, this.position.z + f)),
                        this.setTarget(t.position);
                }
            }),
            (i.prototype._checkInputs = function () {
                t.prototype._checkInputs.call(this), this.follow(this.target);
            }),
            i
        );
    })(e.TargetCamera);
    e.FollowCamera = t;
    var i = (function (t) {
        function i(i, r, n, o, s, a) {
            t.call(this, i, e.Vector3.Zero(), a), (this.alpha = r), (this.beta = n), (this.radius = o), (this.target = s), (this._cartesianCoordinates = e.Vector3.Zero()), this.follow();
        }
        return (
            __extends(i, t),
            (i.prototype.follow = function () {
                (this._cartesianCoordinates.x = this.radius * Math.cos(this.alpha) * Math.cos(this.beta)),
                    (this._cartesianCoordinates.y = this.radius * Math.sin(this.beta)),
                    (this._cartesianCoordinates.z = this.radius * Math.sin(this.alpha) * Math.cos(this.beta)),
                    (this.position = this.target.position.add(this._cartesianCoordinates)),
                    this.setTarget(this.target.position);
            }),
            (i.prototype._checkInputs = function () {
                t.prototype._checkInputs.call(this), this.follow();
            }),
            i
        );
    })(e.TargetCamera);
    e.ArcFollowCamera = i;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(e, i, r) {
            t.call(this, e, i, r), (this._offsetX = null), (this._offsetY = null), (this._pointerCount = 0), (this._pointerPressed = []), (this.angularSensibility = 2e5), (this.moveSensibility = 500);
        }
        return (
            __extends(i, t),
            (i.prototype.attachControl = function (t, i) {
                var r,
                    n = this;
                this._attachedCanvas ||
                    ((this._attachedCanvas = t),
                    void 0 === this._onPointerDown &&
                        ((this._onPointerDown = function (e) {
                            i || e.preventDefault(), n._pointerPressed.push(e.pointerId), 1 === n._pointerPressed.length && (r = { x: e.clientX, y: e.clientY });
                        }),
                        (this._onPointerUp = function (e) {
                            i || e.preventDefault();
                            var t = n._pointerPressed.indexOf(e.pointerId);
                            -1 !== t && (n._pointerPressed.splice(t, 1), 0 == t && ((r = null), (n._offsetX = null), (n._offsetY = null)));
                        }),
                        (this._onPointerMove = function (e) {
                            if ((i || e.preventDefault(), r)) {
                                var t = n._pointerPressed.indexOf(e.pointerId);
                                0 == t && ((n._offsetX = e.clientX - r.x), (n._offsetY = -(e.clientY - r.y)));
                            }
                        }),
                        (this._onLostFocus = function () {
                            (n._offsetX = null), (n._offsetY = null);
                        })),
                    t.addEventListener("pointerdown", this._onPointerDown),
                    t.addEventListener("pointerup", this._onPointerUp),
                    t.addEventListener("pointerout", this._onPointerUp),
                    t.addEventListener("pointermove", this._onPointerMove),
                    e.Tools.RegisterTopRootEvents([{ name: "blur", handler: this._onLostFocus }]));
            }),
            (i.prototype.detachControl = function (t) {
                this._attachedCanvas == t &&
                    (t.removeEventListener("pointerdown", this._onPointerDown),
                    t.removeEventListener("pointerup", this._onPointerUp),
                    t.removeEventListener("pointerout", this._onPointerUp),
                    t.removeEventListener("pointermove", this._onPointerMove),
                    e.Tools.UnregisterTopRootEvents([{ name: "blur", handler: this._onLostFocus }]),
                    (this._attachedCanvas = null));
            }),
            (i.prototype._checkInputs = function () {
                if (this._offsetX)
                    if (((this.cameraRotation.y += this._offsetX / this.angularSensibility), this._pointerPressed.length > 1)) this.cameraRotation.x += -this._offsetY / this.angularSensibility;
                    else {
                        var i = this._computeLocalCameraSpeed(),
                            r = new e.Vector3(0, 0, (i * this._offsetY) / this.moveSensibility);
                        e.Matrix.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, 0, this._cameraRotationMatrix), this.cameraDirection.addInPlace(e.Vector3.TransformCoordinates(r, this._cameraRotationMatrix));
                    }
                t.prototype._checkInputs.call(this);
            }),
            i
        );
    })(e.FreeCamera);
    e.TouchCamera = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = e.Tools.GetPointerPrefix(),
        i = (function (i) {
            function r(t, r, n, o, s, a) {
                var h = this;
                i.call(this, t, e.Vector3.Zero(), a),
                    (this.alpha = r),
                    (this.beta = n),
                    (this.radius = o),
                    (this.target = s),
                    (this.inertialAlphaOffset = 0),
                    (this.inertialBetaOffset = 0),
                    (this.inertialRadiusOffset = 0),
                    (this.lowerAlphaLimit = null),
                    (this.upperAlphaLimit = null),
                    (this.lowerBetaLimit = 0.01),
                    (this.upperBetaLimit = Math.PI),
                    (this.lowerRadiusLimit = null),
                    (this.upperRadiusLimit = null),
                    (this.angularSensibilityX = 1e3),
                    (this.angularSensibilityY = 1e3),
                    (this.wheelPrecision = 3),
                    (this.pinchPrecision = 2),
                    (this.panningSensibility = 50),
                    (this.inertialPanningX = 0),
                    (this.inertialPanningY = 0),
                    (this.keysUp = [38]),
                    (this.keysDown = [40]),
                    (this.keysLeft = [37]),
                    (this.keysRight = [39]),
                    (this.zoomOnFactor = 1),
                    (this.targetScreenOffset = e.Vector2.Zero()),
                    (this.pinchInwards = !0),
                    (this.allowUpsideDown = !0),
                    (this._keys = []),
                    (this._viewMatrix = new e.Matrix()),
                    (this._isRightClick = !1),
                    (this._isCtrlPushed = !1),
                    (this.checkCollisions = !1),
                    (this.collisionRadius = new e.Vector3(0.5, 0.5, 0.5)),
                    (this._collider = new e.Collider()),
                    (this._previousPosition = e.Vector3.Zero()),
                    (this._collisionVelocity = e.Vector3.Zero()),
                    (this._newPosition = e.Vector3.Zero()),
                    (this._onCollisionPositionChange = function (t, i, r) {
                        void 0 === r && (r = null),
                            h.getScene().workerCollisions && h.checkCollisions && i.multiplyInPlace(h._collider.radius),
                            r ? (h.setPosition(h.position), h.onCollide && h.onCollide(r)) : h._previousPosition.copyFrom(h.position);
                        var n = Math.cos(h.alpha),
                            o = Math.sin(h.alpha),
                            s = Math.cos(h.beta),
                            a = Math.sin(h.beta),
                            l = h._getTargetPosition();
                        l.addToRef(new e.Vector3(h.radius * n * a, h.radius * s, h.radius * o * a), h._newPosition), h.position.copyFrom(h._newPosition);
                        var c = h.upVector;
                        if (h.allowUpsideDown && h.beta < 0) {
                            var c = c.clone();
                            c = c.negate();
                        }
                        e.Matrix.LookAtLHToRef(h.position, l, c, h._viewMatrix), (h._viewMatrix.m[12] += h.targetScreenOffset.x), (h._viewMatrix.m[13] += h.targetScreenOffset.y), (h._collisionTriggered = !1);
                    }),
                    this.target || (this.target = e.Vector3.Zero()),
                    this.getViewMatrix();
            }
            return (
                __extends(r, i),
                Object.defineProperty(r.prototype, "angularSensibility", {
                    get: function () {
                        return e.Tools.Warn("Warning: angularSensibility is deprecated, use angularSensibilityX and angularSensibilityY instead."), Math.max(this.angularSensibilityX, this.angularSensibilityY);
                    },
                    set: function (t) {
                        e.Tools.Warn("Warning: angularSensibility is deprecated, use angularSensibilityX and angularSensibilityY instead."), (this.angularSensibilityX = t), (this.angularSensibilityY = t);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                (r.prototype._getTargetPosition = function () {
                    return this.target.position || this.target;
                }),
                (r.prototype._initCache = function () {
                    i.prototype._initCache.call(this),
                        (this._cache.target = new e.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE)),
                        (this._cache.alpha = void 0),
                        (this._cache.beta = void 0),
                        (this._cache.radius = void 0),
                        (this._cache.targetScreenOffset = void 0);
                }),
                (r.prototype._updateCache = function (e) {
                    e || i.prototype._updateCache.call(this),
                        this._cache.target.copyFrom(this._getTargetPosition()),
                        (this._cache.alpha = this.alpha),
                        (this._cache.beta = this.beta),
                        (this._cache.radius = this.radius),
                        (this._cache.targetScreenOffset = this.targetScreenOffset.clone());
                }),
                (r.prototype._isSynchronizedViewMatrix = function () {
                    return i.prototype._isSynchronizedViewMatrix.call(this)
                        ? this._cache.target.equals(this._getTargetPosition()) &&
                              this._cache.alpha === this.alpha &&
                              this._cache.beta === this.beta &&
                              this._cache.radius === this.radius &&
                              this._cache.targetScreenOffset.equals(this.targetScreenOffset)
                        : !1;
                }),
                (r.prototype.attachControl = function (i, r, n) {
                    var o = this;
                    void 0 === n && (n = !0);
                    var s,
                        a = 0,
                        h = new e.SmartCollection();
                    if (!this._attachedElement) {
                        this._attachedElement = i;
                        var l = this.getEngine();
                        void 0 === this._onPointerDown &&
                            ((this._onPointerDown = function (e) {
                                (o._isRightClick = 2 === e.button ? !0 : !1), h.add(e.pointerId, { x: e.clientX, y: e.clientY, type: e.pointerType }), (s = h.item(e.pointerId)), r || e.preventDefault();
                            }),
                            (this._onPointerUp = function (e) {
                                (s = null), (a = 0), h.empty(), r || e.preventDefault();
                            }),
                            (this._onContextMenu = function (e) {
                                e.preventDefault();
                            }),
                            (this._onPointerMove = function (e) {
                                switch ((r || e.preventDefault(), h.count)) {
                                    case 1:
                                        if ((o._isCtrlPushed && n) || (!n && o._isRightClick)) (o.inertialPanningX += -(e.clientX - s.x) / o.panningSensibility), (o.inertialPanningY += (e.clientY - s.y) / o.panningSensibility);
                                        else {
                                            var t = e.clientX - s.x,
                                                i = e.clientY - s.y;
                                            (o.inertialAlphaOffset -= t / o.angularSensibilityX), (o.inertialBetaOffset -= i / o.angularSensibilityY);
                                        }
                                        (s.x = e.clientX), (s.y = e.clientY);
                                        break;
                                    case 2:
                                        (h.item(e.pointerId).x = e.clientX), (h.item(e.pointerId).y = e.clientY);
                                        var l = o.pinchInwards ? 1 : -1,
                                            c = h.getItemByIndex(0).x - h.getItemByIndex(1).x,
                                            u = h.getItemByIndex(0).y - h.getItemByIndex(1).y,
                                            f = c * c + u * u;
                                        if (0 === a) return void (a = f);
                                        f !== a && ((o.inertialRadiusOffset += (f - a) / (o.pinchPrecision * o.wheelPrecision * ((o.angularSensibilityX + o.angularSensibilityY) / 2) * l)), (a = f));
                                        break;
                                    default:
                                        h.item(e.pointerId) && ((h.item(e.pointerId).x = e.clientX), (h.item(e.pointerId).y = e.clientY));
                                }
                            }),
                            (this._onMouseMove = function (e) {
                                if (l.isPointerLock) {
                                    var t = e.movementX || e.mozMovementX || e.webkitMovementX || e.msMovementX || 0,
                                        i = e.movementY || e.mozMovementY || e.webkitMovementY || e.msMovementY || 0;
                                    (o.inertialAlphaOffset -= t / o.angularSensibilityX), (o.inertialBetaOffset -= i / o.angularSensibilityY), r || e.preventDefault();
                                }
                            }),
                            (this._wheel = function (e) {
                                var t = 0;
                                e.wheelDelta ? (t = e.wheelDelta / (40 * o.wheelPrecision)) : e.detail && (t = -e.detail / o.wheelPrecision), t && (o.inertialRadiusOffset += t), e.preventDefault && (r || e.preventDefault());
                            }),
                            (this._onKeyDown = function (e) {
                                if (((o._isCtrlPushed = e.ctrlKey), -1 !== o.keysUp.indexOf(e.keyCode) || -1 !== o.keysDown.indexOf(e.keyCode) || -1 !== o.keysLeft.indexOf(e.keyCode) || -1 !== o.keysRight.indexOf(e.keyCode))) {
                                    var t = o._keys.indexOf(e.keyCode);
                                    -1 === t && o._keys.push(e.keyCode), e.preventDefault && (r || e.preventDefault());
                                }
                            }),
                            (this._onKeyUp = function (e) {
                                if (((o._isCtrlPushed = e.ctrlKey), -1 !== o.keysUp.indexOf(e.keyCode) || -1 !== o.keysDown.indexOf(e.keyCode) || -1 !== o.keysLeft.indexOf(e.keyCode) || -1 !== o.keysRight.indexOf(e.keyCode))) {
                                    var t = o._keys.indexOf(e.keyCode);
                                    t >= 0 && o._keys.splice(t, 1), e.preventDefault && (r || e.preventDefault());
                                }
                            }),
                            (this._onLostFocus = function () {
                                (o._keys = []), h.empty(), (a = 0), (s = null);
                            }),
                            (this._onGestureStart = function (e) {
                                void 0 !== window.MSGesture && (o._MSGestureHandler || ((o._MSGestureHandler = new MSGesture()), (o._MSGestureHandler.target = i)), o._MSGestureHandler.addPointer(e.pointerId));
                            }),
                            (this._onGesture = function (e) {
                                (o.radius *= e.scale), e.preventDefault && (r || (e.stopPropagation(), e.preventDefault()));
                            }),
                            (this._reset = function () {
                                (o._keys = []), (o.inertialAlphaOffset = 0), (o.inertialBetaOffset = 0), (o.inertialRadiusOffset = 0), h.empty(), (a = 0), (s = null);
                            })),
                            n || i.addEventListener("contextmenu", this._onContextMenu, !1),
                            i.addEventListener(t + "down", this._onPointerDown, !1),
                            i.addEventListener(t + "up", this._onPointerUp, !1),
                            i.addEventListener(t + "out", this._onPointerUp, !1),
                            i.addEventListener(t + "move", this._onPointerMove, !1),
                            i.addEventListener("mousemove", this._onMouseMove, !1),
                            i.addEventListener("MSPointerDown", this._onGestureStart, !1),
                            i.addEventListener("MSGestureChange", this._onGesture, !1),
                            i.addEventListener("mousewheel", this._wheel, !1),
                            i.addEventListener("DOMMouseScroll", this._wheel, !1),
                            e.Tools.RegisterTopRootEvents([
                                { name: "keydown", handler: this._onKeyDown },
                                { name: "keyup", handler: this._onKeyUp },
                                { name: "blur", handler: this._onLostFocus },
                            ]);
                    }
                }),
                (r.prototype.detachControl = function (i) {
                    this._attachedElement === i &&
                        (i.removeEventListener("contextmenu", this._onContextMenu),
                        i.removeEventListener(t + "down", this._onPointerDown),
                        i.removeEventListener(t + "up", this._onPointerUp),
                        i.removeEventListener(t + "out", this._onPointerUp),
                        i.removeEventListener(t + "move", this._onPointerMove),
                        i.removeEventListener("mousemove", this._onMouseMove),
                        i.removeEventListener("MSPointerDown", this._onGestureStart),
                        i.removeEventListener("MSGestureChange", this._onGesture),
                        i.removeEventListener("mousewheel", this._wheel),
                        i.removeEventListener("DOMMouseScroll", this._wheel),
                        e.Tools.UnregisterTopRootEvents([
                            { name: "keydown", handler: this._onKeyDown },
                            { name: "keyup", handler: this._onKeyUp },
                            { name: "blur", handler: this._onLostFocus },
                        ]),
                        (this._MSGestureHandler = null),
                        (this._attachedElement = null),
                        this._reset && this._reset());
                }),
                (r.prototype._checkInputs = function () {
                    if (!this._collisionTriggered) {
                        for (var t = 0; t < this._keys.length; t++) {
                            var r = this._keys[t];
                            -1 !== this.keysLeft.indexOf(r)
                                ? (this.inertialAlphaOffset -= 0.01)
                                : -1 !== this.keysUp.indexOf(r)
                                ? (this.inertialBetaOffset -= 0.01)
                                : -1 !== this.keysRight.indexOf(r)
                                ? (this.inertialAlphaOffset += 0.01)
                                : -1 !== this.keysDown.indexOf(r) && (this.inertialBetaOffset += 0.01);
                        }
                        (0 !== this.inertialAlphaOffset || 0 !== this.inertialBetaOffset || 0 != this.inertialRadiusOffset) &&
                            ((this.alpha += this.beta <= 0 ? -this.inertialAlphaOffset : this.inertialAlphaOffset),
                            (this.beta += this.inertialBetaOffset),
                            (this.radius -= this.inertialRadiusOffset),
                            (this.inertialAlphaOffset *= this.inertia),
                            (this.inertialBetaOffset *= this.inertia),
                            (this.inertialRadiusOffset *= this.inertia),
                            Math.abs(this.inertialAlphaOffset) < e.Engine.Epsilon && (this.inertialAlphaOffset = 0),
                            Math.abs(this.inertialBetaOffset) < e.Engine.Epsilon && (this.inertialBetaOffset = 0),
                            Math.abs(this.inertialRadiusOffset) < e.Engine.Epsilon && (this.inertialRadiusOffset = 0)),
                            (0 !== this.inertialPanningX || 0 !== this.inertialPanningY) &&
                                (this._localDirection || ((this._localDirection = e.Vector3.Zero()), (this._transformedDirection = e.Vector3.Zero())),
                                (this.inertialPanningX *= this.inertia),
                                (this.inertialPanningY *= this.inertia),
                                Math.abs(this.inertialPanningX) < e.Engine.Epsilon && (this.inertialPanningX = 0),
                                Math.abs(this.inertialPanningY) < e.Engine.Epsilon && (this.inertialPanningY = 0),
                                this._localDirection.copyFromFloats(this.inertialPanningX, this.inertialPanningY, 0),
                                this._viewMatrix.invertToRef(this._cameraTransformMatrix),
                                e.Vector3.TransformNormalToRef(this._localDirection, this._cameraTransformMatrix, this._transformedDirection),
                                this.target.addInPlace(this._transformedDirection)),
                            this._checkLimits(),
                            i.prototype._checkInputs.call(this);
                    }
                }),
                (r.prototype._checkLimits = function () {
                    null === this.lowerBetaLimit || void 0 === this.lowerBetaLimit
                        ? this.allowUpsideDown && this.beta > Math.PI && (this.beta = this.beta - 2 * Math.PI)
                        : this.beta < this.lowerBetaLimit && (this.beta = this.lowerBetaLimit),
                        null === this.upperBetaLimit || void 0 === this.upperBetaLimit
                            ? this.allowUpsideDown && this.beta < -Math.PI && (this.beta = this.beta + 2 * Math.PI)
                            : this.beta > this.upperBetaLimit && (this.beta = this.upperBetaLimit),
                        this.lowerAlphaLimit && this.alpha < this.lowerAlphaLimit && (this.alpha = this.lowerAlphaLimit),
                        this.upperAlphaLimit && this.alpha > this.upperAlphaLimit && (this.alpha = this.upperAlphaLimit),
                        this.lowerRadiusLimit && this.radius < this.lowerRadiusLimit && (this.radius = this.lowerRadiusLimit),
                        this.upperRadiusLimit && this.radius > this.upperRadiusLimit && (this.radius = this.upperRadiusLimit);
                }),
                (r.prototype.setPosition = function (e) {
                    var t = e.subtract(this._getTargetPosition());
                    (this.radius = t.length()),
                        (this.alpha = Math.acos(t.x / Math.sqrt(Math.pow(t.x, 2) + Math.pow(t.z, 2)))),
                        t.z < 0 && (this.alpha = 2 * Math.PI - this.alpha),
                        (this.beta = Math.acos(t.y / this.radius)),
                        this._checkLimits();
                }),
                (r.prototype.setTarget = function (e) {
                    this.target = e;
                }),
                (r.prototype._getViewMatrix = function () {
                    var t = Math.cos(this.alpha),
                        i = Math.sin(this.alpha),
                        r = Math.cos(this.beta),
                        n = Math.sin(this.beta),
                        o = this._getTargetPosition();
                    if ((o.addToRef(new e.Vector3(this.radius * t * n, this.radius * r, this.radius * i * n), this._newPosition), this.getScene().collisionsEnabled && this.checkCollisions))
                        (this._collider.radius = this.collisionRadius),
                            this._newPosition.subtractToRef(this.position, this._collisionVelocity),
                            (this._collisionTriggered = !0),
                            this.getScene().collisionCoordinator.getNewPosition(this.position, this._collisionVelocity, this._collider, 3, null, this._onCollisionPositionChange, this.uniqueId);
                    else {
                        this.position.copyFrom(this._newPosition);
                        var s = this.upVector;
                        if (this.allowUpsideDown && this.beta < 0) {
                            var s = s.clone();
                            s = s.negate();
                        }
                        e.Matrix.LookAtLHToRef(this.position, o, s, this._viewMatrix), (this._viewMatrix.m[12] += this.targetScreenOffset.x), (this._viewMatrix.m[13] += this.targetScreenOffset.y);
                    }
                    return this._viewMatrix;
                }),
                (r.prototype.zoomOn = function (t, i) {
                    void 0 === i && (i = !1), (t = t || this.getScene().meshes);
                    var r = e.Mesh.MinMax(t),
                        n = e.Vector3.Distance(r.min, r.max);
                    (this.radius = n * this.zoomOnFactor), this.focusOn({ min: r.min, max: r.max, distance: n }, i);
                }),
                (r.prototype.focusOn = function (t, i) {
                    void 0 === i && (i = !1);
                    var r, n;
                    void 0 === t.min ? ((r = t || this.getScene().meshes), (r = e.Mesh.MinMax(r)), (n = e.Vector3.Distance(r.min, r.max))) : ((r = t), (n = t.distance)), (this.target = e.Mesh.Center(r)), i || (this.maxZ = 2 * n);
                }),
                (r.prototype.createRigCamera = function (t, i) {
                    switch (this.cameraRigMode) {
                        case e.Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH:
                        case e.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL:
                        case e.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED:
                        case e.Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER:
                        case e.Camera.RIG_MODE_VR:
                            var n = this._cameraRigParams.stereoHalfAngle * (0 === i ? 1 : -1);
                            return new r(t, this.alpha + n, this.beta, this.radius, this.target, this.getScene());
                    }
                }),
                (r.prototype._updateRigCameras = function () {
                    switch (this.cameraRigMode) {
                        case e.Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH:
                        case e.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL:
                        case e.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED:
                        case e.Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER:
                        case e.Camera.RIG_MODE_VR:
                            var t = this._rigCameras[0],
                                r = this._rigCameras[1];
                            (t.alpha = this.alpha - this._cameraRigParams.stereoHalfAngle), (r.alpha = this.alpha + this._cameraRigParams.stereoHalfAngle), (t.beta = r.beta = this.beta), (t.radius = r.radius = this.radius);
                    }
                    i.prototype._updateRigCameras.call(this);
                }),
                r
            );
        })(e.TargetCamera);
    e.ArcRotateCamera = i;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(e, i, r) {
            var n = this;
            t.call(this, e, i, r),
                (this._offsetX = null),
                (this._offsetY = null),
                (this._orientationGamma = 0),
                (this._orientationBeta = 0),
                (this._initialOrientationGamma = 0),
                (this._initialOrientationBeta = 0),
                (this.angularSensibility = 1e4),
                (this.moveSensibility = 50),
                window.addEventListener(
                    "resize",
                    function () {
                        n._initialOrientationGamma = null;
                    },
                    !1
                );
        }
        return (
            __extends(i, t),
            (i.prototype.attachControl = function (e, t) {
                var i = this;
                this._attachedCanvas ||
                    ((this._attachedCanvas = e),
                    this._orientationChanged ||
                        (this._orientationChanged = function (e) {
                            i._initialOrientationGamma || ((i._initialOrientationGamma = e.gamma), (i._initialOrientationBeta = e.beta)),
                                (i._orientationGamma = e.gamma),
                                (i._orientationBeta = e.beta),
                                (i._offsetY = i._initialOrientationBeta - i._orientationBeta),
                                (i._offsetX = i._initialOrientationGamma - i._orientationGamma);
                        }),
                    window.addEventListener("deviceorientation", this._orientationChanged));
            }),
            (i.prototype.detachControl = function (e) {
                this._attachedCanvas == e &&
                    (window.removeEventListener("deviceorientation", this._orientationChanged),
                    (this._attachedCanvas = null),
                    (this._orientationGamma = 0),
                    (this._orientationBeta = 0),
                    (this._initialOrientationGamma = 0),
                    (this._initialOrientationBeta = 0));
            }),
            (i.prototype._checkInputs = function () {
                if (this._offsetX) {
                    this.cameraRotation.y -= this._offsetX / this.angularSensibility;
                    var i = this._computeLocalCameraSpeed(),
                        r = new e.Vector3(0, 0, (i * this._offsetY) / this.moveSensibility);
                    e.Matrix.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, 0, this._cameraRotationMatrix),
                        this.cameraDirection.addInPlace(e.Vector3.TransformCoordinates(r, this._cameraRotationMatrix)),
                        t.prototype._checkInputs.call(this);
                }
            }),
            i
        );
    })(e.FreeCamera);
    e.DeviceOrientationCamera = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e(e) {
            var t = this;
            (this.babylonGamepads = []),
                (this.oneGamepadConnected = !1),
                (this.isMonitoring = !1),
                (this.gamepadEventSupported = "GamepadEvent" in window),
                (this.gamepadSupportAvailable = navigator.getGamepads || !!navigator.webkitGetGamepads || !!navigator.msGetGamepads || !!navigator.webkitGamepads),
                (this.buttonADataURL =
                    "data:image/png;base64,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"),
                (this._callbackGamepadConnected = e),
                this.gamepadSupportAvailable
                    ? (this.gamepadEventSupported
                          ? (window.addEventListener(
                                "gamepadconnected",
                                function (e) {
                                    t._onGamepadConnected(e);
                                },
                                !1
                            ),
                            window.addEventListener(
                                "gamepaddisconnected",
                                function (e) {
                                    t._onGamepadDisconnected(e);
                                },
                                !1
                            ))
                          : this._startMonitoringGamepads(),
                      this.oneGamepadConnected || this._insertGamepadDOMInstructions())
                    : this._insertGamepadDOMNotSupported();
        }
        return (
            (e.prototype._insertGamepadDOMInstructions = function () {
                e.gamepadDOMInfo = document.createElement("div");
                var t = document.createElement("img");
                t.src = this.buttonADataURL;
                var i = document.createElement("span");
                (i.innerHTML = "<strong>to activate gamepad</strong>"),
                    e.gamepadDOMInfo.appendChild(t),
                    e.gamepadDOMInfo.appendChild(i),
                    (e.gamepadDOMInfo.style.position = "absolute"),
                    (e.gamepadDOMInfo.style.width = "100%"),
                    (e.gamepadDOMInfo.style.height = "48px"),
                    (e.gamepadDOMInfo.style.bottom = "0px"),
                    (e.gamepadDOMInfo.style.backgroundColor = "rgba(1, 1, 1, 0.15)"),
                    (e.gamepadDOMInfo.style.textAlign = "center"),
                    (e.gamepadDOMInfo.style.zIndex = "10"),
                    (t.style.position = "relative"),
                    (t.style.bottom = "8px"),
                    (i.style.position = "relative"),
                    (i.style.fontSize = "32px"),
                    (i.style.bottom = "32px"),
                    (i.style.color = "green"),
                    document.body.appendChild(e.gamepadDOMInfo);
            }),
            (e.prototype._insertGamepadDOMNotSupported = function () {
                e.gamepadDOMInfo = document.createElement("div");
                var t = document.createElement("span");
                (t.innerHTML = "<strong>gamepad not supported</strong>"),
                    e.gamepadDOMInfo.appendChild(t),
                    (e.gamepadDOMInfo.style.position = "absolute"),
                    (e.gamepadDOMInfo.style.width = "100%"),
                    (e.gamepadDOMInfo.style.height = "40px"),
                    (e.gamepadDOMInfo.style.bottom = "0px"),
                    (e.gamepadDOMInfo.style.backgroundColor = "rgba(1, 1, 1, 0.15)"),
                    (e.gamepadDOMInfo.style.textAlign = "center"),
                    (e.gamepadDOMInfo.style.zIndex = "10"),
                    (t.style.position = "relative"),
                    (t.style.fontSize = "32px"),
                    (t.style.color = "red"),
                    document.body.appendChild(e.gamepadDOMInfo);
            }),
            (e.prototype.dispose = function () {
                e.gamepadDOMInfo && document.body.removeChild(e.gamepadDOMInfo);
            }),
            (e.prototype._onGamepadConnected = function (e) {
                var t = this._addNewGamepad(e.gamepad);
                this._callbackGamepadConnected && this._callbackGamepadConnected(t), this._startMonitoringGamepads();
            }),
            (e.prototype._addNewGamepad = function (t) {
                this.oneGamepadConnected || ((this.oneGamepadConnected = !0), e.gamepadDOMInfo && (document.body.removeChild(e.gamepadDOMInfo), (e.gamepadDOMInfo = null)));
                var i;
                return (i = -1 !== t.id.search("Xbox 360") || -1 !== t.id.search("xinput") ? new a(t.id, t.index, t) : new n(t.id, t.index, t)), this.babylonGamepads.push(i), i;
            }),
            (e.prototype._onGamepadDisconnected = function (e) {
                for (var t in this.babylonGamepads)
                    if (this.babylonGamepads[t].index == e.gamepad.index) {
                        this.babylonGamepads.splice(t, 1);
                        break;
                    }
                0 == this.babylonGamepads.length && this._stopMonitoringGamepads();
            }),
            (e.prototype._startMonitoringGamepads = function () {
                this.isMonitoring || ((this.isMonitoring = !0), this._checkGamepadsStatus());
            }),
            (e.prototype._stopMonitoringGamepads = function () {
                this.isMonitoring = !1;
            }),
            (e.prototype._checkGamepadsStatus = function () {
                var e = this;
                this._updateGamepadObjects();
                for (var t in this.babylonGamepads) this.babylonGamepads[t].update();
                this.isMonitoring &&
                    (window.requestAnimationFrame
                        ? window.requestAnimationFrame(function () {
                              e._checkGamepadsStatus();
                          })
                        : window.mozRequestAnimationFrame
                        ? window.mozRequestAnimationFrame(function () {
                              e._checkGamepadsStatus();
                          })
                        : window.webkitRequestAnimationFrame &&
                          window.webkitRequestAnimationFrame(function () {
                              e._checkGamepadsStatus();
                          }));
            }),
            (e.prototype._updateGamepadObjects = function () {
                for (var e = navigator.getGamepads ? navigator.getGamepads() : navigator.webkitGetGamepads ? navigator.webkitGetGamepads() : [], t = 0; t < e.length; t++)
                    if (e[t])
                        if (e[t].index in this.babylonGamepads) this.babylonGamepads[t].browserGamepad = e[t];
                        else {
                            var i = this._addNewGamepad(e[t]);
                            this._callbackGamepadConnected && this._callbackGamepadConnected(i);
                        }
            }),
            e
        );
    })();
    e.Gamepads = t;
    var i = (function () {
        function e(e, t) {
            (this.x = e), (this.y = t);
        }
        return e;
    })();
    e.StickValues = i;
    var r = (function () {
        function e(e, t, i) {
            (this.id = e),
                (this.index = t),
                (this.browserGamepad = i),
                this.browserGamepad.axes.length >= 2 && (this._leftStick = { x: this.browserGamepad.axes[0], y: this.browserGamepad.axes[1] }),
                this.browserGamepad.axes.length >= 4 && (this._rightStick = { x: this.browserGamepad.axes[2], y: this.browserGamepad.axes[3] });
        }
        return (
            (e.prototype.onleftstickchanged = function (e) {
                this._onleftstickchanged = e;
            }),
            (e.prototype.onrightstickchanged = function (e) {
                this._onrightstickchanged = e;
            }),
            Object.defineProperty(e.prototype, "leftStick", {
                get: function () {
                    return this._leftStick;
                },
                set: function (e) {
                    !this._onleftstickchanged || (this._leftStick.x === e.x && this._leftStick.y === e.y) || this._onleftstickchanged(e), (this._leftStick = e);
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e.prototype, "rightStick", {
                get: function () {
                    return this._rightStick;
                },
                set: function (e) {
                    !this._onrightstickchanged || (this._rightStick.x === e.x && this._rightStick.y === e.y) || this._onrightstickchanged(e), (this._rightStick = e);
                },
                enumerable: !0,
                configurable: !0,
            }),
            (e.prototype.update = function () {
                this._leftStick && (this.leftStick = { x: this.browserGamepad.axes[0], y: this.browserGamepad.axes[1] }), this._rightStick && (this.rightStick = { x: this.browserGamepad.axes[2], y: this.browserGamepad.axes[3] });
            }),
            e
        );
    })();
    e.Gamepad = r;
    var n = (function (e) {
        function t(t, i, r) {
            e.call(this, t, i, r), (this.id = t), (this.index = i), (this.gamepad = r), (this._buttons = new Array(r.buttons.length));
        }
        return (
            __extends(t, e),
            (t.prototype.onbuttondown = function (e) {
                this._onbuttondown = e;
            }),
            (t.prototype.onbuttonup = function (e) {
                this._onbuttonup = e;
            }),
            (t.prototype._setButtonValue = function (e, t, i) {
                return e !== t && (this._onbuttondown && 1 === e && this._onbuttondown(i), this._onbuttonup && 0 === e && this._onbuttonup(i)), e;
            }),
            (t.prototype.update = function () {
                e.prototype.update.call(this);
                for (var t = 0; t < this._buttons.length; t++) this._buttons[t] = this._setButtonValue(this.gamepad.buttons[t].value, this._buttons[t], t);
            }),
            t
        );
    })(r);
    (e.GenericPad = n),
        (function (e) {
            (e[(e.A = 0)] = "A"),
                (e[(e.B = 1)] = "B"),
                (e[(e.X = 2)] = "X"),
                (e[(e.Y = 3)] = "Y"),
                (e[(e.Start = 4)] = "Start"),
                (e[(e.Back = 5)] = "Back"),
                (e[(e.LB = 6)] = "LB"),
                (e[(e.RB = 7)] = "RB"),
                (e[(e.LeftStick = 8)] = "LeftStick"),
                (e[(e.RightStick = 9)] = "RightStick");
        })(e.Xbox360Button || (e.Xbox360Button = {}));
    var o = e.Xbox360Button;
    !(function (e) {
        (e[(e.Up = 0)] = "Up"), (e[(e.Down = 1)] = "Down"), (e[(e.Left = 2)] = "Left"), (e[(e.Right = 3)] = "Right");
    })(e.Xbox360Dpad || (e.Xbox360Dpad = {}));
    var s = e.Xbox360Dpad,
        a = (function (e) {
            function t() {
                e.apply(this, arguments),
                    (this._leftTrigger = 0),
                    (this._rightTrigger = 0),
                    (this._buttonA = 0),
                    (this._buttonB = 0),
                    (this._buttonX = 0),
                    (this._buttonY = 0),
                    (this._buttonBack = 0),
                    (this._buttonStart = 0),
                    (this._buttonLB = 0),
                    (this._buttonRB = 0),
                    (this._buttonLeftStick = 0),
                    (this._buttonRightStick = 0),
                    (this._dPadUp = 0),
                    (this._dPadDown = 0),
                    (this._dPadLeft = 0),
                    (this._dPadRight = 0);
            }
            return (
                __extends(t, e),
                (t.prototype.onlefttriggerchanged = function (e) {
                    this._onlefttriggerchanged = e;
                }),
                (t.prototype.onrighttriggerchanged = function (e) {
                    this._onrighttriggerchanged = e;
                }),
                Object.defineProperty(t.prototype, "leftTrigger", {
                    get: function () {
                        return this._leftTrigger;
                    },
                    set: function (e) {
                        this._onlefttriggerchanged && this._leftTrigger !== e && this._onlefttriggerchanged(e), (this._leftTrigger = e);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "rightTrigger", {
                    get: function () {
                        return this._rightTrigger;
                    },
                    set: function (e) {
                        this._onrighttriggerchanged && this._rightTrigger !== e && this._onrighttriggerchanged(e), (this._rightTrigger = e);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                (t.prototype.onbuttondown = function (e) {
                    this._onbuttondown = e;
                }),
                (t.prototype.onbuttonup = function (e) {
                    this._onbuttonup = e;
                }),
                (t.prototype.ondpaddown = function (e) {
                    this._ondpaddown = e;
                }),
                (t.prototype.ondpadup = function (e) {
                    this._ondpadup = e;
                }),
                (t.prototype._setButtonValue = function (e, t, i) {
                    return e !== t && (this._onbuttondown && 1 === e && this._onbuttondown(i), this._onbuttonup && 0 === e && this._onbuttonup(i)), e;
                }),
                (t.prototype._setDPadValue = function (e, t, i) {
                    return e !== t && (this._ondpaddown && 1 === e && this._ondpaddown(i), this._ondpadup && 0 === e && this._ondpadup(i)), e;
                }),
                Object.defineProperty(t.prototype, "buttonA", {
                    get: function () {
                        return this._buttonA;
                    },
                    set: function (e) {
                        this._buttonA = this._setButtonValue(e, this._buttonA, o.A);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonB", {
                    get: function () {
                        return this._buttonB;
                    },
                    set: function (e) {
                        this._buttonB = this._setButtonValue(e, this._buttonB, o.B);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonX", {
                    get: function () {
                        return this._buttonX;
                    },
                    set: function (e) {
                        this._buttonX = this._setButtonValue(e, this._buttonX, o.X);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonY", {
                    get: function () {
                        return this._buttonY;
                    },
                    set: function (e) {
                        this._buttonY = this._setButtonValue(e, this._buttonY, o.Y);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonStart", {
                    get: function () {
                        return this._buttonStart;
                    },
                    set: function (e) {
                        this._buttonStart = this._setButtonValue(e, this._buttonStart, o.Start);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonBack", {
                    get: function () {
                        return this._buttonBack;
                    },
                    set: function (e) {
                        this._buttonBack = this._setButtonValue(e, this._buttonBack, o.Back);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonLB", {
                    get: function () {
                        return this._buttonLB;
                    },
                    set: function (e) {
                        this._buttonLB = this._setButtonValue(e, this._buttonLB, o.LB);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonRB", {
                    get: function () {
                        return this._buttonRB;
                    },
                    set: function (e) {
                        this._buttonRB = this._setButtonValue(e, this._buttonRB, o.RB);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonLeftStick", {
                    get: function () {
                        return this._buttonLeftStick;
                    },
                    set: function (e) {
                        this._buttonLeftStick = this._setButtonValue(e, this._buttonLeftStick, o.LeftStick);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "buttonRightStick", {
                    get: function () {
                        return this._buttonRightStick;
                    },
                    set: function (e) {
                        this._buttonRightStick = this._setButtonValue(e, this._buttonRightStick, o.RightStick);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "dPadUp", {
                    get: function () {
                        return this._dPadUp;
                    },
                    set: function (e) {
                        this._dPadUp = this._setDPadValue(e, this._dPadUp, s.Up);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "dPadDown", {
                    get: function () {
                        return this._dPadDown;
                    },
                    set: function (e) {
                        this._dPadDown = this._setDPadValue(e, this._dPadDown, s.Down);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "dPadLeft", {
                    get: function () {
                        return this._dPadLeft;
                    },
                    set: function (e) {
                        this._dPadLeft = this._setDPadValue(e, this._dPadLeft, s.Left);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                Object.defineProperty(t.prototype, "dPadRight", {
                    get: function () {
                        return this._dPadRight;
                    },
                    set: function (e) {
                        this._dPadRight = this._setDPadValue(e, this._dPadRight, s.Right);
                    },
                    enumerable: !0,
                    configurable: !0,
                }),
                (t.prototype.update = function () {
                    e.prototype.update.call(this),
                        (this.buttonA = this.browserGamepad.buttons[0].value),
                        (this.buttonB = this.browserGamepad.buttons[1].value),
                        (this.buttonX = this.browserGamepad.buttons[2].value),
                        (this.buttonY = this.browserGamepad.buttons[3].value),
                        (this.buttonLB = this.browserGamepad.buttons[4].value),
                        (this.buttonRB = this.browserGamepad.buttons[5].value),
                        (this.leftTrigger = this.browserGamepad.buttons[6].value),
                        (this.rightTrigger = this.browserGamepad.buttons[7].value),
                        (this.buttonBack = this.browserGamepad.buttons[8].value),
                        (this.buttonStart = this.browserGamepad.buttons[9].value),
                        (this.buttonLeftStick = this.browserGamepad.buttons[10].value),
                        (this.buttonRightStick = this.browserGamepad.buttons[11].value),
                        (this.dPadUp = this.browserGamepad.buttons[12].value),
                        (this.dPadDown = this.browserGamepad.buttons[13].value),
                        (this.dPadLeft = this.browserGamepad.buttons[14].value),
                        (this.dPadRight = this.browserGamepad.buttons[15].value);
                }),
                t
            );
        })(r);
    e.Xbox360Pad = a;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n) {
            var o = this;
            t.call(this, i, r, n),
                (this.angularSensibility = 200),
                (this.moveSensibility = 75),
                (this._gamepads = new e.Gamepads(function (e) {
                    o._onNewGameConnected(e);
                }));
        }
        return (
            __extends(i, t),
            (i.prototype._onNewGameConnected = function (e) {
                0 === e.index && (this._gamepad = e);
            }),
            (i.prototype._checkInputs = function () {
                if (this._gamepad) {
                    var i = this._gamepad.leftStick,
                        r = i.x / this.moveSensibility,
                        n = i.y / this.moveSensibility;
                    (i.x = Math.abs(r) > 0.005 ? 0 + r : 0), (i.y = Math.abs(n) > 0.005 ? 0 + n : 0);
                    var o = this._gamepad.rightStick,
                        s = o.x / this.angularSensibility,
                        a = o.y / this.angularSensibility;
                    (o.x = Math.abs(s) > 0.001 ? 0 + s : 0), (o.y = Math.abs(a) > 0.001 ? 0 + a : 0);
                    var h = e.Matrix.RotationYawPitchRoll(this.rotation.y, this.rotation.x, 0),
                        l = 50 * this._computeLocalCameraSpeed(),
                        c = e.Vector3.TransformCoordinates(new e.Vector3(i.x * l, 0, -i.y * l), h);
                    (this.cameraDirection = this.cameraDirection.add(c)), (this.cameraRotation = this.cameraRotation.add(new e.Vector2(o.y, o.x)));
                }
                t.prototype._checkInputs.call(this);
            }),
            (i.prototype.dispose = function () {
                this._gamepads.dispose(), t.prototype.dispose.call(this);
            }),
            i
        );
    })(e.FreeCamera);
    e.GamepadCamera = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e) {
            (this._renderingGroups = new Array()), (this._scene = e);
        }
        return (
            (t.prototype._renderParticles = function (t, i) {
                if (0 !== this._scene._activeParticleSystems.length) {
                    for (var r = this._scene.activeCamera, n = e.Tools.Now, o = 0; o < this._scene._activeParticleSystems.length; o++) {
                        var s = this._scene._activeParticleSystems.data[o];
                        s.renderingGroupId === t && 0 !== (r.layerMask & s.layerMask) && (this._clearDepthBuffer(), (s.emitter.position && i && -1 === i.indexOf(s.emitter)) || (this._scene._activeParticles += s.render()));
                    }
                    this._scene._particlesDuration += e.Tools.Now - n;
                }
            }),
            (t.prototype._renderSprites = function (t) {
                if (this._scene.spritesEnabled && 0 !== this._scene.spriteManagers.length) {
                    for (var i = this._scene.activeCamera, r = e.Tools.Now, n = 0; n < this._scene.spriteManagers.length; n++) {
                        var o = this._scene.spriteManagers[n];
                        o.renderingGroupId === t && 0 !== (i.layerMask & o.layerMask) && (this._clearDepthBuffer(), o.render());
                    }
                    this._scene._spritesDuration += e.Tools.Now - r;
                }
            }),
            (t.prototype._clearDepthBuffer = function () {
                this._depthBufferAlreadyCleaned || (this._scene.getEngine().clear(0, !1, !0), (this._depthBufferAlreadyCleaned = !0));
            }),
            (t.prototype.render = function (e, i, r, n) {
                for (var o = 0; o < t.MAX_RENDERINGGROUPS; o++) {
                    this._depthBufferAlreadyCleaned = !1;
                    var s = this._renderingGroups[o],
                        a = !1;
                    s && (this._clearDepthBuffer(), s.render(e) || (this._renderingGroups.splice(o, 1), (a = !0))), n && this._renderSprites(o), r && this._renderParticles(o, i), a && o--;
                }
            }),
            (t.prototype.reset = function () {
                this._renderingGroups.forEach(function (e, t, i) {
                    e && e.prepare();
                });
            }),
            (t.prototype.dispatch = function (t) {
                var i = t.getMesh(),
                    r = i.renderingGroupId || 0;
                this._renderingGroups[r] || (this._renderingGroups[r] = new e.RenderingGroup(r, this._scene)), this._renderingGroups[r].dispatch(t);
            }),
            (t.MAX_RENDERINGGROUPS = 4),
            t
        );
    })();
    e.RenderingManager = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i) {
            (this.index = t), (this._opaqueSubMeshes = new e.SmartArray(256)), (this._transparentSubMeshes = new e.SmartArray(256)), (this._alphaTestSubMeshes = new e.SmartArray(256)), (this._scene = i);
        }
        return (
            (t.prototype.render = function (t) {
                if (t) return t(this._opaqueSubMeshes, this._alphaTestSubMeshes, this._transparentSubMeshes), !0;
                if (0 === this._opaqueSubMeshes.length && 0 === this._alphaTestSubMeshes.length && 0 === this._transparentSubMeshes.length) return !1;
                var i,
                    r,
                    n = this._scene.getEngine();
                for (i = 0; i < this._opaqueSubMeshes.length; i++) (r = this._opaqueSubMeshes.data[i]), r.render(!1);
                for (n.setAlphaTesting(!0), i = 0; i < this._alphaTestSubMeshes.length; i++) (r = this._alphaTestSubMeshes.data[i]), r.render(!1);
                if ((n.setAlphaTesting(!1), this._transparentSubMeshes.length)) {
                    for (i = 0; i < this._transparentSubMeshes.length; i++)
                        (r = this._transparentSubMeshes.data[i]), (r._alphaIndex = r.getMesh().alphaIndex), (r._distanceToCamera = r.getBoundingInfo().boundingSphere.centerWorld.subtract(this._scene.activeCamera.globalPosition).length());
                    var o = this._transparentSubMeshes.data.slice(0, this._transparentSubMeshes.length);
                    for (
                        o.sort(function (e, t) {
                            return e._alphaIndex > t._alphaIndex ? 1 : e._alphaIndex < t._alphaIndex ? -1 : e._distanceToCamera < t._distanceToCamera ? 1 : e._distanceToCamera > t._distanceToCamera ? -1 : 0;
                        }),
                            i = 0;
                        i < o.length;
                        i++
                    )
                        (r = o[i]), r.render(!0);
                    n.setAlphaMode(e.Engine.ALPHA_DISABLE);
                }
                return !0;
            }),
            (t.prototype.prepare = function () {
                this._opaqueSubMeshes.reset(), this._transparentSubMeshes.reset(), this._alphaTestSubMeshes.reset();
            }),
            (t.prototype.dispatch = function (e) {
                var t = e.getMaterial(),
                    i = e.getMesh();
                t.needAlphaBlending() || i.visibility < 1 || i.hasVertexAlpha ? this._transparentSubMeshes.push(e) : t.needAlphaTesting() ? this._alphaTestSubMeshes.push(e) : this._opaqueSubMeshes.push(e);
            }),
            t
        );
    })();
    e.RenderingGroup = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(i) {
            (this.autoClear = !0),
                (this.clearColor = new e.Color3(0.2, 0.2, 0.3)),
                (this.ambientColor = new e.Color3(0, 0, 0)),
                (this.forceWireframe = !1),
                (this.forcePointsCloud = !1),
                (this.forceShowBoundingBoxes = !1),
                (this.animationsEnabled = !0),
                (this.cameraToUseForPointers = null),
                (this.fogEnabled = !0),
                (this.fogMode = t.FOGMODE_NONE),
                (this.fogColor = new e.Color3(0.2, 0.2, 0.3)),
                (this.fogDensity = 0.1),
                (this.fogStart = 0),
                (this.fogEnd = 1e3),
                (this.shadowsEnabled = !0),
                (this.lightsEnabled = !0),
                (this.lights = new Array()),
                (this.cameras = new Array()),
                (this.activeCameras = new Array()),
                (this.meshes = new Array()),
                (this._geometries = new Array()),
                (this.materials = new Array()),
                (this.multiMaterials = new Array()),
                (this.defaultMaterial = new e.StandardMaterial("default material", this)),
                (this.texturesEnabled = !0),
                (this.textures = new Array()),
                (this.particlesEnabled = !0),
                (this.particleSystems = new Array()),
                (this.spritesEnabled = !0),
                (this.spriteManagers = new Array()),
                (this.layers = new Array()),
                (this.skeletonsEnabled = !0),
                (this.skeletons = new Array()),
                (this.lensFlaresEnabled = !0),
                (this.lensFlareSystems = new Array()),
                (this.collisionsEnabled = !0),
                (this.gravity = new e.Vector3(0, -9.807, 0)),
                (this.postProcessesEnabled = !0),
                (this.renderTargetsEnabled = !0),
                (this.dumpNextRenderTargets = !1),
                (this.customRenderTargets = new Array()),
                (this.importedMeshesFiles = new Array()),
                (this._actionManagers = new Array()),
                (this._meshesForIntersections = new e.SmartArray(256)),
                (this.proceduralTexturesEnabled = !0),
                (this._proceduralTextures = new Array()),
                (this.soundTracks = new Array()),
                (this._audioEnabled = !0),
                (this._headphone = !1),
                (this._totalVertices = 0),
                (this._activeIndices = 0),
                (this._activeParticles = 0),
                (this._lastFrameDuration = 0),
                (this._evaluateActiveMeshesDuration = 0),
                (this._renderTargetsDuration = 0),
                (this._particlesDuration = 0),
                (this._renderDuration = 0),
                (this._spritesDuration = 0),
                (this._animationRatio = 0),
                (this._renderId = 0),
                (this._executeWhenReadyTimeoutId = -1),
                (this._toBeDisposed = new e.SmartArray(256)),
                (this._onReadyCallbacks = new Array()),
                (this._pendingData = []),
                (this._onBeforeRenderCallbacks = new Array()),
                (this._onAfterRenderCallbacks = new Array()),
                (this._activeMeshes = new e.SmartArray(256)),
                (this._processedMaterials = new e.SmartArray(256)),
                (this._renderTargets = new e.SmartArray(256)),
                (this._activeParticleSystems = new e.SmartArray(256)),
                (this._activeSkeletons = new e.SmartArray(32)),
                (this._softwareSkinnedMeshes = new e.SmartArray(32)),
                (this._activeBones = 0),
                (this._activeAnimatables = new Array()),
                (this._transformMatrix = e.Matrix.Zero()),
                (this._edgesRenderers = new e.SmartArray(16)),
                (this._uniqueIdCounter = 0),
                (this._engine = i),
                i.scenes.push(this),
                (this._renderingManager = new e.RenderingManager(this)),
                (this.postProcessManager = new e.PostProcessManager(this)),
                (this.postProcessRenderPipelineManager = new e.PostProcessRenderPipelineManager()),
                (this._boundingBoxRenderer = new e.BoundingBoxRenderer(this)),
                (this._outlineRenderer = new e.OutlineRenderer(this)),
                this.attachControl(),
                (this._debugLayer = new e.DebugLayer(this)),
                (this.mainSoundTrack = new e.SoundTrack(this, { mainTrack: !0 })),
                (this.simplificationQueue = new e.SimplificationQueue()),
                (this.workerCollisions = !1);
        }
        return (
            Object.defineProperty(t, "FOGMODE_NONE", {
                get: function () {
                    return t._FOGMODE_NONE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "FOGMODE_EXP", {
                get: function () {
                    return t._FOGMODE_EXP;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "FOGMODE_EXP2", {
                get: function () {
                    return t._FOGMODE_EXP2;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "FOGMODE_LINEAR", {
                get: function () {
                    return t._FOGMODE_LINEAR;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "debugLayer", {
                get: function () {
                    return this._debugLayer;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "workerCollisions", {
                get: function () {
                    return this._workerCollisions;
                },
                set: function (t) {
                    (t = t && !!Worker),
                        (this._workerCollisions = t),
                        this.collisionCoordinator && this.collisionCoordinator.destroy(),
                        (this.collisionCoordinator = t ? new e.CollisionCoordinatorWorker() : new e.CollisionCoordinatorLegacy()),
                        this.collisionCoordinator.init(this);
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "SelectionOctree", {
                get: function () {
                    return this._selectionOctree;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "meshUnderPointer", {
                get: function () {
                    return this._meshUnderPointer;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "pointerX", {
                get: function () {
                    return this._pointerX;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "pointerY", {
                get: function () {
                    return this._pointerY;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype.getCachedMaterial = function () {
                return this._cachedMaterial;
            }),
            (t.prototype.getBoundingBoxRenderer = function () {
                return this._boundingBoxRenderer;
            }),
            (t.prototype.getOutlineRenderer = function () {
                return this._outlineRenderer;
            }),
            (t.prototype.getEngine = function () {
                return this._engine;
            }),
            (t.prototype.getTotalVertices = function () {
                return this._totalVertices;
            }),
            (t.prototype.getActiveIndices = function () {
                return this._activeIndices;
            }),
            (t.prototype.getActiveParticles = function () {
                return this._activeParticles;
            }),
            (t.prototype.getActiveBones = function () {
                return this._activeBones;
            }),
            (t.prototype.getLastFrameDuration = function () {
                return this._lastFrameDuration;
            }),
            (t.prototype.getEvaluateActiveMeshesDuration = function () {
                return this._evaluateActiveMeshesDuration;
            }),
            (t.prototype.getActiveMeshes = function () {
                return this._activeMeshes;
            }),
            (t.prototype.getRenderTargetsDuration = function () {
                return this._renderTargetsDuration;
            }),
            (t.prototype.getRenderDuration = function () {
                return this._renderDuration;
            }),
            (t.prototype.getParticlesDuration = function () {
                return this._particlesDuration;
            }),
            (t.prototype.getSpritesDuration = function () {
                return this._spritesDuration;
            }),
            (t.prototype.getAnimationRatio = function () {
                return this._animationRatio;
            }),
            (t.prototype.getRenderId = function () {
                return this._renderId;
            }),
            (t.prototype.incrementRenderId = function () {
                this._renderId++;
            }),
            (t.prototype._updatePointerPosition = function (e) {
                var t = this._engine.getRenderingCanvasClientRect();
                (this._pointerX = e.clientX - t.left),
                    (this._pointerY = e.clientY - t.top),
                    this.cameraToUseForPointers &&
                        ((this._pointerX = this._pointerX - this.cameraToUseForPointers.viewport.x * this._engine.getRenderWidth()),
                        (this._pointerY = this._pointerY - this.cameraToUseForPointers.viewport.y * this._engine.getRenderHeight()));
            }),
            (t.prototype.attachControl = function () {
                var t = this;
                (this._onPointerMove = function (e) {
                    var i = t._engine.getRenderingCanvas();
                    t._updatePointerPosition(e);
                    var r = t.pick(
                        t._pointerX,
                        t._pointerY,
                        function (e) {
                            return e.isPickable && e.isVisible && e.isReady();
                        },
                        !1,
                        t.cameraToUseForPointers
                    );
                    r.hit
                        ? ((t._meshUnderPointer = r.pickedMesh), t.setPointerOverMesh(r.pickedMesh), (i.style.cursor = t._meshUnderPointer.actionManager && t._meshUnderPointer.actionManager.hasPointerTriggers ? "pointer" : ""))
                        : (t.setPointerOverMesh(null), (i.style.cursor = ""), (t._meshUnderPointer = null));
                }),
                    (this._onPointerDown = function (i) {
                        var r = null;
                        t.onPointerDown ||
                            (r = function (e) {
                                return e.isPickable && e.isVisible && e.isReady() && e.actionManager && e.actionManager.hasPickTriggers;
                            }),
                            t._updatePointerPosition(i);
                        var n = t.pick(t._pointerX, t._pointerY, r, !1, t.cameraToUseForPointers);
                        if (n.hit && n.pickedMesh.actionManager) {
                            switch (i.button) {
                                case 0:
                                    n.pickedMesh.actionManager.processTrigger(e.ActionManager.OnLeftPickTrigger, e.ActionEvent.CreateNew(n.pickedMesh, i));
                                    break;
                                case 1:
                                    n.pickedMesh.actionManager.processTrigger(e.ActionManager.OnCenterPickTrigger, e.ActionEvent.CreateNew(n.pickedMesh, i));
                                    break;
                                case 2:
                                    n.pickedMesh.actionManager.processTrigger(e.ActionManager.OnRightPickTrigger, e.ActionEvent.CreateNew(n.pickedMesh, i));
                            }
                            n.pickedMesh.actionManager.processTrigger(e.ActionManager.OnPickTrigger, e.ActionEvent.CreateNew(n.pickedMesh, i));
                        }
                        t.onPointerDown && t.onPointerDown(i, n);
                    }),
                    (this._onPointerUp = function (i) {
                        var r = null;
                        t.onPointerUp ||
                            (r = function (t) {
                                return t.isPickable && t.isVisible && t.isReady() && t.actionManager && t.actionManager.hasSpecificTrigger(e.ActionManager.OnPickUpTrigger);
                            }),
                            t._updatePointerPosition(i);
                        var n = t.pick(t._pointerX, t._pointerY, r, !1, t.cameraToUseForPointers);
                        n.hit && n.pickedMesh.actionManager && n.pickedMesh.actionManager.processTrigger(e.ActionManager.OnPickUpTrigger, e.ActionEvent.CreateNew(n.pickedMesh, i)), t.onPointerUp && t.onPointerUp(i, n);
                    }),
                    (this._onKeyDown = function (i) {
                        t.actionManager && t.actionManager.processTrigger(e.ActionManager.OnKeyDownTrigger, e.ActionEvent.CreateNewFromScene(t, i));
                    }),
                    (this._onKeyUp = function (i) {
                        t.actionManager && t.actionManager.processTrigger(e.ActionManager.OnKeyUpTrigger, e.ActionEvent.CreateNewFromScene(t, i));
                    });
                var i = e.Tools.GetPointerPrefix();
                this._engine.getRenderingCanvas().addEventListener(i + "move", this._onPointerMove, !1),
                    this._engine.getRenderingCanvas().addEventListener(i + "down", this._onPointerDown, !1),
                    this._engine.getRenderingCanvas().addEventListener(i + "up", this._onPointerUp, !1),
                    this._engine.getRenderingCanvas().addEventListener("mousewheel", this._onPointerMove, !1),
                    this._engine.getRenderingCanvas().addEventListener("DOMMouseScroll", this._onPointerMove, !1),
                    e.Tools.RegisterTopRootEvents([
                        { name: "keydown", handler: this._onKeyDown },
                        { name: "keyup", handler: this._onKeyUp },
                    ]);
            }),
            (t.prototype.detachControl = function () {
                var t = e.Tools.GetPointerPrefix();
                this._engine.getRenderingCanvas().removeEventListener(t + "move", this._onPointerMove),
                    this._engine.getRenderingCanvas().removeEventListener(t + "down", this._onPointerDown),
                    this._engine.getRenderingCanvas().removeEventListener(t + "up", this._onPointerUp),
                    this._engine.getRenderingCanvas().removeEventListener("mousewheel", this._onPointerMove),
                    this._engine.getRenderingCanvas().removeEventListener("DOMMouseScroll", this._onPointerMove),
                    e.Tools.UnregisterTopRootEvents([
                        { name: "keydown", handler: this._onKeyDown },
                        { name: "keyup", handler: this._onKeyUp },
                    ]);
            }),
            (t.prototype.isReady = function () {
                if (this._pendingData.length > 0) return !1;
                var t;
                for (t = 0; t < this._geometries.length; t++) {
                    var i = this._geometries[t];
                    if (i.delayLoadState === e.Engine.DELAYLOADSTATE_LOADING) return !1;
                }
                for (t = 0; t < this.meshes.length; t++) {
                    var r = this.meshes[t];
                    if (!r.isReady()) return !1;
                    var n = r.material;
                    if (n && !n.isReady(r)) return !1;
                }
                return !0;
            }),
            (t.prototype.resetCachedMaterial = function () {
                this._cachedMaterial = null;
            }),
            (t.prototype.registerBeforeRender = function (e) {
                this._onBeforeRenderCallbacks.push(e);
            }),
            (t.prototype.unregisterBeforeRender = function (e) {
                var t = this._onBeforeRenderCallbacks.indexOf(e);
                t > -1 && this._onBeforeRenderCallbacks.splice(t, 1);
            }),
            (t.prototype.registerAfterRender = function (e) {
                this._onAfterRenderCallbacks.push(e);
            }),
            (t.prototype.unregisterAfterRender = function (e) {
                var t = this._onAfterRenderCallbacks.indexOf(e);
                t > -1 && this._onAfterRenderCallbacks.splice(t, 1);
            }),
            (t.prototype._addPendingData = function (e) {
                this._pendingData.push(e);
            }),
            (t.prototype._removePendingData = function (e) {
                var t = this._pendingData.indexOf(e);
                -1 !== t && this._pendingData.splice(t, 1);
            }),
            (t.prototype.getWaitingItemsCount = function () {
                return this._pendingData.length;
            }),
            (t.prototype.executeWhenReady = function (e) {
                var t = this;
                this._onReadyCallbacks.push(e),
                    -1 === this._executeWhenReadyTimeoutId &&
                        (this._executeWhenReadyTimeoutId = setTimeout(function () {
                            t._checkIsReady();
                        }, 150));
            }),
            (t.prototype._checkIsReady = function () {
                var e = this;
                return this.isReady()
                    ? (this._onReadyCallbacks.forEach(function (e) {
                          e();
                      }),
                      (this._onReadyCallbacks = []),
                      void (this._executeWhenReadyTimeoutId = -1))
                    : void (this._executeWhenReadyTimeoutId = setTimeout(function () {
                          e._checkIsReady();
                      }, 150));
            }),
            (t.prototype.beginAnimation = function (t, i, r, n, o, s, a) {
                if ((void 0 === o && (o = 1), this.stopAnimation(t), a || (a = new e.Animatable(this, t, i, r, n, o, s)), t.animations && a.appendAnimations(t, t.animations), t.getAnimatables))
                    for (var h = t.getAnimatables(), l = 0; l < h.length; l++) this.beginAnimation(h[l], i, r, n, o, s, a);
                return a;
            }),
            (t.prototype.beginDirectAnimation = function (t, i, r, n, o, s, a) {
                void 0 === s && (s = 1);
                var h = new e.Animatable(this, t, r, n, o, s, a, i);
                return h;
            }),
            (t.prototype.getAnimatableByTarget = function (e) {
                for (var t = 0; t < this._activeAnimatables.length; t++) if (this._activeAnimatables[t].target === e) return this._activeAnimatables[t];
                return null;
            }),
            (t.prototype.stopAnimation = function (e) {
                var t = this.getAnimatableByTarget(e);
                t && t.stop();
            }),
            (t.prototype._animate = function () {
                if (this.animationsEnabled) {
                    this._animationStartDate || (this._animationStartDate = e.Tools.Now);
                    for (var t = e.Tools.Now, i = t - this._animationStartDate, r = 0; r < this._activeAnimatables.length; r++) this._activeAnimatables[r]._animate(i);
                }
            }),
            (t.prototype.getViewMatrix = function () {
                return this._viewMatrix;
            }),
            (t.prototype.getProjectionMatrix = function () {
                return this._projectionMatrix;
            }),
            (t.prototype.getTransformMatrix = function () {
                return this._transformMatrix;
            }),
            (t.prototype.setTransformMatrix = function (e, t) {
                (this._viewMatrix = e), (this._projectionMatrix = t), this._viewMatrix.multiplyToRef(this._projectionMatrix, this._transformMatrix);
            }),
            (t.prototype.addMesh = function (e) {
                e.uniqueId = this._uniqueIdCounter++;
                var t = this.meshes.push(e);
                this.collisionCoordinator.onMeshAdded(e), this.onNewMeshAdded && this.onNewMeshAdded(e, t, this);
            }),
            (t.prototype.removeMesh = function (e) {
                var t = this.meshes.indexOf(e);
                return -1 !== t && this.meshes.splice(t, 1), this.collisionCoordinator.onMeshRemoved(e), this.onMeshRemoved && this.onMeshRemoved(e), t;
            }),
            (t.prototype.removeLight = function (e) {
                var t = this.lights.indexOf(e);
                return -1 !== t && this.lights.splice(t, 1), this.onLightRemoved && this.onLightRemoved(e), t;
            }),
            (t.prototype.removeCamera = function (e) {
                var t = this.cameras.indexOf(e);
                -1 !== t && this.cameras.splice(t, 1);
                var i = this.activeCameras.indexOf(e);
                return -1 !== i && this.activeCameras.splice(i, 1), this.activeCamera === e && (this.activeCamera = this.cameras.length > 0 ? this.cameras[0] : null), this.onCameraRemoved && this.onCameraRemoved(e), t;
            }),
            (t.prototype.addLight = function (e) {
                e.uniqueId = this._uniqueIdCounter++;
                var t = this.lights.push(e);
                this.onNewLightAdded && this.onNewLightAdded(e, t, this);
            }),
            (t.prototype.addCamera = function (e) {
                e.uniqueId = this._uniqueIdCounter++;
                var t = this.cameras.push(e);
                this.onNewCameraAdded && this.onNewCameraAdded(e, t, this);
            }),
            (t.prototype.setActiveCameraByID = function (e) {
                var t = this.getCameraByID(e);
                return t ? ((this.activeCamera = t), t) : null;
            }),
            (t.prototype.setActiveCameraByName = function (e) {
                var t = this.getCameraByName(e);
                return t ? ((this.activeCamera = t), t) : null;
            }),
            (t.prototype.getMaterialByID = function (e) {
                for (var t = 0; t < this.materials.length; t++) if (this.materials[t].id === e) return this.materials[t];
                return null;
            }),
            (t.prototype.getMaterialByName = function (e) {
                for (var t = 0; t < this.materials.length; t++) if (this.materials[t].name === e) return this.materials[t];
                return null;
            }),
            (t.prototype.getLensFlareSystemByName = function (e) {
                for (var t = 0; t < this.lensFlareSystems.length; t++) if (this.lensFlareSystems[t].name === e) return this.lensFlareSystems[t];
                return null;
            }),
            (t.prototype.getCameraByID = function (e) {
                for (var t = 0; t < this.cameras.length; t++) if (this.cameras[t].id === e) return this.cameras[t];
                return null;
            }),
            (t.prototype.getCameraByUniqueID = function (e) {
                for (var t = 0; t < this.cameras.length; t++) if (this.cameras[t].uniqueId === e) return this.cameras[t];
                return null;
            }),
            (t.prototype.getCameraByName = function (e) {
                for (var t = 0; t < this.cameras.length; t++) if (this.cameras[t].name === e) return this.cameras[t];
                return null;
            }),
            (t.prototype.getLightByName = function (e) {
                for (var t = 0; t < this.lights.length; t++) if (this.lights[t].name === e) return this.lights[t];
                return null;
            }),
            (t.prototype.getLightByID = function (e) {
                for (var t = 0; t < this.lights.length; t++) if (this.lights[t].id === e) return this.lights[t];
                return null;
            }),
            (t.prototype.getLightByUniqueID = function (e) {
                for (var t = 0; t < this.lights.length; t++) if (this.lights[t].uniqueId === e) return this.lights[t];
                return null;
            }),
            (t.prototype.getGeometryByID = function (e) {
                for (var t = 0; t < this._geometries.length; t++) if (this._geometries[t].id === e) return this._geometries[t];
                return null;
            }),
            (t.prototype.pushGeometry = function (e, t) {
                return !t && this.getGeometryByID(e.id) ? !1 : (this._geometries.push(e), this.collisionCoordinator.onGeometryAdded(e), this.onGeometryAdded && this.onGeometryAdded(e), !0);
            }),
            (t.prototype.removeGeometry = function (e) {
                var t = this._geometries.indexOf(e);
                return t > -1 ? (this._geometries.splice(t, 1), this.collisionCoordinator.onGeometryDeleted(e), this.onGeometryRemoved && this.onGeometryRemoved(e), !0) : !1;
            }),
            (t.prototype.getGeometries = function () {
                return this._geometries;
            }),
            (t.prototype.getMeshByID = function (e) {
                for (var t = 0; t < this.meshes.length; t++) if (this.meshes[t].id === e) return this.meshes[t];
                return null;
            }),
            (t.prototype.getMeshByUniqueID = function (e) {
                for (var t = 0; t < this.meshes.length; t++) if (this.meshes[t].uniqueId === e) return this.meshes[t];
                return null;
            }),
            (t.prototype.getLastMeshByID = function (e) {
                for (var t = this.meshes.length - 1; t >= 0; t--) if (this.meshes[t].id === e) return this.meshes[t];
                return null;
            }),
            (t.prototype.getLastEntryByID = function (e) {
                var t;
                for (t = this.meshes.length - 1; t >= 0; t--) if (this.meshes[t].id === e) return this.meshes[t];
                for (t = this.cameras.length - 1; t >= 0; t--) if (this.cameras[t].id === e) return this.cameras[t];
                for (t = this.lights.length - 1; t >= 0; t--) if (this.lights[t].id === e) return this.lights[t];
                return null;
            }),
            (t.prototype.getNodeByID = function (e) {
                var t = this.getMeshByID(e);
                if (t) return t;
                var i = this.getLightByID(e);
                return i ? i : this.getCameraByID(e);
            }),
            (t.prototype.getNodeByName = function (e) {
                var t = this.getMeshByName(e);
                if (t) return t;
                var i = this.getLightByName(e);
                return i ? i : this.getCameraByName(e);
            }),
            (t.prototype.getMeshByName = function (e) {
                for (var t = 0; t < this.meshes.length; t++) if (this.meshes[t].name === e) return this.meshes[t];
                return null;
            }),
            (t.prototype.getSoundByName = function (e) {
                var t;
                for (t = 0; t < this.mainSoundTrack.soundCollection.length; t++) if (this.mainSoundTrack.soundCollection[t].name === e) return this.mainSoundTrack.soundCollection[t];
                for (var i = 0; i < this.soundTracks.length; i++) for (t = 0; t < this.soundTracks[i].soundCollection.length; t++) if (this.soundTracks[i].soundCollection[t].name === e) return this.soundTracks[i].soundCollection[t];
                return null;
            }),
            (t.prototype.getLastSkeletonByID = function (e) {
                for (var t = this.skeletons.length - 1; t >= 0; t--) if (this.skeletons[t].id === e) return this.skeletons[t];
                return null;
            }),
            (t.prototype.getSkeletonById = function (e) {
                for (var t = 0; t < this.skeletons.length; t++) if (this.skeletons[t].id === e) return this.skeletons[t];
                return null;
            }),
            (t.prototype.getSkeletonByName = function (e) {
                for (var t = 0; t < this.skeletons.length; t++) if (this.skeletons[t].name === e) return this.skeletons[t];
                return null;
            }),
            (t.prototype.isActiveMesh = function (e) {
                return -1 !== this._activeMeshes.indexOf(e);
            }),
            (t.prototype._evaluateSubMesh = function (e, t) {
                if (t.alwaysSelectAsActiveMesh || 1 === t.subMeshes.length || e.isInFrustum(this._frustumPlanes)) {
                    var i = e.getMaterial();
                    t.showSubMeshesBoundingBox && this._boundingBoxRenderer.renderList.push(e.getBoundingInfo().boundingBox),
                        i &&
                            (i.getRenderTargetTextures && -1 === this._processedMaterials.indexOf(i) && (this._processedMaterials.push(i), this._renderTargets.concat(i.getRenderTargetTextures())),
                            (this._activeIndices += e.indexCount),
                            this._renderingManager.dispatch(e));
                }
            }),
            (t.prototype._evaluateActiveMeshes = function () {
                this.activeCamera._activeMeshes.reset(),
                    this._activeMeshes.reset(),
                    this._renderingManager.reset(),
                    this._processedMaterials.reset(),
                    this._activeParticleSystems.reset(),
                    this._activeSkeletons.reset(),
                    this._softwareSkinnedMeshes.reset(),
                    this._boundingBoxRenderer.reset(),
                    this._edgesRenderers.reset(),
                    this._frustumPlanes ? e.Frustum.GetPlanesToRef(this._transformMatrix, this._frustumPlanes) : (this._frustumPlanes = e.Frustum.GetPlanes(this._transformMatrix));
                var t, i;
                if (this._selectionOctree) {
                    var r = this._selectionOctree.select(this._frustumPlanes);
                    (t = r.data), (i = r.length);
                } else (i = this.meshes.length), (t = this.meshes);
                for (var n = 0; i > n; n++) {
                    var o = t[n];
                    if (!o.isBlocked && ((this._totalVertices += o.getTotalVertices()), o.isReady() && o.isEnabled())) {
                        o.computeWorldMatrix(),
                            o.actionManager && o.actionManager.hasSpecificTriggers([e.ActionManager.OnIntersectionEnterTrigger, e.ActionManager.OnIntersectionExitTrigger]) && this._meshesForIntersections.pushNoDuplicate(o);
                        var s = o.getLOD(this.activeCamera);
                        s &&
                            (o._preActivate(),
                            (o.alwaysSelectAsActiveMesh || (o.isVisible && o.visibility > 0 && 0 !== (o.layerMask & this.activeCamera.layerMask) && o.isInFrustum(this._frustumPlanes))) &&
                                (this._activeMeshes.push(o), this.activeCamera._activeMeshes.push(o), o._activate(this._renderId), this._activeMesh(s)));
                    }
                }
                var a = e.Tools.Now;
                if (this.particlesEnabled) {
                    e.Tools.StartPerformanceCounter("Particles", this.particleSystems.length > 0);
                    for (var h = 0; h < this.particleSystems.length; h++) {
                        var l = this.particleSystems[h];
                        l.isStarted() && (!l.emitter.position || (l.emitter && l.emitter.isEnabled())) && (this._activeParticleSystems.push(l), l.animate());
                    }
                    e.Tools.EndPerformanceCounter("Particles", this.particleSystems.length > 0);
                }
                this._particlesDuration += e.Tools.Now - a;
            }),
            (t.prototype._activeMesh = function (e) {
                if (
                    (e.skeleton && this.skeletonsEnabled && (this._activeSkeletons.pushNoDuplicate(e.skeleton), e.computeBonesUsingShaders || this._softwareSkinnedMeshes.pushNoDuplicate(e)),
                    (e.showBoundingBox || this.forceShowBoundingBoxes) && this._boundingBoxRenderer.renderList.push(e.getBoundingInfo().boundingBox),
                    e._edgesRenderer && this._edgesRenderers.push(e._edgesRenderer),
                    e && e.subMeshes)
                ) {
                    var t, i;
                    if (e._submeshesOctree && e.useOctreeForRenderingSelection) {
                        var r = e._submeshesOctree.select(this._frustumPlanes);
                        (t = r.length), (i = r.data);
                    } else (i = e.subMeshes), (t = i.length);
                    for (var n = 0; t > n; n++) {
                        var o = i[n];
                        this._evaluateSubMesh(o, e);
                    }
                }
            }),
            (t.prototype.updateTransformMatrix = function (e) {
                this.setTransformMatrix(this.activeCamera.getViewMatrix(), this.activeCamera.getProjectionMatrix(e));
            }),
            (t.prototype._renderForCamera = function (t) {
                var i = this._engine;
                if (((this.activeCamera = t), !this.activeCamera)) throw new Error("Active camera not set");
                e.Tools.StartPerformanceCounter("Rendering camera " + this.activeCamera.name),
                    i.setViewport(this.activeCamera.viewport),
                    this.resetCachedMaterial(),
                    this._renderId++,
                    this.updateTransformMatrix(),
                    this.beforeCameraRender && this.beforeCameraRender(this.activeCamera);
                var r = e.Tools.Now;
                e.Tools.StartPerformanceCounter("Active meshes evaluation"), this._evaluateActiveMeshes(), (this._evaluateActiveMeshesDuration += e.Tools.Now - r), e.Tools.EndPerformanceCounter("Active meshes evaluation");
                for (var n = 0; n < this._activeSkeletons.length; n++) {
                    var o = this._activeSkeletons.data[n];
                    o.prepare();
                }
                for (var s = 0; s < this._softwareSkinnedMeshes.length; s++) {
                    var a = this._softwareSkinnedMeshes.data[s];
                    a.applySkeleton(a.skeleton);
                }
                var h = e.Tools.Now;
                if (this.renderTargetsEnabled) {
                    e.Tools.StartPerformanceCounter("Render targets", this._renderTargets.length > 0);
                    for (var l = 0; l < this._renderTargets.length; l++) {
                        var c = this._renderTargets.data[l];
                        if (c._shouldRender()) {
                            this._renderId++;
                            var u = c.activeCamera && c.activeCamera !== this.activeCamera;
                            c.render(u, this.dumpNextRenderTargets);
                        }
                    }
                    e.Tools.EndPerformanceCounter("Render targets", this._renderTargets.length > 0), this._renderId++;
                }
                this._renderTargets.length > 0 && i.restoreDefaultFramebuffer(), (this._renderTargetsDuration += e.Tools.Now - h), this.postProcessManager._prepareFrame();
                var f,
                    d,
                    p = e.Tools.Now;
                if (this.layers.length) {
                    for (i.setDepthBuffer(!1), f = 0; f < this.layers.length; f++) (d = this.layers[f]), d.isBackground && d.render();
                    i.setDepthBuffer(!0);
                }
                e.Tools.StartPerformanceCounter("Main render"), this._renderingManager.render(null, null, !0, !0), e.Tools.EndPerformanceCounter("Main render"), this._boundingBoxRenderer.render();
                for (var m = 0; m < this._edgesRenderers.length; m++) this._edgesRenderers.data[m].render();
                if (this.lensFlaresEnabled) {
                    e.Tools.StartPerformanceCounter("Lens flares", this.lensFlareSystems.length > 0);
                    for (var g = 0; g < this.lensFlareSystems.length; g++) {
                        var _ = this.lensFlareSystems[g];
                        0 !== (t.layerMask & _.layerMask) && _.render();
                    }
                    e.Tools.EndPerformanceCounter("Lens flares", this.lensFlareSystems.length > 0);
                }
                if (this.layers.length) {
                    for (i.setDepthBuffer(!1), f = 0; f < this.layers.length; f++) (d = this.layers[f]), d.isBackground || d.render();
                    i.setDepthBuffer(!0);
                }
                (this._renderDuration += e.Tools.Now - p),
                    this.postProcessManager._finalizeFrame(t.isIntermediate),
                    this.activeCamera._updateFromScene(),
                    this._renderTargets.reset(),
                    this.afterCameraRender && this.afterCameraRender(this.activeCamera),
                    e.Tools.EndPerformanceCounter("Rendering camera " + this.activeCamera.name);
            }),
            (t.prototype._processSubCameras = function (t) {
                if (t.cameraRigMode === e.Camera.RIG_MODE_NONE) return void this._renderForCamera(t);
                for (var i = 0; i < t._rigCameras.length; i++) this._renderForCamera(t._rigCameras[i]);
                (this.activeCamera = t), this.setTransformMatrix(this.activeCamera.getViewMatrix(), this.activeCamera.getProjectionMatrix()), this.activeCamera._updateFromScene();
            }),
            (t.prototype._checkIntersections = function () {
                for (var t = 0; t < this._meshesForIntersections.length; t++)
                    for (var i = this._meshesForIntersections.data[t], r = 0; r < i.actionManager.actions.length; r++) {
                        var n = i.actionManager.actions[r];
                        if (n.trigger === e.ActionManager.OnIntersectionEnterTrigger || n.trigger === e.ActionManager.OnIntersectionExitTrigger) {
                            var o = n.getTriggerParameter(),
                                s = o instanceof e.AbstractMesh ? o : o.mesh,
                                a = s.intersectsMesh(i, o.usePreciseIntersection),
                                h = i._intersectionsInProgress.indexOf(s);
                            a && -1 === h
                                ? n.trigger === e.ActionManager.OnIntersectionEnterTrigger
                                    ? (n._executeCurrent(e.ActionEvent.CreateNew(i, null, s)), i._intersectionsInProgress.push(s))
                                    : n.trigger === e.ActionManager.OnIntersectionExitTrigger && i._intersectionsInProgress.push(s)
                                : !a &&
                                  h > -1 &&
                                  (n.trigger === e.ActionManager.OnIntersectionExitTrigger && n._executeCurrent(e.ActionEvent.CreateNew(i, null, s)),
                                  (i.actionManager.hasSpecificTrigger(e.ActionManager.OnIntersectionExitTrigger) && n.trigger !== e.ActionManager.OnIntersectionExitTrigger) || i._intersectionsInProgress.splice(h, 1));
                        }
                    }
            }),
            (t.prototype.render = function () {
                var i = e.Tools.Now;
                (this._particlesDuration = 0),
                    (this._spritesDuration = 0),
                    (this._activeParticles = 0),
                    (this._renderDuration = 0),
                    (this._renderTargetsDuration = 0),
                    (this._evaluateActiveMeshesDuration = 0),
                    (this._totalVertices = 0),
                    (this._activeIndices = 0),
                    (this._activeBones = 0),
                    this.getEngine().resetDrawCalls(),
                    this._meshesForIntersections.reset(),
                    this.resetCachedMaterial(),
                    e.Tools.StartPerformanceCounter("Scene rendering"),
                    this.actionManager && this.actionManager.processTrigger(e.ActionManager.OnEveryFrameTrigger, null),
                    this.simplificationQueue.running || this.simplificationQueue.executeNext();
                var r = Math.max(t.MinDeltaTime, Math.min(this._engine.getDeltaTime(), t.MaxDeltaTime));
                (this._animationRatio = 0.06 * r),
                    this._animate(),
                    this._physicsEngine && (e.Tools.StartPerformanceCounter("Physics"), this._physicsEngine._runOneStep(r / 1e3), e.Tools.EndPerformanceCounter("Physics")),
                    this.beforeRender && this.beforeRender();
                var n;
                for (n = 0; n < this._onBeforeRenderCallbacks.length; n++) this._onBeforeRenderCallbacks[n]();
                var o = e.Tools.Now,
                    s = this.getEngine(),
                    a = this.activeCamera;
                if (this.renderTargetsEnabled) {
                    e.Tools.StartPerformanceCounter("Custom render targets", this.customRenderTargets.length > 0);
                    for (var h = 0; h < this.customRenderTargets.length; h++) {
                        var l = this.customRenderTargets[h];
                        if (l._shouldRender()) {
                            if ((this._renderId++, (this.activeCamera = l.activeCamera || this.activeCamera), !this.activeCamera)) throw new Error("Active camera not set");
                            s.setViewport(this.activeCamera.viewport), this.updateTransformMatrix(), l.render(a !== this.activeCamera, this.dumpNextRenderTargets);
                        }
                    }
                    e.Tools.EndPerformanceCounter("Custom render targets", this.customRenderTargets.length > 0), this._renderId++;
                }
                if ((this.customRenderTargets.length > 0 && s.restoreDefaultFramebuffer(), (this._renderTargetsDuration += e.Tools.Now - o), (this.activeCamera = a), this.proceduralTexturesEnabled)) {
                    e.Tools.StartPerformanceCounter("Procedural textures", this._proceduralTextures.length > 0);
                    for (var c = 0; c < this._proceduralTextures.length; c++) {
                        var u = this._proceduralTextures[c];
                        u._shouldRender() && u.render();
                    }
                    e.Tools.EndPerformanceCounter("Procedural textures", this._proceduralTextures.length > 0);
                }
                if ((this._engine.clear(this.clearColor, this.autoClear || this.forceWireframe || this.forcePointsCloud, !0), this.shadowsEnabled))
                    for (var f = 0; f < this.lights.length; f++) {
                        var d = this.lights[f],
                            p = d.getShadowGenerator();
                        d.isEnabled() && p && -1 !== p.getShadowMap().getScene().textures.indexOf(p.getShadowMap()) && this._renderTargets.push(p.getShadowMap());
                    }
                if ((this._depthRenderer && this._renderTargets.push(this._depthRenderer.getDepthMap()), this.postProcessRenderPipelineManager.update(), this.activeCameras.length > 0))
                    for (var m = this._renderId, g = 0; g < this.activeCameras.length; g++) (this._renderId = m), this._processSubCameras(this.activeCameras[g]);
                else {
                    if (!this.activeCamera) throw new Error("No camera defined");
                    this._processSubCameras(this.activeCamera);
                }
                for (this._checkIntersections(), this._updateAudioParameters(), this.afterRender && this.afterRender(), n = 0; n < this._onAfterRenderCallbacks.length; n++) this._onAfterRenderCallbacks[n]();
                for (var _ = 0; _ < this._toBeDisposed.length; _++) this._toBeDisposed.data[_].dispose(), (this._toBeDisposed[_] = null);
                this._toBeDisposed.reset(), this.dumpNextRenderTargets && (this.dumpNextRenderTargets = !1), e.Tools.EndPerformanceCounter("Scene rendering"), (this._lastFrameDuration = e.Tools.Now - i);
            }),
            (t.prototype._updateAudioParameters = function () {
                if (this.audioEnabled && (0 !== this.mainSoundTrack.soundCollection.length || 0 !== this.soundTracks.length)) {
                    var t,
                        i = e.Engine.audioEngine;
                    if (((t = this.activeCameras.length > 0 ? this.activeCameras[0] : this.activeCamera), t && i.canUseWebAudio)) {
                        i.audioContext.listener.setPosition(t.position.x, t.position.y, t.position.z);
                        var r = e.Matrix.Invert(t.getViewMatrix()),
                            n = e.Vector3.TransformNormal(new e.Vector3(0, 0, -1), r);
                        n.normalize(), i.audioContext.listener.setOrientation(n.x, n.y, n.z, 0, 1, 0);
                        var o;
                        for (o = 0; o < this.mainSoundTrack.soundCollection.length; o++) {
                            var s = this.mainSoundTrack.soundCollection[o];
                            s.useCustomAttenuation && s.updateDistanceFromListener();
                        }
                        for (o = 0; o < this.soundTracks.length; o++)
                            for (var a = 0; a < this.soundTracks[o].soundCollection.length; a++) (s = this.soundTracks[o].soundCollection[a]), s.useCustomAttenuation && s.updateDistanceFromListener();
                    }
                }
            }),
            Object.defineProperty(t.prototype, "audioEnabled", {
                get: function () {
                    return this._audioEnabled;
                },
                set: function (e) {
                    (this._audioEnabled = e), this._audioEnabled ? this._enableAudio() : this._disableAudio();
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype._disableAudio = function () {
                var e;
                for (e = 0; e < this.mainSoundTrack.soundCollection.length; e++) this.mainSoundTrack.soundCollection[e].pause();
                for (e = 0; e < this.soundTracks.length; e++) for (var t = 0; t < this.soundTracks[e].soundCollection.length; t++) this.soundTracks[e].soundCollection[t].pause();
            }),
            (t.prototype._enableAudio = function () {
                var e;
                for (e = 0; e < this.mainSoundTrack.soundCollection.length; e++) this.mainSoundTrack.soundCollection[e].isPaused && this.mainSoundTrack.soundCollection[e].play();
                for (e = 0; e < this.soundTracks.length; e++) for (var t = 0; t < this.soundTracks[e].soundCollection.length; t++) this.soundTracks[e].soundCollection[t].isPaused && this.soundTracks[e].soundCollection[t].play();
            }),
            Object.defineProperty(t.prototype, "headphone", {
                get: function () {
                    return this._headphone;
                },
                set: function (e) {
                    (this._headphone = e), this._headphone ? this._switchAudioModeForHeadphones() : this._switchAudioModeForNormalSpeakers();
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype._switchAudioModeForHeadphones = function () {
                this.mainSoundTrack.switchPanningModelToHRTF();
                for (var e = 0; e < this.soundTracks.length; e++) this.soundTracks[e].switchPanningModelToHRTF();
            }),
            (t.prototype._switchAudioModeForNormalSpeakers = function () {
                this.mainSoundTrack.switchPanningModelToEqualPower();
                for (var e = 0; e < this.soundTracks.length; e++) this.soundTracks[e].switchPanningModelToEqualPower();
            }),
            (t.prototype.enableDepthRenderer = function () {
                return this._depthRenderer ? this._depthRenderer : ((this._depthRenderer = new e.DepthRenderer(this)), this._depthRenderer);
            }),
            (t.prototype.disableDepthRenderer = function () {
                this._depthRenderer && (this._depthRenderer.dispose(), (this._depthRenderer = null));
            }),
            (t.prototype.dispose = function () {
                (this.beforeRender = null),
                    (this.afterRender = null),
                    (this.skeletons = []),
                    this._boundingBoxRenderer.dispose(),
                    this._depthRenderer && this._depthRenderer.dispose(),
                    this.debugLayer.hide(),
                    this.onDispose && this.onDispose(),
                    (this._onBeforeRenderCallbacks = []),
                    (this._onAfterRenderCallbacks = []),
                    this.detachControl(),
                    this.disposeSounds();
                var e,
                    t = this._engine.getRenderingCanvas();
                for (e = 0; e < this.cameras.length; e++) this.cameras[e].detachControl(t);
                for (; this.lights.length; ) this.lights[0].dispose();
                for (; this.meshes.length; ) this.meshes[0].dispose(!0);
                for (; this.cameras.length; ) this.cameras[0].dispose();
                for (; this.materials.length; ) this.materials[0].dispose();
                for (; this.particleSystems.length; ) this.particleSystems[0].dispose();
                for (; this.spriteManagers.length; ) this.spriteManagers[0].dispose();
                for (; this.layers.length; ) this.layers[0].dispose();
                for (; this.textures.length; ) this.textures[0].dispose();
                this.postProcessManager.dispose(), this._physicsEngine && this.disablePhysicsEngine(), (e = this._engine.scenes.indexOf(this)), e > -1 && this._engine.scenes.splice(e, 1), this._engine.wipeCaches();
            }),
            (t.prototype.disposeSounds = function () {
                this.mainSoundTrack.dispose();
                for (var e = 0; e < this.soundTracks.length; e++) this.soundTracks[e].dispose();
            }),
            (t.prototype.getWorldExtends = function () {
                for (var t = new e.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE), i = new e.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE), r = 0; r < this.meshes.length; r++) {
                    var n = this.meshes[r];
                    n.computeWorldMatrix(!0);
                    var o = n.getBoundingInfo().boundingBox.minimumWorld,
                        s = n.getBoundingInfo().boundingBox.maximumWorld;
                    e.Tools.CheckExtends(o, t, i), e.Tools.CheckExtends(s, t, i);
                }
                return { min: t, max: i };
            }),
            (t.prototype.createOrUpdateSelectionOctree = function (t, i) {
                void 0 === t && (t = 64), void 0 === i && (i = 2), this._selectionOctree || (this._selectionOctree = new e.Octree(e.Octree.CreationFuncForMeshes, t, i));
                var r = this.getWorldExtends();
                return this._selectionOctree.update(r.min, r.max, this.meshes), this._selectionOctree;
            }),
            (t.prototype.createPickingRay = function (t, i, r, n) {
                var o = this._engine;
                if (!n) {
                    if (!this.activeCamera) throw new Error("Active camera not set");
                    n = this.activeCamera;
                }
                var s = n.viewport,
                    a = s.toGlobal(o);
                return (
                    (t = t / this._engine.getHardwareScalingLevel() - a.x),
                    (i = i / this._engine.getHardwareScalingLevel() - (this._engine.getRenderHeight() - a.y - a.height)),
                    e.Ray.CreateNew(t, i, a.width, a.height, r ? r : e.Matrix.Identity(), n.getViewMatrix(), n.getProjectionMatrix())
                );
            }),
            (t.prototype._internalPick = function (t, i, r) {
                for (var n = null, o = 0; o < this.meshes.length; o++) {
                    var s = this.meshes[o];
                    if (i) {
                        if (!i(s)) continue;
                    } else if (!s.isEnabled() || !s.isVisible || !s.isPickable) continue;
                    var a = s.getWorldMatrix(),
                        h = t(a),
                        l = s.intersects(h, r);
                    if (l && l.hit && (r || null == n || !(l.distance >= n.distance)) && ((n = l), r)) break;
                }
                return n || new e.PickingInfo();
            }),
            (t.prototype.pick = function (e, t, i, r, n) {
                var o = this;
                return this._internalPick(
                    function (i) {
                        return o.createPickingRay(e, t, i, n);
                    },
                    i,
                    r
                );
            }),
            (t.prototype.pickWithRay = function (t, i, r) {
                var n = this;
                return this._internalPick(
                    function (i) {
                        return n._pickWithRayInverseMatrix || (n._pickWithRayInverseMatrix = e.Matrix.Identity()), i.invertToRef(n._pickWithRayInverseMatrix), e.Ray.Transform(t, n._pickWithRayInverseMatrix);
                    },
                    i,
                    r
                );
            }),
            (t.prototype.setPointerOverMesh = function (t) {
                this._pointerOverMesh !== t &&
                    (this._pointerOverMesh && this._pointerOverMesh.actionManager && this._pointerOverMesh.actionManager.processTrigger(e.ActionManager.OnPointerOutTrigger, e.ActionEvent.CreateNew(this._pointerOverMesh)),
                    (this._pointerOverMesh = t),
                    this._pointerOverMesh && this._pointerOverMesh.actionManager && this._pointerOverMesh.actionManager.processTrigger(e.ActionManager.OnPointerOverTrigger, e.ActionEvent.CreateNew(this._pointerOverMesh)));
            }),
            (t.prototype.getPointerOverMesh = function () {
                return this._pointerOverMesh;
            }),
            (t.prototype.getPhysicsEngine = function () {
                return this._physicsEngine;
            }),
            (t.prototype.enablePhysics = function (t, i) {
                return this._physicsEngine ? !0 : ((this._physicsEngine = new e.PhysicsEngine(i)), this._physicsEngine.isSupported() ? (this._physicsEngine._initialize(t), !0) : ((this._physicsEngine = null), !1));
            }),
            (t.prototype.disablePhysicsEngine = function () {
                this._physicsEngine && (this._physicsEngine.dispose(), (this._physicsEngine = void 0));
            }),
            (t.prototype.isPhysicsEnabled = function () {
                return void 0 !== this._physicsEngine;
            }),
            (t.prototype.setGravity = function (e) {
                this._physicsEngine && this._physicsEngine._setGravity(e);
            }),
            (t.prototype.createCompoundImpostor = function (e, t) {
                if ((e.parts && ((t = e), (e = e.parts)), !this._physicsEngine)) return null;
                for (var i = 0; i < e.length; i++) {
                    var r = e[i].mesh;
                    (r._physicImpostor = e[i].impostor), (r._physicsMass = t.mass / e.length), (r._physicsFriction = t.friction), (r._physicRestitution = t.restitution);
                }
                return this._physicsEngine._registerMeshesAsCompound(e, t);
            }),
            (t.prototype.deleteCompoundImpostor = function (t) {
                for (var i = 0; i < t.parts.length; i++) {
                    var r = t.parts[i].mesh;
                    (r._physicImpostor = e.PhysicsEngine.NoImpostor), this._physicsEngine._unregisterMesh(r);
                }
            }),
            (t.prototype.createDefaultCameraOrLight = function () {
                if ((0 === this.lights.length && new e.HemisphericLight("default light", e.Vector3.Up(), this), !this.activeCamera)) {
                    var t = new e.FreeCamera("default camera", e.Vector3.Zero(), this),
                        i = this.getWorldExtends(),
                        r = i.min.add(i.max.subtract(i.min).scale(0.5));
                    (t.position = new e.Vector3(r.x, r.y, i.min.z - (i.max.z - i.min.z))), t.setTarget(r), (this.activeCamera = t);
                }
            }),
            (t.prototype._getByTags = function (t, i, r) {
                if (void 0 === i) return t;
                var n = [];
                r = r || function (e) {};
                for (var o in t) {
                    var s = t[o];
                    e.Tags.MatchesQuery(s, i) && (n.push(s), r(s));
                }
                return n;
            }),
            (t.prototype.getMeshesByTags = function (e, t) {
                return this._getByTags(this.meshes, e, t);
            }),
            (t.prototype.getCamerasByTags = function (e, t) {
                return this._getByTags(this.cameras, e, t);
            }),
            (t.prototype.getLightsByTags = function (e, t) {
                return this._getByTags(this.lights, e, t);
            }),
            (t.prototype.getMaterialByTags = function (e, t) {
                return this._getByTags(this.materials, e, t).concat(this._getByTags(this.multiMaterials, e, t));
            }),
            (t._FOGMODE_NONE = 0),
            (t._FOGMODE_EXP = 1),
            (t._FOGMODE_EXP2 = 2),
            (t._FOGMODE_LINEAR = 3),
            (t.MinDeltaTime = 1),
            (t.MaxDeltaTime = 1e3),
            t
        );
    })();
    e.Scene = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(i, r, n, o, s, a) {
            if (((this._engine = i instanceof e.Mesh ? i.getScene().getEngine() : i), (this._updatable = o), (this._data = r), s || this.create(), (this._kind = n), a)) return void (this._strideSize = a);
            switch (n) {
                case t.PositionKind:
                    this._strideSize = 3;
                    break;
                case t.NormalKind:
                    this._strideSize = 3;
                    break;
                case t.UVKind:
                case t.UV2Kind:
                case t.UV3Kind:
                case t.UV4Kind:
                case t.UV5Kind:
                case t.UV6Kind:
                    this._strideSize = 2;
                    break;
                case t.ColorKind:
                    this._strideSize = 4;
                    break;
                case t.MatricesIndicesKind:
                    this._strideSize = 4;
                    break;
                case t.MatricesWeightsKind:
                    this._strideSize = 4;
            }
        }
        return (
            (t.prototype.isUpdatable = function () {
                return this._updatable;
            }),
            (t.prototype.getData = function () {
                return this._data;
            }),
            (t.prototype.getBuffer = function () {
                return this._buffer;
            }),
            (t.prototype.getStrideSize = function () {
                return this._strideSize;
            }),
            (t.prototype.create = function (e) {
                (e || !this._buffer) &&
                    ((e = e || this._data),
                    this._buffer || (this._buffer = this._updatable ? this._engine.createDynamicVertexBuffer(4 * e.length) : this._engine.createVertexBuffer(e)),
                    this._updatable && (this._engine.updateDynamicVertexBuffer(this._buffer, e), (this._data = e)));
            }),
            (t.prototype.update = function (e) {
                this.create(e);
            }),
            (t.prototype.updateDirectly = function (e, t) {
                this._buffer && this._updatable && (this._engine.updateDynamicVertexBuffer(this._buffer, e, t), (this._data = null));
            }),
            (t.prototype.dispose = function () {
                this._buffer && this._engine._releaseBuffer(this._buffer) && (this._buffer = null);
            }),
            Object.defineProperty(t, "PositionKind", {
                get: function () {
                    return t._PositionKind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "NormalKind", {
                get: function () {
                    return t._NormalKind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "UVKind", {
                get: function () {
                    return t._UVKind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "UV2Kind", {
                get: function () {
                    return t._UV2Kind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "UV3Kind", {
                get: function () {
                    return t._UV3Kind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "UV4Kind", {
                get: function () {
                    return t._UV4Kind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "UV5Kind", {
                get: function () {
                    return t._UV5Kind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "UV6Kind", {
                get: function () {
                    return t._UV6Kind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ColorKind", {
                get: function () {
                    return t._ColorKind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "MatricesIndicesKind", {
                get: function () {
                    return t._MatricesIndicesKind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "MatricesWeightsKind", {
                get: function () {
                    return t._MatricesWeightsKind;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t._PositionKind = "position"),
            (t._NormalKind = "normal"),
            (t._UVKind = "uv"),
            (t._UV2Kind = "uv2"),
            (t._UV3Kind = "uv3"),
            (t._UV4Kind = "uv4"),
            (t._UV5Kind = "uv5"),
            (t._UV6Kind = "uv6"),
            (t._ColorKind = "color"),
            (t._MatricesIndicesKind = "matricesIndices"),
            (t._MatricesWeightsKind = "matricesWeights"),
            t
        );
    })();
    e.VertexBuffer = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(e, i) {
            t.call(this, e, i.getScene()),
                i.instances.push(this),
                (this._sourceMesh = i),
                this.position.copyFrom(i.position),
                this.rotation.copyFrom(i.rotation),
                this.scaling.copyFrom(i.scaling),
                i.rotationQuaternion && (this.rotationQuaternion = i.rotationQuaternion.clone()),
                (this.infiniteDistance = i.infiniteDistance),
                this.setPivotMatrix(i.getPivotMatrix()),
                this.refreshBoundingInfo(),
                this._syncSubMeshes();
        }
        return (
            __extends(i, t),
            Object.defineProperty(i.prototype, "receiveShadows", {
                get: function () {
                    return this._sourceMesh.receiveShadows;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "material", {
                get: function () {
                    return this._sourceMesh.material;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "visibility", {
                get: function () {
                    return this._sourceMesh.visibility;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "skeleton", {
                get: function () {
                    return this._sourceMesh.skeleton;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.getTotalVertices = function () {
                return this._sourceMesh.getTotalVertices();
            }),
            Object.defineProperty(i.prototype, "sourceMesh", {
                get: function () {
                    return this._sourceMesh;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.getVerticesData = function (e) {
                return this._sourceMesh.getVerticesData(e);
            }),
            (i.prototype.isVerticesDataPresent = function (e) {
                return this._sourceMesh.isVerticesDataPresent(e);
            }),
            (i.prototype.getIndices = function () {
                return this._sourceMesh.getIndices();
            }),
            Object.defineProperty(i.prototype, "_positions", {
                get: function () {
                    return this._sourceMesh._positions;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.refreshBoundingInfo = function () {
                var t = this._sourceMesh.getVerticesData(e.VertexBuffer.PositionKind);
                if (t) {
                    var i = e.Tools.ExtractMinAndMax(t, 0, this._sourceMesh.getTotalVertices());
                    this._boundingInfo = new e.BoundingInfo(i.minimum, i.maximum);
                }
                this._updateBoundingInfo();
            }),
            (i.prototype._preActivate = function () {
                this._currentLOD && this._currentLOD._preActivate();
            }),
            (i.prototype._activate = function (e) {
                this._currentLOD && this._currentLOD._registerInstanceForRenderId(this, e);
            }),
            (i.prototype.getLOD = function (e) {
                return (this._currentLOD = this.sourceMesh.getLOD(this.getScene().activeCamera, this.getBoundingInfo().boundingSphere)), this._currentLOD === this.sourceMesh ? this : this._currentLOD;
            }),
            (i.prototype._syncSubMeshes = function () {
                if ((this.releaseSubMeshes(), this._sourceMesh.subMeshes)) for (var e = 0; e < this._sourceMesh.subMeshes.length; e++) this._sourceMesh.subMeshes[e].clone(this, this._sourceMesh);
            }),
            (i.prototype._generatePointsArray = function () {
                return this._sourceMesh._generatePointsArray();
            }),
            (i.prototype.clone = function (t, i, r) {
                var n = this._sourceMesh.createInstance(t);
                if ((e.Tools.DeepCopy(this, n, ["name"], []), this.refreshBoundingInfo(), i && (n.parent = i), !r))
                    for (var o = 0; o < this.getScene().meshes.length; o++) {
                        var s = this.getScene().meshes[o];
                        s.parent === this && s.clone(s.name, n);
                    }
                return n.computeWorldMatrix(!0), n;
            }),
            (i.prototype.dispose = function (e) {
                var i = this._sourceMesh.instances.indexOf(this);
                this._sourceMesh.instances.splice(i, 1), t.prototype.dispose.call(this, e);
            }),
            i
        );
    })(e.AbstractMesh);
    e.InstancedMesh = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e() {
            (this.mustReturn = !1), (this.visibleInstances = new Array()), (this.renderSelf = new Array());
        }
        return e;
    })();
    e._InstancesBatch = t;
    var i = (function (i) {
        function r(n, o, s, a, h) {
            if (
                (void 0 === s && (s = null),
                i.call(this, n, o),
                (this.delayLoadState = e.Engine.DELAYLOADSTATE_NONE),
                (this.instances = new Array()),
                (this._LODLevels = new Array()),
                (this._onBeforeRenderCallbacks = new Array()),
                (this._onAfterRenderCallbacks = new Array()),
                (this._visibleInstances = {}),
                (this._renderIdForInstances = new Array()),
                (this._batchCache = new t()),
                (this._instancesBufferSize = 2048),
                (this._sideOrientation = r._DEFAULTSIDE),
                (this._areNormalsFrozen = !1),
                a)
            ) {
                a._geometry && a._geometry.applyToMesh(this), e.Tools.DeepCopy(a, this, ["name", "material", "skeleton", "instances"], []), (this.id = n + "." + a.id), (this.material = a.material);
                var l;
                if (!h)
                    for (l = 0; l < o.meshes.length; l++) {
                        var c = o.meshes[l];
                        if (c.parent === a) {
                            c.clone(n + "." + c.name, this, h);
                        }
                    }
                for (l = 0; l < o.particleSystems.length; l++) {
                    var u = o.particleSystems[l];
                    u.emitter === a && u.clone(u.name, this);
                }
                this.computeWorldMatrix(!0);
            }
            null !== s && (this.parent = s);
        }
        return (
            __extends(r, i),
            Object.defineProperty(r, "FRONTSIDE", {
                get: function () {
                    return r._FRONTSIDE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "BACKSIDE", {
                get: function () {
                    return r._BACKSIDE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "DOUBLESIDE", {
                get: function () {
                    return r._DOUBLESIDE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "DEFAULTSIDE", {
                get: function () {
                    return r._DEFAULTSIDE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "NO_CAP", {
                get: function () {
                    return r._NO_CAP;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "CAP_START", {
                get: function () {
                    return r._CAP_START;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "CAP_END", {
                get: function () {
                    return r._CAP_END;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r, "CAP_ALL", {
                get: function () {
                    return r._CAP_ALL;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r.prototype, "hasLODLevels", {
                get: function () {
                    return this._LODLevels.length > 0;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (r.prototype._sortLODLevels = function () {
                this._LODLevels.sort(function (e, t) {
                    return e.distance < t.distance ? 1 : e.distance > t.distance ? -1 : 0;
                });
            }),
            (r.prototype.addLODLevel = function (t, i) {
                if (i && i._masterMesh) return e.Tools.Warn("You cannot use a mesh as LOD level twice"), this;
                var r = new e.Internals.MeshLODLevel(t, i);
                return this._LODLevels.push(r), i && (i._masterMesh = this), this._sortLODLevels(), this;
            }),
            (r.prototype.getLODLevelAtDistance = function (e) {
                for (var t = 0; t < this._LODLevels.length; t++) {
                    var i = this._LODLevels[t];
                    if (i.distance === e) return i.mesh;
                }
                return null;
            }),
            (r.prototype.removeLODLevel = function (e) {
                for (var t = 0; t < this._LODLevels.length; t++) this._LODLevels[t].mesh === e && (this._LODLevels.splice(t, 1), e && (e._masterMesh = null));
                return this._sortLODLevels(), this;
            }),
            (r.prototype.getLOD = function (e, t) {
                if (!this._LODLevels || 0 === this._LODLevels.length) return this;
                var i = (t ? t : this.getBoundingInfo().boundingSphere).centerWorld.subtract(e.position).length();
                if (this._LODLevels[this._LODLevels.length - 1].distance > i) return this.onLODLevelSelection && this.onLODLevelSelection(i, this, this._LODLevels[this._LODLevels.length - 1].mesh), this;
                for (var r = 0; r < this._LODLevels.length; r++) {
                    var n = this._LODLevels[r];
                    if (n.distance < i) return n.mesh && (n.mesh._preActivate(), n.mesh._updateSubMeshesBoundingInfo(this.worldMatrixFromCache)), this.onLODLevelSelection && this.onLODLevelSelection(i, this, n.mesh), n.mesh;
                }
                return this.onLODLevelSelection && this.onLODLevelSelection(i, this, this), this;
            }),
            Object.defineProperty(r.prototype, "geometry", {
                get: function () {
                    return this._geometry;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (r.prototype.getTotalVertices = function () {
                return this._geometry ? this._geometry.getTotalVertices() : 0;
            }),
            (r.prototype.getVerticesData = function (e, t) {
                return this._geometry ? this._geometry.getVerticesData(e, t) : null;
            }),
            (r.prototype.getVertexBuffer = function (e) {
                return this._geometry ? this._geometry.getVertexBuffer(e) : void 0;
            }),
            (r.prototype.isVerticesDataPresent = function (e) {
                return this._geometry ? this._geometry.isVerticesDataPresent(e) : this._delayInfo ? -1 !== this._delayInfo.indexOf(e) : !1;
            }),
            (r.prototype.getVerticesDataKinds = function () {
                if (!this._geometry) {
                    var e = [];
                    if (this._delayInfo) for (var t in this._delayInfo) e.push(t);
                    return e;
                }
                return this._geometry.getVerticesDataKinds();
            }),
            (r.prototype.getTotalIndices = function () {
                return this._geometry ? this._geometry.getTotalIndices() : 0;
            }),
            (r.prototype.getIndices = function (e) {
                return this._geometry ? this._geometry.getIndices(e) : [];
            }),
            Object.defineProperty(r.prototype, "isBlocked", {
                get: function () {
                    return null !== this._masterMesh && void 0 !== this._masterMesh;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (r.prototype.isReady = function () {
                return this.delayLoadState === e.Engine.DELAYLOADSTATE_LOADING ? !1 : i.prototype.isReady.call(this);
            }),
            (r.prototype.isDisposed = function () {
                return this._isDisposed;
            }),
            Object.defineProperty(r.prototype, "sideOrientation", {
                get: function () {
                    return this._sideOrientation;
                },
                set: function (e) {
                    this._sideOrientation = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(r.prototype, "areNormalsFrozen", {
                get: function () {
                    return this._areNormalsFrozen;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (r.prototype.freezeNormals = function () {
                this._areNormalsFrozen = !0;
            }),
            (r.prototype.unfreezeNormals = function () {
                this._areNormalsFrozen = !1;
            }),
            (r.prototype._preActivate = function () {
                var e = this.getScene().getRenderId();
                this._preActivateId !== e && ((this._preActivateId = e), (this._visibleInstances = null));
            }),
            (r.prototype._registerInstanceForRenderId = function (e, t) {
                this._visibleInstances || ((this._visibleInstances = {}), (this._visibleInstances.defaultRenderId = t), (this._visibleInstances.selfDefaultRenderId = this._renderId)),
                    this._visibleInstances[t] || (this._visibleInstances[t] = new Array()),
                    this._visibleInstances[t].push(e);
            }),
            (r.prototype.refreshBoundingInfo = function () {
                var t = this.getVerticesData(e.VertexBuffer.PositionKind);
                if (t) {
                    var i = e.Tools.ExtractMinAndMax(t, 0, this.getTotalVertices());
                    this._boundingInfo = new e.BoundingInfo(i.minimum, i.maximum);
                }
                if (this.subMeshes) for (var r = 0; r < this.subMeshes.length; r++) this.subMeshes[r].refreshBoundingInfo();
                this._updateBoundingInfo();
            }),
            (r.prototype._createGlobalSubMesh = function () {
                var t = this.getTotalVertices();
                return t && this.getIndices() ? (this.releaseSubMeshes(), new e.SubMesh(0, 0, t, 0, this.getTotalIndices(), this)) : null;
            }),
            (r.prototype.subdivide = function (t) {
                if (!(1 > t)) {
                    for (var i = this.getTotalIndices(), r = (i / t) | 0, n = 0; r % 3 !== 0; ) r++;
                    this.releaseSubMeshes();
                    for (var o = 0; t > o && !(n >= i); o++) e.SubMesh.CreateFromIndices(0, n, Math.min(r, i - n), this), (n += r);
                    this.synchronizeInstances();
                }
            }),
            (r.prototype.setVerticesData = function (t, i, r, n) {
                if (t instanceof Array) {
                    var o = i;
                    (i = t), (t = o), e.Tools.Warn("Deprecated usage of setVerticesData detected (since v1.12). Current signature is setVerticesData(kind, data, updatable).");
                }
                if (this._geometry) this._geometry.setVerticesData(t, i, r, n);
                else {
                    var s = new e.VertexData();
                    s.set(i, t);
                    var a = this.getScene();
                    new e.Geometry(e.Geometry.RandomId(), a, s, r, this);
                }
            }),
            (r.prototype.updateVerticesData = function (e, t, i, r) {
                this._geometry && (r ? (this.makeGeometryUnique(), this.updateVerticesData(e, t, i, !1)) : this._geometry.updateVerticesData(e, t, i));
            }),
            (r.prototype.updateVerticesDataDirectly = function (e, t, i, r) {
                this._geometry && (r ? (this.makeGeometryUnique(), this.updateVerticesDataDirectly(e, t, i, !1)) : this._geometry.updateVerticesDataDirectly(e, t, i));
            }),
            (r.prototype.updateMeshPositions = function (t, i) {
                void 0 === i && (i = !0);
                var r = this.getVerticesData(e.VertexBuffer.PositionKind);
                if ((t(r), this.updateVerticesData(e.VertexBuffer.PositionKind, r, !1, !1), i)) {
                    var n = this.getIndices(),
                        o = this.getVerticesData(e.VertexBuffer.NormalKind);
                    e.VertexData.ComputeNormals(r, n, o), this.updateVerticesData(e.VertexBuffer.NormalKind, o, !1, !1);
                }
            }),
            (r.prototype.makeGeometryUnique = function () {
                if (this._geometry) {
                    var t = this._geometry.copy(e.Geometry.RandomId());
                    t.applyToMesh(this);
                }
            }),
            (r.prototype.setIndices = function (t, i) {
                if (this._geometry) this._geometry.setIndices(t, i);
                else {
                    var r = new e.VertexData();
                    r.indices = t;
                    var n = this.getScene();
                    new e.Geometry(e.Geometry.RandomId(), n, r, !1, this);
                }
            }),
            (r.prototype._bind = function (t, i, r) {
                var n,
                    o = this.getScene().getEngine();
                switch (r) {
                    case e.Material.PointFillMode:
                        n = null;
                        break;
                    case e.Material.WireFrameFillMode:
                        n = t.getLinesIndexBuffer(this.getIndices(), o);
                        break;
                    default:
                    case e.Material.TriangleFillMode:
                        n = this._geometry.getIndexBuffer();
                }
                o.bindMultiBuffers(this._geometry.getVertexBuffers(), n, i);
            }),
            (r.prototype._draw = function (t, i, r) {
                if (this._geometry && this._geometry.getVertexBuffers() && this._geometry.getIndexBuffer()) {
                    var n = this.getScene().getEngine();
                    switch (i) {
                        case e.Material.PointFillMode:
                            n.drawPointClouds(t.verticesStart, t.verticesCount, r);
                            break;
                        case e.Material.WireFrameFillMode:
                            n.draw(!1, 0, t.linesIndexCount, r);
                            break;
                        default:
                            n.draw(!0, t.indexStart, t.indexCount, r);
                    }
                }
            }),
            (r.prototype.registerBeforeRender = function (e) {
                this._onBeforeRenderCallbacks.push(e);
            }),
            (r.prototype.unregisterBeforeRender = function (e) {
                var t = this._onBeforeRenderCallbacks.indexOf(e);
                t > -1 && this._onBeforeRenderCallbacks.splice(t, 1);
            }),
            (r.prototype.registerAfterRender = function (e) {
                this._onAfterRenderCallbacks.push(e);
            }),
            (r.prototype.unregisterAfterRender = function (e) {
                var t = this._onAfterRenderCallbacks.indexOf(e);
                t > -1 && this._onAfterRenderCallbacks.splice(t, 1);
            }),
            (r.prototype._getInstancesRenderList = function (e) {
                var t = this.getScene();
                if (((this._batchCache.mustReturn = !1), (this._batchCache.renderSelf[e] = this.isEnabled() && this.isVisible), (this._batchCache.visibleInstances[e] = null), this._visibleInstances)) {
                    var i = t.getRenderId();
                    this._batchCache.visibleInstances[e] = this._visibleInstances[i];
                    var r = this._renderId;
                    if (
                        (!this._batchCache.visibleInstances[e] &&
                            this._visibleInstances.defaultRenderId &&
                            ((this._batchCache.visibleInstances[e] = this._visibleInstances[this._visibleInstances.defaultRenderId]),
                            (i = Math.max(this._visibleInstances.defaultRenderId, i)),
                            (r = Math.max(this._visibleInstances.selfDefaultRenderId, i))),
                        this._batchCache.visibleInstances[e] && this._batchCache.visibleInstances[e].length)
                    ) {
                        if (this._renderIdForInstances[e] === i) return (this._batchCache.mustReturn = !0), this._batchCache;
                        i !== r && (this._batchCache.renderSelf[e] = !1);
                    }
                    this._renderIdForInstances[e] = i;
                }
                return this._batchCache;
            }),
            (r.prototype._renderWithInstances = function (e, t, i, r, n) {
                for (var o = i.visibleInstances[e._id], s = o.length + 1, a = 16 * s * 4; this._instancesBufferSize < a; ) this._instancesBufferSize *= 2;
                (!this._worldMatricesInstancesBuffer || this._worldMatricesInstancesBuffer.capacity < this._instancesBufferSize) &&
                    (this._worldMatricesInstancesBuffer && n.deleteInstancesBuffer(this._worldMatricesInstancesBuffer),
                    (this._worldMatricesInstancesBuffer = n.createInstancesBuffer(this._instancesBufferSize)),
                    (this._worldMatricesInstancesArray = new Float32Array(this._instancesBufferSize / 4)));
                var h = 0,
                    l = 0,
                    c = this.getWorldMatrix();
                if ((i.renderSelf[e._id] && (c.copyToArray(this._worldMatricesInstancesArray, h), (h += 16), l++), o))
                    for (var u = 0; u < o.length; u++) {
                        var f = o[u];
                        f.getWorldMatrix().copyToArray(this._worldMatricesInstancesArray, h), (h += 16), l++;
                    }
                var d = r.getAttributeLocationByName("world0"),
                    p = r.getAttributeLocationByName("world1"),
                    m = r.getAttributeLocationByName("world2"),
                    g = r.getAttributeLocationByName("world3"),
                    _ = [d, p, m, g];
                n.updateAndBindInstancesBuffer(this._worldMatricesInstancesBuffer, this._worldMatricesInstancesArray, _), this._draw(e, t, l), n.unBindInstancesBuffer(this._worldMatricesInstancesBuffer, _);
            }),
            (r.prototype._processRendering = function (e, t, i, r, n, o) {
                var s = this.getScene(),
                    a = s.getEngine();
                if (n) this._renderWithInstances(e, i, r, t, a);
                else if ((r.renderSelf[e._id] && (o && o(!1, this.getWorldMatrix()), this._draw(e, i)), r.visibleInstances[e._id]))
                    for (var h = 0; h < r.visibleInstances[e._id].length; h++) {
                        var l = r.visibleInstances[e._id][h],
                            c = l.getWorldMatrix();
                        o && o(!0, c), this._draw(e, i);
                    }
            }),
            (r.prototype.render = function (t, i) {
                var r = this.getScene(),
                    n = this._getInstancesRenderList(t._id);
                if (!n.mustReturn && this._geometry && this._geometry.getVertexBuffers() && this._geometry.getIndexBuffer()) {
                    var o;
                    for (o = 0; o < this._onBeforeRenderCallbacks.length; o++) this._onBeforeRenderCallbacks[o](this);
                    var s = r.getEngine(),
                        a = null !== s.getCaps().instancedArrays && null !== n.visibleInstances[t._id] && void 0 !== n.visibleInstances[t._id],
                        h = t.getMaterial();
                    if (h && h.isReady(this, a)) {
                        var l = s.getDepthWrite();
                        this.renderOutline && (s.setDepthWrite(!1), r.getOutlineRenderer().render(t, n), s.setDepthWrite(l)), h._preBind();
                        var c = h.getEffect(),
                            u = r.forcePointsCloud ? e.Material.PointFillMode : r.forceWireframe ? e.Material.WireFrameFillMode : h.fillMode;
                        this._bind(t, c, u);
                        var f = this.getWorldMatrix();
                        if (
                            (h.bind(f, this),
                            i && s.setAlphaMode(h.alphaMode),
                            this._processRendering(t, c, u, n, a, function (e, t) {
                                e && h.bindOnlyWorldMatrix(t);
                            }),
                            h.unbind(),
                            this.renderOutline && l && (s.setDepthWrite(!0), s.setColorWrite(!1), r.getOutlineRenderer().render(t, n), s.setColorWrite(!0)),
                            this.renderOverlay)
                        ) {
                            var d = s.getAlphaMode();
                            s.setAlphaMode(e.Engine.ALPHA_COMBINE), r.getOutlineRenderer().render(t, n, !0), s.setAlphaMode(d);
                        }
                        for (o = 0; o < this._onAfterRenderCallbacks.length; o++) this._onAfterRenderCallbacks[o](this);
                    }
                }
            }),
            (r.prototype.getEmittedParticleSystems = function () {
                for (var e = new Array(), t = 0; t < this.getScene().particleSystems.length; t++) {
                    var i = this.getScene().particleSystems[t];
                    i.emitter === this && e.push(i);
                }
                return e;
            }),
            (r.prototype.getHierarchyEmittedParticleSystems = function () {
                var e = new Array(),
                    t = this.getDescendants();
                t.push(this);
                for (var i = 0; i < this.getScene().particleSystems.length; i++) {
                    var r = this.getScene().particleSystems[i];
                    -1 !== t.indexOf(r.emitter) && e.push(r);
                }
                return e;
            }),
            (r.prototype.getChildren = function () {
                for (var e = [], t = 0; t < this.getScene().meshes.length; t++) {
                    var i = this.getScene().meshes[t];
                    i.parent === this && e.push(i);
                }
                return e;
            }),
            (r.prototype._checkDelayState = function () {
                var t = this,
                    i = this,
                    r = this.getScene();
                if (this._geometry) this._geometry.load(r);
                else if (i.delayLoadState === e.Engine.DELAYLOADSTATE_NOTLOADED) {
                    (i.delayLoadState = e.Engine.DELAYLOADSTATE_LOADING), r._addPendingData(i);
                    var n = -1 !== this.delayLoadingFile.indexOf(".babylonbinarymeshdata");
                    e.Tools.LoadFile(
                        this.delayLoadingFile,
                        function (i) {
                            i instanceof ArrayBuffer ? t._delayLoadingFunction(i, t) : t._delayLoadingFunction(JSON.parse(i), t), (t.delayLoadState = e.Engine.DELAYLOADSTATE_LOADED), r._removePendingData(t);
                        },
                        function () {},
                        r.database,
                        n
                    );
                }
            }),
            (r.prototype.isInFrustum = function (t) {
                return this.delayLoadState === e.Engine.DELAYLOADSTATE_LOADING ? !1 : i.prototype.isInFrustum.call(this, t) ? (this._checkDelayState(), !0) : !1;
            }),
            (r.prototype.setMaterialByID = function (e) {
                var t,
                    i = this.getScene().materials;
                for (t = 0; t < i.length; t++) if (i[t].id === e) return void (this.material = i[t]);
                var r = this.getScene().multiMaterials;

                for (t = 0; t < r.length; t++) if (r[t].id === e) return void (this.material = r[t]);
            }),
            (r.prototype.getAnimatables = function () {
                var e = [];
                return this.material && e.push(this.material), this.skeleton && e.push(this.skeleton), e;
            }),
            (r.prototype.bakeTransformIntoVertices = function (t) {
                if (this.isVerticesDataPresent(e.VertexBuffer.PositionKind)) {
                    this._resetPointsArrayCache();
                    var i,
                        r = this.getVerticesData(e.VertexBuffer.PositionKind),
                        n = [];
                    for (i = 0; i < r.length; i += 3) e.Vector3.TransformCoordinates(e.Vector3.FromArray(r, i), t).toArray(n, i);
                    if ((this.setVerticesData(e.VertexBuffer.PositionKind, n, this.getVertexBuffer(e.VertexBuffer.PositionKind).isUpdatable()), this.isVerticesDataPresent(e.VertexBuffer.NormalKind))) {
                        for (r = this.getVerticesData(e.VertexBuffer.NormalKind), n = [], i = 0; i < r.length; i += 3) e.Vector3.TransformNormal(e.Vector3.FromArray(r, i), t).normalize().toArray(n, i);
                        this.setVerticesData(e.VertexBuffer.NormalKind, n, this.getVertexBuffer(e.VertexBuffer.NormalKind).isUpdatable()), t.m[0] * t.m[5] * t.m[10] < 0 && this.flipFaces();
                    }
                }
            }),
            (r.prototype.bakeCurrentTransformIntoVertices = function () {
                this.bakeTransformIntoVertices(this.computeWorldMatrix(!0)),
                    this.scaling.copyFromFloats(1, 1, 1),
                    this.position.copyFromFloats(0, 0, 0),
                    this.rotation.copyFromFloats(0, 0, 0),
                    this.rotationQuaternion && (this.rotationQuaternion = e.Quaternion.Identity()),
                    (this._worldMatrix = e.Matrix.Identity());
            }),
            (r.prototype._resetPointsArrayCache = function () {
                this._positions = null;
            }),
            (r.prototype._generatePointsArray = function () {
                if (this._positions) return !0;
                this._positions = [];
                var t = this.getVerticesData(e.VertexBuffer.PositionKind);
                if (!t) return !1;
                for (var i = 0; i < t.length; i += 3) this._positions.push(e.Vector3.FromArray(t, i));
                return !0;
            }),
            (r.prototype.clone = function (e, t, i) {
                return new r(e, this.getScene(), t, this, i);
            }),
            (r.prototype.dispose = function (e) {
                for (
                    this._geometry && this._geometry.releaseForMesh(this, !0), this._worldMatricesInstancesBuffer && (this.getEngine().deleteInstancesBuffer(this._worldMatricesInstancesBuffer), (this._worldMatricesInstancesBuffer = null));
                    this.instances.length;

                )
                    this.instances[0].dispose();
                i.prototype.dispose.call(this, e);
            }),
            (r.prototype.applyDisplacementMap = function (t, i, r, n) {
                var o = this,
                    s = this.getScene(),
                    a = function (e) {
                        var t = document.createElement("canvas"),
                            s = t.getContext("2d"),
                            a = e.width,
                            h = e.height;
                        (t.width = a), (t.height = h), s.drawImage(e, 0, 0);
                        var l = s.getImageData(0, 0, a, h).data;
                        o.applyDisplacementMapFromBuffer(l, a, h, i, r), n && n(o);
                    };
                e.Tools.LoadImage(t, a, function () {}, s.database);
            }),
            (r.prototype.applyDisplacementMapFromBuffer = function (t, i, r, n, o) {
                if (!this.isVerticesDataPresent(e.VertexBuffer.PositionKind) || !this.isVerticesDataPresent(e.VertexBuffer.NormalKind) || !this.isVerticesDataPresent(e.VertexBuffer.UVKind))
                    return void e.Tools.Warn("Cannot call applyDisplacementMap: Given mesh is not complete. Position, Normal or UV are missing");
                for (
                    var s = this.getVerticesData(e.VertexBuffer.PositionKind),
                        a = this.getVerticesData(e.VertexBuffer.NormalKind),
                        h = this.getVerticesData(e.VertexBuffer.UVKind),
                        l = e.Vector3.Zero(),
                        c = e.Vector3.Zero(),
                        u = e.Vector2.Zero(),
                        f = 0;
                    f < s.length;
                    f += 3
                ) {
                    e.Vector3.FromArrayToRef(s, f, l), e.Vector3.FromArrayToRef(a, f, c), e.Vector2.FromArrayToRef(h, (f / 3) * 2, u);
                    var d = (Math.abs(u.x) * i) % i | 0,
                        p = (Math.abs(u.y) * r) % r | 0,
                        m = 4 * (d + p * i),
                        g = t[m] / 255,
                        _ = t[m + 1] / 255,
                        v = t[m + 2] / 255,
                        y = 0.3 * g + 0.59 * _ + 0.11 * v;
                    c.normalize(), c.scaleInPlace(n + (o - n) * y), (l = l.add(c)), l.toArray(s, f);
                }
                e.VertexData.ComputeNormals(s, this.getIndices(), a), this.updateVerticesData(e.VertexBuffer.PositionKind, s), this.updateVerticesData(e.VertexBuffer.NormalKind, a);
            }),
            (r.prototype.convertToFlatShadedMesh = function () {
                var t,
                    i,
                    r = this.getVerticesDataKinds(),
                    n = [],
                    o = [],
                    s = [],
                    a = !1;
                for (t = 0; t < r.length; t++) {
                    i = r[t];
                    var h = this.getVertexBuffer(i);
                    i !== e.VertexBuffer.NormalKind ? ((n[i] = h), (o[i] = n[i].getData()), (s[i] = [])) : ((a = h.isUpdatable()), r.splice(t, 1), t--);
                }
                var l,
                    c = this.subMeshes.slice(0),
                    u = this.getIndices(),
                    f = this.getTotalIndices();
                for (l = 0; f > l; l++) {
                    var d = u[l];
                    for (t = 0; t < r.length; t++) {
                        i = r[t];
                        for (var p = n[i].getStrideSize(), m = 0; p > m; m++) s[i].push(o[i][d * p + m]);
                    }
                }
                var g = [],
                    _ = s[e.VertexBuffer.PositionKind];
                for (l = 0; f > l; l += 3) {
                    (u[l] = l), (u[l + 1] = l + 1), (u[l + 2] = l + 2);
                    for (
                        var v = e.Vector3.FromArray(_, 3 * l), y = e.Vector3.FromArray(_, 3 * (l + 1)), x = e.Vector3.FromArray(_, 3 * (l + 2)), M = v.subtract(y), S = x.subtract(y), b = e.Vector3.Normalize(e.Vector3.Cross(M, S)), A = 0;
                        3 > A;
                        A++
                    )
                        g.push(b.x), g.push(b.y), g.push(b.z);
                }
                for (this.setIndices(u), this.setVerticesData(e.VertexBuffer.NormalKind, g, a), t = 0; t < r.length; t++) (i = r[t]), this.setVerticesData(i, s[i], n[i].isUpdatable());
                this.releaseSubMeshes();
                for (var T = 0; T < c.length; T++) {
                    var E = c[T];
                    new e.SubMesh(E.materialIndex, E.indexStart, E.indexCount, E.indexStart, E.indexCount, this);
                }
                this.synchronizeInstances();
            }),
            (r.prototype.flipFaces = function (t) {
                void 0 === t && (t = !1);
                var i,
                    r = e.VertexData.ExtractFromMesh(this);
                if (t && this.isVerticesDataPresent(e.VertexBuffer.NormalKind)) for (i = 0; i < r.normals.length; i++) r.normals[i] *= -1;
                var n;
                for (i = 0; i < r.indices.length; i += 3) (n = r.indices[i + 1]), (r.indices[i + 1] = r.indices[i + 2]), (r.indices[i + 2] = n);
                r.applyToMesh(this);
            }),
            (r.prototype.createInstance = function (t) {
                return new e.InstancedMesh(t, this);
            }),
            (r.prototype.synchronizeInstances = function () {
                for (var e = 0; e < this.instances.length; e++) {
                    var t = this.instances[e];
                    t._syncSubMeshes();
                }
            }),
            (r.prototype.simplify = function (t, i, r, n) {
                void 0 === i && (i = !0), void 0 === r && (r = e.SimplificationType.QUADRATIC), this.getScene().simplificationQueue.addTask({ settings: t, parallelProcessing: i, mesh: this, simplificationType: r, successCallback: n });
            }),
            (r.prototype.optimizeIndices = function (t) {
                for (var i = this, r = this.getIndices(), n = this.getVerticesData(e.VertexBuffer.PositionKind), o = [], s = 0; s < n.length; s += 3) o.push(e.Vector3.FromArray(n, s));
                var a = [];
                e.AsyncLoop.SyncAsyncForLoop(
                    o.length,
                    40,
                    function (e) {
                        for (var t = o.length - 1 - e, i = o[t], r = 0; t > r; ++r) {
                            var n = o[r];
                            if (i.equals(n)) {
                                a[t] = r;
                                break;
                            }
                        }
                    },
                    function () {
                        for (var e = 0; e < r.length; ++e) r[e] = a[r[e]] || r[e];
                        var n = i.subMeshes.slice(0);
                        i.setIndices(r), (i.subMeshes = n), t && t(i);
                    }
                );
            }),
            (r.CreateRibbon = function (t, i, n, o, s, a, h, l, c) {
                void 0 === l && (l = r.DEFAULTSIDE), void 0 === c && (c = null);
                var u;
                if (n instanceof e.Scene) {
                    if (((a = n), (h = i.updatable), i.instance)) {
                        (u = i.pathArray), (c = i.instance), (o = i.closePath);
                        {
                            i.closeArray;
                        }
                    }
                } else (u = i), (i = { pathArray: u, closeArray: n, closePath: o, offset: s, sideOrientation: l });
                if (c) {
                    var f = function (e) {
                            for (var t = u[0].length, i = 0, n = c.sideOrientation === r.DOUBLESIDE ? 2 : 1, o = 1; n >= o; o++)
                                for (var s = 0; s < u.length; s++) {
                                    var a = u[s],
                                        h = a.length;
                                    t = h > t ? t : h;
                                    for (var l = 0; t > l; ) (e[i] = a[l].x), (e[i + 1] = a[l].y), (e[i + 2] = a[l].z), l++, (i += 3);
                                    c._closePath && ((e[i] = a[0].x), (e[i + 1] = a[0].y), (e[i + 2] = a[0].z), (i += 3));
                                }
                        },
                        d = c.getVerticesData(e.VertexBuffer.PositionKind);
                    if ((f(d), c.updateVerticesData(e.VertexBuffer.PositionKind, d, !1, !1), !c.areNormalsFrozen)) {
                        var p = c.getIndices(),
                            m = c.getVerticesData(e.VertexBuffer.NormalKind);
                        if ((e.VertexData.ComputeNormals(d, p, m), c._closePath))
                            for (var g = 0, _ = 0, v = 0; v < u.length; v++)
                                (g = 3 * c._idx[v]),
                                    (_ = v + 1 < u.length ? 3 * (c._idx[v + 1] - 1) : m.length - 3),
                                    (m[g] = 0.5 * (m[g] + m[_])),
                                    (m[g + 1] = 0.5 * (m[g + 1] + m[_ + 1])),
                                    (m[g + 2] = 0.5 * (m[g + 2] + m[_ + 2])),
                                    (m[_] = m[g]),
                                    (m[_ + 1] = m[g + 1]),
                                    (m[_ + 2] = m[g + 2]);
                        c.updateVerticesData(e.VertexBuffer.NormalKind, m, !1, !1);
                    }
                    return c;
                }
                var y = new r(t, a);
                y.sideOrientation = l;
                var x = e.VertexData.CreateRibbon(i);
                return o && (y._idx = x._idx), (y._closePath = o), x.applyToMesh(y, h), y;
            }),
            (r.CreateDisc = function (t, i, n, o, s, a) {
                void 0 === a && (a = r.DEFAULTSIDE);
                var h = new r(t, o),
                    l = e.VertexData.CreateDisc(i, n, a);
                return l.applyToMesh(h, s), h;
            }),
            (r.CreateBox = function (t, i, n, o, s) {
                if ((void 0 === s && (s = r.DEFAULTSIDE), (o = o || i.updatable), "number" == typeof i)) {
                    var a = i;
                    i = { size: a, sideOrientation: s };
                }
                var h = new r(t, n),
                    l = e.VertexData.CreateBox(i);
                return l.applyToMesh(h, o), h;
            }),
            (r.CreateSphere = function (t, i, n, o, s, a) {
                if ((void 0 === a && (a = r.DEFAULTSIDE), n instanceof e.Scene)) (o = n), (s = i.updatable);
                else {
                    var h = i;
                    i = { segments: h, diameterX: n, diameterY: n, diameterZ: n, sideOrientation: a };
                }
                var l = new r(t, o),
                    c = e.VertexData.CreateSphere(i);
                return c.applyToMesh(l, s), l;
            }),
            (r.CreateCylinder = function (t, i, n, o, s, a, h, l, c) {
                if ((void 0 === c && (c = r.DEFAULTSIDE), n instanceof e.Scene)) (h = n), (l = i.updatable);
                else {
                    (void 0 !== h && h instanceof e.Scene) || (void 0 !== h && ((c = l || r.DEFAULTSIDE), (l = h)), (h = a), (a = 1));
                    var u = i;
                    i = { height: u, diameterTop: n, diameterBottom: o, tessellation: s, subdivisions: a, sideOrientation: c };
                }
                var f = new r(t, h),
                    d = e.VertexData.CreateCylinder(i);
                return d.applyToMesh(f, l), f;
            }),
            (r.CreateTorus = function (t, i, n, o, s, a, h) {
                if (n instanceof e.Scene) (s = n), (a = i.updatable);
                else {
                    var l = i;
                    i = { diameter: l, thickness: n, tessellation: o, sideOrientation: h };
                }
                var c = new r(t, s),
                    u = e.VertexData.CreateTorus(i);
                return u.applyToMesh(c, a), c;
            }),
            (r.CreateTorusKnot = function (t, i, n, o, s, a, h, l, c, u) {
                if (n instanceof e.Scene) (l = n), (c = i.updatable);
                else {
                    var f = i;
                    i = { radius: f, tube: n, radialSegments: o, tubularSegments: s, p: a, q: h, sideOrientation: u };
                }
                var d = new r(t, l),
                    p = e.VertexData.CreateTorusKnot(i);
                return p.applyToMesh(d, c), d;
            }),
            (r.CreateLines = function (t, i, r, n, o) {
                if ((void 0 === o && (o = null), o)) {
                    var s = function (e) {
                        for (var t = 0, r = 0; r < i.length; r++) (e[t] = i[r].x), (e[t + 1] = i[r].y), (e[t + 2] = i[r].z), (t += 3);
                    };
                    return o.updateMeshPositions(s, !1), o;
                }
                var a = new e.LinesMesh(t, r),
                    h = e.VertexData.CreateLines(i);
                return h.applyToMesh(a, n), a;
            }),
            (r.CreateDashedLines = function (t, i, r, n, o, s, a, h) {
                if ((void 0 === h && (h = null), h)) {
                    var l = function (t) {
                        var r = e.Vector3.Zero(),
                            n = t.length / 6,
                            o = 0,
                            s = 0,
                            a = 0,
                            l = 0,
                            c = 0,
                            u = 0,
                            f = 0,
                            d = 0;
                        for (f = 0; f < i.length - 1; f++) i[f + 1].subtractToRef(i[f], r), (o += r.length());
                        for (a = o / n, l = (h.dashSize * a) / (h.dashSize + h.gapSize), f = 0; f < i.length - 1; f++)
                            for (i[f + 1].subtractToRef(i[f], r), s = Math.floor(r.length() / a), r.normalize(), d = 0; s > d && u < t.length; )
                                (c = a * d),
                                    (t[u] = i[f].x + c * r.x),
                                    (t[u + 1] = i[f].y + c * r.y),
                                    (t[u + 2] = i[f].z + c * r.z),
                                    (t[u + 3] = i[f].x + (c + l) * r.x),
                                    (t[u + 4] = i[f].y + (c + l) * r.y),
                                    (t[u + 5] = i[f].z + (c + l) * r.z),
                                    (u += 6),
                                    d++;
                        for (; u < t.length; ) (t[u] = i[f].x), (t[u + 1] = i[f].y), (t[u + 2] = i[f].z), (u += 3);
                    };
                    return h.updateMeshPositions(l, !1), h;
                }
                var c = new e.LinesMesh(t, s),
                    u = e.VertexData.CreateDashedLines(i, r, n, o);
                return u.applyToMesh(c, a), (c.dashSize = r), (c.gapSize = n), c;
            }),
            (r.ExtrudeShape = function (e, t, i, n, o, s, a, h, l, c) {
                void 0 === l && (l = r.DEFAULTSIDE), void 0 === c && (c = null), (n = n || 1), (o = o || 0);
                var u = r._ExtrudeShapeGeneric(e, t, i, n, o, null, null, !1, !1, s, !1, a, h, l, c);
                return u;
            }),
            (r.ExtrudeShapeCustom = function (e, t, i, n, o, s, a, h, l, c, u, f) {
                void 0 === u && (u = r.DEFAULTSIDE), void 0 === f && (f = null);
                var d = r._ExtrudeShapeGeneric(e, t, i, null, null, n, o, s, a, h, !0, l, c, u, f);
                return d;
            }),
            (r._ExtrudeShapeGeneric = function (t, i, n, o, s, a, h, l, c, u, f, d, p, m, g) {
                var _,
                    v,
                    y = function (t, i, n, o, s, a, h, l, c, u) {
                        for (
                            var f = n.getTangents(),
                                d = n.getNormals(),
                                p = n.getBinormals(),
                                m = n.getDistances(),
                                g = 0,
                                _ = function (e, t) {
                                    return s;
                                },
                                v = function (e, t) {
                                    return a;
                                },
                                y = u ? l : v,
                                x = u ? h : _,
                                M = 0,
                                S = 0;
                            S < i.length;
                            S++
                        ) {
                            for (var b = new Array(), A = y(S, m[S]), T = x(S, m[S]), E = 0; E < t.length; E++) {
                                var P = e.Matrix.RotationAxis(f[S], g),
                                    D = f[S].scale(t[E].z).add(d[S].scale(t[E].x)).add(p[S].scale(t[E].y)),
                                    C = e.Vector3.TransformCoordinates(D, P).scaleInPlace(T).add(i[S]);
                                b.push(C);
                            }
                            (o[M] = b), (g += A), M++;
                        }
                        var I = function (t) {
                            var i,
                                r = Array(),
                                n = e.Vector3.Zero();
                            for (i = 0; i < t.length; i++) n.addInPlace(t[i]);
                            for (n.scaleInPlace(1 / t.length), i = 0; i < t.length; i++) r.push(n);
                            return r;
                        };
                        switch (c) {
                            case r.NO_CAP:
                                break;
                            case r.CAP_START:
                                o.unshift(I(o[0]));
                                break;
                            case r.CAP_END:
                                o.push(I(o[o.length - 1]));
                                break;
                            case r.CAP_ALL:
                                o.unshift(I(o[0])), o.push(I(o[o.length - 1]));
                        }
                        return o;
                    };
                if (g) return (_ = g.path3D.update(n)), (v = y(i, n, g.path3D, g.pathArray, o, s, a, h, g.cap, f)), (g = r.CreateRibbon(null, v, null, null, null, null, null, null, g));
                _ = new e.Path3D(n);
                var x = new Array();
                (u = 0 > u || u > 3 ? 0 : u), (v = y(i, n, _, x, o, s, a, h, u, f));
                var M = r.CreateRibbon(t, v, l, c, 0, d, p, m);
                return (M.pathArray = v), (M.path3D = _), (M.cap = u), M;
            }),
            (r.CreateLathe = function (t, i, n, o, s, a, h) {
                void 0 === h && (h = r.DEFAULTSIDE), (n = n || 1), (o = o || 60 * n);
                for (var l = 2 * Math.PI, c = new Array(), u = 0; 0 === i[u].x; ) u++;
                var f = i[u];
                for (u = 0; u < i.length; u++) c.push(i[u].subtract(f));
                var d,
                    p = l / o,
                    m = new Array();
                for (u = 0; o > u; u++) (d = new e.Vector3(Math.cos(u * p) * n, 0, Math.sin(u * p) * n)), m.push(d);
                m.push(m[0]);
                var g = function () {
                        return 1;
                    },
                    _ = function () {
                        return 0;
                    },
                    v = r.ExtrudeShapeCustom(t, c, m, g, _, !0, !1, r.NO_CAP, s, a, h);
                return v;
            }),
            (r.CreatePlane = function (t, i, n, o, s) {
                if ((void 0 === s && (s = r.DEFAULTSIDE), "number" == typeof i)) {
                    var a = i;
                    i = { size: a, width: a, height: a, sideOrientation: s };
                }
                var h = new r(t, n),
                    l = e.VertexData.CreatePlane(i);
                return l.applyToMesh(h, o || i.updatable), h;
            }),
            (r.CreateGround = function (t, i, r, n, o, s) {
                if (r instanceof e.Scene) (o = r), (s = i.updatable);
                else {
                    var a = i;
                    i = { width: a, height: r, subdivisions: n };
                }
                var h = new e.GroundMesh(t, o);
                h._setReady(!1), (h._subdivisions = i.subdivisions || 1);
                var l = e.VertexData.CreateGround(i);
                return l.applyToMesh(h, s || i.updatable), h._setReady(!0), h;
            }),
            (r.CreateTiledGround = function (t, i, n, o, s, a, h, l, c) {
                var u = new r(t, l),
                    f = e.VertexData.CreateTiledGround(i, n, o, s, a, h);
                return f.applyToMesh(u, c), u;
            }),
            (r.CreateGroundFromHeightMap = function (t, i, r, n, o, s, a, h, l, c) {
                var u = new e.GroundMesh(t, h);
                (u._subdivisions = o), u._setReady(!1);
                var f = function (t) {
                    var i = document.createElement("canvas"),
                        h = i.getContext("2d"),
                        f = t.width,
                        d = t.height;
                    (i.width = f), (i.height = d), h.drawImage(t, 0, 0);
                    var p = h.getImageData(0, 0, f, d).data,
                        m = e.VertexData.CreateGroundFromHeightMap(r, n, o, s, a, p, f, d);
                    m.applyToMesh(u, l), u._setReady(!0), c && c(u);
                };
                return e.Tools.LoadImage(i, f, function () {}, h.database), u;
            }),
            (r.CreateTube = function (t, i, n, o, s, a, h, l, c, u) {
                void 0 === c && (c = r.DEFAULTSIDE), void 0 === u && (u = null);
                var f,
                    d,
                    p = function (t, i, n, o, s, a, h) {
                        for (
                            var l,
                                c,
                                u,
                                f,
                                d,
                                p = i.getTangents(),
                                m = i.getNormals(),
                                g = i.getDistances(),
                                _ = 2 * Math.PI,
                                v = _ / s,
                                y = function (e, t) {
                                    return o;
                                },
                                x = a || y,
                                M = 0,
                                S = 0;
                            S < t.length;
                            S++
                        ) {
                            (c = x(S, g[S])), (l = Array()), (u = m[S]);
                            for (var b = 0; s > b; b++) (d = e.Matrix.RotationAxis(p[S], v * b)), (f = e.Vector3.TransformCoordinates(u, d).scaleInPlace(c).add(t[S])), l.push(f);
                            (n[M] = l), M++;
                        }
                        var A = function (e, i) {
                            for (var r = Array(), n = 0; e > n; n++) r.push(t[i]);
                            return r;
                        };
                        switch (h) {
                            case r.NO_CAP:
                                break;
                            case r.CAP_START:
                                n.unshift(A(s + 1, 0));
                                break;
                            case r.CAP_END:
                                n.push(A(s + 1, t.length - 1));
                                break;
                            case r.CAP_ALL:
                                n.unshift(A(s + 1, 0)), n.push(A(s + 1, t.length - 1));
                        }
                        return n;
                    };
                if (u) return (f = u.path3D.update(i)), (d = p(i, f, u.pathArray, n, u.tessellation, s, u.cap)), (u = r.CreateRibbon(null, d, null, null, null, null, null, null, u));
                f = new e.Path3D(i);
                var m = new Array();
                (a = 0 > a || a > 3 ? 0 : a), (d = p(i, f, m, n, o, s, a));
                var g = r.CreateRibbon(t, d, !1, !0, 0, h, l, c);
                return (g.pathArray = d), (g.path3D = f), (g.tessellation = o), (g.cap = a), g;
            }),
            (r.CreateDecal = function (t, i, n, o, s, a) {
                void 0 === a && (a = 0);
                var h = i.getIndices(),
                    l = i.getVerticesData(e.VertexBuffer.PositionKind),
                    c = i.getVerticesData(e.VertexBuffer.NormalKind);
                if (!o) {
                    var u = new e.Vector3(0, 0, 1),
                        f = i.getScene().activeCamera,
                        d = e.Vector3.TransformCoordinates(u, f.getWorldMatrix());
                    o = f.globalPosition.subtract(d);
                }
                var p = -Math.atan2(o.z, o.x) - Math.PI / 2,
                    m = Math.sqrt(o.x * o.x + o.z * o.z),
                    g = Math.atan2(o.y, m),
                    _ = e.Matrix.RotationYawPitchRoll(p, g, a).multiply(e.Matrix.Translation(n.x, n.y, n.z)),
                    v = e.Matrix.Invert(_),
                    y = i.getWorldMatrix(),
                    x = y.multiply(v),
                    M = new e.VertexData();
                (M.indices = []), (M.positions = []), (M.normals = []), (M.uvs = []);
                for (
                    var S = 0,
                        b = function (t) {
                            var i = h[t],
                                r = new e.PositionNormalVertex();
                            return (r.position = new e.Vector3(l[3 * i], l[3 * i + 1], l[3 * i + 2])), (r.position = e.Vector3.TransformCoordinates(r.position, x)), (r.normal = new e.Vector3(c[3 * i], c[3 * i + 1], c[3 * i + 2])), r;
                        },
                        A = function (t, i) {
                            if (0 === t.length) return t;
                            for (
                                var r = 0.5 * Math.abs(e.Vector3.Dot(s, i)),
                                    n = function (t, n) {
                                        var o = e.Vector3.GetClipFactor(t.position, n.position, i, r);
                                        return new e.PositionNormalVertex(e.Vector3.Lerp(t.position, n.position, o), e.Vector3.Lerp(t.normal, n.normal, o));
                                    },
                                    o = new Array(),
                                    a = 0;
                                a < t.length;
                                a += 3
                            ) {
                                var h,
                                    l,
                                    c,
                                    u,
                                    f,
                                    d,
                                    p,
                                    m = 0,
                                    g = e.Vector3.Dot(t[a].position, i) - r,
                                    _ = e.Vector3.Dot(t[a + 1].position, i) - r,
                                    v = e.Vector3.Dot(t[a + 2].position, i) - r;
                                switch (((h = g > 0), (l = _ > 0), (c = v > 0), (m = (h ? 1 : 0) + (l ? 1 : 0) + (c ? 1 : 0)))) {
                                    case 0:
                                        o.push(t[a]), o.push(t[a + 1]), o.push(t[a + 2]);
                                        break;
                                    case 1:
                                        if ((h && ((u = t[a + 1]), (f = t[a + 2]), (d = n(t[a], u)), (p = n(t[a], f))), l)) {
                                            (u = t[a]), (f = t[a + 2]), (d = n(t[a + 1], u)), (p = n(t[a + 1], f)), o.push(d), o.push(f.clone()), o.push(u.clone()), o.push(f.clone()), o.push(d.clone()), o.push(p);
                                            break;
                                        }
                                        c && ((u = t[a]), (f = t[a + 1]), (d = n(t[a + 2], u)), (p = n(t[a + 2], f))), o.push(u.clone()), o.push(f.clone()), o.push(d), o.push(p), o.push(d.clone()), o.push(f.clone());
                                        break;
                                    case 2:
                                        h || ((u = t[a].clone()), (f = n(u, t[a + 1])), (d = n(u, t[a + 2])), o.push(u), o.push(f), o.push(d)),
                                            l || ((u = t[a + 1].clone()), (f = n(u, t[a + 2])), (d = n(u, t[a])), o.push(u), o.push(f), o.push(d)),
                                            c || ((u = t[a + 2].clone()), (f = n(u, t[a])), (d = n(u, t[a + 1])), o.push(u), o.push(f), o.push(d));
                                        break;
                                    case 3:
                                }
                            }
                            return o;
                        },
                        T = 0;
                    T < h.length;
                    T += 3
                ) {
                    var E = new Array();
                    if (
                        (E.push(b(T)),
                        E.push(b(T + 1)),
                        E.push(b(T + 2)),
                        (E = A(E, new e.Vector3(1, 0, 0))),
                        (E = A(E, new e.Vector3(-1, 0, 0))),
                        (E = A(E, new e.Vector3(0, 1, 0))),
                        (E = A(E, new e.Vector3(0, -1, 0))),
                        (E = A(E, new e.Vector3(0, 0, 1))),
                        (E = A(E, new e.Vector3(0, 0, -1))),
                        0 !== E.length)
                    )
                        for (var P = 0; P < E.length; P++) {
                            var D = E[P];
                            M.indices.push(S), D.position.toArray(M.positions, 3 * S), D.normal.toArray(M.normals, 3 * S), M.uvs.push(0.5 + D.position.x / s.x), M.uvs.push(0.5 + D.position.y / s.y), S++;
                        }
                }
                var C = new r(t, i.getScene());
                return M.applyToMesh(C), (C.position = n.clone()), (C.rotation = new e.Vector3(g, p, a)), C;
            }),
            (r.prototype.applySkeleton = function (t) {
                if (!this.isVerticesDataPresent(e.VertexBuffer.PositionKind)) return this;
                if (!this.isVerticesDataPresent(e.VertexBuffer.NormalKind)) return this;
                if (!this.isVerticesDataPresent(e.VertexBuffer.MatricesIndicesKind)) return this;
                if (!this.isVerticesDataPresent(e.VertexBuffer.MatricesWeightsKind)) return this;
                var i;
                this._sourcePositions ||
                    ((i = this.getVerticesData(e.VertexBuffer.PositionKind)),
                    (this._sourcePositions = new Float32Array(i)),
                    this.getVertexBuffer(e.VertexBuffer.PositionKind).isUpdatable() || this.setVerticesData(e.VertexBuffer.PositionKind, i, !0)),
                    this._sourceNormals ||
                        ((i = this.getVerticesData(e.VertexBuffer.NormalKind)),
                        (this._sourceNormals = new Float32Array(i)),
                        this.getVertexBuffer(e.VertexBuffer.NormalKind).isUpdatable() || this.setVerticesData(e.VertexBuffer.NormalKind, i, !0));
                for (
                    var r = this.getVerticesData(e.VertexBuffer.PositionKind),
                        n = this.getVerticesData(e.VertexBuffer.NormalKind),
                        o = this.getVerticesData(e.VertexBuffer.MatricesIndicesKind),
                        s = this.getVerticesData(e.VertexBuffer.MatricesWeightsKind),
                        a = t.getTransformMatrices(),
                        h = e.Vector3.Zero(),
                        l = new e.Matrix(),
                        c = new e.Matrix(),
                        u = 0;
                    u < r.length;
                    u += 3
                ) {
                    var f = (u / 3) * 4,
                        d = s[f],
                        p = s[f + 1],
                        m = s[f + 2],
                        g = s[f + 3];
                    d > 0 && (e.Matrix.FromFloat32ArrayToRefScaled(a, 16 * o[f], d, c), l.addToSelf(c)),
                        p > 0 && (e.Matrix.FromFloat32ArrayToRefScaled(a, 16 * o[f + 1], p, c), l.addToSelf(c)),
                        m > 0 && (e.Matrix.FromFloat32ArrayToRefScaled(a, 16 * o[f + 2], m, c), l.addToSelf(c)),
                        g > 0 && (e.Matrix.FromFloat32ArrayToRefScaled(a, 16 * o[f + 3], g, c), l.addToSelf(c)),
                        e.Vector3.TransformCoordinatesFromFloatsToRef(this._sourcePositions[u], this._sourcePositions[u + 1], this._sourcePositions[u + 2], l, h),
                        h.toArray(r, u),
                        e.Vector3.TransformNormalFromFloatsToRef(this._sourceNormals[u], this._sourceNormals[u + 1], this._sourceNormals[u + 2], l, h),
                        h.toArray(n, u),
                        l.reset();
                }
                return this.updateVerticesData(e.VertexBuffer.PositionKind, r), this.updateVerticesData(e.VertexBuffer.NormalKind, n), this;
            }),
            (r.MinMax = function (e) {
                var t = null,
                    i = null;
                for (var r in e) {
                    var n = e[r],
                        o = n.getBoundingInfo().boundingBox;
                    t ? (t.MinimizeInPlace(o.minimumWorld), i.MaximizeInPlace(o.maximumWorld)) : ((t = o.minimumWorld), (i = o.maximumWorld));
                }
                return { min: t, max: i };
            }),
            (r.Center = function (t) {
                var i = void 0 !== t.min ? t : r.MinMax(t);
                return e.Vector3.Center(i.min, i.max);
            }),
            (r.MergeMeshes = function (t, i, n, o) {
                void 0 === i && (i = !0);
                var s;
                if (!n) {
                    var a = 0;
                    for (s = 0; s < t.length; s++)
                        if (t[s] && ((a += t[s].getTotalVertices()), a > 65536))
                            return e.Tools.Warn("Cannot merge meshes because resulting mesh will have more than 65536 vertices. Please use allow32BitsIndices = true to use 32 bits indices"), null;
                }
                var h, l, c;
                for (s = 0; s < t.length; s++) t[s] && (t[s].computeWorldMatrix(!0), (l = e.VertexData.ExtractFromMesh(t[s], !0)), l.transform(t[s].getWorldMatrix()), h ? h.merge(l) : ((h = l), (c = t[s])));
                if ((o || (o = new r(c.name + "_merged", c.getScene())), h.applyToMesh(o), (o.material = c.material), (o.checkCollisions = c.checkCollisions), i)) for (s = 0; s < t.length; s++) t[s] && t[s].dispose();
                return o;
            }),
            (r._FRONTSIDE = 0),
            (r._BACKSIDE = 1),
            (r._DOUBLESIDE = 2),
            (r._DEFAULTSIDE = 0),
            (r._NO_CAP = 0),
            (r._CAP_START = 1),
            (r._CAP_END = 2),
            (r._CAP_ALL = 3),
            r
        );
    })(e.AbstractMesh);
    e.Mesh = i;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, t, i, r, n, o, s, a) {
            void 0 === a && (a = !0),
                (this.materialIndex = e),
                (this.verticesStart = t),
                (this.verticesCount = i),
                (this.indexStart = r),
                (this.indexCount = n),
                (this._renderId = 0),
                (this._mesh = o),
                (this._renderingMesh = s || o),
                o.subMeshes.push(this),
                (this._trianglePlanes = []),
                (this._id = o.subMeshes.length - 1),
                a && (this.refreshBoundingInfo(), o.computeWorldMatrix(!0));
        }
        return (
            (t.prototype.getBoundingInfo = function () {
                return this._boundingInfo;
            }),
            (t.prototype.getMesh = function () {
                return this._mesh;
            }),
            (t.prototype.getRenderingMesh = function () {
                return this._renderingMesh;
            }),
            (t.prototype.getMaterial = function () {
                var t = this._renderingMesh.material;
                if (t && t instanceof e.MultiMaterial) {
                    var i = t;
                    return i.getSubMaterial(this.materialIndex);
                }
                return t ? t : this._mesh.getScene().defaultMaterial;
            }),
            (t.prototype.refreshBoundingInfo = function () {
                var t = this._renderingMesh.getVerticesData(e.VertexBuffer.PositionKind);
                if (!t) return void (this._boundingInfo = this._mesh._boundingInfo);
                var i,
                    r = this._renderingMesh.getIndices();
                (i = 0 === this.indexStart && this.indexCount === r.length ? e.Tools.ExtractMinAndMax(t, this.verticesStart, this.verticesCount) : e.Tools.ExtractMinAndMaxIndexed(t, r, this.indexStart, this.indexCount)),
                    (this._boundingInfo = new e.BoundingInfo(i.minimum, i.maximum));
            }),
            (t.prototype._checkCollision = function (e) {
                return this._boundingInfo._checkCollision(e);
            }),
            (t.prototype.updateBoundingInfo = function (e) {
                this._boundingInfo || this.refreshBoundingInfo(), this._boundingInfo._update(e);
            }),
            (t.prototype.isInFrustum = function (e) {
                return this._boundingInfo.isInFrustum(e);
            }),
            (t.prototype.render = function (e) {
                this._renderingMesh.render(this, e);
            }),
            (t.prototype.getLinesIndexBuffer = function (e, t) {
                if (!this._linesIndexBuffer) {
                    for (var i = [], r = this.indexStart; r < this.indexStart + this.indexCount; r += 3) i.push(e[r], e[r + 1], e[r + 1], e[r + 2], e[r + 2], e[r]);
                    (this._linesIndexBuffer = t.createIndexBuffer(i)), (this.linesIndexCount = i.length);
                }
                return this._linesIndexBuffer;
            }),
            (t.prototype.canIntersects = function (e) {
                return e.intersectsBox(this._boundingInfo.boundingBox);
            }),
            (t.prototype.intersects = function (e, t, i, r) {
                for (var n = null, o = this.indexStart; o < this.indexStart + this.indexCount; o += 3) {
                    var s = t[i[o]],
                        a = t[i[o + 1]],
                        h = t[i[o + 2]],
                        l = e.intersectsTriangle(s, a, h);
                    if (l) {
                        if (l.distance < 0) continue;
                        if ((r || !n || l.distance < n.distance) && ((n = l), (n.faceId = o / 3), r)) break;
                    }
                }
                return n;
            }),
            (t.prototype.clone = function (i, r) {
                var n = new t(this.materialIndex, this.verticesStart, this.verticesCount, this.indexStart, this.indexCount, i, r, !1);
                return (n._boundingInfo = new e.BoundingInfo(this._boundingInfo.minimum, this._boundingInfo.maximum)), n;
            }),
            (t.prototype.dispose = function () {
                this._linesIndexBuffer && (this._mesh.getScene().getEngine()._releaseBuffer(this._linesIndexBuffer), (this._linesIndexBuffer = null));
                var e = this._mesh.subMeshes.indexOf(this);
                this._mesh.subMeshes.splice(e, 1);
            }),
            (t.CreateFromIndices = function (e, i, r, n, o) {
                var s = Number.MAX_VALUE,
                    a = -Number.MAX_VALUE;
                o = o || n;
                for (var h = o.getIndices(), l = i; i + r > l; l++) {
                    var c = h[l];
                    s > c && (s = c), c > a && (a = c);
                }
                return new t(e, s, a - s + 1, i, r, n, o);
            }),
            t
        );
    })();
    e.SubMesh = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t) {
            (this.delayLoadState = e.Engine.DELAYLOADSTATE_NONE),
                (this.hasAlpha = !1),
                (this.getAlphaFromRGB = !1),
                (this.level = 1),
                (this.isCube = !1),
                (this.isRenderTarget = !1),
                (this.animations = new Array()),
                (this.coordinatesIndex = 0),
                (this.coordinatesMode = e.Texture.EXPLICIT_MODE),
                (this.wrapU = e.Texture.WRAP_ADDRESSMODE),
                (this.wrapV = e.Texture.WRAP_ADDRESSMODE),
                (this.anisotropicFilteringLevel = 4),
                (this._scene = t),
                this._scene.textures.push(this);
        }
        return (
            (t.prototype.getScene = function () {
                return this._scene;
            }),
            (t.prototype.getTextureMatrix = function () {
                return null;
            }),
            (t.prototype.getReflectionTextureMatrix = function () {
                return null;
            }),
            (t.prototype.getInternalTexture = function () {
                return this._texture;
            }),
            (t.prototype.isReady = function () {
                return this.delayLoadState === e.Engine.DELAYLOADSTATE_NOTLOADED ? !0 : this._texture ? this._texture.isReady : !1;
            }),
            (t.prototype.getSize = function () {
                return this._texture._width ? { width: this._texture._width, height: this._texture._height } : this._texture._size ? { width: this._texture._size, height: this._texture._size } : { width: 0, height: 0 };
            }),
            (t.prototype.getBaseSize = function () {
                return this.isReady() ? (this._texture._size ? { width: this._texture._size, height: this._texture._size } : { width: this._texture._baseWidth, height: this._texture._baseHeight }) : { width: 0, height: 0 };
            }),
            (t.prototype.scale = function (e) {}),
            Object.defineProperty(t.prototype, "canRescale", {
                get: function () {
                    return !1;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype._removeFromCache = function (e, t) {
                for (var i = this._scene.getEngine().getLoadedTexturesCache(), r = 0; r < i.length; r++) {
                    var n = i[r];
                    if (n.url === e && n.noMipmap === t) return void i.splice(r, 1);
                }
            }),
            (t.prototype._getFromCache = function (e, t, i) {
                for (var r = this._scene.getEngine().getLoadedTexturesCache(), n = 0; n < r.length; n++) {
                    var o = r[n];
                    if (o.url === e && o.noMipmap === t && (!i || i === o.samplingMode)) return o.references++, o;
                }
                return null;
            }),
            (t.prototype.delayLoad = function () {}),
            (t.prototype.releaseInternalTexture = function () {
                if (this._texture) {
                    var e = this._scene.getEngine().getLoadedTexturesCache();
                    if ((this._texture.references--, 0 === this._texture.references)) {
                        var t = e.indexOf(this._texture);
                        e.splice(t, 1), this._scene.getEngine()._releaseTexture(this._texture), delete this._texture;
                    }
                }
            }),
            (t.prototype.clone = function () {
                return null;
            }),
            (t.prototype.dispose = function () {
                var e = this._scene.textures.indexOf(this);
                e >= 0 && this._scene.textures.splice(e, 1), void 0 !== this._texture && (this.releaseInternalTexture(), this.onDispose && this.onDispose());
            }),
            t
        );
    })();
    e.BaseTexture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(r, n, o, s, a, h, l, c, u) {
            void 0 === a && (a = i.TRILINEAR_SAMPLINGMODE),
                void 0 === h && (h = null),
                void 0 === l && (l = null),
                void 0 === c && (c = null),
                void 0 === u && (u = !1),
                t.call(this, n),
                (this.uOffset = 0),
                (this.vOffset = 0),
                (this.uScale = 1),
                (this.vScale = 1),
                (this.uAng = 0),
                (this.vAng = 0),
                (this.wAng = 0),
                (this.name = r),
                (this.url = r),
                (this._noMipmap = o),
                (this._invertY = s),
                (this._samplingMode = a),
                (this._buffer = c),
                (this._deleteBuffer = u),
                r &&
                    ((this._texture = this._getFromCache(r, o, a)),
                    this._texture
                        ? e.Tools.SetImmediate(function () {
                              h && h();
                          })
                        : n.useDelayedTextureLoading
                        ? (this.delayLoadState = e.Engine.DELAYLOADSTATE_NOTLOADED)
                        : ((this._texture = n.getEngine().createTexture(r, o, s, n, this._samplingMode, h, l, this._buffer)), u && delete this._buffer));
        }
        return (
            __extends(i, t),
            (i.prototype.delayLoad = function () {
                this.delayLoadState === e.Engine.DELAYLOADSTATE_NOTLOADED &&
                    ((this.delayLoadState = e.Engine.DELAYLOADSTATE_LOADED),
                    (this._texture = this._getFromCache(this.url, this._noMipmap, this._samplingMode)),
                    this._texture ||
                        ((this._texture = this.getScene().getEngine().createTexture(this.url, this._noMipmap, this._invertY, this.getScene(), this._samplingMode, null, null, this._buffer)), this._deleteBuffer && delete this._buffer));
            }),
            (i.prototype.updateSamplingMode = function (e) {
                this._texture && this.getScene().getEngine().updateTextureSamplingMode(e, this._texture);
            }),
            (i.prototype._prepareRowForTextureGeneration = function (t, i, r, n) {
                (t *= this.uScale),
                    (i *= this.vScale),
                    (t -= 0.5 * this.uScale),
                    (i -= 0.5 * this.vScale),
                    (r -= 0.5),
                    e.Vector3.TransformCoordinatesFromFloatsToRef(t, i, r, this._rowGenerationMatrix, n),
                    (n.x += 0.5 * this.uScale + this.uOffset),
                    (n.y += 0.5 * this.vScale + this.vOffset),
                    (n.z += 0.5);
            }),
            (i.prototype.getTextureMatrix = function () {
                return this.uOffset === this._cachedUOffset &&
                    this.vOffset === this._cachedVOffset &&
                    this.uScale === this._cachedUScale &&
                    this.vScale === this._cachedVScale &&
                    this.uAng === this._cachedUAng &&
                    this.vAng === this._cachedVAng &&
                    this.wAng === this._cachedWAng
                    ? this._cachedTextureMatrix
                    : ((this._cachedUOffset = this.uOffset),
                      (this._cachedVOffset = this.vOffset),
                      (this._cachedUScale = this.uScale),
                      (this._cachedVScale = this.vScale),
                      (this._cachedUAng = this.uAng),
                      (this._cachedVAng = this.vAng),
                      (this._cachedWAng = this.wAng),
                      this._cachedTextureMatrix || ((this._cachedTextureMatrix = e.Matrix.Zero()), (this._rowGenerationMatrix = new e.Matrix()), (this._t0 = e.Vector3.Zero()), (this._t1 = e.Vector3.Zero()), (this._t2 = e.Vector3.Zero())),
                      e.Matrix.RotationYawPitchRollToRef(this.vAng, this.uAng, this.wAng, this._rowGenerationMatrix),
                      this._prepareRowForTextureGeneration(0, 0, 0, this._t0),
                      this._prepareRowForTextureGeneration(1, 0, 0, this._t1),
                      this._prepareRowForTextureGeneration(0, 1, 0, this._t2),
                      this._t1.subtractInPlace(this._t0),
                      this._t2.subtractInPlace(this._t0),
                      e.Matrix.IdentityToRef(this._cachedTextureMatrix),
                      (this._cachedTextureMatrix.m[0] = this._t1.x),
                      (this._cachedTextureMatrix.m[1] = this._t1.y),
                      (this._cachedTextureMatrix.m[2] = this._t1.z),
                      (this._cachedTextureMatrix.m[4] = this._t2.x),
                      (this._cachedTextureMatrix.m[5] = this._t2.y),
                      (this._cachedTextureMatrix.m[6] = this._t2.z),
                      (this._cachedTextureMatrix.m[8] = this._t0.x),
                      (this._cachedTextureMatrix.m[9] = this._t0.y),
                      (this._cachedTextureMatrix.m[10] = this._t0.z),
                      this._cachedTextureMatrix);
            }),
            (i.prototype.getReflectionTextureMatrix = function () {
                if (this.uOffset === this._cachedUOffset && this.vOffset === this._cachedVOffset && this.uScale === this._cachedUScale && this.vScale === this._cachedVScale && this.coordinatesMode === this._cachedCoordinatesMode)
                    return this._cachedTextureMatrix;
                switch ((this._cachedTextureMatrix || ((this._cachedTextureMatrix = e.Matrix.Zero()), (this._projectionModeMatrix = e.Matrix.Zero())), (this._cachedCoordinatesMode = this.coordinatesMode), this.coordinatesMode)) {
                    case i.SPHERICAL_MODE:
                        e.Matrix.IdentityToRef(this._cachedTextureMatrix),
                            (this._cachedTextureMatrix[0] = -0.5 * this.uScale),
                            (this._cachedTextureMatrix[5] = -0.5 * this.vScale),
                            (this._cachedTextureMatrix[12] = 0.5 + this.uOffset),
                            (this._cachedTextureMatrix[13] = 0.5 + this.vOffset);
                        break;
                    case i.PLANAR_MODE:
                        e.Matrix.IdentityToRef(this._cachedTextureMatrix),
                            (this._cachedTextureMatrix[0] = this.uScale),
                            (this._cachedTextureMatrix[5] = this.vScale),
                            (this._cachedTextureMatrix[12] = this.uOffset),
                            (this._cachedTextureMatrix[13] = this.vOffset);
                        break;
                    case i.PROJECTION_MODE:
                        e.Matrix.IdentityToRef(this._projectionModeMatrix),
                            (this._projectionModeMatrix.m[0] = 0.5),
                            (this._projectionModeMatrix.m[5] = -0.5),
                            (this._projectionModeMatrix.m[10] = 0),
                            (this._projectionModeMatrix.m[12] = 0.5),
                            (this._projectionModeMatrix.m[13] = 0.5),
                            (this._projectionModeMatrix.m[14] = 1),
                            (this._projectionModeMatrix.m[15] = 1),
                            this.getScene().getProjectionMatrix().multiplyToRef(this._projectionModeMatrix, this._cachedTextureMatrix);
                        break;
                    default:
                        e.Matrix.IdentityToRef(this._cachedTextureMatrix);
                }
                return this._cachedTextureMatrix;
            }),
            (i.prototype.clone = function () {
                var e = new i(this._texture.url, this.getScene(), this._noMipmap, this._invertY, this._samplingMode);
                return (
                    (e.hasAlpha = this.hasAlpha),
                    (e.level = this.level),
                    (e.wrapU = this.wrapU),
                    (e.wrapV = this.wrapV),
                    (e.coordinatesIndex = this.coordinatesIndex),
                    (e.coordinatesMode = this.coordinatesMode),
                    (e.uOffset = this.uOffset),
                    (e.vOffset = this.vOffset),
                    (e.uScale = this.uScale),
                    (e.vScale = this.vScale),
                    (e.uAng = this.uAng),
                    (e.vAng = this.vAng),
                    (e.wAng = this.wAng),
                    e
                );
            }),
            (i.CreateFromBase64String = function (e, t, r, n, o, s, a, h) {
                return void 0 === s && (s = i.TRILINEAR_SAMPLINGMODE), void 0 === a && (a = null), void 0 === h && (h = null), new i("data:" + t, r, n, o, s, a, h, e);
            }),
            (i.NEAREST_SAMPLINGMODE = 1),
            (i.BILINEAR_SAMPLINGMODE = 2),
            (i.TRILINEAR_SAMPLINGMODE = 3),
            (i.EXPLICIT_MODE = 0),
            (i.SPHERICAL_MODE = 1),
            (i.PLANAR_MODE = 2),
            (i.CUBIC_MODE = 3),
            (i.PROJECTION_MODE = 4),
            (i.SKYBOX_MODE = 5),
            (i.CLAMP_ADDRESSMODE = 0),
            (i.WRAP_ADDRESSMODE = 1),
            (i.MIRROR_ADDRESSMODE = 2),
            i
        );
    })(e.BaseTexture);
    e.Texture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o) {
            t.call(this, r),
                (this.coordinatesMode = e.Texture.CUBIC_MODE),
                (this.name = i),
                (this.url = i),
                (this._noMipmap = o),
                (this.hasAlpha = !1),
                (this._texture = this._getFromCache(i, o)),
                n || (n = ["_px.jpg", "_py.jpg", "_pz.jpg", "_nx.jpg", "_ny.jpg", "_nz.jpg"]),
                (this._extensions = n),
                this._texture || (r.useDelayedTextureLoading ? (this.delayLoadState = e.Engine.DELAYLOADSTATE_NOTLOADED) : (this._texture = r.getEngine().createCubeTexture(i, r, n, o))),
                (this.isCube = !0),
                (this._textureMatrix = e.Matrix.Identity());
        }
        return (
            __extends(i, t),
            (i.prototype.clone = function () {
                var e = new i(this.url, this.getScene(), this._extensions, this._noMipmap);
                return (e.level = this.level), (e.wrapU = this.wrapU), (e.wrapV = this.wrapV), (e.coordinatesIndex = this.coordinatesIndex), (e.coordinatesMode = this.coordinatesMode), e;
            }),
            (i.prototype.delayLoad = function () {
                this.delayLoadState === e.Engine.DELAYLOADSTATE_NOTLOADED &&
                    ((this.delayLoadState = e.Engine.DELAYLOADSTATE_LOADED),
                    (this._texture = this._getFromCache(this.url, this._noMipmap)),
                    this._texture || (this._texture = this.getScene().getEngine().createCubeTexture(this.url, this.getScene(), this._extensions)));
            }),
            (i.prototype.getReflectionTextureMatrix = function () {
                return this._textureMatrix;
            }),
            i
        );
    })(e.BaseTexture);
    e.CubeTexture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o, s, a) {
            void 0 === s && (s = !0),
                void 0 === a && (a = e.Engine.TEXTURETYPE_UNSIGNED_INT),
                t.call(this, null, n, !o),
                (this.renderList = new Array()),
                (this.renderParticles = !0),
                (this.renderSprites = !1),
                (this.coordinatesMode = e.Texture.PROJECTION_MODE),
                (this._currentRefreshId = -1),
                (this._refreshRate = 1),
                (this.name = i),
                (this.isRenderTarget = !0),
                (this._size = r),
                (this._generateMipMaps = o),
                (this._doNotChangeAspectRatio = s),
                (this._texture = n.getEngine().createRenderTargetTexture(r, { generateMipMaps: o, type: a })),
                (this._renderingManager = new e.RenderingManager(n));
        }
        return (
            __extends(i, t),
            (i.prototype.resetRefreshCounter = function () {
                this._currentRefreshId = -1;
            }),
            Object.defineProperty(i.prototype, "refreshRate", {
                get: function () {
                    return this._refreshRate;
                },
                set: function (e) {
                    (this._refreshRate = e), this.resetRefreshCounter();
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype._shouldRender = function () {
                return -1 === this._currentRefreshId ? ((this._currentRefreshId = 1), !0) : this.refreshRate === this._currentRefreshId ? ((this._currentRefreshId = 1), !0) : (this._currentRefreshId++, !1);
            }),
            (i.prototype.isReady = function () {
                return this.getScene().renderTargetsEnabled ? t.prototype.isReady.call(this) : !1;
            }),
            (i.prototype.getRenderSize = function () {
                return this._size;
            }),
            Object.defineProperty(i.prototype, "canRescale", {
                get: function () {
                    return !0;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.scale = function (e) {
                var t = this._size * e;
                this.resize(t, this._generateMipMaps);
            }),
            (i.prototype.resize = function (e, t) {
                this.releaseInternalTexture(), (this._texture = this.getScene().getEngine().createRenderTargetTexture(e, t));
            }),
            (i.prototype.render = function (t, i) {
                var r = this.getScene(),
                    n = r.getEngine();
                if (this._waitingRenderList) {
                    this.renderList = [];
                    for (var o = 0; o < this._waitingRenderList.length; o++) {
                        var s = this._waitingRenderList[o];
                        this.renderList.push(r.getMeshByID(s));
                    }
                    delete this._waitingRenderList;
                }
                if (!this.renderList || 0 !== this.renderList.length) {
                    (t && r.postProcessManager._prepareFrame(this._texture)) || n.bindFramebuffer(this._texture), this._renderingManager.reset();
                    for (var a = this.renderList ? this.renderList : r.getActiveMeshes().data, h = 0; h < a.length; h++) {
                        var l = a[h];
                        if (l) {
                            if (!l.isReady()) {
                                this.resetRefreshCounter();
                                continue;
                            }
                            if (l.isEnabled() && l.isVisible && l.subMeshes && 0 !== (l.layerMask & r.activeCamera.layerMask)) {
                                l._activate(r.getRenderId());
                                for (var c = 0; c < l.subMeshes.length; c++) {
                                    var u = l.subMeshes[c];
                                    (r._activeIndices += u.indexCount), this._renderingManager.dispatch(u);
                                }
                            }
                        }
                    }
                    this.onBeforeRender && this.onBeforeRender(),
                        this.onClear ? this.onClear(n) : n.clear(r.clearColor, !0, !0),
                        this._doNotChangeAspectRatio || r.updateTransformMatrix(!0),
                        this._renderingManager.render(this.customRenderFunction, a, this.renderParticles, this.renderSprites),
                        t && r.postProcessManager._finalizeFrame(!1, this._texture),
                        this._doNotChangeAspectRatio || r.updateTransformMatrix(!0),
                        this.onAfterRender && this.onAfterRender(),
                        i && e.Tools.DumpFramebuffer(this._size, this._size, n),
                        n.unBindFramebuffer(this._texture),
                        this.onAfterUnbind && this.onAfterUnbind();
                }
            }),
            (i.prototype.clone = function () {
                var e = this.getSize(),
                    t = new i(this.name, e.width, this.getScene(), this._generateMipMaps);
                return (t.hasAlpha = this.hasAlpha), (t.level = this.level), (t.coordinatesMode = this.coordinatesMode), (t.renderList = this.renderList.slice(0)), t;
            }),
            i
        );
    })(e.Texture);
    e.RenderTargetTexture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i, r, n, o, s) {
            void 0 === s && (s = !0),
                e.call(this, null, n, !s),
                (this.isEnabled = !0),
                (this._currentRefreshId = -1),
                (this._refreshRate = 1),
                (this._vertexDeclaration = [2]),
                (this._vertexStrideSize = 8),
                (this._uniforms = new Array()),
                (this._samplers = new Array()),
                (this._textures = new Array()),
                (this._floats = new Array()),
                (this._floatsArrays = {}),
                (this._colors3 = new Array()),
                (this._colors4 = new Array()),
                (this._vectors2 = new Array()),
                (this._vectors3 = new Array()),
                (this._matrices = new Array()),
                (this._fallbackTextureUsed = !1),
                n._proceduralTextures.push(this),
                (this.name = t),
                (this.isRenderTarget = !0),
                (this._size = i),
                (this._generateMipMaps = s),
                this.setFragment(r),
                (this._fallbackTexture = o),
                (this._texture = n.getEngine().createRenderTargetTexture(i, s));
            var a = [];
            a.push(1, 1), a.push(-1, 1), a.push(-1, -1), a.push(1, -1), (this._vertexBuffer = n.getEngine().createVertexBuffer(a));
            var h = [];
            h.push(0), h.push(1), h.push(2), h.push(0), h.push(2), h.push(3), (this._indexBuffer = n.getEngine().createIndexBuffer(h));
        }
        return (
            __extends(t, e),
            (t.prototype.reset = function () {
                if (void 0 !== this._effect) {
                    var e = this.getScene().getEngine();
                    e._releaseEffect(this._effect);
                }
            }),
            (t.prototype.isReady = function () {
                var e,
                    t = this,
                    i = this.getScene().getEngine();
                return this._fragment
                    ? this._fallbackTextureUsed
                        ? !0
                        : ((e = void 0 !== this._fragment.fragmentElement ? { vertex: "procedural", fragmentElement: this._fragment.fragmentElement } : { vertex: "procedural", fragment: this._fragment }),
                          (this._effect = i.createEffect(e, ["position"], this._uniforms, this._samplers, "", null, null, function () {
                              t.releaseInternalTexture(), t._fallbackTexture && ((t._texture = t._fallbackTexture._texture), t._texture.references++), (t._fallbackTextureUsed = !0);
                          })),
                          this._effect.isReady())
                    : !1;
            }),
            (t.prototype.resetRefreshCounter = function () {
                this._currentRefreshId = -1;
            }),
            (t.prototype.setFragment = function (e) {
                this._fragment = e;
            }),
            Object.defineProperty(t.prototype, "refreshRate", {
                get: function () {
                    return this._refreshRate;
                },
                set: function (e) {
                    (this._refreshRate = e), this.resetRefreshCounter();
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype._shouldRender = function () {
                return this.isEnabled && this.isReady() && this._texture
                    ? this._fallbackTextureUsed
                        ? !1
                        : -1 === this._currentRefreshId
                        ? ((this._currentRefreshId = 1), !0)
                        : this.refreshRate === this._currentRefreshId
                        ? ((this._currentRefreshId = 1), !0)
                        : (this._currentRefreshId++, !1)
                    : !1;
            }),
            (t.prototype.getRenderSize = function () {
                return this._size;
            }),
            (t.prototype.resize = function (e, t) {
                this._fallbackTextureUsed || (this.releaseInternalTexture(), (this._texture = this.getScene().getEngine().createRenderTargetTexture(e, t)));
            }),
            (t.prototype._checkUniform = function (e) {
                -1 === this._uniforms.indexOf(e) && this._uniforms.push(e);
            }),
            (t.prototype.setTexture = function (e, t) {
                return -1 === this._samplers.indexOf(e) && this._samplers.push(e), (this._textures[e] = t), this;
            }),
            (t.prototype.setFloat = function (e, t) {
                return this._checkUniform(e), (this._floats[e] = t), this;
            }),
            (t.prototype.setFloats = function (e, t) {
                return this._checkUniform(e), (this._floatsArrays[e] = t), this;
            }),
            (t.prototype.setColor3 = function (e, t) {
                return this._checkUniform(e), (this._colors3[e] = t), this;
            }),
            (t.prototype.setColor4 = function (e, t) {
                return this._checkUniform(e), (this._colors4[e] = t), this;
            }),
            (t.prototype.setVector2 = function (e, t) {
                return this._checkUniform(e), (this._vectors2[e] = t), this;
            }),
            (t.prototype.setVector3 = function (e, t) {
                return this._checkUniform(e), (this._vectors3[e] = t), this;
            }),
            (t.prototype.setMatrix = function (e, t) {
                return this._checkUniform(e), (this._matrices[e] = t), this;
            }),
            (t.prototype.render = function (e) {
                var t = this.getScene(),
                    i = t.getEngine();
                i.bindFramebuffer(this._texture), i.clear(t.clearColor, !0, !0), i.enableEffect(this._effect), i.setState(!1);
                for (var r in this._textures) this._effect.setTexture(r, this._textures[r]);
                for (r in this._floats) this._effect.setFloat(r, this._floats[r]);
                for (r in this._floatsArrays) this._effect.setArray(r, this._floatsArrays[r]);
                for (r in this._colors3) this._effect.setColor3(r, this._colors3[r]);
                for (r in this._colors4) {
                    var n = this._colors4[r];
                    this._effect.setFloat4(r, n.r, n.g, n.b, n.a);
                }
                for (r in this._vectors2) this._effect.setVector2(r, this._vectors2[r]);
                for (r in this._vectors3) this._effect.setVector3(r, this._vectors3[r]);
                for (r in this._matrices) this._effect.setMatrix(r, this._matrices[r]);
                i.bindBuffers(this._vertexBuffer, this._indexBuffer, this._vertexDeclaration, this._vertexStrideSize, this._effect), i.draw(!0, 0, 6), i.unBindFramebuffer(this._texture);
            }),
            (t.prototype.clone = function () {
                var e = this.getSize(),
                    i = new t(this.name, e.width, this._fragment, this.getScene(), this._fallbackTexture, this._generateMipMaps);
                return (i.hasAlpha = this.hasAlpha), (i.level = this.level), (i.coordinatesMode = this.coordinatesMode), i;
            }),
            (t.prototype.dispose = function () {
                var t = this.getScene()._proceduralTextures.indexOf(this);
                t >= 0 && this.getScene()._proceduralTextures.splice(t, 1), e.prototype.dispose.call(this);
            }),
            t
        );
    })(e.Texture);
    e.ProceduralTexture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o) {
            var s = this;
            t.call(this, i, r, n, o, !0),
                (this.mirrorPlane = new e.Plane(0, 1, 0, 1)),
                (this._transformMatrix = e.Matrix.Zero()),
                (this._mirrorMatrix = e.Matrix.Zero()),
                (this.onBeforeRender = function () {
                    e.Matrix.ReflectionToRef(s.mirrorPlane, s._mirrorMatrix),
                        (s._savedViewMatrix = n.getViewMatrix()),
                        s._mirrorMatrix.multiplyToRef(s._savedViewMatrix, s._transformMatrix),
                        n.setTransformMatrix(s._transformMatrix, n.getProjectionMatrix()),
                        (n.clipPlane = s.mirrorPlane),
                        (n.getEngine().cullBackFaces = !1);
                }),
                (this.onAfterRender = function () {
                    n.setTransformMatrix(s._savedViewMatrix, n.getProjectionMatrix()), (n.getEngine().cullBackFaces = !0), delete n.clipPlane;
                });
        }
        return (
            __extends(i, t),
            (i.prototype.clone = function () {
                var e = this.getSize(),
                    t = new i(this.name, e.width, this.getScene(), this._generateMipMaps);
                return (t.hasAlpha = this.hasAlpha), (t.level = this.level), (t.mirrorPlane = this.mirrorPlane.clone()), (t.renderList = this.renderList.slice(0)), t;
            }),
            i
        );
    })(e.RenderTargetTexture);
    e.MirrorTexture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o, s) {
            void 0 === s && (s = e.Texture.TRILINEAR_SAMPLINGMODE),
                t.call(this, null, n, !o),
                (this.name = i),
                (this.wrapU = e.Texture.CLAMP_ADDRESSMODE),
                (this.wrapV = e.Texture.CLAMP_ADDRESSMODE),
                (this._generateMipMaps = o),
                r.getContext
                    ? ((this._canvas = r), (this._texture = n.getEngine().createDynamicTexture(r.width, r.height, o, s)))
                    : ((this._canvas = document.createElement("canvas")), (this._texture = r.width ? n.getEngine().createDynamicTexture(r.width, r.height, o, s) : n.getEngine().createDynamicTexture(r, r, o, s)));
            var a = this.getSize();
            (this._canvas.width = a.width), (this._canvas.height = a.height), (this._context = this._canvas.getContext("2d"));
        }
        return (
            __extends(i, t),
            Object.defineProperty(i.prototype, "canRescale", {
                get: function () {
                    return !0;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (i.prototype.scale = function (e) {
                var t = this.getSize();
                (t.width *= e),
                    (t.height *= e),
                    (this._canvas.width = t.width),
                    (this._canvas.height = t.height),
                    this.releaseInternalTexture(),
                    (this._texture = this.getScene().getEngine().createDynamicTexture(t.width, t.height, this._generateMipMaps, this._samplingMode));
            }),
            (i.prototype.getContext = function () {
                return this._context;
            }),
            (i.prototype.clear = function () {
                var e = this.getSize();
                this._context.fillRect(0, 0, e.width, e.height);
            }),
            (i.prototype.update = function (e) {
                this.getScene()
                    .getEngine()
                    .updateDynamicTexture(this._texture, this._canvas, void 0 === e ? !0 : e);
            }),
            (i.prototype.drawText = function (e, t, i, r, n, o, s, a) {
                void 0 === a && (a = !0);
                var h = this.getSize();
                if ((o && ((this._context.fillStyle = o), this._context.fillRect(0, 0, h.width, h.height)), (this._context.font = r), null === t)) {
                    var l = this._context.measureText(e);
                    t = (h.width - l.width) / 2;
                }
                (this._context.fillStyle = n), this._context.fillText(e, t, i), a && this.update(s);
            }),
            (i.prototype.clone = function () {
                var e = this.getSize(),
                    t = new i(this.name, e.width, this.getScene(), this._generateMipMaps);
                return (t.hasAlpha = this.hasAlpha), (t.level = this.level), (t.wrapU = this.wrapU), (t.wrapV = this.wrapV), t;
            }),
            i
        );
    })(e.Texture);
    e.DynamicTexture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o, s, a) {
            var h = this;
            void 0 === o && (o = !1),
                void 0 === s && (s = !1),
                void 0 === a && (a = e.Texture.TRILINEAR_SAMPLINGMODE),
                t.call(this, null, n, !o, s),
                (this._autoLaunch = !0),
                (this.name = i),
                (this.video = document.createElement("video")),
                (this.video.autoplay = !1),
                (this.video.loop = !0),
                this.video.addEventListener("canplaythrough", function () {
                    e.Tools.IsExponantOfTwo(h.video.videoWidth) && e.Tools.IsExponantOfTwo(h.video.videoHeight)
                        ? ((h.wrapU = e.Texture.WRAP_ADDRESSMODE), (h.wrapV = e.Texture.WRAP_ADDRESSMODE))
                        : ((h.wrapU = e.Texture.CLAMP_ADDRESSMODE), (h.wrapV = e.Texture.CLAMP_ADDRESSMODE), (o = !1)),
                        (h._texture = n.getEngine().createDynamicTexture(h.video.videoWidth, h.video.videoHeight, o, a, !1)),
                        (h._texture.isReady = !0);
                }),
                r.forEach(function (e) {
                    var t = document.createElement("source");
                    (t.src = e), h.video.appendChild(t);
                }),
                (this._lastUpdate = e.Tools.Now);
        }
        return (
            __extends(i, t),
            (i.prototype.update = function () {
                this._autoLaunch && ((this._autoLaunch = !1), this.video.play());
                var t = e.Tools.Now;
                return t - this._lastUpdate < 15 || this.video.readyState !== this.video.HAVE_ENOUGH_DATA ? !1 : ((this._lastUpdate = t), this.getScene().getEngine().updateVideoTexture(this._texture, this.video, this._invertY), !0);
            }),
            i
        );
    })(e.Texture);
    e.VideoTexture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(e, i, r, n, o, s) {
            t.call(this, e, r, null, n, o, s), (this._animate = !0), (this._time = 0), (this._texturePath = i), this.loadJson(i), (this.refreshRate = 1);
        }
        return (
            __extends(i, t),
            (i.prototype.loadJson = function (t) {
                function i() {
                    e.Tools.Log("No config file found in " + t + " trying to use ShadersStore or DOM element");
                    try {
                        n.setFragment(n._texturePath);
                    } catch (i) {
                        e.Tools.Error("No json or ShaderStore or DOM element found for CustomProceduralTexture");
                    }
                }
                var r = this,
                    n = this,
                    o = t + "/config.json",
                    s = new XMLHttpRequest();
                s.open("GET", o, !0),
                    s.addEventListener(
                        "load",
                        function () {
                            if (200 === s.status || e.Tools.ValidateXHRData(s, 1))
                                try {
                                    (r._config = JSON.parse(s.response)), r.updateShaderUniforms(), r.updateTextures(), r.setFragment(r._texturePath + "/custom"), (r._animate = r._config.animate), (r.refreshRate = r._config.refreshrate);
                                } catch (t) {
                                    i();
                                }
                            else i();
                        },
                        !1
                    ),
                    s.addEventListener(
                        "error",
                        function () {
                            i();
                        },
                        !1
                    );
                try {
                    s.send();
                } catch (a) {
                    e.Tools.Error("CustomProceduralTexture: Error on XHR send request.");
                }
            }),
            (i.prototype.isReady = function () {
                if (!t.prototype.isReady.call(this)) return !1;
                for (var e in this._textures) {
                    var i = this._textures[e];
                    if (!i.isReady()) return !1;
                }
                return !0;
            }),
            (i.prototype.render = function (e) {
                this._animate && ((this._time += 0.03 * this.getScene().getAnimationRatio()), this.updateShaderUniforms()), t.prototype.render.call(this, e);
            }),
            (i.prototype.updateTextures = function () {
                for (var t = 0; t < this._config.sampler2Ds.length; t++) this.setTexture(this._config.sampler2Ds[t].sample2Dname, new e.Texture(this._texturePath + "/" + this._config.sampler2Ds[t].textureRelativeUrl, this.getScene()));
            }),
            (i.prototype.updateShaderUniforms = function () {
                if (this._config)
                    for (var t = 0; t < this._config.uniforms.length; t++) {
                        var i = this._config.uniforms[t];
                        switch (i.type) {
                            case "float":
                                this.setFloat(i.name, i.value);
                                break;
                            case "color3":
                                this.setColor3(i.name, new e.Color3(i.r, i.g, i.b));
                                break;
                            case "color4":
                                this.setColor4(i.name, new e.Color4(i.r, i.g, i.b, i.a));
                                break;
                            case "vector2":
                                this.setVector2(i.name, new e.Vector2(i.x, i.y));
                                break;
                            case "vector3":
                                this.setVector3(i.name, new e.Vector3(i.x, i.y, i.z));
                        }
                    }
                this.setFloat("time", this._time);
            }),
            Object.defineProperty(i.prototype, "animate", {
                get: function () {
                    return this._animate;
                },
                set: function (e) {
                    this._animate = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            i
        );
    })(e.ProceduralTexture);
    e.CustomProceduralTexture = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o, s) {
            t.call(this, i, r, "wood", n, o, s), (this._ampScale = 100), (this._woodColor = new e.Color3(0.32, 0.17, 0.09)), this.updateShaderUniforms(), (this.refreshRate = 0);
        }
        return (
            __extends(i, t),
            (i.prototype.updateShaderUniforms = function () {
                this.setFloat("ampScale", this._ampScale), this.setColor3("woodColor", this._woodColor);
            }),
            Object.defineProperty(i.prototype, "ampScale", {
                get: function () {
                    return this._ampScale;
                },
                set: function (e) {
                    (this._ampScale = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "woodColor", {
                get: function () {
                    return this._woodColor;
                },
                set: function (e) {
                    (this._woodColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            i
        );
    })(e.ProceduralTexture);
    e.WoodProceduralTexture = t;
    var i = (function (t) {
        function i(r, n, o, s, a) {
            t.call(this, r, n, "fire", o, s, a),
                (this._time = 0),
                (this._speed = new e.Vector2(0.5, 0.3)),
                (this._autoGenerateTime = !0),
                (this._alphaThreshold = 0.5),
                (this._fireColors = i.RedFireColors),
                this.updateShaderUniforms(),
                (this.refreshRate = 1);
        }
        return (
            __extends(i, t),
            (i.prototype.updateShaderUniforms = function () {
                this.setFloat("time", this._time),
                    this.setVector2("speed", this._speed),
                    this.setColor3("c1", this._fireColors[0]),
                    this.setColor3("c2", this._fireColors[1]),
                    this.setColor3("c3", this._fireColors[2]),
                    this.setColor3("c4", this._fireColors[3]),
                    this.setColor3("c5", this._fireColors[4]),
                    this.setColor3("c6", this._fireColors[5]),
                    this.setFloat("alphaThreshold", this._alphaThreshold);
            }),
            (i.prototype.render = function (e) {
                this._autoGenerateTime && ((this._time += 0.03 * this.getScene().getAnimationRatio()), this.updateShaderUniforms()), t.prototype.render.call(this, e);
            }),
            Object.defineProperty(i, "PurpleFireColors", {
                get: function () {
                    return [new e.Color3(0.5, 0, 1), new e.Color3(0.9, 0, 1), new e.Color3(0.2, 0, 1), new e.Color3(1, 0.9, 1), new e.Color3(0.1, 0.1, 1), new e.Color3(0.9, 0.9, 1)];
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i, "GreenFireColors", {
                get: function () {
                    return [new e.Color3(0.5, 1, 0), new e.Color3(0.5, 1, 0), new e.Color3(0.3, 0.4, 0), new e.Color3(0.5, 1, 0), new e.Color3(0.2, 0, 0), new e.Color3(0.5, 1, 0)];
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i, "RedFireColors", {
                get: function () {
                    return [new e.Color3(0.5, 0, 0.1), new e.Color3(0.9, 0, 0), new e.Color3(0.2, 0, 0), new e.Color3(1, 0.9, 0), new e.Color3(0.1, 0.1, 0.1), new e.Color3(0.9, 0.9, 0.9)];
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i, "BlueFireColors", {
                get: function () {
                    return [new e.Color3(0.1, 0, 0.5), new e.Color3(0, 0, 0.5), new e.Color3(0.1, 0, 0.2), new e.Color3(0, 0, 1), new e.Color3(0.1, 0.2, 0.3), new e.Color3(0, 0.2, 0.9)];
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "fireColors", {
                get: function () {
                    return this._fireColors;
                },
                set: function (e) {
                    (this._fireColors = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "time", {
                get: function () {
                    return this._time;
                },
                set: function (e) {
                    (this._time = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "speed", {
                get: function () {
                    return this._speed;
                },
                set: function (e) {
                    (this._speed = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "alphaThreshold", {
                get: function () {
                    return this._alphaThreshold;
                },
                set: function (e) {
                    (this._alphaThreshold = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            i
        );
    })(e.ProceduralTexture);
    e.FireProceduralTexture = i;
    var r = (function (t) {
        function i(i, r, n, o, s) {
            t.call(this, i, r, "cloud", n, o, s), (this._skyColor = new e.Color4(0.15, 0.68, 1, 1)), (this._cloudColor = new e.Color4(1, 1, 1, 1)), this.updateShaderUniforms(), (this.refreshRate = 0);
        }
        return (
            __extends(i, t),
            (i.prototype.updateShaderUniforms = function () {
                this.setColor4("skyColor", this._skyColor), this.setColor4("cloudColor", this._cloudColor);
            }),
            Object.defineProperty(i.prototype, "skyColor", {
                get: function () {
                    return this._skyColor;
                },
                set: function (e) {
                    (this._skyColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "cloudColor", {
                get: function () {
                    return this._cloudColor;
                },
                set: function (e) {
                    (this._cloudColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            i
        );
    })(e.ProceduralTexture);
    e.CloudProceduralTexture = r;
    var n = (function (t) {
        function i(i, r, n, o, s) {
            t.call(this, i, r, "grass", n, o, s),
                (this._herb1 = new e.Color3(0.29, 0.38, 0.02)),
                (this._herb2 = new e.Color3(0.36, 0.49, 0.09)),
                (this._herb3 = new e.Color3(0.51, 0.6, 0.28)),
                (this._groundColor = new e.Color3(1, 1, 1)),
                (this._grassColors = [new e.Color3(0.29, 0.38, 0.02), new e.Color3(0.36, 0.49, 0.09), new e.Color3(0.51, 0.6, 0.28)]),
                this.updateShaderUniforms(),
                (this.refreshRate = 0);
        }
        return (
            __extends(i, t),
            (i.prototype.updateShaderUniforms = function () {
                this.setColor3("herb1Color", this._grassColors[0]), this.setColor3("herb2Color", this._grassColors[1]), this.setColor3("herb3Color", this._grassColors[2]), this.setColor3("groundColor", this._groundColor);
            }),
            Object.defineProperty(i.prototype, "grassColors", {
                get: function () {
                    return this._grassColors;
                },
                set: function (e) {
                    (this._grassColors = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "groundColor", {
                get: function () {
                    return this._groundColor;
                },
                set: function (e) {
                    (this.groundColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            i
        );
    })(e.ProceduralTexture);
    e.GrassProceduralTexture = n;
    var o = (function (t) {
        function i(i, r, n, o, s) {
            t.call(this, i, r, "road", n, o, s), (this._roadColor = new e.Color3(0.53, 0.53, 0.53)), this.updateShaderUniforms(), (this.refreshRate = 0);
        }
        return (
            __extends(i, t),
            (i.prototype.updateShaderUniforms = function () {
                this.setColor3("roadColor", this._roadColor);
            }),
            Object.defineProperty(i.prototype, "roadColor", {
                get: function () {
                    return this._roadColor;
                },
                set: function (e) {
                    (this._roadColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            i
        );
    })(e.ProceduralTexture);
    e.RoadProceduralTexture = o;
    var s = (function (t) {
        function i(i, r, n, o, s) {
            t.call(this, i, r, "brick", n, o, s),
                (this._numberOfBricksHeight = 15),
                (this._numberOfBricksWidth = 5),
                (this._jointColor = new e.Color3(0.72, 0.72, 0.72)),
                (this._brickColor = new e.Color3(0.77, 0.47, 0.4)),
                this.updateShaderUniforms(),
                (this.refreshRate = 0);
        }
        return (
            __extends(i, t),
            (i.prototype.updateShaderUniforms = function () {
                this.setFloat("numberOfBricksHeight", this._numberOfBricksHeight),
                    this.setFloat("numberOfBricksWidth", this._numberOfBricksWidth),
                    this.setColor3("brickColor", this._brickColor),
                    this.setColor3("jointColor", this._jointColor);
            }),
            Object.defineProperty(i.prototype, "numberOfBricksHeight", {
                get: function () {
                    return this._numberOfBricksHeight;
                },
                set: function (e) {
                    (this._numberOfBricksHeight = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "numberOfBricksWidth", {
                get: function () {
                    return this._numberOfBricksWidth;
                },
                set: function (e) {
                    (this._numberOfBricksWidth = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "jointColor", {
                get: function () {
                    return this._jointColor;
                },
                set: function (e) {
                    (this._jointColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "brickColor", {
                get: function () {
                    return this._brickColor;
                },
                set: function (e) {
                    (this._brickColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            i
        );
    })(e.ProceduralTexture);
    e.BrickProceduralTexture = s;
    var a = (function (t) {
        function i(i, r, n, o, s) {
            t.call(this, i, r, "marble", n, o, s),
                (this._numberOfTilesHeight = 3),
                (this._numberOfTilesWidth = 3),
                (this._amplitude = 9),
                (this._marbleColor = new e.Color3(0.77, 0.47, 0.4)),
                (this._jointColor = new e.Color3(0.72, 0.72, 0.72)),
                this.updateShaderUniforms(),
                (this.refreshRate = 0);
        }
        return (
            __extends(i, t),
            (i.prototype.updateShaderUniforms = function () {
                this.setFloat("numberOfTilesHeight", this._numberOfTilesHeight),
                    this.setFloat("numberOfTilesWidth", this._numberOfTilesWidth),
                    this.setFloat("amplitude", this._amplitude),
                    this.setColor3("marbleColor", this._marbleColor),
                    this.setColor3("jointColor", this._jointColor);
            }),
            Object.defineProperty(i.prototype, "numberOfTilesHeight", {
                get: function () {
                    return this._numberOfTilesHeight;
                },
                set: function (e) {
                    (this._numberOfTilesHeight = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "numberOfTilesWidth", {
                get: function () {
                    return this._numberOfTilesWidth;
                },
                set: function (e) {
                    (this._numberOfTilesWidth = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "jointColor", {
                get: function () {
                    return this._jointColor;
                },
                set: function (e) {
                    (this._jointColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(i.prototype, "marbleColor", {
                get: function () {
                    return this._marbleColor;
                },
                set: function (e) {
                    (this._marbleColor = e), this.updateShaderUniforms();
                },
                enumerable: !0,
                configurable: !0,
            }),
            i
        );
    })(e.ProceduralTexture);
    e.MarbleProceduralTexture = a;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e() {
            (this._defines = {}), (this._currentRank = 32), (this._maxRank = -1);
        }
        return (
            (e.prototype.addFallback = function (e, t) {
                this._defines[e] || (e < this._currentRank && (this._currentRank = e), e > this._maxRank && (this._maxRank = e), (this._defines[e] = new Array())), this._defines[e].push(t);
            }),
            Object.defineProperty(e.prototype, "isMoreFallbacks", {
                get: function () {
                    return this._currentRank <= this._maxRank;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (e.prototype.reduce = function (e) {
                for (var t = this._defines[this._currentRank], i = 0; i < t.length; i++) e = e.replace("#define " + t[i], "");
                return this._currentRank++, e;
            }),
            e
        );
    })();
    e.EffectFallbacks = t;
    var i = (function () {
        function t(e, t, i, r, n, o, s, a, h) {
            var l = this;
            (this._isReady = !1),
                (this._compilationError = ""),
                (this._valueCache = []),
                (this._engine = n),
                (this.name = e),
                (this.defines = o),
                (this._uniformsNames = i.concat(r)),
                (this._samplers = r),
                (this._attributesNames = t),
                (this.onError = h),
                (this.onCompiled = a);
            var c, u;
            e.vertexElement ? ((c = document.getElementById(e.vertexElement)), c || (c = e.vertexElement)) : (c = e.vertex || e),
                e.fragmentElement ? ((u = document.getElementById(e.fragmentElement)), u || (u = e.fragmentElement)) : (u = e.fragment || e),
                this._loadVertexShader(c, function (e) {
                    l._loadFragmentShader(u, function (i) {
                        l._prepareEffect(e, i, t, o, s);
                    });
                });
        }
        return (
            (t.prototype.isReady = function () {
                return this._isReady;
            }),
            (t.prototype.getProgram = function () {
                return this._program;
            }),
            (t.prototype.getAttributesNames = function () {
                return this._attributesNames;
            }),
            (t.prototype.getAttributeLocation = function (e) {
                return this._attributes[e];
            }),
            (t.prototype.getAttributeLocationByName = function (e) {
                var t = this._attributesNames.indexOf(e);
                return this._attributes[t];
            }),
            (t.prototype.getAttributesCount = function () {
                return this._attributes.length;
            }),
            (t.prototype.getUniformIndex = function (e) {
                return this._uniformsNames.indexOf(e);
            }),
            (t.prototype.getUniform = function (e) {
                return this._uniforms[this._uniformsNames.indexOf(e)];
            }),
            (t.prototype.getSamplers = function () {
                return this._samplers;
            }),
            (t.prototype.getCompilationError = function () {
                return this._compilationError;
            }),
            (t.prototype._loadVertexShader = function (i, r) {
                if (i instanceof HTMLElement) {
                    var n = e.Tools.GetDOMTextContent(i);
                    return void r(n);
                }
                if (t.ShadersStore[i + "VertexShader"]) return void r(t.ShadersStore[i + "VertexShader"]);
                var o;
                (o = "." === i[0] || "/" === i[0] ? i : e.Engine.ShadersRepository + i), e.Tools.LoadFile(o + ".vertex.fx", r);
            }),
            (t.prototype._loadFragmentShader = function (i, r) {
                if (i instanceof HTMLElement) {
                    var n = e.Tools.GetDOMTextContent(i);
                    return void r(n);
                }
                if (t.ShadersStore[i + "PixelShader"]) return void r(t.ShadersStore[i + "PixelShader"]);
                if (t.ShadersStore[i + "FragmentShader"]) return void r(t.ShadersStore[i + "FragmentShader"]);
                var o;
                (o = "." === i[0] || "/" === i[0] ? i : e.Engine.ShadersRepository + i), e.Tools.LoadFile(o + ".fragment.fx", r);
            }),
            (t.prototype._prepareEffect = function (t, i, r, n, o) {
                try {
                    var s = this._engine;
                    s.getCaps().highPrecisionShaderSupported || ((t = t.replace("precision highp float", "precision mediump float")), (i = i.replace("precision highp float", "precision mediump float"))),
                        (this._program = s.createShaderProgram(t, i, n)),
                        (this._uniforms = s.getUniforms(this._program, this._uniformsNames)),
                        (this._attributes = s.getAttributes(this._program, r));
                    for (var a = 0; a < this._samplers.length; a++) {
                        var h = this.getUniform(this._samplers[a]);
                        null == h && (this._samplers.splice(a, 1), a--);
                    }
                    s.bindSamplers(this), (this._isReady = !0), this.onCompiled && this.onCompiled(this);
                } catch (l) {
                    if (-1 !== l.message.indexOf("highp"))
                        return (t = t.replace("precision highp float", "precision mediump float")), (i = i.replace("precision highp float", "precision mediump float")), void this._prepareEffect(t, i, r, n, o);
                    o && o.isMoreFallbacks
                        ? ((n = o.reduce(n)), this._prepareEffect(t, i, r, n, o))
                        : (e.Tools.Error("Unable to compile effect: "),
                          this.name.vertexElement
                              ? (e.Tools.Error("Vertex shader:" + this.name.vertexElement), e.Tools.Error("Fragment shader:" + this.name.fragmentElement))
                              : this.name.vertex
                              ? (e.Tools.Error("Vertex shader:" + this.name.vertex), e.Tools.Error("Fragment shader:" + this.name.fragment))
                              : (e.Tools.Error("Vertex shader:" + this.name), e.Tools.Error("Fragment shader:" + this.name)),
                          e.Tools.Error("Defines: " + n),
                          e.Tools.Error("Error: " + l.message),
                          (this._compilationError = l.message),
                          this.onError && this.onError(this, this._compilationError));
                }
            }),
            (t.prototype._bindTexture = function (e, t) {
                this._engine._bindTexture(this._samplers.indexOf(e), t);
            }),
            (t.prototype.setTexture = function (e, t) {
                this._engine.setTexture(this._samplers.indexOf(e), t);
            }),
            (t.prototype.setTextureFromPostProcess = function (e, t) {
                this._engine.setTextureFromPostProcess(this._samplers.indexOf(e), t);
            }),
            (t.prototype._cacheFloat2 = function (e, t, i) {
                return this._valueCache[e] ? ((this._valueCache[e][0] = t), void (this._valueCache[e][1] = i)) : void (this._valueCache[e] = [t, i]);
            }),
            (t.prototype._cacheFloat3 = function (e, t, i, r) {
                return this._valueCache[e] ? ((this._valueCache[e][0] = t), (this._valueCache[e][1] = i), void (this._valueCache[e][2] = r)) : void (this._valueCache[e] = [t, i, r]);
            }),
            (t.prototype._cacheFloat4 = function (e, t, i, r, n) {
                return this._valueCache[e] ? ((this._valueCache[e][0] = t), (this._valueCache[e][1] = i), (this._valueCache[e][2] = r), void (this._valueCache[e][3] = n)) : void (this._valueCache[e] = [t, i, r, n]);
            }),
            (t.prototype.setArray = function (e, t) {
                return this._engine.setArray(this.getUniform(e), t), this;
            }),
            (t.prototype.setArray2 = function (e, t) {
                return this._engine.setArray2(this.getUniform(e), t), this;
            }),
            (t.prototype.setArray3 = function (e, t) {
                return this._engine.setArray3(this.getUniform(e), t), this;
            }),
            (t.prototype.setArray4 = function (e, t) {
                return this._engine.setArray4(this.getUniform(e), t), this;
            }),
            (t.prototype.setMatrices = function (e, t) {
                return this._engine.setMatrices(this.getUniform(e), t), this;
            }),
            (t.prototype.setMatrix = function (e, t) {
                return this._engine.setMatrix(this.getUniform(e), t), this;
            }),
            (t.prototype.setMatrix3x3 = function (e, t) {
                return this._engine.setMatrix3x3(this.getUniform(e), t), this;
            }),
            (t.prototype.setMatrix2x2 = function (e, t) {
                return this._engine.setMatrix2x2(this.getUniform(e), t), this;
            }),
            (t.prototype.setFloat = function (e, t) {
                return this._valueCache[e] && this._valueCache[e] === t ? this : ((this._valueCache[e] = t), this._engine.setFloat(this.getUniform(e), t), this);
            }),
            (t.prototype.setBool = function (e, t) {
                return this._valueCache[e] && this._valueCache[e] === t ? this : ((this._valueCache[e] = t), this._engine.setBool(this.getUniform(e), t ? 1 : 0), this);
            }),
            (t.prototype.setVector2 = function (e, t) {
                return this._valueCache[e] && this._valueCache[e][0] === t.x && this._valueCache[e][1] === t.y ? this : (this._cacheFloat2(e, t.x, t.y), this._engine.setFloat2(this.getUniform(e), t.x, t.y), this);
            }),
            (t.prototype.setFloat2 = function (e, t, i) {
                return this._valueCache[e] && this._valueCache[e][0] === t && this._valueCache[e][1] === i ? this : (this._cacheFloat2(e, t, i), this._engine.setFloat2(this.getUniform(e), t, i), this);
            }),
            (t.prototype.setVector3 = function (e, t) {
                return this._valueCache[e] && this._valueCache[e][0] === t.x && this._valueCache[e][1] === t.y && this._valueCache[e][2] === t.z
                    ? this
                    : (this._cacheFloat3(e, t.x, t.y, t.z), this._engine.setFloat3(this.getUniform(e), t.x, t.y, t.z), this);
            }),
            (t.prototype.setFloat3 = function (e, t, i, r) {
                return this._valueCache[e] && this._valueCache[e][0] === t && this._valueCache[e][1] === i && this._valueCache[e][2] === r ? this : (this._cacheFloat3(e, t, i, r), this._engine.setFloat3(this.getUniform(e), t, i, r), this);
            }),
            (t.prototype.setVector4 = function (e, t) {
                return this._valueCache[e] && this._valueCache[e][0] === t.x && this._valueCache[e][1] === t.y && this._valueCache[e][2] === t.z && this._valueCache[e][3] === t.w
                    ? this
                    : (this._cacheFloat4(e, t.x, t.y, t.z, t.w), this._engine.setFloat4(this.getUniform(e), t.x, t.y, t.z, t.w), this);
            }),
            (t.prototype.setFloat4 = function (e, t, i, r, n) {
                return this._valueCache[e] && this._valueCache[e][0] === t && this._valueCache[e][1] === i && this._valueCache[e][2] === r && this._valueCache[e][3] === n
                    ? this
                    : (this._cacheFloat4(e, t, i, r, n), this._engine.setFloat4(this.getUniform(e), t, i, r, n), this);
            }),
            (t.prototype.setColor3 = function (e, t) {
                return this._valueCache[e] && this._valueCache[e][0] === t.r && this._valueCache[e][1] === t.g && this._valueCache[e][2] === t.b
                    ? this
                    : (this._cacheFloat3(e, t.r, t.g, t.b), this._engine.setColor3(this.getUniform(e), t), this);
            }),
            (t.prototype.setColor4 = function (e, t, i) {
                return this._valueCache[e] && this._valueCache[e][0] === t.r && this._valueCache[e][1] === t.g && this._valueCache[e][2] === t.b && this._valueCache[e][3] === i
                    ? this
                    : (this._cacheFloat4(e, t.r, t.g, t.b, i), this._engine.setColor4(this.getUniform(e), t, i), this);
            }),
            (t.ShadersStore = {}),
            t
        );
    })();
    e.Effect = i;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(i, r, n) {
            (this.name = i),
                (this.checkReadyOnEveryCall = !0),
                (this.checkReadyOnlyOnce = !1),
                (this.state = ""),
                (this.alpha = 1),
                (this.backFaceCulling = !0),
                (this.sideOrientation = t.CounterClockWiseSideOrientation),
                (this.alphaMode = e.Engine.ALPHA_COMBINE),
                (this.disableDepthWrite = !1),
                (this.fogEnabled = !0),
                (this._wasPreviouslyReady = !1),
                (this._fillMode = t.TriangleFillMode),
                (this.pointSize = 1),
                (this.zOffset = 0),
                (this.id = i),
                (this._scene = r),
                n || r.materials.push(this);
        }
        return (
            Object.defineProperty(t, "TriangleFillMode", {
                get: function () {
                    return t._TriangleFillMode;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "WireFrameFillMode", {
                get: function () {
                    return t._WireFrameFillMode;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "PointFillMode", {
                get: function () {
                    return t._PointFillMode;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ClockWiseSideOrientation", {
                get: function () {
                    return t._ClockWiseSideOrientation;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "CounterClockWiseSideOrientation", {
                get: function () {
                    return t._CounterClockWiseSideOrientation;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "wireframe", {
                get: function () {
                    return this._fillMode === t.WireFrameFillMode;
                },
                set: function (e) {
                    this._fillMode = e ? t.WireFrameFillMode : t.TriangleFillMode;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "pointsCloud", {
                get: function () {
                    return this._fillMode === t.PointFillMode;
                },
                set: function (e) {
                    this._fillMode = e ? t.PointFillMode : t.TriangleFillMode;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "fillMode", {
                get: function () {
                    return this._fillMode;
                },
                set: function (e) {
                    this._fillMode = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype.isReady = function (e, t) {
                return !0;
            }),
            (t.prototype.getEffect = function () {
                return this._effect;
            }),
            (t.prototype.getScene = function () {
                return this._scene;
            }),
            (t.prototype.needAlphaBlending = function () {
                return this.alpha < 1;
            }),
            (t.prototype.needAlphaTesting = function () {
                return !1;
            }),
            (t.prototype.getAlphaTestTexture = function () {
                return null;
            }),
            (t.prototype.trackCreation = function (e, t) {}),
            (t.prototype._preBind = function () {
                var e = this._scene.getEngine();
                e.enableEffect(this._effect), e.setState(this.backFaceCulling, this.zOffset, !1, this.sideOrientation === t.ClockWiseSideOrientation);
            }),
            (t.prototype.bind = function (e, t) {
                if (((this._scene._cachedMaterial = this), this.onBind && this.onBind(this, t), this.disableDepthWrite)) {
                    var i = this._scene.getEngine();
                    (this._cachedDepthWriteState = i.getDepthWrite()), i.setDepthWrite(!1);
                }
            }),
            (t.prototype.bindOnlyWorldMatrix = function (e) {}),
            (t.prototype.unbind = function () {
                if (this.disableDepthWrite) {
                    var e = this._scene.getEngine();
                    e.setDepthWrite(this._cachedDepthWriteState);
                }
            }),
            (t.prototype.clone = function (e) {
                return null;
            }),
            (t.prototype.dispose = function (e) {
                var t = this._scene.materials.indexOf(this);
                this._scene.materials.splice(t, 1), e && this._effect && (this._scene.getEngine()._releaseEffect(this._effect), (this._effect = null)), this.onDispose && this.onDispose();
            }),
            (t.prototype.copyTo = function (e) {
                (e.checkReadyOnlyOnce = this.checkReadyOnlyOnce),
                    (e.checkReadyOnEveryCall = this.checkReadyOnEveryCall),
                    (e.alpha = this.alpha),
                    (e.fillMode = this.fillMode),
                    (e.backFaceCulling = this.backFaceCulling),
                    (e.wireframe = this.wireframe),
                    (e.fogEnabled = this.fogEnabled),
                    (e.wireframe = this.wireframe),
                    (e.zOffset = this.zOffset),
                    (e.alphaMode = this.alphaMode),
                    (e.sideOrientation = this.sideOrientation),
                    (e.disableDepthWrite = this.disableDepthWrite),
                    (e.pointSize = this.pointSize),
                    (e.pointsCloud = this.pointsCloud);
            }),
            (t._TriangleFillMode = 0),
            (t._WireFrameFillMode = 1),
            (t._PointFillMode = 2),
            (t._ClockWiseSideOrientation = 0),
            (t._CounterClockWiseSideOrientation = 1),
            t
        );
    })();
    e.Material = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = 4,
        i = (function () {
            function t() {
                (this.isEnabled = !0), (this.leftColor = e.Color3.White()), (this.rightColor = e.Color3.Black()), (this.bias = 0), (this.power = 1);
            }
            return (
                (t.prototype.clone = function () {
                    var i = new t();
                    return e.Tools.DeepCopy(this, i), new t();
                }),
                t
            );
        })();
    e.FresnelParameters = i;
    var r = (function () {
            function e() {
                (this.DIFFUSE = !1),
                    (this.AMBIENT = !1),
                    (this.OPACITY = !1),
                    (this.OPACITYRGB = !1),
                    (this.REFLECTION = !1),
                    (this.EMISSIVE = !1),
                    (this.SPECULAR = !1),
                    (this.BUMP = !1),
                    (this.SPECULAROVERALPHA = !1),
                    (this.CLIPPLANE = !1),
                    (this.ALPHATEST = !1),
                    (this.ALPHAFROMDIFFUSE = !1),
                    (this.POINTSIZE = !1),
                    (this.FOG = !1),
                    (this.LIGHT0 = !1),
                    (this.LIGHT1 = !1),
                    (this.LIGHT2 = !1),
                    (this.LIGHT3 = !1),
                    (this.SPOTLIGHT0 = !1),
                    (this.SPOTLIGHT1 = !1),
                    (this.SPOTLIGHT2 = !1),
                    (this.SPOTLIGHT3 = !1),
                    (this.HEMILIGHT0 = !1),
                    (this.HEMILIGHT1 = !1),
                    (this.HEMILIGHT2 = !1),
                    (this.HEMILIGHT3 = !1),
                    (this.POINTDIRLIGHT0 = !1),
                    (this.POINTDIRLIGHT1 = !1),
                    (this.POINTDIRLIGHT2 = !1),
                    (this.POINTDIRLIGHT3 = !1),
                    (this.SPECULARTERM = !1),
                    (this.SHADOW0 = !1),
                    (this.SHADOW1 = !1),
                    (this.SHADOW2 = !1),
                    (this.SHADOW3 = !1),
                    (this.SHADOWS = !1),
                    (this.SHADOWVSM0 = !1),
                    (this.SHADOWVSM1 = !1),
                    (this.SHADOWVSM2 = !1),
                    (this.SHADOWVSM3 = !1),
                    (this.SHADOWPCF0 = !1),
                    (this.SHADOWPCF1 = !1),
                    (this.SHADOWPCF2 = !1),
                    (this.SHADOWPCF3 = !1),
                    (this.DIFFUSEFRESNEL = !1),
                    (this.OPACITYFRESNEL = !1),
                    (this.REFLECTIONFRESNEL = !1),
                    (this.EMISSIVEFRESNEL = !1),
                    (this.FRESNEL = !1),
                    (this.NORMAL = !1),
                    (this.UV1 = !1),
                    (this.UV2 = !1),
                    (this.VERTEXCOLOR = !1),
                    (this.VERTEXALPHA = !1),
                    (this.BONES = !1),
                    (this.BONES4 = !1),
                    (this.BonesPerMesh = 0),
                    (this.INSTANCES = !1),
                    (this.GLOSSINESS = !1),
                    (this.ROUGHNESS = !1),
                    (this.EMISSIVEASILLUMINATION = !1),
                    (this.REFLECTIONFRESNELFROMSPECULAR = !1),
                    (this.LIGHTMAP = !1),
                    (this._keys = Object.keys(this));
            }
            return (
                (e.prototype.isEqual = function (e) {
                    for (var t = 0; t < this._keys.length; t++) {
                        var i = this._keys[t];
                        if (this[i] !== e[i]) return !1;
                    }
                    return !0;
                }),
                (e.prototype.cloneTo = function (e) {
                    for (var t = 0; t < this._keys.length; t++) {
                        var i = this._keys[t];
                        e[i] = this[i];
                    }
                }),
                (e.prototype.reset = function () {
                    for (var e = 0; e < this._keys.length; e++) {
                        var t = this._keys[e];
                        this[t] = "BonesPerMesh" !== t ? !1 : 0;
                    }
                }),
                (e.prototype.toString = function () {
                    for (var e = "", t = 0; t < this._keys.length; t++) {
                        var i = this._keys[t];
                        "BonesPerMesh" === i && this[i] > 0 ? (e += "#define BonesPerMesh " + this[i] + "\n") : this[i] && (e += "#define " + i + "\n");
                    }
                    return e;
                }),
                e
            );
        })(),
        n = (function (i) {
            function n(t, n) {
                var o = this;
                i.call(this, t, n),
                    (this.ambientColor = new e.Color3(0, 0, 0)),
                    (this.diffuseColor = new e.Color3(1, 1, 1)),
                    (this.specularColor = new e.Color3(1, 1, 1)),
                    (this.specularPower = 64),
                    (this.emissiveColor = new e.Color3(0, 0, 0)),
                    (this.useAlphaFromDiffuseTexture = !1),
                    (this.useEmissiveAsIllumination = !1),
                    (this.useReflectionFresnelFromSpecular = !1),
                    (this.useSpecularOverAlpha = !0),
                    (this.roughness = 0),
                    (this.lightmapThreshold = 0),
                    (this.useGlossinessFromSpecularMapAlpha = !1),
                    (this._renderTargets = new e.SmartArray(16)),
                    (this._worldViewProjectionMatrix = e.Matrix.Zero()),
                    (this._globalAmbientColor = new e.Color3(0, 0, 0)),
                    (this._scaledDiffuse = new e.Color3()),
                    (this._scaledSpecular = new e.Color3()),
                    (this._defines = new r()),
                    (this._cachedDefines = new r()),
                    (this._cachedDefines.BonesPerMesh = -1),
                    (this.getRenderTargetTextures = function () {
                        return o._renderTargets.reset(), o.reflectionTexture && o.reflectionTexture.isRenderTarget && o._renderTargets.push(o.reflectionTexture), o._renderTargets;
                    });
            }
            return (
                __extends(n, i),
                (n.prototype.needAlphaBlending = function () {
                    return this.alpha < 1 || null != this.opacityTexture || this._shouldUseAlphaFromDiffuseTexture() || (this.opacityFresnelParameters && this.opacityFresnelParameters.isEnabled);
                }),
                (n.prototype.needAlphaTesting = function () {
                    return null != this.diffuseTexture && this.diffuseTexture.hasAlpha;
                }),
                (n.prototype._shouldUseAlphaFromDiffuseTexture = function () {
                    return null != this.diffuseTexture && this.diffuseTexture.hasAlpha && this.useAlphaFromDiffuseTexture;
                }),
                (n.prototype.getAlphaTestTexture = function () {
                    return this.diffuseTexture;
                }),
                (n.prototype.isReady = function (i, r) {
                    if (this.checkReadyOnlyOnce && this._wasPreviouslyReady) return !0;
                    var o = this.getScene();
                    if (!this.checkReadyOnEveryCall && this._renderId === o.getRenderId()) return !0;
                    var s = o.getEngine(),
                        a = !1,
                        h = !1;
                    if ((this._defines.reset(), o.texturesEnabled)) {
                        if (this.diffuseTexture && n.DiffuseTextureEnabled) {
                            if (!this.diffuseTexture.isReady()) return !1;
                            (h = !0), (this._defines.DIFFUSE = !0);
                        }
                        if (this.ambientTexture && n.AmbientTextureEnabled) {
                            if (!this.ambientTexture.isReady()) return !1;
                            (h = !0), (this._defines.AMBIENT = !0);
                        }
                        if (this.opacityTexture && n.OpacityTextureEnabled) {
                            if (!this.opacityTexture.isReady()) return !1;
                            (h = !0), (this._defines.OPACITY = !0), this.opacityTexture.getAlphaFromRGB && (this._defines.OPACITYRGB = !0);
                        }
                        if (this.reflectionTexture && n.ReflectionTextureEnabled) {
                            if (!this.reflectionTexture.isReady()) return !1;
                            (a = !0), (h = !0), (this._defines.REFLECTION = !0), this.roughness > 0 && (this._defines.ROUGHNESS = !0);
                        }
                        if (this.emissiveTexture && n.EmissiveTextureEnabled) {
                            if (!this.emissiveTexture.isReady()) return !1;
                            (h = !0), (this._defines.EMISSIVE = !0);
                        }
                        if (this.lightmapTexture && n.LightmapEnabled) {
                            if (!this.lightmapTexture.isReady()) return !1;
                            (h = !0), (this._defines.LIGHTMAP = !0);
                        }
                        if (this.specularTexture && n.SpecularTextureEnabled) {
                            if (!this.specularTexture.isReady()) return !1;
                            (h = !0), (this._defines.SPECULAR = !0), (this._defines.GLOSSINESS = this.useGlossinessFromSpecularMapAlpha);
                        }
                    }
                    if (o.getEngine().getCaps().standardDerivatives && this.bumpTexture && n.BumpTextureEnabled) {
                        if (!this.bumpTexture.isReady()) return !1;
                        (h = !0), (this._defines.BUMP = !0);
                    }
                    o.clipPlane && (this._defines.CLIPPLANE = !0),
                        s.getAlphaTesting() && (this._defines.ALPHATEST = !0),
                        this._shouldUseAlphaFromDiffuseTexture() && (this._defines.ALPHAFROMDIFFUSE = !0),
                        this.useEmissiveAsIllumination && (this._defines.EMISSIVEASILLUMINATION = !0),
                        this.useReflectionFresnelFromSpecular && (this._defines.REFLECTIONFRESNELFROMSPECULAR = !0),
                        (this.pointsCloud || o.forcePointsCloud) && (this._defines.POINTSIZE = !0),
                        o.fogEnabled && i && i.applyFog && o.fogMode !== e.Scene.FOGMODE_NONE && this.fogEnabled && (this._defines.FOG = !0);
                    var l = 0;
                    if (o.lightsEnabled)
                        for (var c = 0; c < o.lights.length; c++) {
                            var u = o.lights[c];
                            if (u.isEnabled()) {
                                if (u._excludedMeshesIds.length > 0) {
                                    for (var f = 0; f < u._excludedMeshesIds.length; f++) {
                                        var d = o.getMeshByID(u._excludedMeshesIds[f]);
                                        d && u.excludedMeshes.push(d);
                                    }
                                    u._excludedMeshesIds = [];
                                }
                                if (u._includedOnlyMeshesIds.length > 0) {
                                    for (var p = 0; p < u._includedOnlyMeshesIds.length; p++) {
                                        var m = o.getMeshByID(u._includedOnlyMeshesIds[p]);
                                        m && u.includedOnlyMeshes.push(m);
                                    }
                                    u._includedOnlyMeshesIds = [];
                                }
                                if (u.canAffectMesh(i)) {
                                    (a = !0), (this._defines["LIGHT" + l] = !0);
                                    var g;
                                    if (
                                        ((g = u instanceof e.SpotLight ? "SPOTLIGHT" + l : u instanceof e.HemisphericLight ? "HEMILIGHT" + l : "POINTDIRLIGHT" + l),
                                        (this._defines[g] = !0),
                                        u.specular.equalsFloats(0, 0, 0) || (this._defines.SPECULARTERM = !0),
                                        o.shadowsEnabled)
                                    ) {
                                        var _ = u.getShadowGenerator();
                                        i &&
                                            i.receiveShadows &&
                                            _ &&
                                            ((this._defines["SHADOW" + l] = !0),
                                            (this._defines.SHADOWS = !0),
                                            (_.useVarianceShadowMap || _.useBlurVarianceShadowMap) && (this._defines["SHADOWVSM" + l] = !0),
                                            _.usePoissonSampling && (this._defines["SHADOWPCF" + l] = !0));
                                    }
                                    if ((l++, l === t)) break;
                                }
                            }
                        }
                    if (
                        (n.FresnelEnabled &&
                            ((this.diffuseFresnelParameters && this.diffuseFresnelParameters.isEnabled) ||
                                (this.opacityFresnelParameters && this.opacityFresnelParameters.isEnabled) ||
                                (this.emissiveFresnelParameters && this.emissiveFresnelParameters.isEnabled) ||
                                (this.reflectionFresnelParameters && this.reflectionFresnelParameters.isEnabled)) &&
                            (this.diffuseFresnelParameters && this.diffuseFresnelParameters.isEnabled && (this._defines.DIFFUSEFRESNEL = !0),
                            this.opacityFresnelParameters && this.opacityFresnelParameters.isEnabled && (this._defines.OPACITYFRESNEL = !0),
                            this.reflectionFresnelParameters && this.reflectionFresnelParameters.isEnabled && (this._defines.REFLECTIONFRESNEL = !0),
                            this.emissiveFresnelParameters && this.emissiveFresnelParameters.isEnabled && (this._defines.EMISSIVEFRESNEL = !0),
                            (a = !0),
                            (this._defines.FRESNEL = !0)),
                        this._defines.SPECULARTERM && this.useSpecularOverAlpha && (this._defines.SPECULAROVERALPHA = !0),
                        i &&
                            (a && i.isVerticesDataPresent(e.VertexBuffer.NormalKind) && (this._defines.NORMAL = !0),
                            h && (i.isVerticesDataPresent(e.VertexBuffer.UVKind) && (this._defines.UV1 = !0), i.isVerticesDataPresent(e.VertexBuffer.UV2Kind) && (this._defines.UV2 = !0)),
                            i.useVertexColors && i.isVerticesDataPresent(e.VertexBuffer.ColorKind) && ((this._defines.VERTEXCOLOR = !0), i.hasVertexAlpha && (this._defines.VERTEXALPHA = !0)),
                            i.useBones && i.computeBonesUsingShaders && ((this._defines.BONES = !0), (this._defines.BonesPerMesh = i.skeleton.bones.length + 1), (this._defines.BONES4 = !0)),
                            r && (this._defines.INSTANCES = !0)),
                        !this._defines.isEqual(this._cachedDefines))
                    ) {
                        this._defines.cloneTo(this._cachedDefines), o.resetCachedMaterial();
                        var v = new e.EffectFallbacks();
                        this._defines.REFLECTION && v.addFallback(0, "REFLECTION"),
                            this._defines.SPECULAR && v.addFallback(0, "SPECULAR"),
                            this._defines.BUMP && v.addFallback(0, "BUMP"),
                            this._defines.SPECULAROVERALPHA && v.addFallback(0, "SPECULAROVERALPHA"),
                            this._defines.FOG && v.addFallback(1, "FOG");
                        for (var l = 0; t > l; l++)
                            this._defines["LIGHT" + l] &&
                                (l > 0 && v.addFallback(l, "LIGHT" + l),
                                this._defines["SHADOW" + l] && v.addFallback(0, "SHADOW" + l),
                                this._defines["SHADOWPCF" + l] && v.addFallback(0, "SHADOWPCF" + l),
                                this._defines["SHADOWVSM" + l] && v.addFallback(0, "SHADOWVSM" + l));
                        this._defines.SPECULARTERM && v.addFallback(0, "SPECULARTERM"),
                            this._defines.DIFFUSEFRESNEL && v.addFallback(1, "DIFFUSEFRESNEL"),
                            this._defines.OPACITYFRESNEL && v.addFallback(2, "OPACITYFRESNEL"),
                            this._defines.REFLECTIONFRESNEL && v.addFallback(3, "REFLECTIONFRESNEL"),
                            this._defines.EMISSIVEFRESNEL && v.addFallback(4, "EMISSIVEFRESNEL"),
                            this._defines.FRESNEL && v.addFallback(4, "FRESNEL"),
                            this._defines.BONES4 && v.addFallback(0, "BONES4");
                        var y = [e.VertexBuffer.PositionKind];
                        this._defines.NORMAL && y.push(e.VertexBuffer.NormalKind),
                            this._defines.UV1 && y.push(e.VertexBuffer.UVKind),
                            this._defines.UV2 && y.push(e.VertexBuffer.UV2Kind),
                            this._defines.VERTEXCOLOR && y.push(e.VertexBuffer.ColorKind),
                            this._defines.BONES && (y.push(e.VertexBuffer.MatricesIndicesKind), y.push(e.VertexBuffer.MatricesWeightsKind)),
                            this._defines.INSTANCES && (y.push("world0"), y.push("world1"), y.push("world2"), y.push("world3"));
                        var x = "default";
                        o.getEngine().getCaps().standardDerivatives || (x = "legacydefault");
                        var M = this._defines.toString();
                        this._effect = o
                            .getEngine()
                            .createEffect(
                                x,
                                y,
                                [
                                    "world",
                                    "view",
                                    "viewProjection",
                                    "vEyePosition",
                                    "vLightsType",
                                    "vAmbientColor",
                                    "vDiffuseColor",
                                    "vSpecularColor",
                                    "vEmissiveColor",
                                    "vLightData0",
                                    "vLightDiffuse0",
                                    "vLightSpecular0",
                                    "vLightDirection0",
                                    "vLightGround0",
                                    "lightMatrix0",
                                    "vLightData1",
                                    "vLightDiffuse1",
                                    "vLightSpecular1",
                                    "vLightDirection1",
                                    "vLightGround1",
                                    "lightMatrix1",
                                    "vLightData2",
                                    "vLightDiffuse2",
                                    "vLightSpecular2",
                                    "vLightDirection2",
                                    "vLightGround2",
                                    "lightMatrix2",
                                    "vLightData3",
                                    "vLightDiffuse3",
                                    "vLightSpecular3",
                                    "vLightDirection3",
                                    "vLightGround3",
                                    "lightMatrix3",
                                    "vFogInfos",
                                    "vFogColor",
                                    "pointSize",
                                    "vDiffuseInfos",
                                    "vAmbientInfos",
                                    "vOpacityInfos",
                                    "vReflectionInfos",
                                    "vEmissiveInfos",
                                    "vSpecularInfos",
                                    "vBumpInfos",
                                    "vLightmapInfos",
                                    "mBones",
                                    "vClipPlane",
                                    "diffuseMatrix",
                                    "ambientMatrix",
                                    "opacityMatrix",
                                    "reflectionMatrix",
                                    "emissiveMatrix",
                                    "specularMatrix",
                                    "bumpMatrix",
                                    "lightmapMatrix",
                                    "shadowsInfo0",
                                    "shadowsInfo1",
                                    "shadowsInfo2",
                                    "shadowsInfo3",
                                    "diffuseLeftColor",
                                    "diffuseRightColor",
                                    "opacityParts",
                                    "reflectionLeftColor",
                                    "reflectionRightColor",
                                    "emissiveLeftColor",
                                    "emissiveRightColor",
                                    "roughness",
                                ],
                                [
                                    "diffuseSampler",
                                    "ambientSampler",
                                    "opacitySampler",
                                    "reflectionCubeSampler",
                                    "reflection2DSampler",
                                    "emissiveSampler",
                                    "specularSampler",
                                    "bumpSampler",
                                    "lightmapSampler",
                                    "shadowSampler0",
                                    "shadowSampler1",
                                    "shadowSampler2",
                                    "shadowSampler3",
                                ],
                                M,
                                v,
                                this.onCompiled,
                                this.onError
                            );
                    }
                    return this._effect.isReady() ? ((this._renderId = o.getRenderId()), (this._wasPreviouslyReady = !0), !0) : !1;
                }),
                (n.prototype.unbind = function () {
                    this.reflectionTexture && this.reflectionTexture.isRenderTarget && this._effect.setTexture("reflection2DSampler", null), i.prototype.unbind.call(this);
                }),
                (n.prototype.bindOnlyWorldMatrix = function (e) {
                    this._effect.setMatrix("world", e);
                }),
                (n.prototype.bind = function (r, o) {
                    var s = this.getScene();
                    if (
                        (this.bindOnlyWorldMatrix(r),
                        this._effect.setMatrix("viewProjection", s.getTransformMatrix()),
                        o && o.useBones && o.computeBonesUsingShaders && this._effect.setMatrices("mBones", o.skeleton.getTransformMatrices()),
                        s.getCachedMaterial() !== this)
                    ) {
                        if (
                            (n.FresnelEnabled &&
                                (this.diffuseFresnelParameters &&
                                    this.diffuseFresnelParameters.isEnabled &&
                                    (this._effect.setColor4("diffuseLeftColor", this.diffuseFresnelParameters.leftColor, this.diffuseFresnelParameters.power),
                                    this._effect.setColor4("diffuseRightColor", this.diffuseFresnelParameters.rightColor, this.diffuseFresnelParameters.bias)),
                                this.opacityFresnelParameters &&
                                    this.opacityFresnelParameters.isEnabled &&
                                    this._effect.setColor4(
                                        "opacityParts",
                                        new e.Color3(this.opacityFresnelParameters.leftColor.toLuminance(), this.opacityFresnelParameters.rightColor.toLuminance(), this.opacityFresnelParameters.bias),
                                        this.opacityFresnelParameters.power
                                    ),
                                this.reflectionFresnelParameters &&
                                    this.reflectionFresnelParameters.isEnabled &&
                                    (this._effect.setColor4("reflectionLeftColor", this.reflectionFresnelParameters.leftColor, this.reflectionFresnelParameters.power),
                                    this._effect.setColor4("reflectionRightColor", this.reflectionFresnelParameters.rightColor, this.reflectionFresnelParameters.bias)),
                                this.emissiveFresnelParameters &&
                                    this.emissiveFresnelParameters.isEnabled &&
                                    (this._effect.setColor4("emissiveLeftColor", this.emissiveFresnelParameters.leftColor, this.emissiveFresnelParameters.power),
                                    this._effect.setColor4("emissiveRightColor", this.emissiveFresnelParameters.rightColor, this.emissiveFresnelParameters.bias))),
                            this.diffuseTexture &&
                                n.DiffuseTextureEnabled &&
                                (this._effect.setTexture("diffuseSampler", this.diffuseTexture),
                                this._effect.setFloat2("vDiffuseInfos", this.diffuseTexture.coordinatesIndex, this.diffuseTexture.level),
                                this._effect.setMatrix("diffuseMatrix", this.diffuseTexture.getTextureMatrix())),
                            this.ambientTexture &&
                                n.AmbientTextureEnabled &&
                                (this._effect.setTexture("ambientSampler", this.ambientTexture),
                                this._effect.setFloat2("vAmbientInfos", this.ambientTexture.coordinatesIndex, this.ambientTexture.level),
                                this._effect.setMatrix("ambientMatrix", this.ambientTexture.getTextureMatrix())),
                            this.opacityTexture &&
                                n.OpacityTextureEnabled &&
                                (this._effect.setTexture("opacitySampler", this.opacityTexture),
                                this._effect.setFloat2("vOpacityInfos", this.opacityTexture.coordinatesIndex, this.opacityTexture.level),
                                this._effect.setMatrix("opacityMatrix", this.opacityTexture.getTextureMatrix())),
                            this.reflectionTexture &&
                                n.ReflectionTextureEnabled &&
                                (this.reflectionTexture.isCube
                                    ? (this._effect.setTexture("reflectionCubeSampler", this.reflectionTexture), this._defines.ROUGHNESS && this._effect.setFloat("roughness", this.roughness))
                                    : this._effect.setTexture("reflection2DSampler", this.reflectionTexture),
                                this._effect.setMatrix("reflectionMatrix", this.reflectionTexture.getReflectionTextureMatrix()),
                                this._effect.setFloat3("vReflectionInfos", this.reflectionTexture.coordinatesMode, this.reflectionTexture.level, this.reflectionTexture.isCube ? 1 : 0)),
                            this.emissiveTexture &&
                                n.EmissiveTextureEnabled &&
                                (this._effect.setTexture("emissiveSampler", this.emissiveTexture),
                                this._effect.setFloat2("vEmissiveInfos", this.emissiveTexture.coordinatesIndex, this.emissiveTexture.level),
                                this._effect.setMatrix("emissiveMatrix", this.emissiveTexture.getTextureMatrix())),
                            this.lightmapTexture &&
                                n.LightmapEnabled &&
                                (this._effect.setTexture("lightmapSampler", this.lightmapTexture),
                                this._effect.setFloat3("vLightmapInfos", this.lightmapTexture.coordinatesIndex, this.lightmapTexture.level, this.lightmapThreshold),
                                this._effect.setMatrix("lightmapMatrix", this.lightmapTexture.getTextureMatrix())),
                            this.specularTexture &&
                                n.SpecularTextureEnabled &&
                                (this._effect.setTexture("specularSampler", this.specularTexture),
                                this._effect.setFloat2("vSpecularInfos", this.specularTexture.coordinatesIndex, this.specularTexture.level),
                                this._effect.setMatrix("specularMatrix", this.specularTexture.getTextureMatrix())),
                            this.bumpTexture &&
                                s.getEngine().getCaps().standardDerivatives &&
                                n.BumpTextureEnabled &&
                                (this._effect.setTexture("bumpSampler", this.bumpTexture),
                                this._effect.setFloat2("vBumpInfos", this.bumpTexture.coordinatesIndex, 1 / this.bumpTexture.level),
                                this._effect.setMatrix("bumpMatrix", this.bumpTexture.getTextureMatrix())),
                            s.clipPlane)
                        ) {
                            var a = s.clipPlane;
                            this._effect.setFloat4("vClipPlane", a.normal.x, a.normal.y, a.normal.z, a.d);
                        }
                        this.pointsCloud && this._effect.setFloat("pointSize", this.pointSize),
                            s.ambientColor.multiplyToRef(this.ambientColor, this._globalAmbientColor),
                            (this._scaledSpecular.r = this.specularColor.r * e.Tools.Clamp(1 - this.emissiveColor.r)),
                            (this._scaledSpecular.g = this.specularColor.g * e.Tools.Clamp(1 - this.emissiveColor.g)),
                            (this._scaledSpecular.b = this.specularColor.b * e.Tools.Clamp(1 - this.emissiveColor.b)),
                            this._effect.setVector3("vEyePosition", s.activeCamera.position),
                            this._effect.setColor3("vAmbientColor", this._globalAmbientColor),
                            this._defines.SPECULARTERM && this._effect.setColor4("vSpecularColor", this._scaledSpecular, this.specularPower),
                            this._effect.setColor3("vEmissiveColor", this.emissiveColor);
                    }
                    if (
                        ((this._scaledDiffuse.r = this.diffuseColor.r * e.Tools.Clamp(1 - this.emissiveColor.r)),
                        (this._scaledDiffuse.g = this.diffuseColor.g * e.Tools.Clamp(1 - this.emissiveColor.g)),
                        (this._scaledDiffuse.b = this.diffuseColor.b * e.Tools.Clamp(1 - this.emissiveColor.b)),
                        this._effect.setColor4("vDiffuseColor", this._scaledDiffuse, this.alpha * o.visibility),
                        s.lightsEnabled)
                    )
                        for (var h = 0, l = 0; l < s.lights.length; l++) {
                            var c = s.lights[l];
                            if (c.isEnabled() && c.canAffectMesh(o)) {
                                if (
                                    (c instanceof e.PointLight
                                        ? c.transferToEffect(this._effect, "vLightData" + h)
                                        : c instanceof e.DirectionalLight
                                        ? c.transferToEffect(this._effect, "vLightData" + h)
                                        : c instanceof e.SpotLight
                                        ? c.transferToEffect(this._effect, "vLightData" + h, "vLightDirection" + h)
                                        : c instanceof e.HemisphericLight && c.transferToEffect(this._effect, "vLightData" + h, "vLightGround" + h),
                                    c.diffuse.scaleToRef(c.intensity, this._scaledDiffuse),
                                    this._effect.setColor4("vLightDiffuse" + h, this._scaledDiffuse, c.range),
                                    this._defines.SPECULARTERM && (c.specular.scaleToRef(c.intensity, this._scaledSpecular), this._effect.setColor3("vLightSpecular" + h, this._scaledSpecular)),
                                    s.shadowsEnabled)
                                ) {
                                    var u = c.getShadowGenerator();
                                    o.receiveShadows &&
                                        u &&
                                        (this._effect.setMatrix("lightMatrix" + h, u.getTransformMatrix()),
                                        this._effect.setTexture("shadowSampler" + h, u.getShadowMapForRendering()),
                                        this._effect.setFloat3("shadowsInfo" + h, u.getDarkness(), u.getShadowMap().getSize().width, u.bias));
                                }
                                if ((h++, h === t)) break;
                            }
                        }
                    ((s.fogEnabled && o.applyFog && s.fogMode !== e.Scene.FOGMODE_NONE) || this.reflectionTexture) && this._effect.setMatrix("view", s.getViewMatrix()),
                        s.fogEnabled && o.applyFog && s.fogMode !== e.Scene.FOGMODE_NONE && (this._effect.setFloat4("vFogInfos", s.fogMode, s.fogStart, s.fogEnd, s.fogDensity), this._effect.setColor3("vFogColor", s.fogColor)),
                        i.prototype.bind.call(this, r, o);
                }),
                (n.prototype.getAnimatables = function () {
                    var e = [];
                    return (
                        this.diffuseTexture && this.diffuseTexture.animations && this.diffuseTexture.animations.length > 0 && e.push(this.diffuseTexture),
                        this.ambientTexture && this.ambientTexture.animations && this.ambientTexture.animations.length > 0 && e.push(this.ambientTexture),
                        this.opacityTexture && this.opacityTexture.animations && this.opacityTexture.animations.length > 0 && e.push(this.opacityTexture),
                        this.reflectionTexture && this.reflectionTexture.animations && this.reflectionTexture.animations.length > 0 && e.push(this.reflectionTexture),
                        this.emissiveTexture && this.emissiveTexture.animations && this.emissiveTexture.animations.length > 0 && e.push(this.emissiveTexture),
                        this.specularTexture && this.specularTexture.animations && this.specularTexture.animations.length > 0 && e.push(this.specularTexture),
                        this.bumpTexture && this.bumpTexture.animations && this.bumpTexture.animations.length > 0 && e.push(this.bumpTexture),
                        e
                    );
                }),
                (n.prototype.dispose = function (e) {
                    this.diffuseTexture && this.diffuseTexture.dispose(),
                        this.ambientTexture && this.ambientTexture.dispose(),
                        this.opacityTexture && this.opacityTexture.dispose(),
                        this.reflectionTexture && this.reflectionTexture.dispose(),
                        this.emissiveTexture && this.emissiveTexture.dispose(),
                        this.specularTexture && this.specularTexture.dispose(),
                        this.bumpTexture && this.bumpTexture.dispose(),
                        i.prototype.dispose.call(this, e);
                }),
                (n.prototype.clone = function (e) {
                    var t = new n(e, this.getScene());
                    return (
                        this.copyTo(t),
                        this.diffuseTexture && this.diffuseTexture.clone && (t.diffuseTexture = this.diffuseTexture.clone()),
                        this.ambientTexture && this.ambientTexture.clone && (t.ambientTexture = this.ambientTexture.clone()),
                        this.opacityTexture && this.opacityTexture.clone && (t.opacityTexture = this.opacityTexture.clone()),
                        this.reflectionTexture && this.reflectionTexture.clone && (t.reflectionTexture = this.reflectionTexture.clone()),
                        this.emissiveTexture && this.emissiveTexture.clone && (t.emissiveTexture = this.emissiveTexture.clone()),
                        this.specularTexture && this.specularTexture.clone && (t.specularTexture = this.specularTexture.clone()),
                        this.bumpTexture && this.bumpTexture.clone && (t.bumpTexture = this.bumpTexture.clone()),
                        this.lightmapTexture && this.lightmapTexture.clone && ((t.bumpTexture = this.bumpTexture.clone()), (t.lightmapTexture = this.lightmapTexture.clone()), (t.lightmapThreshold = this.lightmapThreshold)),
                        (t.ambientColor = this.ambientColor.clone()),
                        (t.diffuseColor = this.diffuseColor.clone()),
                        (t.specularColor = this.specularColor.clone()),
                        (t.specularPower = this.specularPower),
                        (t.emissiveColor = this.emissiveColor.clone()),
                        (t.useAlphaFromDiffuseTexture = this.useAlphaFromDiffuseTexture),
                        (t.useEmissiveAsIllumination = this.useEmissiveAsIllumination),
                        (t.useGlossinessFromSpecularMapAlpha = this.useGlossinessFromSpecularMapAlpha),
                        (t.useReflectionFresnelFromSpecular = this.useReflectionFresnelFromSpecular),
                        (t.useSpecularOverAlpha = this.useSpecularOverAlpha),
                        (t.roughness = this.roughness),
                        (t.diffuseFresnelParameters = this.diffuseFresnelParameters.clone()),
                        (t.emissiveFresnelParameters = this.emissiveFresnelParameters.clone()),
                        (t.reflectionFresnelParameters = this.reflectionFresnelParameters.clone()),
                        (t.opacityFresnelParameters = this.opacityFresnelParameters.clone()),
                        t
                    );
                }),
                (n.DiffuseTextureEnabled = !0),
                (n.AmbientTextureEnabled = !0),
                (n.OpacityTextureEnabled = !0),
                (n.ReflectionTextureEnabled = !0),
                (n.EmissiveTextureEnabled = !0),
                (n.SpecularTextureEnabled = !0),
                (n.BumpTextureEnabled = !0),
                (n.FresnelEnabled = !0),
                (n.LightmapEnabled = !0),
                n
            );
        })(e.Material);
    e.StandardMaterial = n;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i) {
            e.call(this, t, i, !0), (this.subMaterials = new Array()), i.multiMaterials.push(this);
        }
        return (
            __extends(t, e),
            (t.prototype.getSubMaterial = function (e) {
                return 0 > e || e >= this.subMaterials.length ? this.getScene().defaultMaterial : this.subMaterials[e];
            }),
            (t.prototype.isReady = function (e) {
                for (var t = 0; t < this.subMaterials.length; t++) {
                    var i = this.subMaterials[t];
                    if (i && !this.subMaterials[t].isReady(e)) return !1;
                }
                return !0;
            }),
            (t.prototype.clone = function (e) {
                for (var i = new t(e, this.getScene()), r = 0; r < this.subMaterials.length; r++) {
                    var n = this.subMaterials[r];
                    i.subMaterials.push(n);
                }
                return i;
            }),
            t
        );
    })(e.Material);
    e.MultiMaterial = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t() {}
        return (
            Object.defineProperty(t, "ForceFullSceneLoadingForIncremental", {
                get: function () {
                    return t._ForceFullSceneLoadingForIncremental;
                },
                set: function (e) {
                    t._ForceFullSceneLoadingForIncremental = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ShowLoadingScreen", {
                get: function () {
                    return t._ShowLoadingScreen;
                },
                set: function (e) {
                    t._ShowLoadingScreen = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t._getPluginForFilename = function (e) {
                var t = e.lastIndexOf("."),
                    i = e.indexOf("?");
                -1 === i && (i = e.length);
                for (var r = e.substring(t, i).toLowerCase(), n = 0; n < this._registeredPlugins.length; n++) {
                    var o = this._registeredPlugins[n];
                    if (-1 !== o.extensions.indexOf(r)) return o;
                }
                return this._registeredPlugins[this._registeredPlugins.length - 1];
            }),
            (t.RegisterPlugin = function (e) {
                (e.extensions = e.extensions.toLowerCase()), t._registeredPlugins.push(e);
            }),
            (t.ImportMesh = function (i, r, n, o, s, a, h) {
                if (n.substr && "/" === n.substr(0, 1)) return void e.Tools.Error("Wrong sceneFilename parameter");
                var l = {};
                o._addPendingData(l);
                var c = function (c) {
                    o.database = u;
                    var f = t._getPluginForFilename(n),
                        d = function (e) {
                            var t = [],
                                a = [],
                                c = [];
                            try {
                                if (!f.importMesh(i, o, e, r, t, a, c)) return h && h(o, "Unable to import meshes from " + r + n), void o._removePendingData(l);
                            } catch (u) {
                                return h && h(o, "Unable to import meshes from " + r + n + " (Exception: " + u + ")"), void o._removePendingData(l);
                            }
                            s && (o.importedMeshesFiles.push(r + n), s(t, a, c), o._removePendingData(l));
                        };
                    return n.substr && "data:" === n.substr(0, 5)
                        ? void d(n.substr(5))
                        : void e.Tools.LoadFile(
                              r + n,
                              function (e) {
                                  d(e);
                              },
                              a,
                              u
                          );
                };
                if (o.getEngine().enableOfflineSupport) var u = new e.Database(r + n, c);
                else c(!0);
            }),
            (t.Load = function (i, r, n, o, s, a) {
                t.Append(i, r, new e.Scene(n), o, s, a);
            }),
            (t.Append = function (i, r, n, o, s, a) {
                if (r.substr && "/" === r.substr(0, 1)) return void e.Tools.Error("Wrong sceneFilename parameter");
                var h,
                    l = this._getPluginForFilename(r.name || r),
                    c = {};
                n._addPendingData(c), t.ShowLoadingScreen && n.getEngine().displayLoadingUI();
                var u = function (e) {
                        return (
                            (n.database = h),
                            l.load(n, e, i)
                                ? (o && o(n),
                                  n._removePendingData(c),
                                  void (
                                      t.ShowLoadingScreen &&
                                      n.executeWhenReady(function () {
                                          n.getEngine().hideLoadingUI();
                                      })
                                  ))
                                : (a && a(n), n._removePendingData(c), void n.getEngine().hideLoadingUI())
                        );
                    },
                    f = function (t) {
                        e.Tools.LoadFile(i + r, u, s, h);
                    };
                return r.substr && "data:" === r.substr(0, 5) ? void u(r.substr(5)) : void (-1 === i.indexOf("file:") ? (n.getEngine().enableOfflineSupport ? (h = new e.Database(i + r, f)) : f(!0)) : e.Tools.ReadFile(r, u, s));
            }),
            (t._ForceFullSceneLoadingForIncremental = !1),
            (t._ShowLoadingScreen = !0),
            (t._registeredPlugins = new Array()),
            t
        );
    })();
    e.SceneLoader = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t;
    !(function (t) {
        var i = function (e, t) {
                if (e.length === 3 * t) {
                    for (var i = [], r = 0; r < e.length; r += 3) {
                        var n = (r / 3) * 4;
                        (i[n] = e[r]), (i[n + 1] = e[r + 1]), (i[n + 2] = e[r + 2]), (i[n + 3] = 1);
                    }
                    return i;
                }
                return e;
            },
            r = function (t, i, r) {
                var n = null;
                return (!i.name && !i.extensions) || i.isRenderTarget || ((n = new e.CubeTexture(t + i.name, r, i.extensions)), (n.name = i.name), (n.hasAlpha = i.hasAlpha), (n.level = i.level), (n.coordinatesMode = i.coordinatesMode)), n;
            },
            n = function (t, i, n) {
                if (i.isCube) return r(t, i, n);
                if (!i.name && !i.isRenderTarget) return null;
                var o;
                if (
                    (i.mirrorPlane
                        ? ((o = new e.MirrorTexture(i.name, i.renderTargetSize, n)), (o._waitingRenderList = i.renderList), (o.mirrorPlane = e.Plane.FromArray(i.mirrorPlane)))
                        : i.isRenderTarget
                        ? ((o = new e.RenderTargetTexture(i.name, i.renderTargetSize, n)), (o._waitingRenderList = i.renderList))
                        : (o = i.base64String ? e.Texture.CreateFromBase64String(i.base64String, i.name, n) : new e.Texture(t + i.name, n)),
                    (o.name = i.name),
                    (o.hasAlpha = i.hasAlpha),
                    (o.getAlphaFromRGB = i.getAlphaFromRGB),
                    (o.level = i.level),
                    (o.coordinatesIndex = i.coordinatesIndex),
                    (o.coordinatesMode = i.coordinatesMode),
                    (o.uOffset = i.uOffset),
                    (o.vOffset = i.vOffset),
                    (o.uScale = i.uScale),
                    (o.vScale = i.vScale),
                    (o.uAng = i.uAng),
                    (o.vAng = i.vAng),
                    (o.wAng = i.wAng),
                    (o.wrapU = i.wrapU),
                    (o.wrapV = i.wrapV),
                    i.animations)
                )
                    for (var s = 0; s < i.animations.length; s++) {
                        var a = i.animations[s];
                        o.animations.push(d(a));
                    }
                return o;
            },
            o = function (t, i) {
                for (var r = new e.Skeleton(t.name, t.id, i), n = 0; n < t.bones.length; n++) {
                    var o = t.bones[n],
                        s = null;
                    o.parentBoneIndex > -1 && (s = r.bones[o.parentBoneIndex]);
                    var a = new e.Bone(o.name, r, s, e.Matrix.FromArray(o.matrix));
                    o.animation && a.animations.push(d(o.animation));
                }
                return r;
            },
            s = function (t) {
                var i = new e.FresnelParameters();
                return (i.isEnabled = t.isEnabled), (i.leftColor = e.Color3.FromArray(t.leftColor)), (i.rightColor = e.Color3.FromArray(t.rightColor)), (i.bias = t.bias), (i.power = t.power || 1), i;
            },
            a = function (t, i, r) {
                var o;
                return (
                    (o = new e.StandardMaterial(t.name, i)),
                    (o.ambientColor = e.Color3.FromArray(t.ambient)),
                    (o.diffuseColor = e.Color3.FromArray(t.diffuse)),
                    (o.specularColor = e.Color3.FromArray(t.specular)),
                    (o.specularPower = t.specularPower),
                    (o.emissiveColor = e.Color3.FromArray(t.emissive)),
                    (o.useReflectionFresnelFromSpecular = t.useReflectionFresnelFromSpecular),
                    (o.useEmissiveAsIllumination = t.useEmissiveAsIllumination),
                    (o.alpha = t.alpha),
                    (o.id = t.id),
                    t.disableDepthWrite && (o.disableDepthWrite = t.disableDepthWrite),
                    e.Tags.AddTagsTo(o, t.tags),
                    (o.backFaceCulling = t.backFaceCulling),
                    (o.wireframe = t.wireframe),
                    t.diffuseTexture && (o.diffuseTexture = n(r, t.diffuseTexture, i)),
                    t.diffuseFresnelParameters && (o.diffuseFresnelParameters = s(t.diffuseFresnelParameters)),
                    t.ambientTexture && (o.ambientTexture = n(r, t.ambientTexture, i)),
                    t.opacityTexture && (o.opacityTexture = n(r, t.opacityTexture, i)),
                    t.opacityFresnelParameters && (o.opacityFresnelParameters = s(t.opacityFresnelParameters)),
                    t.reflectionTexture && (o.reflectionTexture = n(r, t.reflectionTexture, i)),
                    t.reflectionFresnelParameters && (o.reflectionFresnelParameters = s(t.reflectionFresnelParameters)),
                    t.emissiveTexture && (o.emissiveTexture = n(r, t.emissiveTexture, i)),
                    t.lightmapTexture && ((o.lightmapTexture = n(r, t.lightmapTexture, i)), (o.lightmapThreshold = t.lightmapThreshold)),
                    t.emissiveFresnelParameters && (o.emissiveFresnelParameters = s(t.emissiveFresnelParameters)),
                    t.specularTexture && (o.specularTexture = n(r, t.specularTexture, i)),
                    t.bumpTexture && (o.bumpTexture = n(r, t.bumpTexture, i)),
                    t.checkReadyOnlyOnce && (o.checkReadyOnlyOnce = t.checkReadyOnlyOnce),
                    o
                );
            },
            h = function (e, t, i, r) {
                for (var n = 0; n < t.materials.length; n++) {
                    var o = t.materials[n];
                    if (o.id === e) return a(o, i, r);
                }
                return null;
            },
            l = function (t, i) {
                var r = new e.MultiMaterial(t.name, i);
                (r.id = t.id), e.Tags.AddTagsTo(r, t.tags);
                for (var n = 0; n < t.materials.length; n++) {
                    var o = t.materials[n];
                    r.subMaterials.push(o ? i.getMaterialByID(o) : null);
                }
                return r;
            },
            c = function (t, i, r) {
                var n = i.getLastEntryByID(t.emitterId),
                    o = new e.LensFlareSystem("lensFlareSystem#" + t.emitterId, n, i);
                o.borderLimit = t.borderLimit;
                for (var s = 0; s < t.flares.length; s++) {
                    var a = t.flares[s];
                    new e.LensFlare(a.size, a.position, e.Color3.FromArray(a.color), r + a.textureName, o);
                }
                return o;
            },
            u = function (t, i, r) {
                var n = i.getLastMeshByID(t.emitterId),
                    o = new e.ParticleSystem("particles#" + n.name, t.capacity, i);
                return (
                    t.textureName && ((o.particleTexture = new e.Texture(r + t.textureName, i)), (o.particleTexture.name = t.textureName)),
                    (o.minAngularSpeed = t.minAngularSpeed),
                    (o.maxAngularSpeed = t.maxAngularSpeed),
                    (o.minSize = t.minSize),
                    (o.maxSize = t.maxSize),
                    (o.minLifeTime = t.minLifeTime),
                    (o.maxLifeTime = t.maxLifeTime),
                    (o.emitter = n),
                    (o.emitRate = t.emitRate),
                    (o.minEmitBox = e.Vector3.FromArray(t.minEmitBox)),
                    (o.maxEmitBox = e.Vector3.FromArray(t.maxEmitBox)),
                    (o.gravity = e.Vector3.FromArray(t.gravity)),
                    (o.direction1 = e.Vector3.FromArray(t.direction1)),
                    (o.direction2 = e.Vector3.FromArray(t.direction2)),
                    (o.color1 = e.Color4.FromArray(t.color1)),
                    (o.color2 = e.Color4.FromArray(t.color2)),
                    (o.colorDead = e.Color4.FromArray(t.colorDead)),
                    (o.updateSpeed = t.updateSpeed),
                    (o.targetStopDuration = t.targetStopFrame),
                    (o.textureMask = e.Color4.FromArray(t.textureMask)),
                    (o.blendMode = t.blendMode),
                    o.start(),
                    o
                );
            },
            f = function (t, i) {
                for (var r = i.getLightByID(t.lightId), n = new e.ShadowGenerator(t.mapSize, r), o = 0; o < t.renderList.length; o++) {
                    var s = i.getMeshByID(t.renderList[o]);
                    n.getShadowMap().renderList.push(s);
                }
                return (
                    t.usePoissonSampling
                        ? (n.usePoissonSampling = !0)
                        : t.useVarianceShadowMap
                        ? (n.useVarianceShadowMap = !0)
                        : t.useBlurVarianceShadowMap && ((n.useBlurVarianceShadowMap = !0), t.blurScale && (n.blurScale = t.blurScale), t.blurBoxOffset && (n.blurBoxOffset = t.blurBoxOffset)),
                    void 0 !== t.bias && (n.bias = t.bias),
                    n
                );
            },
            d = function (t) {
                for (var i = new e.Animation(t.name, t.property, t.framePerSecond, t.dataType, t.loopBehavior), r = t.dataType, n = [], o = 0; o < t.keys.length; o++) {
                    var s,
                        a = t.keys[o];
                    switch (r) {
                        case e.Animation.ANIMATIONTYPE_FLOAT:
                            s = a.values[0];
                            break;
                        case e.Animation.ANIMATIONTYPE_QUATERNION:
                            s = e.Quaternion.FromArray(a.values);
                            break;
                        case e.Animation.ANIMATIONTYPE_MATRIX:
                            s = e.Matrix.FromArray(a.values);
                            break;
                        case e.Animation.ANIMATIONTYPE_VECTOR3:
                        default:
                            s = e.Vector3.FromArray(a.values);
                    }
                    n.push({ frame: a.frame, value: s });
                }
                return i.setKeys(n), i;
            },
            p = function (t, i) {
                var r;
                switch (t.type) {
                    case 0:
                        r = new e.PointLight(t.name, e.Vector3.FromArray(t.position), i);
                        break;
                    case 1:
                        (r = new e.DirectionalLight(t.name, e.Vector3.FromArray(t.direction), i)), (r.position = e.Vector3.FromArray(t.position));
                        break;
                    case 2:
                        r = new e.SpotLight(t.name, e.Vector3.FromArray(t.position), e.Vector3.FromArray(t.direction), t.angle, t.exponent, i);
                        break;
                    case 3:
                        (r = new e.HemisphericLight(t.name, e.Vector3.FromArray(t.direction), i)), (r.groundColor = e.Color3.FromArray(t.groundColor));
                }
                if (
                    ((r.id = t.id),
                    e.Tags.AddTagsTo(r, t.tags),
                    void 0 !== t.intensity && (r.intensity = t.intensity),
                    t.range && (r.range = t.range),
                    (r.diffuse = e.Color3.FromArray(t.diffuse)),
                    (r.specular = e.Color3.FromArray(t.specular)),
                    t.excludedMeshesIds && (r._excludedMeshesIds = t.excludedMeshesIds),
                    t.parentId && (r._waitingParentId = t.parentId),
                    t.includedOnlyMeshesIds && (r._includedOnlyMeshesIds = t.includedOnlyMeshesIds),
                    t.animations)
                )
                    for (var n = 0; n < t.animations.length; n++) {
                        var o = t.animations[n];
                        r.animations.push(d(o));
                    }
                t.autoAnimate && i.beginAnimation(r, t.autoAnimateFrom, t.autoAnimateTo, t.autoAnimateLoop, 1);
            },
            m = function (t, i) {
                var r,
                    n = e.Vector3.FromArray(t.position),
                    o = t.lockedTargetId ? i.getLastMeshByID(t.lockedTargetId) : null;
                if ("AnaglyphArcRotateCamera" === t.type || "ArcRotateCamera" === t.type) {
                    var s = t.alpha,
                        a = t.beta,
                        h = t.radius;
                    if ("AnaglyphArcRotateCamera" === t.type) {
                        var l = t.interaxial_distance;
                        r = new e.AnaglyphArcRotateCamera(t.name, s, a, h, o, l, i);
                    } else r = new e.ArcRotateCamera(t.name, s, a, h, o, i);
                } else
                    "AnaglyphFreeCamera" === t.type
                        ? ((l = t.interaxial_distance), (r = new e.AnaglyphFreeCamera(t.name, n, l, i)))
                        : "DeviceOrientationCamera" === t.type
                        ? (r = new e.DeviceOrientationCamera(t.name, n, i))
                        : "FollowCamera" === t.type
                        ? ((r = new e.FollowCamera(t.name, n, i)), (r.heightOffset = t.heightOffset), (r.radius = t.radius), (r.rotationOffset = t.rotationOffset), o && (r.target = o))
                        : (r =
                              "GamepadCamera" === t.type
                                  ? new e.GamepadCamera(t.name, n, i)
                                  : "TouchCamera" === t.type
                                  ? new e.TouchCamera(t.name, n, i)
                                  : "VirtualJoysticksCamera" === t.type
                                  ? new e.VirtualJoysticksCamera(t.name, n, i)
                                  : "WebVRFreeCamera" === t.type
                                  ? new e.WebVRFreeCamera(t.name, n, i)
                                  : "VRDeviceOrientationFreeCamera" === t.type
                                  ? new e.VRDeviceOrientationFreeCamera(t.name, n, i)
                                  : new e.FreeCamera(t.name, n, i));
                if (t.cameraRigMode) {
                    var c = t.interaxial_distance ? { interaxialDistance: t.interaxial_distance } : {};
                    r.setCameraRigMode(t.cameraRigMode, c);
                }
                if (
                    (o && r instanceof e.FreeCamera && (r.lockedTarget = o),
                    (r.id = t.id),
                    e.Tags.AddTagsTo(r, t.tags),
                    t.parentId && (r._waitingParentId = t.parentId),
                    t.target ? (r.setTarget ? r.setTarget(e.Vector3.FromArray(t.target)) : (r.target = e.Vector3.FromArray(t.target))) : (r.rotation = e.Vector3.FromArray(t.rotation)),
                    (r.fov = t.fov),
                    (r.minZ = t.minZ),
                    (r.maxZ = t.maxZ),
                    (r.speed = t.speed),
                    (r.inertia = t.inertia),
                    (r.checkCollisions = t.checkCollisions),
                    (r.applyGravity = t.applyGravity),
                    t.ellipsoid && (r.ellipsoid = e.Vector3.FromArray(t.ellipsoid)),
                    t.animations)
                )
                    for (var u = 0; u < t.animations.length; u++) {
                        var f = t.animations[u];
                        r.animations.push(d(f));
                    }
                return t.autoAnimate && i.beginAnimation(r, t.autoAnimateFrom, t.autoAnimateTo, t.autoAnimateLoop, 1), (r.layerMask = t.layerMask && !isNaN(t.layerMask) ? Math.abs(parseInt(t.layerMask)) : 268435455), r;
            },
            g = function (e, t) {
                var i = e.id;
                return t.getGeometryByID(i);
            },
            _ = function (t, i) {
                if (g(t, i)) return null;
                var r = new e.Geometry.Primitives.Box(t.id, i, t.size, t.canBeRegenerated, null);
                return e.Tags.AddTagsTo(r, t.tags), i.pushGeometry(r, !0), r;
            },
            v = function (t, i) {
                if (g(t, i)) return null;
                var r = new e.Geometry.Primitives.Sphere(t.id, i, t.segments, t.diameter, t.canBeRegenerated, null);
                return e.Tags.AddTagsTo(r, t.tags), i.pushGeometry(r, !0), r;
            },
            y = function (t, i) {
                if (g(t, i)) return null;
                var r = new e.Geometry.Primitives.Cylinder(t.id, i, t.height, t.diameterTop, t.diameterBottom, t.tessellation, t.subdivisions, t.canBeRegenerated, null);
                return e.Tags.AddTagsTo(r, t.tags), i.pushGeometry(r, !0), r;
            },
            x = function (t, i) {
                if (g(t, i)) return null;
                var r = new e.Geometry.Primitives.Torus(t.id, i, t.diameter, t.thickness, t.tessellation, t.canBeRegenerated, null);
                return e.Tags.AddTagsTo(r, t.tags), i.pushGeometry(r, !0), r;
            },
            M = function (t, i) {
                if (g(t, i)) return null;
                var r = new e.Geometry.Primitives.Ground(t.id, i, t.width, t.height, t.subdivisions, t.canBeRegenerated, null);
                return e.Tags.AddTagsTo(r, t.tags), i.pushGeometry(r, !0), r;
            },
            S = function (t, i) {
                if (g(t, i)) return null;
                var r = new e.Geometry.Primitives.Plane(t.id, i, t.size, t.canBeRegenerated, null);
                return e.Tags.AddTagsTo(r, t.tags), i.pushGeometry(r, !0), r;
            },
            b = function (t, i) {
                if (g(t, i)) return null;
                var r = new e.Geometry.Primitives.TorusKnot(t.id, i, t.radius, t.tube, t.radialSegments, t.tubularSegments, t.p, t.q, t.canBeRegenerated, null);
                return e.Tags.AddTagsTo(r, t.tags), i.pushGeometry(r, !0), r;
            },
            A = function (t, i, r) {
                if (g(t, i)) return null;
                var n = new e.Geometry(t.id, i);
                return (
                    e.Tags.AddTagsTo(n, t.tags),
                    t.delayLoadingFile
                        ? ((n.delayLoadState = e.Engine.DELAYLOADSTATE_NOTLOADED),
                          (n.delayLoadingFile = r + t.delayLoadingFile),
                          (n._boundingInfo = new e.BoundingInfo(e.Vector3.FromArray(t.boundingBoxMinimum), e.Vector3.FromArray(t.boundingBoxMaximum))),
                          (n._delayInfo = []),
                          t.hasUVs && n._delayInfo.push(e.VertexBuffer.UVKind),
                          t.hasUVs2 && n._delayInfo.push(e.VertexBuffer.UV2Kind),
                          t.hasUVs3 && n._delayInfo.push(e.VertexBuffer.UV3Kind),
                          t.hasUVs4 && n._delayInfo.push(e.VertexBuffer.UV4Kind),
                          t.hasUVs5 && n._delayInfo.push(e.VertexBuffer.UV5Kind),
                          t.hasUVs6 && n._delayInfo.push(e.VertexBuffer.UV6Kind),
                          t.hasColors && n._delayInfo.push(e.VertexBuffer.ColorKind),
                          t.hasMatricesIndices && n._delayInfo.push(e.VertexBuffer.MatricesIndicesKind),
                          t.hasMatricesWeights && n._delayInfo.push(e.VertexBuffer.MatricesWeightsKind),
                          (n._delayLoadingFunction = C))
                        : C(t, n),
                    i.pushGeometry(n, !0),
                    n
                );
            },
            T = function (t, i, r) {
                var n = new e.Mesh(t.name, i);
                if (
                    ((n.id = t.id),
                    e.Tags.AddTagsTo(n, t.tags),
                    (n.position = e.Vector3.FromArray(t.position)),
                    t.rotationQuaternion ? (n.rotationQuaternion = e.Quaternion.FromArray(t.rotationQuaternion)) : t.rotation && (n.rotation = e.Vector3.FromArray(t.rotation)),
                    (n.scaling = e.Vector3.FromArray(t.scaling)),
                    t.localMatrix ? n.setPivotMatrix(e.Matrix.FromArray(t.localMatrix)) : t.pivotMatrix && n.setPivotMatrix(e.Matrix.FromArray(t.pivotMatrix)),
                    n.setEnabled(t.isEnabled),
                    (n.isVisible = t.isVisible),
                    (n.infiniteDistance = t.infiniteDistance),
                    (n.showBoundingBox = t.showBoundingBox),
                    (n.showSubMeshesBoundingBox = t.showSubMeshesBoundingBox),
                    void 0 !== t.applyFog && (n.applyFog = t.applyFog),
                    void 0 !== t.pickable && (n.isPickable = t.pickable),
                    void 0 !== t.alphaIndex && (n.alphaIndex = t.alphaIndex),
                    (n.receiveShadows = t.receiveShadows),
                    (n.billboardMode = t.billboardMode),
                    void 0 !== t.visibility && (n.visibility = t.visibility),
                    (n.checkCollisions = t.checkCollisions),
                    (n._shouldGenerateFlatShading = t.useFlatShading),
                    t.freezeWorldMatrix && (n._waitingFreezeWorldMatrix = t.freezeWorldMatrix),
                    t.parentId && (n._waitingParentId = t.parentId),
                    void 0 !== t.actions && (n._waitingActions = t.actions),
                    (n.hasVertexAlpha = t.hasVertexAlpha),
                    t.delayLoadingFile
                        ? ((n.delayLoadState = e.Engine.DELAYLOADSTATE_NOTLOADED),
                          (n.delayLoadingFile = r + t.delayLoadingFile),
                          (n._boundingInfo = new e.BoundingInfo(e.Vector3.FromArray(t.boundingBoxMinimum), e.Vector3.FromArray(t.boundingBoxMaximum))),
                          t._binaryInfo && (n._binaryInfo = t._binaryInfo),
                          (n._delayInfo = []),
                          t.hasUVs && n._delayInfo.push(e.VertexBuffer.UVKind),
                          t.hasUVs2 && n._delayInfo.push(e.VertexBuffer.UV2Kind),
                          t.hasUVs3 && n._delayInfo.push(e.VertexBuffer.UV3Kind),
                          t.hasUVs4 && n._delayInfo.push(e.VertexBuffer.UV4Kind),
                          t.hasUVs5 && n._delayInfo.push(e.VertexBuffer.UV5Kind),
                          t.hasUVs6 && n._delayInfo.push(e.VertexBuffer.UV6Kind),
                          t.hasColors && n._delayInfo.push(e.VertexBuffer.ColorKind),
                          t.hasMatricesIndices && n._delayInfo.push(e.VertexBuffer.MatricesIndicesKind),
                          t.hasMatricesWeights && n._delayInfo.push(e.VertexBuffer.MatricesWeightsKind),
                          (n._delayLoadingFunction = I),
                          e.SceneLoader.ForceFullSceneLoadingForIncremental && n._checkDelayState())
                        : I(t, n),
                    t.materialId ? n.setMaterialByID(t.materialId) : (n.material = null),
                    t.skeletonId > -1 && (n.skeleton = i.getLastSkeletonByID(t.skeletonId)),
                    t.physicsImpostor && (i.isPhysicsEnabled() || i.enablePhysics(), n.setPhysicsState({ impostor: t.physicsImpostor, mass: t.physicsMass, friction: t.physicsFriction, restitution: t.physicsRestitution })),
                    t.animations)
                )
                    for (var o = 0; o < t.animations.length; o++) {
                        var s = t.animations[o];
                        n.animations.push(d(s));
                    }
                if ((t.autoAnimate && i.beginAnimation(n, t.autoAnimateFrom, t.autoAnimateTo, t.autoAnimateLoop, 1), (n.layerMask = t.layerMask && !isNaN(t.layerMask) ? Math.abs(parseInt(t.layerMask)) : 268435455), t.instances))
                    for (var a = 0; a < t.instances.length; a++) {
                        var h = t.instances[a],
                            l = n.createInstance(h.name);
                        if (
                            (e.Tags.AddTagsTo(l, h.tags),
                            (l.position = e.Vector3.FromArray(h.position)),
                            h.rotationQuaternion ? (l.rotationQuaternion = e.Quaternion.FromArray(h.rotationQuaternion)) : h.rotation && (l.rotation = e.Vector3.FromArray(h.rotation)),
                            (l.scaling = e.Vector3.FromArray(h.scaling)),
                            (l.checkCollisions = n.checkCollisions),
                            t.animations)
                        )
                            for (o = 0; o < t.animations.length; o++) (s = t.animations[o]), l.animations.push(d(s));
                    }
                return n;
            },
            E = function (t, i, r) {
                var n = new e.ActionManager(r);
                null === i ? (r.actionManager = n) : (i.actionManager = n);
                for (
                    var o = function (t, i) {
                            var r = Object.create(e[t].prototype);
                            return r.constructor.apply(r, i), r;
                        },
                        s = function (t, i, r, n) {
                            if (null === n) {
                                var o = parseFloat(i);
                                return "true" === i || "false" === i ? "true" === i : isNaN(o) ? i : o;
                            }
                            for (var s = n.split("."), a = i.split(","), h = 0; h < s.length; h++) r = r[s[h]];
                            if ("boolean" == typeof r) return "true" === a[0];
                            if ("string" == typeof r) return a[0];
                            for (var l = new Array(), h = 0; h < a.length; h++) l.push(parseFloat(a[h]));
                            return r instanceof e.Vector3
                                ? e.Vector3.FromArray(l)
                                : r instanceof e.Vector4
                                ? e.Vector4.FromArray(l)
                                : r instanceof e.Color3
                                ? e.Color3.FromArray(l)
                                : r instanceof e.Color4
                                ? e.Color4.FromArray(l)
                                : parseFloat(a[0]);
                        },
                        a = function (t, i, h, l, c) {
                            if ((void 0 === c && (c = null), !t.detached)) {
                                var u = new Array(),
                                    f = null,
                                    d = null,
                                    p = t.combine && t.combine.length > 0;
                                if ((u.push(2 === t.type ? n : i), p)) {
                                    for (var m = new Array(), g = 0; g < t.combine.length; g++) a(t.combine[g], e.ActionManager.NothingTrigger, h, l, m);
                                    u.push(m);
                                } else
                                    for (var _ = 0; _ < t.properties.length; _++) {
                                        var v = t.properties[_].value,
                                            y = t.properties[_].name,
                                            x = t.properties[_].targetType;
                                        "target" === y
                                            ? (v = f = null !== x && "SceneProperties" === x ? r : r.getNodeByName(v))
                                            : "parent" === y
                                            ? (v = r.getNodeByName(v))
                                            : "sound" === y
                                            ? (v = r.getSoundByName(v))
                                            : "propertyPath" !== y
                                            ? (v = 2 === t.type && "operator" === y ? e.ValueCondition[v] : s(y, v, f, "value" === y ? d : null))
                                            : (d = v),
                                            u.push(v);
                                    }
                                if ((u.push(null === c ? h : null), "InterpolateValueAction" === t.name)) {
                                    var M = u[u.length - 2];
                                    (u[u.length - 1] = M), (u[u.length - 2] = h);
                                }
                                var S = o(t.name, u);
                                null === c ? (S instanceof e.Condition ? ((h = S), (S = l)) : ((h = null), l ? l.then(S) : n.registerAction(S))) : c.push(S);
                                for (var _ = 0; _ < t.children.length; _++) a(t.children[_], i, h, S, null);
                            }
                        },
                        h = 0;
                    h < t.children.length;
                    h++
                ) {
                    var l,
                        c = t.children[h];
                    if (c.properties.length > 0) {
                        var u = c.properties[0].value,
                            f = null === c.properties[0].targetType ? u : r.getMeshByName(u);
                        l = { trigger: e.ActionManager[c.name], parameter: f };
                    } else l = e.ActionManager[c.name];
                    for (var d = 0; d < c.children.length; d++) c.detached || a(c.children[d], l, null, null);
                }
            },
            P = function (t, i, r) {
                var n = t.name,
                    o = r + n,
                    s = {
                        autoplay: t.autoplay,
                        loop: t.loop,
                        volume: t.volume,
                        spatialSound: t.spatialSound,
                        maxDistance: t.maxDistance,
                        rolloffFactor: t.rolloffFactor,
                        refDistance: t.refDistance,
                        distanceModel: t.distanceModel,
                        playbackRate: t.playbackRate,
                    },
                    a = new e.Sound(
                        n,
                        o,
                        i,
                        function () {
                            i._removePendingData(a);
                        },
                        s
                    );
                if ((i._addPendingData(a), t.position)) {
                    var h = e.Vector3.FromArray(t.position);
                    a.setPosition(h);
                }
                if (t.isDirectional && (a.setDirectionalCone(t.coneInnerAngle || 360, t.coneOuterAngle || 360, t.coneOuterGain || 0), t.localDirectionToMesh)) {
                    var l = e.Vector3.FromArray(t.localDirectionToMesh);
                    a.setLocalDirectionToMesh(l);
                }
                if (t.connectedMeshId) {
                    var c = i.getMeshByID(t.connectedMeshId);
                    c && a.attachToMesh(c);
                }
            },
            D = function (e, t, i) {
                t = t instanceof Array ? t : [t];
                for (var r in t) if (e.name === t[r]) return i.push(e.id), !0;
                return e.parentId && -1 !== i.indexOf(e.parentId) ? (i.push(e.id), !0) : !1;
            },
            C = function (t, r) {
                var n = new e.VertexData(),
                    o = t.positions;
                o && n.set(o, e.VertexBuffer.PositionKind);
                var s = t.normals;
                s && n.set(s, e.VertexBuffer.NormalKind);
                var a = t.uvs;
                a && n.set(a, e.VertexBuffer.UVKind);
                var h = t.uv2s;
                h && n.set(h, e.VertexBuffer.UV2Kind);
                var l = t.uv3s;
                l && n.set(l, e.VertexBuffer.UV3Kind);
                var c = t.uv4s;
                c && n.set(c, e.VertexBuffer.UV4Kind);
                var u = t.uv5s;
                u && n.set(u, e.VertexBuffer.UV5Kind);
                var f = t.uv6s;
                f && n.set(f, e.VertexBuffer.UV6Kind);
                var d = t.colors;
                d && n.set(i(d, o.length / 3), e.VertexBuffer.ColorKind);
                var p = t.matricesIndices;
                p && n.set(p, e.VertexBuffer.MatricesIndicesKind);
                var m = t.matricesWeights;
                m && n.set(m, e.VertexBuffer.MatricesWeightsKind);
                var g = t.indices;
                g && (n.indices = g), r.setAllVerticesData(n, t.updatable);
            },
            I = function (t, r) {
                var n = r.getScene(),
                    o = t.geometryId;
                if (o) {
                    var s = n.getGeometryByID(o);
                    s && s.applyToMesh(r);
                } else if (t instanceof ArrayBuffer) {
                    var a = r._binaryInfo;
                    if (a.positionsAttrDesc && a.positionsAttrDesc.count > 0) {
                        var h = new Float32Array(t, a.positionsAttrDesc.offset, a.positionsAttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.PositionKind, h, !1);
                    }
                    if (a.normalsAttrDesc && a.normalsAttrDesc.count > 0) {
                        var l = new Float32Array(t, a.normalsAttrDesc.offset, a.normalsAttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.NormalKind, l, !1);
                    }
                    if (a.uvsAttrDesc && a.uvsAttrDesc.count > 0) {
                        var c = new Float32Array(t, a.uvsAttrDesc.offset, a.uvsAttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.UVKind, c, !1);
                    }
                    if (a.uvs2AttrDesc && a.uvs2AttrDesc.count > 0) {
                        var u = new Float32Array(t, a.uvs2AttrDesc.offset, a.uvs2AttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.UV2Kind, u, !1);
                    }
                    if (a.uvs3AttrDesc && a.uvs3AttrDesc.count > 0) {
                        var f = new Float32Array(t, a.uvs3AttrDesc.offset, a.uvs3AttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.UV3Kind, f, !1);
                    }
                    if (a.uvs4AttrDesc && a.uvs4AttrDesc.count > 0) {
                        var d = new Float32Array(t, a.uvs4AttrDesc.offset, a.uvs4AttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.UV4Kind, d, !1);
                    }
                    if (a.uvs5AttrDesc && a.uvs5AttrDesc.count > 0) {
                        var p = new Float32Array(t, a.uvs5AttrDesc.offset, a.uvs5AttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.UV5Kind, p, !1);
                    }
                    if (a.uvs6AttrDesc && a.uvs6AttrDesc.count > 0) {
                        var m = new Float32Array(t, a.uvs6AttrDesc.offset, a.uvs6AttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.UV6Kind, m, !1);
                    }
                    if (a.colorsAttrDesc && a.colorsAttrDesc.count > 0) {
                        var g = new Float32Array(t, a.colorsAttrDesc.offset, a.colorsAttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.ColorKind, g, !1, a.colorsAttrDesc.stride);
                    }
                    if (a.matricesIndicesAttrDesc && a.matricesIndicesAttrDesc.count > 0) {
                        var _ = new Int32Array(t, a.matricesIndicesAttrDesc.offset, a.matricesIndicesAttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.MatricesIndicesKind, _, !1);
                    }
                    if (a.matricesWeightsAttrDesc && a.matricesWeightsAttrDesc.count > 0) {
                        var v = new Float32Array(t, a.matricesWeightsAttrDesc.offset, a.matricesWeightsAttrDesc.count);
                        r.setVerticesData(e.VertexBuffer.MatricesWeightsKind, v, !1);
                    }
                    if (a.indicesAttrDesc && a.indicesAttrDesc.count > 0) {
                        var y = new Int32Array(t, a.indicesAttrDesc.offset, a.indicesAttrDesc.count);
                        r.setIndices(y);
                    }
                    if (a.subMeshesAttrDesc && a.subMeshesAttrDesc.count > 0) {
                        var x = new Int32Array(t, a.subMeshesAttrDesc.offset, 5 * a.subMeshesAttrDesc.count);
                        r.subMeshes = [];
                        for (var M = 0; M < a.subMeshesAttrDesc.count; M++) {
                            var S = x[5 * M + 0],
                                b = x[5 * M + 1],
                                A = x[5 * M + 2],
                                T = x[5 * M + 3],
                                E = x[5 * M + 4];
                            new e.SubMesh(S, b, A, T, E, r);
                        }
                    }
                } else if (t.positions && t.normals && t.indices) {
                    if (
                        (r.setVerticesData(e.VertexBuffer.PositionKind, t.positions, !1),
                        r.setVerticesData(e.VertexBuffer.NormalKind, t.normals, !1),
                        t.uvs && r.setVerticesData(e.VertexBuffer.UVKind, t.uvs, !1),
                        t.uvs2 && r.setVerticesData(e.VertexBuffer.UV2Kind, t.uvs2, !1),
                        t.uvs3 && r.setVerticesData(e.VertexBuffer.UV3Kind, t.uvs3, !1),
                        t.uvs4 && r.setVerticesData(e.VertexBuffer.UV4Kind, t.uvs4, !1),
                        t.uvs5 && r.setVerticesData(e.VertexBuffer.UV5Kind, t.uvs5, !1),
                        t.uvs6 && r.setVerticesData(e.VertexBuffer.UV6Kind, t.uvs6, !1),
                        t.colors && r.setVerticesData(e.VertexBuffer.ColorKind, i(t.colors, t.positions.length / 3), !1),
                        t.matricesIndices)
                    )
                        if (t.matricesIndices._isExpanded) delete t.matricesIndices._isExpanded, r.setVerticesData(e.VertexBuffer.MatricesIndicesKind, t.matricesIndices, !1);
                        else {
                            for (var P = [], M = 0; M < t.matricesIndices.length; M++) {
                                var D = t.matricesIndices[M];
                                P.push(255 & D), P.push((65280 & D) >> 8), P.push((16711680 & D) >> 16), P.push(D >> 24);
                            }
                            r.setVerticesData(e.VertexBuffer.MatricesIndicesKind, P, !1);
                        }
                    t.matricesWeights && r.setVerticesData(e.VertexBuffer.MatricesWeightsKind, t.matricesWeights, !1), r.setIndices(t.indices);
                }
                if (t.subMeshes) {
                    r.subMeshes = [];
                    for (var C = 0; C < t.subMeshes.length; C++) {
                        var I = t.subMeshes[C];
                        new e.SubMesh(I.materialIndex, I.verticesStart, I.verticesCount, I.indexStart, I.indexCount, r);
                    }
                }
                r._shouldGenerateFlatShading && (r.convertToFlatShadedMesh(), delete r._shouldGenerateFlatShading), r.computeWorldMatrix(!0), n._selectionOctree && n._selectionOctree.addMesh(r);
            };
        e.SceneLoader.RegisterPlugin({
            extensions: ".babylon",
            importMesh: function (t, i, r, n, s, a, c) {
                for (var f = JSON.parse(r), d = [], p = [], m = [], g = 0; g < f.meshes.length; g++) {
                    var E = f.meshes[g];
                    if (!t || D(E, t, m)) {
                        if ((t instanceof Array && delete t[t.indexOf(E.name)], E.geometryId && f.geometries)) {
                            var P = !1;
                            ["boxes", "spheres", "cylinders", "toruses", "grounds", "planes", "torusKnots", "vertexData"].forEach(function (e) {
                                !P &&
                                    f.geometries[e] &&
                                    f.geometries[e] instanceof Array &&
                                    f.geometries[e].forEach(function (t) {
                                        if (t.id == E.geometryId) {
                                            switch (e) {
                                                case "boxes":
                                                    _(t, i);
                                                    break;
                                                case "spheres":
                                                    v(t, i);
                                                    break;
                                                case "cylinders":
                                                    y(t, i);
                                                    break;
                                                case "toruses":
                                                    x(t, i);
                                                    break;
                                                case "grounds":
                                                    M(t, i);
                                                    break;
                                                case "planes":
                                                    S(t, i);
                                                    break;
                                                case "torusKnots":
                                                    b(t, i);
                                                    break;
                                                case "vertexData":
                                                    A(t, i, n);
                                            }
                                            P = !0;
                                        }
                                    });
                            }),
                                P || e.Tools.Warn("Geometry not found for mesh " + E.id);
                        }
                        if (E.materialId) {
                            var C = -1 !== p.indexOf(E.materialId);
                            if (!C && f.multiMaterials)
                                for (var I = 0; I < f.multiMaterials.length; I++) {
                                    var w = f.multiMaterials[I];
                                    if (w.id == E.materialId) {
                                        for (var R = 0; R < w.materials.length; R++) {
                                            var L = w.materials[R];
                                            p.push(L), h(L, f, i, n);
                                        }
                                        p.push(w.id), l(w, i), (C = !0);
                                        break;
                                    }
                                }
                            C || (p.push(E.materialId), h(E.materialId, f, i, n) || e.Tools.Warn("Material not found for mesh " + E.id));
                        }
                        if (E.skeletonId > -1 && i.skeletons) {
                            var O = d.indexOf(E.skeletonId) > -1;
                            if (!O)
                                for (var B = 0; B < f.skeletons.length; B++) {
                                    var F = f.skeletons[B];
                                    F.id === E.skeletonId && (c.push(o(F, i)), d.push(F.id));
                                }
                        }
                        var V = T(E, i, n);
                        s.push(V);
                    }
                }
                for (g = 0; g < i.meshes.length; g++) {
                    var N = i.meshes[g];
                    N._waitingParentId && ((N.parent = i.getLastEntryByID(N._waitingParentId)), (N._waitingParentId = void 0));
                }
                for (g = 0; g < i.meshes.length; g++) {
                    var N = i.meshes[g];
                    N._waitingFreezeWorldMatrix && (N.freezeWorldMatrix(), (N._waitingFreezeWorldMatrix = void 0));
                }
                if (f.particleSystems)
                    for (g = 0; g < f.particleSystems.length; g++) {
                        var z = f.particleSystems[g];
                        -1 !== m.indexOf(z.emitterId) && a.push(u(z, i, n));
                    }
                return !0;
            },
            load: function (t, i, r) {
                var n = JSON.parse(i);
                (t.useDelayedTextureLoading = n.useDelayedTextureLoading && !e.SceneLoader.ForceFullSceneLoadingForIncremental),
                    (t.autoClear = n.autoClear),
                    (t.clearColor = e.Color3.FromArray(n.clearColor)),
                    (t.ambientColor = e.Color3.FromArray(n.ambientColor)),
                    (t.gravity = e.Vector3.FromArray(n.gravity)),
                    n.fogMode && 0 !== n.fogMode && ((t.fogMode = n.fogMode), (t.fogColor = e.Color3.FromArray(n.fogColor)), (t.fogStart = n.fogStart), (t.fogEnd = n.fogEnd), (t.fogDensity = n.fogDensity));
                for (var s = 0; s < n.lights.length; s++) {
                    var h = n.lights[s];
                    p(h, t);
                }
                if (n.materials)
                    for (s = 0; s < n.materials.length; s++) {
                        var d = n.materials[s];
                        a(d, t, r);
                    }
                if (n.multiMaterials)
                    for (s = 0; s < n.multiMaterials.length; s++) {
                        var g = n.multiMaterials[s];
                        l(g, t);
                    }
                if (n.skeletons)
                    for (s = 0; s < n.skeletons.length; s++) {
                        var D = n.skeletons[s];
                        o(D, t);
                    }
                var C = n.geometries;
                if (C) {
                    var I = C.boxes;
                    if (I)
                        for (s = 0; s < I.length; s++) {
                            var w = I[s];
                            _(w, t);
                        }
                    var R = C.spheres;
                    if (R)
                        for (s = 0; s < R.length; s++) {
                            var L = R[s];
                            v(L, t);
                        }
                    var O = C.cylinders;
                    if (O)
                        for (s = 0; s < O.length; s++) {
                            var B = O[s];
                            y(B, t);
                        }
                    var F = C.toruses;
                    if (F)
                        for (s = 0; s < F.length; s++) {
                            var V = F[s];
                            x(V, t);
                        }
                    var N = C.grounds;
                    if (N)
                        for (s = 0; s < N.length; s++) {
                            var z = N[s];
                            M(z, t);
                        }
                    var k = C.planes;
                    if (k)
                        for (s = 0; s < k.length; s++) {
                            var U = k[s];
                            S(U, t);
                        }
                    var W = C.torusKnots;
                    if (W)
                        for (s = 0; s < W.length; s++) {
                            var G = W[s];
                            b(G, t);
                        }
                    var Y = C.vertexData;
                    if (Y)
                        for (s = 0; s < Y.length; s++) {
                            var H = Y[s];
                            A(H, t, r);
                        }
                }
                for (s = 0; s < n.meshes.length; s++) {
                    var j = n.meshes[s];
                    T(j, t, r);
                }
                for (s = 0; s < n.cameras.length; s++) {
                    var K = n.cameras[s];
                    m(K, t);
                }
                for (n.activeCameraID && t.setActiveCameraByID(n.activeCameraID), s = 0; s < t.cameras.length; s++) {
                    var X = t.cameras[s];
                    X._waitingParentId && ((X.parent = t.getLastEntryByID(X._waitingParentId)), (X._waitingParentId = void 0));
                }
                for (s = 0; s < t.lights.length; s++) {
                    var q = t.lights[s];
                    q._waitingParentId && ((q.parent = t.getLastEntryByID(q._waitingParentId)), (q._waitingParentId = void 0));
                }
                if (n.sounds)
                    for (s = 0; s < n.sounds.length; s++) {
                        var Z = n.sounds[s];
                        if (e.Engine.audioEngine.canUseWebAudio) P(Z, t, r);
                        else {
                            new e.Sound(Z.name, null, t);
                        }
                    }
                for (s = 0; s < t.meshes.length; s++) {
                    var Q = t.meshes[s];
                    Q._waitingParentId && ((Q.parent = t.getLastEntryByID(Q._waitingParentId)), (Q._waitingParentId = void 0)), Q._waitingActions && (E(Q._waitingActions, Q, t), (Q._waitingActions = void 0));
                }
                for (s = 0; s < t.meshes.length; s++) {
                    var J = t.meshes[s];
                    J._waitingFreezeWorldMatrix && (J.freezeWorldMatrix(), (J._waitingFreezeWorldMatrix = void 0));
                }
                if (n.particleSystems)
                    for (s = 0; s < n.particleSystems.length; s++) {
                        var $ = n.particleSystems[s];
                        u($, t, r);
                    }
                if (n.lensFlareSystems)
                    for (s = 0; s < n.lensFlareSystems.length; s++) {
                        var ee = n.lensFlareSystems[s];
                        c(ee, t, r);
                    }
                if (n.shadowGenerators)
                    for (s = 0; s < n.shadowGenerators.length; s++) {
                        var te = n.shadowGenerators[s];
                        f(te, t);
                    }
                return n.actions && E(n.actions, null, t), !0;
            },
        });
    })((t = e.Internals || (e.Internals = {})));
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i, r, n, o, s, a) {
            void 0 === a && (a = e.Texture.TRILINEAR_SAMPLINGMODE),
                (this.name = t),
                (this.cellSize = n),
                (this.sprites = new Array()),
                (this.renderingGroupId = 0),
                (this.layerMask = 268435455),
                (this.fogEnabled = !0),
                (this._vertexDeclaration = [4, 4, 4, 4]),
                (this._vertexStrideSize = 64),
                (this._capacity = r),
                (this._spriteTexture = new e.Texture(i, o, !0, !1, a)),
                (this._spriteTexture.wrapU = e.Texture.CLAMP_ADDRESSMODE),
                (this._spriteTexture.wrapV = e.Texture.CLAMP_ADDRESSMODE),
                (this._epsilon = void 0 === s ? 0.01 : s),
                (this._scene = o),
                this._scene.spriteManagers.push(this),
                (this._vertexBuffer = o.getEngine().createDynamicVertexBuffer(r * this._vertexStrideSize * 4));
            for (var h = [], l = 0, c = 0; r > c; c++) h.push(l), h.push(l + 1), h.push(l + 2), h.push(l), h.push(l + 2), h.push(l + 3), (l += 4);
            (this._indexBuffer = o.getEngine().createIndexBuffer(h)),
                (this._vertices = new Float32Array(r * this._vertexStrideSize)),
                (this._effectBase = this._scene.getEngine().createEffect("sprites", ["position", "options", "cellInfo", "color"], ["view", "projection", "textureInfos", "alphaTest"], ["diffuseSampler"], "")),
                (this._effectFog = this._scene
                    .getEngine()
                    .createEffect("sprites", ["position", "options", "cellInfo", "color"], ["view", "projection", "textureInfos", "alphaTest", "vFogInfos", "vFogColor"], ["diffuseSampler"], "#define FOG"));
        }
        return (
            (t.prototype._appendSpriteVertex = function (e, t, i, r, n) {
                var o = 16 * e;
                0 === i ? (i = this._epsilon) : 1 === i && (i = 1 - this._epsilon),
                    0 === r ? (r = this._epsilon) : 1 === r && (r = 1 - this._epsilon),
                    (this._vertices[o] = t.position.x),
                    (this._vertices[o + 1] = t.position.y),
                    (this._vertices[o + 2] = t.position.z),
                    (this._vertices[o + 3] = t.angle),
                    (this._vertices[o + 4] = t.width),
                    (this._vertices[o + 5] = t.height),
                    (this._vertices[o + 6] = i),
                    (this._vertices[o + 7] = r),
                    (this._vertices[o + 8] = t.invertU ? 1 : 0),
                    (this._vertices[o + 9] = t.invertV ? 1 : 0);
                var s = (t.cellIndex / n) >> 0;
                (this._vertices[o + 10] = t.cellIndex - s * n),
                    (this._vertices[o + 11] = s),
                    (this._vertices[o + 12] = t.color.r),
                    (this._vertices[o + 13] = t.color.g),
                    (this._vertices[o + 14] = t.color.b),
                    (this._vertices[o + 15] = t.color.a);
            }),
            (t.prototype.render = function () {
                if (this._effectBase.isReady() && this._effectFog.isReady() && this._spriteTexture && this._spriteTexture.isReady()) {
                    for (var t = this._scene.getEngine(), i = this._spriteTexture.getBaseSize(), r = t.getDeltaTime(), n = Math.min(this._capacity, this.sprites.length), o = i.width / this.cellSize, s = 0, a = 0; n > a; a++) {
                        var h = this.sprites[a];
                        h && (h._animate(r), this._appendSpriteVertex(s++, h, 0, 0, o), this._appendSpriteVertex(s++, h, 1, 0, o), this._appendSpriteVertex(s++, h, 1, 1, o), this._appendSpriteVertex(s++, h, 0, 1, o));
                    }
                    t.updateDynamicVertexBuffer(this._vertexBuffer, this._vertices);
                    var l = this._effectBase;
                    this._scene.fogEnabled && this._scene.fogMode !== e.Scene.FOGMODE_NONE && this.fogEnabled && (l = this._effectFog), t.enableEffect(l);
                    var c = this._scene.getViewMatrix();
                    l.setTexture("diffuseSampler", this._spriteTexture),
                        l.setMatrix("view", c),
                        l.setMatrix("projection", this._scene.getProjectionMatrix()),
                        l.setFloat2("textureInfos", this.cellSize / i.width, this.cellSize / i.height),
                        this._scene.fogEnabled &&
                            this._scene.fogMode !== e.Scene.FOGMODE_NONE &&
                            this.fogEnabled &&
                            (l.setFloat4("vFogInfos", this._scene.fogMode, this._scene.fogStart, this._scene.fogEnd, this._scene.fogDensity), l.setColor3("vFogColor", this._scene.fogColor)),
                        t.bindBuffers(this._vertexBuffer, this._indexBuffer, this._vertexDeclaration, this._vertexStrideSize, l),
                        t.setDepthFunctionToLessOrEqual(),
                        l.setBool("alphaTest", !0),
                        t.setColorWrite(!1),
                        t.draw(!0, 0, 6 * n),
                        t.setColorWrite(!0),
                        l.setBool("alphaTest", !1),
                        t.setAlphaMode(e.Engine.ALPHA_COMBINE),
                        t.draw(!0, 0, 6 * n),
                        t.setAlphaMode(e.Engine.ALPHA_DISABLE);
                }
            }),
            (t.prototype.dispose = function () {
                this._vertexBuffer && (this._scene.getEngine()._releaseBuffer(this._vertexBuffer), (this._vertexBuffer = null)),
                    this._indexBuffer && (this._scene.getEngine()._releaseBuffer(this._indexBuffer), (this._indexBuffer = null)),
                    this._spriteTexture && (this._spriteTexture.dispose(), (this._spriteTexture = null));
                var e = this._scene.spriteManagers.indexOf(this);
                this._scene.spriteManagers.splice(e, 1), this.onDispose && this.onDispose();
            }),
            t
        );
    })();
    e.SpriteManager = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i) {
            (this.name = t),
                (this.color = new e.Color4(1, 1, 1, 1)),
                (this.width = 1),
                (this.height = 1),
                (this.angle = 0),
                (this.cellIndex = 0),
                (this.invertU = 0),
                (this.invertV = 0),
                (this.animations = new Array()),
                (this._animationStarted = !1),
                (this._loopAnimation = !1),
                (this._fromIndex = 0),
                (this._toIndex = 0),
                (this._delay = 0),
                (this._direction = 1),
                (this._frameCount = 0),
                (this._time = 0),
                (this._manager = i),
                this._manager.sprites.push(this),
                (this.position = e.Vector3.Zero());
        }
        return (
            Object.defineProperty(t.prototype, "size", {
                get: function () {
                    return this.width;
                },
                set: function (e) {
                    (this.width = e), (this.height = e);
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype.playAnimation = function (e, t, i, r) {
                (this._fromIndex = e), (this._toIndex = t), (this._loopAnimation = i), (this._delay = r), (this._animationStarted = !0), (this._direction = t > e ? 1 : -1), (this.cellIndex = e), (this._time = 0);
            }),
            (t.prototype.stopAnimation = function () {
                this._animationStarted = !1;
            }),
            (t.prototype._animate = function (e) {
                this._animationStarted &&
                    ((this._time += e),
                    this._time > this._delay &&
                        ((this._time = this._time % this._delay),
                        (this.cellIndex += this._direction),
                        this.cellIndex == this._toIndex && (this._loopAnimation ? (this.cellIndex = this._fromIndex) : ((this._animationStarted = !1), this.disposeWhenFinishedAnimating && this.dispose()))));
            }),
            (t.prototype.dispose = function () {
                for (var e = 0; e < this._manager.sprites.length; e++) this._manager.sprites[e] == this && this._manager.sprites.splice(e, 1);
            }),
            t
        );
    })();
    e.Sprite = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i, r, n, o) {
            (this.name = t),
                (this._vertexDeclaration = [2]),
                (this._vertexStrideSize = 8),
                (this.texture = i ? new e.Texture(i, r, !0) : null),
                (this.isBackground = void 0 === n ? !0 : n),
                (this.color = void 0 === o ? new e.Color4(1, 1, 1, 1) : o),
                (this._scene = r),
                this._scene.layers.push(this);
            var s = [];
            s.push(1, 1), s.push(-1, 1), s.push(-1, -1), s.push(1, -1), (this._vertexBuffer = r.getEngine().createVertexBuffer(s));
            var a = [];
            a.push(0),
                a.push(1),
                a.push(2),
                a.push(0),
                a.push(2),
                a.push(3),
                (this._indexBuffer = r.getEngine().createIndexBuffer(a)),
                (this._effect = this._scene.getEngine().createEffect("layer", ["position"], ["textureMatrix", "color"], ["textureSampler"], ""));
        }
        return (
            (t.prototype.render = function () {
                if (this._effect.isReady() && this.texture && this.texture.isReady()) {
                    var t = this._scene.getEngine();
                    t.enableEffect(this._effect),
                        t.setState(!1),
                        this._effect.setTexture("textureSampler", this.texture),
                        this._effect.setMatrix("textureMatrix", this.texture.getTextureMatrix()),
                        this._effect.setFloat4("color", this.color.r, this.color.g, this.color.b, this.color.a),
                        t.bindBuffers(this._vertexBuffer, this._indexBuffer, this._vertexDeclaration, this._vertexStrideSize, this._effect),
                        t.setAlphaMode(e.Engine.ALPHA_COMBINE),
                        t.draw(!0, 0, 6),
                        t.setAlphaMode(e.Engine.ALPHA_DISABLE);
                }
            }),
            (t.prototype.dispose = function () {
                this._vertexBuffer && (this._scene.getEngine()._releaseBuffer(this._vertexBuffer), (this._vertexBuffer = null)),
                    this._indexBuffer && (this._scene.getEngine()._releaseBuffer(this._indexBuffer), (this._indexBuffer = null)),
                    this.texture && (this.texture.dispose(), (this.texture = null));
                var e = this._scene.layers.indexOf(this);
                this._scene.layers.splice(e, 1), this.onDispose && this.onDispose();
            }),
            t
        );
    })();
    e.Layer = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t() {
            (this.position = e.Vector3.Zero()),
                (this.direction = e.Vector3.Zero()),
                (this.color = new e.Color4(0, 0, 0, 0)),
                (this.colorStep = new e.Color4(0, 0, 0, 0)),
                (this.lifeTime = 1),
                (this.age = 0),
                (this.size = 0),
                (this.angle = 0),
                (this.angularSpeed = 0);
        }
        return (
            (t.prototype.copyTo = function (e) {
                e.position.copyFrom(this.position),
                    e.direction.copyFrom(this.direction),
                    e.color.copyFrom(this.color),
                    e.colorStep.copyFrom(this.colorStep),
                    (e.lifeTime = this.lifeTime),
                    (e.age = this.age),
                    (e.size = this.size),
                    (e.angle = this.angle),
                    (e.angularSpeed = this.angularSpeed);
            }),
            t
        );
    })();
    e.Particle = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = function (e, t) {
            if (e === t) return e;
            var i = Math.random();
            return i * (t - e) + e;
        },
        i = (function () {
            function i(r, n, o, s) {
                var a = this;
                (this.name = r),
                    (this.renderingGroupId = 0),
                    (this.emitter = null),
                    (this.emitRate = 10),
                    (this.manualEmitCount = -1),
                    (this.updateSpeed = 0.01),
                    (this.targetStopDuration = 0),
                    (this.disposeOnStop = !1),
                    (this.minEmitPower = 1),
                    (this.maxEmitPower = 1),
                    (this.minLifeTime = 1),
                    (this.maxLifeTime = 1),
                    (this.minSize = 1),
                    (this.maxSize = 1),
                    (this.minAngularSpeed = 0),
                    (this.maxAngularSpeed = 0),
                    (this.layerMask = 268435455),
                    (this.blendMode = i.BLENDMODE_ONEONE),
                    (this.forceDepthWrite = !1),
                    (this.gravity = e.Vector3.Zero()),
                    (this.direction1 = new e.Vector3(0, 1, 0)),
                    (this.direction2 = new e.Vector3(0, 1, 0)),
                    (this.minEmitBox = new e.Vector3(-0.5, -0.5, -0.5)),
                    (this.maxEmitBox = new e.Vector3(0.5, 0.5, 0.5)),
                    (this.color1 = new e.Color4(1, 1, 1, 1)),
                    (this.color2 = new e.Color4(1, 1, 1, 1)),
                    (this.colorDead = new e.Color4(0, 0, 0, 1)),
                    (this.textureMask = new e.Color4(1, 1, 1, 1)),
                    (this.particles = new Array()),
                    (this._vertexDeclaration = [3, 4, 4]),
                    (this._vertexStrideSize = 44),
                    (this._stockParticles = new Array()),
                    (this._newPartsExcess = 0),
                    (this._scaledColorStep = new e.Color4(0, 0, 0, 0)),
                    (this._colorDiff = new e.Color4(0, 0, 0, 0)),
                    (this._scaledDirection = e.Vector3.Zero()),
                    (this._scaledGravity = e.Vector3.Zero()),
                    (this._currentRenderId = -1),
                    (this._started = !1),
                    (this._stopped = !1),
                    (this._actualFrame = 0),
                    (this.id = r),
                    (this._capacity = n),
                    (this._scene = o),
                    (this._customEffect = s),
                    o.particleSystems.push(this),
                    (this._vertexBuffer = o.getEngine().createDynamicVertexBuffer(n * this._vertexStrideSize * 4));
                for (var h = [], l = 0, c = 0; n > c; c++) h.push(l), h.push(l + 1), h.push(l + 2), h.push(l), h.push(l + 2), h.push(l + 3), (l += 4);
                (this._indexBuffer = o.getEngine().createIndexBuffer(h)),
                    (this._vertices = new Float32Array(n * this._vertexStrideSize)),
                    (this.startDirectionFunction = function (i, r, n) {
                        var o = t(a.direction1.x, a.direction2.x),
                            s = t(a.direction1.y, a.direction2.y),
                            h = t(a.direction1.z, a.direction2.z);
                        e.Vector3.TransformNormalFromFloatsToRef(o * i, s * i, h * i, r, n);
                    }),
                    (this.startPositionFunction = function (i, r) {
                        var n = t(a.minEmitBox.x, a.maxEmitBox.x),
                            o = t(a.minEmitBox.y, a.maxEmitBox.y),
                            s = t(a.minEmitBox.z, a.maxEmitBox.z);
                        e.Vector3.TransformCoordinatesFromFloatsToRef(n, o, s, i, r);
                    }),
                    (this.updateFunction = function (e) {
                        for (var t = 0; t < e.length; t++) {
                            var i = e[t];
                            (i.age += a._scaledUpdateSpeed),
                                i.age >= i.lifeTime
                                    ? (a.recycleParticle(i), t--)
                                    : (i.colorStep.scaleToRef(a._scaledUpdateSpeed, a._scaledColorStep),
                                      i.color.addInPlace(a._scaledColorStep),
                                      i.color.a < 0 && (i.color.a = 0),
                                      (i.angle += i.angularSpeed * a._scaledUpdateSpeed),
                                      i.direction.scaleToRef(a._scaledUpdateSpeed, a._scaledDirection),
                                      i.position.addInPlace(a._scaledDirection),
                                      a.gravity.scaleToRef(a._scaledUpdateSpeed, a._scaledGravity),
                                      i.direction.addInPlace(a._scaledGravity));
                        }
                    });
            }
            return (
                (i.prototype.recycleParticle = function (e) {
                    var t = this.particles.pop();
                    t !== e && (t.copyTo(e), this._stockParticles.push(t));
                }),
                (i.prototype.getCapacity = function () {
                    return this._capacity;
                }),
                (i.prototype.isAlive = function () {
                    return this._alive;
                }),
                (i.prototype.isStarted = function () {
                    return this._started;
                }),
                (i.prototype.start = function () {
                    (this._started = !0), (this._stopped = !1), (this._actualFrame = 0);
                }),
                (i.prototype.stop = function () {
                    this._stopped = !0;
                }),
                (i.prototype._appendParticleVertex = function (e, t, i, r) {
                    var n = 11 * e;
                    (this._vertices[n] = t.position.x),
                        (this._vertices[n + 1] = t.position.y),
                        (this._vertices[n + 2] = t.position.z),
                        (this._vertices[n + 3] = t.color.r),
                        (this._vertices[n + 4] = t.color.g),
                        (this._vertices[n + 5] = t.color.b),
                        (this._vertices[n + 6] = t.color.a),
                        (this._vertices[n + 7] = t.angle),
                        (this._vertices[n + 8] = t.size),
                        (this._vertices[n + 9] = i),
                        (this._vertices[n + 10] = r);
                }),
                (i.prototype._update = function (i) {
                    (this._alive = this.particles.length > 0), this.updateFunction(this.particles);

                    var r;
                    r = this.emitter.position ? this.emitter.getWorldMatrix() : e.Matrix.Translation(this.emitter.x, this.emitter.y, this.emitter.z);
                    for (var n = 0; i > n && this.particles.length !== this._capacity; n++) {
                        if (0 !== this._stockParticles.length) {
                            var o = this._stockParticles.pop();
                            o.age = 0;
                        } else o = new e.Particle();
                        this.particles.push(o);
                        var s = t(this.minEmitPower, this.maxEmitPower);
                        this.startDirectionFunction(s, r, o.direction),
                            (o.lifeTime = t(this.minLifeTime, this.maxLifeTime)),
                            (o.size = t(this.minSize, this.maxSize)),
                            (o.angularSpeed = t(this.minAngularSpeed, this.maxAngularSpeed)),
                            this.startPositionFunction(r, o.position);
                        var a = t(0, 1);
                        e.Color4.LerpToRef(this.color1, this.color2, a, o.color), this.colorDead.subtractToRef(o.color, this._colorDiff), this._colorDiff.scaleToRef(1 / o.lifeTime, o.colorStep);
                    }
                }),
                (i.prototype._getEffect = function () {
                    if (this._customEffect) return this._customEffect;
                    var e = [];
                    this._scene.clipPlane && e.push("#define CLIPPLANE");
                    var t = e.join("\n");
                    return (
                        this._cachedDefines !== t &&
                            ((this._cachedDefines = t),
                            (this._effect = this._scene.getEngine().createEffect("particles", ["position", "color", "options"], ["invView", "view", "projection", "vClipPlane", "textureMask"], ["diffuseSampler"], t))),
                        this._effect
                    );
                }),
                (i.prototype.animate = function () {
                    if (this._started) {
                        var e = this._getEffect();
                        if (this.emitter && e.isReady() && this.particleTexture && this.particleTexture.isReady() && this._currentRenderId !== this._scene.getRenderId()) {
                            (this._currentRenderId = this._scene.getRenderId()), (this._scaledUpdateSpeed = this.updateSpeed * this._scene.getAnimationRatio());
                            var t;
                            this.manualEmitCount > -1 ? ((t = this.manualEmitCount), (this.manualEmitCount = 0)) : (t = this.emitRate);
                            var i = (t * this._scaledUpdateSpeed) >> 0;
                            (this._newPartsExcess += t * this._scaledUpdateSpeed - i),
                                this._newPartsExcess > 1 && ((i += this._newPartsExcess >> 0), (this._newPartsExcess -= this._newPartsExcess >> 0)),
                                (this._alive = !1),
                                this._stopped ? (i = 0) : ((this._actualFrame += this._scaledUpdateSpeed), this.targetStopDuration && this._actualFrame >= this.targetStopDuration && this.stop()),
                                this._update(i),
                                this._stopped && (this._alive || ((this._started = !1), this.disposeOnStop && this._scene._toBeDisposed.push(this)));
                            for (var r = 0, n = 0; n < this.particles.length; n++) {
                                var o = this.particles[n];
                                this._appendParticleVertex(r++, o, 0, 0), this._appendParticleVertex(r++, o, 1, 0), this._appendParticleVertex(r++, o, 1, 1), this._appendParticleVertex(r++, o, 0, 1);
                            }
                            var s = this._scene.getEngine();
                            s.updateDynamicVertexBuffer(this._vertexBuffer, this._vertices);
                        }
                    }
                }),
                (i.prototype.render = function () {
                    var t = this._getEffect();
                    if (!(this.emitter && t.isReady() && this.particleTexture && this.particleTexture.isReady() && this.particles.length)) return 0;
                    var r = this._scene.getEngine();
                    r.enableEffect(t), r.setState(!1);
                    var n = this._scene.getViewMatrix();
                    if (
                        (t.setTexture("diffuseSampler", this.particleTexture),
                        t.setMatrix("view", n),
                        t.setMatrix("projection", this._scene.getProjectionMatrix()),
                        t.setFloat4("textureMask", this.textureMask.r, this.textureMask.g, this.textureMask.b, this.textureMask.a),
                        this._scene.clipPlane)
                    ) {
                        var o = this._scene.clipPlane,
                            s = n.clone();
                        s.invert(), t.setMatrix("invView", s), t.setFloat4("vClipPlane", o.normal.x, o.normal.y, o.normal.z, o.d);
                    }
                    return (
                        r.bindBuffers(this._vertexBuffer, this._indexBuffer, this._vertexDeclaration, this._vertexStrideSize, t),
                        r.setAlphaMode(this.blendMode === i.BLENDMODE_ONEONE ? e.Engine.ALPHA_ONEONE : e.Engine.ALPHA_COMBINE),
                        this.forceDepthWrite && r.setDepthWrite(!0),
                        r.draw(!0, 0, 6 * this.particles.length),
                        r.setAlphaMode(e.Engine.ALPHA_DISABLE),
                        this.particles.length
                    );
                }),
                (i.prototype.dispose = function () {
                    this._vertexBuffer && (this._scene.getEngine()._releaseBuffer(this._vertexBuffer), (this._vertexBuffer = null)),
                        this._indexBuffer && (this._scene.getEngine()._releaseBuffer(this._indexBuffer), (this._indexBuffer = null)),
                        this.particleTexture && (this.particleTexture.dispose(), (this.particleTexture = null));
                    var e = this._scene.particleSystems.indexOf(this);
                    this._scene.particleSystems.splice(e, 1), this.onDispose && this.onDispose();
                }),
                (i.prototype.clone = function (t, r) {
                    var n = new i(t, this._capacity, this._scene);
                    return (
                        e.Tools.DeepCopy(this, n, ["particles"], ["_vertexDeclaration", "_vertexStrideSize"]),
                        void 0 === r && (r = this.emitter),
                        (n.emitter = r),
                        this.particleTexture && (n.particleTexture = new e.Texture(this.particleTexture.url, this._scene)),
                        n.start(),
                        n
                    );
                }),
                (i.BLENDMODE_ONEONE = 0),
                (i.BLENDMODE_STANDARD = 1),
                i
            );
        })();
    e.ParticleSystem = i;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, i, r, n, o) {
            (this.name = e),
                (this.targetProperty = i),
                (this.framePerSecond = r),
                (this.dataType = n),
                (this.loopMode = o),
                (this._offsetsCache = {}),
                (this._highLimitsCache = {}),
                (this._stopped = !1),
                (this.allowMatricesInterpolation = !1),
                (this.targetPropertyPath = i.split(".")),
                (this.dataType = n),
                (this.loopMode = void 0 === o ? t.ANIMATIONLOOPMODE_CYCLE : o);
        }
        return (
            (t.CreateAndStartAnimation = function (i, r, n, o, s, a, h, l, c) {
                var u = void 0;
                if (
                    (!isNaN(parseFloat(a)) && isFinite(a)
                        ? (u = t.ANIMATIONTYPE_FLOAT)
                        : a instanceof e.Quaternion
                        ? (u = t.ANIMATIONTYPE_QUATERNION)
                        : a instanceof e.Vector3
                        ? (u = t.ANIMATIONTYPE_VECTOR3)
                        : a instanceof e.Vector2
                        ? (u = t.ANIMATIONTYPE_VECTOR2)
                        : a instanceof e.Color3 && (u = t.ANIMATIONTYPE_COLOR3),
                    void 0 == u)
                )
                    return null;
                var f = new t(i, n, o, u, l),
                    d = [];
                return d.push({ frame: 0, value: a }), d.push({ frame: s, value: h }), f.setKeys(d), void 0 !== c && f.setEasingFunction(c), r.animations.push(f), r.getScene().beginAnimation(r, 0, s, 1 === f.loopMode);
            }),
            (t.prototype.reset = function () {
                (this._offsetsCache = {}), (this._highLimitsCache = {}), (this.currentFrame = 0);
            }),
            (t.prototype.isStopped = function () {
                return this._stopped;
            }),
            (t.prototype.getKeys = function () {
                return this._keys;
            }),
            (t.prototype.getEasingFunction = function () {
                return this._easingFunction;
            }),
            (t.prototype.setEasingFunction = function (e) {
                this._easingFunction = e;
            }),
            (t.prototype.floatInterpolateFunction = function (e, t, i) {
                return e + (t - e) * i;
            }),
            (t.prototype.quaternionInterpolateFunction = function (t, i, r) {
                return e.Quaternion.Slerp(t, i, r);
            }),
            (t.prototype.vector3InterpolateFunction = function (t, i, r) {
                return e.Vector3.Lerp(t, i, r);
            }),
            (t.prototype.vector2InterpolateFunction = function (t, i, r) {
                return e.Vector2.Lerp(t, i, r);
            }),
            (t.prototype.color3InterpolateFunction = function (t, i, r) {
                return e.Color3.Lerp(t, i, r);
            }),
            (t.prototype.matrixInterpolateFunction = function (t, i, r) {
                var n = new e.Vector3(0, 0, 0),
                    o = new e.Quaternion(),
                    s = new e.Vector3(0, 0, 0);
                t.decompose(n, o, s);
                var a = new e.Vector3(0, 0, 0),
                    h = new e.Quaternion(),
                    l = new e.Vector3(0, 0, 0);
                i.decompose(a, h, l);
                var c = this.vector3InterpolateFunction(n, a, r),
                    u = this.quaternionInterpolateFunction(o, h, r),
                    f = this.vector3InterpolateFunction(s, l, r),
                    d = e.Matrix.Compose(c, u, f);
                return d;
            }),
            (t.prototype.clone = function () {
                var e = new t(this.name, this.targetPropertyPath.join("."), this.framePerSecond, this.dataType, this.loopMode);
                return e.setKeys(this._keys), e;
            }),
            (t.prototype.setKeys = function (e) {
                (this._keys = e.slice(0)), (this._offsetsCache = {}), (this._highLimitsCache = {});
            }),
            (t.prototype._getKeyValue = function (e) {
                return "function" == typeof e ? e() : e;
            }),
            (t.prototype._interpolate = function (e, i, r, n, o) {
                if (r === t.ANIMATIONLOOPMODE_CONSTANT && i > 0) return o.clone ? o.clone() : o;
                this.currentFrame = e;
                var s = Math.max(0, Math.min(this._keys.length - 1, Math.floor((this._keys.length * (e - this._keys[0].frame)) / (this._keys[this._keys.length - 1].frame - this._keys[0].frame)) - 1));
                if (this._keys[s].frame >= e) for (; s - 1 >= 0 && this._keys[s].frame >= e; ) s--;
                for (var a = s; a < this._keys.length; a++)
                    if (this._keys[a + 1].frame >= e) {
                        var h = this._getKeyValue(this._keys[a].value),
                            l = this._getKeyValue(this._keys[a + 1].value),
                            c = (e - this._keys[a].frame) / (this._keys[a + 1].frame - this._keys[a].frame);
                        switch ((null != this._easingFunction && (c = this._easingFunction.ease(c)), this.dataType)) {
                            case t.ANIMATIONTYPE_FLOAT:
                                switch (r) {
                                    case t.ANIMATIONLOOPMODE_CYCLE:
                                    case t.ANIMATIONLOOPMODE_CONSTANT:
                                        return this.floatInterpolateFunction(h, l, c);
                                    case t.ANIMATIONLOOPMODE_RELATIVE:
                                        return n * i + this.floatInterpolateFunction(h, l, c);
                                }
                                break;
                            case t.ANIMATIONTYPE_QUATERNION:
                                var u = null;
                                switch (r) {
                                    case t.ANIMATIONLOOPMODE_CYCLE:
                                    case t.ANIMATIONLOOPMODE_CONSTANT:
                                        u = this.quaternionInterpolateFunction(h, l, c);
                                        break;
                                    case t.ANIMATIONLOOPMODE_RELATIVE:
                                        u = this.quaternionInterpolateFunction(h, l, c).add(n.scale(i));
                                }
                                return u;
                            case t.ANIMATIONTYPE_VECTOR3:
                                switch (r) {
                                    case t.ANIMATIONLOOPMODE_CYCLE:
                                    case t.ANIMATIONLOOPMODE_CONSTANT:
                                        return this.vector3InterpolateFunction(h, l, c);
                                    case t.ANIMATIONLOOPMODE_RELATIVE:
                                        return this.vector3InterpolateFunction(h, l, c).add(n.scale(i));
                                }
                            case t.ANIMATIONTYPE_VECTOR2:
                                switch (r) {
                                    case t.ANIMATIONLOOPMODE_CYCLE:
                                    case t.ANIMATIONLOOPMODE_CONSTANT:
                                        return this.vector2InterpolateFunction(h, l, c);
                                    case t.ANIMATIONLOOPMODE_RELATIVE:
                                        return this.vector2InterpolateFunction(h, l, c).add(n.scale(i));
                                }
                            case t.ANIMATIONTYPE_COLOR3:
                                switch (r) {
                                    case t.ANIMATIONLOOPMODE_CYCLE:
                                    case t.ANIMATIONLOOPMODE_CONSTANT:
                                        return this.color3InterpolateFunction(h, l, c);
                                    case t.ANIMATIONLOOPMODE_RELATIVE:
                                        return this.color3InterpolateFunction(h, l, c).add(n.scale(i));
                                }
                            case t.ANIMATIONTYPE_MATRIX:
                                switch (r) {
                                    case t.ANIMATIONLOOPMODE_CYCLE:
                                    case t.ANIMATIONLOOPMODE_CONSTANT:
                                        if (this.allowMatricesInterpolation) return this.matrixInterpolateFunction(h, l, c);
                                    case t.ANIMATIONLOOPMODE_RELATIVE:
                                        return h;
                                }
                        }
                        break;
                    }
                return this._getKeyValue(this._keys[this._keys.length - 1].value);
            }),
            (t.prototype.animate = function (i, r, n, o, s) {
                if (!this.targetPropertyPath || this.targetPropertyPath.length < 1) return (this._stopped = !0), !1;
                var a = !0;
                if (0 !== this._keys[0].frame) {
                    var h = { frame: 0, value: this._keys[0].value };
                    this._keys.splice(0, 0, h);
                }
                (r < this._keys[0].frame || r > this._keys[this._keys.length - 1].frame) && (r = this._keys[0].frame),
                    (n < this._keys[0].frame || n > this._keys[this._keys.length - 1].frame) && (n = this._keys[this._keys.length - 1].frame);
                var l,
                    c = n - r,
                    u = (i * this.framePerSecond * s) / 1e3,
                    f = 0;
                if (u > c && !o) (a = !1), (f = this._getKeyValue(this._keys[this._keys.length - 1].value));
                else if (this.loopMode !== t.ANIMATIONLOOPMODE_CYCLE) {
                    var d = n.toString() + r.toString();
                    if (!this._offsetsCache[d]) {
                        var p = this._interpolate(r, 0, t.ANIMATIONLOOPMODE_CYCLE),
                            m = this._interpolate(n, 0, t.ANIMATIONLOOPMODE_CYCLE);
                        switch (this.dataType) {
                            case t.ANIMATIONTYPE_FLOAT:
                                this._offsetsCache[d] = m - p;
                                break;
                            case t.ANIMATIONTYPE_QUATERNION:
                                this._offsetsCache[d] = m.subtract(p);
                                break;
                            case t.ANIMATIONTYPE_VECTOR3:
                                this._offsetsCache[d] = m.subtract(p);
                            case t.ANIMATIONTYPE_VECTOR2:
                                this._offsetsCache[d] = m.subtract(p);
                            case t.ANIMATIONTYPE_COLOR3:
                                this._offsetsCache[d] = m.subtract(p);
                        }
                        this._highLimitsCache[d] = m;
                    }
                    (f = this._highLimitsCache[d]), (l = this._offsetsCache[d]);
                }
                if (void 0 === l)
                    switch (this.dataType) {
                        case t.ANIMATIONTYPE_FLOAT:
                            l = 0;
                            break;
                        case t.ANIMATIONTYPE_QUATERNION:
                            l = new e.Quaternion(0, 0, 0, 0);
                            break;
                        case t.ANIMATIONTYPE_VECTOR3:
                            l = e.Vector3.Zero();
                            break;
                        case t.ANIMATIONTYPE_VECTOR2:
                            l = e.Vector2.Zero();
                            break;
                        case t.ANIMATIONTYPE_COLOR3:
                            l = e.Color3.Black();
                    }
                var g = (u / c) >> 0,
                    _ = a ? r + (u % c) : n,
                    v = this._interpolate(_, g, this.loopMode, l, f);
                if (this.targetPropertyPath.length > 1) {
                    for (var y = this._target[this.targetPropertyPath[0]], x = 1; x < this.targetPropertyPath.length - 1; x++) y = y[this.targetPropertyPath[x]];
                    y[this.targetPropertyPath[this.targetPropertyPath.length - 1]] = v;
                } else this._target[this.targetPropertyPath[0]] = v;
                return this._target.markAsDirty && this._target.markAsDirty(this.targetProperty), a || (this._stopped = !0), a;
            }),
            Object.defineProperty(t, "ANIMATIONTYPE_FLOAT", {
                get: function () {
                    return t._ANIMATIONTYPE_FLOAT;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ANIMATIONTYPE_VECTOR3", {
                get: function () {
                    return t._ANIMATIONTYPE_VECTOR3;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ANIMATIONTYPE_VECTOR2", {
                get: function () {
                    return t._ANIMATIONTYPE_VECTOR2;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ANIMATIONTYPE_QUATERNION", {
                get: function () {
                    return t._ANIMATIONTYPE_QUATERNION;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ANIMATIONTYPE_MATRIX", {
                get: function () {
                    return t._ANIMATIONTYPE_MATRIX;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ANIMATIONTYPE_COLOR3", {
                get: function () {
                    return t._ANIMATIONTYPE_COLOR3;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ANIMATIONLOOPMODE_RELATIVE", {
                get: function () {
                    return t._ANIMATIONLOOPMODE_RELATIVE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ANIMATIONLOOPMODE_CYCLE", {
                get: function () {
                    return t._ANIMATIONLOOPMODE_CYCLE;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t, "ANIMATIONLOOPMODE_CONSTANT", {
                get: function () {
                    return t._ANIMATIONLOOPMODE_CONSTANT;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t._ANIMATIONTYPE_FLOAT = 0),
            (t._ANIMATIONTYPE_VECTOR3 = 1),
            (t._ANIMATIONTYPE_QUATERNION = 2),
            (t._ANIMATIONTYPE_MATRIX = 3),
            (t._ANIMATIONTYPE_COLOR3 = 4),
            (t._ANIMATIONTYPE_VECTOR2 = 5),
            (t._ANIMATIONLOOPMODE_RELATIVE = 0),
            (t._ANIMATIONLOOPMODE_CYCLE = 1),
            (t._ANIMATIONLOOPMODE_CONSTANT = 2),
            t
        );
    })();
    e.Animation = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e(e, t, i, r, n, o, s, a) {
            void 0 === i && (i = 0),
                void 0 === r && (r = 100),
                void 0 === n && (n = !1),
                void 0 === o && (o = 1),
                (this.target = t),
                (this.fromFrame = i),
                (this.toFrame = r),
                (this.loopAnimation = n),
                (this.speedRatio = o),
                (this.onAnimationEnd = s),
                (this._animations = new Array()),
                (this._paused = !1),
                (this.animationStarted = !1),
                a && this.appendAnimations(t, a),
                (this._scene = e),
                e._activeAnimatables.push(this);
        }
        return (
            (e.prototype.appendAnimations = function (e, t) {
                for (var i = 0; i < t.length; i++) {
                    var r = t[i];
                    (r._target = e), this._animations.push(r);
                }
            }),
            (e.prototype.getAnimationByTargetProperty = function (e) {
                for (var t = this._animations, i = 0; i < t.length; i++) if (t[i].targetProperty === e) return t[i];
                return null;
            }),
            (e.prototype.reset = function () {
                for (var e = this._animations, t = 0; t < e.length; t++) e[t].reset();
                (this._localDelayOffset = null), (this._pausedDelay = null);
            }),
            (e.prototype.pause = function () {
                this._paused || (this._paused = !0);
            }),
            (e.prototype.restart = function () {
                this._paused = !1;
            }),
            (e.prototype.stop = function () {
                var e = this._scene._activeAnimatables.indexOf(this);
                e > -1 && this._scene._activeAnimatables.splice(e, 1), this.onAnimationEnd && this.onAnimationEnd();
            }),
            (e.prototype._animate = function (e) {
                if (this._paused) return this._pausedDelay || (this._pausedDelay = e), !0;
                this._localDelayOffset ? this._pausedDelay && ((this._localDelayOffset += e - this._pausedDelay), (this._pausedDelay = null)) : (this._localDelayOffset = e);
                for (var t = !1, i = this._animations, r = 0; r < i.length; r++) {
                    var n = i[r],
                        o = n.animate(e - this._localDelayOffset, this.fromFrame, this.toFrame, this.loopAnimation, this.speedRatio);
                    t = t || o;
                }
                return t || ((r = this._scene._activeAnimatables.indexOf(this)), this._scene._activeAnimatables.splice(r, 1)), !t && this.onAnimationEnd && this.onAnimationEnd(), t;
            }),
            e
        );
    })();
    e.Animatable = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e() {
            this._easingMode = e.EASINGMODE_EASEIN;
        }
        return (
            Object.defineProperty(e, "EASINGMODE_EASEIN", {
                get: function () {
                    return e._EASINGMODE_EASEIN;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e, "EASINGMODE_EASEOUT", {
                get: function () {
                    return e._EASINGMODE_EASEOUT;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(e, "EASINGMODE_EASEINOUT", {
                get: function () {
                    return e._EASINGMODE_EASEINOUT;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (e.prototype.setEasingMode = function (e) {
                var t = Math.min(Math.max(e, 0), 2);
                this._easingMode = t;
            }),
            (e.prototype.getEasingMode = function () {
                return this._easingMode;
            }),
            (e.prototype.easeInCore = function (e) {
                throw new Error("You must implement this method");
            }),
            (e.prototype.ease = function (t) {
                switch (this._easingMode) {
                    case e.EASINGMODE_EASEIN:
                        return this.easeInCore(t);
                    case e.EASINGMODE_EASEOUT:
                        return 1 - this.easeInCore(1 - t);
                }
                return t >= 0.5 ? 0.5 * (1 - this.easeInCore(2 * (1 - t))) + 0.5 : 0.5 * this.easeInCore(2 * t);
            }),
            (e._EASINGMODE_EASEIN = 0),
            (e._EASINGMODE_EASEOUT = 1),
            (e._EASINGMODE_EASEINOUT = 2),
            e
        );
    })();
    e.EasingFunction = t;
    var i = (function (e) {
        function t() {
            e.apply(this, arguments);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                return (e = Math.max(0, Math.min(1, e))), 1 - Math.sqrt(1 - e * e);
            }),
            t
        );
    })(t);
    e.CircleEase = i;
    var r = (function (e) {
        function t(t) {
            void 0 === t && (t = 1), e.call(this), (this.amplitude = t);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                var t = Math.max(0, this.amplitude);
                return Math.pow(e, 3) - e * t * Math.sin(3.141592653589793 * e);
            }),
            t
        );
    })(t);
    e.BackEase = r;
    var n = (function (e) {
        function t(t, i) {
            void 0 === t && (t = 3), void 0 === i && (i = 2), e.call(this), (this.bounces = t), (this.bounciness = i);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                var t = Math.max(0, this.bounces),
                    i = this.bounciness;
                1 >= i && (i = 1.001);
                var r = Math.pow(i, t),
                    n = 1 - i,
                    o = (1 - r) / n + 0.5 * r,
                    s = e * o,
                    a = Math.log(-s * (1 - i) + 1) / Math.log(i),
                    h = Math.floor(a),
                    l = h + 1,
                    c = (1 - Math.pow(i, h)) / (n * o),
                    u = (1 - Math.pow(i, l)) / (n * o),
                    f = 0.5 * (c + u),
                    d = e - f,
                    p = f - c;
                return (-Math.pow(1 / i, t - h) / (p * p)) * (d - p) * (d + p);
            }),
            t
        );
    })(t);
    e.BounceEase = n;
    var o = (function (e) {
        function t() {
            e.apply(this, arguments);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                return e * e * e;
            }),
            t
        );
    })(t);
    e.CubicEase = o;
    var s = (function (e) {
        function t(t, i) {
            void 0 === t && (t = 3), void 0 === i && (i = 3), e.call(this), (this.oscillations = t), (this.springiness = i);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                var t,
                    i = Math.max(0, this.oscillations),
                    r = Math.max(0, this.springiness);
                return (t = 0 == r ? e : (Math.exp(r * e) - 1) / (Math.exp(r) - 1)), t * Math.sin((6.283185307179586 * i + 1.5707963267948966) * e);
            }),
            t
        );
    })(t);
    e.ElasticEase = s;
    var a = (function (e) {
        function t(t) {
            void 0 === t && (t = 2), e.call(this), (this.exponent = t);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                return this.exponent <= 0 ? e : (Math.exp(this.exponent * e) - 1) / (Math.exp(this.exponent) - 1);
            }),
            t
        );
    })(t);
    e.ExponentialEase = a;
    var h = (function (e) {
        function t(t) {
            void 0 === t && (t = 2), e.call(this), (this.power = t);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                var t = Math.max(0, this.power);
                return Math.pow(e, t);
            }),
            t
        );
    })(t);
    e.PowerEase = h;
    var l = (function (e) {
        function t() {
            e.apply(this, arguments);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                return e * e;
            }),
            t
        );
    })(t);
    e.QuadraticEase = l;
    var c = (function (e) {
        function t() {
            e.apply(this, arguments);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                return e * e * e * e;
            }),
            t
        );
    })(t);
    e.QuarticEase = c;
    var u = (function (e) {
        function t() {
            e.apply(this, arguments);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                return e * e * e * e * e;
            }),
            t
        );
    })(t);
    e.QuinticEase = u;
    var f = (function (e) {
        function t() {
            e.apply(this, arguments);
        }
        return (
            __extends(t, e),
            (t.prototype.easeInCore = function (e) {
                return 1 - Math.sin(1.5707963267948966 * (1 - e));
            }),
            t
        );
    })(t);
    e.SineEase = f;
    var d = (function (t) {
        function i(e, i, r, n) {
            void 0 === e && (e = 0), void 0 === i && (i = 0), void 0 === r && (r = 1), void 0 === n && (n = 1), t.call(this), (this.x1 = e), (this.y1 = i), (this.x2 = r), (this.y2 = n);
        }
        return (
            __extends(i, t),
            (i.prototype.easeInCore = function (t) {
                return e.BezierCurve.interpolate(t, this.x1, this.y1, this.x2, this.y2);
            }),
            i
        );
    })(t);
    e.BezierCurveEase = d;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i, r) {
            void 0 === r && (r = 2), (this.maxDepth = r), (this.dynamicContent = new Array()), (this._maxBlockCapacity = i || 64), (this._selectionContent = new e.SmartArray(1024)), (this._creationFunc = t);
        }
        return (
            (t.prototype.update = function (e, i, r) {
                t._CreateBlocks(e, i, r, this._maxBlockCapacity, 0, this.maxDepth, this, this._creationFunc);
            }),
            (t.prototype.addMesh = function (e) {
                for (var t = 0; t < this.blocks.length; t++) {
                    var i = this.blocks[t];
                    i.addEntry(e);
                }
            }),
            (t.prototype.select = function (e, t) {
                this._selectionContent.reset();
                for (var i = 0; i < this.blocks.length; i++) {
                    var r = this.blocks[i];
                    r.select(e, this._selectionContent, t);
                }
                return t ? this._selectionContent.concat(this.dynamicContent) : this._selectionContent.concatWithNoDuplicate(this.dynamicContent), this._selectionContent;
            }),
            (t.prototype.intersects = function (e, t, i) {
                this._selectionContent.reset();
                for (var r = 0; r < this.blocks.length; r++) {
                    var n = this.blocks[r];
                    n.intersects(e, t, this._selectionContent, i);
                }
                return i ? this._selectionContent.concat(this.dynamicContent) : this._selectionContent.concatWithNoDuplicate(this.dynamicContent), this._selectionContent;
            }),
            (t.prototype.intersectsRay = function (e) {
                this._selectionContent.reset();
                for (var t = 0; t < this.blocks.length; t++) {
                    var i = this.blocks[t];
                    i.intersectsRay(e, this._selectionContent);
                }
                return this._selectionContent.concatWithNoDuplicate(this.dynamicContent), this._selectionContent;
            }),
            (t._CreateBlocks = function (t, i, r, n, o, s, a, h) {
                a.blocks = new Array();
                for (var l = new e.Vector3((i.x - t.x) / 2, (i.y - t.y) / 2, (i.z - t.z) / 2), c = 0; 2 > c; c++)
                    for (var u = 0; 2 > u; u++)
                        for (var f = 0; 2 > f; f++) {
                            var d = t.add(l.multiplyByFloats(c, u, f)),
                                p = t.add(l.multiplyByFloats(c + 1, u + 1, f + 1)),
                                m = new e.OctreeBlock(d, p, n, o + 1, s, h);
                            m.addEntries(r), a.blocks.push(m);
                        }
            }),
            (t.CreationFuncForMeshes = function (e, t) {
                !e.isBlocked && e.getBoundingInfo().boundingBox.intersectsMinMax(t.minPoint, t.maxPoint) && t.entries.push(e);
            }),
            (t.CreationFuncForSubMeshes = function (e, t) {
                e.getBoundingInfo().boundingBox.intersectsMinMax(t.minPoint, t.maxPoint) && t.entries.push(e);
            }),
            t
        );
    })();
    e.Octree = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, t, i, r, n, o) {
            (this.entries = new Array()),
                (this._boundingVectors = new Array()),
                (this._capacity = i),
                (this._depth = r),
                (this._maxDepth = n),
                (this._creationFunc = o),
                (this._minPoint = e),
                (this._maxPoint = t),
                this._boundingVectors.push(e.clone()),
                this._boundingVectors.push(t.clone()),
                this._boundingVectors.push(e.clone()),
                (this._boundingVectors[2].x = t.x),
                this._boundingVectors.push(e.clone()),
                (this._boundingVectors[3].y = t.y),
                this._boundingVectors.push(e.clone()),
                (this._boundingVectors[4].z = t.z),
                this._boundingVectors.push(t.clone()),
                (this._boundingVectors[5].z = e.z),
                this._boundingVectors.push(t.clone()),
                (this._boundingVectors[6].x = e.x),
                this._boundingVectors.push(t.clone()),
                (this._boundingVectors[7].y = e.y);
        }
        return (
            Object.defineProperty(t.prototype, "capacity", {
                get: function () {
                    return this._capacity;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "minPoint", {
                get: function () {
                    return this._minPoint;
                },
                enumerable: !0,
                configurable: !0,
            }),
            Object.defineProperty(t.prototype, "maxPoint", {
                get: function () {
                    return this._maxPoint;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype.addEntry = function (e) {
                if (this.blocks)
                    for (var t = 0; t < this.blocks.length; t++) {
                        var i = this.blocks[t];
                        i.addEntry(e);
                    }
                else this._creationFunc(e, this), this.entries.length > this.capacity && this._depth < this._maxDepth && this.createInnerBlocks();
            }),
            (t.prototype.addEntries = function (e) {
                for (var t = 0; t < e.length; t++) {
                    var i = e[t];
                    this.addEntry(i);
                }
            }),
            (t.prototype.select = function (t, i, r) {
                if (e.BoundingBox.IsInFrustum(this._boundingVectors, t)) {
                    if (this.blocks) {
                        for (var n = 0; n < this.blocks.length; n++) {
                            var o = this.blocks[n];
                            o.select(t, i, r);
                        }
                        return;
                    }
                    r ? i.concat(this.entries) : i.concatWithNoDuplicate(this.entries);
                }
            }),
            (t.prototype.intersects = function (t, i, r, n) {
                if (e.BoundingBox.IntersectsSphere(this._minPoint, this._maxPoint, t, i)) {
                    if (this.blocks) {
                        for (var o = 0; o < this.blocks.length; o++) {
                            var s = this.blocks[o];
                            s.intersects(t, i, r, n);
                        }
                        return;
                    }
                    n ? r.concat(this.entries) : r.concatWithNoDuplicate(this.entries);
                }
            }),
            (t.prototype.intersectsRay = function (e, t) {
                if (e.intersectsBoxMinMax(this._minPoint, this._maxPoint)) {
                    if (this.blocks) {
                        for (var i = 0; i < this.blocks.length; i++) {
                            var r = this.blocks[i];
                            r.intersectsRay(e, t);
                        }
                        return;
                    }
                    t.concatWithNoDuplicate(this.entries);
                }
            }),
            (t.prototype.createInnerBlocks = function () {
                e.Octree._CreateBlocks(this._minPoint, this._maxPoint, this.entries, this._capacity, this._depth, this._maxDepth, this, this._creationFunc);
            }),
            t
        );
    })();
    e.OctreeBlock = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o) {
            t.call(this, i, r.getScene()),
                (this.name = i),
                (this.children = new Array()),
                (this.animations = new Array()),
                (this._worldTransform = new e.Matrix()),
                (this._absoluteTransform = new e.Matrix()),
                (this._invertedAbsoluteTransform = new e.Matrix()),
                (this._skeleton = r),
                (this._matrix = o),
                (this._baseMatrix = o),
                r.bones.push(this),
                n ? ((this._parent = n), n.children.push(this)) : (this._parent = null),
                this._updateDifferenceMatrix();
        }
        return (
            __extends(i, t),
            (i.prototype.getParent = function () {
                return this._parent;
            }),
            (i.prototype.getLocalMatrix = function () {
                return this._matrix;
            }),
            (i.prototype.getBaseMatrix = function () {
                return this._baseMatrix;
            }),
            (i.prototype.getWorldMatrix = function () {
                return this._worldTransform;
            }),
            (i.prototype.getInvertedAbsoluteTransform = function () {
                return this._invertedAbsoluteTransform;
            }),
            (i.prototype.getAbsoluteMatrix = function () {
                for (var e = this._matrix.clone(), t = this._parent; t; ) (e = e.multiply(t.getLocalMatrix())), (t = t.getParent());
                return e;
            }),
            (i.prototype.updateMatrix = function (e) {
                (this._matrix = e), this._skeleton._markAsDirty(), this._updateDifferenceMatrix();
            }),
            (i.prototype._updateDifferenceMatrix = function () {
                this._parent ? this._matrix.multiplyToRef(this._parent._absoluteTransform, this._absoluteTransform) : this._absoluteTransform.copyFrom(this._matrix), this._absoluteTransform.invertToRef(this._invertedAbsoluteTransform);
                for (var e = 0; e < this.children.length; e++) this.children[e]._updateDifferenceMatrix();
            }),
            (i.prototype.markAsDirty = function () {
                this._currentRenderId++, this._skeleton._markAsDirty();
            }),
            i
        );
    })(e.Node);
    e.Bone = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i, r) {
            (this.name = t), (this.id = i), (this.bones = new Array()), (this._isDirty = !0), (this._identity = e.Matrix.Identity()), (this.bones = []), (this._scene = r), r.skeletons.push(this), this.prepare(), (this._isDirty = !0);
        }
        return (
            (t.prototype.getTransformMatrices = function () {
                return this._transformMatrices;
            }),
            (t.prototype.getScene = function () {
                return this._scene;
            }),
            (t.prototype._markAsDirty = function () {
                this._isDirty = !0;
            }),
            (t.prototype.prepare = function () {
                if (this._isDirty) {
                    (this._transformMatrices && this._transformMatrices.length === 16 * (this.bones.length + 1)) || (this._transformMatrices = new Float32Array(16 * (this.bones.length + 1)));
                    for (var e = 0; e < this.bones.length; e++) {
                        var t = this.bones[e],
                            i = t.getParent();
                        i ? t.getLocalMatrix().multiplyToRef(i.getWorldMatrix(), t.getWorldMatrix()) : t.getWorldMatrix().copyFrom(t.getLocalMatrix()),
                            t.getInvertedAbsoluteTransform().multiplyToArray(t.getWorldMatrix(), this._transformMatrices, 16 * e);
                    }
                    this._identity.copyToArray(this._transformMatrices, 16 * this.bones.length), (this._isDirty = !1), (this._scene._activeBones += this.bones.length);
                }
            }),
            (t.prototype.getAnimatables = function () {
                if (!this._animatables || this._animatables.length !== this.bones.length) {
                    this._animatables = [];
                    for (var e = 0; e < this.bones.length; e++) this._animatables.push(this.bones[e]);
                }
                return this._animatables;
            }),
            (t.prototype.clone = function (i, r) {
                for (var n = new t(i, r || i, this._scene), o = 0; o < this.bones.length; o++) {
                    var s = this.bones[o],
                        a = null;
                    if (s.getParent()) {
                        var h = this.bones.indexOf(s.getParent());
                        a = n.bones[h];
                    }
                    var l = new e.Bone(s.name, n, a, s.getBaseMatrix());
                    e.Tools.DeepCopy(s.animations, l.animations);
                }
                return n;
            }),
            t
        );
    })();
    e.Skeleton = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i, r, n, o, s, a, h, l, c, u) {
            void 0 === a && (a = e.Texture.NEAREST_SAMPLINGMODE),
                void 0 === u && (u = e.Engine.TEXTURETYPE_UNSIGNED_INT),
                (this.name = t),
                (this.width = -1),
                (this.height = -1),
                (this._reusable = !1),
                (this._textures = new e.SmartArray(2)),
                (this._currentRenderTextureInd = 0),
                null != s ? ((this._camera = s), (this._scene = s.getScene()), s.attachPostProcess(this), (this._engine = this._scene.getEngine())) : (this._engine = h),
                (this._renderRatio = o),
                (this.renderTargetSamplingMode = a ? a : e.Texture.NEAREST_SAMPLINGMODE),
                (this._reusable = l || !1),
                (this._textureType = u),
                (n = n || []),
                n.push("textureSampler"),
                (this._effect = this._engine.createEffect({ vertex: "postprocess", fragment: i }, ["position"], r || [], n, void 0 !== c ? c : ""));
        }
        return (
            (t.prototype.isReusable = function () {
                return this._reusable;
            }),
            (t.prototype.activate = function (t, i) {
                t = t || this._camera;
                var r = t.getScene(),
                    n = t.getEngine().getCaps().maxTextureSize,
                    o = ((i ? i._width : this._engine.getRenderingCanvas().width) * this._renderRatio) | 0,
                    s = ((i ? i._height : this._engine.getRenderingCanvas().height) * this._renderRatio) | 0;
                if (((o = this._renderRatio.width || e.Tools.GetExponantOfTwo(o, n)), (s = this._renderRatio.height || e.Tools.GetExponantOfTwo(s, n)), this.width !== o || this.height !== s)) {
                    if (this._textures.length > 0) {
                        for (var a = 0; a < this._textures.length; a++) this._engine._releaseTexture(this._textures.data[a]);
                        this._textures.reset();
                    }
                    (this.width = o),
                        (this.height = s),
                        this._textures.push(
                            this._engine.createRenderTargetTexture(
                                { width: this.width, height: this.height },
                                { generateMipMaps: !1, generateDepthBuffer: t._postProcesses.indexOf(this) === t._postProcessesTakenIndices[0], samplingMode: this.renderTargetSamplingMode, type: this._textureType }
                            )
                        ),
                        this._reusable &&
                            this._textures.push(
                                this._engine.createRenderTargetTexture(
                                    { width: this.width, height: this.height },
                                    { generateMipMaps: !1, generateDepthBuffer: t._postProcesses.indexOf(this) === t._postProcessesTakenIndices[0], samplingMode: this.renderTargetSamplingMode, type: this._textureType }
                                )
                            ),
                        this.onSizeChanged && this.onSizeChanged();
                }
                this._engine.bindFramebuffer(this._textures.data[this._currentRenderTextureInd]),
                    this.onActivate && this.onActivate(t),
                    this.clearColor ? this._engine.clear(this.clearColor, !0, !0) : this._engine.clear(r.clearColor, r.autoClear || r.forceWireframe, !0),
                    this._reusable && (this._currentRenderTextureInd = (this._currentRenderTextureInd + 1) % 2);
            }),
            (t.prototype.apply = function () {
                return this._effect.isReady()
                    ? (this._engine.enableEffect(this._effect),
                      this._engine.setState(!1),
                      this._engine.setAlphaMode(e.Engine.ALPHA_DISABLE),
                      this._engine.setDepthBuffer(!1),
                      this._engine.setDepthWrite(!1),
                      this._effect._bindTexture("textureSampler", this._textures.data[this._currentRenderTextureInd]),
                      this.onApply && this.onApply(this._effect),
                      this._effect)
                    : null;
            }),
            (t.prototype.dispose = function (e) {
                if (((e = e || this._camera), this._textures.length > 0)) {
                    for (var t = 0; t < this._textures.length; t++) this._engine._releaseTexture(this._textures.data[t]);
                    this._textures.reset();
                }
                if (e) {
                    e.detachPostProcess(this);
                    var i = e._postProcesses.indexOf(this);
                    i === e._postProcessesTakenIndices[0] && e._postProcessesTakenIndices.length > 0 && (this._camera._postProcesses[e._postProcessesTakenIndices[0]].width = -1);
                }
            }),
            t
        );
    })();
    e.PostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e(e) {
            (this._vertexDeclaration = [2]), (this._vertexStrideSize = 8), (this._scene = e);
        }
        return (
            (e.prototype._prepareBuffers = function () {
                if (!this._vertexBuffer) {
                    var e = [];
                    e.push(1, 1), e.push(-1, 1), e.push(-1, -1), e.push(1, -1), (this._vertexBuffer = this._scene.getEngine().createVertexBuffer(e));
                    var t = [];
                    t.push(0), t.push(1), t.push(2), t.push(0), t.push(2), t.push(3), (this._indexBuffer = this._scene.getEngine().createIndexBuffer(t));
                }
            }),
            (e.prototype._prepareFrame = function (e) {
                var t = this._scene.activeCamera._postProcesses,
                    i = this._scene.activeCamera._postProcessesTakenIndices;
                return 0 !== i.length && this._scene.postProcessesEnabled ? (t[this._scene.activeCamera._postProcessesTakenIndices[0]].activate(this._scene.activeCamera, e), !0) : !1;
            }),
            (e.prototype.directRender = function (e, t) {
                for (var i = this._scene.getEngine(), r = 0; r < e.length; r++) {
                    r < e.length - 1 ? e[r + 1].activate(this._scene.activeCamera, t) : t ? i.bindFramebuffer(t) : i.restoreDefaultFramebuffer();
                    var n = e[r],
                        o = n.apply();
                    o &&
                        (n.onBeforeRender && n.onBeforeRender(o),
                        this._prepareBuffers(),
                        i.bindBuffers(this._vertexBuffer, this._indexBuffer, this._vertexDeclaration, this._vertexStrideSize, o),
                        i.draw(!0, 0, 6),
                        n.onAfterRender && n.onAfterRender(o));
                }
                i.setDepthBuffer(!0), i.setDepthWrite(!0);
            }),
            (e.prototype._finalizeFrame = function (e, t, i) {
                i = i || this._scene.activeCamera._postProcesses;
                var r = this._scene.activeCamera._postProcessesTakenIndices;
                if (0 !== r.length && this._scene.postProcessesEnabled) {
                    for (var n = this._scene.getEngine(), o = 0; o < r.length && (o < r.length - 1 ? i[r[o + 1]].activate(this._scene.activeCamera) : t ? n.bindFramebuffer(t) : n.restoreDefaultFramebuffer(), !e); o++) {
                        var s = i[r[o]],
                            a = s.apply();
                        a &&
                            (s.onBeforeRender && s.onBeforeRender(a),
                            this._prepareBuffers(),
                            n.bindBuffers(this._vertexBuffer, this._indexBuffer, this._vertexDeclaration, this._vertexStrideSize, a),
                            n.draw(!0, 0, 6),
                            s.onAfterRender && s.onAfterRender(a));
                    }
                    n.setDepthBuffer(!0), n.setDepthWrite(!0);
                }
            }),
            (e.prototype.dispose = function () {
                this._vertexBuffer && (this._scene.getEngine()._releaseBuffer(this._vertexBuffer), (this._vertexBuffer = null)), this._indexBuffer && (this._scene.getEngine()._releaseBuffer(this._indexBuffer), (this._indexBuffer = null));
            }),
            e
        );
    })();
    e.PostProcessManager = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i, r, n, o, s) {
            e.call(this, t, "pass", null, null, i, r, n, o, s);
        }
        return __extends(t, e), t;
    })(e.PostProcess);
    e.PassPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o, s, a, h, l) {
            var c = this;
            void 0 === a && (a = e.Texture.BILINEAR_SAMPLINGMODE),
                t.call(this, i, "blur", ["screenSize", "direction", "blurWidth"], null, o, s, a, h, l),
                (this.direction = r),
                (this.blurWidth = n),
                (this.onApply = function (e) {
                    e.setFloat2("screenSize", c.width, c.height), e.setVector2("direction", c.direction), e.setFloat("blurWidth", c.blurWidth);
                });
        }
        return __extends(i, t), i;
    })(e.PostProcess);
    e.BlurPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o, s, a, h, l, c, u) {
            var f = this;
            t.call(this, i, "refraction", ["baseColor", "depth", "colorLevel"], ["refractionSampler"], a, h, l, c, u),
                (this.color = n),
                (this.depth = o),
                (this.colorLevel = s),
                (this.onActivate = function (t) {
                    f._refRexture = f._refRexture || new e.Texture(r, t.getScene());
                }),
                (this.onApply = function (e) {
                    e.setColor3("baseColor", f.color), e.setFloat("depth", f.depth), e.setFloat("colorLevel", f.colorLevel), e.setTexture("refractionSampler", f._refRexture);
                });
        }
        return (
            __extends(i, t),
            (i.prototype.dispose = function (e) {
                this._refRexture && this._refRexture.dispose(), t.prototype.dispose.call(this, e);
            }),
            i
        );
    })(e.PostProcess);

    e.RefractionPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i, r, n, o, s) {
            e.call(this, t, "blackAndWhite", null, null, i, r, n, o, s);
        }
        return __extends(t, e), t;
    })(e.PostProcess);
    e.BlackAndWhitePostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i, r, n, o, s, a) {
            var h = this;
            e.call(this, t, "convolution", ["kernel", "screenSize"], null, r, n, o, s, a),
                (this.kernel = i),
                (this.onApply = function (e) {
                    e.setFloat2("screenSize", h.width, h.height), e.setArray("kernel", h.kernel);
                });
        }
        return (
            __extends(t, e),
            (t.EdgeDetect0Kernel = [1, 0, -1, 0, 0, 0, -1, 0, 1]),
            (t.EdgeDetect1Kernel = [0, 1, 0, 1, -4, 1, 0, 1, 0]),
            (t.EdgeDetect2Kernel = [-1, -1, -1, -1, 8, -1, -1, -1, -1]),
            (t.SharpenKernel = [0, -1, 0, -1, 5, -1, 0, -1, 0]),
            (t.EmbossKernel = [-2, -1, 0, -1, 1, 1, 0, 1, 2]),
            (t.GaussianKernel = [0, 1, 0, 1, 1, 1, 0, 1, 0]),
            t
        );
    })(e.PostProcess);
    e.ConvolutionPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i, r, n, o, s, a) {
            var h = this;
            e.call(this, t, "filter", ["kernelMatrix"], null, r, n, o, s, a),
                (this.kernelMatrix = i),
                (this.onApply = function (e) {
                    e.setMatrix("kernelMatrix", h.kernelMatrix);
                });
        }
        return __extends(t, e), t;
    })(e.PostProcess);
    e.FilterPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i, r, n, o, s) {
            var a = this;
            e.call(this, t, "fxaa", ["texelSize"], null, i, r, n, o, s),
                (this.onSizeChanged = function () {
                    (a.texelWidth = 1 / a.width), (a.texelHeight = 1 / a.height);
                }),
                (this.onApply = function (e) {
                    e.setFloat2("texelSize", a.texelWidth, a.texelHeight);
                });
        }
        return __extends(t, e), t;
    })(e.PostProcess);
    e.FxaaPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o, s) {
            var a = this;
            t.call(this, i, "stereoscopicInterlace", ["stepSize"], ["camASampler"], 1, r, s, r.getScene().getEngine(), !1, o ? "#define IS_STEREOSCOPIC_HORIZ 1" : void 0),
                (this._stepSize = new e.Vector2(1 / this.width, 1 / this.height)),
                (this.onSizeChanged = function () {
                    a._stepSize = new e.Vector2(1 / a.width, 1 / a.height);
                }),
                (this.onApply = function (e) {
                    e.setTextureFromPostProcess("camASampler", n), e.setFloat2("stepSize", a._stepSize.x, a._stepSize.y);
                });
        }
        return __extends(i, t), i;
    })(e.PostProcess);
    e.StereoscopicInterlacePostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i, r, n, o) {
            (this.size = t),
                (this.position = i),
                (this.dispose = function () {
                    this.texture && this.texture.dispose();
                    var e = this._system.lensFlares.indexOf(this);
                    this._system.lensFlares.splice(e, 1);
                }),
                (this.color = r || new e.Color3(1, 1, 1)),
                (this.texture = n ? new e.Texture(n, o.getScene(), !0) : null),
                (this._system = o),
                o.lensFlares.push(this);
        }
        return t;
    })();
    e.LensFlare = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, t, i) {
            (this.name = e),
                (this.lensFlares = new Array()),
                (this.borderLimit = 300),
                (this.layerMask = 268435455),
                (this._vertexDeclaration = [2]),
                (this._vertexStrideSize = 8),
                (this._isEnabled = !0),
                (this._scene = i),
                (this._emitter = t),
                i.lensFlareSystems.push(this),
                (this.meshesSelectionPredicate = function (e) {
                    return e.material && e.isVisible && e.isEnabled() && e.isBlocker && 0 != (e.layerMask & i.activeCamera.layerMask);
                });
            var r = [];
            r.push(1, 1), r.push(-1, 1), r.push(-1, -1), r.push(1, -1), (this._vertexBuffer = i.getEngine().createVertexBuffer(r));
            var n = [];
            n.push(0),
                n.push(1),
                n.push(2),
                n.push(0),
                n.push(2),
                n.push(3),
                (this._indexBuffer = i.getEngine().createIndexBuffer(n)),
                (this._effect = this._scene.getEngine().createEffect("lensFlare", ["position"], ["color", "viewportMatrix"], ["textureSampler"], ""));
        }
        return (
            Object.defineProperty(t.prototype, "isEnabled", {
                get: function () {
                    return this._isEnabled;
                },
                set: function (e) {
                    this._isEnabled = e;
                },
                enumerable: !0,
                configurable: !0,
            }),
            (t.prototype.getScene = function () {
                return this._scene;
            }),
            (t.prototype.getEmitter = function () {
                return this._emitter;
            }),
            (t.prototype.setEmitter = function (e) {
                this._emitter = e;
            }),
            (t.prototype.getEmitterPosition = function () {
                return this._emitter.getAbsolutePosition ? this._emitter.getAbsolutePosition() : this._emitter.position;
            }),
            (t.prototype.computeEffectivePosition = function (t) {
                var i = this.getEmitterPosition();
                return (
                    (i = e.Vector3.Project(i, e.Matrix.Identity(), this._scene.getTransformMatrix(), t)),
                    (this._positionX = i.x),
                    (this._positionY = i.y),
                    (i = e.Vector3.TransformCoordinates(this.getEmitterPosition(), this._scene.getViewMatrix())),
                    i.z > 0 && this._positionX > t.x && this._positionX < t.x + t.width && this._positionY > t.y && this._positionY < t.y + t.height ? !0 : !1
                );
            }),
            (t.prototype._isVisible = function () {
                if (!this._isEnabled) return !1;
                var t = this.getEmitterPosition(),
                    i = t.subtract(this._scene.activeCamera.position),
                    r = i.length();
                i.normalize();
                var n = new e.Ray(this._scene.activeCamera.position, i),
                    o = this._scene.pickWithRay(n, this.meshesSelectionPredicate, !0);
                return !o.hit || o.distance > r;
            }),
            (t.prototype.render = function () {
                if (!this._effect.isReady()) return !1;
                var t = this._scene.getEngine(),
                    i = this._scene.activeCamera.viewport,
                    r = i.toGlobal(t);
                if (!this.computeEffectivePosition(r)) return !1;
                if (!this._isVisible()) return !1;
                var n, o;
                (n = this._positionX < this.borderLimit + r.x ? this.borderLimit + r.x - this._positionX : this._positionX > r.x + r.width - this.borderLimit ? this._positionX - r.x - r.width + this.borderLimit : 0),
                    (o = this._positionY < this.borderLimit + r.y ? this.borderLimit + r.y - this._positionY : this._positionY > r.y + r.height - this.borderLimit ? this._positionY - r.y - r.height + this.borderLimit : 0);
                var s = n > o ? n : o;
                s > this.borderLimit && (s = this.borderLimit);
                var a = 1 - s / this.borderLimit;
                if (0 > a) return !1;
                a > 1 && (a = 1);
                var h = r.x + r.width / 2,
                    l = r.y + r.height / 2,
                    c = h - this._positionX,
                    u = l - this._positionY;
                t.enableEffect(this._effect), t.setState(!1), t.setDepthBuffer(!1), t.setAlphaMode(e.Engine.ALPHA_ONEONE), t.bindBuffers(this._vertexBuffer, this._indexBuffer, this._vertexDeclaration, this._vertexStrideSize, this._effect);
                for (var f = 0; f < this.lensFlares.length; f++) {
                    var d = this.lensFlares[f],
                        p = h - c * d.position,
                        m = l - u * d.position,
                        g = d.size,
                        _ = d.size * t.getAspectRatio(this._scene.activeCamera),
                        v = 2 * (p / r.width) - 1,
                        y = 1 - 2 * (m / r.height),
                        x = e.Matrix.FromValues(g / 2, 0, 0, 0, 0, _ / 2, 0, 0, 0, 0, 1, 0, v, y, 0, 1);
                    this._effect.setMatrix("viewportMatrix", x), this._effect.setTexture("textureSampler", d.texture), this._effect.setFloat4("color", d.color.r * a, d.color.g * a, d.color.b * a, 1), t.draw(!0, 0, 6);
                }
                return t.setDepthBuffer(!0), t.setAlphaMode(e.Engine.ALPHA_DISABLE), !0;
            }),
            (t.prototype.dispose = function () {
                for (
                    this._vertexBuffer && (this._scene.getEngine()._releaseBuffer(this._vertexBuffer), (this._vertexBuffer = null)),
                        this._indexBuffer && (this._scene.getEngine()._releaseBuffer(this._indexBuffer), (this._indexBuffer = null));
                    this.lensFlares.length;

                )
                    this.lensFlares[0].dispose();
                var e = this._scene.lensFlareSystems.indexOf(this);
                this._scene.lensFlareSystems.splice(e, 1);
            }),
            t
        );
    })();
    e.LensFlareSystem = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t() {
            (this._registeredMeshes = []),
                (this._physicsMaterials = []),
                (this.updateBodyPosition = function (e) {
                    for (var t = 0; t < this._registeredMeshes.length; t++) {
                        var i = this._registeredMeshes[t];
                        if (i.mesh === e || i.mesh === e.parent) {
                            var r = i.body,
                                n = e.getBoundingInfo().boundingBox.center;
                            return (
                                r.position.set(n.x, n.z, n.y), (r.quaternion.x = e.rotationQuaternion.x), (r.quaternion.z = e.rotationQuaternion.y), (r.quaternion.y = e.rotationQuaternion.z), void (r.quaternion.w = -e.rotationQuaternion.w)
                            );
                        }
                    }
                });
        }
        return (
            (t.prototype.initialize = function (e) {
                void 0 === e && (e = 10), (this._world = new CANNON.World()), (this._world.broadphase = new CANNON.NaiveBroadphase()), (this._world.solver.iterations = e);
            }),
            (t.prototype._checkWithEpsilon = function (t) {
                return t < e.PhysicsEngine.Epsilon ? e.PhysicsEngine.Epsilon : t;
            }),
            (t.prototype.runOneStep = function (t) {
                this._world.step(t);
                for (var i = 0; i < this._registeredMeshes.length; i++) {
                    var r = this._registeredMeshes[i];
                    if (!r.isChild) {
                        var n = r.body.position.x,
                            o = r.body.position.y,
                            s = r.body.position.z,
                            a = r.delta;
                        a ? ((r.mesh.position.x = n + a.x), (r.mesh.position.y = s + a.y), (r.mesh.position.z = o + a.z)) : ((r.mesh.position.x = n), (r.mesh.position.y = s), (r.mesh.position.z = o)),
                            r.mesh.rotationQuaternion || (r.mesh.rotationQuaternion = new e.Quaternion(0, 0, 0, 1)),
                            (r.mesh.rotationQuaternion.x = r.body.quaternion.x),
                            (r.mesh.rotationQuaternion.y = r.body.quaternion.z),
                            (r.mesh.rotationQuaternion.z = r.body.quaternion.y),
                            (r.mesh.rotationQuaternion.w = -r.body.quaternion.w);
                    }
                }
            }),
            (t.prototype.setGravity = function (e) {
                this._world.gravity.set(e.x, e.z, e.y);
            }),
            (t.prototype.registerMesh = function (t, i, r) {
                switch ((this.unregisterMesh(t), t.computeWorldMatrix(!0), i)) {
                    case e.PhysicsEngine.SphereImpostor:
                        var n = t.getBoundingInfo().boundingBox,
                            o = n.maximumWorld.x - n.minimumWorld.x,
                            s = n.maximumWorld.y - n.minimumWorld.y,
                            a = n.maximumWorld.z - n.minimumWorld.z;
                        return this._createSphere(Math.max(this._checkWithEpsilon(o), this._checkWithEpsilon(s), this._checkWithEpsilon(a)) / 2, t, r);
                    case e.PhysicsEngine.BoxImpostor:
                        n = t.getBoundingInfo().boundingBox;
                        var h = n.minimumWorld,
                            l = n.maximumWorld,
                            c = l.subtract(h).scale(0.5);
                        return this._createBox(this._checkWithEpsilon(c.x), this._checkWithEpsilon(c.y), this._checkWithEpsilon(c.z), t, r);
                    case e.PhysicsEngine.PlaneImpostor:
                        return this._createPlane(t, r);
                    case e.PhysicsEngine.MeshImpostor:
                        var u = t.getVerticesData(e.VertexBuffer.PositionKind),
                            f = t.getIndices();
                        return this._createConvexPolyhedron(u, f, t, r);
                }
                return null;
            }),
            (t.prototype._createSphere = function (e, t, i) {
                var r = new CANNON.Sphere(e);
                return i ? this._createRigidBodyFromShape(r, t, i.mass, i.friction, i.restitution) : r;
            }),
            (t.prototype._createBox = function (e, t, i, r, n) {
                var o = new CANNON.Box(new CANNON.Vec3(e, i, t));
                return n ? this._createRigidBodyFromShape(o, r, n.mass, n.friction, n.restitution) : o;
            }),
            (t.prototype._createPlane = function (e, t) {
                var i = new CANNON.Plane();
                return t ? this._createRigidBodyFromShape(i, e, t.mass, t.friction, t.restitution) : i;
            }),
            (t.prototype._createConvexPolyhedron = function (t, i, r, n) {
                var o = [],
                    s = [];
                r.computeWorldMatrix(!0);
                for (var a = 0; a < t.length; a += 3) {
                    var h = e.Vector3.Zero();
                    e.Vector3.TransformNormalFromFloatsToRef(t[a], t[a + 1], t[a + 2], r.getWorldMatrix(), h), o.push(new CANNON.Vec3(h.x, h.z, h.y));
                }
                for (var l = 0; l < i.length; l += 3) s.push([i[l], i[l + 2], i[l + 1]]);
                var c = new CANNON.ConvexPolyhedron(o, s);
                return n ? this._createRigidBodyFromShape(c, r, n.mass, n.friction, n.restitution) : c;
            }),
            (t.prototype._addMaterial = function (e, t) {
                var i, r;
                for (i = 0; i < this._physicsMaterials.length; i++) if (((r = this._physicsMaterials[i]), r.friction === e && r.restitution === t)) return r;
                var n = new CANNON.Material();
                for (n.friction = e, n.restitution = t, this._physicsMaterials.push(n), i = 0; i < this._physicsMaterials.length; i++) {
                    r = this._physicsMaterials[i];
                    var o = new CANNON.ContactMaterial(r, n, r.friction * n.friction, r.restitution * n.restitution);
                    (o.contactEquationStiffness = 1e10), (o.contactEquationRegularizationTime = 10), this._world.addContactMaterial(o);
                }
                return n;
            }),
            (t.prototype._createRigidBodyFromShape = function (t, i, r, n, o) {
                var s = null;
                i.rotationQuaternion && ((s = i.rotationQuaternion.clone()), (i.rotationQuaternion = new e.Quaternion(0, 0, 0, 1)));
                var a = i.getBoundingInfo().boundingBox,
                    h = i.position.subtract(a.center),
                    l = this._addMaterial(n, o),
                    c = new CANNON.RigidBody(r, t, l);
                return (
                    s && ((c.quaternion.x = s.x), (c.quaternion.z = s.y), (c.quaternion.y = s.z), (c.quaternion.w = -s.w)),
                    c.position.set(a.center.x, a.center.z, a.center.y),
                    this._world.add(c),
                    this._registeredMeshes.push({ mesh: i, body: c, material: l, delta: h }),
                    c
                );
            }),
            (t.prototype.registerMeshesAsCompound = function (e, t) {
                for (var i = new CANNON.Compound(), r = 0; r < e.length; r++) {
                    var n = e[r].mesh,
                        o = this.registerMesh(n, e[r].impostor);
                    0 == r ? i.addChild(o, new CANNON.Vec3(0, 0, 0)) : i.addChild(o, new CANNON.Vec3(n.position.x, n.position.z, n.position.y));
                }
                var s = e[0].mesh,
                    a = this._createRigidBodyFromShape(i, s, t.mass, t.friction, t.restitution);
                return (a.parts = e), a;
            }),
            (t.prototype._unbindBody = function (e) {
                for (var t = 0; t < this._registeredMeshes.length; t++) {
                    var i = this._registeredMeshes[t];
                    i.body === e && ((i.body = null), (i.delta = 0));
                }
            }),
            (t.prototype.unregisterMesh = function (e) {
                for (var t = 0; t < this._registeredMeshes.length; t++) {
                    var i = this._registeredMeshes[t];
                    if (i.mesh === e) return i.body && (this._world.remove(i.body), this._unbindBody(i.body)), void this._registeredMeshes.splice(t, 1);
                }
            }),
            (t.prototype.applyImpulse = function (e, t, i) {
                for (var r = new CANNON.Vec3(i.x, i.z, i.y), n = new CANNON.Vec3(t.x, t.z, t.y), o = 0; o < this._registeredMeshes.length; o++) {
                    var s = this._registeredMeshes[o];
                    if (s.mesh === e) return void s.body.applyImpulse(n, r);
                }
            }),
            (t.prototype.createLink = function (e, t, i, r) {
                for (var n = null, o = null, s = 0; s < this._registeredMeshes.length; s++) {
                    var a = this._registeredMeshes[s];
                    a.mesh === e ? (n = a.body) : a.mesh === t && (o = a.body);
                }
                if (!n || !o) return !1;
                var h = new CANNON.PointToPointConstraint(n, new CANNON.Vec3(i.x, i.z, i.y), o, new CANNON.Vec3(r.x, r.z, r.y));
                return this._world.addConstraint(h), !0;
            }),
            (t.prototype.dispose = function () {
                for (; this._registeredMeshes.length; ) this.unregisterMesh(this._registeredMeshes[0].mesh);
            }),
            (t.prototype.isSupported = function () {
                return void 0 !== window.CANNON;
            }),
            t
        );
    })();
    e.CannonJSPlugin = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t() {
            (this._registeredMeshes = []),
                (this.updateBodyPosition = function (e) {
                    for (var t = 0; t < this._registeredMeshes.length; t++) {
                        var i = this._registeredMeshes[t];
                        if (i.mesh === e || i.mesh === e.parent) {
                            var r = i.body.body;
                            e.computeWorldMatrix(!0);
                            var n = e.getBoundingInfo().boundingBox.center;
                            return r.setPosition(new OIMO.Vec3(n.x, n.y, n.z)), r.setRotation(new OIMO.Vec3(e.rotation.x, e.rotation.y, e.rotation.z)), void (r.sleeping = !1);
                        }
                        if (i.mesh.parent === e) {
                            e.computeWorldMatrix(!0), i.mesh.computeWorldMatrix(!0);
                            var o = i.mesh.getAbsolutePosition(),
                                s = e.rotation;
                            return (r = i.body.body), r.setPosition(new OIMO.Vec3(o.x, o.y, o.z)), r.setRotation(new OIMO.Vec3(s.x, s.y, s.z)), void (r.sleeping = !1);
                        }
                    }
                });
        }
        return (
            (t.prototype._checkWithEpsilon = function (t) {
                return t < e.PhysicsEngine.Epsilon ? e.PhysicsEngine.Epsilon : t;
            }),
            (t.prototype.initialize = function (e) {
                (this._world = new OIMO.World()), this._world.clear();
            }),
            (t.prototype.setGravity = function (e) {
                this._world.gravity = e;
            }),
            (t.prototype.registerMesh = function (t, i, r) {
                var n = null;
                this.unregisterMesh(t), t.computeWorldMatrix(!0);
                var o = null;
                t.rotationQuaternion && ((o = t.rotationQuaternion.clone()), (t.rotationQuaternion = new e.Quaternion(0, 0, 0, 1)), t.computeWorldMatrix(!0));
                var s = t.getBoundingInfo().boundingBox,
                    a = t.position.subtract(s.center);
                if (o) {
                    var h = new e.Matrix();
                    o.toRotationMatrix(h), (a = e.Vector3.TransformCoordinates(a, h));
                }
                switch (i) {
                    case e.PhysicsEngine.SphereImpostor:
                        var l = s.maximumWorld.x - s.minimumWorld.x,
                            c = s.maximumWorld.y - s.minimumWorld.y,
                            u = s.maximumWorld.z - s.minimumWorld.z,
                            f = Math.max(this._checkWithEpsilon(l), this._checkWithEpsilon(c), this._checkWithEpsilon(u)) / 2;
                        n = new OIMO.Body({
                            type: "sphere",
                            size: [f],
                            pos: [s.center.x, s.center.y, s.center.z],
                            rot: [t.rotation.x / OIMO.TO_RAD, t.rotation.y / OIMO.TO_RAD, t.rotation.z / OIMO.TO_RAD],
                            move: 0 != r.mass,
                            config: [r.mass, r.friction, r.restitution],
                            world: this._world,
                        });
                        break;
                    case e.PhysicsEngine.PlaneImpostor:
                    case e.PhysicsEngine.CylinderImpostor:
                    case e.PhysicsEngine.BoxImpostor:
                        var d = s.minimumWorld,
                            p = s.maximumWorld,
                            m = p.subtract(d),
                            g = this._checkWithEpsilon(m.x),
                            _ = this._checkWithEpsilon(m.y),
                            v = this._checkWithEpsilon(m.z);
                        n = new OIMO.Body({
                            type: "box",
                            size: [g, _, v],
                            pos: [s.center.x, s.center.y, s.center.z],
                            rot: [t.rotation.x / OIMO.TO_RAD, t.rotation.y / OIMO.TO_RAD, t.rotation.z / OIMO.TO_RAD],
                            move: 0 != r.mass,
                            config: [r.mass, r.friction, r.restitution],
                            world: this._world,
                        });
                }
                return o && ((n.body.orientation = new OIMO.Quat(o.w, o.x, o.y, o.z)), n.body.syncShapes()), this._registeredMeshes.push({ mesh: t, body: n, delta: a }), n;
            }),
            (t.prototype.registerMeshesAsCompound = function (e, t) {
                for (var i = [], r = [], n = [], o = [], s = e[0].mesh, a = 0; a < e.length; a++) {
                    var h = e[a],
                        l = this._createBodyAsCompound(h, t, s);
                    i.push(l.type), r.push.apply(r, l.size), n.push.apply(n, l.pos), o.push.apply(o, l.rot);
                }
                var c = new OIMO.Body({ type: i, size: r, pos: n, rot: o, move: 0 != t.mass, config: [t.mass, t.friction, t.restitution], world: this._world });
                return this._registeredMeshes.push({ mesh: s, body: c }), c;
            }),
            (t.prototype._createBodyAsCompound = function (t, i, r) {
                var n = null,
                    o = t.mesh;
                switch ((o.computeWorldMatrix(), t.impostor)) {
                    case e.PhysicsEngine.SphereImpostor:
                        var s = o.getBoundingInfo().boundingBox,
                            a = s.maximumWorld.x - s.minimumWorld.x,
                            h = s.maximumWorld.y - s.minimumWorld.y,
                            l = s.maximumWorld.z - s.minimumWorld.z,
                            c = Math.max(this._checkWithEpsilon(a), this._checkWithEpsilon(h), this._checkWithEpsilon(l)) / 2;
                        n = { type: "sphere", size: [c, -1, -1], pos: [o.position.x, o.position.y, o.position.z], rot: [o.rotation.x / OIMO.TO_RAD, o.rotation.y / OIMO.TO_RAD, o.rotation.z / OIMO.TO_RAD] };
                        break;
                    case e.PhysicsEngine.PlaneImpostor:
                    case e.PhysicsEngine.BoxImpostor:
                        s = o.getBoundingInfo().boundingBox;
                        var u = s.minimumWorld,
                            f = s.maximumWorld,
                            d = f.subtract(u),
                            p = this._checkWithEpsilon(d.x),
                            m = this._checkWithEpsilon(d.y),
                            g = this._checkWithEpsilon(d.z),
                            _ = o.position;
                        n = { type: "box", size: [p, m, g], pos: [_.x, _.y, _.z], rot: [o.rotation.x / OIMO.TO_RAD, o.rotation.y / OIMO.TO_RAD, o.rotation.z / OIMO.TO_RAD] };
                }
                return n;
            }),
            (t.prototype.unregisterMesh = function (e) {
                for (var t = 0; t < this._registeredMeshes.length; t++) {
                    var i = this._registeredMeshes[t];
                    if (i.mesh === e || i.mesh === e.parent) return i.body && (this._world.removeRigidBody(i.body.body), this._unbindBody(i.body)), void this._registeredMeshes.splice(t, 1);
                }
            }),
            (t.prototype._unbindBody = function (e) {
                for (var t = 0; t < this._registeredMeshes.length; t++) {
                    var i = this._registeredMeshes[t];
                    i.body === e && (i.body = null);
                }
            }),
            (t.prototype.applyImpulse = function (e, t, i) {
                for (var r = 0; r < this._registeredMeshes.length; r++) {
                    var n = this._registeredMeshes[r];
                    if (n.mesh === e || n.mesh === e.parent) {
                        var o = n.body.body.massInfo.mass;
                        return void n.body.body.applyImpulse(i.scale(OIMO.INV_SCALE), t.scale(OIMO.INV_SCALE * o));
                    }
                }
            }),
            (t.prototype.createLink = function (e, t, i, r, n) {
                for (var o = null, s = null, a = 0; a < this._registeredMeshes.length; a++) {
                    var h = this._registeredMeshes[a];
                    h.mesh === e ? (o = h.body.body) : h.mesh === t && (s = h.body.body);
                }
                return o && s
                    ? (n || (n = {}),
                      new OIMO.Link({ type: n.type, body1: o, body2: s, min: n.min, max: n.max, axe1: n.axe1, axe2: n.axe2, pos1: [i.x, i.y, i.z], pos2: [r.x, r.y, r.z], collision: n.collision, spring: n.spring, world: this._world }),
                      !0)
                    : !1;
            }),
            (t.prototype.dispose = function () {
                for (this._world.clear(); this._registeredMeshes.length; ) this.unregisterMesh(this._registeredMeshes[0].mesh);
            }),
            (t.prototype.isSupported = function () {
                return void 0 !== OIMO;
            }),
            (t.prototype._getLastShape = function (e) {
                for (var t = e.shapes; t.next; ) t = t.next;
                return t;
            }),
            (t.prototype.runOneStep = function (t) {
                this._world.step();
                for (var i, r = this._registeredMeshes.length; r--; ) {
                    var n = this._registeredMeshes[r].body.body,
                        o = this._registeredMeshes[r].mesh,
                        s = this._registeredMeshes[r].delta;
                    if (!n.sleeping)
                        if (n.shapes.next) {
                            var a = this._getLastShape(n);
                            (o.position.x = a.position.x * OIMO.WORLD_SCALE), (o.position.y = a.position.y * OIMO.WORLD_SCALE), (o.position.z = a.position.z * OIMO.WORLD_SCALE);
                            var h = e.Matrix.FromArray(n.getMatrix());
                            o.rotationQuaternion || (o.rotationQuaternion = new e.Quaternion(0, 0, 0, 1)), o.rotationQuaternion.fromRotationMatrix(h), o.computeWorldMatrix();
                        } else {
                            (i = n.getMatrix()), (h = e.Matrix.FromArray(i));
                            var l = h.m[12],
                                c = h.m[13],
                                u = h.m[14];
                            s ? ((o.position.x = l + s.x), (o.position.y = c + s.y), (o.position.z = u + s.z)) : ((o.position.x = l), (o.position.y = c), (o.position.z = u)),
                                o.rotationQuaternion || (o.rotationQuaternion = new e.Quaternion(0, 0, 0, 1)),
                                e.Quaternion.FromRotationMatrixToRef(h, o.rotationQuaternion),
                                o.computeWorldMatrix();
                        }
                }
            }),
            t
        );
    })();
    e.OimoJSPlugin = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t) {
            this._currentPlugin = t || new e.OimoJSPlugin();
        }
        return (
            (t.prototype._initialize = function (e) {
                this._currentPlugin.initialize(), this._setGravity(e);
            }),
            (t.prototype._runOneStep = function (e) {
                e > 0.1 ? (e = 0.1) : 0 >= e && (e = 1 / 60), this._currentPlugin.runOneStep(e);
            }),
            (t.prototype._setGravity = function (t) {
                (this.gravity = t || new e.Vector3(0, -9.807, 0)), this._currentPlugin.setGravity(this.gravity);
            }),
            (t.prototype._registerMesh = function (e, t, i) {
                return this._currentPlugin.registerMesh(e, t, i);
            }),
            (t.prototype._registerMeshesAsCompound = function (e, t) {
                return this._currentPlugin.registerMeshesAsCompound(e, t);
            }),
            (t.prototype._unregisterMesh = function (e) {
                this._currentPlugin.unregisterMesh(e);
            }),
            (t.prototype._applyImpulse = function (e, t, i) {
                this._currentPlugin.applyImpulse(e, t, i);
            }),
            (t.prototype._createLink = function (e, t, i, r, n) {
                return this._currentPlugin.createLink(e, t, i, r, n);
            }),
            (t.prototype._updateBodyPosition = function (e) {
                this._currentPlugin.updateBodyPosition(e);
            }),
            (t.prototype.dispose = function () {
                this._currentPlugin.dispose();
            }),
            (t.prototype.isSupported = function () {
                return this._currentPlugin.isSupported();
            }),
            (t.NoImpostor = 0),
            (t.SphereImpostor = 1),
            (t.BoxImpostor = 2),
            (t.PlaneImpostor = 3),
            (t.MeshImpostor = 4),
            (t.CapsuleImpostor = 5),
            (t.ConeImpostor = 6),
            (t.CylinderImpostor = 7),
            (t.ConvexHullImpostor = 8),
            (t.Epsilon = 0.001),
            t
        );
    })();
    e.PhysicsEngine = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t,
        i = function (t) {
            var i = {};
            if (((i.name = t.name), (i.id = t.id), (i.tags = e.Tags.GetTags(t)), t instanceof e.PointLight)) (i.type = 0), (i.position = t.position.asArray());
            else if (t instanceof e.DirectionalLight) {
                i.type = 1;
                var r = t;
                (i.position = r.position.asArray()), (i.direction = r.direction.asArray());
            } else if (t instanceof e.SpotLight) {
                i.type = 2;
                var n = t;
                (i.position = n.position.asArray()), (i.direction = n.position.asArray()), (i.angle = n.angle), (i.exponent = n.exponent);
            } else if (t instanceof e.HemisphericLight) {
                i.type = 3;
                var o = t;
                (i.direction = o.direction.asArray()), (i.groundColor = o.groundColor.asArray());
            }
            return t.intensity && (i.intensity = t.intensity), (i.range = t.range), (i.diffuse = t.diffuse.asArray()), (i.specular = t.specular.asArray()), i;
        },
        r = function (e) {
            var t = {};
            return (t.isEnabled = e.isEnabled), (t.leftColor = e.leftColor), (t.rightColor = e.rightColor), (t.bias = e.bias), (t.power = e.power), t;
        },
        n = function (e, i) {
            if (e.animations) {
                i.animations = [];
                for (var r = 0; r < e.animations.length; r++) {
                    var n = e.animations[r];
                    i.animations.push(t(n));
                }
            }
        },
        o = function (t) {
            var i = {};
            if (
                ((i.name = t.name),
                (i.tags = e.Tags.GetTags(t)),
                (i.id = t.id),
                (i.position = t.position.asArray()),
                t.parent && (i.parentId = t.parent.id),
                (i.fov = t.fov),
                (i.minZ = t.minZ),
                (i.maxZ = t.maxZ),
                (i.inertia = t.inertia),
                t instanceof e.FreeCamera
                    ? (i.type = "FreeCamera")
                    : t instanceof e.ArcRotateCamera
                    ? (i.type = "ArcRotateCamera")
                    : t instanceof e.AnaglyphArcRotateCamera
                    ? (i.type = "AnaglyphArcRotateCamera")
                    : t instanceof e.GamepadCamera
                    ? (i.type = "GamepadCamera")
                    : t instanceof e.AnaglyphFreeCamera
                    ? (i.type = "AnaglyphFreeCamera")
                    : t instanceof e.DeviceOrientationCamera
                    ? (i.type = "DeviceOrientationCamera")
                    : t instanceof e.FollowCamera
                    ? (i.type = "FollowCamera")
                    : t instanceof e.TouchCamera
                    ? (i.type = "TouchCamera")
                    : t instanceof e.VirtualJoysticksCamera
                    ? (i.type = "VirtualJoysticksCamera")
                    : t instanceof e.WebVRFreeCamera
                    ? (i.type = "WebVRFreeCamera")
                    : t instanceof e.VRDeviceOrientationFreeCamera && (i.type = "VRDeviceOrientationFreeCamera"),
                t instanceof e.ArcRotateCamera || t instanceof e.AnaglyphArcRotateCamera)
            ) {
                var r = t;
                (i.alpha = r.alpha), (i.beta = r.beta), (i.radius = r.radius), r.target && r.target.id && (i.lockedTargetId = r.target.id);
            } else if (t instanceof e.FollowCamera) {
                var o = t;
                (i.radius = o.radius), (i.heightOffset = o.heightOffset), (i.rotationOffset = o.rotationOffset);
            } else (t instanceof e.AnaglyphFreeCamera || t instanceof e.AnaglyphArcRotateCamera) && void 0 !== t._interaxialDistance && (i.interaxial_distance = e.Tools.ToDegrees(t._interaxialDistance));
            return (
                void 0 !== t.speed && (i.speed = t.speed),
                t.target && t.target instanceof e.Vector3 && (i.target = t.target.asArray()),
                t.rotation && t.rotation instanceof e.Vector3 && (i.rotation = t.rotation.asArray()),
                t.lockedTarget && t.lockedTarget.id && (i.lockedTargetId = t.lockedTarget.id),
                (i.checkCollisions = t.checkCollisions || !1),
                (i.applyGravity = t.applyGravity || !1),
                t.ellipsoid && (i.ellipsoid = t.ellipsoid.asArray()),
                n(t, i),
                (i.layerMask = t.layerMask),
                i
            );
        };
    t = function (t) {
        var i = {};
        (i.name = t.name), (i.property = t.targetProperty), (i.framePerSecond = t.framePerSecond), (i.dataType = t.dataType), (i.loopBehavior = t.loopMode);
        var r = t.dataType;
        i.keys = [];
        for (var n = t.getKeys(), o = 0; o < n.length; o++) {
            var s = n[o],
                a = {};
            switch (((a.frame = s.frame), r)) {
                case e.Animation.ANIMATIONTYPE_FLOAT:
                    a.values = [s.value];
                    break;
                case e.Animation.ANIMATIONTYPE_QUATERNION:
                case e.Animation.ANIMATIONTYPE_MATRIX:
                case e.Animation.ANIMATIONTYPE_VECTOR3:
                    a.values = s.value.asArray();
            }
            i.keys.push(a);
        }
        return i;
    };
    var s,
        a = function (t) {
            var i = {};
            (i.name = t.name), (i.id = t.id), (i.tags = e.Tags.GetTags(t)), (i.materials = []);
            for (var r = 0; r < t.subMaterials.length; r++) {
                var n = t.subMaterials[r];
                i.materials.push(n ? n.id : null);
            }
            return i;
        },
        h = function (t) {
            var i = {};
            return (
                (i.name = t.name),
                (i.ambient = t.ambientColor.asArray()),
                (i.diffuse = t.diffuseColor.asArray()),
                (i.specular = t.specularColor.asArray()),
                (i.specularPower = t.specularPower),
                (i.emissive = t.emissiveColor.asArray()),
                (i.useReflectionFresnelFromSpecular = i.useReflectionFresnelFromSpecular),
                (i.useEmissiveAsIllumination = i.useEmissiveAsIllumination),
                (i.alpha = t.alpha),
                (i.id = t.id),
                (i.tags = e.Tags.GetTags(t)),
                (i.backFaceCulling = t.backFaceCulling),
                t.diffuseTexture && (i.diffuseTexture = s(t.diffuseTexture)),
                t.diffuseFresnelParameters && (i.diffuseFresnelParameters = r(t.diffuseFresnelParameters)),
                t.ambientTexture && (i.ambientTexture = s(t.ambientTexture)),
                t.opacityTexture && (i.opacityTexture = s(t.opacityTexture)),
                t.opacityFresnelParameters && (i.opacityFresnelParameters = r(t.opacityFresnelParameters)),
                t.reflectionTexture && (i.reflectionTexture = s(t.reflectionTexture)),
                t.reflectionFresnelParameters && (i.reflectionFresnelParameters = r(t.reflectionFresnelParameters)),
                t.emissiveTexture && (i.emissiveTexture = s(t.emissiveTexture)),
                t.lightmapTexture && ((i.lightmapTexture = s(t.lightmapTexture)), (i.lightmapThreshold = t.lightmapThreshold)),
                t.emissiveFresnelParameters && (i.emissiveFresnelParameters = r(t.emissiveFresnelParameters)),
                t.specularTexture && (i.specularTexture = s(t.specularTexture)),
                t.bumpTexture && (i.bumpTexture = s(t.bumpTexture)),
                i
            );
        };
    s = function (t) {
        var i = {};
        if (!t.name) return null;
        if (t instanceof e.CubeTexture) return (i.name = t.name), (i.hasAlpha = t.hasAlpha), (i.isCube = !0), (i.level = t.level), (i.coordinatesMode = t.coordinatesMode), i;
        var r;
        if (t instanceof e.MirrorTexture) {
            var o = t;
            for (i.renderTargetSize = o.getRenderSize(), i.renderList = [], r = 0; r < o.renderList.length; r++) i.renderList.push(o.renderList[r].id);
            i.mirrorPlane = o.mirrorPlane.asArray();
        } else if (t instanceof e.RenderTargetTexture) {
            var s = t;
            for (i.renderTargetSize = s.getRenderSize(), i.renderList = [], r = 0; r < s.renderList.length; r++) i.renderList.push(s.renderList[r].id);
        }
        var a = t;
        return (
            (i.name = t.name),
            (i.hasAlpha = t.hasAlpha),
            (i.level = t.level),
            (i.coordinatesIndex = t.coordinatesIndex),
            (i.coordinatesMode = t.coordinatesMode),
            (i.uOffset = a.uOffset),
            (i.vOffset = a.vOffset),
            (i.uScale = a.uScale),
            (i.vScale = a.vScale),
            (i.uAng = a.uAng),
            (i.vAng = a.vAng),
            (i.wAng = a.wAng),
            (i.wrapU = t.wrapU),
            (i.wrapV = t.wrapV),
            n(t, i),
            i
        );
    };
    var l,
        c,
        u,
        f,
        d,
        p,
        m,
        g,
        _ = function (e) {
            var i = {};
            (i.name = e.name), (i.id = e.id), (i.bones = []);
            for (var r = 0; r < e.bones.length; r++) {
                var n = e.bones[r],
                    o = { parentBoneIndex: n.getParent() ? e.bones.indexOf(n.getParent()) : -1, name: n.name, matrix: n.getLocalMatrix().toArray() };
                i.bones.push(o), n.animations && n.animations.length > 0 && (o.animation = t(n.animations[0]));
            }
            return i;
        },
        v = function (e) {
            var t = {};
            return (
                (t.emitterId = e.emitter.id),
                (t.capacity = e.getCapacity()),
                e.particleTexture && (t.textureName = e.particleTexture.name),
                (t.minAngularSpeed = e.minAngularSpeed),
                (t.maxAngularSpeed = e.maxAngularSpeed),
                (t.minSize = e.minSize),
                (t.maxSize = e.maxSize),
                (t.minLifeTime = e.minLifeTime),
                (t.maxLifeTime = e.maxLifeTime),
                (t.emitRate = e.emitRate),
                (t.minEmitBox = e.minEmitBox.asArray()),
                (t.maxEmitBox = e.maxEmitBox.asArray()),
                (t.gravity = e.gravity.asArray()),
                (t.direction1 = e.direction1.asArray()),
                (t.direction2 = e.direction2.asArray()),
                (t.color1 = e.color1.asArray()),
                (t.color2 = e.color2.asArray()),
                (t.colorDead = e.colorDead.asArray()),
                (t.updateSpeed = e.updateSpeed),
                (t.targetStopDuration = e.targetStopDuration),
                (t.textureMask = e.textureMask.asArray()),
                (t.blendMode = e.blendMode),
                t
            );
        },
        y = function (t) {
            var i = {};
            (i.emitterId = t.getEmitter().id), (i.borderLimit = t.borderLimit), (i.flares = []);
            for (var r = 0; r < t.lensFlares.length; r++) {
                var n = t.lensFlares[r];
                i.flares.push({ size: n.size, position: n.position, color: n.color.asArray(), textureName: e.Tools.GetFilename(n.texture.name) });
            }
            return i;
        },
        x = function (e) {
            var t = {},
                i = e.getShadowGenerator();
            (t.lightId = e.id), (t.mapSize = i.getShadowMap().getRenderSize()), (t.useVarianceShadowMap = i.useVarianceShadowMap), (t.usePoissonSampling = i.usePoissonSampling), (t.renderList = []);
            for (var r = 0; r < i.getShadowMap().renderList.length; r++) {
                var n = i.getShadowMap().renderList[r];
                t.renderList.push(n.id);
            }
            return t;
        },
        M = [],
        S = function (t, i) {
            if (!M[t.id]) {
                if (t instanceof e.Geometry.Primitives.Box) i.boxes.push(g(t));
                else if (t instanceof e.Geometry.Primitives.Sphere) i.spheres.push(m(t));
                else if (t instanceof e.Geometry.Primitives.Cylinder) i.cylinders.push(p(t));
                else if (t instanceof e.Geometry.Primitives.Torus) i.toruses.push(d(t));
                else if (t instanceof e.Geometry.Primitives.Ground) i.grounds.push(f(t));
                else if (t instanceof e.Geometry.Primitives.Plane) i.planes.push(u(t));
                else if (t instanceof e.Geometry.Primitives.TorusKnot) i.torusKnots.push(c(t));
                else {
                    if (t instanceof e.Geometry.Primitives._Primitive) throw new Error("Unknown primitive type");
                    i.vertexData.push(l(t));
                }
                M[t.id] = !0;
            }
        },
        b = function (t) {
            var i = {};
            return (i.id = t.id), e.Tags.HasTags(t) && (i.tags = e.Tags.GetTags(t)), i;
        };
    l = function (t) {
        var i = b(t);
        return (
            t.isVerticesDataPresent(e.VertexBuffer.PositionKind) && (i.positions = t.getVerticesData(e.VertexBuffer.PositionKind)),
            t.isVerticesDataPresent(e.VertexBuffer.NormalKind) && (i.normals = t.getVerticesData(e.VertexBuffer.NormalKind)),
            t.isVerticesDataPresent(e.VertexBuffer.UVKind) && (i.uvs = t.getVerticesData(e.VertexBuffer.UVKind)),
            t.isVerticesDataPresent(e.VertexBuffer.UV2Kind) && (i.uvs2 = t.getVerticesData(e.VertexBuffer.UV2Kind)),
            t.isVerticesDataPresent(e.VertexBuffer.UV3Kind) && (i.uvs3 = t.getVerticesData(e.VertexBuffer.UV3Kind)),
            t.isVerticesDataPresent(e.VertexBuffer.UV4Kind) && (i.uvs4 = t.getVerticesData(e.VertexBuffer.UV4Kind)),
            t.isVerticesDataPresent(e.VertexBuffer.UV5Kind) && (i.uvs5 = t.getVerticesData(e.VertexBuffer.UV5Kind)),
            t.isVerticesDataPresent(e.VertexBuffer.UV6Kind) && (i.uvs6 = t.getVerticesData(e.VertexBuffer.UV6Kind)),
            t.isVerticesDataPresent(e.VertexBuffer.ColorKind) && (i.colors = t.getVerticesData(e.VertexBuffer.ColorKind)),
            t.isVerticesDataPresent(e.VertexBuffer.MatricesIndicesKind) && ((i.matricesIndices = t.getVerticesData(e.VertexBuffer.MatricesIndicesKind)), (i.matricesIndices._isExpanded = !0)),
            t.isVerticesDataPresent(e.VertexBuffer.MatricesWeightsKind) && (i.matricesWeights = t.getVerticesData(e.VertexBuffer.MatricesWeightsKind)),
            (i.indices = t.getIndices()),
            i
        );
    };
    var A = function (e) {
        var t = b(e);
        return (t.canBeRegenerated = e.canBeRegenerated()), t;
    };
    (g = function (e) {
        var t = A(e);
        return (t.size = e.size), t;
    }),
        (m = function (e) {
            var t = A(e);
            return (t.segments = e.segments), (t.diameter = e.diameter), t;
        }),
        (p = function (e) {
            var t = A(e);
            return (t.height = e.height), (t.diameterTop = e.diameterTop), (t.diameterBottom = e.diameterBottom), (t.tessellation = e.tessellation), t;
        }),
        (d = function (e) {
            var t = A(e);
            return (t.diameter = e.diameter), (t.thickness = e.thickness), (t.tessellation = e.tessellation), t;
        }),
        (f = function (e) {
            var t = A(e);
            return (t.width = e.width), (t.height = e.height), (t.subdivisions = e.subdivisions), t;
        }),
        (u = function (e) {
            var t = A(e);
            return (t.size = e.size), t;
        }),
        (c = function (e) {
            var t = A(e);
            return (t.radius = e.radius), (t.tube = e.tube), (t.radialSegments = e.radialSegments), (t.tubularSegments = e.tubularSegments), (t.p = e.p), (t.q = e.q), t;
        });
    var T = function (t, i) {
            var r = {};
            (r.name = t.name),
                (r.id = t.id),
                e.Tags.HasTags(t) && (r.tags = e.Tags.GetTags(t)),
                (r.position = t.position.asArray()),
                t.rotationQuaternion ? (r.rotationQuaternion = t.rotationQuaternion.asArray()) : t.rotation && (r.rotation = t.rotation.asArray()),
                (r.scaling = t.scaling.asArray()),
                (r.localMatrix = t.getPivotMatrix().asArray()),
                (r.isEnabled = t.isEnabled()),
                (r.isVisible = t.isVisible),
                (r.infiniteDistance = t.infiniteDistance),
                (r.pickable = t.isPickable),
                (r.receiveShadows = t.receiveShadows),
                (r.billboardMode = t.billboardMode),
                (r.visibility = t.visibility),
                (r.checkCollisions = t.checkCollisions),
                t.parent && (r.parentId = t.parent.id);
            var o = t._geometry;
            if (o) {
                var s = o.id;
                (r.geometryId = s), t.getScene().getGeometryByID(s) || S(o, i.geometries), (r.subMeshes = []);
                for (var a = 0; a < t.subMeshes.length; a++) {
                    var h = t.subMeshes[a];
                    r.subMeshes.push({ materialIndex: h.materialIndex, verticesStart: h.verticesStart, verticesCount: h.verticesCount, indexStart: h.indexStart, indexCount: h.indexCount });
                }
            }
            if ((t.material ? (r.materialId = t.material.id) : (t.material = null), t.skeleton && (r.skeletonId = t.skeleton.id), t.getPhysicsImpostor() !== e.PhysicsEngine.NoImpostor))
                switch (((r.physicsMass = t.getPhysicsMass()), (r.physicsFriction = t.getPhysicsFriction()), (r.physicsRestitution = t.getPhysicsRestitution()), t.getPhysicsImpostor())) {
                    case e.PhysicsEngine.BoxImpostor:
                        r.physicsImpostor = 1;
                        break;
                    case e.PhysicsEngine.SphereImpostor:
                        r.physicsImpostor = 2;
                }
            r.instances = [];
            for (var l = 0; l < t.instances.length; l++) {
                var c = t.instances[l],
                    u = { name: c.name, position: c.position, rotation: c.rotation, rotationQuaternion: c.rotationQuaternion, scaling: c.scaling };
                r.instances.push(u), n(c, u);
            }
            return n(t, r), (r.layerMask = t.layerMask), r;
        },
        E = function (t, i) {
            if (t.delayLoadState === e.Engine.DELAYLOADSTATE_LOADED || t.delayLoadState === e.Engine.DELAYLOADSTATE_NONE) {
                t.material &&
                    (t.material instanceof e.StandardMaterial
                        ? ((i.materials = i.materials || []),
                          i.materials.some(function (e) {
                              return e.id === t.material.id;
                          }) || i.materials.push(h(t.material)))
                        : t.material instanceof e.MultiMaterial &&
                          ((i.multiMaterials = i.multiMaterials || []),
                          i.multiMaterials.some(function (e) {
                              return e.id === t.material.id;
                          }) || i.multiMaterials.push(a(t.material))));

                var r = t._geometry;
                r &&
                    (i.geometries ||
                        ((i.geometries = {}),
                        (i.geometries.boxes = []),
                        (i.geometries.spheres = []),
                        (i.geometries.cylinders = []),
                        (i.geometries.toruses = []),
                        (i.geometries.grounds = []),
                        (i.geometries.planes = []),
                        (i.geometries.torusKnots = []),
                        (i.geometries.vertexData = [])),
                    S(r, i.geometries)),
                    t.skeleton && ((i.skeletons = i.skeletons || []), i.skeletons.push(_(t.skeleton))),
                    (i.meshes = i.meshes || []),
                    i.meshes.push(T(t, i));
            }
        },
        P = (function () {
            function t() {}
            return (
                (t.Serialize = function (t) {
                    var r = {};
                    (r.useDelayedTextureLoading = t.useDelayedTextureLoading),
                        (r.autoClear = t.autoClear),
                        (r.clearColor = t.clearColor.asArray()),
                        (r.ambientColor = t.ambientColor.asArray()),
                        (r.gravity = t.gravity.asArray()),
                        t.fogMode && 0 !== t.fogMode && ((r.fogMode = t.fogMode), (r.fogColor = t.fogColor.asArray()), (r.fogStart = t.fogStart), (r.fogEnd = t.fogEnd), (r.fogDensity = t.fogDensity)),
                        (r.lights = []);
                    var n, s;
                    for (n = 0; n < t.lights.length; n++) (s = t.lights[n]), r.lights.push(i(s));
                    for (r.cameras = [], n = 0; n < t.cameras.length; n++) {
                        var l = t.cameras[n];
                        r.cameras.push(o(l));
                    }
                    t.activeCamera && (r.activeCameraID = t.activeCamera.id), (r.materials = []), (r.multiMaterials = []);
                    var c;
                    for (n = 0; n < t.materials.length; n++) (c = t.materials[n]), r.materials.push(h(c));
                    for (r.multiMaterials = [], n = 0; n < t.multiMaterials.length; n++) {
                        var u = t.multiMaterials[n];
                        r.multiMaterials.push(a(u));
                    }
                    for (n = 0; n < t.materials.length; n++) (c = t.materials[n]), c instanceof e.StandardMaterial ? r.materials.push(h(c)) : c instanceof e.MultiMaterial && r.multiMaterials.push(a(c));
                    for (r.skeletons = [], n = 0; n < t.skeletons.length; n++) r.skeletons.push(_(t.skeletons[n]));
                    (r.geometries = {}),
                        (r.geometries.boxes = []),
                        (r.geometries.spheres = []),
                        (r.geometries.cylinders = []),
                        (r.geometries.toruses = []),
                        (r.geometries.grounds = []),
                        (r.geometries.planes = []),
                        (r.geometries.torusKnots = []),
                        (r.geometries.vertexData = []),
                        (M = []);
                    var f = t.getGeometries();
                    for (n = 0; n < f.length; n++) {
                        var d = f[n];
                        d.isReady() && S(d, r.geometries);
                    }
                    for (r.meshes = [], n = 0; n < t.meshes.length; n++) {
                        var p = t.meshes[n];
                        if (p instanceof e.Mesh) {
                            var m = p;
                            (m.delayLoadState === e.Engine.DELAYLOADSTATE_LOADED || m.delayLoadState === e.Engine.DELAYLOADSTATE_NONE) && r.meshes.push(T(m, r));
                        }
                    }
                    for (r.particleSystems = [], n = 0; n < t.particleSystems.length; n++) r.particleSystems.push(v(t.particleSystems[n]));
                    for (r.lensFlareSystems = [], n = 0; n < t.lensFlareSystems.length; n++) r.lensFlareSystems.push(y(t.lensFlareSystems[n]));
                    for (r.shadowGenerators = [], n = 0; n < t.lights.length; n++) (s = t.lights[n]), s.getShadowGenerator() && r.shadowGenerators.push(x(s));
                    return r;
                }),
                (t.SerializeMesh = function (t, i, r) {
                    void 0 === i && (i = !1), void 0 === r && (r = !1);
                    var n = {};
                    if (((t = t instanceof Array ? t : [t]), i || r))
                        for (var o = 0; o < t.length; ++o)
                            r &&
                                t[o].getDescendants().forEach(function (i) {
                                    i instanceof e.Mesh && t.indexOf(i) < 0 && t.push(i);
                                }),
                                i && t[o].parent && t.indexOf(t[o].parent) < 0 && t.push(t[o].parent);
                    return (
                        t.forEach(function (e) {
                            E(e, n);
                        }),
                        n
                    );
                }),
                t
            );
        })();
    e.SceneSerializer = P;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = 0,
        i = (function () {
            function t(e, t, i) {
                (this.pos = e), (this.normal = t), (this.uv = i);
            }
            return (
                (t.prototype.clone = function () {
                    return new t(this.pos.clone(), this.normal.clone(), this.uv.clone());
                }),
                (t.prototype.flip = function () {
                    this.normal = this.normal.scale(-1);
                }),
                (t.prototype.interpolate = function (i, r) {
                    return new t(e.Vector3.Lerp(this.pos, i.pos, r), e.Vector3.Lerp(this.normal, i.normal, r), e.Vector2.Lerp(this.uv, i.uv, r));
                }),
                t
            );
        })(),
        r = (function () {
            function t(e, t) {
                (this.normal = e), (this.w = t);
            }
            return (
                (t.FromPoints = function (i, r, n) {
                    var o = n.subtract(i),
                        s = r.subtract(i);
                    if (0 === o.lengthSquared() || 0 === s.lengthSquared()) return null;
                    var a = e.Vector3.Normalize(e.Vector3.Cross(o, s));
                    return new t(a, e.Vector3.Dot(a, i));
                }),
                (t.prototype.clone = function () {
                    return new t(this.normal.clone(), this.w);
                }),
                (t.prototype.flip = function () {
                    this.normal.scaleInPlace(-1), (this.w = -this.w);
                }),
                (t.prototype.splitPolygon = function (i, r, o, s, a) {
                    for (var h = 0, l = 1, c = 2, u = 3, f = 0, d = [], p = 0; p < i.vertices.length; p++) {
                        var m = e.Vector3.Dot(this.normal, i.vertices[p].pos) - this.w,
                            g = m < -t.EPSILON ? c : m > t.EPSILON ? l : h;
                        (f |= g), d.push(g);
                    }
                    switch (f) {
                        case h:
                            (e.Vector3.Dot(this.normal, i.plane.normal) > 0 ? r : o).push(i);
                            break;
                        case l:
                            s.push(i);
                            break;
                        case c:
                            a.push(i);
                            break;
                        case u:
                            var _ = [],
                                v = [];
                            for (p = 0; p < i.vertices.length; p++) {
                                var y = (p + 1) % i.vertices.length,
                                    x = d[p],
                                    M = d[y],
                                    S = i.vertices[p],
                                    b = i.vertices[y];
                                if ((x != c && _.push(S), x != l && v.push(x != c ? S.clone() : S), (x | M) == u)) {
                                    m = (this.w - e.Vector3.Dot(this.normal, S.pos)) / e.Vector3.Dot(this.normal, b.pos.subtract(S.pos));
                                    var A = S.interpolate(b, m);
                                    _.push(A), v.push(A.clone());
                                }
                            }
                            if (_.length >= 3) {
                                var T = new n(_, i.shared);
                                T.plane && s.push(T);
                            }
                            v.length >= 3 && ((T = new n(v, i.shared)), T.plane && a.push(T));
                    }
                }),
                (t.EPSILON = 1e-5),
                t
            );
        })(),
        n = (function () {
            function e(e, t) {
                (this.vertices = e), (this.shared = t), (this.plane = r.FromPoints(e[0].pos, e[1].pos, e[2].pos));
            }
            return (
                (e.prototype.clone = function () {
                    var t = this.vertices.map(function (e) {
                        return e.clone();
                    });
                    return new e(t, this.shared);
                }),
                (e.prototype.flip = function () {
                    this.vertices.reverse().map(function (e) {
                        e.flip();
                    }),
                        this.plane.flip();
                }),
                e
            );
        })(),
        o = (function () {
            function e(e) {
                (this.plane = null), (this.front = null), (this.back = null), (this.polygons = []), e && this.build(e);
            }
            return (
                (e.prototype.clone = function () {
                    var t = new e();
                    return (
                        (t.plane = this.plane && this.plane.clone()),
                        (t.front = this.front && this.front.clone()),
                        (t.back = this.back && this.back.clone()),
                        (t.polygons = this.polygons.map(function (e) {
                            return e.clone();
                        })),
                        t
                    );
                }),
                (e.prototype.invert = function () {
                    for (var e = 0; e < this.polygons.length; e++) this.polygons[e].flip();
                    this.plane && this.plane.flip(), this.front && this.front.invert(), this.back && this.back.invert();
                    var t = this.front;
                    (this.front = this.back), (this.back = t);
                }),
                (e.prototype.clipPolygons = function (e) {
                    if (!this.plane) return e.slice();
                    for (var t = [], i = [], r = 0; r < e.length; r++) this.plane.splitPolygon(e[r], t, i, t, i);
                    return this.front && (t = this.front.clipPolygons(t)), (i = this.back ? this.back.clipPolygons(i) : []), t.concat(i);
                }),
                (e.prototype.clipTo = function (e) {
                    (this.polygons = e.clipPolygons(this.polygons)), this.front && this.front.clipTo(e), this.back && this.back.clipTo(e);
                }),
                (e.prototype.allPolygons = function () {
                    var e = this.polygons.slice();
                    return this.front && (e = e.concat(this.front.allPolygons())), this.back && (e = e.concat(this.back.allPolygons())), e;
                }),
                (e.prototype.build = function (t) {
                    if (t.length) {
                        this.plane || (this.plane = t[0].plane.clone());
                        for (var i = [], r = [], n = 0; n < t.length; n++) this.plane.splitPolygon(t[n], this.polygons, this.polygons, i, r);
                        i.length && (this.front || (this.front = new e()), this.front.build(i)), r.length && (this.back || (this.back = new e()), this.back.build(r));
                    }
                }),
                e
            );
        })(),
        s = (function () {
            function r() {
                this.polygons = new Array();
            }
            return (
                (r.FromMesh = function (o) {
                    var s,
                        a,
                        h,
                        l,
                        c,
                        u,
                        f,
                        d,
                        p,
                        m,
                        g,
                        _ = new Array();
                    if (!(o instanceof e.Mesh)) throw "BABYLON.CSG: Wrong Mesh type, must be BABYLON.Mesh";
                    o.computeWorldMatrix(!0), (f = o.getWorldMatrix()), (d = o.position.clone()), (p = o.rotation.clone()), o.rotationQuaternion && (m = o.rotationQuaternion.clone()), (g = o.scaling.clone());
                    for (
                        var v = o.getIndices(), y = o.getVerticesData(e.VertexBuffer.PositionKind), x = o.getVerticesData(e.VertexBuffer.NormalKind), M = o.getVerticesData(e.VertexBuffer.UVKind), S = o.subMeshes, b = 0, A = S.length;
                        A > b;
                        b++
                    )
                        for (var T = S[b].indexStart, E = S[b].indexCount + S[b].indexStart; E > T; T += 3) {
                            u = [];
                            for (var P = 0; 3 > P; P++) {
                                var D = new e.Vector3(x[3 * v[T + P]], x[3 * v[T + P] + 1], x[3 * v[T + P] + 2]);
                                h = new e.Vector2(M[2 * v[T + P]], M[2 * v[T + P] + 1]);
                                var C = new e.Vector3(y[3 * v[T + P]], y[3 * v[T + P] + 1], y[3 * v[T + P] + 2]);
                                (l = e.Vector3.TransformCoordinates(C, f)), (a = e.Vector3.TransformNormal(D, f)), (s = new i(l, a, h)), u.push(s);
                            }
                            (c = new n(u, { subMeshId: b, meshId: t, materialIndex: S[b].materialIndex })), c.plane && _.push(c);
                        }
                    var I = r.FromPolygons(_);
                    return (I.matrix = f), (I.position = d), (I.rotation = p), (I.scaling = g), (I.rotationQuaternion = m), t++, I;
                }),
                (r.FromPolygons = function (e) {
                    var t = new r();
                    return (t.polygons = e), t;
                }),
                (r.prototype.clone = function () {
                    var e = new r();
                    return (
                        (e.polygons = this.polygons.map(function (e) {
                            return e.clone();
                        })),
                        e.copyTransformAttributes(this),
                        e
                    );
                }),
                (r.prototype.toPolygons = function () {
                    return this.polygons;
                }),
                (r.prototype.union = function (e) {
                    var t = new o(this.clone().polygons),
                        i = new o(e.clone().polygons);
                    return t.clipTo(i), i.clipTo(t), i.invert(), i.clipTo(t), i.invert(), t.build(i.allPolygons()), r.FromPolygons(t.allPolygons()).copyTransformAttributes(this);
                }),
                (r.prototype.unionInPlace = function (e) {
                    var t = new o(this.polygons),
                        i = new o(e.polygons);
                    t.clipTo(i), i.clipTo(t), i.invert(), i.clipTo(t), i.invert(), t.build(i.allPolygons()), (this.polygons = t.allPolygons());
                }),
                (r.prototype.subtract = function (e) {
                    var t = new o(this.clone().polygons),
                        i = new o(e.clone().polygons);
                    return t.invert(), t.clipTo(i), i.clipTo(t), i.invert(), i.clipTo(t), i.invert(), t.build(i.allPolygons()), t.invert(), r.FromPolygons(t.allPolygons()).copyTransformAttributes(this);
                }),
                (r.prototype.subtractInPlace = function (e) {
                    var t = new o(this.polygons),
                        i = new o(e.polygons);
                    t.invert(), t.clipTo(i), i.clipTo(t), i.invert(), i.clipTo(t), i.invert(), t.build(i.allPolygons()), t.invert(), (this.polygons = t.allPolygons());
                }),
                (r.prototype.intersect = function (e) {
                    var t = new o(this.clone().polygons),
                        i = new o(e.clone().polygons);
                    return t.invert(), i.clipTo(t), i.invert(), t.clipTo(i), i.clipTo(t), t.build(i.allPolygons()), t.invert(), r.FromPolygons(t.allPolygons()).copyTransformAttributes(this);
                }),
                (r.prototype.intersectInPlace = function (e) {
                    var t = new o(this.polygons),
                        i = new o(e.polygons);
                    t.invert(), i.clipTo(t), i.invert(), t.clipTo(i), i.clipTo(t), t.build(i.allPolygons()), t.invert(), (this.polygons = t.allPolygons());
                }),
                (r.prototype.inverse = function () {
                    var e = this.clone();
                    return e.inverseInPlace(), e;
                }),
                (r.prototype.inverseInPlace = function () {
                    this.polygons.map(function (e) {
                        e.flip();
                    });
                }),
                (r.prototype.copyTransformAttributes = function (e) {
                    return (this.matrix = e.matrix), (this.position = e.position), (this.rotation = e.rotation), (this.scaling = e.scaling), (this.rotationQuaternion = e.rotationQuaternion), this;
                }),
                (r.prototype.buildMeshGeometry = function (t, i, r) {
                    var n = this.matrix.clone();
                    n.invert();
                    var o,
                        s,
                        a,
                        h = new e.Mesh(t, i),
                        l = [],
                        c = [],
                        u = [],
                        f = [],
                        d = e.Vector3.Zero(),
                        p = e.Vector3.Zero(),
                        m = e.Vector2.Zero(),
                        g = this.polygons,
                        _ = [0, 0, 0],
                        v = {},
                        y = 0,
                        x = {};
                    r &&
                        g.sort(function (e, t) {
                            return e.shared.meshId === t.shared.meshId ? e.shared.subMeshId - t.shared.subMeshId : e.shared.meshId - t.shared.meshId;
                        });
                    for (var M = 0, S = g.length; S > M; M++) {
                        (o = g[M]),
                            x[o.shared.meshId] || (x[o.shared.meshId] = {}),
                            x[o.shared.meshId][o.shared.subMeshId] || (x[o.shared.meshId][o.shared.subMeshId] = { indexStart: +(1 / 0), indexEnd: -(1 / 0), materialIndex: o.shared.materialIndex }),
                            (a = x[o.shared.meshId][o.shared.subMeshId]);
                        for (var b = 2, A = o.vertices.length; A > b; b++) {
                            (_[0] = 0), (_[1] = b - 1), (_[2] = b);
                            for (var T = 0; 3 > T; T++) {
                                d.copyFrom(o.vertices[_[T]].pos), p.copyFrom(o.vertices[_[T]].normal), m.copyFrom(o.vertices[_[T]].uv);
                                var E = e.Vector3.TransformCoordinates(d, n),
                                    P = e.Vector3.TransformNormal(p, n);
                                (s = v[E.x + "," + E.y + "," + E.z]),
                                    ("undefined" == typeof s || u[3 * s] !== P.x || u[3 * s + 1] !== P.y || u[3 * s + 2] !== P.z || f[2 * s] !== m.x || f[2 * s + 1] !== m.y) &&
                                        (l.push(E.x, E.y, E.z), f.push(m.x, m.y), u.push(p.x, p.y, p.z), (s = v[E.x + "," + E.y + "," + E.z] = l.length / 3 - 1)),
                                    c.push(s),
                                    (a.indexStart = Math.min(y, a.indexStart)),
                                    (a.indexEnd = Math.max(y, a.indexEnd)),
                                    y++;
                            }
                        }
                    }
                    if ((h.setVerticesData(e.VertexBuffer.PositionKind, l), h.setVerticesData(e.VertexBuffer.NormalKind, u), h.setVerticesData(e.VertexBuffer.UVKind, f), h.setIndices(c), r)) {
                        var D,
                            C = 0;
                        h.subMeshes.length = 0;
                        for (var I in x) {
                            D = -1;
                            for (var w in x[I]) (a = x[I][w]), e.SubMesh.CreateFromIndices(a.materialIndex + C, a.indexStart, a.indexEnd - a.indexStart + 1, h), (D = Math.max(a.materialIndex, D));
                            C += ++D;
                        }
                    }
                    return h;
                }),
                (r.prototype.toMesh = function (e, t, i, r) {
                    var n = this.buildMeshGeometry(e, i, r);
                    return (
                        (n.material = t),
                        n.position.copyFrom(this.position),
                        n.rotation.copyFrom(this.rotation),
                        this.rotationQuaternion && (n.rotationQuaternion = this.rotationQuaternion.clone()),
                        n.scaling.copyFrom(this.scaling),
                        n.computeWorldMatrix(!0),
                        n
                    );
                }),
                r
            );
        })();
    e.CSG = s;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o) {
            var s = this;
            t.call(this, i, "vrDistortionCorrection", ["LensCenter", "Scale", "ScaleIn", "HmdWarpParam"], null, o.postProcessScaleFactor, r, e.Texture.BILINEAR_SAMPLINGMODE, null, null),
                (this._isRightEye = n),
                (this._distortionFactors = o.distortionK),
                (this._postProcessScaleFactor = o.postProcessScaleFactor),
                (this._lensCenterOffset = o.lensCenterOffset),
                (this.onSizeChanged = function () {
                    (s.aspectRatio = (0.5 * s.width) / s.height),
                        (s._scaleIn = new e.Vector2(2, 2 / s.aspectRatio)),
                        (s._scaleFactor = new e.Vector2(0.5 * (1 / s._postProcessScaleFactor), 0.5 * (1 / s._postProcessScaleFactor) * s.aspectRatio)),
                        (s._lensCenter = new e.Vector2(s._isRightEye ? 0.5 - 0.5 * s._lensCenterOffset : 0.5 + 0.5 * s._lensCenterOffset, 0.5));
                }),
                (this.onApply = function (e) {
                    e.setFloat2("LensCenter", s._lensCenter.x, s._lensCenter.y),
                        e.setFloat2("Scale", s._scaleFactor.x, s._scaleFactor.y),
                        e.setFloat2("ScaleIn", s._scaleIn.x, s._scaleIn.y),
                        e.setFloat4("HmdWarpParam", s._distortionFactors[0], s._distortionFactors[1], s._distortionFactors[2], s._distortionFactors[3]);
                });
        }
        return __extends(i, t), i;
    })(e.PostProcess);
    e.VRDistortionCorrectionPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    !(function (e) {
        (e[(e.X = 0)] = "X"), (e[(e.Y = 1)] = "Y"), (e[(e.Z = 2)] = "Z");
    })(e.JoystickAxis || (e.JoystickAxis = {}));
    var t = e.JoystickAxis,
        i = (function () {
            function i(r) {
                var n = this;
                (this._leftJoystick = r ? !0 : !1),
                    (this._joystickIndex = i._globalJoystickIndex),
                    i._globalJoystickIndex++,
                    (this._axisTargetedByLeftAndRight = t.X),
                    (this._axisTargetedByUpAndDown = t.Y),
                    (this.reverseLeftRight = !1),
                    (this.reverseUpDown = !1),
                    (this._touches = new e.SmartCollection()),
                    (this.deltaPosition = e.Vector3.Zero()),
                    (this._joystickSensibility = 25),
                    (this._inversedSensibility = 1 / (this._joystickSensibility / 1e3)),
                    (this._rotationSpeed = 25),
                    (this._inverseRotationSpeed = 1 / (this._rotationSpeed / 1e3)),
                    (this._rotateOnAxisRelativeToMesh = !1),
                    (this._onResize = function (e) {
                        (i.vjCanvasWidth = window.innerWidth),
                            (i.vjCanvasHeight = window.innerHeight),
                            (i.vjCanvas.width = i.vjCanvasWidth),
                            (i.vjCanvas.height = i.vjCanvasHeight),
                            (i.halfWidth = i.vjCanvasWidth / 2),
                            (i.halfHeight = i.vjCanvasHeight / 2);
                    }),
                    i.vjCanvas ||
                        (window.addEventListener("resize", this._onResize, !1),
                        (i.vjCanvas = document.createElement("canvas")),
                        (i.vjCanvasWidth = window.innerWidth),
                        (i.vjCanvasHeight = window.innerHeight),
                        (i.vjCanvas.width = window.innerWidth),
                        (i.vjCanvas.height = window.innerHeight),
                        (i.vjCanvas.style.width = "100%"),
                        (i.vjCanvas.style.height = "100%"),
                        (i.vjCanvas.style.position = "absolute"),
                        (i.vjCanvas.style.backgroundColor = "transparent"),
                        (i.vjCanvas.style.top = "0px"),
                        (i.vjCanvas.style.left = "0px"),
                        (i.vjCanvas.style.zIndex = "5"),
                        (i.vjCanvas.style.msTouchAction = "none"),
                        i.vjCanvas.setAttribute("touch-action", "none"),
                        (i.vjCanvasContext = i.vjCanvas.getContext("2d")),
                        (i.vjCanvasContext.strokeStyle = "#ffffff"),
                        (i.vjCanvasContext.lineWidth = 2),
                        document.body.appendChild(i.vjCanvas)),
                    (i.halfWidth = i.vjCanvas.width / 2),
                    (i.halfHeight = i.vjCanvas.height / 2),
                    (this.pressed = !1),
                    (this._joystickColor = "cyan"),
                    (this._joystickPointerID = -1),
                    (this._joystickPointerPos = new e.Vector2(0, 0)),
                    (this._joystickPreviousPointerPos = new e.Vector2(0, 0)),
                    (this._joystickPointerStartPos = new e.Vector2(0, 0)),
                    (this._deltaJoystickVector = new e.Vector2(0, 0)),
                    (this._onPointerDownHandlerRef = function (e) {
                        n._onPointerDown(e);
                    }),
                    (this._onPointerMoveHandlerRef = function (e) {
                        n._onPointerMove(e);
                    }),
                    (this._onPointerOutHandlerRef = function (e) {
                        n._onPointerUp(e);
                    }),
                    (this._onPointerUpHandlerRef = function (e) {
                        n._onPointerUp(e);
                    }),
                    i.vjCanvas.addEventListener("pointerdown", this._onPointerDownHandlerRef, !1),
                    i.vjCanvas.addEventListener("pointermove", this._onPointerMoveHandlerRef, !1),
                    i.vjCanvas.addEventListener("pointerup", this._onPointerUpHandlerRef, !1),
                    i.vjCanvas.addEventListener("pointerout", this._onPointerUpHandlerRef, !1),
                    i.vjCanvas.addEventListener(
                        "contextmenu",
                        function (e) {
                            e.preventDefault();
                        },
                        !1
                    ),
                    requestAnimationFrame(function () {
                        n._drawVirtualJoystick();
                    });
            }
            return (
                (i.prototype.setJoystickSensibility = function (e) {
                    (this._joystickSensibility = e), (this._inversedSensibility = 1 / (this._joystickSensibility / 1e3));
                }),
                (i.prototype._onPointerDown = function (e) {
                    var t;
                    e.preventDefault(),
                        (t = this._leftJoystick === !0 ? e.clientX < i.halfWidth : e.clientX > i.halfWidth),
                        t && this._joystickPointerID < 0
                            ? ((this._joystickPointerID = e.pointerId),
                              (this._joystickPointerStartPos.x = e.clientX),
                              (this._joystickPointerStartPos.y = e.clientY),
                              (this._joystickPointerPos = this._joystickPointerStartPos.clone()),
                              (this._joystickPreviousPointerPos = this._joystickPointerStartPos.clone()),
                              (this._deltaJoystickVector.x = 0),
                              (this._deltaJoystickVector.y = 0),
                              (this.pressed = !0),
                              this._touches.add(e.pointerId.toString(), e))
                            : i._globalJoystickIndex < 2 && this._action && (this._action(), this._touches.add(e.pointerId.toString(), { x: e.clientX, y: e.clientY, prevX: e.clientX, prevY: e.clientY }));
                }),
                (i.prototype._onPointerMove = function (e) {
                    if (this._joystickPointerID == e.pointerId) {
                        (this._joystickPointerPos.x = e.clientX),
                            (this._joystickPointerPos.y = e.clientY),
                            (this._deltaJoystickVector = this._joystickPointerPos.clone()),
                            (this._deltaJoystickVector = this._deltaJoystickVector.subtract(this._joystickPointerStartPos));
                        var i = this.reverseLeftRight ? -1 : 1,
                            r = (i * this._deltaJoystickVector.x) / this._inversedSensibility;
                        switch (this._axisTargetedByLeftAndRight) {
                            case t.X:
                                this.deltaPosition.x = Math.min(1, Math.max(-1, r));
                                break;
                            case t.Y:
                                this.deltaPosition.y = Math.min(1, Math.max(-1, r));
                                break;
                            case t.Z:
                                this.deltaPosition.z = Math.min(1, Math.max(-1, r));
                        }
                        var n = this.reverseUpDown ? 1 : -1,
                            o = (n * this._deltaJoystickVector.y) / this._inversedSensibility;
                        switch (this._axisTargetedByUpAndDown) {
                            case t.X:
                                this.deltaPosition.x = Math.min(1, Math.max(-1, o));
                                break;
                            case t.Y:
                                this.deltaPosition.y = Math.min(1, Math.max(-1, o));
                                break;
                            case t.Z:
                                this.deltaPosition.z = Math.min(1, Math.max(-1, o));
                        }
                    } else this._touches.item(e.pointerId.toString()) && ((this._touches.item(e.pointerId.toString()).x = e.clientX), (this._touches.item(e.pointerId.toString()).y = e.clientY));
                }),
                (i.prototype._onPointerUp = function (e) {
                    if (this._joystickPointerID == e.pointerId)
                        i.vjCanvasContext.clearRect(this._joystickPointerStartPos.x - 63, this._joystickPointerStartPos.y - 63, 126, 126),
                            i.vjCanvasContext.clearRect(this._joystickPreviousPointerPos.x - 41, this._joystickPreviousPointerPos.y - 41, 82, 82),
                            (this._joystickPointerID = -1),
                            (this.pressed = !1);
                    else {
                        var t = this._touches.item(e.pointerId.toString());
                        t && i.vjCanvasContext.clearRect(t.prevX - 43, t.prevY - 43, 86, 86);
                    }
                    (this._deltaJoystickVector.x = 0), (this._deltaJoystickVector.y = 0), this._touches.remove(e.pointerId.toString());
                }),
                (i.prototype.setJoystickColor = function (e) {
                    this._joystickColor = e;
                }),
                (i.prototype.setActionOnTouch = function (e) {
                    this._action = e;
                }),
                (i.prototype.setAxisForLeftRight = function (e) {
                    switch (e) {
                        case t.X:
                        case t.Y:
                        case t.Z:
                            this._axisTargetedByLeftAndRight = e;
                            break;
                        default:
                            this._axisTargetedByLeftAndRight = t.X;
                    }
                }),
                (i.prototype.setAxisForUpDown = function (e) {
                    switch (e) {
                        case t.X:
                        case t.Y:
                        case t.Z:
                            this._axisTargetedByUpAndDown = e;
                            break;
                        default:
                            this._axisTargetedByUpAndDown = t.Y;
                    }
                }),
                (i.prototype._clearCanvas = function () {
                    this._leftJoystick ? i.vjCanvasContext.clearRect(0, 0, i.vjCanvasWidth / 2, i.vjCanvasHeight) : i.vjCanvasContext.clearRect(i.vjCanvasWidth / 2, 0, i.vjCanvasWidth, i.vjCanvasHeight);
                }),
                (i.prototype._drawVirtualJoystick = function () {
                    var e = this;
                    this.pressed &&
                        this._touches.forEach(function (t) {
                            t.pointerId === e._joystickPointerID
                                ? (i.vjCanvasContext.clearRect(e._joystickPointerStartPos.x - 63, e._joystickPointerStartPos.y - 63, 126, 126),
                                  i.vjCanvasContext.clearRect(e._joystickPreviousPointerPos.x - 41, e._joystickPreviousPointerPos.y - 41, 82, 82),
                                  i.vjCanvasContext.beginPath(),
                                  (i.vjCanvasContext.lineWidth = 6),
                                  (i.vjCanvasContext.strokeStyle = e._joystickColor),
                                  i.vjCanvasContext.arc(e._joystickPointerStartPos.x, e._joystickPointerStartPos.y, 40, 0, 2 * Math.PI, !0),
                                  i.vjCanvasContext.stroke(),
                                  i.vjCanvasContext.closePath(),
                                  i.vjCanvasContext.beginPath(),
                                  (i.vjCanvasContext.strokeStyle = e._joystickColor),
                                  (i.vjCanvasContext.lineWidth = 2),
                                  i.vjCanvasContext.arc(e._joystickPointerStartPos.x, e._joystickPointerStartPos.y, 60, 0, 2 * Math.PI, !0),
                                  i.vjCanvasContext.stroke(),
                                  i.vjCanvasContext.closePath(),
                                  i.vjCanvasContext.beginPath(),
                                  (i.vjCanvasContext.strokeStyle = e._joystickColor),
                                  i.vjCanvasContext.arc(e._joystickPointerPos.x, e._joystickPointerPos.y, 40, 0, 2 * Math.PI, !0),
                                  i.vjCanvasContext.stroke(),
                                  i.vjCanvasContext.closePath(),
                                  (e._joystickPreviousPointerPos = e._joystickPointerPos.clone()))
                                : (i.vjCanvasContext.clearRect(t.prevX - 43, t.prevY - 43, 86, 86),
                                  i.vjCanvasContext.beginPath(),
                                  (i.vjCanvasContext.fillStyle = "white"),
                                  i.vjCanvasContext.beginPath(),
                                  (i.vjCanvasContext.strokeStyle = "red"),
                                  (i.vjCanvasContext.lineWidth = 6),
                                  i.vjCanvasContext.arc(t.x, t.y, 40, 0, 2 * Math.PI, !0),
                                  i.vjCanvasContext.stroke(),
                                  i.vjCanvasContext.closePath(),
                                  (t.prevX = t.x),
                                  (t.prevY = t.y));
                        }),
                        requestAnimationFrame(function () {
                            e._drawVirtualJoystick();
                        });
                }),
                (i.prototype.releaseCanvas = function () {
                    i.vjCanvas &&
                        (i.vjCanvas.removeEventListener("pointerdown", this._onPointerDownHandlerRef),
                        i.vjCanvas.removeEventListener("pointermove", this._onPointerMoveHandlerRef),
                        i.vjCanvas.removeEventListener("pointerup", this._onPointerUpHandlerRef),
                        i.vjCanvas.removeEventListener("pointerout", this._onPointerUpHandlerRef),
                        window.removeEventListener("resize", this._onResize),
                        document.body.removeChild(i.vjCanvas),
                        (i.vjCanvas = null));
                }),
                (i._globalJoystickIndex = 0),
                i
            );
        })();
    e.VirtualJoystick = i;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n) {
            t.call(this, i, r, n),
                (this._leftjoystick = new e.VirtualJoystick(!0)),
                this._leftjoystick.setAxisForUpDown(e.JoystickAxis.Z),
                this._leftjoystick.setAxisForLeftRight(e.JoystickAxis.X),
                this._leftjoystick.setJoystickSensibility(0.15),
                (this._rightjoystick = new e.VirtualJoystick(!1)),
                this._rightjoystick.setAxisForUpDown(e.JoystickAxis.X),
                this._rightjoystick.setAxisForLeftRight(e.JoystickAxis.Y),
                (this._rightjoystick.reverseUpDown = !0),
                this._rightjoystick.setJoystickSensibility(0.05),
                this._rightjoystick.setJoystickColor("yellow");
        }
        return (
            __extends(i, t),
            (i.prototype.getLeftJoystick = function () {
                return this._leftjoystick;
            }),
            (i.prototype.getRightJoystick = function () {
                return this._rightjoystick;
            }),
            (i.prototype._checkInputs = function () {
                var i = 50 * this._computeLocalCameraSpeed(),
                    r = e.Matrix.RotationYawPitchRoll(this.rotation.y, this.rotation.x, 0),
                    n = e.Vector3.TransformCoordinates(new e.Vector3(this._leftjoystick.deltaPosition.x * i, this._leftjoystick.deltaPosition.y * i, this._leftjoystick.deltaPosition.z * i), r);
                (this.cameraDirection = this.cameraDirection.add(n)),
                    (this.cameraRotation = this.cameraRotation.addVector3(this._rightjoystick.deltaPosition)),
                    this._leftjoystick.pressed || (this._leftjoystick.deltaPosition = this._leftjoystick.deltaPosition.scale(0.9)),
                    this._rightjoystick.pressed || (this._rightjoystick.deltaPosition = this._rightjoystick.deltaPosition.scale(0.9)),
                    t.prototype._checkInputs.call(this);
            }),
            (i.prototype.dispose = function () {
                this._leftjoystick.releaseCanvas(), t.prototype.dispose.call(this);
            }),
            i
        );
    })(e.FreeCamera);
    e.VirtualJoysticksCamera = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (t) {
        function i(i, r, n, o) {
            t.call(this, i, r),
                (this._textures = new Array()),
                (this._floats = new Array()),
                (this._floatsArrays = {}),
                (this._colors3 = new Array()),
                (this._colors4 = new Array()),
                (this._vectors2 = new Array()),
                (this._vectors3 = new Array()),
                (this._vectors4 = new Array()),
                (this._matrices = new Array()),
                (this._matrices3x3 = new Array()),
                (this._matrices2x2 = new Array()),
                (this._cachedWorldViewMatrix = new e.Matrix()),
                (this._shaderPath = n),
                (o.needAlphaBlending = o.needAlphaBlending || !1),
                (o.needAlphaTesting = o.needAlphaTesting || !1),
                (o.attributes = o.attributes || ["position", "normal", "uv"]),
                (o.uniforms = o.uniforms || ["worldViewProjection"]),
                (o.samplers = o.samplers || []),
                (o.defines = o.defines || []),
                (this._options = o);
        }
        return (
            __extends(i, t),
            (i.prototype.needAlphaBlending = function () {
                return this._options.needAlphaBlending;
            }),
            (i.prototype.needAlphaTesting = function () {
                return this._options.needAlphaTesting;
            }),
            (i.prototype._checkUniform = function (e) {
                -1 === this._options.uniforms.indexOf(e) && this._options.uniforms.push(e);
            }),
            (i.prototype.setTexture = function (e, t) {
                return -1 === this._options.samplers.indexOf(e) && this._options.samplers.push(e), (this._textures[e] = t), this;
            }),
            (i.prototype.setFloat = function (e, t) {
                return this._checkUniform(e), (this._floats[e] = t), this;
            }),
            (i.prototype.setFloats = function (e, t) {
                return this._checkUniform(e), (this._floatsArrays[e] = t), this;
            }),
            (i.prototype.setColor3 = function (e, t) {
                return this._checkUniform(e), (this._colors3[e] = t), this;
            }),
            (i.prototype.setColor4 = function (e, t) {
                return this._checkUniform(e), (this._colors4[e] = t), this;
            }),
            (i.prototype.setVector2 = function (e, t) {
                return this._checkUniform(e), (this._vectors2[e] = t), this;
            }),
            (i.prototype.setVector3 = function (e, t) {
                return this._checkUniform(e), (this._vectors3[e] = t), this;
            }),
            (i.prototype.setVector4 = function (e, t) {
                return this._checkUniform(e), (this._vectors4[e] = t), this;
            }),
            (i.prototype.setMatrix = function (e, t) {
                return this._checkUniform(e), (this._matrices[e] = t), this;
            }),
            (i.prototype.setMatrix3x3 = function (e, t) {
                return this._checkUniform(e), (this._matrices3x3[e] = t), this;
            }),
            (i.prototype.setMatrix2x2 = function (e, t) {
                return this._checkUniform(e), (this._matrices2x2[e] = t), this;
            }),
            (i.prototype.isReady = function (t, i) {
                var r = this.getScene(),
                    n = r.getEngine();
                if (!this.checkReadyOnEveryCall && this._renderId === r.getRenderId()) return !0;
                var o = [],
                    s = new e.EffectFallbacks();
                i && o.push("#define INSTANCES");
                for (var a = 0; a < this._options.defines.length; a++) o.push(this._options.defines[a]);
                t && t.useBones && t.computeBonesUsingShaders && (o.push("#define BONES"), o.push("#define BonesPerMesh " + (t.skeleton.bones.length + 1)), o.push("#define BONES4"), s.addFallback(0, "BONES4")),
                    n.getAlphaTesting() && o.push("#define ALPHATEST");
                var h = this._effect,
                    l = o.join("\n");
                return (
                    (this._effect = n.createEffect(this._shaderPath, this._options.attributes, this._options.uniforms, this._options.samplers, l, s, this.onCompiled, this.onError)),
                    this._effect.isReady() ? (h !== this._effect && r.resetCachedMaterial(), (this._renderId = r.getRenderId()), !0) : !1
                );
            }),
            (i.prototype.bindOnlyWorldMatrix = function (e) {
                var t = this.getScene();
                -1 !== this._options.uniforms.indexOf("world") && this._effect.setMatrix("world", e),
                    -1 !== this._options.uniforms.indexOf("worldView") && (e.multiplyToRef(t.getViewMatrix(), this._cachedWorldViewMatrix), this._effect.setMatrix("worldView", this._cachedWorldViewMatrix)),
                    -1 !== this._options.uniforms.indexOf("worldViewProjection") && this._effect.setMatrix("worldViewProjection", e.multiply(t.getTransformMatrix()));
            }),
            (i.prototype.bind = function (e, i) {
                if ((this.bindOnlyWorldMatrix(e), this.getScene().getCachedMaterial() !== this)) {
                    -1 !== this._options.uniforms.indexOf("view") && this._effect.setMatrix("view", this.getScene().getViewMatrix()),
                        -1 !== this._options.uniforms.indexOf("projection") && this._effect.setMatrix("projection", this.getScene().getProjectionMatrix()),
                        -1 !== this._options.uniforms.indexOf("viewProjection") && this._effect.setMatrix("viewProjection", this.getScene().getTransformMatrix()),
                        i && i.useBones && i.computeBonesUsingShaders && this._effect.setMatrices("mBones", i.skeleton.getTransformMatrices());
                    for (var r in this._textures) this._effect.setTexture(r, this._textures[r]);
                    for (r in this._floats) this._effect.setFloat(r, this._floats[r]);
                    for (r in this._floatsArrays) this._effect.setArray(r, this._floatsArrays[r]);
                    for (r in this._colors3) this._effect.setColor3(r, this._colors3[r]);
                    for (r in this._colors4) {
                        var n = this._colors4[r];
                        this._effect.setFloat4(r, n.r, n.g, n.b, n.a);
                    }
                    for (r in this._vectors2) this._effect.setVector2(r, this._vectors2[r]);
                    for (r in this._vectors3) this._effect.setVector3(r, this._vectors3[r]);
                    for (r in this._vectors4) this._effect.setVector4(r, this._vectors4[r]);
                    for (r in this._matrices) this._effect.setMatrix(r, this._matrices[r]);
                    for (r in this._matrices3x3) this._effect.setMatrix3x3(r, this._matrices3x3[r]);
                    for (r in this._matrices2x2) this._effect.setMatrix2x2(r, this._matrices2x2[r]);
                }
                t.prototype.bind.call(this, e, i);
            }),
            (i.prototype.clone = function (e) {
                var t = new i(e, this.getScene(), this._shaderPath, this._options);
                return t;
            }),
            (i.prototype.dispose = function (e) {
                for (var i in this._textures) this._textures[i].dispose();
                (this._textures = []), t.prototype.dispose.call(this, e);
            }),
            i
        );
    })(e.Material);
    e.ShaderMaterial = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t() {}
        return (
            (t.prototype.set = function (t, i) {
                switch (i) {
                    case e.VertexBuffer.PositionKind:
                        this.positions = t;
                        break;
                    case e.VertexBuffer.NormalKind:
                        this.normals = t;
                        break;
                    case e.VertexBuffer.UVKind:
                        this.uvs = t;
                        break;
                    case e.VertexBuffer.UV2Kind:
                        this.uvs2 = t;
                        break;
                    case e.VertexBuffer.UV3Kind:
                        this.uvs3 = t;
                        break;
                    case e.VertexBuffer.UV4Kind:
                        this.uvs4 = t;
                        break;
                    case e.VertexBuffer.UV5Kind:
                        this.uvs5 = t;
                        break;
                    case e.VertexBuffer.UV6Kind:
                        this.uvs6 = t;
                        break;
                    case e.VertexBuffer.ColorKind:
                        this.colors = t;
                        break;
                    case e.VertexBuffer.MatricesIndicesKind:
                        this.matricesIndices = t;
                        break;
                    case e.VertexBuffer.MatricesWeightsKind:
                        this.matricesWeights = t;
                }
            }),
            (t.prototype.applyToMesh = function (e, t) {
                this._applyTo(e, t);
            }),
            (t.prototype.applyToGeometry = function (e, t) {
                this._applyTo(e, t);
            }),
            (t.prototype.updateMesh = function (e, t, i) {
                this._update(e);
            }),
            (t.prototype.updateGeometry = function (e, t, i) {
                this._update(e);
            }),
            (t.prototype._applyTo = function (t, i) {
                this.positions && t.setVerticesData(e.VertexBuffer.PositionKind, this.positions, i),
                    this.normals && t.setVerticesData(e.VertexBuffer.NormalKind, this.normals, i),
                    this.uvs && t.setVerticesData(e.VertexBuffer.UVKind, this.uvs, i),
                    this.uvs2 && t.setVerticesData(e.VertexBuffer.UV2Kind, this.uvs2, i),
                    this.uvs3 && t.setVerticesData(e.VertexBuffer.UV3Kind, this.uvs3, i),
                    this.uvs4 && t.setVerticesData(e.VertexBuffer.UV4Kind, this.uvs4, i),
                    this.uvs5 && t.setVerticesData(e.VertexBuffer.UV5Kind, this.uvs5, i),
                    this.uvs6 && t.setVerticesData(e.VertexBuffer.UV6Kind, this.uvs6, i),
                    this.colors && t.setVerticesData(e.VertexBuffer.ColorKind, this.colors, i),
                    this.matricesIndices && t.setVerticesData(e.VertexBuffer.MatricesIndicesKind, this.matricesIndices, i),
                    this.matricesWeights && t.setVerticesData(e.VertexBuffer.MatricesWeightsKind, this.matricesWeights, i),
                    this.indices && t.setIndices(this.indices);
            }),
            (t.prototype._update = function (t, i, r) {
                this.positions && t.updateVerticesData(e.VertexBuffer.PositionKind, this.positions, i, r),
                    this.normals && t.updateVerticesData(e.VertexBuffer.NormalKind, this.normals, i, r),
                    this.uvs && t.updateVerticesData(e.VertexBuffer.UVKind, this.uvs, i, r),
                    this.uvs2 && t.updateVerticesData(e.VertexBuffer.UV2Kind, this.uvs2, i, r),
                    this.uvs3 && t.updateVerticesData(e.VertexBuffer.UV3Kind, this.uvs3, i, r),
                    this.uvs4 && t.updateVerticesData(e.VertexBuffer.UV4Kind, this.uvs4, i, r),
                    this.uvs5 && t.updateVerticesData(e.VertexBuffer.UV5Kind, this.uvs5, i, r),
                    this.uvs6 && t.updateVerticesData(e.VertexBuffer.UV6Kind, this.uvs6, i, r),
                    this.colors && t.updateVerticesData(e.VertexBuffer.ColorKind, this.colors, i, r),
                    this.matricesIndices && t.updateVerticesData(e.VertexBuffer.MatricesIndicesKind, this.matricesIndices, i, r),
                    this.matricesWeights && t.updateVerticesData(e.VertexBuffer.MatricesWeightsKind, this.matricesWeights, i, r),
                    this.indices && t.setIndices(this.indices);
            }),
            (t.prototype.transform = function (t) {
                var i,
                    r = e.Vector3.Zero();
                if (this.positions) {
                    var n = e.Vector3.Zero();
                    for (i = 0; i < this.positions.length; i += 3)
                        e.Vector3.FromArrayToRef(this.positions, i, n), e.Vector3.TransformCoordinatesToRef(n, t, r), (this.positions[i] = r.x), (this.positions[i + 1] = r.y), (this.positions[i + 2] = r.z);
                }
                if (this.normals) {
                    var o = e.Vector3.Zero();
                    for (i = 0; i < this.normals.length; i += 3) e.Vector3.FromArrayToRef(this.normals, i, o), e.Vector3.TransformNormalToRef(o, t, r), (this.normals[i] = r.x), (this.normals[i + 1] = r.y), (this.normals[i + 2] = r.z);
                }
            }),
            (t.prototype.merge = function (e) {
                var t;
                if (e.indices) {
                    this.indices || (this.indices = []);
                    var i = this.positions ? this.positions.length / 3 : 0;
                    for (t = 0; t < e.indices.length; t++) this.indices.push(e.indices[t] + i);
                }
                if (e.positions) for (this.positions || (this.positions = []), t = 0; t < e.positions.length; t++) this.positions.push(e.positions[t]);
                if (e.normals) for (this.normals || (this.normals = []), t = 0; t < e.normals.length; t++) this.normals.push(e.normals[t]);
                if (e.uvs) for (this.uvs || (this.uvs = []), t = 0; t < e.uvs.length; t++) this.uvs.push(e.uvs[t]);
                if (e.uvs2) for (this.uvs2 || (this.uvs2 = []), t = 0; t < e.uvs2.length; t++) this.uvs2.push(e.uvs2[t]);
                if (e.uvs3) for (this.uvs3 || (this.uvs3 = []), t = 0; t < e.uvs3.length; t++) this.uvs3.push(e.uvs3[t]);
                if (e.uvs4) for (this.uvs4 || (this.uvs4 = []), t = 0; t < e.uvs4.length; t++) this.uvs4.push(e.uvs4[t]);
                if (e.uvs5) for (this.uvs5 || (this.uvs5 = []), t = 0; t < e.uvs5.length; t++) this.uvs5.push(e.uvs5[t]);
                if (e.uvs6) for (this.uvs6 || (this.uvs6 = []), t = 0; t < e.uvs6.length; t++) this.uvs6.push(e.uvs6[t]);
                if (e.matricesIndices) for (this.matricesIndices || (this.matricesIndices = []), t = 0; t < e.matricesIndices.length; t++) this.matricesIndices.push(e.matricesIndices[t]);
                if (e.matricesWeights) for (this.matricesWeights || (this.matricesWeights = []), t = 0; t < e.matricesWeights.length; t++) this.matricesWeights.push(e.matricesWeights[t]);
                if (e.colors) for (this.colors || (this.colors = []), t = 0; t < e.colors.length; t++) this.colors.push(e.colors[t]);
            }),
            (t.ExtractFromMesh = function (e, i) {
                return t._ExtractFrom(e, i);
            }),
            (t.ExtractFromGeometry = function (e, i) {
                return t._ExtractFrom(e, i);
            }),
            (t._ExtractFrom = function (i, r) {
                var n = new t();
                return (
                    i.isVerticesDataPresent(e.VertexBuffer.PositionKind) && (n.positions = i.getVerticesData(e.VertexBuffer.PositionKind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.NormalKind) && (n.normals = i.getVerticesData(e.VertexBuffer.NormalKind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.UVKind) && (n.uvs = i.getVerticesData(e.VertexBuffer.UVKind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.UV2Kind) && (n.uvs2 = i.getVerticesData(e.VertexBuffer.UV2Kind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.UV3Kind) && (n.uvs3 = i.getVerticesData(e.VertexBuffer.UV3Kind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.UV4Kind) && (n.uvs4 = i.getVerticesData(e.VertexBuffer.UV4Kind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.UV5Kind) && (n.uvs5 = i.getVerticesData(e.VertexBuffer.UV5Kind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.UV6Kind) && (n.uvs6 = i.getVerticesData(e.VertexBuffer.UV6Kind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.ColorKind) && (n.colors = i.getVerticesData(e.VertexBuffer.ColorKind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.MatricesIndicesKind) && (n.matricesIndices = i.getVerticesData(e.VertexBuffer.MatricesIndicesKind, r)),
                    i.isVerticesDataPresent(e.VertexBuffer.MatricesWeightsKind) && (n.matricesWeights = i.getVerticesData(e.VertexBuffer.MatricesWeightsKind, r)),
                    (n.indices = i.getIndices(r)),
                    n
                );
            }),
            (t.CreateRibbon = function (i) {
                var r = i.pathArray,
                    n = i.closeArray || !1,
                    o = i.closePath || !1,
                    s = Math.floor(r[0].length / 2),
                    a = i.offset || s;
                a = a > s ? s : Math.floor(a);
                var h,
                    l,
                    c,
                    u,
                    f = 0 === i.sideOrientation ? 0 : i.sideOrientation || e.Mesh.DEFAULTSIDE,
                    d = [],
                    p = [],
                    m = [],
                    g = [],
                    _ = [],
                    v = [],
                    y = [],
                    x = [],
                    M = [],
                    S = [];
                if (r.length < 2) {
                    var b = [],
                        A = [];
                    for (c = 0; c < r[0].length - a; c++) b.push(r[0][c]), A.push(r[0][c + a]);
                    r = [b, A];
                }
                var T,
                    E,
                    P = 0,
                    D = o ? 1 : 0;
                h = r[0].length;
                var C, I;
                for (l = 0; l < r.length; l++) {
                    for (y[l] = 0, _[l] = [0], T = r[l], E = T.length, h = E > h ? h : E, u = 0; E > u; ) d.push(T[u].x, T[u].y, T[u].z), u > 0 && ((C = T[u].subtract(T[u - 1]).length()), (I = C + y[l]), _[l].push(I), (y[l] = I)), u++;
                    o && (u--, d.push(T[0].x, T[0].y, T[0].z), (C = T[u].subtract(T[0]).length()), (I = C + y[l]), _[l].push(I), (y[l] = I)), (M[l] = E + D), (S[l] = P), (P += E + D);
                }
                var w, R, L, O;
                for (c = 0; h + D > c; c++) {
                    for (x[c] = 0, v[c] = [0], l = 0; l < r.length - 1; l++) (w = r[l]), (R = r[l + 1]), c === h ? ((L = w[0]), (O = R[0])) : ((L = w[c]), (O = R[c])), (C = O.subtract(L).length()), (I = C + x[c]), v[c].push(I), (x[c] = I);
                    n && ((w = r[l]), (R = r[0]), (C = R[c].subtract(w[c]).length()), (I = C + x[c]), (x[c] = I));
                }
                var B, F;
                for (l = 0; l < r.length; l++) for (c = 0; h + D > c; c++) (B = _[l][c] / y[l]), (F = v[c][l] / x[c]), g.push(B, F);
                l = 0;
                for (var V = 0, N = M[l] - 1, z = M[l + 1] - 1, k = z > N ? N : z, U = S[1] - S[0], W = n ? M.length : M.length - 1; k >= V && W > l; )
                    p.push(V, V + U, V + 1),
                        p.push(V + U + 1, V + 1, V + U),
                        (V += 1),
                        V === k && (l++, l === M.length - 1 ? ((U = S[0] - S[l]), (N = M[l] - 1), (z = M[0] - 1)) : ((U = S[l + 1] - S[l]), (N = M[l] - 1), (z = M[l + 1] - 1)), (V = S[l]), (k = z > N ? N + V : z + V));
                if ((t.ComputeNormals(d, p, m), o)) {
                    var G = 0,
                        Y = 0;
                    for (l = 0; l < r.length; l++)
                        (G = 3 * S[l]),
                            (Y = l + 1 < r.length ? 3 * (S[l + 1] - 1) : m.length - 3),
                            (m[G] = 0.5 * (m[G] + m[Y])),
                            (m[G + 1] = 0.5 * (m[G + 1] + m[Y + 1])),
                            (m[G + 2] = 0.5 * (m[G + 2] + m[Y + 2])),
                            (m[Y] = m[G]),
                            (m[Y + 1] = m[G + 1]),
                            (m[Y + 2] = m[G + 2]);
                }
                t._ComputeSides(f, d, p, m, g);
                var H = new t();
                return (H.indices = p), (H.positions = d), (H.normals = m), (H.uvs = g), o && (H._idx = S), H;
            }),
            (t.CreateBox = function (i) {
                var r,
                    n = [new e.Vector3(0, 0, 1), new e.Vector3(0, 0, -1), new e.Vector3(1, 0, 0), new e.Vector3(-1, 0, 0), new e.Vector3(0, 1, 0), new e.Vector3(0, -1, 0)],
                    o = [],
                    s = [],
                    a = [],
                    h = [],
                    l = i.width || i.size || 1,
                    c = i.height || i.size || 1,
                    u = i.depth || i.size || 1,
                    f = 0 === i.sideOrientation ? 0 : i.sideOrientation || e.Mesh.DEFAULTSIDE,
                    d = i.faceUV || new Array(6),
                    p = [];
                i.faceColors && (r = i.faceColors);
                for (var m = 0; 6 > m; m++) void 0 === d[m] && (d[m] = new e.Vector4(0, 0, 1, 1)), r && void 0 === r[m] && (r[m] = new e.Color4(1, 1, 1, 1));
                for (var g = new e.Vector3(l / 2, c / 2, u / 2), _ = 0; _ < n.length; _++) {
                    var v = n[_],
                        y = new e.Vector3(v.y, v.z, v.x),
                        x = e.Vector3.Cross(v, y),
                        M = s.length / 3;
                    o.push(M), o.push(M + 1), o.push(M + 2), o.push(M), o.push(M + 2), o.push(M + 3);
                    var S = v.subtract(y).subtract(x).multiply(g);
                    s.push(S.x, S.y, S.z),
                        a.push(v.x, v.y, v.z),
                        h.push(d[_].z, d[_].w),
                        r && p.push(r[_].r, r[_].g, r[_].b, r[_].a),
                        (S = v.subtract(y).add(x).multiply(g)),
                        s.push(S.x, S.y, S.z),
                        a.push(v.x, v.y, v.z),
                        h.push(d[_].x, d[_].w),
                        r && p.push(r[_].r, r[_].g, r[_].b, r[_].a),
                        (S = v.add(y).add(x).multiply(g)),
                        s.push(S.x, S.y, S.z),
                        a.push(v.x, v.y, v.z),
                        h.push(d[_].x, d[_].y),
                        r && p.push(r[_].r, r[_].g, r[_].b, r[_].a),
                        (S = v.add(y).subtract(x).multiply(g)),
                        s.push(S.x, S.y, S.z),
                        a.push(v.x, v.y, v.z),
                        h.push(d[_].z, d[_].y),
                        r && p.push(r[_].r, r[_].g, r[_].b, r[_].a);
                }
                t._ComputeSides(f, s, o, a, h);
                var b = new t();
                if (((b.indices = o), (b.positions = s), (b.normals = a), (b.uvs = h), r)) {
                    var A = f === e.Mesh.DOUBLESIDE ? p.concat(p) : p;
                    b.colors = A;
                }
                return b;
            }),
            (t.CreateSphere = function (i) {
                for (
                    var r = i.segments || 32,
                        n = i.diameterX || i.diameter || 1,
                        o = i.diameterY || i.diameter || 1,
                        s = i.diameterZ || i.diameter || 1,
                        a = 0 === i.sideOrientation ? 0 : i.sideOrientation || e.Mesh.DEFAULTSIDE,
                        h = new e.Vector3(n / 2, o / 2, s / 2),
                        l = 2 + r,
                        c = 2 * l,
                        u = [],
                        f = [],
                        d = [],
                        p = [],
                        m = 0;
                    l >= m;
                    m++
                ) {
                    for (var g = m / l, _ = g * Math.PI, v = 0; c >= v; v++) {
                        var y = v / c,
                            x = y * Math.PI * 2,
                            M = e.Matrix.RotationZ(-_),
                            S = e.Matrix.RotationY(x),
                            b = e.Vector3.TransformCoordinates(e.Vector3.Up(), M),
                            A = e.Vector3.TransformCoordinates(b, S),
                            T = A.multiply(h),
                            E = e.Vector3.Normalize(T);
                        f.push(T.x, T.y, T.z), d.push(E.x, E.y, E.z), p.push(y, g);
                    }
                    if (m > 0) for (var P = f.length / 3, D = P - 2 * (c + 1); P > D + c + 2; D++) u.push(D), u.push(D + 1), u.push(D + c + 1), u.push(D + c + 1), u.push(D + 1), u.push(D + c + 2);
                }
                t._ComputeSides(a, f, u, d, p);
                var C = new t();
                return (C.indices = u), (C.positions = f), (C.normals = d), (C.uvs = p), C;
            }),
            (t.CreateCylinder = function (i) {
                var r,
                    n,
                    o,
                    s,
                    a,
                    h = i.height || 2,
                    l = 0 === i.diameterTop ? 0 : i.diameterTop || 1,
                    c = i.diameterBottom || 1,
                    u = i.tessellation || 24,
                    f = i.subdivisions || 1,
                    d = 0 === i.sideOrientation ? 0 : i.sideOrientation || e.Mesh.DEFAULTSIDE,
                    p = [],
                    m = [],
                    g = [],
                    _ = [],
                    v = (2 * Math.PI) / u,
                    y = (c - l) / 2 / h,
                    x = e.Vector3.Zero(),
                    M = e.Vector3.Zero();
                for (s = 0; f >= s; s++)
                    for (n = s / f, o = (n * (l - c) + c) / 2, a = 0; u >= a; a++)
                        (r = a * v),
                            (x.x = Math.cos(-r) * o),
                            (x.y = -h / 2 + n * h),
                            (x.z = Math.sin(-r) * o),
                            0 === l && s === f
                                ? ((M.x = g[g.length - 3 * (u + 1)]), (M.y = g[g.length - 3 * (u + 1) + 1]), (M.z = g[g.length - 3 * (u + 1) + 2]))
                                : ((M.x = x.x), (M.z = x.z), (M.y = Math.sqrt(M.x * M.x + M.z * M.z) * y), M.normalize()),
                            m.push(x.x, x.y, x.z),
                            g.push(M.x, M.y, M.z),
                            _.push(a / u, 1 - n);
                for (s = 0; f > s; s++)
                    for (a = 0; u > a; a++) {
                        var S = s * (u + 1) + a,
                            b = (s + 1) * (u + 1) + a,
                            A = s * (u + 1) + (a + 1),
                            T = (s + 1) * (u + 1) + (a + 1);
                        p.push(S, b, A), p.push(T, A, b);
                    }
                var E = function (t) {
                    var i = t ? l / 2 : c / 2;
                    if (0 !== i) {
                        var r,
                            n,
                            o,
                            s = m.length / 3,
                            a = new e.Vector3(0, t ? h / 2 : -h / 2, 0),
                            f = new e.Vector2(0.5, 0.5);
                        for (o = 0; u > o; o++) {
                            (r = (2 * Math.PI * o) / u), (n = new e.Vector3(Math.cos(-r), 0, Math.sin(-r)));
                            var d = n.scale(i).add(a),
                                v = new e.Vector2(n.x * f.x + 0.5, n.z * f.y + 0.5);
                            m.push(d.x, d.y, d.z), g.push(0, t ? 1 : -1, 0), _.push(v.x, v.y);
                        }
                        for (o = 0; u - 2 > o; o++) t ? (p.push(s), p.push(s + ((o + 2) % u)), p.push(s + ((o + 1) % u))) : (p.push(s), p.push(s + ((o + 1) % u)), p.push(s + ((o + 2) % u)));
                    }
                };
                E(!0), E(!1), t._ComputeSides(d, m, p, g, _);
                var P = new t();
                return (P.indices = p), (P.positions = m), (P.normals = g), (P.uvs = _), P;
            }),
            (t.CreateTorus = function (i) {
                for (var r = [], n = [], o = [], s = [], a = i.diameter || 1, h = i.thickness || 0.5, l = i.tessellation || 16, c = 0 === i.sideOrientation ? 0 : i.sideOrientation || e.Mesh.DEFAULTSIDE, u = l + 1, f = 0; l >= f; f++)
                    for (var d = f / l, p = (f * Math.PI * 2) / l - Math.PI / 2, m = e.Matrix.Translation(a / 2, 0, 0).multiply(e.Matrix.RotationY(p)), g = 0; l >= g; g++) {
                        var _ = 1 - g / l,
                            v = (g * Math.PI * 2) / l + Math.PI,
                            y = Math.cos(v),
                            x = Math.sin(v),
                            M = new e.Vector3(y, x, 0),
                            S = M.scale(h / 2),
                            b = new e.Vector2(d, _);
                        (S = e.Vector3.TransformCoordinates(S, m)), (M = e.Vector3.TransformNormal(M, m)), n.push(S.x, S.y, S.z), o.push(M.x, M.y, M.z), s.push(b.x, b.y);
                        var A = (f + 1) % u,
                            T = (g + 1) % u;
                        r.push(f * u + g), r.push(f * u + T), r.push(A * u + g), r.push(f * u + T), r.push(A * u + T), r.push(A * u + g);
                    }
                t._ComputeSides(c, n, r, o, s);
                var E = new t();
                return (E.indices = r), (E.positions = n), (E.normals = o), (E.uvs = s), E;
            }),
            (t.CreateLines = function (e) {
                for (var i = [], r = [], n = 0; n < e.length; n++) r.push(e[n].x, e[n].y, e[n].z), n > 0 && (i.push(n - 1), i.push(n));
                var o = new t();
                return (o.indices = i), (o.positions = r), o;
            }),
            (t.CreateDashedLines = function (i, r, n, o) {
                (r = r || 3), (n = n || 1), (o = o || 200);
                var s = new Array(),
                    a = new Array(),
                    h = e.Vector3.Zero(),
                    l = 0,
                    c = 0,
                    u = 0,
                    f = 0,
                    d = 0,
                    p = 0,
                    m = 0;
                for (m = 0; m < i.length - 1; m++) i[m + 1].subtractToRef(i[m], h), (l += h.length());
                for (u = l / o, f = (r * u) / (r + n), m = 0; m < i.length - 1; m++) {
                    i[m + 1].subtractToRef(i[m], h), (c = Math.floor(h.length() / u)), h.normalize();
                    for (var g = 0; c > g; g++) (d = u * g), s.push(i[m].x + d * h.x, i[m].y + d * h.y, i[m].z + d * h.z), s.push(i[m].x + (d + f) * h.x, i[m].y + (d + f) * h.y, i[m].z + (d + f) * h.z), a.push(p, p + 1), (p += 2);
                }
                var _ = new t();
                return (_.positions = s), (_.indices = a), _;
            }),
            (t.CreateGround = function (i) {
                var r,
                    n,
                    o = [],
                    s = [],
                    a = [],
                    h = [],
                    l = i.width || 1,
                    c = i.height || 1,
                    u = i.subdivisions || 1;
                for (r = 0; u >= r; r++)
                    for (n = 0; u >= n; n++) {
                        var f = new e.Vector3((n * l) / u - l / 2, 0, ((u - r) * c) / u - c / 2),
                            d = new e.Vector3(0, 1, 0);
                        s.push(f.x, f.y, f.z), a.push(d.x, d.y, d.z), h.push(n / u, 1 - r / u);
                    }
                for (r = 0; u > r; r++)
                    for (n = 0; u > n; n++) o.push(n + 1 + (r + 1) * (u + 1)), o.push(n + 1 + r * (u + 1)), o.push(n + r * (u + 1)), o.push(n + (r + 1) * (u + 1)), o.push(n + 1 + (r + 1) * (u + 1)), o.push(n + r * (u + 1));
                var p = new t();
                return (p.indices = o), (p.positions = s), (p.normals = a), (p.uvs = h), p;
            }),
            (t.CreateTiledGround = function (i, r, n, o, s, a) {
                function h(t, i, r, n) {
                    var o = p.length / 3,
                        s = a.w + 1;
                    for (l = 0; l < a.h; l++)
                        for (c = 0; c < a.w; c++) {
                            var h = [o + c + l * s, o + (c + 1) + l * s, o + (c + 1) + (l + 1) * s, o + c + (l + 1) * s];
                            d.push(h[1]), d.push(h[2]), d.push(h[3]), d.push(h[0]), d.push(h[1]), d.push(h[3]);
                        }
                    var u = e.Vector3.Zero(),
                        f = new e.Vector3(0, 1, 0);
                    for (l = 0; l <= a.h; l++) for (u.z = (l * (n - i)) / a.h + i, c = 0; c <= a.w; c++) (u.x = (c * (r - t)) / a.w + t), (u.y = 0), p.push(u.x, u.y, u.z), m.push(f.x, f.y, f.z), g.push(c / a.w, l / a.h);
                }
                void 0 === s && (s = { w: 1, h: 1 }), void 0 === a && (a = { w: 1, h: 1 });
                var l,
                    c,
                    u,
                    f,
                    d = [],
                    p = [],
                    m = [],
                    g = [];
                (s.h = s.w < 1 ? 1 : s.h), (s.w = s.w < 1 ? 1 : s.w), (a.w = a.w < 1 ? 1 : a.w), (a.h = a.h < 1 ? 1 : a.h);
                var _ = { w: (n - i) / s.w, h: (o - r) / s.h };
                for (u = 0; u < s.h; u++) for (f = 0; f < s.w; f++) h(i + f * _.w, r + u * _.h, i + (f + 1) * _.w, r + (u + 1) * _.h);
                var v = new t();
                return (v.indices = d), (v.positions = p), (v.normals = m), (v.uvs = g), v;
            }),
            (t.CreateGroundFromHeightMap = function (i, r, n, o, s, a, h, l) {
                var c,
                    u,
                    f = [],
                    d = [],
                    p = [],
                    m = [];
                for (c = 0; n >= c; c++)
                    for (u = 0; n >= u; u++) {
                        var g = new e.Vector3((u * i) / n - i / 2, 0, ((n - c) * r) / n - r / 2),
                            _ = (((g.x + i / 2) / i) * (h - 1)) | 0,
                            v = ((1 - (g.z + r / 2) / r) * (l - 1)) | 0,
                            y = 4 * (_ + v * h),
                            x = a[y] / 255,
                            M = a[y + 1] / 255,
                            S = a[y + 2] / 255,
                            b = 0.3 * x + 0.59 * M + 0.11 * S;
                        (g.y = o + (s - o) * b), d.push(g.x, g.y, g.z), p.push(0, 0, 0), m.push(u / n, 1 - c / n);
                    }
                for (c = 0; n > c; c++)
                    for (u = 0; n > u; u++) f.push(u + 1 + (c + 1) * (n + 1)), f.push(u + 1 + c * (n + 1)), f.push(u + c * (n + 1)), f.push(u + (c + 1) * (n + 1)), f.push(u + 1 + (c + 1) * (n + 1)), f.push(u + c * (n + 1));
                t.ComputeNormals(d, f, p);
                var A = new t();
                return (A.indices = f), (A.positions = d), (A.normals = p), (A.uvs = m), A;
            }),
            (t.CreatePlane = function (i) {
                var r = [],
                    n = [],
                    o = [],
                    s = [],
                    a = i.width || i.size || 1,
                    h = i.height || i.size || 1,
                    l = 0 === i.sideOrientation ? 0 : i.sideOrientation || e.Mesh.DEFAULTSIDE,
                    c = a / 2,
                    u = h / 2;
                n.push(-c, -u, 0),
                    o.push(0, 0, -1),
                    s.push(0, 0),
                    n.push(c, -u, 0),
                    o.push(0, 0, -1),
                    s.push(1, 0),
                    n.push(c, u, 0),
                    o.push(0, 0, -1),
                    s.push(1, 1),
                    n.push(-c, u, 0),
                    o.push(0, 0, -1),
                    s.push(0, 1),
                    r.push(0),
                    r.push(1),
                    r.push(2),
                    r.push(0),
                    r.push(2),
                    r.push(3),
                    t._ComputeSides(l, n, r, o, s);
                var f = new t();
                return (f.indices = r), (f.positions = n), (f.normals = o), (f.uvs = s), f;
            }),
            (t.CreateDisc = function (i, r, n) {
                void 0 === n && (n = e.Mesh.DEFAULTSIDE);
                var o = [],
                    s = [],
                    a = [],
                    h = [];
                o.push(0, 0, 0), h.push(0.5, 0.5);
                for (var l = (2 * Math.PI) / r, c = 0; c < 2 * Math.PI; c += l) {
                    var u = Math.cos(c),
                        f = Math.sin(c),
                        d = (u + 1) / 2,
                        p = (1 - f) / 2;
                    o.push(i * u, i * f, 0), h.push(d, p);
                }
                o.push(o[3], o[4], o[5]), h.push(h[2], h[3]);
                for (var m = o.length / 3, g = 1; m - 1 > g; g++) s.push(g + 1, 0, g);
                t.ComputeNormals(o, s, a), t._ComputeSides(n, o, s, a, h);
                var _ = new t();
                return (_.indices = s), (_.positions = o), (_.normals = a), (_.uvs = h), _;
            }),
            (t.CreateTorusKnot = function (i) {
                var r,
                    n,
                    o = [],
                    s = [],
                    a = [],
                    h = [],
                    l = i.radius || 2,
                    c = i.tube || 0.5,
                    u = i.radialSegments || 32,
                    f = i.tubularSegments || 32,
                    d = i.p || 2,
                    p = i.q || 3,
                    m = 0 === i.sideOrientation ? 0 : i.sideOrientation || e.Mesh.DEFAULTSIDE,
                    g = function (t) {
                        var i = Math.cos(t),
                            r = Math.sin(t),
                            n = (p / d) * t,
                            o = Math.cos(n),
                            s = l * (2 + o) * 0.5 * i,
                            a = l * (2 + o) * r * 0.5,
                            h = l * Math.sin(n) * 0.5;
                        return new e.Vector3(s, a, h);
                    };
                for (r = 0; u >= r; r++) {
                    var _ = r % u,
                        v = (_ / u) * 2 * d * Math.PI,
                        y = g(v),
                        x = g(v + 0.01),
                        M = x.subtract(y),
                        S = x.add(y),
                        b = e.Vector3.Cross(M, S);
                    for (S = e.Vector3.Cross(b, M), b.normalize(), S.normalize(), n = 0; f > n; n++) {
                        var A = n % f,
                            T = (A / f) * 2 * Math.PI,
                            E = -c * Math.cos(T),
                            P = c * Math.sin(T);
                        s.push(y.x + E * S.x + P * b.x), s.push(y.y + E * S.y + P * b.y), s.push(y.z + E * S.z + P * b.z), h.push(r / u), h.push(n / f);
                    }
                }
                for (r = 0; u > r; r++)
                    for (n = 0; f > n; n++) {
                        var D = (n + 1) % f,
                            C = r * f + n,
                            I = (r + 1) * f + n,
                            w = (r + 1) * f + D,
                            R = r * f + D;
                        o.push(R), o.push(I), o.push(C), o.push(R), o.push(w), o.push(I);
                    }
                t.ComputeNormals(s, o, a), t._ComputeSides(m, s, o, a, h);
                var L = new t();
                return (L.indices = o), (L.positions = s), (L.normals = a), (L.uvs = h), L;
            }),
            (t.ComputeNormals = function (t, i, r) {
                var n = 0,
                    o = e.Vector3.Zero(),
                    s = e.Vector3.Zero(),
                    a = e.Vector3.Zero(),
                    h = e.Vector3.Zero();
                for (n = 0; n < t.length; n++) r[n] = 0;
                var l = i.length / 3;
                for (n = 0; l > n; n++) {
                    var c = i[3 * n],
                        u = i[3 * n + 1],
                        f = i[3 * n + 2];
                    (o.x = t[3 * c] - t[3 * u]),
                        (o.y = t[3 * c + 1] - t[3 * u + 1]),
                        (o.z = t[3 * c + 2] - t[3 * u + 2]),
                        (s.x = t[3 * f] - t[3 * u]),
                        (s.y = t[3 * f + 1] - t[3 * u + 1]),
                        (s.z = t[3 * f + 2] - t[3 * u + 2]),
                        e.Vector3.CrossToRef(o, s, a),
                        a.normalize(),
                        (r[3 * c] += a.x),
                        (r[3 * c + 1] += a.y),
                        (r[3 * c + 2] += a.z),
                        (r[3 * u] += a.x),
                        (r[3 * u + 1] += a.y),
                        (r[3 * u + 2] += a.z),
                        (r[3 * f] += a.x),
                        (r[3 * f + 1] += a.y),
                        (r[3 * f + 2] += a.z);
                }
                for (n = 0; n < r.length / 3; n++) e.Vector3.FromFloatsToRef(r[3 * n], r[3 * n + 1], r[3 * n + 2], h), h.normalize(), (r[3 * n] = h.x), (r[3 * n + 1] = h.y), (r[3 * n + 2] = h.z);
            }),
            (t._ComputeSides = function (t, i, r, n, o) {
                var s,
                    a,
                    h = r.length,
                    l = n.length;
                switch ((t = t || e.Mesh.DEFAULTSIDE)) {
                    case e.Mesh.FRONTSIDE:
                        break;
                    case e.Mesh.BACKSIDE:
                        var c;
                        for (s = 0; h > s; s += 3) (c = r[s]), (r[s] = r[s + 2]), (r[s + 2] = c);
                        for (a = 0; l > a; a++) n[a] = -n[a];
                        break;
                    case e.Mesh.DOUBLESIDE:
                        for (var u = i.length, f = u / 3, d = 0; u > d; d++) i[u + d] = i[d];
                        for (s = 0; h > s; s += 3) (r[s + h] = r[s + 2] + f), (r[s + 1 + h] = r[s + 1] + f), (r[s + 2 + h] = r[s] + f);
                        for (a = 0; l > a; a++) n[l + a] = -n[a];
                        for (var p = o.length, m = 0; p > m; m++) o[m + p] = o[m];
                }
            }),
            t
        );
    })();
    e.VertexData = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i, r, n, o, s) {
            e.call(this, t, "anaglyph", null, ["leftSampler"], i, r, n, o, s);
        }
        return __extends(t, e), t;
    })(e.PostProcess);
    e.AnaglyphPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t() {}
        return (
            (t.EnableFor = function (e) {
                (e._tags = e._tags || {}),
                    (e.hasTags = function () {
                        return t.HasTags(e);
                    }),
                    (e.addTags = function (i) {
                        return t.AddTagsTo(e, i);
                    }),
                    (e.removeTags = function (i) {
                        return t.RemoveTagsFrom(e, i);
                    }),
                    (e.matchesTagsQuery = function (i) {
                        return t.MatchesQuery(e, i);
                    });
            }),
            (t.DisableFor = function (e) {
                delete e._tags, delete e.hasTags, delete e.addTags, delete e.removeTags, delete e.matchesTagsQuery;
            }),
            (t.HasTags = function (t) {
                return t._tags ? !e.Tools.IsEmpty(t._tags) : !1;
            }),
            (t.GetTags = function (e) {
                return e._tags ? e._tags : null;
            }),
            (t.AddTagsTo = function (e, i) {
                if (i) {
                    var r = i.split(" ");
                    for (var n in r) t._AddTagTo(e, r[n]);
                }
            }),
            (t._AddTagTo = function (e, i) {
                (i = i.trim()), "" !== i && "true" !== i && "false" !== i && (i.match(/[\s]/) || i.match(/^([!]|([|]|[&]){2})/) || (t.EnableFor(e), (e._tags[i] = !0)));
            }),
            (t.RemoveTagsFrom = function (e, i) {
                if (t.HasTags(e)) {
                    var r = i.split(" ");
                    for (var n in r) t._RemoveTagFrom(e, r[n]);
                }
            }),
            (t._RemoveTagFrom = function (e, t) {
                delete e._tags[t];
            }),
            (t.MatchesQuery = function (i, r) {
                return void 0 === r
                    ? !0
                    : "" === r
                    ? t.HasTags(i)
                    : e.Internals.AndOrNotEvaluator.Eval(r, function (e) {
                          return t.HasTags(i) && i._tags[e];
                      });
            }),
            t
        );
    })();
    e.Tags = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t;
    !(function (e) {
        var t = (function () {
            function e() {}
            return (
                (e.Eval = function (t, i) {
                    return (
                        (t = t.match(/\([^\(\)]*\)/g)
                            ? t.replace(/\([^\(\)]*\)/g, function (t) {
                                  return (t = t.slice(1, t.length - 1)), e._HandleParenthesisContent(t, i);
                              })
                            : e._HandleParenthesisContent(t, i)),
                        "true" === t ? !0 : "false" === t ? !1 : e.Eval(t, i)
                    );
                }),
                (e._HandleParenthesisContent = function (t, i) {
                    i =
                        i ||
                        function (e) {
                            return "true" === e ? !0 : !1;
                        };
                    var r,
                        n = t.split("||");
                    for (var o in n) {
                        var s = e._SimplifyNegation(n[o].trim()),
                            a = s.split("&&");
                        if (a.length > 1)
                            for (var h = 0; h < a.length; ++h) {
                                var l = e._SimplifyNegation(a[h].trim());
                                if (((r = "true" !== l && "false" !== l ? ("!" === l[0] ? !i(l.substring(1)) : i(l)) : "true" === l ? !0 : !1), !r)) {
                                    s = "false";
                                    break;
                                }
                            }
                        if (r || "true" === s) {
                            r = !0;
                            break;
                        }
                        r = "true" !== s && "false" !== s ? ("!" === s[0] ? !i(s.substring(1)) : i(s)) : "true" === s ? !0 : !1;
                    }
                    return r ? "true" : "false";
                }),
                (e._SimplifyNegation = function (e) {
                    return (
                        (e = e.replace(/^[\s!]+/, function (e) {
                            return (
                                (e = e.replace(/[\s]/g, function () {
                                    return "";
                                })),
                                e.length % 2 ? "!" : ""
                            );
                        })),
                        (e = e.trim()),
                        "!true" === e ? (e = "false") : "!false" === e && (e = "true"),
                        e
                    );
                }),
                e
            );
        })();
        e.AndOrNotEvaluator = t;
    })((t = e.Internals || (e.Internals = {})));
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t, i, r, n, o, s) {
            (this._enabled = !0),
                (this._refCount = 0),
                (this._name = i),
                (this._renderTexture = new e.RenderTargetTexture(i, r, t)),
                this.setRenderList(n),
                (this._renderTexture.onBeforeRender = o),
                (this._renderTexture.onAfterRender = s),
                (this._scene = t),
                (this._renderList = n);
        }
        return (
            (t.prototype._incRefCount = function () {
                return 0 === this._refCount && this._scene.customRenderTargets.push(this._renderTexture), ++this._refCount;
            }),
            (t.prototype._decRefCount = function () {
                return this._refCount--, this._refCount <= 0 && this._scene.customRenderTargets.splice(this._scene.customRenderTargets.indexOf(this._renderTexture), 1), this._refCount;
            }),
            (t.prototype._update = function () {
                this.setRenderList(this._renderList);
            }),
            (t.prototype.setRenderList = function (e) {
                this._renderTexture.renderList = e;
            }),
            (t.prototype.getRenderTexture = function () {
                return this._renderTexture;
            }),
            t
        );
    })();
    e.PostProcessRenderPass = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, t, i, r) {
            (this._engine = e),
                (this._name = t),
                (this._singleInstance = r || !0),
                (this._getPostProcess = i),
                (this._cameras = []),
                (this._indicesForCamera = []),
                (this._postProcesses = {}),
                (this._renderPasses = {}),
                (this._renderEffectAsPasses = {});
        }
        return (
            (t.prototype._update = function () {
                for (var e in this._renderPasses) this._renderPasses[e]._update();
            }),
            (t.prototype.addPass = function (e) {
                (this._renderPasses[e._name] = e), this._linkParameters();
            }),
            (t.prototype.removePass = function (e) {
                delete this._renderPasses[e._name], this._linkParameters();
            }),
            (t.prototype.addRenderEffectAsPass = function (e) {
                (this._renderEffectAsPasses[e._name] = e), this._linkParameters();
            }),
            (t.prototype.getPass = function (e) {
                for (var t in this._renderPasses) if (t === e) return this._renderPasses[e];
            }),
            (t.prototype.emptyPasses = function () {
                (this._renderPasses = {}), this._linkParameters();
            }),
            (t.prototype._attachCameras = function (t) {
                for (var i, r = e.Tools.MakeArray(t || this._cameras), n = 0; n < r.length; n++) {
                    var o = r[n],
                        s = o.name;
                    (i = this._singleInstance ? 0 : s), (this._postProcesses[i] = this._postProcesses[i] || this._getPostProcess());
                    var a = o.attachPostProcess(this._postProcesses[i]);
                    this._indicesForCamera[s] || (this._indicesForCamera[s] = []), this._indicesForCamera[s].push(a), -1 === this._cameras.indexOf(o) && (this._cameras[s] = o);
                    for (var h in this._renderPasses) this._renderPasses[h]._incRefCount();
                }
                this._linkParameters();
            }),
            (t.prototype._detachCameras = function (t) {
                for (var i = e.Tools.MakeArray(t || this._cameras), r = 0; r < i.length; r++) {
                    var n = i[r],
                        o = n.name;
                    n.detachPostProcess(this._postProcesses[this._singleInstance ? 0 : o], this._indicesForCamera[o]);
                    var s = this._cameras.indexOf(o);
                    this._indicesForCamera.splice(s, 1), this._cameras.splice(s, 1);
                    for (var a in this._renderPasses) this._renderPasses[a]._decRefCount();
                }
            }),
            (t.prototype._enable = function (t) {
                for (var i = e.Tools.MakeArray(t || this._cameras), r = 0; r < i.length; r++) {
                    for (var n = i[r], o = n.name, s = 0; s < this._indicesForCamera[o].length; s++)
                        void 0 === n._postProcesses[this._indicesForCamera[o][s]] && t[r].attachPostProcess(this._postProcesses[this._singleInstance ? 0 : o], this._indicesForCamera[o][s]);
                    for (var a in this._renderPasses) this._renderPasses[a]._incRefCount();
                }
            }),
            (t.prototype._disable = function (t) {
                for (var i = e.Tools.MakeArray(t || this._cameras), r = 0; r < i.length; r++) {
                    var n = i[r],
                        o = n.Name;
                    n.detachPostProcess(this._postProcesses[this._singleInstance ? 0 : o], this._indicesForCamera[o]);
                    for (var s in this._renderPasses) this._renderPasses[s]._decRefCount();
                }
            }),
            (t.prototype.getPostProcess = function (e) {
                return this._singleInstance ? this._postProcesses[0] : this._postProcesses[e.name];
            }),
            (t.prototype._linkParameters = function () {
                var e = this;
                for (var t in this._postProcesses)
                    this.applyParameters && this.applyParameters(this._postProcesses[t]),
                        (this._postProcesses[t].onBeforeRender = function (t) {
                            e._linkTextures(t);
                        });
            }),
            (t.prototype._linkTextures = function (e) {
                for (var t in this._renderPasses) e.setTexture(t, this._renderPasses[t].getRenderTexture());
                for (var i in this._renderEffectAsPasses) e.setTextureFromPostProcess(i + "Sampler", this._renderEffectAsPasses[i].getPostProcess());
            }),
            t
        );
    })();
    e.PostProcessRenderEffect = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(e, t) {
            (this._engine = e), (this._name = t), (this._renderEffects = {}), (this._renderEffectsForIsolatedPass = {}), (this._cameras = []);
        }
        return (
            (t.prototype.addEffect = function (e) {
                this._renderEffects[e._name] = e;
            }),
            (t.prototype._enableEffect = function (t, i) {
                var r = this._renderEffects[t];
                r && r._enable(e.Tools.MakeArray(i || this._cameras));
            }),
            (t.prototype._disableEffect = function (t, i) {
                var r = this._renderEffects[t];
                r && r._disable(e.Tools.MakeArray(i || this._cameras));
            }),
            (t.prototype._attachCameras = function (t, i) {
                for (var r = e.Tools.MakeArray(t || this._cameras), n = [], o = 0; o < r.length; o++) {
                    var s = r[o],
                        a = s.name;
                    -1 === this._cameras.indexOf(s) ? (this._cameras[a] = s) : i && n.push(o);
                }
                for (var o = 0; o < n.length; o++) t.splice(n[o], 1);
                for (var h in this._renderEffects) this._renderEffects[h]._attachCameras(r);
            }),
            (t.prototype._detachCameras = function (t) {
                var i = e.Tools.MakeArray(t || this._cameras);
                for (var r in this._renderEffects) this._renderEffects[r]._detachCameras(i);
                for (var n = 0; n < i.length; n++) this._cameras.splice(this._cameras.indexOf(i[n]), 1);
            }),
            (t.prototype._enableDisplayOnlyPass = function (i, r) {
                var n = this,
                    o = e.Tools.MakeArray(r || this._cameras),
                    s = null;
                for (var a in this._renderEffects) if (((s = this._renderEffects[a].getPass(i)), null != s)) break;
                if (null !== s) {
                    for (var a in this._renderEffects) this._renderEffects[a]._disable(o);
                    s._name = t.PASS_SAMPLER_NAME;
                    for (var h = 0; h < o.length; h++) {
                        var l = o[h],
                            c = l.name;
                        (this._renderEffectsForIsolatedPass[c] =
                            this._renderEffectsForIsolatedPass[c] ||
                            new e.PostProcessRenderEffect(this._engine, t.PASS_EFFECT_NAME, function () {
                                return new e.DisplayPassPostProcess(t.PASS_EFFECT_NAME, 1, null, null, n._engine, !0);
                            })),
                            this._renderEffectsForIsolatedPass[c].emptyPasses(),
                            this._renderEffectsForIsolatedPass[c].addPass(s),
                            this._renderEffectsForIsolatedPass[c]._attachCameras(l);
                    }
                }
            }),
            (t.prototype._disableDisplayOnlyPass = function (i) {
                for (var r = this, n = e.Tools.MakeArray(i || this._cameras), o = 0; o < n.length; o++) {
                    var s = n[o],
                        a = s.name;
                    (this._renderEffectsForIsolatedPass[a] =
                        this._renderEffectsForIsolatedPass[a] ||
                        new e.PostProcessRenderEffect(this._engine, t.PASS_EFFECT_NAME, function () {
                            return new e.DisplayPassPostProcess(t.PASS_EFFECT_NAME, 1, null, null, r._engine, !0);
                        })),
                        this._renderEffectsForIsolatedPass[a]._disable(s);
                }
                for (var h in this._renderEffects) this._renderEffects[h]._enable(n);
            }),
            (t.prototype._update = function () {
                for (var e in this._renderEffects) this._renderEffects[e]._update();
                for (var t = 0; t < this._cameras.length; t++) {
                    var i = this._cameras[t].name;
                    this._renderEffectsForIsolatedPass[i] && this._renderEffectsForIsolatedPass[i]._update();
                }
            }),
            (t.PASS_EFFECT_NAME = "passEffect"),
            (t.PASS_SAMPLER_NAME = "passSampler"),
            t
        );
    })();
    e.PostProcessRenderPipeline = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function e() {
            this._renderPipelines = {};
        }
        return (
            (e.prototype.addPipeline = function (e) {
                this._renderPipelines[e._name] = e;
            }),
            (e.prototype.attachCamerasToRenderPipeline = function (e, t, i) {
                var r = this._renderPipelines[e];
                r && r._attachCameras(t, i);
            }),
            (e.prototype.detachCamerasFromRenderPipeline = function (e, t) {
                var i = this._renderPipelines[e];
                i && i._detachCameras(t);
            }),
            (e.prototype.enableEffectInPipeline = function (e, t, i) {
                var r = this._renderPipelines[e];
                r && r._enableEffect(t, i);
            }),
            (e.prototype.disableEffectInPipeline = function (e, t, i) {
                var r = this._renderPipelines[e];
                r && r._disableEffect(t, i);
            }),
            (e.prototype.enableDisplayOnlyPassInPipeline = function (e, t, i) {
                var r = this._renderPipelines[e];
                r && r._enableDisplayOnlyPass(t, i);
            }),
            (e.prototype.disableDisplayOnlyPassInPipeline = function (e, t) {
                var i = this._renderPipelines[e];
                i && i._disableDisplayOnlyPass(t);
            }),
            (e.prototype.update = function () {
                for (var e in this._renderPipelines) this._renderPipelines[e]._update();
            }),
            e
        );
    })();
    e.PostProcessRenderPipelineManager = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function (e) {
        function t(t, i, r, n, o, s) {
            e.call(this, t, "displayPass", ["passSampler"], ["passSampler"], i, r, n, o, s);
        }
        return __extends(t, e), t;
    })(e.PostProcess);
    e.DisplayPassPostProcess = t;
})(BABYLON || (BABYLON = {}));
var BABYLON;
!(function (e) {
    var t = (function () {
        function t(t) {
            (this.frontColor = new e.Color3(1, 1, 1)), (this.backColor = new e.Color3(0.1, 0.1, 0.1)), (this.showBackLines = !0), (this.renderList = new e.SmartArray(32)), (this._scene = t);
        }
        return (
            (t.prototype._prepareRessources = function () {
             