#!/usr/bin/env python3
import pandas as pd, math, sys

ref = pd.read_csv("../reports/c2_repeat_1h_1440_summary.csv").iloc[0].to_dict()
new = pd.read_csv("summary.csv").iloc[0].to_dict()

def ok(a,b,eps=1e-9): 
    return abs(float(a)-float(b)) <= eps

checks = {
  "equity_end": ok(new["equity_end"], ref["equity_end"]),
  "trades": int(new["trades"]) == int(ref["trades"]),
  "profit_factor": ok(new["profit_factor"], ref["profit_factor"]),
  "max_drawdown_%": ok(new["max_drawdown_%"], ref["max_drawdown_%"]),
  "win_rate_%": ok(new["win_rate_%"], ref["win_rate_%"]),
}
print("Comparison:", checks)
if not all(checks.values()):
    sys.exit(1)
print("All metrics match exactly.")
