# New pluggable backtest skeleton

New pluggable backtest skeleton (separate strategy module)

Below is a ready-to-paste project layout with all files inlined. Create a folder (e.g. new_branch/) and put the files exactly as listed.

File tree

new_branch/
  backtester_core.py           # main loop (pluggable strategy)
  engine/
    data.py                    # load cache DB, build md_slice (adds dp6h/dp12h/qv_24h)
    portfolio.py               # portfolio, PnL, CSV outputs
  strategies/
    base.py                    # StrategyBase API (universe, rank, entry, manage)
    alpha_v0.py                # your new strategy (clean slate)
  configs/
    alpha_v0.yaml              # config (strategy+portfolio+session)
  scripts/
    run_alpha_500.sh           # quick 500-bar smoke test
    run_alpha_60d.sh           # full run (per cache range)
  README_NEW_STRAT.md          # mini docs

## Layout
- `backtester_core.py` — main loop
- `engine/` — data & portfolio
- `strategies/` — base API + your strategy (`alpha_v0.py`)
- `configs/alpha_v0.yaml` — all params
- `scripts/*.sh` — run helpers

## Run
```bash
bash scripts/run_alpha_500.sh   # 500-bar smoke test
bash scripts/run_alpha_60d.sh   # full range per cache

Outputs: trades.csv, summary.csv

Extend

Add strategies/my_strat.py with class MyStrat(StrategyBase)

Update strategy_class in YAML

Implement entry_signal() and manage_position()