# OBW Backtesting Project (C2 repeat)

This archive contains the project code, strategies, configs, and run results
for the Cross-Sectional RS (C2) strategy tested on 1h / 60d (1440 bars).

## Important
- **Database is NOT included** to keep the archive small.
- Place your DB file (e.g. `combined_cache_1440.db`) **one level above** the project folder
  when you unzip, or edit `cache_db` in YAML to point to an absolute path.

## Strategy & Config used for the successful run
- Strategy file: `strategies/cross_sectional_rs.py` (your uploaded version)
- Config used: `configs/c2_repeat_1h_1440.yaml`

### Parameters
```
top_n: 4
side: LONG
min_momentum_sum: 0.12
min_atr_ratio: 0.022
min_vol_surge_mult: 1.25
min_breadth: 0.60
sl_atr_mult: 1.4
tp_atr_mult: 2.6
max_hold_hours: 96
max_mae_atr_mult: 1.6
mom_flip_thresh: 0.02
trail_start_atr: 1.2
trail_dist_atr: 1.0
min_qv_24h: 200000
min_qv_1h: 10000
```

## How to run
From the parent folder (so the DB is visible as `../combined_cache_1440.db`):
```bash
python3 -m obw_platform.backtester_core --cfg obw_platform/configs/c2_repeat_1h_1440.yaml
```

Or adjust `cache_db` in YAML to an absolute path.

## Outputs included
- `reports/c2_repeat_1h_1440_trades.csv`
- `reports/c2_repeat_1h_1440_summary.csv`
- `reports/c2_repeat_1h_1440_equity.png`

Generated at: 2025-08-10T21:09:29.102603Z
