# README_TF — різниця таймфреймів і запуск

Цей пакет містить альтернативні конфіги для тих самих параметрів C2 (LONG), але на інших кешах (2h/4h/8h).
**Увага:** БД у пакеті немає — покладіть їх на рівень вище `backtest_SK/`:

```
obw_c2_repro_pack_nodb/
  combined_cache_1440.db         # 1h (~60d) [опціонально]
  combined_cache_1440_2h.db      # 2h (~120d)
  combined_cache_1440_4h.db      # 4h (~240d)
  combined_cache_1440_8h.db      # 8h (~480d)
  backtest_SK/
    ...
```

## Підтримувані години відкриття (Kyiv)
Ці кеші мають бари лише у певні години (кратні таймфрейму). Тому `open_hour_kyiv` у YAML має співпадати з доступними годинами:
- **2h:** Kyiv ∈ {1,3,5,7,9,11,13,15,17,19,21,23}
- **4h:** Kyiv ∈ {3,7,11,15,19,23}
- **8h:** Kyiv ∈ {3,11,19}

У доданих конфігах використано **`open_hour_kyiv: 3`** (універсально підходить для 2h/4h/8h). За потреби змініть.

## Команди запуску (приклади, 1440 барів)
```bash
cd backtest_SK
# 2h (~120d):
python3 backtester_core.py --cfg configs/cs_C2_2h.yaml --limit-bars 1440
# 4h (~240d):
python3 backtester_core.py --cfg configs/cs_C2_4h.yaml --limit-bars 1440
# 8h (~480d):
python3 backtester_core.py --cfg configs/cs_C2_8h.yaml --limit-bars 1440
```

## Зауваги до метрик
- Параметри стратегії залишені як у 1h; для кращої адаптації під TF можна
  тюнити `min_atr_ratio`, `min_momentum_sum`, `min_vol_surge_mult`, `min_breadth`,
  або додати грід‑пошук.
- Перевірка сплеску обсягу ґрунтується на середньому за 24 години; для TF>1h це працює коректно,
  але за бажанням можна змінити на середній **на бар**.
