const { Configuration, OpenAIApi } = require('openai');
require('dotenv').config();

const configuration = new Configuration({
    organization: 'org-u45p71RO6MuRVs81loDqIF1q',
    apiKey: process.env.OPENAI_API_KEY,
});

const ai = new OpenAIApi(configuration);
// const response = await ai.listEngines();

const getResponse = async query => {
    const messages = [
        {
            role: 'assistant',
            content: `${query.lang.content} ${query.subject} ${query.lang.topic} ${query.section}. ${query.lang.contentEnd}`,
        },
    ];
    try {
        const response = await ai.createChatCompletion({ model: 'gpt-3.5-turbo', messages });
        const content = response.data.choices[0].message.content;
        // console.log('content: ', content);
        return content;
    } catch (e) {
        console.log('error ChatGPT: ', e);
        return e.message;
    }
};

// const getAnswer = async query => {
//     const messages = [
//         {
//             role: 'assistant',
//             content: `Is the answer: ${query.question} correct for the question or problem: ${query.answer}? Answer only yes or no.`,
//         },
//     ];
//     try {
//         const response = await ai.createChatCompletion({ model: 'gpt-3.5-turbo', messages });
//         const content = response.data.choices[0].message.content;
//         return content;
//     } catch (e) {
//         console.log('error ChatGPT: ', e);
//         return e.message;
//     }
// };

// const getCorrectAnswer = async question => {
//     const messages = [
//         {
//             role: 'assistant',
//             content: `Give an answer to the question or problem:: ${question}. The answer to this problem or question should be one or maximum two words or one number.`,
//         },
//     ];
//     try {
//         const response = await ai.createChatCompletion({ model: 'gpt-3.5-turbo', messages });
//         const content = response.data.choices[0].message.content;
//         return content;
//     } catch (e) {
//         console.log('error ChatGPT: ', e);
//         return e.message;
//     }
// };

module.exports = { getResponse };
