const TelegramApi = require('node-telegram-bot-api');
const { getResponse } = require('./chatGPT');
const { en, ua } = require('./localization');
require('dotenv').config();

const bot = new TelegramApi(process.env.BOT_TOKEN, { polling: true });

const chats = {};
const questions = {};
const branches = {};
const answers = {};
const lang = {};

const subjects = chatId => {
    return {
        reply_markup: JSON.stringify({
            inline_keyboard: [
                [
                    { text: lang[chatId].algebra, callback_data: `1${lang[chatId].algebra}` },
                    { text: lang[chatId].geometry, callback_data: `1${lang[chatId].geometry}` },
                ],

                [
                    { text: lang[chatId].physics, callback_data: `1${lang[chatId].physics}` },
                    { text: lang[chatId].chemistry, callback_data: `1${lang[chatId].chemistry}` },
                ],
                [
                    { text: lang[chatId].biology, callback_data: `1${lang[chatId].biology}` },
                    { text: lang[chatId].history, callback_data: `1${lang[chatId].history}` },
                ],
            ],
        }),
    };
};

const sections = (chatId, subject) => {
    const subjects = {
        Algebra: {
            reply_markup: JSON.stringify({
                inline_keyboard: [
                    [
                        { text: lang[chatId].linearEq, callback_data: `2${lang[chatId].linearEq}` },
                        {
                            text: lang[chatId].trigonomFunc,
                            callback_data: `2${lang[chatId].trigonomFunc}`,
                        },
                    ],
                ],
            }),
        },
        Geometry: {
            reply_markup: JSON.stringify({
                inline_keyboard: [
                    [
                        {
                            text: lang[chatId].pythagorTh,
                            callback_data: `2${lang[chatId].pythagorTh}`,
                        },
                        {
                            text: lang[chatId].coordinates,
                            callback_data: `2${lang[chatId].coordinates}`,
                        },
                    ],
                ],
            }),
        },
        Physics: {
            reply_markup: JSON.stringify({
                inline_keyboard: [
                    [
                        { text: lang[chatId].statics, callback_data: `2${lang[chatId].statics}` },
                        {
                            text: lang[chatId].kinematics,
                            callback_data: `2${lang[chatId].kinematics}`,
                        },
                    ],
                    [{ text: lang[chatId].dynamics, callback_data: `2${lang[chatId].dynamics}` }],
                ],
            }),
        },
        Сhemistry: {
            reply_markup: JSON.stringify({
                inline_keyboard: [
                    [
                        {
                            text: lang[chatId].periodicLaw,
                            callback_data: `2${lang[chatId].periodicLaw}`,
                        },
                        { text: lang[chatId].organic, callback_data: `2${lang[chatId].organic}` },
                    ],
                ],
            }),
        },
        Biology: {
            reply_markup: JSON.stringify({
                inline_keyboard: [
                    [
                        {
                            text: lang[chatId].heredity,
                            callback_data: `2${lang[chatId].heredity}`,
                        },
                        {
                            text: lang[chatId].mutations,
                            callback_data: `2${lang[chatId].mutations}`,
                        },
                    ],
                ],
            }),
        },
        History: {
            reply_markup: JSON.stringify({
                inline_keyboard: [
                    [
                        {
                            text: lang[chatId].enlightenment,
                            callback_data: `2${lang[chatId].enlightenment}`,
                        },
                        { text: lang[chatId].sww, callback_data: `2${lang[chatId].sww}` },
                    ],
                ],
            }),
        },
    };

    let result = subject;
    if (subject === 'Алгебра') result = 'Algebra';
    if (subject === 'Геометрія') result = 'Geometry';
    if (subject === 'Фізика') result = 'Physics';
    if (subject === 'Хімія') result = 'Сhemistry';
    if (subject === 'Біологія') result = 'Biology';
    if (subject === 'Історія') result = 'History';

    // console.log('result: ', result);
    // console.log('subject: ', subject);
    // console.log('subjects[result]: ', subjects[result]);
    return subjects[result];
};

const newTask = chatId => {
    return {
        reply_markup: JSON.stringify({
            inline_keyboard: [
                [
                    { text: lang[chatId].anotherQuest, callback_data: '3Next' },
                    { text: lang[chatId].anotherSubj, callback_data: '3NewSubject' },
                ],
            ],
        }),
    };
};

const newTray = chatId => {
    return {
        reply_markup: JSON.stringify({
            inline_keyboard: [
                [
                    { text: lang[chatId].tryAgain, callback_data: '3Try' },
                    { text: lang[chatId].findCorrectAnswer, callback_data: '3Correct' },
                ],
            ],
        }),
    };
};

localization = {
    reply_markup: JSON.stringify({
        inline_keyboard: [
            [
                { text: '🇺🇸/🇬🇧 English', callback_data: 'langEN' },
                { text: '🇺🇦 Українська', callback_data: 'langUA' },
            ],
        ],
    }),
};

const welcome = async msg => {
    // console.log('msg: ', msg);
    const chatId = msg.chat.id;
    const name = msg.chat.first_name || '';
    const lastName = msg.chat.last_name || '';

    return await bot.sendMessage(
        chatId,
        `${lang[chatId].welcome} ${name} ${lastName}! ${lang[chatId].today}`,
        subjects(chatId)
    );
};

const start = async () => {
    bot.on('message', async msg => {
        const text = msg.text;
        const chatId = msg.chat.id;

        try {
            if (text === '/start') {
                return await bot.sendMessage(
                    chatId,
                    `Please choose a language. / Будь ласка оберіть мову`,
                    localization
                );
            }

            if (questions[chatId]) {
                if (text.trim().toLowerCase() === answers[chatId].toLowerCase()) {
                    const answer = answers[chatId];
                    reset(chatId);
                    return await bot.sendMessage(
                        chatId,
                        `${lang[chatId].right} ${answer}`,
                        newTask(chatId)
                    );
                } else
                    return await bot.sendMessage(
                        chatId,
                        `${lang[chatId].wrong} "${text}" ${lang[chatId].notCorrect}`,
                        newTray(chatId)
                    );
            }
            if (lang[chatId]) return bot.sendMessage(chatId, lang[chatId].today, subjects(chatId));
            else
                return await bot.sendMessage(
                    chatId,
                    `Please choose a language. / Будь ласка оберіть мову`,
                    localization
                );
        } catch (e) {
            console.log('e: ', e.message);
            reset(chatId);
            bot.sendMessage(chatId, lang[chatId].error);
            return await welcome(msg);
        }
    });

    bot.on('callback_query', async msg => {
        const data = msg.data;
        const chatId = msg.message.chat.id;

        if (data.startsWith('lang')) {
            if (data === 'langEN') lang[chatId] = en;
            else lang[chatId] = ua;

            return await welcome(msg.message);
        }
        if (!lang[chatId])
            return await bot.sendMessage(
                chatId,
                `Please choose a language. / Будь ласка оберіть мову`,
                localization
            );

        if (data.startsWith('1')) {
            const subject = data.slice(1);
            chats[chatId] = subject;
            // console.log('lang[chatId]: ', lang[chatId]);
            await bot.sendMessage(
                chatId,
                `${lang[chatId].whichSection} ${subject} ${lang[chatId].interested}`,
                sections(chatId, subject)
            );
        }
        if (data.startsWith('2')) {
            const section = data.slice(1);
            branches[chatId] = section;
            await bot.sendMessage(
                chatId,
                `${lang[chatId].exercise} ${chats[chatId]} ${lang[chatId].topic} ${section}`
            );
            const task = await getResponse({ subject: chats[chatId], section, lang: lang[chatId] });
            console.log('task: ', task);
            const question = task.slice(0, task.indexOf('[['));
            const answer = task.slice(task.indexOf('[[') + 2, -2);
            questions[chatId] = question;
            answers[chatId] = answer;
            await bot.sendMessage(chatId, question);
        }

        if (data === '3Next') {
            await bot.sendMessage(
                chatId,
                `${lang[chatId].exercise} ${chats[chatId]} ${lang[chatId].topic} ${branches[chatId]}`
            );
            const task = await getResponse({
                subject: chats[chatId],
                section: branches[chatId],
                lang: lang[chatId],
            });
            console.log('task: ', task);
            const question = task.slice(0, task.indexOf('[['));
            const answer = task.slice(task.indexOf('[[') + 2, -2);
            questions[chatId] = question;
            answers[chatId] = answer;
            await bot.sendMessage(chatId, question);
        }

        if (data === '3NewSubject') {
            return await bot.sendMessage(chatId, lang[chatId].chooseSub, subjects(chatId));
        }

        if (data === '3Try') {
            return await bot.sendMessage(chatId, lang[chatId].writeAnswer);
        }

        if (data === '3Correct') {
            const answer = answers[chatId];
            reset(chatId);
            await bot.sendMessage(
                chatId,
                `${lang[chatId].correctAnswer} ${answer}`,
                newTask(chatId)
            );
        }
    });
};

start();

function reset(id) {
    delete answers[id];
    delete questions[id];
}
