const mongoose = require('mongoose');
const app = require('./app');

const https = require('https');
const fs = require('fs');

// const options = {
//     cert: fs.readFileSync('/etc/letsencrypt/live/vps2.happyuser.info/fullchain.pem'),
//     key: fs.readFileSync('/etc/letsencrypt/live/vps2.happyuser.info/privkey.pem'),
// };

const options = {
    cert: fs.readFileSync('/etc/letsencrypt/live/renderserver.happyuser.info/fullchain.pem'),
    key: fs.readFileSync('/etc/letsencrypt/live/renderserver.happyuser.info/privkey.pem'),
};

const server = https.createServer(options, app);
// const server = app;

const { DB_HOST, PORT = 4000 } = process.env;

mongoose.set('strictQuery', false);
mongoose
    .connect(DB_HOST)
    .then(() => {
        console.log('Database connection successful');
        server.listen(PORT, () => {
            console.log(`Server running. Use our API on port: ${PORT}`);
        });
    })
    .catch(error => {
        console.log(error.message);
        process.exit(1);
    });
