const express = require('express');
const { User } = require('../../models/user');
const { ctrlWrapper, paypal } = require('../../helpers');

const router = express.Router();

router.post('/activate', ctrlWrapper(activatePlan));

async function activatePlan(req, res) {
    const { event_type, plan_id, resource } = req.body;
    console.log('event_type: ', event_type);

    if (event_type === 'PAYMENT.SALE.COMPLETED') {
        const email = resource.custom;
        const user = await User.findOne({ email });

        if (user) {
            const newSubscription = resource.billing_agreement_id;
            const { day, plan_id } = await paypal.getInfo(newSubscription);
            console.log('day: ', day);
            let nextPayDay;
            if (day) nextPayDay = new Date(day);
            else {
                nextPayDay = new Date(user.nextPayDay);
                nextPayDay.setDate(nextPayDay.getDate() + 31);
            }

            // const plan = {
            //     basic: 'P-07R859561S031722VMUAWA5Y',
            //     basic14: 'P-9Y493700K0857335UMUADK5Y', //has free trial
            //     // enterprice: 'P-3XS4801330882222PMUAEW3I',
            //     enterprice: 'P-5RN91923AL8155529MUEVDQQ',
            // };   //sandbox

            const plan = {
                basic: 'P-1KD769117E528273XMUFNYDI',
                // basic14: 'P-8WM48351LR382992RMT3V7CA', //has free trial,
                enterprice: 'P-5GN17812N3892143KMT3WAFI',
            };

            const pricingPlan = plan_id === plan.enterprice ? 'Enterprice' : 'Basic';

            await User.findByIdAndUpdate(user._id, { nextPayDay, pricingPlan });
        }
    }
    res.sendStatus(200); //     res.status(200).send();
}

module.exports = router;
