const { Schema, model } = require('mongoose');
const { handleSaveError } = require('../helpers');
const Joi = require('joi');

const emailRegexp = /^[a-z0-9\._-]+@[a-z]+\.[a-z]{2,3}$/;
const pricingPlans = ['None', 'Starter', 'Basic', 'Enterprice'];

const userSchema = Schema(
    {
        name: {
            type: String,
            required: [true, 'Name is required'],
        },

        lastName: {
            type: String,
            required: [true, 'Last name is required'],
        },
        password: {
            type: String,
            required: [true, 'Password is required'],
        },
        email: {
            type: String,
            required: [true, 'Email is required'],
            unique: true,
            match: emailRegexp,
        },
        pricingPlan: {
            type: String,
            enum: pricingPlans,
            default: 'Starter',
        },

        subscriptionId: {
            type: String,
            default: '',
        },

        nextPayDay: {
            type: Date,
            default: new Date(2023, 0, 1),
        },

        favorite: {
            type: [String],
            default: [],
        },

        verify: {
            type: Boolean,
            default: false,
        },

        emailVerified: {
            type: Boolean,
            default: false,
        },

        banned: {
            type: Boolean,
            default: false,
        },

        passKey: {
            type: String,
            default: null,
        },

        role: {
            type: String,
            default: 'user',
        },

        // hasTrial: {
        //     type: Boolean,
        //     default: true,
        // },

        accessToken: {
            type: String,
            default: null,
        },
        refreshToken: {
            type: String,
            default: null,
        },
        subscribeToken: {
            type: String,
            default: null,
        },
        verificationToken: {
            type: String,
            default: null,
        },
    },

    { versionKey: false, timestamps: true }
);

userSchema.post('save', handleSaveError);

const signin = Joi.object({
    email: Joi.string().required(),
    password: Joi.string().required(),
});

const signup = Joi.object({
    name: Joi.string().required(),
    lastName: Joi.string().required(),
    email: Joi.string().pattern(emailRegexp).required(),
    password: Joi.string().min(6).required(),
});

const refresh = Joi.object({
    refreshToken: Joi.string().required(),
});

const resend = Joi.object({
    email: Joi.string().pattern(emailRegexp).required(),
});

const reset = Joi.object({
    email: Joi.string().pattern(emailRegexp).required(),
    password: Joi.string().min(6).required(),
});

// const pricingPlan = Joi.object({
//     pricingPlan: Joi.string()
//         .valid(...pricingPlans)
//         .required(),
// });
const pricingPlan = Joi.object({
    subscriptionId: Joi.string().required(),
    plan_id: Joi.string().required(),
});

const favorite = Joi.object({
    id: Joi.string().required(),
});
const update = Joi.object({
    name: Joi.string().required(),
    lastName: Joi.string().required(),
});

const schemas = { signin, signup, refresh, resend, reset, pricingPlan, favorite, update };

const User = model('user', userSchema);
module.exports = { User, schemas };
