const { Schema, model } = require('mongoose');
const Joi = require('joi');
const { handleSaveError } = require('../helpers');

const textureSchema = new Schema(
    {
        img: {
            type: String,
            required: true,
        },
        name: {
            type: String,
            required: true,
        },
        width: {
            type: Number,
            required: true,
        },
        height: {
            type: Number,
            required: true,
        },
        type: {
            type: String,
            enum: ['tile', 'carpet', 'stone'],
            required: true,
        },
        // favorite: { type: Boolean, default: false, required: true },
        // origin: {
        //     type: String,
        //     enum: ['catalog', 'uploads'],
        //     required: true,
        // },
        owner: {
            type: Schema.Types.ObjectId,
            ref: 'user',
            required: true,
        },
    },
    { versionKey: false, timestamps: true }
);

textureSchema.post('save', handleSaveError);

const add = Joi.object({
    img: Joi.string(),
    name: Joi.string().required(),
    type: Joi.string().valid('tile', 'carpet', 'stone').required(),
    width: Joi.number().min(1).max(10000).required(),
    height: Joi.number().min(1).max(10000).required(),
    // favorite: Joi.boolean(),
});

// const favorite = Joi.object({
//     favorite: Joi.bool().required(),
// });

const schemas = { add };

const Texture = model('texture', textureSchema);

module.exports = { Texture, schemas };
