const { Schema, model } = require('mongoose');
const Joi = require('joi');
const { handleSaveError } = require('../helpers');

const projectSchema = new Schema(
    {
        name: {
            type: String,
            required: true,
        },
        room: {
            type: String,
            required: true,
        },
        img: {
            type: String,
            required: true,
        },
        meshes: {
            type: Object,
            required: true,
        },

        owner: {
            type: Schema.Types.ObjectId,
            ref: 'user',
            required: true,
        },
    },
    { versionKey: false, timestamps: true }
);

projectSchema.post('save', handleSaveError);

const add = Joi.object({
    name: Joi.string().required(),
    room: Joi.string().required(),
    meshes: Joi.any().required(),
});

const update = Joi.object({
    name: Joi.string(),
    room: Joi.string(),
    meshes: Joi.any(),
});

const schemas = { add, update };

const Project = model('project', projectSchema);

module.exports = { Project, schemas };
