const bcrypt = require('bcryptjs');
const { v4: uuid } = require('uuid');
const { Strategy } = require('passport-google-oauth2');
const { User } = require('../../models/user');
const { sendRequestRegistration, RequestError } = require('../../helpers');

require('dotenv').config();

const { GOOGLE_CLIENT_ID, GOOGLE_CLIENT_SECRET, GOOGLE_CALLBACK_URL } = process.env;

const googleParams = {
    clientID: GOOGLE_CLIENT_ID,
    clientSecret: GOOGLE_CLIENT_SECRET,
    callbackURL: GOOGLE_CALLBACK_URL,
    passReqToCallback: true,
};

const googleCallback = async (req, accessToken, refreshToken, profile, done) => {
    try {
        const { email, name } = profile;
        // console.log('profile: ', profile);
        const user = await User.findOne({ email });
        if (user) {
            if (user.banned) throw RequestError(401, 'User has been banned');
            return done(null, user);
        }
        const hashPassword = await bcrypt.hash(uuid(), 10);

        const nextPayDay = new Date();
        nextPayDay.setDate(nextPayDay.getDate() + 14);

        const newUser = await User.create({
            name: name.givenName,
            lastName: name.familyName,
            email,
            password: hashPassword,
            emailVerified: true,
            verify: true,
            nextPayDay,
        });
        // await sendRequestRegistration(newUser);
        return done(null, newUser);
    } catch (error) {
        done(error, false);
    }
};

const googleStrategy = new Strategy(googleParams, googleCallback);

module.exports = googleStrategy;
