const nodemailer = require('nodemailer');

const { google } = require('googleapis');

const OAuth2 = google.auth.OAuth2;

const { GOOGLE_CLIENT_ID, GOOGLE_CLIENT_SECRET, GOOGLE_REFRESH_TOKEN, MAIL_USER } = process.env;

const OAuth2Client = new OAuth2(GOOGLE_CLIENT_ID, GOOGLE_CLIENT_SECRET);
OAuth2Client.setCredentials({ refresh_token: GOOGLE_REFRESH_TOKEN });

const sendMail = async mail => {
    const accessToken = await OAuth2Client.getAccessToken();
    const config = {
        service: 'gmail',
        auth: {
            type: 'OAuth2',
            user: MAIL_USER,
            clientId: GOOGLE_CLIENT_ID,
            clientSecret: GOOGLE_CLIENT_SECRET,
            refreshToken: GOOGLE_REFRESH_TOKEN,
            accessToken: accessToken,
        },
    };

    const transport = nodemailer.createTransport(config);

    transport.sendMail(mail, (err, res) => {
        if (err) console.log('Send mail Error: ', err);
        else console.log('Send mail Success: ', res);
    });
};

// const mailMessage = {
//     to: 'hellreebok@gmail.com.com',
//     subject: 'A Message from Rendersee',
//     html: '<h3> ================Test mail ==================== </h3>',
// };

// sendMail(mailMessage);

// const config = {
//     host: 'smtp.ukr.net',
//     port: 465,
//     secure: true,

//     auth: {
//         user: 'hell_x@ukr.net',
//         pass: process.env.PASSWORD,
//     },
// };

// const transporter = nodemailer.createTransport(config);

// const sendMail = async data => {
//     await transporter.sendMail({ ...data, from: 'hell_x@ukr.net' });
//     return true;
// };

module.exports = sendMail;
