const fetch = require('node-fetch');
const { PAYPAL_CLIENT_ID, PAYPAL_SECRET } = process.env;

// const baseURL = 'https://api-m.sandbox.paypal.com';
const baseURL = 'https://api-m.paypal.com';

// async function generateClientToken(req, res) {
//     const accessToken = await generateAccessToken();
//     console.log('accessToken: ', accessToken);
//     const response = await fetch(`${baseURL}/v1/identity/generate-token`, {
//         method: 'POST',
//         headers: {
//             Authorization: `Bearer ${accessToken}`,
//             'Accept-Language': 'en_US',
//             'Content-Type': 'application/json',
//         },
//     });
//     const data = await response.json();
//     res.status(200).json(data.client_token);

// return data.client_token;
// }

async function generateAccessToken() {
    const auth = Buffer.from(PAYPAL_CLIENT_ID + ':' + PAYPAL_SECRET).toString('base64');

    const response = await fetch(`${baseURL}/v1/oauth2/token`, {
        method: 'POST',
        body: 'grant_type=client_credentials',
        headers: {
            Authorization: `Basic ${auth}`,
            'Content-Type': 'application/json',
            Accept: 'application/json',
        },
    });
    const data = await response.json();
    return data.access_token;
}

async function cancelSubscription(id) {
    console.log('cancel id: ', id);
    const accessToken = await generateAccessToken();
    const response = await fetch(`${baseURL}/v1/billing/subscriptions/${id}/cancel`, {
        method: 'POST',
        headers: {
            Authorization: `Bearer ${accessToken}`,
            'Content-Type': 'application/json',
            Accept: 'application/json',
        },
        body: JSON.stringify({ reason: 'user changed subscription' }),
    });

    // const cancel = await response.json();
    // console.log('cancel: ', cancel);
}

async function getInfo(id) {
    console.log('==info id: ', id);
    const accessToken = await generateAccessToken();
    const response = await fetch(`${baseURL}/v1/billing/subscriptions/${id}`, {
        headers: {
            Authorization: `Bearer ${accessToken}`,
            'Content-Type': 'application/json',
            Accept: 'application/json',
        },
    });

    const info = await response.json();

    console.log('==info: ', info);

    const day = info.billing_info?.next_billing_time || null;

    console.log('day: ', day);

    return { day: info.billing_info.next_billing_time, plan_id: info.plan_id };
}

module.exports = { cancelSubscription, generateAccessToken, getInfo };
