const { Texture } = require('../models/texture');
const { catalogTextures } = require('../catalog/catalogTextures');

const createCatalogTextures = async userId => {
    for (let i = 0; i < catalogTextures.length; i++) {
        await Texture.create({
            name: catalogTextures[i].name,
            width: catalogTextures[i].width,
            height: catalogTextures[i].height,
            type: catalogTextures[i].type,
            img: catalogTextures[i].img,
            origin: 'catalog',
            owner: userId,
        });
    }
};

module.exports = { createCatalogTextures };
