const express = require('express');
const logger = require('morgan');
const cors = require('cors');
require('dotenv').config();

const fetch = require('node-fetch');

const users = require('./routes/api/users.js');
const textures = require('./routes/api/textures.js');
const projects = require('./routes/api/projects.js');
const payments = require('./routes/api/payments.js');

const app = express();

// const formatsLogger = app.get("env") === "development" ? "dev" : "short";

app.use(logger('dev'));
app.use(cors());

app.use(express.json());
app.use(express.static('public'));

app.get('/api/test', (req, res) => {
    res.send('<h1>Test passed</h1>');
});

app.get('/api/getpost', async (req, res) => {
    try {
        const response = await fetch('https://renderserver.happyuser.info/api/post', {
            method: 'POST',
        });

        const data = await response.json();
        res.send(`<h1>${data.message}</h1>`);
    } catch {
        res.send("<h1>POST request DON'T passed</h1>");
    }
});

app.post('/api/post', (req, res) => {
    res.json({ message: 'POST request passed' });
});

app.use('/api/users', users);
app.use('/api/textures', textures);
app.use('/api/projects', projects);
app.use('/api/payments', payments);

app.use((req, res) => {
    res.status(404).json({ message: 'Not found' });
});

app.use((err, req, res, next) => {
    console.log('err: ', err.message);

    res.status(500).json({ message: err.message });
});

module.exports = app;
